/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptor;
import oracle.olapi.syntax.FunctionDescriptorCatalog;
import oracle.olapi.syntax.RowExpression;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RowFunctionExpression
extends RowExpression {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    private RowFunctionExpression(String string, FunctionArgument[] functionArgumentArray, boolean bl) {
        RowFunctionExpression.validateValue(string);
        this.m_FunctionName = string;
        this.m_Arguments = bl ? RowFunctionExpression.getFunctionArgumentArrayClone(functionArgumentArray) : functionArgumentArray;
        this.initialize();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getFunctionName());
        if (this.getArgumentsInternal().length == 0 && this.getFunctionDescriptor().isPseudoColumn()) {
            return;
        }
        Expression.printExpressions(this.getArgumentsInternal(), syntaxPrintingContext);
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        FunctionArgument[] functionArgumentArray = new FunctionArgument[this.getArgumentsInternal().length];
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), functionArgumentArray, null, null, 3, "UnknownRowFunction", validationContext);
        this.m_Arguments = functionArgumentArray;
        validationContext.pop();
        this.setDataType(validationContext.getCurrentDataType());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getArgumentsInternal());
    }

    public RowFunctionExpression(String string, FunctionArgument[] functionArgumentArray) {
        this(string, functionArgumentArray, true);
    }

    public RowFunctionExpression(String string, List<FunctionArgument> list) {
        this(string, RowFunctionExpression.getFunctionArgumentArrayClone(list), false);
    }

    public RowFunctionExpression(String string) {
        this(string, new FunctionArgument[0], false);
    }

    public RowFunctionExpression(String string, FunctionArgument functionArgument) {
        this(string, new FunctionArgument[]{functionArgument}, false);
    }

    public RowFunctionExpression(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2}, false);
    }

    public RowFunctionExpression(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3}, false);
    }

    public RowFunctionExpression(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3, FunctionArgument functionArgument4) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3, functionArgument4}, false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitRowFunctionExpression(this, object);
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }
}

