/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;

public final class SQLDataType
extends SyntaxObject {
    private DataType m_DataType = null;
    private String m_SQLText = null;

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("DATATYPE ");
        syntaxPrintingContext.append(this.getSQLText());
    }

    public SQLDataType(String string, DataType dataType) {
        this.m_SQLText = string;
        this.m_DataType = dataType;
    }

    public SQLDataType(String string) {
        SyntaxObject.validateValue(string);
        this.m_SQLText = string.toUpperCase();
        SQLDataType sQLDataType = SQLDataType.getSQLDataType(this.m_SQLText);
        this.m_DataType = sQLDataType.getDataType();
    }

    public SQLDataType(DataType dataType) {
        this.m_SQLText = dataType.getName();
        this.m_DataType = dataType;
    }

    public static SQLDataType getSQLDataType(String string) {
        try {
            return (SQLDataType)SyntaxObject.fromSyntax("DATATYPE " + string, null);
        }
        catch (Exception exception) {
            throw new SyntaxException("UnknownDataType", string);
        }
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSQLDataType(this, object);
    }

    public DataType getDataType() {
        return this.m_DataType;
    }

    public String getSQLText() {
        return this.m_SQLText;
    }
}

