/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.InvalidMetadataException;
import oracle.olapi.session.UserSession;
import oracle.olapi.transaction.ActiveSubtransactionsException;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.CommitException;
import oracle.olapi.transaction.IncrementalChangeException;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionEvent;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionListener;
import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.TransactionTypeUnavailableException;

public class BaseTransactionProvider
implements TransactionProvider {
    static final int AFTER_SET_EVENT = 0;
    static final int AFTER_CREATE_EVENT = 1;
    static final int BEFORE_COMMIT_EVENT = 2;
    static final int BEFORE_ROLLBACK_EVENT = 3;
    private Map m_TransactionMap = new HashMap();
    private boolean m_HideIncrementalTransactions = true;
    private DataProvider m_DataProvider = null;
    private List m_TransactionListeners = null;

    private List getTransactionListeners() {
        if (null == this.m_TransactionListeners) {
            this.m_TransactionListeners = new ArrayList();
        }
        return this.m_TransactionListeners;
    }

    private DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    private final Map getTransactionMap() {
        return this.m_TransactionMap;
    }

    public void initialize(DataProvider dataProvider) {
        this.m_DataProvider = dataProvider;
    }

    void registerTransaction(BaseTransaction baseTransaction) {
        this.getTransactionMap().put(Thread.currentThread(), baseTransaction);
    }

    public synchronized void replaceTransaction(BaseTransaction baseTransaction, BaseTransaction baseTransaction2) {
        ArrayList<Thread> arrayList = null;
        for (Map.Entry entry : this.getTransactionMap().entrySet()) {
            boolean bl;
            Thread thread = (Thread)entry.getKey();
            boolean bl2 = bl = !thread.isAlive();
            if (!bl && baseTransaction.equals(entry.getValue())) {
                if (null == baseTransaction2) {
                    bl = true;
                } else {
                    entry.setValue(baseTransaction2);
                }
            }
            if (!bl) continue;
            if (null == arrayList) {
                arrayList = new ArrayList<Thread>();
            }
            arrayList.add(thread);
        }
        if (null != arrayList) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.getTransactionMap().remove(iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireEvent(Transaction transaction, BaseTransaction baseTransaction, int n) {
        if (null == this.m_TransactionListeners) {
            return;
        }
        if (this.hideIncrementalTransactions() && baseTransaction.isIncremental()) {
            return;
        }
        BaseTransactionProvider baseTransactionProvider = this;
        synchronized (baseTransactionProvider) {
            TransactionEventImpl transactionEventImpl = new TransactionEventImpl(transaction, baseTransaction);
            for (TransactionListener transactionListener : this.m_TransactionListeners) {
                switch (n) {
                    case 0: {
                        transactionListener.performAfterSetCurrent(transactionEventImpl);
                        break;
                    }
                    case 1: {
                        transactionListener.performAfterCreate(transactionEventImpl);
                        break;
                    }
                    case 2: {
                        transactionListener.performBeforeCommit(transactionEventImpl);
                        break;
                    }
                    case 3: {
                        transactionListener.performBeforeRollback(transactionEventImpl);
                    }
                }
            }
        }
    }

    public final BaseTransaction getCurrentSystemTransaction() {
        BaseTransaction baseTransaction;
        BaseTransaction baseTransaction2 = baseTransaction = (BaseTransaction)this.getTransactionMap().get(Thread.currentThread());
        if (this.hideIncrementalTransactions() && null != baseTransaction) {
            baseTransaction2 = baseTransaction.getSystemTransaction();
        }
        if (null != baseTransaction && baseTransaction2 == baseTransaction) {
            return baseTransaction;
        }
        if (null != baseTransaction2) {
            this.registerTransaction(baseTransaction2);
            return baseTransaction2;
        }
        UserSession userSession = null;
        if (null != this.getDataProvider()) {
            userSession = this.getDataProvider().getDefaultUserSession();
            baseTransaction = userSession.getRootBaseTransaction();
        }
        if (null == baseTransaction) {
            baseTransaction = this.createRootTransaction(userSession);
        }
        this.registerTransaction(baseTransaction);
        return baseTransaction;
    }

    public final Transaction getCurrentTransaction() {
        if (this.hideIncrementalTransactions()) {
            return this.getCurrentSystemTransaction().getUserTransaction();
        }
        return this.getCurrentSystemTransaction();
    }

    public final void setCurrentTransaction(Transaction transaction) {
        Transaction transaction2;
        BaseTransaction baseTransaction = (BaseTransaction)transaction;
        BaseTransaction baseTransaction2 = null;
        if (null != baseTransaction) {
            baseTransaction2 = baseTransaction.getSystemTransaction();
        }
        if ((transaction2 = this.getCurrentTransaction()) == baseTransaction2) {
            return;
        }
        this.registerTransaction(baseTransaction2);
        this.fireEvent(transaction2, baseTransaction, 0);
    }

    public final void prepareCurrentTransaction() throws NotCommittableException, TransactionInactiveException, ActiveSubtransactionsException {
        this.getCurrentTransaction().prepare();
    }

    public final void commitCurrentTransaction() throws CommitException, TransactionInactiveException, ActiveSubtransactionsException {
        this.getCurrentTransaction().commit();
    }

    public final void rollbackCurrentTransaction() throws TransactionInactiveException, ActiveSubtransactionsException {
        this.getCurrentTransaction().rollback();
    }

    public final Transaction beginSubtransaction() throws TransactionInactiveException {
        if (this.hideIncrementalTransactions()) {
            return this.getUserTransaction(true).createSubtransaction();
        }
        return this.getCurrentSystemTransaction().createSubtransaction();
    }

    public BaseTransaction createRootTransaction(UserSession userSession) {
        BaseTransaction baseTransaction = new BaseTransaction(this, userSession, null, false);
        if (null != userSession) {
            userSession.setRootBaseTransaction(baseTransaction);
        }
        return baseTransaction;
    }

    public final synchronized void addTransactionListener(TransactionListener transactionListener) {
        this.getTransactionListeners().add(transactionListener);
    }

    public final synchronized void removeTransactionListener(TransactionListener transactionListener) {
        this.getTransactionListeners().add(transactionListener);
    }

    public final BaseTransaction getIncrementalTransaction() {
        return this.getCurrentSystemTransaction().getIncrementalTransaction();
    }

    public final BaseTransaction getUserTransaction(boolean bl) {
        BaseTransaction baseTransaction = this.getCurrentSystemTransaction();
        if (!bl) {
            return baseTransaction.getUserTransaction();
        }
        if (!baseTransaction.isIncremental()) {
            return baseTransaction;
        }
        if (this.hideIncrementalTransactions()) {
            BaseTransaction baseTransaction2 = baseTransaction.getParentTransaction();
            try {
                baseTransaction.commit();
            }
            catch (Exception exception) {
                throw new IncrementalChangeException(exception);
            }
            return baseTransaction2;
        }
        throw new TransactionTypeUnavailableException();
    }

    public InvalidMetadataException commitRootTransaction(BaseTransaction baseTransaction) throws NotCommittableException {
        return this.commitRootTransaction(baseTransaction, true);
    }

    public InvalidMetadataException commitRootTransaction(BaseTransaction baseTransaction, boolean bl) throws NotCommittableException {
        UserSession userSession = baseTransaction.getUserSession();
        DefinitionManager definitionManager = baseTransaction.findOrCreateDefinitionManager(this.getDataProvider());
        InvalidMetadataException invalidMetadataException = null;
        if (bl) {
            invalidMetadataException = definitionManager.commitRoot();
        }
        if (!userSession.isCreatingBranch()) {
            BaseTransaction baseTransaction2 = this.createRootTransaction(userSession);
            baseTransaction2.setDefinitionManager(definitionManager);
            definitionManager.setTransaction(baseTransaction2);
            this.replaceTransaction(baseTransaction, baseTransaction2);
        }
        return invalidMetadataException;
    }

    public BaseTransaction rollbackRootTransaction(BaseTransaction baseTransaction) throws NotCommittableException {
        UserSession userSession = baseTransaction.getUserSession();
        DefinitionManager definitionManager = baseTransaction.findOrCreateDefinitionManager(this.getDataProvider());
        BaseTransaction baseTransaction2 = this.createRootTransaction(userSession);
        baseTransaction2.setDefinitionManager(definitionManager);
        definitionManager.setTransaction(baseTransaction2);
        this.replaceTransaction(baseTransaction, baseTransaction2);
        return baseTransaction2;
    }

    public final void setHideIncrementalTransactions(boolean bl) {
        this.m_HideIncrementalTransactions = bl;
    }

    public BaseTransactionProvider(DataProvider dataProvider, boolean bl) {
        this.m_DataProvider = dataProvider;
        this.m_HideIncrementalTransactions = bl;
    }

    public final boolean hideIncrementalTransactions() {
        return this.m_HideIncrementalTransactions;
    }

    private static class TransactionEventImpl
    implements TransactionEvent {
        private Transaction m_FromT;
        private Transaction m_ToT;

        public TransactionEventImpl(Transaction transaction, Transaction transaction2) {
            this.m_FromT = transaction;
            this.m_ToT = transaction2;
        }

        public Transaction getFromTransaction() {
            return this.m_FromT;
        }

        public Transaction getToTransaction() {
            return this.m_ToT;
        }
    }
}

