/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;

public class EHRelation
extends ExportHandler {
    public EHRelation(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Relation_Name").append(",");
        sb.append("ModelID").append(",");
        sb.append("Num_ModelID").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("Source_Entity_Name").append(",");
        sb.append("Target_Entity_Name").append(",");
        sb.append("Source_Label").append(",");
        sb.append("Target_Label").append(",");
        sb.append("SourceTo_Target_Cardinality").append(",");
        sb.append("TargetTo_Source_Cardinality").append(",");
        sb.append("Source_Optional").append(",");
        sb.append("Target_Optional").append(",");
        sb.append("Dominant_Role").append(",");
        sb.append("Identifying").append(",");
        sb.append("Source_ID").append(",");
        sb.append("Num_Source_ID").append(",");
        sb.append("Target_ID").append(",");
        sb.append("Num_Target_ID").append(",");
        sb.append("Number_Of_Attributes");
        lines.add(sb.toString());
        LogicalDesign logDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logDesign)) {
            Iterator it = logDesign.getRelationSet().iterator();
            while (it.hasNext()) {
                Relation relation = (Relation)it.next();
                sb = new StringBuffer();
                sb.append(this.replaceAndQuoteString(relation.getName())).append(",");
                sb.append(logDesign.getObjectID()).append(",");
                sb.append(logDesign.getNumID()).append(",");
                sb.append(relation.getObjectID()).append(",");
                sb.append(relation.getNumID()).append(",");
                sb.append(relation.getImportedId() != null ? relation.getImportedId() : "").append(",");
                sb.append(this.replaceAndQuoteString(relation.getSourceEntity().getName())).append(",");
                sb.append(this.replaceAndQuoteString(relation.getTargetEntity().getName())).append(",");
                sb.append(relation.getNameOnSource() != null ? relation.getNameOnSource() : "").append(",");
                sb.append(relation.getNameOnTarget() != null ? relation.getNameOnTarget() : "").append(",");
                sb.append(this.quotedString(relation.getTargetCardinality().toString())).append(",");
                sb.append(this.quotedString(relation.getSourceCardinality().toString())).append(",");
                sb.append(relation.isOptionalSource() ? "Y" : "N").append(",");
                sb.append(relation.isOptionalTarget() ? "Y" : "N").append(",");
                sb.append(this.replaceAndQuoteString(relation.getDominantRole().getName())).append(",");
                sb.append(relation.isIdentifying() ? "Y" : "N").append(",");
                sb.append(relation.getSourceEntity().getObjectID()).append(",");
                sb.append(relation.getSourceEntity().getNumID()).append(",");
                sb.append(relation.getTargetEntity().getObjectID()).append(",");
                sb.append(relation.getTargetEntity().getNumID()).append(",");
                int[] pkEndPoint = relation.getPKProviderEndPoint();
                if (pkEndPoint.length > 0) {
                    int otherEndPoint = relation.getOtherEndPoint(pkEndPoint[0]);
                    sb.append(relation.getFKAttributes(otherEndPoint).length).append(",");
                } else {
                    sb.append("").append(",");
                }
                lines.add(sb.toString());
                this.getCsvExporter().addNote(relation.getObjectID(), relation.getNumID(), "Relation", relation.getNotes());
                this.getCsvExporter().addComment(relation.getObjectID(), relation.getNumID(), "Relation", relation.getComment());
                this.getCsvExporter().addCommentRDBMS(relation.getObjectID(), relation.getNumID(), "Relation", relation.getCommentInRDBMS());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Relations.csv";
    }
}

