/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHSpatialColumnDefinition
extends ExportHandler {
    public EHSpatialColumnDefinition(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Table_ID").append(",");
        sb.append("Num_Table_ID").append(",");
        sb.append("Definition_ID").append(",");
        sb.append("Definition_Name").append(",");
        sb.append("Table_Name").append(",");
        sb.append("ColumnID").append(",");
        sb.append("Num_ColumnID").append(",");
        sb.append("Column_Name").append(",");
        sb.append("Use_Function").append(",");
        sb.append("Function_Expression").append(",");
        sb.append("Coordinate_System_ID").append(",");
        sb.append("Has_Spatial_Index").append(",");
        sb.append("Spatial_Index_ID").append(",");
        sb.append("Num_Spatial_Index_ID");
        lines.add(sb.toString());
        for (RelationalDesign phDesign : this.getDesign().getRelationalDesigns()) {
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator tit = phDesign.getTableSet().iterator();
            while (tit.hasNext()) {
                Table table = (Table)tit.next();
                Iterator sdit = table.getSpatialDefinitions().iterator();
                int seq = 0;
                while (sdit.hasNext()) {
                    SpatialColumnDefObject sd = (SpatialColumnDefObject)sdit.next();
                    sd.setId(++seq);
                    sb = new StringBuffer();
                    sb.append(table.getObjectID()).append(",");
                    sb.append(table.getNumID()).append(",");
                    sb.append(seq).append(",");
                    sb.append(this.replaceAndQuoteString(sd.getName())).append(",");
                    sb.append(table.getName()).append(",");
                    if (sd.getSpatialColumn() != null) {
                        sb.append(sd.getSpatialColumn().getObjectID()).append(",");
                        sb.append(sd.getSpatialColumn().getNumID()).append(",");
                        sb.append(sd.getSpatialColumn().getName()).append(",");
                    } else {
                        sb.append("").append(",");
                        sb.append("").append(",");
                        sb.append("").append(",");
                    }
                    sb.append(sd.isFunction() ? "Y" : "N").append(",");
                    sb.append(this.replaceAndQuoteString(sd.getFuncExpression())).append(",");
                    sb.append(sd.getSystemID()).append(",");
                    if (sd.getSpatialIndex() != null) {
                        sb.append("Y").append(",");
                        sb.append(sd.getSpatialIndex().getObjectID()).append(",");
                        sb.append(sd.getSpatialIndex().getNumID()).append(",");
                    } else {
                        sb.append("N").append(",");
                        sb.append("").append(",");
                        sb.append("").append(",");
                    }
                    lines.add(sb.toString());
                }
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Spatial_Column_Definition.csv";
    }
}

