/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class SQLAnalyzer {
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_PACKAGE = "package";
    public static final String TYPE_COLUMN = "column";
    private static final String t_ref = "table_reference";
    private static final String u_funct = "user_defined_function";
    private static final String dml_table = "aliased_dml_table_expression_clause";
    private static final String function_call = "function_call";
    private static final String prm_spec_type = "prm_spec_unconstrained_type";
    private static final String prm_spec = "prm_spec";
    private static final String unconstrained_type = "unconstrained_type";
    private static String column = "column";
    private static final String q_block = "query_block";

    private static boolean hasString(String[] split, String str) {
        for (int i = 1; i < split.length; ++i) {
            if (!str.equals(split[i].trim())) continue;
            return true;
        }
        return false;
    }

    private static String getContent(ParseNode pn, List<LexerToken> src) {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = pn.from; i < pn.to; ++i) {
                sb.append(src.get((int)i).content);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseContentForTable(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            int p = 0;
            int i = pn.from;
            while (i < pn.to) {
                String temp = src.get((int)i).content;
                if (p == 0) {
                    if (temp.startsWith("(")) {
                        return;
                    }
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    pd.valid = true;
                } else if (p == 1) {
                    if (!".".equals(temp)) {
                        pd.alias = temp;
                        return;
                    }
                    pd.schema = pd.name;
                    pd.name = null;
                } else if (p == 2) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                } else if (p == 3) {
                    pd.alias = temp;
                    return;
                }
                ++p;
                ++i;
            }
            return;
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForColumn(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (p == 0) {
                    if (temp.startsWith("(")) break;
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    pd.valid = true;
                } else if (p == 1) {
                    if (!".".equals(temp)) break;
                    pd.schema = pd.name;
                    pd.name = null;
                } else if (p == 2) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    break;
                }
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForParameterSpec(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            boolean percentFound = false;
            String colName = null;
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (percentFound) {
                    if (temp.equalsIgnoreCase("TYPE")) {
                        if (pd.name != null) {
                            pd.valid = true;
                        }
                    } else if (temp.equalsIgnoreCase("ROWTYPE")) {
                        pd.schema = pd.name;
                        pd.name = colName;
                        pd.valid = true;
                    }
                    break;
                }
                if (p == 0) {
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if (p == 2) {
                    pd.name = colName;
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if (p == 4) {
                    pd.schema = pd.name;
                    pd.name = colName;
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if ("%".equals(temp)) {
                    percentFound = true;
                } else if (!".".equals(temp)) break;
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForFunction(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        int p = 0;
        try {
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (temp.startsWith("(")) {
                    pd.valid = p > 0;
                    return;
                }
                if (p == 0) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                } else if (".".equals(temp)) {
                    if (p == 1) {
                        pd.schema = pd.name;
                        pd.name = null;
                    } else if (p == 3) {
                        pd.pack = pd.name;
                        pd.name = null;
                    }
                } else if (p == 2 || p == 4) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    if (p == 4) break;
                }
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    public static List<PDescriptor> getTablesAndFunctions(String sql) {
        HashMap<String, PDescriptor> tmap = null;
        HashMap<String, PDescriptor> fmap = null;
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        int table_ref = earley.getSymbol(t_ref);
        int dml_tab = earley.getSymbol(dml_table);
        int udf = earley.getSymbol(u_funct);
        int f_cal = earley.getSymbol(function_call);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    ParseNode parent = n.parent();
                    if (n.contains(table_ref) || n.contains(dml_tab)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap<String, PDescriptor>();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (n.contains(udf) || n.contains(f_cal)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_FUNCTION;
                        SQLAnalyzer.parseContentForFunction(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (fmap == null) {
                            fmap = new HashMap<String, PDescriptor>();
                        }
                        if (fmap.get(name) != null) continue;
                        list.add(pd);
                        fmap.put(name, pd);
                        continue;
                    }
                    if (parent == null || !parent.contains(param_spec) || !n.contains(unconstr_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        return list;
    }

    public static List<PDescriptor> getTables(String sql) {
        HashMap<String, PDescriptor> tmap = null;
        Object fmap = null;
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        int table_ref = earley.getSymbol(t_ref);
        int dml_tab = earley.getSymbol(dml_table);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    ParseNode parent = n.parent();
                    if (n.contains(table_ref) || n.contains(dml_tab)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap<String, PDescriptor>();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (parent == null || !parent.contains(param_spec) || !n.contains(unconstr_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        return list;
    }

    public static List<PDescriptor> getTablesAndColumns(String sql, String schema, Map containers) {
        HashMap<String, PDescriptor> tmap = new HashMap<String, PDescriptor>();
        Object fmap = null;
        HashMap<String, PDescriptor> cmap = new HashMap<String, PDescriptor>();
        HashMap<String, PDescriptor> c2map = new HashMap<String, PDescriptor>();
        HashMap<String, Object> amap = new HashMap<String, Object>();
        ArrayList cols = new ArrayList();
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        int table_ref = earley.getSymbol(t_ref);
        int column_ = earley.getSymbol(column);
        int dml_tab = earley.getSymbol(dml_table);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        int query_block = earley.getSymbol(q_block);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            int count = 10;
            Integer qb = 10;
            int qb_end = root.to;
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(qb);
            stack.push(qb_end);
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    if (n.contains(query_block)) {
                        stack.push(qb);
                        stack.push(qb_end);
                        qb = ++count;
                        qb_end = n.to;
                    }
                    if (n.from == qb_end) {
                        qb_end = (Integer)stack.pop();
                        qb = (Integer)stack.pop();
                    }
                    String qb_id = String.valueOf(qb);
                    ParseNode parent = n.parent();
                    if (n.contains(table_ref) || n.contains(dml_tab)) {
                        String alias;
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap();
                        }
                        if (tmap.get(name) == null) {
                            list.add(pd);
                            tmap.put(name, pd);
                        }
                        if ((alias = pd.alias) == null || alias.isEmpty()) {
                            alias = pd.name;
                        }
                        amap.put(qb_id + alias, pd);
                        HashMap<String, PDescriptor> tables = (HashMap<String, PDescriptor>)amap.get(qb_id);
                        if (tables == null) {
                            tables = new HashMap<String, PDescriptor>();
                            amap.put(qb_id, tables);
                        }
                        tables.put(name, pd);
                        continue;
                    }
                    if (n.contains(column_)) {
                        String cont = SQLAnalyzer.getContent(n, src);
                        PDescriptor pd2 = new PDescriptor();
                        pd2.element = cont;
                        pd2.type = TYPE_COLUMN;
                        pd2.query_block_id = qb_id;
                        pd2.start = n.from;
                        SQLAnalyzer.parseContentForColumn(n, src, pd2);
                        if (!pd2.valid) continue;
                        String name2 = pd2.toString();
                        cmap.put(qb_id + name2, pd2);
                        continue;
                    }
                    if (parent == null || !parent.contains(param_spec) || !n.contains(unconstr_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    pd.start = n.from;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
                for (Map.Entry ent : cmap.entrySet()) {
                    String lname;
                    PDescriptor pd = (PDescriptor)ent.getValue();
                    if (pd.schema != null && !pd.schema.isEmpty()) {
                        PDescriptor td = (PDescriptor)amap.get(pd.query_block_id + pd.schema);
                        if (td == null) continue;
                        pd.schema = td.schema;
                        pd.table = td.name;
                        String lname2 = pd.toString();
                        if (c2map.get(lname2) != null) continue;
                        c2map.put(lname2, pd);
                        list.add(pd);
                        continue;
                    }
                    if (containers == null) continue;
                    ArrayList<PDescriptor> tables = new ArrayList<PDescriptor>();
                    Map map = (Map)amap.get(pd.query_block_id);
                    if (map == null) continue;
                    tables.addAll(map.values());
                    SQLAnalyzer.resolveContainer(pd, schema, tables, containers);
                    if (pd.table == null || pd.table.isEmpty() || c2map.get(lname = pd.toString()) != null) continue;
                    c2map.put(lname, pd);
                    list.add(pd);
                }
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        Collections.sort(list);
        return list;
    }

    public static void resolveContainer(PDescriptor cd, String schema, List<PDescriptor> tables, Map containers) {
        for (PDescriptor td : tables) {
            ContainerObject co;
            String name = td.name;
            if (td.schema != null && !td.schema.isEmpty()) {
                name = td.schema + "." + name;
            } else if (schema != null && !schema.isEmpty()) {
                name = schema + "." + name;
            }
            if ((co = (ContainerObject)containers.get(name.toUpperCase())) == null || co.getElementByName(cd.name) == null) continue;
            cd.table = td.name;
            cd.schema = td.schema;
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        String sql = Service.readFile((String)"D:/testaabc.sql");
        SqlEarley earley = SqlEarley.getInstance();
        int table_ref = earley.getSymbol(t_ref);
        int column_ = earley.getSymbol(column);
        int dml_tab = earley.getSymbol(dml_table);
        int udf = earley.getSymbol(u_funct);
        int f_cal = earley.getSymbol(function_call);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        int query_block = earley.getSymbol(q_block);
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(src, (Matriceable)matrix);
        ParseNode root = earley.forest(src, matrix);
        int count = 10;
        Integer qb = 10;
        int qb_end = root.to;
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(qb);
        stack.push(qb_end);
        List<PDescriptor> list = SQLAnalyzer.getTablesAndColumns(sql, null, null);
        for (PDescriptor pd : list) {
            System.out.println(pd.toString());
        }
        for (ParseNode n : root.descendants()) {
            PDescriptor pd;
            String cont;
            if (n.contains(query_block)) {
                stack.push(qb);
                stack.push(qb_end);
                qb = ++count;
                qb_end = n.to;
            }
            if (n.from == qb_end) {
                qb_end = (Integer)stack.pop();
                qb = (Integer)stack.pop();
            }
            String conta = n.content(src);
            String contb = SQLAnalyzer.getContent(n, src);
            ParseNode parent = n.parent();
            String tostr = n.toString();
            String[] split = tostr.split("  ");
            if (n.contains(table_ref) || n.contains(dml_tab)) {
                cont = SQLAnalyzer.getContent(n, src);
                pd = new PDescriptor();
                pd.element = cont;
                pd.type = TYPE_TABLE;
                pd.start = n.from;
                SQLAnalyzer.parseContentForTable(n, src, pd);
                System.out.println("table " + String.valueOf(pd.schema) + "." + pd.name + " " + pd.alias + "  qb=" + qb + "  - valid " + pd.valid);
                continue;
            }
            if (n.contains(column_)) {
                cont = SQLAnalyzer.getContent(n, src);
                pd = new PDescriptor();
                pd.element = cont;
                pd.type = TYPE_COLUMN;
                pd.start = n.from;
                SQLAnalyzer.parseContentForColumn(n, src, pd);
                System.out.println("column " + String.valueOf(pd.schema) + "." + pd.name + "  qb=" + qb + "  - valid " + pd.valid);
                continue;
            }
            if (n.contains(udf) || n.contains(f_cal)) {
                cont = n.content(src);
                if (cont.indexOf("(") <= 0) continue;
                pd = new PDescriptor();
                pd.element = cont;
                pd.type = TYPE_FUNCTION;
                pd.start = n.from;
                SQLAnalyzer.parseContentForFunction(n, src, pd);
                System.out.println("function " + cont);
                System.out.println("function " + String.valueOf(pd.schema) + "." + String.valueOf(pd.pack) + "." + pd.name);
                continue;
            }
            if (parent == null || !parent.contains(param_spec) || !n.contains(unconstr_type)) continue;
            PDescriptor pd2 = new PDescriptor();
            pd2.type = TYPE_TABLE;
            pd2.start = n.from;
            SQLAnalyzer.parseContentForParameterSpec(n, src, pd2);
            System.out.println(pd2.toString() + " valid =" + pd2.valid);
        }
        root.printTree();
    }

    public static class PDescriptor
    implements Comparable<PDescriptor> {
        public String element;
        public String type = "";
        public String schema;
        public String name;
        public String pack;
        public String alias;
        public String table;
        public int start = 0;
        boolean valid = false;
        public String query_block_id = "";

        int getSortValue() {
            return Integer.valueOf(this.query_block_id) * 100000 + this.start;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (SQLAnalyzer.TYPE_COLUMN.equalsIgnoreCase(this.type)) {
                sb.append(String.valueOf(this.schema)).append(".").append(String.valueOf(this.table)).append(".").append(this.name);
            } else {
                sb.append(String.valueOf(this.schema)).append(".").append(String.valueOf(this.pack)).append(".").append(this.name);
            }
            return sb.toString().toUpperCase();
        }

        @Override
        public int compareTo(PDescriptor pd) {
            int sv2;
            int sv1 = this.getSortValue();
            if (sv1 < (sv2 = pd.getSortValue())) {
                return -1;
            }
            if (sv1 > sv2) {
                return 1;
            }
            return 0;
        }
    }
}

