/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;

public class SSBFKOraclev10g
extends AbstractSSBOracle {
    StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        boolean ora12_2;
        FKProxyOraclev10g fkproxy;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        FKIndexAssociation fk = null;
        if (object instanceof FKIndexAssociation) {
            fk = (FKIndexAssociation)object;
            RelationalDesign rd = (RelationalDesign)fk.getDesignPart();
            this.storageDesign = (StorageDesignOracle)this.getStorageDesign();
            fkproxy = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fk.getObjectID());
            if (fkproxy == null && (fkproxy = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID())) == null) {
                this.appendViewFKs(oldbuffer, fk, prettyPrint);
                return;
            }
        } else {
            fkproxy = (FKProxyOraclev10g)object;
            this.storageDesign = (StorageDesignOracle)fkproxy.getStorageDesign();
        }
        boolean ext_table = false;
        TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(fkproxy.getTable().getObjectID());
        if (tableProxy != null) {
            ext_table = "EXTERNAL".equalsIgnoreCase(tableProxy.getOrganization());
        }
        if ((ora12_2 = this.storageDesign instanceof StorageDesignOraclev12cR2) || !ext_table) {
            if (fkproxy.getIndex().getElements().length > 0) {
                PartitionListOracle partitionList = tableProxy.getPartitionList();
                if (partitionList instanceof PartitionListOraclev11g && partitionList.getPartitionType().equals("REFERENCE") && fkproxy == ((PartitionListOraclev11g)partitionList).getRefConstraint()) {
                    return;
                }
                if (DDLGenerationOptions.isIncludeComments() && !"".equals(fkproxy.getComment())) {
                    this.appendComment(oldbuffer, fkproxy);
                    SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                }
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                String fkName = fkproxy.getName();
                if (fkName.length() > tableProxy.getMaxConstraintNameLength()) {
                    SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBFKOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: FK name length exceeds maximum allowed length(" + tableProxy.getMaxConstraintNameLength() + ")");
                    SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                this.appendPrompt(buffer, tableProxy, "FOREIGN KEY ON");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "TABLE");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, "ADD");
                if (!fkName.startsWith("SYS_")) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy));
                }
                SSBFKOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
                advancedComment = buffer.toString();
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBFKOraclev10g.appendString(buffer, fkproxy.getColumns(this.storageDesign));
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
                this.appendReferences(buffer, fkproxy);
                boolean referencesView = fkproxy.getFKTable() instanceof TableView;
                if (referencesView || ext_table) {
                    if (ext_table) {
                        SSBFKOraclev10g.appendStringWithSpace(buffer, "RELY");
                    }
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                } else {
                    this.appendOnDelete(buffer, fkproxy);
                    this.appendConstraintState(buffer, fkproxy);
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBFKOraclev10g.appendLineFinisher(buffer, prettyPrint);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterTable();
                String relyValue = null;
                if (referencesView) {
                    if (fkproxy.getRely().equals("YES")) {
                        relyValue = "RELY";
                    } else {
                        KeyObject fkIndex = (KeyObject)fkproxy.getObject();
                        if (fkIndex != null) {
                            fk = fkIndex.getFKAssociation();
                        }
                        if (fk != null && fk.isRely()) {
                            relyValue = "RELY";
                        }
                    }
                } else if (fkproxy.getValidate().equals("NO")) {
                    if (fkproxy.getRely().equals("YES")) {
                        relyValue = "RELY";
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        relyValue = "NORELY";
                    }
                }
                if (relyValue != null && !ext_table) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                    SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy));
                    advancedComment = buffer.toString();
                    SSBFKOraclev10g.appendStringWithSpace(buffer, relyValue);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    SSBFKOraclev10g.appendLineFinisher(buffer, prettyPrint);
                    SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementAlterTable();
                }
                this.appendExceptionTable(oldbuffer, fkproxy, prettyPrint);
                this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
            } else {
                SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                oldbuffer.append("-- Error - Foreign Key ");
                oldbuffer.append(this.storageDesign.getFormatedName(fkproxy));
                oldbuffer.append(" has no columns");
                SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendExceptionTable(StringBuffer oldbuffer, FKProxyOraclev10g fk, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (fk.getExceptionsTable() != null && "YES".equalsIgnoreCase(fk.getEnable())) {
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "TABLE");
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(fk.getTableProxy()));
            advancedComment = buffer.toString();
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "MODIFY");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementAlterTable();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof FKProxyOraclev10g) {
            if (!((FKProxyOraclev10g)object).getStorageDesign().isOpen()) {
                return ((FKProxyOraclev10g)object).getObject().isMarkedGenerate();
            }
            return ((FKProxyOraclev10g)object).isMarkedGenerate();
        }
        if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return false;
    }

    private void appendReferences(StringBuffer buffer, FKProxyOraclev10g fk) {
        SSBFKOraclev10g.appendNewLine(buffer, true, 1);
        FKContainer refTable = fk.getFKTable();
        if (refTable != null) {
            SSBFKOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
            ModelIDObject refTableObject = null;
            refTableObject = refTable instanceof TableView ? this.storageDesign.getTableViewProxySet().getProxy(refTable.getObjectID()) : this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObject == null) {
                refTableObject = refTable;
            }
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObject));
            boolean refStructType = false;
            if (refTable.isBST()) {
                ColumnProxy[] columnProxies = fk.getColumnProxies();
                for (int i = 0; i < columnProxies.length; ++i) {
                    Column column = columnProxies[i].getColumn();
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
            if (!refStructType) {
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
                SSBFKOraclev10g.appendNewLine(buffer, true, 0);
                SSBFKOraclev10g.appendString(buffer, fk.getReferenceColumns(this.storageDesign));
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else {
            FKIndexAssociation fkIndexAssociation = fk.getIndex().getFKAssociation();
            String formattedTableLongName = fkIndexAssociation.getFormattedReferredTableLongName();
            if (!formattedTableLongName.isEmpty()) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
                SSBFKOraclev10g.appendStringWithSpace(buffer, formattedTableLongName);
                SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(fkIndexAssociation.getReferredColumnNames()));
                SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private static void appendReferences(StringBuffer buffer, MOHTableOracle.PK_UK_helper pk, StorageDesignOracle storageDesign) {
        SSBFKOraclev10g.appendNewLine(buffer, true, 1);
        if (pk.tname != null) {
            SSBFKOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
            SSBFKOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(pk.owner) + "." + storageDesign.getFormatedName(pk.tname));
            boolean refStructType = false;
            if (!refStructType) {
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendString(buffer, storageDesign.getFormattedNameList(pk.columns));
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendOnDelete(StringBuffer buffer, FKProxyOraclev10g fk) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        String onDelete = fkass.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = fkass.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            SSBFKOraclev10g.appendNewLine(buffer, true, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ON");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "DELETE");
            SSBFKOraclev10g.appendStringWithSpace(buffer, onDelete);
        }
    }

    private static void appendOnDelete(StringBuffer buffer, MOHTableOracle.FKTemp fkt) {
        String onDelete = fkt.delete_rule;
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            SSBFKOraclev10g.appendNewLine(buffer, true, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ON");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "DELETE");
            SSBFKOraclev10g.appendStringWithSpace(buffer, onDelete);
        }
    }

    private void appendConstraintState(StringBuffer buffer, FKProxyOraclev10g fk) {
        if (this.storageDesign.isOpen()) {
            SSBFKOraclev10g.appendNewLine(buffer, true, 1);
            if ("NO".equalsIgnoreCase(fk.getDeferrable())) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "NOT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            } else {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(fk.getInitially())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(fk.getEnable())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(fk.getValidate())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(fk.getEnable())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(fk.getValidate())) {
                        SSBFKOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(fk.getValidate())) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            if (fk.getExceptionsTable() != null) {
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                buffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
            }
        }
    }

    private static void appendConstraintState(StringBuffer buffer, MOHTableOracle.FKTemp fkt, StorageDesignOracle storageDesign) {
        if (storageDesign.isOpen()) {
            SSBFKOraclev10g.appendNewLine(buffer, true, 1);
            if ("NOT DEFERRABLE".equalsIgnoreCase(fkt.deferrable)) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "NOT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            } else {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(fkt.deferred)) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
                } else if (storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            }
            if (storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("ENABLED".equalsIgnoreCase(fkt.status)) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("VALIDATED".equalsIgnoreCase(fkt.validated)) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"ENABLED".equalsIgnoreCase(fkt.status)) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                    if ("VALIDATED".equalsIgnoreCase(fkt.validated)) {
                        SSBFKOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"VALIDATED".equalsIgnoreCase(fkt.validated)) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
        }
    }

    protected static void appendViewFKs(StringBuffer oldbuffer, MOHTableOracle.FKTemp fkt, boolean prettyPrint, StorageDesignOracle storageDesign) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        String fkName = fkt.name;
        SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
        SSBFKOraclev10g.appendStringWithSpace(buffer, "VIEW");
        String longName = storageDesign.getFormatedName(fkt.owner) + "." + storageDesign.getFormatedName(fkt.tname);
        SSBFKOraclev10g.appendStringWithSpace(buffer, longName);
        SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBFKOraclev10g.appendStringWithSpace(buffer, "ADD");
        if (!fkName.startsWith("SYS_") || storageDesign.getAppView().getSettings().isIncludeSystemNamesInCompare()) {
            SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBFKOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(fkName));
        }
        SSBFKOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
        advancedComment = buffer.toString();
        SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
        SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        SSBFKOraclev10g.appendString(buffer, storageDesign.getFormattedNameList(fkt.columns));
        SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
        SSBFKOraclev10g.appendFKReferences(buffer, fkt.hlp, storageDesign);
        SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
        SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        SSBFKOraclev10g.appendLineFinisher(buffer, prettyPrint);
        SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        SSBFKOraclev10g.incrementAlterView();
        if (fkt.rely != null && "RELY".equalsIgnoreCase(fkt.rely)) {
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "VIEW");
            SSBFKOraclev10g.appendStringWithSpace(buffer, longName);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "MODIFY");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBFKOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(fkName));
            SSBFKOraclev10g.appendStringWithSpace(buffer, "RELY");
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.appendLineFinisher(buffer, prettyPrint);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.incrementAlterView();
        }
        oldbuffer.append(buffer);
    }

    protected void appendViewFKs(StringBuffer oldbuffer, FKIndexAssociation fk, boolean prettyPrint) {
        if (fk.getLocalFKIndex().getElements().length > 0) {
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            TableViewProxyOracle tableProxy = (TableViewProxyOracle)this.storageDesign.getTableViewProxySet().getProxy(fk.getTable().getObjectID());
            this.appendComment(oldbuffer, fk);
            SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
            String fkName = fk.getName();
            if (fkName.length() > tableProxy.getMaxConstraintNameLength()) {
                SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBFKOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: FK name length exceeds maximum allowed length(" + tableProxy.getMaxConstraintNameLength() + ")");
                SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
            this.appendPrompt(buffer, tableProxy, "FOREIGN KEY ON");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "VIEW");
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!fkName.startsWith("SYS_")) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
            }
            SSBFKOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
            advancedComment = buffer.toString();
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.appendString(buffer, this.getFKColumns(fk));
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendFKReferences(buffer, fk);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.appendLineFinisher(buffer, prettyPrint);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementAlterView();
            if (fk.isRely()) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "VIEW");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk));
                advancedComment = buffer.toString();
                SSBFKOraclev10g.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBFKOraclev10g.appendLineFinisher(buffer, prettyPrint);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementAlterView();
            }
            this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        } else {
            SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            oldbuffer.append("-- Error - Foreign Key ");
            oldbuffer.append(this.storageDesign.getFormatedName(fk));
            oldbuffer.append(" has no columns");
            SSBFKOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    public String getFKColumns(FKIndexAssociation fk) {
        StringBuffer result = new StringBuffer();
        ContainedObject[] columns = fk.getLocalFKIndex().getElements();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                result.append(",\n");
            }
            result.append("     ").append(this.storageDesign.getFormatedName(columns[i]));
        }
        return result.toString();
    }

    private void appendFKReferences(StringBuffer buffer, FKIndexAssociation fk) {
        SSBFKOraclev10g.appendNewLine(buffer, true, 1);
        FKContainer refTable = fk.getRemoteTable();
        if (refTable != null) {
            SSBFKOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
            ModelIDObject refTableObject = null;
            refTableObject = refTable instanceof TableView ? this.storageDesign.getTableViewProxySet().getProxy(refTable.getObjectID()) : this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObject == null) {
                refTableObject = refTable;
            }
            SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObject));
            boolean refStructType = false;
            if (refTable.isBST()) {
                ContainedObject[] columns = fk.getLocalFKIndex().getElements();
                for (int i = 0; i < columns.length; ++i) {
                    FKElement column = (FKElement)columns[i];
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
            if (!refStructType) {
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
                SSBFKOraclev10g.appendNewLine(buffer, true, 0);
                SSBFKOraclev10g.appendString(buffer, this.getFKReferenceColumns(fk));
                SSBFKOraclev10g.appendNewLine(buffer, true, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else {
            String formattedTableLongName = fk.getFormattedReferredTableLongName();
            if (!formattedTableLongName.isEmpty()) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
                SSBFKOraclev10g.appendStringWithSpace(buffer, formattedTableLongName);
                SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
                SSBFKOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(fk.getReferredColumnNames()));
                SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private static void appendFKReferences(StringBuffer buffer, MOHTableOracle.PK_UK_helper pk, StorageDesignOracle storageDesign) {
        SSBFKOraclev10g.appendNewLine(buffer, true, 1);
        SSBFKOraclev10g.appendStringWithSpace(buffer, "REFERENCES");
        SSBFKOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(pk.owner) + "." + storageDesign.getFormatedName(pk.tname));
        boolean refStructType = false;
        if (!refStructType) {
            SSBFKOraclev10g.appendNewLine(buffer, true, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
            SSBFKOraclev10g.appendNewLine(buffer, true, 0);
            SSBFKOraclev10g.appendString(buffer, storageDesign.getFormattedNameList(pk.columns));
            SSBFKOraclev10g.appendNewLine(buffer, true, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    public String getFKReferenceColumns(FKIndexAssociation fk) {
        StringBuffer result = new StringBuffer();
        KeyObject remoteIndex = fk.getRemoteIndex();
        if (remoteIndex != null) {
            ContainedObject[] columns = remoteIndex.getElements();
            for (int i = 0; i < columns.length; ++i) {
                ModelIDObject columnObject;
                if (i > 0) {
                    result.append(",\n");
                }
                if ((columnObject = this.storageDesign.getColumnProxySet().getProxy(columns[i].getObjectID())) == null) {
                    columnObject = columns[i];
                }
                String name = this.storageDesign.getFormatedName(columnObject);
                result.append("     ").append(name);
            }
        }
        return result.toString();
    }

    public static String getFK_DDL(List<MOHTableOracle.FKTemp> list, StorageDesignOracle storageDesign) {
        StringBuffer oldbuffer = new StringBuffer();
        for (MOHTableOracle.FKTemp fkt : list) {
            SSBFKOraclev10g.appendFK_DDL(oldbuffer, fkt, storageDesign, true);
        }
        return oldbuffer.toString();
    }

    public static void appendFK_DDL(StringBuffer oldbuffer, List<MOHTableOracle.FKTemp> list, StorageDesignOracle storageDesign) {
        for (MOHTableOracle.FKTemp fkt : list) {
            SSBFKOraclev10g.appendFK_DDL(oldbuffer, fkt, storageDesign, true);
        }
    }

    public static void appendFK_DDL(StringBuffer oldbuffer, MOHTableOracle.FKTemp fkt, StorageDesignOracle storageDesign, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        if (fkt.onView) {
            SSBFKOraclev10g.appendViewFKs(oldbuffer, fkt, prettyPrint, storageDesign);
            return;
        }
        boolean ext_table = false;
        boolean ora12_2 = false;
        if (ora12_2 || !ext_table) {
            String fkName = fkt.name;
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
            SSBFKOraclev10g.appendStringWithSpace(buffer, "TABLE");
            String longName = storageDesign.getFormatedName(fkt.owner) + "." + storageDesign.getFormatedName(fkt.tname);
            SSBFKOraclev10g.appendStringWithSpace(buffer, longName);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!fkName.startsWith("SYS_") || storageDesign.getAppView().getSettings().isIncludeSystemNamesInCompare()) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormattedNameList(fkName));
            }
            SSBFKOraclev10g.appendStringWithSpace(buffer, "FOREIGN KEY");
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, '(');
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendString(buffer, storageDesign.getFormattedNameList(fkt.columns));
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBFKOraclev10g.appendStringWithSpace(buffer, ')');
            SSBFKOraclev10g.appendReferences(buffer, fkt.hlp, storageDesign);
            boolean referencesView = fkt.hlp.onView;
            if (referencesView || ext_table) {
                if (ext_table) {
                    SSBFKOraclev10g.appendStringWithSpace(buffer, "RELY");
                }
                SSBFKOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            } else {
                SSBFKOraclev10g.appendOnDelete(buffer, fkt);
                SSBFKOraclev10g.appendConstraintState(buffer, fkt, storageDesign);
            }
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBFKOraclev10g.appendLineFinisher(buffer, prettyPrint);
            SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            String relyValue = null;
            if (referencesView) {
                if (fkt.rely != null && "RELY".equalsIgnoreCase(fkt.rely)) {
                    relyValue = "RELY";
                }
            } else if ("NOT VALIDATED".equals(fkt.validated)) {
                if (fkt.rely != null && "RELY".equalsIgnoreCase(fkt.rely)) {
                    relyValue = "RELY";
                } else if (storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    relyValue = "NORELY";
                }
            }
            if (relyValue != null && !ext_table) {
                SSBFKOraclev10g.appendStringWithSpace(buffer, "ALTER");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "TABLE");
                SSBFKOraclev10g.appendStringWithSpace(buffer, longName);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBFKOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                SSBFKOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBFKOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(fkName));
                SSBFKOraclev10g.appendStringWithSpace(buffer, relyValue);
                SSBFKOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBFKOraclev10g.appendLineFinisher(buffer, prettyPrint);
            }
            oldbuffer.append(buffer);
        }
    }
}

