/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBORDSSchema
extends AbstractSSBOracle {
    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchemaObject && ((SchemaObject)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        SchemaObject schema = (SchemaObject)object;
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 0);
        if (schema.isORDSDropSchema()) {
            this.appendDropSchema(schema, buffer, prettyPrint);
        }
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 0);
        SSBORDSSchema.appendString(buffer, "DECLARE");
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 1);
        SSBORDSSchema.appendString(buffer, "PRAGMA AUTONOMOUS_TRANSACTION");
        SSBORDSSchema.appendString(buffer, ';');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 0);
        SSBORDSSchema.appendString(buffer, "BEGIN");
        Iterator it = ((RelationalDesign)schema.getDesignPart()).getTableSet().iterator();
        while (it.hasNext()) {
            ContainerObject table = (ContainerObject)it.next();
            if (table.getSchemaObject() != schema) continue;
            this.appendEnableObject(table, schema.getName(), "TABLE", buffer, prettyPrint);
        }
        it = ((RelationalDesign)schema.getDesignPart()).getTableViewSet().iterator();
        while (it.hasNext()) {
            ContainerObject view = (ContainerObject)it.next();
            if (view.getSchemaObject() != schema) continue;
            this.appendEnableObject(view, schema.getName(), "VIEW", buffer, prettyPrint);
        }
        this.appendEnableSchema(schema, buffer, prettyPrint);
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 1);
        SSBORDSSchema.appendString(buffer, "COMMIT");
        SSBORDSSchema.appendString(buffer, ';');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 0);
        SSBORDSSchema.appendString(buffer, "END");
        SSBORDSSchema.appendString(buffer, ';');
        DDLFileMaker.incrementORDSEnableSchema();
    }

    private void appendDropSchema(SchemaObject schema, StringBuffer buffer, boolean prettyPrint) {
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 0);
        SSBORDSSchema.appendString(buffer, "DECLARE");
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 1);
        SSBORDSSchema.appendString(buffer, "PRAGMA AUTONOMOUS_TRANSACTION");
        SSBORDSSchema.appendString(buffer, ';');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 0);
        SSBORDSSchema.appendString(buffer, "BEGIN");
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 1);
        SSBORDSSchema.appendString(buffer, "ORDS.ENABLE_SCHEMA");
        SSBORDSSchema.appendString(buffer, '(');
        SSBORDSSchema.appendStringWithSpace(buffer, "p_enabled");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, "FALSE");
        SSBORDSSchema.appendString(buffer, ')');
        SSBORDSSchema.appendString(buffer, ';');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 1);
        SSBORDSSchema.appendString(buffer, "ORDS.DROP_REST_FOR_SCHEMA");
        SSBORDSSchema.appendString(buffer, '(');
        SSBORDSSchema.appendStringWithSpace(buffer, "p_schema");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, this.addQuotes(schema.getName(), true));
        SSBORDSSchema.appendString(buffer, ')');
        SSBORDSSchema.appendString(buffer, ';');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 1);
        SSBORDSSchema.appendString(buffer, "COMMIT");
        SSBORDSSchema.appendString(buffer, ';');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 0);
        SSBORDSSchema.appendString(buffer, "END");
        SSBORDSSchema.appendString(buffer, ';');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 0);
        DDLFileMaker.incrementORDSDropSchema();
    }

    private void appendEnableObject(ContainerObject container, String schemaName, String type, StringBuffer buffer, boolean prettyPrint) {
        int tab = 6;
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 1);
        SSBORDSSchema.appendString(buffer, "ORDS.ENABLE_OBJECT");
        SSBORDSSchema.appendStringWithSpace(buffer, '(');
        SSBORDSSchema.appendStringWithSpace(buffer, "p_enabled");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, container.isORDSEnable() ? "TRUE" : "FALSE");
        SSBORDSSchema.appendStringWithSpace(buffer, ',');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, tab);
        SSBORDSSchema.appendStringWithSpace(buffer, "p_schema");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, this.addQuotes(schemaName, true));
        SSBORDSSchema.appendStringWithSpace(buffer, ',');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, tab);
        SSBORDSSchema.appendStringWithSpace(buffer, "p_object");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, this.addQuotes(container.getName(), true));
        SSBORDSSchema.appendStringWithSpace(buffer, ',');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, tab);
        SSBORDSSchema.appendStringWithSpace(buffer, "p_object_type");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, this.addQuotes(type, true));
        SSBORDSSchema.appendStringWithSpace(buffer, ',');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, tab);
        SSBORDSSchema.appendStringWithSpace(buffer, "p_object_alias");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, this.addQuotes(container.getORDSAliasNotEmpty(), true));
        SSBORDSSchema.appendStringWithSpace(buffer, ',');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, tab);
        SSBORDSSchema.appendStringWithSpace(buffer, "p_auto_rest_auth");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, container.isORDSAuth() ? "TRUE" : "FALSE");
        SSBORDSSchema.appendString(buffer, ')');
        SSBORDSSchema.appendString(buffer, ';');
    }

    private void appendEnableSchema(SchemaObject schema, StringBuffer buffer, boolean prettyPrint) {
        int tab = 6;
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, 1);
        SSBORDSSchema.appendString(buffer, "ORDS.ENABLE_SCHEMA");
        SSBORDSSchema.appendStringWithSpace(buffer, '(');
        SSBORDSSchema.appendStringWithSpace(buffer, "p_enabled");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, schema.isORDSEnable() ? "TRUE" : "FALSE");
        SSBORDSSchema.appendStringWithSpace(buffer, ',');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, tab);
        SSBORDSSchema.appendStringWithSpace(buffer, "p_schema");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, this.addQuotes(schema.getName(), true));
        SSBORDSSchema.appendStringWithSpace(buffer, ',');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, tab);
        SSBORDSSchema.appendStringWithSpace(buffer, "p_url_mapping_type");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, this.addQuotes("BASE_PATH", true));
        SSBORDSSchema.appendStringWithSpace(buffer, ',');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, tab);
        SSBORDSSchema.appendStringWithSpace(buffer, "p_url_mapping_pattern");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, this.addQuotes(schema.getORDSAliasNotEmpty(), true));
        SSBORDSSchema.appendStringWithSpace(buffer, ',');
        SSBORDSSchema.appendNewLine(buffer, prettyPrint, tab);
        SSBORDSSchema.appendStringWithSpace(buffer, "p_auto_rest_auth");
        SSBORDSSchema.appendStringWithSpace(buffer, "=>");
        SSBORDSSchema.appendString(buffer, schema.isORDSAuth() ? "TRUE" : "FALSE");
        SSBORDSSchema.appendString(buffer, ')');
        SSBORDSSchema.appendString(buffer, ';');
    }
}

