/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DimensionOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDimensionOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        DimensionOraclev9i dimension = (DimensionOraclev9i)object;
        this.storageDesign = dimension.getStorageDesign();
        this.appendComment(buffer, dimension);
        if (dimension.getLevelSet().length > 0) {
            this.appendCreate(buffer, dimension);
            advancedComment = buffer.toString();
            this.appendLevels(buffer, dimension, prettyPrint);
            this.appendHierarchies(buffer, dimension, prettyPrint);
            this.appendAttributes(buffer, dimension, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBDimensionOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBDimensionOraclev9i.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateDimension();
        } else {
            SSBDimensionOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid Dimension without Levels: " + dimension.getName());
            SSBDimensionOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBDimensionOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
    }

    private void appendCreate(StringBuffer buffer, DimensionOraclev9i dimension) {
        String uname;
        this.appendCreate(buffer);
        SSBDimensionOraclev9i.appendStringWithSpace(buffer, "DIMENSION");
        if (dimension.getUser() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL() && !"".equals(uname = dimension.getUser().getName())) {
            SSBDimensionOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(dimension.getUser()));
            SSBDimensionOraclev9i.appendString(buffer, '.');
        }
        SSBDimensionOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(dimension));
    }

    private void appendLevels(StringBuffer buffer, DimensionOraclev9i dimension, boolean prettyPrint) {
        Object[] levels = dimension.getLevelSet();
        for (int i = 0; i < levels.length; ++i) {
            LevelOracle level = (LevelOracle)levels[i];
            SSBDimensionOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            if (level.getColumnSet().size() > 0) {
                SSBDimensionOraclev9i.appendStringWithSpace(buffer, "LEVEL");
                SSBDimensionOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(level));
                SSBDimensionOraclev9i.appendStringWithSpace(buffer, "IS");
                if (level.getColumnSet().size() > 1) {
                    SSBDimensionOraclev9i.appendStringWithSpace(buffer, '(');
                }
                for (int j = 0; j < level.getColumnSet().size(); ++j) {
                    ColumnProxyOracle column = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy((String)level.getColumnSet().elementAt(j));
                    if (column == null) continue;
                    if (j > 0) {
                        this.appendComma(buffer);
                    }
                    SSBDimensionOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(column.getTableProxy()) + '.' + this.storageDesign.getFormatedName(column));
                }
                if (level.getColumnSet().size() <= 1) continue;
                SSBDimensionOraclev9i.appendStringWithSpace(buffer, ')');
                continue;
            }
            SSBDimensionOraclev9i.appendStringWithSpace(buffer, "--  ERROR: Invalid Level with no Columns: " + level.getName());
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendHierarchies(StringBuffer buffer, DimensionOraclev9i dimension, boolean prettyPrint) {
        Object[] hierarchies = dimension.getHierarchySet();
        for (int i = 0; i < hierarchies.length; ++i) {
            int j;
            HierarchyOracle h = (HierarchyOracle)hierarchies[i];
            if (h.getLevelSet().size() <= 0) continue;
            SSBDimensionOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBDimensionOraclev9i.appendStringWithSpace(buffer, "HIERARCHY");
            SSBDimensionOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(h));
            SSBDimensionOraclev9i.appendStringWithSpace(buffer, '(');
            for (j = 0; j < h.getLevelSet().size(); ++j) {
                LevelOracle level;
                if (j > 0) {
                    SSBDimensionOraclev9i.appendStringWithSpace(buffer, " CHILD OF ");
                }
                if ((level = (LevelOracle)dimension.getStorageDesignOracle().getLevelSet().getById((String)h.getLevelSet().get(j))) == null) continue;
                SSBDimensionOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBDimensionOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(level));
            }
            for (j = 0; j < h.getJoinSet().size(); ++j) {
                SSBDimensionOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                this.appendStringWithSpace(buffer, h.getJoinSet().elementAt(j));
            }
            SSBDimensionOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBDimensionOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendAttributes(StringBuffer buffer, DimensionOraclev9i dimension, boolean prettyPrint) {
        Object[] attributes = dimension.getAttributeSet();
        for (int i = 0; i < attributes.length; ++i) {
            DimensionAttributeOracle attr = (DimensionAttributeOracle)attributes[i];
            if (attr.getLevel() == null || attr.getColumnSet().size() <= 0) continue;
            SSBDimensionOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBDimensionOraclev9i.appendStringWithSpace(buffer, "ATTRIBUTE");
            SSBDimensionOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(attr.getLevel()));
            SSBDimensionOraclev9i.appendStringWithSpace(buffer, "DETERMINES");
            for (int j = 0; j < attr.getColumnSet().size(); ++j) {
                ColumnProxyOracle column;
                if (attr.getColumnSet().size() > 1 && j == 0) {
                    SSBDimensionOraclev9i.appendStringWithSpace(buffer, '(');
                }
                if ((column = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy((String)attr.getColumnSet().elementAt(j))) == null) continue;
                if (j > 0) {
                    this.appendComma(buffer);
                }
                SSBDimensionOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBDimensionOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
            }
            if (attr.getColumnSet().size() <= 1) continue;
            SSBDimensionOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBDimensionOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DimensionOraclev9i && ((DimensionOraclev9i)object).isMarkedGenerate();
    }
}

