/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k12;

import oracle.dbtools.crest.exports.ddl.sqlserver.SSBAutoIncrementColumnSqlServer;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k5.SSBTableSqlServerv2k5;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.ColumnProxySqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;

public class SSBTableSqlServerv2k12
extends SSBTableSqlServerv2k5 {
    private SSBAutoIncrementColumnSqlServer ssbAutoIncCol = null;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        this.appendAutoIncrementSequences(buffer, object, prettyPrint);
        super.doAppend(buffer, object, prettyPrint);
    }

    private void appendAutoIncrementSequences(StringBuffer buffer, Object object, boolean prettyPrint) {
        Table table = null;
        if (object instanceof Table) {
            table = (Table)object;
        } else if (object instanceof TableProxySqlServerv2k5) {
            table = (Table)((TableProxySqlServerv2k5)object).getObject();
        }
        for (Column column : table.getElementsCollection()) {
            if (!column.isAutoIncrementColumn()) continue;
            if (this.ssbAutoIncCol == null) {
                StorageDesignSqlServerv2k12 stoDes = (StorageDesignSqlServerv2k12)this.getStorageDesign(table);
                this.ssbAutoIncCol = new SSBAutoIncrementColumnSqlServer(stoDes);
            }
            this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint, false);
        }
    }

    @Override
    protected void appendColumns(StringBuffer buffer, Table table, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        super.appendColumns(buffer, table, tableProxy, prettyPrint);
    }

    @Override
    protected void appendDefault(StringBuffer buffer, ColumnProxySqlServer columnProxy) {
        Column column = columnProxy.getColumn();
        String defaultValue = columnProxy.getDefaultValue();
        if (column.isAutoIncrementColumn() && ((ColumnProxySqlServerv2k12)columnProxy).getDDLTypeForAutoIncCol().equalsIgnoreCase("DEFAULT_CLAUSE")) {
            if (this.ssbAutoIncCol == null) {
                StorageDesignSqlServer stoDes = (StorageDesignSqlServer)this.getStorageDesign(columnProxy);
                this.ssbAutoIncCol = new SSBAutoIncrementColumnSqlServer(stoDes);
            }
            defaultValue = "NEXT VALUE FOR " + this.ssbAutoIncCol.generateSequenceName(null, column, false);
        }
        if (!columnProxy.getDefineDefault() && defaultValue != null && !"".equals(defaultValue)) {
            SSBTableSqlServerv2k12.appendStringWithSpace(buffer, "DEFAULT");
            try {
                String dt = columnProxy.getColumn().getDatatypeString("SQL Server 2005");
                String df = this.addQuotesToDefault(dt, defaultValue);
                SSBTableSqlServerv2k12.appendStringWithSpace(buffer, df);
            }
            catch (Exception e) {
                SSBTableSqlServerv2k12.appendString(buffer, '\'');
                SSBTableSqlServerv2k12.appendString(buffer, columnProxy.getDefaultValue().trim());
                SSBTableSqlServerv2k12.appendStringWithSpace(buffer, '\'');
            }
        }
    }

    @Override
    protected void appendIdentity(StringBuffer buffer, ColumnProxySqlServerv2k5 columnProxy) {
        if (!(columnProxy instanceof ColumnProxySqlServerv2k12) || columnProxy instanceof ColumnProxySqlServerv2k12 && ((ColumnProxySqlServerv2k12)columnProxy).getDDLTypeForAutoIncCol().equalsIgnoreCase("IDENTITY_CLAUSE")) {
            super.appendIdentity(buffer, columnProxy);
        }
    }
}

