/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexSqlServerv2k5
extends AbstractSSBSqlServer {
    protected StorageDesignSqlServerv2k5 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Index index = null;
        IndexProxySqlServerv2k5 indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
            indexProxy = (IndexProxySqlServerv2k5)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxySqlServer) {
            indexProxy = (IndexProxySqlServerv2k5)object;
            index = (Index)indexProxy.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
        }
        if (indexProxy != null && indexProxy.isCommentChanged()) {
            this.appendComment(buffer, indexProxy);
        } else {
            this.appendComment(buffer, index);
        }
        if (indexProxy != null) {
            if (indexProxy.isMarkedGenerate()) {
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "CREATE");
                this.appendUnique(buffer, indexProxy);
                this.appendClustered(buffer, indexProxy);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "INDEX");
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(indexProxy));
                this.appendTable(buffer, indexProxy, prettyPrint);
                this.appendIncludeColumn(buffer, indexProxy, prettyPrint);
                this.appendOptions(buffer, indexProxy, prettyPrint);
                this.appendFilegroup(buffer, indexProxy, prettyPrint);
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "GO");
                DDLFileMaker.incrementCreateIndex();
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
                }
                this.appendExtProperties(buffer, indexProxy, prettyPrint);
            } else if (index.hasIndexExpression()) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getIndexExpression());
            } else {
                buffer.append("-- Index ").append(index.getName()).append(" on Table ").append(indexProxy.getTableName()).append(" not created in ddl");
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            }
        } else if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
        }
    }

    protected void appendIncludeColumn(StringBuffer buffer, IndexProxySqlServerv2k5 indexProxy, boolean prettyPrint) {
        if (!indexProxy.getIncludeColumns().equalsIgnoreCase("")) {
            boolean writeComma = false;
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "INCLUDE");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '(');
            Column[] columns = (Column[])indexProxy.getTable().getElements();
            for (int i = 0; i < columns.length; ++i) {
                if (!indexProxy.getIncludeColumnsSet().contains(columns[i].getObjectID())) continue;
                if (writeComma) {
                    this.appendComma(buffer);
                }
                this.appendStringWithSpace(buffer, columns[i]);
                writeComma = true;
            }
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendIndexComment(StringBuffer buffer, Index index, IndexProxySqlServer indexProxy, boolean prettyPrint) {
        String comment = null;
        String tableName = null;
        if (indexProxy != null && indexProxy.isCommentInRDBMSChanged()) {
            comment = indexProxy.getCommentInRDBMS();
            tableName = indexProxy.getTableProxy().getName();
        } else if (index != null) {
            comment = index.getCommentInRDBMS();
            tableName = index.getContainerObject().getName();
        }
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBIndexSqlServerv2k5.appendString(buffer, '\'');
            SSBIndexSqlServerv2k5.appendString(buffer, comment);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
            if (indexProxy != null && ((TableProxySqlServer)indexProxy.getTableProxy()).getSchema() != null) {
                SSBIndexSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBIndexSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBIndexSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexSqlServerv2k5.appendString(buffer, ((TableProxySqlServer)indexProxy.getTableProxy()).getSchema().getName());
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (indexProxy != null && ((TableProxySqlServer)indexProxy.getTableProxy()).getUser() != null) {
                SSBIndexSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexSqlServerv2k5.appendString(buffer, "USER");
                SSBIndexSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBIndexSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexSqlServerv2k5.appendString(buffer, ((TableProxySqlServer)indexProxy.getTableProxy()).getUser().getName());
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBIndexSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexSqlServerv2k5.appendString(buffer, "USER");
                SSBIndexSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBIndexSqlServerv2k5.appendString(buffer, '\'');
                SSBIndexSqlServerv2k5.appendString(buffer, "dbo");
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBIndexSqlServerv2k5.appendString(buffer, "'table'");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBIndexSqlServerv2k5.appendString(buffer, '\'');
            SSBIndexSqlServerv2k5.appendString(buffer, tableName);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBIndexSqlServerv2k5.appendString(buffer, "'index'");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBIndexSqlServerv2k5.appendString(buffer, '\'');
            SSBIndexSqlServerv2k5.appendString(buffer, index.getName());
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexSqlServerv2k5.appendString(buffer, "GO");
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendUnique(StringBuffer buffer, IndexProxySqlServerv2k5 index) {
        if (index.getUnique().equalsIgnoreCase("YES")) {
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "UNIQUE");
        }
    }

    protected void appendClustered(StringBuffer buffer, IndexProxySqlServerv2k5 index) {
        if (index.isClustered()) {
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "CLUSTERED");
        } else {
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "NONCLUSTERED");
        }
    }

    protected void appendTable(StringBuffer buffer, IndexProxy index, boolean prettyPrint) {
        SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
        SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index.getTableProxy()));
        SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '(');
        SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        if (index.getIndex().hasIndexExpression()) {
            SSBIndexSqlServerv2k5.appendString(buffer, ' ');
            SSBIndexSqlServerv2k5.appendString(buffer, index.getIndex().getIndexExpression());
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        }
        ColumnProxy[] columns = index.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            String sortorder = "";
            if (columns[i].getObject() != null) {
                sortorder = ((Index)index.getObject()).getColumnSortOrder(columns[i].getObject());
            }
            SSBIndexSqlServerv2k5.appendString(buffer, ' ');
            if ("DESC".equalsIgnoreCase(sortorder)) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()) + " " + sortorder);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()) + " ASC");
            } else {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
            }
            if (i != columns.length - 1) {
                this.appendComma(buffer);
            }
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ')');
    }

    protected void appendOptions(StringBuffer buffer, IndexProxySqlServerv2k5 index, boolean prettyPrint) {
        if ((index.getFillFactor() > 0 || index.getIgnoreDupKey().equalsIgnoreCase("YES") || index.getRecomputeStatistics().equalsIgnoreCase("OFF") || index.getSortInTempDB().equalsIgnoreCase("YES") || index.getAllowRowLocks().equalsIgnoreCase("OFF") || index.getAllowPageLocks().equalsIgnoreCase("OFF") || index.getDropExisting().equalsIgnoreCase("ON") || index.getOnlineChoise().equalsIgnoreCase("ON") || index.getMaxdop() > 0) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "WITH");
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '(');
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendSpace(buffer);
            boolean writeComma = false;
            if (index.getFillFactor() > 0) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "PAD_INDEX");
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                    this.appendComma(buffer);
                    SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexSqlServerv2k5.appendSpace(buffer);
                }
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getFillFactor());
                writeComma = true;
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "PAD_INDEX");
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                    this.appendComma(buffer);
                    SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexSqlServerv2k5.appendSpace(buffer);
                }
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "0");
                writeComma = true;
            }
            if (writeComma) {
                this.appendComma(buffer);
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexSqlServerv2k5.appendSpace(buffer);
            }
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "IGNORE_DUP_KEY");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            if (index.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            } else {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
            }
            this.appendComma(buffer);
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendSpace(buffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "STATISTICS_NORECOMPUTE");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            if (index.getRecomputeStatistics().equalsIgnoreCase("OFF")) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            } else {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
            }
            this.appendComma(buffer);
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendSpace(buffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "SORT_IN_TEMPDB");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            if (index.getSortInTempDB().equalsIgnoreCase("YES")) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            } else {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
            }
            this.appendComma(buffer);
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendSpace(buffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ALLOW_ROW_LOCKS");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getAllowRowLocks());
            this.appendComma(buffer);
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendSpace(buffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ALLOW_PAGE_LOCKS");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getAllowPageLocks());
            this.appendComma(buffer);
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendSpace(buffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "DROP_EXISTING");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getDropExisting());
            this.appendComma(buffer);
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendSpace(buffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ONLINE");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getOnlineChoise());
            this.appendComma(buffer);
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendSpace(buffer);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "MAXDOP");
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, Integer.toString(index.getMaxdop()));
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendString(buffer, ')');
        }
    }

    protected void appendFilegroup(StringBuffer buffer, IndexProxySqlServerv2k5 index, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (index.getPartitionScheme() != null) {
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getPartitionScheme().getName()));
                if (index.getPartitioningColumn() != null) {
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '(');
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getPartitioningColumn().getName()));
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ')');
                }
            } else if (index.getFilegroup() != null && index.getPartitionScheme() == null) {
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getFilegroup().getName()));
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                SSBIndexSqlServerv2k5.appendString(buffer, "\"default\"");
            }
        }
    }

    protected void appendExtProperties(StringBuffer buffer, IndexProxySqlServerv2k5 index, boolean prettyPrint) {
        if (!(index.getProps().trim().equalsIgnoreCase("") || ((TableProxySqlServer)index.getTableProxy()).getSchema() == null && ((TableProxySqlServer)index.getTableProxy()).getUser() == null)) {
            StringTokenizer st = new StringTokenizer(index.getProps().trim(), ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                String value = st.nextToken();
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, name);
                this.appendComma(buffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, value);
                this.appendComma(buffer);
                if (((TableProxySqlServer)index.getTableProxy()).getSchema() != null) {
                    SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "'schema'");
                    this.appendComma(buffer);
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(((TableProxySqlServer)index.getTableProxy()).getSchema().getName()));
                    this.appendComma(buffer);
                } else {
                    SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "'user'");
                    this.appendComma(buffer);
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(((TableProxySqlServer)index.getTableProxy()).getUser().getName()));
                    this.appendComma(buffer);
                }
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "'table'");
                this.appendComma(buffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getTableProxy().getName()));
                this.appendComma(buffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "'index'");
                this.appendComma(buffer);
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getName()));
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexSqlServerv2k5.appendString(buffer, "GO");
                SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxySqlServerv2k5 && ((TableProxySqlServerv2k5)((IndexProxySqlServerv2k5)object).getTableProxy()).getDatabase() != null && !((TableProxySqlServerv2k5)((IndexProxySqlServerv2k5)object).getTableProxy()).getDatabase().isNullInstance() && ((IndexProxy)object).isMarkedGenerate() && !((IndexProxySqlServerv2k5)object).isPrimaryXmlIndex();
    }

    public void appendIndexForConstraint(StringBuffer oldbuffer, Index object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Index index = null;
        IndexProxy indexProxy = null;
        index = object;
        StorageDesignSqlServerv2k5 storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
        if ("Primary Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxy)storageDesign.getPKProxySet().getProxy(index.getObjectID());
        } else if ("Unique Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxy)storageDesign.getUniqueProxySet().getProxy(index.getObjectID());
        } else if (index.isFK()) {
            indexProxy = (IndexProxy)storageDesign.getFKProxySet().getProxy(index.getObjectID());
        }
        if (index != null && !index.isOidKey() && indexProxy != null) {
            this.storageDesign = (StorageDesignSqlServerv2k5)indexProxy.getStorageDesign();
            if (indexProxy.isMarkedGenerate()) {
                if (index.getElements().length > 0) {
                    if (indexProxy.isCommentChanged()) {
                        this.appendComment(oldbuffer, indexProxy);
                    } else {
                        this.appendComment(oldbuffer, index);
                    }
                    TableProxy tp = indexProxy.getTableProxy();
                    String indName = indexProxy.getName();
                    String lname = indName = ApplyNamingStandards.createIndexNameAuto(tp.getName(), indName, index, index.getDesign().getDesignLevelSettings().getNamingStandardRule(), index.getDesignPart().getName(), index.getTable().getAbbreviation());
                    if (indName.length() > indexProxy.getMaxNameLength()) {
                        SSBIndexSqlServerv2k5.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBIndexSqlServerv2k5.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxy.getMaxNameLength() + ")");
                        SSBIndexSqlServerv2k5.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "CREATE");
                    if ("Primary Constraint".equals(index.getIndexState()) || "Unique Constraint".equals(index.getIndexState())) {
                        SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "UNIQUE");
                    }
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "INDEX");
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, storageDesign.getFormatedName(lname));
                    advancedComment = buffer.toString();
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                    SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(indexProxy.getTableProxy()));
                    this.appendConstraintElementList(buffer, index, indexProxy, true);
                    SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexSqlServerv2k5.appendNewLine(oldbuffer, prettyPrint, 0);
                    oldbuffer.append("-- Error - Index ");
                    oldbuffer.append(storageDesign.getFormatedName(index.getName()));
                    oldbuffer.append(" has no columns");
                    SSBIndexSqlServerv2k5.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer buffer, Index index, IndexProxy indexProxy, boolean prettyPrint) {
        ColumnProxy column = null;
        ColumnProxy[] columns = indexProxy.getColumnProxies();
        SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, "-- No Columns");
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, '(');
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            column = columns[i];
            SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexSqlServerv2k5.appendString(buffer, ' ');
            String columnName = this.storageDesign.getFormatedName(column.getName());
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, columnName);
            SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
        }
        SSBIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexSqlServerv2k5.appendStringWithSpace(buffer, ')');
    }
}

