/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k5.SSBIndexOnViewSqlServerv2k5;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexOnViewSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBViewSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesignSqlServerv2k5 storageDesign;
    private SSBIndexOnViewSqlServerv2k5 ssbIndex = new SSBIndexOnViewSqlServerv2k5();

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (this.ssbIndex.getStorageDesign() == null) {
            this.ssbIndex.setStorageDesign(this.getStorageDesign());
        }
        TableView view = null;
        TableViewProxySqlServerv2k5 proxy = null;
        if (object instanceof TableView) {
            view = (TableView)object;
            if (this.getStorageDesign(object) instanceof StorageDesignSqlServerv2k5) {
                this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
                proxy = (TableViewProxySqlServerv2k5)this.storageDesign.getProxy(view);
            }
        } else if (object instanceof TableViewProxySqlServerv2k5) {
            proxy = (TableViewProxySqlServerv2k5)object;
            view = (TableView)proxy.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
        }
        if (!view.isValidSQL()) {
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName());
            DDLFileMaker.incrementErrors();
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            return;
        }
        if (proxy != null) {
            if (!proxy.isMarkedGenerate()) {
                this.appendIndexes(buffer, proxy, prettyPrint);
                return;
            }
            if (!proxy.getDefinition().trim().equalsIgnoreCase("")) {
                int index;
                this.appendBeforeCreateScript(buffer, prettyPrint, view);
                if (proxy.isCommentChanged()) {
                    this.appendComment(buffer, proxy);
                } else {
                    this.appendComment(buffer, view);
                }
                String stmt = proxy.getDefinition();
                stmt = stmt.trim();
                if (stmt.endsWith(";")) {
                    stmt = stmt.substring(0, stmt.length() - 1).trim();
                }
                String createViewPart = "";
                boolean includesColumnList = false;
                if (Token.getFirstToken(stmt).equalsIgnoreCase("CREATE") && (index = StringUtilities.indexOf(stmt, "VIEW")) > -1) {
                    int viewNameIndex;
                    int dotIndex;
                    createViewPart = stmt.substring(0, index + 4);
                    String stmtWithoutNL = (stmt = stmt.substring(index + 4).trim()).replaceAll("[\t\n\f\r\u000b]+", " ");
                    String oldViewName = Token.getFirstName(stmtWithoutNL, '\"', '\"');
                    int bracketIndex = oldViewName.indexOf(40);
                    if (bracketIndex > -1) {
                        oldViewName = oldViewName.substring(0, bracketIndex);
                    }
                    if ((dotIndex = oldViewName.indexOf(46)) > -1) {
                        oldViewName = oldViewName.substring(dotIndex + 1);
                    }
                    if ((viewNameIndex = stmt.indexOf(oldViewName, dotIndex)) > -1 && (stmt = stmt.substring(viewNameIndex + oldViewName.length())).startsWith("\"")) {
                        stmt = stmt.substring(1);
                    }
                    if ((stmt = stmt.trim()).toUpperCase().startsWith("AS")) {
                        stmt = stmt.substring(2).trim();
                    } else if (stmt.startsWith("(")) {
                        includesColumnList = true;
                    }
                }
                if (!Token.startsWithString(createViewPart, "CREATE")) {
                    createViewPart = "CREATE VIEW";
                }
                String longName = this.storageDesign.isOpen() ? proxy.getLongNameDDL() : view.getName();
                createViewPart = createViewPart + ' ' + this.storageDesign.getFormatedName(longName) + this.appendWithOptions(proxy);
                if (includesColumnList) {
                    stmt = createViewPart + ' ' + stmt;
                } else {
                    String columnList = this.getColumnList(view);
                    stmt = createViewPart + ' ' + columnList + ' ' + "AS" + ' ' + NEWLINE + stmt;
                }
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, stmt);
                if (proxy.getCheckOption() && buffer.indexOf("WITH CHECK OPTION") == -1) {
                    SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBViewSqlServerv2k5.appendString(buffer, "WITH CHECK OPTION");
                }
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBViewSqlServerv2k5.appendString(buffer, "GO");
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementCreateView();
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                this.appendAfterCreateScript(buffer, prettyPrint, view);
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                this.appendAlter(buffer, proxy, prettyPrint);
                if (view.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendViewComment(buffer, view, proxy, prettyPrint);
                }
                this.appendExtProperties(buffer, proxy, prettyPrint);
                this.appendIndexes(buffer, proxy, prettyPrint);
            } else {
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName() + " with empty body");
                DDLFileMaker.incrementErrors();
            }
        } else {
            this.appendComment(buffer, view);
            DDLFileMaker.incrementErrors();
        }
    }

    private String appendWithOptions(TableViewProxySqlServerv2k5 proxy) {
        String withOptions = " WITH";
        boolean withFlag = false;
        if (proxy.getEncryption().equalsIgnoreCase("YES")) {
            withOptions = withOptions + ' ' + "ENCRYPTION";
            withFlag = true;
        }
        if (proxy.getSchemaBinding().equalsIgnoreCase("YES")) {
            withOptions = withOptions + ' ' + "SCHEMABINDING";
            withFlag = true;
        }
        if (proxy.getViewMetaData().equalsIgnoreCase("YES")) {
            withOptions = withOptions + ' ' + "VIEW_METADATA";
            withFlag = true;
        }
        return withFlag ? withOptions : "";
    }

    private void appendIndexes(StringBuffer buffer, TableViewProxySqlServerv2k5 proxy, boolean prettyPrint) {
        IndexOnViewSqlServerv2k5 index;
        boolean uniqueClusteredFound = false;
        for (Object object : proxy.getIndexesOnView()) {
            if (!(object instanceof IndexOnViewSqlServerv2k5) || !(index = (IndexOnViewSqlServerv2k5)object).getUnique().equalsIgnoreCase("YES") || !index.getClustered().equalsIgnoreCase("YES")) continue;
            this.ssbIndex.doAppend(buffer, object, prettyPrint);
            uniqueClusteredFound = true;
        }
        for (Object object : proxy.getIndexesOnView()) {
            if (!(object instanceof IndexOnViewSqlServerv2k5) || (index = (IndexOnViewSqlServerv2k5)object).getUnique().equalsIgnoreCase("YES") && index.getClustered().equalsIgnoreCase("YES")) continue;
            if (uniqueClusteredFound) {
                this.ssbIndex.doAppend(buffer, object, prettyPrint);
                continue;
            }
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "--  ERROR: Missing Index on View " + proxy.getName() + " : a unique clustered index must be created on the view before the nonclustered index " + index.getName() + " can be created");
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    protected String appendOwner(String definition, TableViewProxySqlServerv2k5 view) {
        String result = definition;
        String name = Token.getTokenAfter(result, "VIEW");
        if (name.indexOf(46) == -1 && view.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            String owner = this.storageDesign.getFormatedName(view.getSchema().getName());
            result = this.appendOwner(result, name, owner);
        }
        return result;
    }

    protected void appendViewComment(StringBuffer buffer, TableView view, TableViewProxySqlServerv2k5 proxy, boolean prettyPrint) {
        String comment = null;
        String viewName = null;
        if (proxy != null && proxy.isCommentInRDBMSChanged()) {
            comment = proxy.getCommentInRDBMS();
            viewName = proxy.getName();
        } else if (view != null) {
            comment = view.getCommentInRDBMS();
            viewName = view.getName();
        }
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k5.appendString(buffer, '\'');
            SSBViewSqlServerv2k5.appendString(buffer, comment);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            if (proxy != null && proxy.getSchema() != null) {
                SSBViewSqlServerv2k5.appendString(buffer, '\'');
                SSBViewSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k5.appendString(buffer, '\'');
                SSBViewSqlServerv2k5.appendString(buffer, proxy.getSchema().getName());
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (proxy != null && proxy.getUser() != null) {
                SSBViewSqlServerv2k5.appendString(buffer, '\'');
                SSBViewSqlServerv2k5.appendString(buffer, "USER");
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k5.appendString(buffer, '\'');
                SSBViewSqlServerv2k5.appendString(buffer, proxy.getUser().getName());
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBViewSqlServerv2k5.appendString(buffer, '\'');
                SSBViewSqlServerv2k5.appendString(buffer, "USER");
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k5.appendString(buffer, '\'');
                SSBViewSqlServerv2k5.appendString(buffer, "dbo");
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBViewSqlServerv2k5.appendString(buffer, '\'');
            SSBViewSqlServerv2k5.appendString(buffer, "VIEW");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k5.appendString(buffer, '\'');
            SSBViewSqlServerv2k5.appendString(buffer, viewName);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k5.appendString(buffer, "GO");
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
        ContainedObject[] elements = null;
        TableView tbView = null;
        if (proxy != null) {
            tbView = (TableView)proxy.getObject();
            elements = tbView.getElements();
        } else if (view != null) {
            tbView = view;
            elements = tbView.getElements();
        }
        if (elements != null && tbView != null) {
            for (int i = 0; i < elements.length; ++i) {
                ContainedObject desObj = elements[i];
                if (desObj.getCommentInRDBMS() == null) continue;
                this.appendViewElementComment(buffer, desObj, tbView, prettyPrint);
            }
        }
    }

    private void appendExtProperties(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableViewProxySqlServerv2k5 viewProxySqlServer = (TableViewProxySqlServerv2k5)object;
        if (!("".equalsIgnoreCase(viewProxySqlServer.getProps()) || viewProxySqlServer.getSchema() == null && viewProxySqlServer.getUser() == null)) {
            int i = 0;
            while (i < viewProxySqlServer.getExtPropsSet().size() - 1) {
                String name = '\'' + (String)viewProxySqlServer.getExtPropsSet().get(i) + '\'';
                String value = '\'' + (String)viewProxySqlServer.getExtPropsSet().get(++i) + '\'';
                ++i;
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
                String props = name + ", " + value;
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, props);
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                if (viewProxySqlServer.getSchema() != null) {
                    SSBViewSqlServerv2k5.appendString(buffer, '\'');
                    SSBViewSqlServerv2k5.appendString(buffer, "SCHEMA");
                    SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBViewSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(viewProxySqlServer.getSchema().getName()));
                    SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                } else {
                    SSBViewSqlServerv2k5.appendString(buffer, '\'');
                    SSBViewSqlServerv2k5.appendString(buffer, "USER");
                    SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBViewSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(viewProxySqlServer.getUser().getName()));
                    SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                }
                SSBViewSqlServerv2k5.appendString(buffer, '\'');
                SSBViewSqlServerv2k5.appendString(buffer, "VIEW");
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(viewProxySqlServer.getName()));
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBViewSqlServerv2k5.appendString(buffer, "GO");
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableViewProxySqlServerv2k5 && ((TableViewProxySqlServerv2k5)object).getDataBase() != null && !((TableViewProxySqlServerv2k5)object).getDataBase().isNullInstance();
    }

    protected void appendColumns(StringBuffer buffer, TableView view, TableViewProxySqlServerv2k5 tableViewProxy, boolean prettyPrint) {
        ColumnView[] columns = (ColumnView[])view.getElements();
        SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBViewSqlServerv2k5.appendString(buffer, "-- No columns");
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        } else {
            for (int i = 0; i < columns.length; ++i) {
                if (i == 0) {
                    SSBViewSqlServerv2k5.appendString(buffer, '(');
                } else {
                    buffer.append(", ");
                }
                SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                if (tableViewProxy == null) continue;
                if (!columns[i].getAlias().equalsIgnoreCase("")) {
                    SSBViewSqlServerv2k5.appendStringWithSpace(buffer, columns[i].getAlias());
                    continue;
                }
                SSBViewSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
            }
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k5.appendString(buffer, ')');
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    protected void appendAlter(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableViewProxySqlServerv2k5 viewProxySqlServer = (TableViewProxySqlServerv2k5)object;
        if (viewProxySqlServer.getDataBase() != null && !viewProxySqlServer.getDataBase().isNullInstance() && viewProxySqlServer.getIndexesOnView() != null && !viewProxySqlServer.getIndexesOnView().isEmpty()) {
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "ALTER");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "DATABASE");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(viewProxySqlServer.getDataBase().getName()));
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "SET");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "ARITHABORT");
            SSBViewSqlServerv2k5.appendString(buffer, "ON");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "CONCAT_NULL_YIELDS_NULL");
            SSBViewSqlServerv2k5.appendString(buffer, "ON");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "QUOTED_IDENTIFIER");
            SSBViewSqlServerv2k5.appendString(buffer, "ON");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "ANSI_NULLS");
            SSBViewSqlServerv2k5.appendString(buffer, "ON");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "ANSI_PADDING");
            SSBViewSqlServerv2k5.appendString(buffer, "ON");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "ANSI_WARNINGS");
            SSBViewSqlServerv2k5.appendString(buffer, "ON");
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k5.appendStringWithSpace(buffer, "NUMERIC_ROUNDABORT");
            SSBViewSqlServerv2k5.appendString(buffer, "OFF");
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k5.appendString(buffer, "GO");
            SSBViewSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }
}

