/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.oracleaw;

import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.AWAction.BuildDatabase;
import oracle.AWAction.Interaction;
import oracle.AWXML.Level;
import oracle.AWXML.Measure;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.oracleaw.AWExportOptions;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.multidimensional.BaseExample11g;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.jdbc.driver.OracleConnection;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.deployment.AWAttributeOrganization;
import oracle.olapi.metadata.deployment.AWCubeOrganization;
import oracle.olapi.metadata.deployment.AWPrimaryDimensionOrganization;
import oracle.olapi.metadata.mapping.AttributeMap;
import oracle.olapi.metadata.mapping.CubeDimensionalityMap;
import oracle.olapi.metadata.mapping.CubeMap;
import oracle.olapi.metadata.mapping.HierarchyLevelMap;
import oracle.olapi.metadata.mapping.MeasureMap;
import oracle.olapi.metadata.mapping.MemberListMap;
import oracle.olapi.metadata.mapping.SolvedValueHierarchyMap;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmDerivedMeasure;
import oracle.olapi.metadata.mdm.MdmDescriptionType;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmDimensionality;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmOrganizationalSchema;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmRootSchema;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmTable;
import oracle.olapi.metadata.mdm.MdmTimeDimension;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;
import oracle.olapi.syntax.AggregationCommand;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.ConsistentSolveSpecification;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SymmetricCondition;
import oracle.olapi.syntax.SymmetricConditionElement;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValueComparisonCondition;

public class OracleAW11Exporter
extends BaseExample11g {
    public static String EXPORT_RECREATE_AW = Messages.getString("OracleAWExporter.0");
    public static String EXPORT_METADATA_TO_FILE = Messages.getString("OracleAWExporter.1");
    public static String EXPORT_NEW_CALC_MEASURES = Messages.getString("OracleAWExporter.2");
    public static String EXPORT_ALL_CALC_MEASURES = Messages.getString("OracleAWExporter.3");
    public static String[] EXPORT_TYPES = new String[]{EXPORT_RECREATE_AW, EXPORT_NEW_CALC_MEASURES, EXPORT_ALL_CALC_MEASURES, EXPORT_METADATA_TO_FILE};
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(OracleAW11Exporter.class);
    private MultidimensionalDesign mdmDesign;
    private MultidimensionalDesign tmdmDesign;
    private String schema = "GLOBAL";
    private String exportType = EXPORT_NEW_CALC_MEASURES;
    private StorageDesign storDesign;
    private RelationalDesign physDesign;
    private RelationalDesign tphysDesign;
    private Connection connection;
    private String connectString = "";
    private String user = null;
    private String awName = "test1";
    private AW globalAW;
    private Map dimMap;
    private Map hierMap;
    private Map awdimMap;
    private Map dimensionalityMap;
    Vector _keys = new Vector(0);
    Vector _cols = new Vector(0);
    List _levels = new ArrayList();
    Vector _levColumns = new Vector(0);
    Vector _dimList = new Vector(0);
    Vector _measures = new Vector(0);
    Vector _measCols = new Vector(0);
    private boolean valid = true;
    private boolean warning = false;
    private StringBuffer validationSB;
    private StringBuffer warningsSB;
    private List globMeas = new ArrayList();
    private ProgressDialog monitor;
    private Interaction curInteraction;
    private String fileName;
    private boolean buildAW = false;
    private Map measMap = new TreeMap();
    private boolean validated = false;
    private String LD_NAME = "Long_Description";
    private String SD_NAME = "Short_Description";
    private String END_DATE_NAME = "End_Date";
    private String TIME_SPAN_NAME = "Time_Span";
    private String err;
    private Design design;
    private DataProvider dp = null;
    private MdmDatabaseSchema mdmDBSchema = null;
    private MdmMetadataProvider metadataProvider = null;
    boolean atached = false;
    boolean created = false;
    boolean commited = false;
    List selectedObjects;
    List globLevDesc = new ArrayList();
    boolean validTimeDim = true;
    Map awdimTOdim = new TreeMap();
    Map awdimTOrollupLink = new TreeMap();
    Map levMap = new TreeMap();
    MdmDescriptionType mdmShortDescrDescrType = MdmDescriptionType.getShortDescriptionDescriptionType();
    MdmDescriptionType mdmDescDescType = MdmDescriptionType.getDescriptionDescriptionType();
    private List sortedMeasures = new ArrayList();
    private List tracedMeasures = new ArrayList();
    List measureDependencies;
    boolean cyclicRef = false;
    boolean error = false;
    StringBuffer eb = new StringBuffer();
    private boolean overwrite = false;
    private Map awmeasToMeasure = new TreeMap();
    private Map awmeasMap = new TreeMap();
    private Map additionalAWMeasures = new TreeMap();
    private Map oldNewMap = new TreeMap();
    private List exportedMeasures = new ArrayList();
    private List exportedFolders = new ArrayList();
    private List awMeasureFolders = new ArrayList();

    public OracleAW11Exporter(ApplicationView appView) {
        this.appView = appView;
        this.design = appView.getCurrentDesign();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() {
        this.warningsSB = new StringBuffer("  There are warnings generated during validation phase:\n\n");
        this.validationSB = new StringBuffer("  There are errors during validation phase!\n\n");
        this.mdmDesign = this.tmdmDesign = this.design.getMultidimensionalDesign();
        this.physDesign = this.tphysDesign = this.design.getRelationalDesign();
        if (this.design.getMultidimensionalDesigns().size() == 1 && this.design.getRelationalDesigns().size() == 1) {
            this.validate();
        }
        if (this.valid) {
            AWExportOptions cve;
            boolean result;
            if (this.validated && this.warning) {
                LogReport lr = new LogReport(this.appView);
                lr.setName("Validation Log");
                lr.setLog(this.warningsSB.toString());
                lr.showModalDialog(new Dimension(750, 550));
            }
            if (result = (cve = new AWExportOptions(this.getApplicationView())).showDialog()) {
                this.mdmDesign = cve.getMultidimensionalDesign();
                this.schema = cve.getSchema().toUpperCase();
                this.storDesign = cve.getStorageDesign();
                this.physDesign = cve.getPhysicalDesign();
                this.connection = cve.getConnection();
                this.awName = cve.getAWName().toUpperCase();
                this.buildAW = cve.isPopulateCubes();
                this.buildAW = false;
                this.exportType = cve.getExportMode();
                this.fileName = cve.getFileName();
                this.selectedObjects = cve.getSelectedObjects();
                if (this.mdmDesign != null) {
                    if (!this.validated) {
                        this.validate();
                    }
                    if (this.valid && this.connection instanceof OracleConnection) {
                        String userName;
                        try {
                            Properties prop = cve.getSelectedConnectionProperties();
                            prop.put("url", prop.get("customUrl"));
                            this.initialize(prop, (OracleConnection)this.connection);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        this.dp = this.getContext().getDataProvider();
                        this.connection = this.dp.getConnection();
                        if ("".equals(this.schema)) {
                            try {
                                this.schema = this.connection.getMetaData().getUserName();
                            }
                            catch (SQLException e1) {
                                // empty catch block
                            }
                        }
                        if ((userName = this.getContext().getUser()) == null) {
                            try {
                                userName = this.connection.getMetaData().getUserName();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        this.metadataProvider = this.dp.getMdmMetadataProvider();
                        MdmRootSchema mdmRootSchema = (MdmRootSchema)this.metadataProvider.getRootSchema();
                        this.mdmDBSchema = mdmRootSchema.getDatabaseSchema(userName);
                        try {
                            this.run();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        LogReport lr = new LogReport(this.appView);
                        lr.setName("Validation Log");
                        if (this.warning) {
                            lr.setLog(this.validationSB.toString() + "\n\n" + this.warningsSB.toString());
                        } else {
                            lr.setLog(this.validationSB.toString());
                        }
                        lr.setLog(this.validationSB.toString());
                        lr.showDialog(new Dimension(750, 550));
                    }
                }
            }
        } else {
            LogReport lr = new LogReport(this.appView);
            lr.setName("Validation Log");
            if (this.warning) {
                lr.setLog(this.validationSB.toString() + "\n\n" + this.warningsSB.toString());
            } else {
                lr.setLog(this.validationSB.toString());
            }
            lr.showDialog(new Dimension(750, 550));
        }
    }

    private void validate() {
        Iterator it = this.mdmDesign.getLevelSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)it.next();
            this.validateLevel(level);
        }
        it = this.mdmDesign.getDimensionSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)it.next();
            this.validateDimension(dim);
        }
        it = this.mdmDesign.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            this.validateCube(cube);
        }
    }

    private void createAW() {
        this.addDimensions();
    }

    private boolean validConnection() {
        try {
            int atIndex = this.connectString.indexOf(64);
            if (atIndex >= 0) {
                this.connectString = this.connectString.substring(atIndex + 1);
            }
            System.out.println("Connecting to " + this.connectString);
            if (!(this.connection instanceof oracle.jdbc.OracleConnection)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            System.out.println("Error connecting to " + this.connectString + ".\n" + e);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorConnectingTo"), this.connectString) + e.getLocalizedMessage(), Messages.getString("OracleAWExporter.Error"), 0);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private AW getAW(List list, String name) {
        for (AW aw : list) {
            if (!aw.getName().equalsIgnoreCase(name)) continue;
            return aw;
        }
        return null;
    }

    private boolean deleteExistingAW(oracle.jdbc.OracleConnection connection, String user, String awName) {
        try {
            System.out.println("Deleting " + user + "." + awName + " if it exists.");
            List list = this.mdmDBSchema.getAWs();
            AW aw = this.getAW(list, awName);
            if (aw == null) {
                return true;
            }
            this.mdmDBSchema.removeAW(aw, true);
            this.dp.getTransactionProvider().commitCurrentTransaction();
            System.out.println("Deleted " + user + "." + awName + ".");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            String err = e.toString();
            String descr = "";
            if (err.indexOf("ORA-33276") > -1) {
                descr = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceAttached"), user, awName);
                this.dp.getTransactionProvider().rollbackCurrentTransaction();
                this.atached = true;
            } else {
                if (err.indexOf("ORA-33262") > -1) {
                    return true;
                }
                descr = err;
            }
            System.out.println(descr);
            return false;
        }
    }

    private boolean readAWDefinitions(String user, String awName) {
        try {
            this.globalAW = this.mdmDBSchema.findOrCreateAW(awName);
        }
        catch (Exception e) {
            String err = e.toString();
            String descr = "";
            if (err.indexOf("ORA-33276") > -1) {
                descr = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceAttached"), user, awName);
                this.atached = true;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), descr, Messages.getString("OracleAWExporter.Error"), 0);
            } else if (err.indexOf("ORA-33262") > -1) {
                descr = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceDoesntExist"), user, awName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), descr, Messages.getString("OracleAWExporter.Error"), 0);
            } else if (err.indexOf("ORA-34344") > -1) {
                descr = MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceDoesntExistOrAttached"), user, awName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), descr, Messages.getString("OracleAWExporter.Error"), 0);
            } else {
                descr = err;
            }
            System.out.println(descr);
            LOGGER.error("Error in reading Analytic Workspace definitions: ", e);
            return false;
        }
        return true;
    }

    private ModelIDObject getCorrespondentObject(ModelIDObject object) {
        if (object != null) {
            if (this.storDesign != null) {
                if (object instanceof Entity) {
                    Table tab = ((Entity)object).getEngTable(this.physDesign);
                    if (tab != null) {
                        TableProxy tp = (TableProxy)this.storDesign.getTableProxySet().getProxy(tab.getObjectID());
                        return tp;
                    }
                } else if (object instanceof Attribute) {
                    ContainedObject column = ((Attribute)object).getEngColumn(this.physDesign);
                    if (column != null) {
                        return this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
                    }
                } else {
                    if (object instanceof EntityView) {
                        TableView tabv = ((EntityView)object).getEngTableView(this.physDesign);
                        if (tabv == null) {
                            return object;
                        }
                        return this.storDesign.getTableViewProxySet().getObjectByID(tabv.getObjectID());
                    }
                    if (object instanceof AttributeView) {
                        ColumnView column = ((AttributeView)object).getEngColumnView(this.physDesign);
                        if (column == null) {
                            return object;
                        }
                        return column;
                    }
                    if (object instanceof Column) {
                        return this.storDesign.getColumnProxySet().getProxy(object.getObjectID());
                    }
                    if (object instanceof ColumnView) {
                        return object;
                    }
                    if (object instanceof Table) {
                        return this.storDesign.getTableProxySet().getProxy(object.getObjectID());
                    }
                    if (object instanceof TableView) {
                        return this.storDesign.getTableViewProxySet().getProxy(object.getObjectID());
                    }
                }
            } else {
                if (object instanceof Entity) {
                    Table tab = ((Entity)object).getEngTable(this.physDesign);
                    if (tab == null) {
                        return object;
                    }
                    return tab;
                }
                if (object instanceof Attribute) {
                    ContainedObject column = ((Attribute)object).getEngColumn(this.physDesign);
                    if (column == null) {
                        return object;
                    }
                    return column;
                }
                if (object instanceof EntityView) {
                    TableView tabv = ((EntityView)object).getEngTableView(this.physDesign);
                    if (tabv == null) {
                        return object;
                    }
                    return tabv;
                }
                if (object instanceof AttributeView) {
                    ColumnView column = ((AttributeView)object).getEngColumnView(this.physDesign);
                    if (column == null) {
                        return object;
                    }
                    return column;
                }
                if (object instanceof DesignObject && ((DesignObject)object).getDesignPart() instanceof RelationalDesign) {
                    return object;
                }
            }
        }
        return object;
    }

    private String getSchema(ModelIDObject object) {
        String res = null;
        if (object != null) {
            if (object instanceof TableProxy) {
                res = this.getSchemaImplementation((TableProxy)object);
            } else if (object instanceof Entity) {
                ModelIDObject cobj = this.getCorrespondentObject(object);
                if (cobj instanceof TableProxy) {
                    res = this.getSchemaImplementation((TableProxy)cobj);
                } else if (cobj instanceof Table && ((Table)cobj).getSchemaObject() != null) {
                    return ((Table)cobj).getSchemaObject().getName().toUpperCase();
                }
            } else if (object instanceof ContainedObject) {
                ModelIDObject cobj = this.getCorrespondentObject(((ContainedObject)object).getContainer());
                if (cobj instanceof TableProxy) {
                    res = this.getSchemaImplementation((TableProxy)cobj);
                }
            } else if (object instanceof CalculatedAttribute) {
                ModelIDObject cobj = this.getCorrespondentObject(((CalculatedAttribute)object).getLevel().getLevelEntity());
                if (cobj instanceof TableProxy) {
                    res = this.getSchemaImplementation((TableProxy)cobj);
                }
            } else if (object instanceof EntityView) {
                ModelIDObject cobj = this.getCorrespondentObject(object);
                if (cobj instanceof TableViewProxy) {
                    res = this.getSchemaImplementation((TableViewProxy)cobj);
                } else if (cobj instanceof TableView && ((TableView)cobj).getSchemaObject() != null) {
                    return ((TableView)cobj).getSchemaObject().getName().toUpperCase();
                }
            } else if (object instanceof Table) {
                if (this.storDesign != null && this.storDesign.isOpen()) {
                    TableProxy tp = (TableProxy)this.storDesign.getTableProxySet().getObjectByID(object.getObjectID());
                    if (tp != null) {
                        res = this.getSchemaImplementation(tp);
                    }
                } else {
                    res = ((Table)object).getSchema();
                }
            } else if (object instanceof TableView) {
                if (this.storDesign != null && this.storDesign.isOpen()) {
                    TableViewProxy tp = (TableViewProxy)this.storDesign.getTableViewProxySet().getObjectByID(object.getObjectID());
                    if (tp != null) {
                        res = this.getSchemaImplementation(tp);
                    }
                } else {
                    res = ((TableView)object).getSchema();
                }
            }
            if (res != null && !"".equals(res)) {
                return res;
            }
        }
        return this.schema.toUpperCase();
    }

    private String getSchemaImplementation(TableProxy tp) {
        StorageObject sto = tp.getUserSchema();
        if (sto != null) {
            return sto.getName();
        }
        String sch = tp.getSchemaImplementationName();
        if (!"".equals(sch)) {
            return sch;
        }
        return null;
    }

    private String getSchemaImplementation(TableViewProxy tp) {
        StorageObject sto = tp.getUserSchema();
        if (sto != null) {
            return sto.getName();
        }
        SchemaObject scho = ((TableView)tp.getObject()).getSchemaObject();
        String sch = tp.getStorageDesign().getSchemaImplementationNane(scho);
        if (!"".equals(sch)) {
            return sch;
        }
        return null;
    }

    public void clearCubeMapVectors() {
        this._measures.removeAllElements();
        this._measCols.removeAllElements();
        this._levels.clear();
        this._cols.removeAllElements();
        this._dimList.removeAllElements();
    }

    private Query getCubeQuery(Cube cube) {
        ContainerObject cob = cube.getFactEntity();
        if (cob != null) {
            ModelIDObject fact = this.getCorrespondentObject(cob);
            String name = fact.getLongName();
            MdmObject table = null;
            try {
                table = this.metadataProvider.getMetadataObject(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (table != null && table instanceof MdmTable) {
                return ((MdmTable)table).getQuery();
            }
        }
        return null;
    }

    private Query getLevelQuery(oracle.dbtools.crest.model.design.multidimensional.Level level) {
        ContainerObject cob = level.getLevelEntity();
        if (cob != null) {
            ModelIDObject fact = this.getCorrespondentObject(cob);
            String name = fact.getLongName();
            MdmObject table = null;
            try {
                table = this.metadataProvider.getMetadataObject(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (table != null && table instanceof MdmTable) {
                return ((MdmTable)table).getQuery();
            }
        }
        return null;
    }

    public void associateCubeDimensions(Cube cube, CubeMap cubeMap, MdmCube awcube, List _dimList, List levels, List rlinks) {
        Query query = this.getCubeQuery(cube);
        if (query != null) {
            cubeMap.setQuery(query);
        }
        for (int i = 0; i < _dimList.size(); ++i) {
            MdmHierarchy mdmDefHier;
            String expr;
            MdmPrimaryDimension dim = (MdmPrimaryDimension)_dimList.get(i);
            MdmDimensionality mdim = awcube.addDimension((MdmDimension)dim);
            this.dimensionalityMap.put(dim.getName(), mdim);
            LevelDesc ldesc = (LevelDesc)levels.get(i);
            if (ldesc.level == null) continue;
            RollupLink rlink = (RollupLink)rlinks.get(i);
            List left = rlink.getChildToParentAttributes();
            List right = ldesc.level.getLevelKey();
            Expression fkEspr = null;
            CubeDimensionalityMap cdm = null;
            if (left.size() == right.size() && (expr = this.getExpression(left)) != null) {
                fkEspr = (Expression)SyntaxObject.fromSyntax((String)expr, (MdmMetadataProvider)this.metadataProvider);
            }
            if (fkEspr != null) {
                cdm = cubeMap.findOrCreateCubeDimensionalityMap(mdim);
                cdm.setExpression(fkEspr);
            } else if (left.size() > 0 && right.size() > 0) {
                ContainedObject kattr = (ContainedObject)right.get(0);
                ContainedObject pattr = (ContainedObject)left.get(0);
                ModelIDObject corobj = this.getCorrespondentObject(kattr);
                ModelIDObject pcorobj = this.getCorrespondentObject(pattr);
                if (corobj != null && pcorobj != null) {
                    String kcolname = this.getSchema(kattr) + "." + corobj.getLongName(false);
                    String pcolname = this.getSchema(pattr) + "." + pcorobj.getLongName(false);
                    Expression parent = (Expression)SyntaxObject.fromSyntax((String)pcolname, (MdmMetadataProvider)this.metadataProvider);
                    Expression key = (Expression)SyntaxObject.fromSyntax((String)kcolname, (MdmMetadataProvider)this.metadataProvider);
                    if (key instanceof ColumnExpression && parent instanceof ColumnExpression) {
                        ValueComparisonCondition joinCond = new ValueComparisonCondition((TypedExpression)((ColumnExpression)parent), "=", (TypedExpression)((ColumnExpression)key));
                        cdm = cubeMap.findOrCreateCubeDimensionalityMap(mdim);
                        cdm.setExpression(parent);
                    }
                }
            }
            if (cdm == null || !((mdmDefHier = dim.getDefaultHierarchy()) instanceof MdmLevelHierarchy)) continue;
            MdmLevelHierarchy mdmLevHier = (MdmLevelHierarchy)mdmDefHier;
            List levHierList = mdmLevHier.getHierarchyLevels();
            MdmHierarchyLevel leafLevel = (MdmHierarchyLevel)levHierList.get(levHierList.size() - 1);
            cdm.setMappedDimension((MdmDimension)leafLevel);
        }
    }

    private void addDimensions() {
        this.awdimTOdim.clear();
        ArrayList mlist = new ArrayList();
        Iterator it = this.mdmDesign.getDimensionSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)it.next();
            this.addDimension(dim, dim.getName());
        }
        for (AWExportOptions.SelObject so : this.selectedObjects) {
            if (so.object instanceof Cube && so.selected) {
                Cube cube = (Cube)so.object;
                this.clearCubeMapVectors();
                String cname = cube.getName().replaceAll(" ", "_").toUpperCase();
                MdmCube awcube = this.mdmDBSchema.findOrCreateCube(cname);
                awcube.setDescription(cube.getOracleLongName());
                awcube.setShortDescription(cube.getOracleShortName());
                cube.setNameInOracleAW(awcube.getName());
                ArrayList<MdmPrimaryDimension> dimList = new ArrayList<MdmPrimaryDimension>();
                ArrayList<LevelDesc> levels = new ArrayList<LevelDesc>();
                ArrayList<RollupLink> links = new ArrayList<RollupLink>();
                for (RollupLink rlink : cube.getRollupLinks()) {
                    links.add(rlink);
                    oracle.dbtools.crest.model.design.multidimensional.Dimension dim = rlink.getDimension();
                    if (dim == null) continue;
                    MdmPrimaryDimension awdim = null;
                    awdim = rlink.isRolePlaying() ? this.addDimension(dim, rlink.getName() + "_" + dim.getName()) : (MdmPrimaryDimension)this.dimMap.get(dim.getObjectID());
                    if (awdim != null) {
                        this.awdimTOrollupLink.put(awdim.getName(), rlink);
                    }
                    dimList.add(awdim);
                    oracle.dbtools.crest.model.design.multidimensional.Level level = null;
                    if (dim.getBaseLevel() == null) continue;
                    level = dim.getBaseLevel();
                    LevelDesc ldesc = this.getLevelDesc(this.globLevDesc, level, awdim);
                    if (level.isValueBasedHierarchy()) {
                        if (ldesc != null) {
                            ldesc.olevel = null;
                        } else {
                            ldesc = new LevelDesc();
                            ldesc.olevel = null;
                            ldesc.odimension = awdim;
                        }
                    }
                    if (ldesc == null) continue;
                    ldesc.odimension = awdim;
                    ldesc.dim = dim;
                    ldesc.level = level;
                    levels.add(ldesc);
                }
                String sparse = "DENSE";
                if (cube.isCompressedComposites() && !cube.isUseGlobalComposites()) {
                    sparse = "COMPRESSED";
                }
                AWCubeOrganization awCubeOrg = awcube.createAWOrganization(this.globalAW, true);
                awCubeOrg.setMVOption("NONE");
                awCubeOrg.setMeasureStorage("SHARED");
                awCubeOrg.setCubeStorageType("NUMBER");
                awCubeOrg.setSparseType(sparse);
                if (cube.isPartitioned() && cube.getPartHierarchy() != null && cube.getPartLevel() != null) {
                    MdmLevelHierarchy awh = (MdmLevelHierarchy)this.hierMap.get(cube.getPartHierarchy().getObjectID());
                    MdmHierarchyLevel mdmHierLevel = (MdmHierarchyLevel)this.levMap.get(cube.getPartHierarchy().getObjectID() + cube.getPartLevel().getObjectID());
                    if (mdmHierLevel != null) {
                        awCubeOrg.setPartitionLevel(mdmHierLevel);
                        if (cube.isUseGlobalComposites()) {
                            awCubeOrg.setSparseType("SPARSE_GLOBAL");
                        }
                    } else {
                        MdmHierarchyLevel hlev;
                        MdmDimensionLevel awl = (MdmDimensionLevel)this.levMap.get(cube.getPartLevel().getObjectID() + cube.getPartDimension().getObjectID());
                        if (awh != null && awl != null && (hlev = awh.findOrCreateHierarchyLevel(awl)) != null) {
                            awCubeOrg.setPartitionLevel(hlev);
                        }
                    }
                }
                CubeMap cubeMap = awcube.createCubeMap();
                this.associateCubeDimensions(cube, cubeMap, awcube, dimList, levels, links);
                this.processMeasures(cube, awcube, cubeMap);
                this.precomputeNA(awcube, cube, awCubeOrg);
                continue;
            }
            if (!(so.object instanceof Slice) || !so.selected) continue;
            Slice slice = (Slice)so.object;
            this.createSlice(slice);
        }
        this.addMeasureFolders();
    }

    private void processMeasures(Cube cube, MdmCube awcube, CubeMap cubeMap) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.sortMeasures(cube.getMeasures());
        ArrayList<String> whereClauseList = new ArrayList<String>();
        Iterator itm = this.sortedMeasures.iterator();
        ArrayList<MeasureDesc> cmeas = new ArrayList<MeasureDesc>();
        while (itm.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Measure meas = (oracle.dbtools.crest.model.design.multidimensional.Measure)itm.next();
            if (!meas.isFormula() && !meas.isFactDimension()) {
                ModelIDObject corobj;
                String mname = meas.getName().replaceAll(" ", "_").toUpperCase();
                mname = mname.replaceAll("[(]", "_");
                mname = mname.replaceAll("[)]", "_");
                MdmBaseMeasure awmeas = awcube.findOrCreateBaseMeasure(mname);
                SQLDataType sdt = new SQLDataType("NUMBER");
                awmeas.setSQLDataType(sdt);
                ContainedObject attr = meas.getMeasureFact();
                if (attr != null && (corobj = this.getCorrespondentObject(attr)) != null) {
                    String colname = this.getSchema(attr) + "." + corobj.getLongName(false);
                    this._measCols.add(colname.toUpperCase());
                    whereClauseList.add(meas.getWhereClause().trim());
                    MeasureMap mmap = cubeMap.findOrCreateMeasureMap(awmeas);
                    Expression expr = (Expression)SyntaxObject.fromSyntax((String)colname, (MdmMetadataProvider)this.metadataProvider);
                    mmap.setExpression(expr);
                }
                awmeas.setShortDescription(meas.getOracleShortName());
                awmeas.setDescription(meas.getOracleLongName());
                meas.setNameInOracleAW(awmeas.getName());
                this._measures.add(awmeas);
                MeasureDesc mdesc = new MeasureDesc();
                mdesc.awmeasure = awmeas;
                mdesc.awmeasureName = mname;
                mdesc.measure = meas;
                this.globMeas.add(mdesc);
                this.measMap.put(meas.getObjectID(), awmeas);
                cmeas.add(mdesc);
                continue;
            }
            if (meas.isFactDimension()) continue;
        }
        for (oracle.dbtools.crest.model.design.multidimensional.Measure meas : this.sortedMeasures) {
            if (!meas.isFormula() || meas.isDefinedAsOracleAWCalculated() && meas.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) continue;
            this.createDerivedMeasure(cube, awcube, meas, null, null);
        }
    }

    private List getAWDimensionsFor(oracle.dbtools.crest.model.design.multidimensional.Dimension dim, Map awdimToMap) {
        ArrayList<MdmPrimaryDimension> list = new ArrayList<MdmPrimaryDimension>();
        for (Map.Entry entry : awdimToMap.entrySet()) {
            MdmPrimaryDimension mdim;
            if (entry.getValue() != dim || (mdim = (MdmPrimaryDimension)this.awdimMap.get(entry.getKey())) == null) continue;
            list.add(mdim);
        }
        return list;
    }

    private void addMeasureFolder(MeasureFolder folder, MdmOrganizationalSchema awparent, boolean export) {
        String fname = folder.getName().toUpperCase().replaceAll(" ", "_").toUpperCase();
        MdmOrganizationalSchema awMeasureFolder = null;
        if (awparent != null) {
            awMeasureFolder = this.mdmDBSchema.findOrCreateOrganizationalSchema(fname);
            awparent.addSubSchema((MdmSchema)awMeasureFolder);
        } else {
            awMeasureFolder = this.mdmDBSchema.findOrCreateOrganizationalSchema(fname);
        }
        awMeasureFolder.setShortDescription(folder.getOracleShortName());
        awMeasureFolder.setDescription(folder.getOracleLongName());
        folder.setNameInOracleAW(awMeasureFolder.getName());
        for (int i = 0; i < folder.getMeasures().size(); ++i) {
            MdmMeasure awmeas;
            MeasureFolder.MFElement mfel = (MeasureFolder.MFElement)folder.getMeasures().get(i);
            if (mfel.isMeasureWrapper()) {
                Slice.MeasureWrapper mw = (Slice.MeasureWrapper)mfel.getMeasure();
                awmeas = (MdmMeasure)this.measMap.get(this.makeMeasureID((Slice)mfel.getParent(), mw));
            } else {
                oracle.dbtools.crest.model.design.multidimensional.Measure meas = (oracle.dbtools.crest.model.design.multidimensional.Measure)mfel.getMeasure();
                awmeas = (MdmMeasure)this.measMap.get(meas.getObjectID());
            }
            if (awmeas == null) continue;
            awMeasureFolder.addMeasure(awmeas);
        }
        Iterator it = this.mdmDesign.getMeasureFolderSet().iterator();
        while (it.hasNext()) {
            MeasureFolder mf = (MeasureFolder)it.next();
            if (mf.getParentFolder() != folder) continue;
            this.addMeasureFolder(mf, awMeasureFolder, export);
        }
        if (!export || awparent == null) {
            // empty if block
        }
    }

    private void addMeasureFolders() {
        Iterator it = this.mdmDesign.getMeasureFolderSet().iterator();
        while (it.hasNext()) {
            MeasureFolder mf = (MeasureFolder)it.next();
            if (mf.getParentFolder() != null) continue;
            this.addMeasureFolder(mf, null, false);
        }
    }

    private boolean sliceContainsDimension(Slice slice, oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        for (Slice.SelectedLevel sl : slice.getSelectedLevels()) {
            if (sl.getDimension() != dim) continue;
            return true;
        }
        return false;
    }

    private String makeMeasureID(Slice slice, Slice.MeasureWrapper mw) {
        String id = slice.getObjectID() + mw.getMeasure().getObjectID() + String.valueOf(mw.getAggrFunction().getObjectID());
        return id;
    }

    private void createSlice(Slice slice) {
        Cube cube = slice.getCube();
        boolean err = false;
        this.clearCubeMapVectors();
        String cname = slice.getName().replaceAll(" ", "_").toUpperCase();
        MdmCube awcube = this.mdmDBSchema.findOrCreateCube(cname);
        awcube.setDescription(slice.getName() + " - generated from Oracle SQL Developer Modeling Slice in Cube: " + slice.getCube().getName());
        slice.setNameInOracleAW(awcube.getName());
        Vector<MdmPrimaryDimension> _dimList = new Vector<MdmPrimaryDimension>(slice.getSelectedLevels().size());
        for (Slice.SelectedLevel sl : slice.getSelectedLevels()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = sl.getDimension();
            MdmPrimaryDimension awdim = (MdmPrimaryDimension)this.dimMap.get(dim.getObjectID());
            _dimList.add(awdim);
            oracle.dbtools.crest.model.design.multidimensional.Level level = null;
            if (dim.getBaseLevel() == null) continue;
            level = dim.getBaseLevel();
            LevelDesc ldesc = this.getLevelDesc(this.globLevDesc, level, awdim);
            if (level.isValueBasedHierarchy()) {
                if (ldesc != null) {
                    ldesc.olevel = null;
                } else {
                    ldesc = new LevelDesc();
                    ldesc.olevel = null;
                }
            }
            ldesc.odimension = awdim;
            ldesc.dim = dim;
            ldesc.level = level;
            this._levels.add(ldesc);
        }
        if (cube.isPartitioned() && cube.getPartHierarchy() != null && cube.getPartLevel() != null && this.sliceContainsDimension(slice, cube.getPartDimension())) {
            AWCubeOrganization awCubeOrg = awcube.createAWOrganization(this.globalAW, true);
            MdmLevelHierarchy awh = (MdmLevelHierarchy)this.hierMap.get(cube.getPartHierarchy().getObjectID());
            MdmHierarchyLevel awl = (MdmHierarchyLevel)this.levMap.get(cube.getPartLevel().getObjectID() + cube.getPartDimension().getObjectID());
            awCubeOrg.setPartitionLevel(awl);
        }
        ArrayList<MeasureDesc> cmeas = new ArrayList<MeasureDesc>();
        slice.verifyMeasureWrappers();
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.sortMeasures(slice.getCube().getMeasures());
        ArrayList<String> whereClauseList = new ArrayList<String>();
        for (Slice.MeasureWrapper mw : this.sortSliceMeasureWrappers(this.sortedMeasures, slice.getSelectedMeasureWrappers())) {
            oracle.dbtools.crest.model.design.multidimensional.Measure meas = mw.getMeasure();
            if (!meas.isFormula() && !meas.isFactDimension()) {
                ModelIDObject corobj;
                ContainedObject attr = meas.getMeasureFact();
                if (attr != null && (corobj = this.getCorrespondentObject(attr)) != null) {
                    String colname = this.getSchema(attr) + "." + corobj.getLongName(false);
                    this._measCols.add(colname.toUpperCase());
                    whereClauseList.add(slice.getWhereClauseFor(mw));
                }
                String mname = meas.getName().replaceAll(" ", "_").toUpperCase();
                mname = mname.replaceAll("[(]", "_");
                if (this.existsMeasureName(mname = mname.replaceAll("[)]", "_"))) {
                    String tname = mw.getAggrFunction().measureAlias;
                    mname = this.existsMeasureName(tname) ? (this.existsMeasureName(tname = mname + "_" + cname) ? this.produceUniqueMeasureName(mname) : tname) : tname;
                }
                MdmBaseMeasure awmeas = this.createBaseMeasure(awcube, mname);
                awmeas.setShortDescription(meas.getOracleShortName());
                awmeas.setDescription(meas.getOracleLongName());
                meas.setNameInOracleAW(awmeas.getName());
                this._measures.add(awmeas);
                MeasureDesc mdesc = new MeasureDesc();
                mdesc.awmeasure = awmeas;
                mdesc.awmeasureName = mname;
                mdesc.measure = null;
                mdesc.mwrapper = mw;
                this.globMeas.add(mdesc);
                this.measMap.put(this.makeMeasureID(slice, mw), awmeas);
                cmeas.add(mdesc);
                continue;
            }
            if (meas.isDefinedAsOracleAWCalculated() && !meas.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) continue;
        }
        if (!err) {
            // empty if block
        }
    }

    private List sortSliceMeasureWrappers(List sortedMeasures, List mwList) {
        ArrayList<Slice.MeasureWrapper> list = new ArrayList<Slice.MeasureWrapper>();
        Object[] mwarray = mwList.toArray();
        int size = mwList.size();
        Iterator it = sortedMeasures.iterator();
        while (size > 0 && it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Measure measure = (oracle.dbtools.crest.model.design.multidimensional.Measure)it.next();
            for (int i = 0; i < mwarray.length; ++i) {
                if (size > 0) {
                    Slice.MeasureWrapper mw = (Slice.MeasureWrapper)mwarray[i];
                    if (mw == null || mw.getMeasure() != measure) continue;
                    list.add(mw);
                    mwarray[i] = null;
                    --size;
                    continue;
                }
                return list;
            }
        }
        return list;
    }

    private boolean existsMeasureName(String name) {
        for (MeasureDesc mdesc : this.globMeas) {
            if (!mdesc.awmeasure.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private String produceUniqueMeasureName(String basename) {
        int i = 0;
        if (this.existsMeasureName(basename)) {
            String name;
            while (this.existsMeasureName(name = basename + "_" + Integer.toString(++i))) {
            }
            return name;
        }
        return basename;
    }

    private boolean getSparseFor(Cube cube, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        RollupLink rl = cube.getRollUpLink(dimension);
        if (rl != null) {
            return rl.isSparseDimension();
        }
        return false;
    }

    private String getOperatorFor(Cube cube, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        RollupLink rl = cube.getRollUpLink(dimension);
        if (rl != null) {
            return rl.getDefaultAggregationOperator();
        }
        return "SUM";
    }

    private void precomputeNA(MdmCube awcube, Cube cube, AWCubeOrganization awCubeOrg) {
        FunctionArgument[] fargs = new FunctionArgument[]{};
        awCubeOrg.clearSparseDimensions();
        ArrayList<AggregationCommand> solveCommands = new ArrayList<AggregationCommand>();
        ArrayList<SymmetricConditionElement> conditions = new ArrayList<SymmetricConditionElement>();
        ArrayList<MdmPrimaryDimension> awDims = new ArrayList<MdmPrimaryDimension>();
        List dims = awcube.getDimensions();
        for (oracle.dbtools.crest.model.design.multidimensional.Dimension dim : cube.getDimensions()) {
            List list = this.getAWDimensionsFor(dim, this.awdimTOdim);
            for (MdmPrimaryDimension mdim : list) {
                if (!dims.contains(mdim)) continue;
                awDims.add(mdim);
            }
        }
        for (MdmPrimaryDimension awdim : awDims) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.awdimTOdim.get(awdim.getName());
            RollupLink rlink = (RollupLink)this.awdimTOrollupLink.get(awdim.getName());
            if (rlink != null) {
                MdmDimensionality mdim;
                String function = rlink.getDefaultAggregationOperator();
                if (!"".equals(function)) {
                    AggregationCommand command = new AggregationCommand(function, fargs, awdim);
                    solveCommands.add(command);
                }
                if (rlink.isSparseDimension() && (mdim = (MdmDimensionality)this.dimensionalityMap.get(awdim.getName())) != null) {
                    awCubeOrg.addSparseDimension(mdim);
                }
            }
            if (dim.getBaseLevel() != null && !dim.getBaseLevel().isValueBasedHierarchy() && dim.getSummaryLevels().size() > 0) {
                ArrayList<MdmDimensionLevel> levels = new ArrayList<MdmDimensionLevel>();
                for (oracle.dbtools.crest.model.design.multidimensional.Level level : dim.getSummaryLevels()) {
                    LevelDesc ldesc = this.getLevelDesc(this.globLevDesc, level, awdim);
                    if (ldesc == null || ldesc.olevel == null) continue;
                    levels.add(ldesc.olevel);
                }
                if (levels.size() > 0) {
                    SymmetricConditionElement elem = new SymmetricConditionElement(awdim, levels);
                    conditions.add(elem);
                }
            }
            ConsistentSolveSpecification conSolveSpec = new ConsistentSolveSpecification(solveCommands);
            awcube.setConsistentSolveSpecification(conSolveSpec);
            if (conditions.size() <= 0) continue;
            SymmetricCondition scond = new SymmetricCondition(conditions);
            awCubeOrg.setPrecomputeCondition(scond);
        }
    }

    private boolean validForDimension(oracle.dbtools.crest.model.design.multidimensional.Measure meas, oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        Measure.AggregateFunction af;
        return meas.getAdditivity().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.SEMI_ADDITIVE) && (af = meas.getDefaultAggregationFunction()) != null && af.dimensions.indexOf(dim) > -1;
    }

    public void precomputeMeasureForCubeNA(oracle.AWXML.Cube _cube, Cube cube, List measures) {
    }

    public void precomputeMeasureForSliceNA(oracle.AWXML.Cube _cube, Slice slice, List measures) {
    }

    private MdmPrimaryDimension addDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension, String dimensionName) {
        MdmBaseAttribute timeSpan = null;
        MdmBaseAttribute endDate = null;
        ArrayList attrs = new ArrayList();
        ArrayList<LevelDesc> levels = new ArrayList<LevelDesc>();
        TreeMap<String, MdmBaseAttribute> attrMap = new TreeMap<String, MdmBaseAttribute>();
        String name = dimensionName.replaceAll(" ", "_").toUpperCase();
        if (name.length() > 30) {
            name = name.substring(0, 30);
        }
        Object mdmPrimDim = null;
        mdmPrimDim = dimension.isTimeDimension() ? this.mdmDBSchema.findOrCreateTimeDimension(name) : this.mdmDBSchema.findOrCreateStandardDimension(name);
        MdmTimeDimension awdim = mdmPrimDim;
        this.dimMap.put(dimension.getObjectID(), awdim);
        this.awdimMap.put(awdim.getName(), awdim);
        awdim.setShortDescription(dimension.getOracleShortName());
        awdim.setDescription(dimension.getOracleLongName());
        awdim.setPluralDescription(dimension.getOraclePluralName());
        dimension.setNameInOracleAW(awdim.getName());
        this.awdimTOdim.put(awdim.getName(), dimension);
        MdmBaseAttribute longDescAttr = mdmPrimDim.findOrCreateBaseAttribute("LONG_DESCRIPTION");
        longDescAttr.setDescription("Long description attribute");
        longDescAttr.setShortDescription("Long description");
        SQLDataType sdtVC2 = new SQLDataType("VARCHAR2");
        longDescAttr.setSQLDataType(sdtVC2);
        MdmBaseAttribute shortDescAttr = mdmPrimDim.findOrCreateBaseAttribute("SHORT_DESCRIPTION");
        shortDescAttr.setDescription("Short description attribute");
        shortDescAttr.setShortDescription("Short description");
        shortDescAttr.setSQLDataType(sdtVC2);
        mdmPrimDim.setValueDescriptionAttribute((MdmAttribute)longDescAttr);
        mdmPrimDim.setShortValueDescriptionAttribute((MdmAttribute)shortDescAttr);
        boolean timeDim = false;
        if (this.validTimeDim && dimension.isTimeDimension()) {
            timeDim = true;
            timeSpan = awdim.findOrCreateBaseAttribute("TIME_SPAN");
            endDate = awdim.findOrCreateBaseAttribute("END_DATE");
            endDate.setDescription("End date attribute");
            endDate.setShortDescription("End date");
            endDate.setSQLDataType(new SQLDataType(DataType.DATE));
            timeSpan = mdmPrimDim.findOrCreateBaseAttribute("TIME_SPAN");
            timeSpan.setDescription("Time span attribute");
            timeSpan.setShortDescription("Time span");
            timeSpan.setSQLDataType(new SQLDataType(DataType.NUMBER));
            MdmTimeDimension tDim = mdmPrimDim;
            tDim.setTimeSpanAttribute((MdmAttribute)timeSpan);
            tDim.setEndDateAttribute((MdmAttribute)endDate);
        }
        Iterator itl = dimension.getAllLevels().iterator();
        while (itl.hasNext()) {
            String kexpr;
            this.clearLevelMapVectors();
            oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)itl.next();
            if (level.isValueBasedHierarchy()) continue;
            String lname = level.getName().replaceAll(" ", "_").toUpperCase();
            MdmDimensionLevel oralev = awdim.findOrCreateDimensionLevel(lname);
            MemberListMap mdmDimLevelMemListMap = oralev.findOrCreateMemberListMap();
            this.levMap.put(level.getObjectID() + dimension.getObjectID(), oralev);
            LevelDesc ldesc = new LevelDesc();
            ldesc.level = level;
            ldesc.olevel = oralev;
            ldesc.dim = dimension;
            ldesc.odimension = awdim;
            if (level.getLevelKey().size() <= 0) continue;
            String schema = null;
            ContainerObject cob = level.getLevelEntity();
            if (cob != null) {
                schema = this.getSchema(cob);
            }
            if ((kexpr = this.getExpression(level.getLevelKey())) != null) {
                Expression keyExp = (Expression)SyntaxObject.fromSyntax((String)kexpr, (MdmMetadataProvider)this.metadataProvider);
                mdmDimLevelMemListMap.setKeyExpression(keyExp);
                Query query = this.getLevelQuery(level);
                if (query != null) {
                    mdmDimLevelMemListMap.setQuery(query);
                }
            }
            ldesc.attribute = (ContainedObject)level.getLevelKey().get(0);
            level.setNameInOracleAW(oralev.getName());
            attrs.clear();
            this.createSD_LD_TS_ED_Map(attrs, level, timeDim, oralev, (MdmPrimaryDimension)awdim, longDescAttr, shortDescAttr, endDate, timeSpan);
            attrs.clear();
            attrs.addAll(level.getSlowChangingAttributes());
            for (DesignObject sca : attrs) {
                ContainedObject attr;
                ModelIDObject corobj;
                MdmBaseAttribute awattr = (MdmBaseAttribute)attrMap.get(((SlowChangingAttribute)sca).getObjectID());
                if (awattr == null) {
                    String aname = ((SlowChangingAttribute)sca).getName().replaceAll(" ", "_").toUpperCase();
                    awattr = awdim.findOrCreateBaseAttribute(aname);
                    attrMap.put(((SlowChangingAttribute)sca).getObjectID(), awattr);
                }
                oralev.addAttribute((MdmAttribute)awattr);
                if (((SlowChangingAttribute)sca).isIndexed()) {
                    // empty if block
                }
                if ((corobj = this.getCorrespondentObject(attr = ((SlowChangingAttribute)sca).getAttribute())) == null) continue;
                String colname = this.getSchema(attr) + "." + corobj.getLongName(false);
                this._cols.add(colname);
                AttributeMap mdattrMap = mdmDimLevelMemListMap.findOrCreateAttributeMap(awattr);
                Expression lDescColExp = (Expression)SyntaxObject.fromSyntax((String)colname, (MdmMetadataProvider)this.metadataProvider);
                mdattrMap.setExpression(lDescColExp);
                awattr.setDescription(this.mdmDescDescType, ((SlowChangingAttribute)sca).getName());
                awattr.setDescription(this.mdmShortDescrDescrType, ((SlowChangingAttribute)sca).getName());
                if (!((SlowChangingAttribute)sca).isIndexed()) continue;
            }
            for (DesignObject sca : level.getCalculatedAttributes()) {
                MdmBaseAttribute awattr;
                Expression calcexp = null;
                try {
                    calcexp = schema != null ? (Expression)SyntaxObject.fromSyntax((String)((CalculatedAttribute)sca).getFunction(), (MdmMetadataProvider)this.metadataProvider, (String)schema) : (Expression)SyntaxObject.fromSyntax((String)((CalculatedAttribute)sca).getFunction(), (MdmMetadataProvider)this.metadataProvider);
                }
                catch (Exception attr) {
                    // empty catch block
                }
                if ((awattr = (MdmBaseAttribute)attrMap.get(sca.getObjectID())) != null || calcexp == null) continue;
                String aname = sca.getName().replaceAll(" ", "_").toUpperCase();
                awattr = awdim.findOrCreateBaseAttribute(aname);
                attrMap.put(sca.getObjectID(), awattr);
                AttributeMap mdattrMap = mdmDimLevelMemListMap.findOrCreateAttributeMap(awattr);
                mdattrMap.setExpression(calcexp);
                oralev.addAttribute((MdmAttribute)awattr);
            }
            this.createLevelMap(oralev, this._keys, this._cols, dimension.getWhereClauseFor(level));
            levels.add(ldesc);
            this.globLevDesc.add(ldesc);
        }
        AWPrimaryDimensionOrganization dimOrganization = awdim.createAWOrganization(this.globalAW, true);
        for (SlowChangingAttribute sca : dimension.getAllDescriptiveAttributes()) {
            MdmBaseAttribute awattr;
            if (!sca.isIndexed() || (awattr = (MdmBaseAttribute)attrMap.get(sca.getObjectID())) == null) continue;
            AWAttributeOrganization attrOrg = dimOrganization.getAttributeOrganization(awattr);
            attrOrg.setCreateAttributeIndex(true);
        }
        for (Hierarchy hier : dimension.getHierarchies()) {
            this.clearHierarchyMapVectors();
            if (hier.isValueBasedHierarchy()) {
                this.createValubasedHierarchy((MdmPrimaryDimension)awdim, hier, this._levColumns, (MdmAttribute)longDescAttr, (MdmAttribute)shortDescAttr);
                continue;
            }
            String hierName = hier.getName().replaceAll(" ", "_").toUpperCase();
            MdmLevelHierarchy awhier = awdim.findOrCreateLevelHierarchy(hierName);
            hier.setNameInOracleAW(awhier.getName());
            this.hierMap.put(hier.getObjectID(), awhier);
            awhier.setShortDescription(hier.getOracleShortName());
            awhier.setDescription(hier.getOracleLongName());
            awhier.setPluralDescription(hier.getOraclePluralName());
            if (hier.isDefaultHierarchy()) {
                awdim.setDefaultHierarchy((MdmHierarchy)awhier);
            }
            if (hier.isRaggedHierarchy()) {
                awhier.setIsRagged(true);
                awhier.setIsSkipLevel(true);
            }
            for (int i = hier.getLevels().size() - 1; i > -1; --i) {
                oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)hier.getLevels().get(i);
                LevelDesc ldesc = this.getLevelDesc(levels, level, (MdmPrimaryDimension)awdim);
                if (ldesc == null) continue;
                this._levels.add(ldesc);
                ModelIDObject corobj = this.getCorrespondentObject(ldesc.attribute);
                if (corobj == null) continue;
                String colname = this.getSchema(ldesc.attribute) + "." + corobj.getLongName(false);
                this._levColumns.add(colname);
            }
            this.createHierarchyMap11(awhier, hier, this._levels, this._levColumns, (MdmPrimaryDimension)awdim);
        }
        return awdim;
    }

    private void createSD_LD_TS_ED_Map(List attrs, oracle.dbtools.crest.model.design.multidimensional.Level level, boolean timeDim, MdmDimensionLevel oralev, MdmPrimaryDimension awdim, MdmBaseAttribute longDescAttr, MdmBaseAttribute shortDescAttr, MdmBaseAttribute endDateAttr, MdmBaseAttribute timeSpanAttr) {
        String colname;
        ModelIDObject corobj;
        Expression lDescColExp;
        Level.OraAWAttributes oa = level.getOraAWAttributes();
        ArrayList<ContainedObject> processed = new ArrayList<ContainedObject>();
        MemberListMap mdmDimLevelMemListMap = oralev.findOrCreateMemberListMap();
        ContainedObject attr = oa.shortDesc;
        if (attr != null) {
            processed.add(attr);
            ModelIDObject corobj2 = this.getCorrespondentObject(attr);
            if (corobj2 != null) {
                String colname2 = this.getSchema(attr) + "." + corobj2.getLongName(false);
                this._cols.add(colname2);
                AttributeMap attrMapShort = mdmDimLevelMemListMap.findOrCreateAttributeMap(shortDescAttr);
                lDescColExp = (Expression)SyntaxObject.fromSyntax((String)colname2, (MdmMetadataProvider)this.metadataProvider);
                attrMapShort.setExpression(lDescColExp);
                oralev.addAttribute((MdmAttribute)shortDescAttr);
            }
        }
        if ((attr = oa.longDesc) != null) {
            AttributeMap attrMapLong = mdmDimLevelMemListMap.findOrCreateAttributeMap(longDescAttr);
            processed.add(attr);
            corobj = this.getCorrespondentObject(attr);
            if (corobj != null) {
                colname = this.getSchema(attr) + "." + corobj.getLongName(false);
                this._cols.add(colname);
                lDescColExp = (Expression)SyntaxObject.fromSyntax((String)colname, (MdmMetadataProvider)this.metadataProvider);
                attrMapLong.setExpression(lDescColExp);
                oralev.addAttribute((MdmAttribute)longDescAttr);
            }
        }
        if (this.validTimeDim && timeDim) {
            AttributeMap attrMap;
            attr = oa.timeEnd;
            if (attr != null && endDateAttr != null) {
                attrMap = mdmDimLevelMemListMap.findOrCreateAttributeMap(endDateAttr);
                processed.add(attr);
                corobj = this.getCorrespondentObject(attr);
                if (corobj != null) {
                    colname = this.getSchema(attr) + "." + corobj.getLongName(false);
                    this._cols.add(colname);
                    lDescColExp = (Expression)SyntaxObject.fromSyntax((String)colname, (MdmMetadataProvider)this.metadataProvider);
                    attrMap.setExpression(lDescColExp);
                    oralev.addAttribute((MdmAttribute)endDateAttr);
                }
            }
            if ((attr = oa.timeSpan) != null && timeSpanAttr != null) {
                attrMap = mdmDimLevelMemListMap.findOrCreateAttributeMap(timeSpanAttr);
                processed.add(attr);
                corobj = this.getCorrespondentObject(attr);
                if (corobj != null) {
                    colname = this.getSchema(attr) + "." + corobj.getLongName(false);
                    this._cols.add(colname);
                    lDescColExp = (Expression)SyntaxObject.fromSyntax((String)colname, (MdmMetadataProvider)this.metadataProvider);
                    attrMap.setExpression(lDescColExp);
                    oralev.addAttribute((MdmAttribute)timeSpanAttr);
                }
            }
        }
        for (ContainedObject attribute : processed) {
            attrs.remove(attribute);
        }
    }

    Expression getExpression(ContainedObject attr) {
        ModelIDObject corobj;
        if (attr != null && (corobj = this.getCorrespondentObject(attr)) != null) {
            String colname = this.getSchema(attr) + "." + corobj.getLongName(false);
            Expression colExp = (Expression)SyntaxObject.fromSyntax((String)colname, (MdmMetadataProvider)this.metadataProvider);
            return colExp;
        }
        return null;
    }

    public void createValubasedHierarchy(MdmPrimaryDimension awdim, Hierarchy hier, Vector columns, MdmAttribute ldAttr, MdmAttribute sdAttr) {
        Expression exp;
        AttributeMap attrMap;
        MdmBaseAttribute awattr;
        ContainedObject attr;
        String pexpr;
        if (hier.getLevels().size() == 0) {
            return;
        }
        oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)hier.getLevels().get(0);
        Query query = this.getLevelQuery(level);
        String hname = hier.getName().replaceAll(" ", "_").toUpperCase();
        ArrayList attrs = new ArrayList();
        Level.OraAWAttributes oa = level.getOraAWAttributes();
        MdmValueHierarchy mdmValHier = awdim.findOrCreateValueHierarchy(hname);
        SolvedValueHierarchyMap solvedValHierMap = mdmValHier.findOrCreateSolvedValueHierarchyMap();
        solvedValHierMap.setQuery(query);
        String kexpr = this.getExpression(level.getLevelKey());
        if (kexpr != null) {
            Expression keyExp = (Expression)SyntaxObject.fromSyntax((String)kexpr, (MdmMetadataProvider)this.metadataProvider);
            solvedValHierMap.setKeyExpression(keyExp);
        }
        if ((pexpr = this.getExpression(level.getParentKey())) != null) {
            Expression parentExp = (Expression)SyntaxObject.fromSyntax((String)pexpr, (MdmMetadataProvider)this.metadataProvider);
            solvedValHierMap.setParentKeyExpression(parentExp);
        }
        if ((attr = oa.shortDesc) != null && (awattr = awdim.findOrCreateBaseAttribute(this.SD_NAME)) != null) {
            attrMap = solvedValHierMap.findOrCreateAttributeMap(awattr);
            exp = this.getExpression(attr);
            attrMap.setExpression(exp);
            mdmValHier.addAttribute((MdmAttribute)awattr);
        }
        if ((attr = oa.longDesc) != null && (awattr = awdim.findOrCreateBaseAttribute(this.LD_NAME)) != null) {
            attrMap = solvedValHierMap.findOrCreateAttributeMap(awattr);
            exp = this.getExpression(attr);
            attrMap.setExpression(exp);
            mdmValHier.addAttribute((MdmAttribute)awattr);
        }
        attrs.addAll(level.getSlowChangingAttributes());
        for (DesignObject sca : attrs) {
            String aname = ((SlowChangingAttribute)sca).getName().replaceAll(" ", "_").toUpperCase();
            awattr = awdim.findOrCreateBaseAttribute(aname);
            AttributeMap attrMap2 = solvedValHierMap.findOrCreateAttributeMap(awattr);
            awattr.setDescription(this.mdmDescDescType, ((SlowChangingAttribute)sca).getName());
            awattr.setDescription(this.mdmShortDescrDescrType, ((SlowChangingAttribute)sca).getName());
            attr = ((SlowChangingAttribute)sca).getAttribute();
            if (attr != null) {
                Expression exp2 = this.getExpression(attr);
                attrMap2.setExpression(exp2);
            }
            mdmValHier.addAttribute((MdmAttribute)awattr);
        }
        for (DesignObject sca : level.getCalculatedAttributes()) {
            Expression calcexp = null;
            try {
                ContainerObject cob = level.getLevelEntity();
                if (cob != null) {
                    String schema = this.getSchema(cob);
                    calcexp = (Expression)SyntaxObject.fromSyntax((String)((CalculatedAttribute)sca).getFunction(), (MdmMetadataProvider)this.metadataProvider, (String)schema);
                } else {
                    calcexp = (Expression)SyntaxObject.fromSyntax((String)((CalculatedAttribute)sca).getFunction(), (MdmMetadataProvider)this.metadataProvider);
                }
            }
            catch (Exception cob) {
                // empty catch block
            }
            if (calcexp == null) continue;
            String aname = sca.getName().replaceAll(" ", "_").toUpperCase();
            awattr = awdim.findOrCreateBaseAttribute(aname);
            AttributeMap attrMap3 = solvedValHierMap.findOrCreateAttributeMap(awattr);
            attrMap3.setExpression(calcexp);
            mdmValHier.addAttribute((MdmAttribute)awattr);
        }
    }

    private String getExpression(List list) {
        String res = null;
        for (DesignObject dobj : list) {
            ContainedObject attr = null;
            if (dobj instanceof SlowChangingAttribute) {
                attr = ((SlowChangingAttribute)dobj).getAttribute();
            } else if (dobj instanceof ContainedObject) {
                attr = (ContainedObject)dobj;
            }
            if (attr != null) {
                ModelIDObject corobj = this.getCorrespondentObject(attr);
                if (corobj == null) continue;
                String colname = this.getSchema(attr) + "." + corobj.getLongName(false);
                if (res == null) {
                    res = colname;
                    continue;
                }
                res = res + "||" + colname;
                continue;
            }
            return null;
        }
        return res;
    }

    private Condition getJoinCondition(List left, List right) {
        SyntaxObject expr;
        String res = null;
        for (int i = 0; i < left.size(); ++i) {
            DesignObject dobj = (DesignObject)left.get(i);
            ContainedObject lattr = null;
            if (dobj instanceof SlowChangingAttribute) {
                lattr = ((SlowChangingAttribute)dobj).getAttribute();
            } else if (dobj instanceof ContainedObject) {
                lattr = (ContainedObject)dobj;
            }
            dobj = (DesignObject)right.get(i);
            ContainedObject rattr = null;
            if (dobj instanceof SlowChangingAttribute) {
                rattr = ((SlowChangingAttribute)dobj).getAttribute();
            } else if (dobj instanceof ContainedObject) {
                rattr = (ContainedObject)dobj;
            }
            if (lattr != null && rattr != null) {
                ModelIDObject lcorobj = this.getCorrespondentObject(lattr);
                ModelIDObject rcorobj = this.getCorrespondentObject(rattr);
                if (lcorobj != null && rcorobj != null) {
                    String lcolname = this.getSchema(lattr) + "." + lcorobj.getLongName(false);
                    String rcolname = this.getSchema(rattr) + "." + rcorobj.getLongName(false);
                    if (res == null) {
                        res = lcolname + " = " + rcolname;
                        continue;
                    }
                    res = res + " AND " + lcolname + " = " + rcolname;
                    continue;
                }
                return null;
            }
            return null;
        }
        if (res != null && (expr = Condition.fromSyntax(res, (MdmMetadataProvider)this.metadataProvider)) instanceof Condition) {
            return (Condition)expr;
        }
        return null;
    }

    private void createHierarchyMap11(MdmLevelHierarchy _hier, Hierarchy hier, List _levels, Vector columns, MdmPrimaryDimension dimension) {
        oracle.dbtools.crest.model.design.multidimensional.Level prevLevel = null;
        LevelDesc prevLevelDesc = null;
        oracle.dbtools.crest.model.design.multidimensional.Level level = null;
        int i = 0;
        for (LevelDesc ldes : _levels) {
            Link link;
            level = ldes.level;
            MdmHierarchyLevel mdmHierLevel = _hier.findOrCreateHierarchyLevel(ldes.olevel);
            this.levMap.put(hier.getObjectID() + level.getObjectID(), mdmHierLevel);
            HierarchyLevelMap hierLevelMap = mdmHierLevel.findOrCreateHierarchyLevelMap();
            String kexpr = this.getExpression(level.getLevelKey());
            if (kexpr != null) {
                Expression keyExp = (Expression)SyntaxObject.fromSyntax((String)kexpr, (MdmMetadataProvider)this.metadataProvider);
                hierLevelMap.setKeyExpression(keyExp);
                if (keyExp instanceof ColumnExpression) {
                    ColumnExpression cexpr = (ColumnExpression)keyExp;
                    hierLevelMap.setQuery(cexpr.getQuery());
                } else {
                    Query query = this.getLevelQuery(level);
                    if (query != null) {
                        hierLevelMap.setQuery(query);
                    }
                }
            }
            MemberListMap members = ldes.olevel.findOrCreateMemberListMap();
            for (MdmAttribute ma : ldes.olevel.getAttributes()) {
                if (ma instanceof MdmBaseAttribute) {
                    AttributeMap dl_am = members.findOrCreateAttributeMap((MdmBaseAttribute)ma);
                    if (dl_am.getExpression() != null) {
                        AttributeMap hl_am = hierLevelMap.findOrCreateAttributeMap((MdmBaseAttribute)ma);
                        hl_am.setExpression(dl_am.getExpression());
                    } else {
                        members.removeAttributeMap(dl_am);
                    }
                }
                mdmHierLevel.addAttribute(ma);
            }
            if (i > 0 && prevLevel != null && prevLevelDesc != null && (link = level.getFirstLinkToTarget(prevLevel)) != null && link.getRollupLink().getChildToParentAttributes().size() > 0) {
                List left = link.getRollupLink().getChildToParentAttributes();
                List right = prevLevel.getLevelKey();
                Condition join = null;
                if (left.size() == right.size()) {
                    join = this.getJoinCondition(left, right);
                }
                if (join != null) {
                    hierLevelMap.setJoinCondition(join);
                } else {
                    ContainedObject rattr = (ContainedObject)link.getRollupLink().getChildToParentAttributes().get(0);
                    ModelIDObject corobj = this.getCorrespondentObject(rattr);
                    if (corobj != null) {
                        String colname = this.getSchema(rattr) + "." + corobj.getLongName(false);
                        String kcol = (String)columns.get(i - 1);
                        Expression parent = (Expression)SyntaxObject.fromSyntax((String)kcol, (MdmMetadataProvider)this.metadataProvider);
                        Expression child = (Expression)SyntaxObject.fromSyntax((String)colname, (MdmMetadataProvider)this.metadataProvider);
                        if (child instanceof ColumnExpression && parent instanceof ColumnExpression) {
                            ValueComparisonCondition joinCond = new ValueComparisonCondition((TypedExpression)((ColumnExpression)child), "=", (TypedExpression)((ColumnExpression)parent));
                            hierLevelMap.setJoinCondition((Condition)joinCond);
                        }
                    }
                }
            }
            ++i;
            prevLevel = level;
            prevLevelDesc = ldes;
        }
    }

    public oracle.AWXML.Attribute createLongDescAttr(oracle.AWXML.Dimension dim) {
        oracle.AWXML.Attribute ldAttr = dim.createAttribute();
        ldAttr.setName(this.LD_NAME);
        ldAttr.setClassification("MEMBER_LONG_DESCRIPTION");
        return ldAttr;
    }

    public oracle.AWXML.Attribute createShortDescAttr(oracle.AWXML.Dimension dim) {
        oracle.AWXML.Attribute sdAttr = dim.createAttribute();
        sdAttr.setName(this.SD_NAME);
        sdAttr.setClassification("MEMBER_SHORT_DESCRIPTION");
        return sdAttr;
    }

    private LevelDesc getLevelDesc(List list, oracle.dbtools.crest.model.design.multidimensional.Level level, oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        for (LevelDesc ldes : list) {
            if (ldes.level != level || ldes.dim != dim) continue;
            return ldes;
        }
        return null;
    }

    private LevelDesc getLevelDesc(List list, oracle.dbtools.crest.model.design.multidimensional.Level level, MdmPrimaryDimension dim) {
        for (LevelDesc ldes : list) {
            if (ldes.level != level || ldes.odimension != dim) continue;
            return ldes;
        }
        return null;
    }

    public void createLevelMap(MdmDimensionLevel _lev, Vector _keys, Vector _columns, String whereClause) {
    }

    public void clearLevelMapVectors() {
        this._keys.removeAllElements();
        this._cols.removeAllElements();
    }

    public void clearHierarchyMapVectors() {
        this._levels.clear();
        this._levColumns.removeAllElements();
    }

    private ApplicationView getApplicationView() {
        return this.appView;
    }

    public void setTempStatusMessage(String message) {
        this.appView.setTempStatusMessage(message);
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private void validateLevel(oracle.dbtools.crest.model.design.multidimensional.Level level) {
        ColumnProxy cp;
        ContainerObject obj = level.getLevelEntity();
        Entity ent = null;
        if (obj != null && obj instanceof Entity) {
            ent = (Entity)obj;
            if (this.storDesign != null) {
                TableProxy tp = this.getTableProxy(ent);
                if (tp == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding table for entity ").append(ent.getName());
                }
            } else if (ent.getEngTable(this.physDesign) == null) {
                this.valid = false;
                this.validationSB.append("\n There is no corresponding table for entity ").append(ent.getName());
            }
        }
        EntityView entv = null;
        if (ent == null && obj != null && obj instanceof EntityView) {
            entv = (EntityView)obj;
            if (this.storDesign != null) {
                TableViewProxy tp = this.getTableViewProxy(entv);
                if (tp == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding table for entity ").append(entv.getName());
                }
            } else if (entv.getEngTableView(this.physDesign) == null) {
                this.valid = false;
                this.validationSB.append("\n There is no corresponding table for entity ").append(entv.getName());
            }
        }
        boolean relModelObject = false;
        if (obj != null && obj.getDesignPart() instanceof RelationalDesign) {
            relModelObject = true;
        }
        if (ent == null && entv == null && !relModelObject) {
            this.valid = false;
            this.validationSB.append("\nLevel Entity is not defined for " + level.getName());
        } else if (level.getLevelKey().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nLevel key attributes are not defined for " + level.getName());
        }
        for (ContainedObject attr : level.getLevelKey()) {
            if (!(attr instanceof Attribute)) continue;
            if (this.storDesign != null) {
                cp = this.getColumnProxy((Attribute)attr);
                if (cp != null) continue;
                this.valid = false;
                this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName(false));
                continue;
            }
            if (((Attribute)attr).getEngColumn(this.physDesign) != null) continue;
            this.valid = false;
            this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName(false));
        }
        for (ContainedObject attr : level.getDescriptiveAttributes()) {
            if (!(attr instanceof Attribute)) continue;
            if (this.storDesign != null) {
                cp = this.getColumnProxy((Attribute)attr);
                if (cp != null) continue;
                this.valid = false;
                this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName(false));
                continue;
            }
            if (((Attribute)attr).getEngColumn(this.physDesign) != null) continue;
            this.valid = false;
            this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName(false));
        }
    }

    private ColumnProxy getColumnProxy(Attribute attribute) {
        ContainedObject column = attribute.getEngColumn(this.physDesign);
        if (column != null && this.storDesign != null) {
            ColumnProxy cp = (ColumnProxy)this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
            return cp;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableProxy getTableProxy(ContainerObject entity) {
        if (!(entity instanceof Entity)) {
            if (!(entity instanceof Table)) return null;
            if (this.storDesign == null) return null;
            return (TableProxy)this.storDesign.getTableProxySet().getProxy(entity.getObjectID());
        }
        Table table = ((Entity)entity).getEngTable(this.physDesign);
        if (table != null && this.storDesign != null) {
            return (TableProxy)this.storDesign.getTableProxySet().getProxy(table.getObjectID());
        }
        if (table != null) return null;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableViewProxy getTableViewProxy(ContainerObject entity) {
        if (!(entity instanceof EntityView)) {
            if (!(entity instanceof TableView)) return null;
            if (this.storDesign == null) return null;
            return (TableViewProxy)this.storDesign.getTableViewProxySet().getProxy(entity.getObjectID());
        }
        TableView table = ((EntityView)entity).getEngTableView(this.physDesign);
        if (table != null && this.storDesign != null) {
            return (TableViewProxy)this.storDesign.getTableViewProxySet().getProxy(table.getObjectID());
        }
        if (table != null) return null;
        return null;
    }

    public void xml_build_global_aw(String awName) {
        this.curInteraction = new Interaction();
        BuildDatabase myBuild = (BuildDatabase)this.curInteraction.createAction("BUILDDATABASE");
        myBuild.setAWName(awName);
        myBuild.setRunSolve(false);
        myBuild.Execute();
    }

    public MdmBaseMeasure createBaseMeasure(MdmCube mdmCube, String name) {
        MdmBaseMeasure mdmBaseMeasure = mdmCube.findOrCreateBaseMeasure(name);
        SQLDataType sdt = new SQLDataType("NUMBER");
        mdmBaseMeasure.setSQLDataType(sdt);
        return mdmBaseMeasure;
    }

    private MdmDerivedMeasure createDerivedMeasure(Cube cube, MdmCube awcube, oracle.dbtools.crest.model.design.multidimensional.Measure meas, Slice slice, Slice.MeasureWrapper mw) {
        String mname = meas.getName().replaceAll(" ", "_").toUpperCase();
        mname = mname.replaceAll("[(]", "_");
        if (this.existsMeasureName(mname = mname.replaceAll("[)]", "_"))) {
            String tname = mname;
            mname = this.existsMeasureName(tname) ? this.produceUniqueMeasureName(mname) : tname;
        }
        String expr = meas.getFormula();
        Expression mexpr = null;
        try {
            ContainerObject cob = cube.getFactEntity();
            String schema = this.getSchema(cob);
            mexpr = schema != null ? (Expression)SyntaxObject.fromSyntax((String)expr, (MdmMetadataProvider)this.metadataProvider, (String)schema.toUpperCase()) : (Expression)SyntaxObject.fromSyntax((String)expr, (MdmMetadataProvider)this.metadataProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mexpr != null) {
            MdmDerivedMeasure derivedMeasure = awcube.findOrCreateDerivedMeasure(mname);
            derivedMeasure.setDescription(meas.getOracleLongName());
            derivedMeasure.setShortDescription(meas.getOracleShortName());
            meas.setNameInOracleAW(derivedMeasure.getName());
            derivedMeasure.setMeasureExpression(mexpr);
            if (slice == null || mw == null) {
                this.measMap.put(meas.getObjectID(), derivedMeasure);
            } else {
                this.measMap.put(this.makeMeasureID(slice, mw), derivedMeasure);
            }
            return derivedMeasure;
        }
        return null;
    }

    private String getOperatorID(String objectName) {
        String invalidChars = "[^A-Z0-9_]";
        String newID = objectName.toUpperCase();
        newID = newID.replaceAll(invalidChars, "_");
        return newID;
    }

    private List getMeasureDependencies(List measures) {
        ArrayList<MeasureDependence> list = new ArrayList<MeasureDependence>();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : measures) {
            MeasureDependence md = new MeasureDependence(measure);
            if (!measure.isFormula()) {
                list.add(md);
                continue;
            }
            if (measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                oracle.dbtools.crest.model.design.multidimensional.Measure usedMeasure = measure.getUsedOLAPMeasure();
                if (usedMeasure != null) {
                    md.dependOn.add(usedMeasure);
                }
            } else if (!measure.isCustomFormula()) {
                String formula = measure.getFormula().toUpperCase();
                for (oracle.dbtools.crest.model.design.multidimensional.Measure measn : measures) {
                    String namedq;
                    if (measn == measure || formula.indexOf(namedq = "\"" + measn.getName().toUpperCase().trim() + "\"") <= -1) continue;
                    md.dependOn.add(measn);
                }
            }
            list.add(md);
        }
        return list;
    }

    private void sortMeasures(List measures) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.cyclicRef = false;
        this.measureDependencies = this.getMeasureDependencies(measures);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : measures) {
            this.addToSorted(measure);
            if (!this.cyclicRef) continue;
            return;
        }
    }

    private void addToSorted(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        if (this.sortedMeasures.contains(measure)) {
            return;
        }
        MeasureDependence md = this.getMeasureDependence(measure, this.measureDependencies);
        if (md == null) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        if (md.dependOn.size() == 0) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        this.tracedMeasures.add(measure);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure meas : md.dependOn) {
            if (this.tracedMeasures.contains(meas) && !this.sortedMeasures.contains(meas)) {
                this.cyclicRef = true;
                String mname = "\"" + meas.getCube().getName() + "\".\"" + meas.getName() + "\"";
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ThereIsCyclicFeferenceForMeasure"), mname), Messages.getString("OracleAWExporter.CyclicRference"), 0, 0, null, new String[]{Messages.getString("OracleAWExporter.Ok")}, Messages.getString("OracleAWExporter.Ok"));
                this.error = true;
                this.valid = false;
                this.eb.append("\nCyclic reference for measure ").append(mname);
                return;
            }
            if (this.sortedMeasures.contains(meas)) continue;
            this.addToSorted(meas);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedMeasures.add(measure);
    }

    private MeasureDependence getMeasureDependence(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List measureDependencies) {
        for (MeasureDependence md : measureDependencies) {
            if (md.measure != measure) continue;
            return md;
        }
        return null;
    }

    public String getMeasureExpression(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        Cube cube = measure.getCube();
        String func = measure.getFormula();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure obj : cube.getMeasures()) {
            Measure awmeas;
            String obname;
            if (obj == measure || func.indexOf(obname = "\"" + obj.getName().trim() + "\"") <= -1 || (awmeas = (Measure)this.measMap.get(obj.getObjectID())) == null) continue;
            String measID = awmeas.getId();
            func = this.replace(func, obname, measID);
        }
        return func;
    }

    public String getMeasureExpression(Slice slice, Slice.MeasureWrapper mw) {
        oracle.dbtools.crest.model.design.multidimensional.Measure measure = mw.getMeasure();
        Cube cube = measure.getCube();
        String func = measure.getFormula();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure obj : cube.getMeasures()) {
            String id;
            Measure awmeas;
            String obname;
            if (obj == measure || func.indexOf(obname = "\"" + obj.getName().trim() + "\"") <= -1 || (awmeas = (Measure)this.measMap.get(id = slice.getObjectID() + obj.getObjectID() + obj.getDefaultAggregationFunction().getObjectID())) == null) continue;
            String measID = awmeas.getId();
            func = this.replace(func, obname, measID);
        }
        return func;
    }

    private String replace(String origin, String str1, String str2) {
        String temp = str1.trim();
        String result = origin;
        int ind = result.indexOf(temp);
        int lstr1 = temp.length();
        while (ind > -1) {
            String tresult = ind == 0 ? "" : result.substring(0, ind);
            int k = tresult.length() + str2.length();
            result = tresult + str2 + result.substring(ind + lstr1);
            ind = result.indexOf(temp, k);
        }
        return result;
    }

    private void validateCube(Cube cube) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.eb.setLength(0);
        this.sortMeasures(cube.getMeasures());
        if (this.cyclicRef) {
            this.valid = false;
            this.validationSB.append("\n\nCube " + cube.getName() + " has measures with cyclic references").append(this.eb.toString());
        }
        if (cube.getFactEntities().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nThere is no Fact Entity defined for Cube " + cube.getName());
        }
        if (cube.hasRolePlayingDimensions()) {
            this.warning = true;
            this.warningsSB.append("\nCube " + cube.getName() + " has Role Playing Dimensions and will not be generated. Use Slice to create cube.");
        }
        if (cube.getDimensions().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nThere is no dimension usage for cube " + cube.getName());
        }
        for (oracle.dbtools.crest.model.design.multidimensional.Dimension dim : cube.getDimensions()) {
            oracle.dbtools.crest.model.design.multidimensional.Level level = dim.getBaseLevel();
            RollupLink rl = cube.getRollUpLink(dim);
            if (rl.getChildToParentAttributes().size() == 0) {
                this.valid = false;
                this.validationSB.append("\nThere are no reference attributes defined for dimenson " + dim.getName() + " in Cube " + cube.getName());
                continue;
            }
            if (level == null || rl.getChildToParentAttributes().size() == level.getLevelKey().size()) continue;
            this.valid = false;
            this.validationSB.append("\nThe number of reference attributes for dimenson " + dim.getName() + " in cube " + cube.getName());
            this.validationSB.append(" differ from number of key attributes for level " + level.getName());
        }
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : cube.getMeasures()) {
            this.validateMeasure(measure);
        }
        for (Slice slice : cube.getPrecalculatedSlices()) {
            this.validateSlice(slice);
        }
    }

    private void validateMeasure(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
        if (!measure.isFormula()) {
            ContainedObject attr = measure.getMeasureFact();
            if (attr == null) {
                this.valid = false;
                this.validationSB.append("\nThere is no fact attribute defined for measure " + measure.getName() + "in Cube " + measure.getCube().getName());
            } else if (this.storDesign != null) {
                if (attr instanceof Attribute) {
                    ColumnProxy cp = this.getColumnProxy((Attribute)attr);
                    if (cp == null) {
                        this.valid = false;
                        this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName(false));
                    }
                } else if (attr instanceof AttributeView && ((AttributeView)attr).getEngColumnView(this.physDesign) == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding columnView for attributeView ").append(attr.getLongName(false));
                }
            } else if (attr instanceof Attribute) {
                if (((Attribute)attr).getEngColumn(this.physDesign) == null) {
                    this.valid = false;
                    this.validationSB.append("\n There is no corresponding column for attribute ").append(attr.getLongName(false));
                }
            } else if (attr instanceof AttributeView && ((AttributeView)attr).getEngColumnView(this.physDesign) == null) {
                this.valid = false;
                this.validationSB.append("\n There is no corresponding columnView for attributeView ").append(attr.getLongName(false));
            }
        } else {
            this.validateAndSetOLAPMeasure((MultidimensionalDesign)measure.getDesignPart(), measure);
        }
    }

    private void validateAndSetOLAPMeasure(MultidimensionalDesign mdm, oracle.dbtools.crest.model.design.multidimensional.Measure meas) {
        if (meas.isFormula() && meas.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
            String operator;
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim;
            oracle.dbtools.crest.model.design.multidimensional.Measure usedMeasure = meas.getUsedOLAPMeasure();
            if (usedMeasure != null) {
                usedMeasure = (oracle.dbtools.crest.model.design.multidimensional.Measure)mdm.getMeasureSet().getObjectByID(usedMeasure.getObjectID());
            }
            if (usedMeasure == null) {
                this.valid = false;
                meas.setUsedOLAPMeasure(null);
                this.validationSB.append("\nBase measure is not set for OLAP calcilated measure " + meas.getName());
            }
            if ((dim = meas.getOLAPDimension()) != null) {
                dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)mdm.getDimensionSet().getObjectByID(dim.getObjectID());
            }
            if (dim == null) {
                this.valid = false;
                meas.setOLAPDimension(null);
                meas.setOLAPHierarchy(null);
                meas.setOLAPLevel(null);
                this.validationSB.append("\nDimension is not set for OLAP calcilated measure " + meas.getName());
            }
            if ((operator = this.getOperatorID(meas.getOLAPOperator())).indexOf("PRIOR_PERIOD") > -1 || operator.indexOf("FUTURE_PERIOD") > -1 || operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SAME_PERIOD_ANCESTORS") > -1 || operator.indexOf("SHARE_TO") > -1 || operator.indexOf("RANK_") > -1 || operator.indexOf("CUMULATIVE_TOTAL") > -1) {
                Hierarchy hier = meas.getOLAPHierarchy();
                if (hier != null) {
                    hier = (Hierarchy)mdm.getHierarchySet().getObjectByID(hier.getObjectID());
                }
                if (hier == null) {
                    this.valid = false;
                    meas.setOLAPHierarchy(null);
                    meas.setOLAPLevel(null);
                    this.validationSB.append("\nHierarchy is not set for OLAP calcilated measure " + meas.getName());
                }
            }
            if (operator.indexOf("PERIOD_TO_DATE") > -1 || operator.indexOf("SHARE_TO_LEVEL") > -1) {
                oracle.dbtools.crest.model.design.multidimensional.Level level = meas.getOLAPLevel();
                if (level != null) {
                    level = (oracle.dbtools.crest.model.design.multidimensional.Level)mdm.getLevelSet().getObjectByID(level.getObjectID());
                }
                if (level == null) {
                    this.valid = false;
                    meas.setOLAPLevel(null);
                    this.validationSB.append("\nLevel is not set for OLAP calcilated measure " + meas.getName());
                }
            }
        }
    }

    private void validateDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        oracle.dbtools.crest.model.design.multidimensional.Level blevel = dim.getBaseLevel();
        if (blevel == null) {
            this.valid = false;
            this.validationSB.append("\nThere is no base level for dimension " + dim.getName());
        }
        for (Hierarchy hier : dim.getHierarchies()) {
            this.validateHierachy(hier);
        }
        for (oracle.dbtools.crest.model.design.multidimensional.Level level : dim.getAllLevels()) {
            this.validateAWAttributes(level, dim.isTimeDimension());
        }
    }

    private void validateHierachy(Hierarchy hier) {
        block4: {
            Object[] levels;
            block2: {
                oracle.dbtools.crest.model.design.multidimensional.Level level;
                block7: {
                    block6: {
                        block5: {
                            block3: {
                                levels = hier.getLevels().toArray();
                                if (!hier.isValueBasedHierarchy()) break block2;
                                level = (oracle.dbtools.crest.model.design.multidimensional.Level)levels[0];
                                if (levels.length <= 1) break block3;
                                this.valid = false;
                                this.validationSB.append("\nValue based hierachy " + hier.getName() + " has levels connected to its defintition level " + level.getName());
                                break block4;
                            }
                            if (level.getLevelEntity() != null) break block5;
                            this.valid = false;
                            this.validationSB.append("\nLevel Entity is not defined for " + level.getName());
                            break block4;
                        }
                        if (level.getLevelKey().size() != 0) break block6;
                        this.valid = false;
                        this.validationSB.append("\nLevel key attributes are not defined for " + level.getName());
                        break block4;
                    }
                    if (level.getParentKey().size() != 0) break block7;
                    this.valid = false;
                    this.validationSB.append("\nParent key attributes are nod defined for Value Based Hierarchy in level " + level.getName());
                    break block4;
                }
                if (level.getParentKey().size() == level.getLevelKey().size()) break block4;
                this.valid = false;
                this.validationSB.append("\nThe number of parent key attributes for Value Based Hierarchy in level " + level.getName());
                this.validationSB.append(" differ from number of key attributes ");
                break block4;
            }
            for (int i = 0; i < levels.length - 1; ++i) {
                oracle.dbtools.crest.model.design.multidimensional.Level level = (oracle.dbtools.crest.model.design.multidimensional.Level)levels[i];
                oracle.dbtools.crest.model.design.multidimensional.Level uplevel = (oracle.dbtools.crest.model.design.multidimensional.Level)levels[i + 1];
                Link link = level.getFirstLinkToTarget(uplevel);
                if (level.getLevelKey().size() == 0) {
                    this.valid = false;
                    this.validationSB.append("\nLevel key attributes are not defined for " + level.getName());
                    continue;
                }
                if (link == null) continue;
                RollupLink rl = link.getRollupLink();
                if (level.getLevelEntity() == uplevel.getLevelEntity() || rl.getChildToParentAttributes().size() == uplevel.getLevelKey().size()) continue;
                this.valid = false;
                this.validationSB.append("\nThe number of reference attributes from level " + level.getName() + " ito level " + uplevel.getName());
                this.validationSB.append(" differ from number of key attributes for level " + uplevel.getName());
            }
        }
    }

    private void validateAWAttributes(oracle.dbtools.crest.model.design.multidimensional.Level level, boolean isTimeDimeansion) {
        Level.OraAWAttributes awa = level.getOraAWAttributes();
        if (awa.shortDesc == null) {
            this.warning = true;
            this.warningsSB.append("\nSHORT_DESCRIPTION attribute is not defined for " + level.getName());
        }
        if (awa.longDesc == null) {
            this.warning = true;
            this.warningsSB.append("\nLONG_DESCRIPTION attribute is not defined for " + level.getName());
        }
        if (isTimeDimeansion) {
            if (awa.timeSpan == null) {
                this.warning = true;
                this.warningsSB.append("\nTIME_SPAN attribute is not defined for " + level.getName());
            }
            if (awa.timeEnd == null) {
                this.warning = true;
                this.warningsSB.append("\nTIME_END attribute is not defined for " + level.getName());
            }
        }
    }

    private void validateSlice(Slice slice) {
        slice.verifyMeasureWrappers();
        if (slice.getSelectedLevels().size() == 0) {
            this.valid = false;
            this.validationSB.append("\nThere is no dimension usage for slice " + slice.getName());
        }
        for (Slice.MeasureWrapper mw : slice.getSelectedMeasureWrappers()) {
            List list = this.getMeasureDependenciesFor(mw.getMeasure(), slice.getCube().getMeasures());
            String mnames = "";
            boolean first = true;
            for (int i = 0; i < list.size(); ++i) {
                oracle.dbtools.crest.model.design.multidimensional.Measure meas = (oracle.dbtools.crest.model.design.multidimensional.Measure)list.get(i);
                Slice.MeasureWrapper tmw = this.findMWrapperFor(meas, meas.getDefaultAggregationFunction(), slice.getSelectedMeasureWrappers());
                if (tmw != null) continue;
                if (first) {
                    first = false;
                    mnames = meas.getName() + " - " + meas.getDefaultAggregationFunction().name;
                    continue;
                }
                mnames = mnames + " ," + meas.getName() + " - " + meas.getDefaultAggregationFunction().name;
            }
            if ("".equals(mnames)) continue;
            this.valid = false;
            this.validationSB.append("\nDependence error in Slice - " + slice.getName() + "measure " + mw.getMeasure().getName() + "depends on measures: " + mnames);
        }
    }

    private List getMeasureDependenciesFor(oracle.dbtools.crest.model.design.multidimensional.Measure inmeasure, List measures) {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure> list = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure>();
        if (!inmeasure.isFormula()) {
            return list;
        }
        oracle.dbtools.crest.model.design.multidimensional.Measure usedMeasure = inmeasure.getUsedOLAPMeasure();
        String formula = inmeasure.getFormula().toUpperCase();
        for (oracle.dbtools.crest.model.design.multidimensional.Measure measure : measures) {
            String namedq;
            if (measure == inmeasure || !inmeasure.isFormula()) continue;
            if (inmeasure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
                if (usedMeasure == null || usedMeasure != measure) continue;
                list.add(usedMeasure);
                continue;
            }
            if (measure.isCustomFormula() || formula.indexOf(namedq = "\"" + measure.getName().toUpperCase().trim() + "\"") <= -1) continue;
            list.add(measure);
        }
        return list;
    }

    private Slice.MeasureWrapper findMWrapperFor(oracle.dbtools.crest.model.design.multidimensional.Measure measure, Measure.AggregateFunction af, List wrappers) {
        for (Slice.MeasureWrapper mw : wrappers) {
            if (mw.getMeasure() != measure || af != mw.getAggrFunction()) continue;
            return mw;
        }
        return null;
    }

    private void exportCalcMeasures() {
        this.overwrite = this.exportType.equals(EXPORT_ALL_CALC_MEASURES);
        this.captureDimensions();
        this.captureFolders();
        for (AWExportOptions.SelObject so : this.selectedObjects) {
            if (so.object instanceof Cube && so.selected) {
                Cube cube = (Cube)so.object;
                if (cube.hasRolePlayingDimensions()) continue;
                this.exportCubeCalcMeasures(cube);
                continue;
            }
            if (!(so.object instanceof Slice) || !so.selected) continue;
            Slice slice = (Slice)so.object;
            this.exportSliceCalcMeasures(slice);
        }
        this.exportMeasureFolders();
        this.dp.getTransactionProvider().commitCurrentTransaction();
    }

    private void captureAWCubeMeasures(Cube cube, MdmCube awcube) {
        List vmder = awcube.getMeasures();
        ArrayList awmderlist = new ArrayList(vmder);
        for (oracle.dbtools.crest.model.design.multidimensional.Measure meas : cube.getMeasures()) {
            MdmDerivedMeasure awmeas;
            if (!meas.isFormula() && !meas.isFactDimension()) {
                awmeas = awcube.findOrCreateBaseMeasure(meas.getNameInOracleAW());
                if (awmeas == null) continue;
                this.measMap.put(meas.getObjectID(), awmeas);
                this.awmeasToMeasure.put(awmeas.getID(), meas);
                this.awmeasMap.put(awmeas.getID(), awmeas);
                awmderlist.remove(awmeas);
                continue;
            }
            awmeas = awcube.findOrCreateDerivedMeasure(meas.getNameInOracleAW());
            if (awmeas == null) continue;
            this.measMap.put(meas.getObjectID(), awmeas);
            this.awmeasToMeasure.put(awmeas.getID(), meas);
            this.awmeasMap.put(awmeas.getID(), awmeas);
            awmderlist.remove(awmeas);
        }
        for (MdmMeasure awmeas : awmderlist) {
            this.additionalAWMeasures.put(awmeas.getID(), awmeas);
            this.awmeasMap.put(awmeas.getID(), awmeas);
        }
    }

    private void deleteAWMeasures(List measures, MdmCube awcube) {
        for (int i = measures.size() - 1; i > -1; --i) {
            oracle.dbtools.crest.model.design.multidimensional.Measure meas = (oracle.dbtools.crest.model.design.multidimensional.Measure)measures.get(i);
            MdmDerivedMeasure awmeas = (MdmDerivedMeasure)this.measMap.get(meas.getObjectID());
            if (awmeas == null || !(awmeas instanceof MdmDerivedMeasure)) continue;
            awcube.removeMeasure((MdmMeasure)awmeas);
        }
    }

    private void exportCubeCalcMeasures(Cube cube) {
    }

    private void exportSliceCalcMeasures(Slice slice) {
    }

    private boolean isValidMeasure(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List measures) {
        List list = this.getMeasureDependencies(measure, measures);
        if (list.size() == 0) {
            return true;
        }
        boolean result = true;
        for (oracle.dbtools.crest.model.design.multidimensional.Measure meas : list) {
            Measure awmeas;
            if (meas.isFormula() || (awmeas = (Measure)this.measMap.get(meas.getObjectID())) != null) continue;
            result = false;
        }
        return result;
    }

    private List getMeasureDependencies(oracle.dbtools.crest.model.design.multidimensional.Measure measure, List measures) {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure> list = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Measure>();
        if (!measure.isFormula()) {
            return list;
        }
        if (measure.getOracleAWFormulaType().equalsIgnoreCase(oracle.dbtools.crest.model.design.multidimensional.Measure.AW_OLAP_FORMULA)) {
            oracle.dbtools.crest.model.design.multidimensional.Measure usedMeasure = measure.getUsedOLAPMeasure();
            if (usedMeasure != null) {
                list.add(usedMeasure);
            }
        } else if (!measure.isCustomFormula()) {
            String formula = measure.getFormula().toUpperCase();
            for (oracle.dbtools.crest.model.design.multidimensional.Measure measn : measures) {
                String namedq;
                if (measn == measure || formula.indexOf(namedq = "\"" + measn.getName().toUpperCase().trim() + "\"") <= -1) continue;
                list.add(measn);
            }
        }
        return list;
    }

    private void captureFolders() {
    }

    private void captureDimensions() {
        ArrayList dimlist = new ArrayList(this.globalAW.getDimensions());
        Iterator it = this.mdmDesign.getDimensionSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)it.next();
            oracle.AWXML.Dimension awdim = this.findDimension(dimlist, dim.getNameInOracleAW());
            if (awdim == null) continue;
            this.dimMap.put(dim.getObjectID(), awdim);
            this.captureDimension(awdim, dim);
        }
    }

    private void captureDimension(oracle.AWXML.Dimension awdim, oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        ArrayList awlevels = new ArrayList(awdim.getLevels());
        for (oracle.dbtools.crest.model.design.multidimensional.Level level : dim.getAllLevels()) {
            Level awlevel = this.findLevel(awlevels, level.getNameInOracleAW());
            if (awlevel == null) continue;
            this.levMap.put(level.getObjectID() + dim.getObjectID(), awlevel);
        }
        ArrayList awhiers = new ArrayList(awdim.getHierarchies());
        for (Hierarchy hier : dim.getHierarchies()) {
            oracle.AWXML.Hierarchy awhier = this.findHierarchy(awhiers, hier.getNameInOracleAW());
            if (awhier == null) continue;
            this.hierMap.put(hier.getObjectID(), awhier);
        }
    }

    private Level findLevel(List awlevels, String name) {
        for (Level awlevel : awlevels) {
            if (!name.equalsIgnoreCase(awlevel.getName())) continue;
            return awlevel;
        }
        return null;
    }

    private oracle.AWXML.Hierarchy findHierarchy(List awhiers, String name) {
        for (oracle.AWXML.Hierarchy awhier : awhiers) {
            if (!name.equalsIgnoreCase(awhier.getName())) continue;
            return awhier;
        }
        return null;
    }

    private oracle.AWXML.Dimension findDimension(List awdims, String name) {
        for (oracle.AWXML.Dimension awdim : awdims) {
            if (!name.equalsIgnoreCase(awdim.getName())) continue;
            return awdim;
        }
        return null;
    }

    private void exportMeasureFolders() {
    }

    private String getExportedXML() {
        String expXML = "";
        return expXML;
    }

    private void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public void exportToXML(BaseMetadataObject bo, String fileName) {
        ArrayList<BaseMetadataObject> objects = new ArrayList<BaseMetadataObject>();
        objects.add(bo);
        this.exportToXML(objects, fileName);
    }

    public void exportToXML(List objects, String fileName) {
        try {
            HashMap renameMap = new HashMap();
            boolean includeOwnerString = false;
            Object writer = null;
            String xml = this.metadataProvider.exportFullXML(objects, null, includeOwnerString);
            if (fileName == null) {
                fileName = "buildAWG";
            }
            if (!fileName.toUpperCase().endsWith(".XML")) {
                fileName = fileName + ".xml";
            }
            FileOutputStream fos = new FileOutputStream(fileName);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            BufferedWriter buf = new BufferedWriter(osw);
            buf.write(xml);
            buf.close();
            osw.close();
            fos.close();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    private void commit(String objName) {
        try {
            this.dp.getTransactionProvider().commitCurrentTransaction();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void rollback(String objName) {
        try {
            this.dp.getTransactionProvider().rollbackCurrentTransaction();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void run() throws Exception {
        if (this.exportType.equals(EXPORT_METADATA_TO_FILE)) {
            new Thread(new Runner()).start();
        } else if (this.validConnection()) {
            if (this.exportType.equals(EXPORT_ALL_CALC_MEASURES) || this.exportType.equals(EXPORT_NEW_CALC_MEASURES)) {
                new Thread(new CalcMeasuresRunner()).start();
            } else {
                new Thread(new Runner()).start();
            }
        }
    }

    class MeasureDependence {
        oracle.dbtools.crest.model.design.multidimensional.Measure measure;
        List dependOn = new ArrayList();

        MeasureDependence(oracle.dbtools.crest.model.design.multidimensional.Measure measure) {
            this.measure = measure;
        }
    }

    private class CalcMeasuresRunner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                try {
                    OracleAW11Exporter.this.monitor = new ProgressDialog(OracleAW11Exporter.this.appView, "", 0, 100);
                    try {
                        if (OracleAW11Exporter.this.exportType.equals(EXPORT_ALL_CALC_MEASURES) || OracleAW11Exporter.this.exportType.equals(EXPORT_NEW_CALC_MEASURES)) {
                            OracleAW11Exporter.this.atached = false;
                            OracleAW11Exporter.this.monitor.setProgress(5);
                            OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.ReadDefinitions"));
                            boolean ok = OracleAW11Exporter.this.readAWDefinitions(OracleAW11Exporter.this.user, OracleAW11Exporter.this.awName);
                            if (ok) {
                                int result;
                                File xmlFile;
                                OracleAW11Exporter.this.dimMap = new TreeMap();
                                OracleAW11Exporter.this.hierMap = new TreeMap();
                                OracleAW11Exporter.this.awdimMap = new TreeMap();
                                OracleAW11Exporter.this.dimensionalityMap = new TreeMap();
                                OracleAW11Exporter.this.monitor.setProgress(40);
                                OracleAW11Exporter.this.atached = true;
                                OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.ExportCalculatedMeasures"));
                                OracleAW11Exporter.this.exportCalcMeasures();
                                OracleAW11Exporter.this.commited = false;
                                OracleAW11Exporter.this.commited = true;
                                ok = true;
                                if ("".equals(OracleAW11Exporter.this.fileName.trim())) {
                                    ok = false;
                                }
                                if (OracleAW11Exporter.this.fileName.indexOf(46) == -1) {
                                    OracleAW11Exporter.this.fileName = OracleAW11Exporter.this.fileName + ".xml";
                                }
                                if ((xmlFile = new File(OracleAW11Exporter.this.fileName)).exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.FileExists") + '\"' + xmlFile.getAbsolutePath() + '\"' + " already exists.\nDo you want to overwrite it?", Messages.getString("OracleAWExporter.Warning"), 0, 3, OracleAW11Exporter.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                                    ok = false;
                                }
                                if (ok) {
                                    String XML = OracleAW11Exporter.this.getExportedXML();
                                    try {
                                        if (ok) {
                                            OracleAW11Exporter.this.monitor.setProgress(95);
                                            OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.WriteExportedMetadataToFile"));
                                            FileWriter xmlout = new FileWriter(xmlFile);
                                            xmlout.write(XML);
                                            xmlout.write("\n");
                                            xmlout.close();
                                            OracleAW11Exporter.this.monitor.setProgress(100);
                                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.ExportedOk"));
                                        }
                                    }
                                    catch (Exception e) {
                                        String error = e.toString();
                                        LOGGER.error("Failure to write XML string to file: " + OracleAW11Exporter.this.fileName + "\n", e);
                                        System.out.println("Failure to write XML string to file: " + OracleAW11Exporter.this.fileName + "\n" + error);
                                    }
                                }
                            }
                        }
                        OracleAW11Exporter.this.monitor.close();
                        if (OracleAW11Exporter.this.commited) return;
                    }
                    catch (Throwable throwable) {
                        OracleAW11Exporter.this.monitor.close();
                        if (OracleAW11Exporter.this.commited) throw throwable;
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorDuringExportToAnlyticalWorkspace"), OracleAW11Exporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                        throw throwable;
                    }
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorDuringExportToAnlyticalWorkspace"), OracleAW11Exporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                    return;
                }
                finally {
                    if (OracleAW11Exporter.this.atached && OracleAW11Exporter.this.globalAW != null) {
                        OracleAW11Exporter.this.atached = false;
                    }
                }
            }
            catch (Exception e) {
                OracleAW11Exporter.this.err = e.toString();
                LOGGER.error("Error Generate Analytical Workspace: ", e);
                if (OracleAW11Exporter.this.atached && OracleAW11Exporter.this.globalAW != null) {
                    OracleAW11Exporter.this.atached = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogReport lr2 = new LogReport(OracleAW11Exporter.this.mdmDesign.getAppView());
                        lr2.setName("Error Log");
                        lr2.setLog(OracleAW11Exporter.this.err);
                        lr2.showDialog(new Dimension(750, 550));
                    }
                });
                return;
            }
            finally {
                OracleAW11Exporter.this.closeConnection();
                System.gc();
            }
        }
    }

    private class Runner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            try {
                block53: {
                    block56: {
                        block54: {
                            block55: {
                                block50: {
                                    block52: {
                                        OracleAW11Exporter.this.monitor = new ProgressDialog(OracleAW11Exporter.this.appView, "", 0, 100);
                                        OracleAW11Exporter.this.monitor.setProgress(1);
                                        OracleAW11Exporter.this.monitor.setNote(" ");
                                        try {
                                            int result;
                                            File xmlFile;
                                            if (!OracleAW11Exporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) break block50;
                                            boolean ok = true;
                                            if ("".equals(OracleAW11Exporter.this.fileName.trim())) {
                                                OracleAW11Exporter.this.fileName = OracleAW11Exporter.this.awName.trim() + ".xml";
                                            }
                                            if (OracleAW11Exporter.this.fileName.indexOf(46) == -1) {
                                                OracleAW11Exporter.this.fileName = OracleAW11Exporter.this.fileName + ".xml";
                                            }
                                            if ((xmlFile = new File(OracleAW11Exporter.this.fileName)).exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.FileExists"), xmlFile.getAbsolutePath()), Messages.getString("OracleAWExporter.Warning"), 0, 3, OracleAW11Exporter.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                                                ok = false;
                                            }
                                            if (!ok) break block50;
                                            OracleAW11Exporter.this.dimMap = new TreeMap();
                                            OracleAW11Exporter.this.hierMap = new TreeMap();
                                            OracleAW11Exporter.this.awdimMap = new TreeMap();
                                            OracleAW11Exporter.this.dimensionalityMap = new TreeMap();
                                            OracleAW11Exporter.this.globalAW = OracleAW11Exporter.this.mdmDBSchema.findOrCreateAW(OracleAW11Exporter.this.awName);
                                            try {
                                                OracleAW11Exporter.this.monitor.setProgress(5);
                                                OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.BuildAnalyticWorkspace"));
                                                OracleAW11Exporter.this.createAW();
                                                HashMap renameMap = new HashMap();
                                                boolean includeOwnerString = false;
                                                ArrayList<AW> objects = new ArrayList<AW>();
                                                objects.add(OracleAW11Exporter.this.globalAW);
                                                try {
                                                    PrintWriter writer = new PrintWriter(new FileWriter(xmlFile));
                                                    OracleAW11Exporter.this.metadataProvider.exportFullXML((Writer)writer, objects, null, false);
                                                    writer.close();
                                                }
                                                catch (IOException ie) {
                                                    ie.printStackTrace();
                                                }
                                                OracleAW11Exporter.this.rollback("test");
                                            }
                                            finally {
                                                OracleAW11Exporter.this.shutdown();
                                                if (OracleAW11Exporter.this.dp != null) {
                                                    OracleAW11Exporter.this.dp = null;
                                                }
                                            }
                                            OracleAW11Exporter.this.monitor.close();
                                            if (OracleAW11Exporter.this.commited || OracleAW11Exporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) break block52;
                                        }
                                        catch (Throwable throwable) {
                                            OracleAW11Exporter.this.monitor.close();
                                            if (!OracleAW11Exporter.this.commited && !OracleAW11Exporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) {
                                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAW11Exporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                                            }
                                            throw throwable;
                                        }
                                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAW11Exporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                                    }
                                    return;
                                }
                                OracleAW11Exporter.this.monitor.setProgress(5);
                                OracleAW11Exporter.this.atached = false;
                                OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.DeleteExistingAnalyticWorkspace"));
                                if (OracleAW11Exporter.this.user == null) {
                                    OracleAW11Exporter.this.user = OracleAW11Exporter.this.connection.getMetaData().getUserName();
                                }
                                if ("".equals(OracleAW11Exporter.this.schema)) {
                                    OracleAW11Exporter.this.schema = OracleAW11Exporter.this.user;
                                }
                                boolean result = OracleAW11Exporter.this.deleteExistingAW((oracle.jdbc.OracleConnection)OracleAW11Exporter.this.connection, OracleAW11Exporter.this.user, OracleAW11Exporter.this.awName);
                                OracleAW11Exporter.this.monitor.setProgress(20);
                                if (OracleAW11Exporter.this.atached) {
                                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.AnalyticWorkspaceAttached"), OracleAW11Exporter.this.user, OracleAW11Exporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                                    break block53;
                                }
                                OracleAW11Exporter.this.dimMap = new TreeMap();
                                OracleAW11Exporter.this.hierMap = new TreeMap();
                                OracleAW11Exporter.this.awdimMap = new TreeMap();
                                OracleAW11Exporter.this.dimensionalityMap = new TreeMap();
                                if (result) break block54;
                                OracleAW11Exporter.this.shutdown();
                                if (OracleAW11Exporter.this.dp != null) {
                                    OracleAW11Exporter.this.dp = null;
                                }
                                if (OracleAW11Exporter.this.created) {
                                    OracleAW11Exporter.this.monitor.setProgress(95);
                                    OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.DetachAnalyticWorkspace"));
                                    OracleAW11Exporter.this.atached = false;
                                }
                                OracleAW11Exporter.this.monitor.close();
                                if (OracleAW11Exporter.this.commited || OracleAW11Exporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) break block55;
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAW11Exporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                            }
                            return;
                        }
                        OracleAW11Exporter.this.globalAW = OracleAW11Exporter.this.mdmDBSchema.findOrCreateAW(OracleAW11Exporter.this.awName);
                        OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.BuildAnalyticWorkspace"));
                        OracleAW11Exporter.this.createAW();
                        HashMap renameMap = new HashMap();
                        boolean includeOwnerString = false;
                        ArrayList<AW> objects = new ArrayList<AW>();
                        objects.add(OracleAW11Exporter.this.globalAW);
                        OracleAW11Exporter.this.dp.getTransactionProvider().commitCurrentTransaction();
                        String xml = "empty";
                        try {
                            boolean ok = true;
                            if ("".equals(OracleAW11Exporter.this.fileName.trim())) {
                                ok = false;
                            }
                            File xmlFile = null;
                            if (ok) {
                                int result1;
                                if (OracleAW11Exporter.this.fileName.indexOf(46) == -1) {
                                    OracleAW11Exporter.this.fileName = OracleAW11Exporter.this.fileName + ".xml";
                                }
                                if ((xmlFile = new File(OracleAW11Exporter.this.fileName)).exists() && (result1 = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.FileExists") + '\"' + xmlFile.getAbsolutePath() + '\"' + " already exists.\nDo you want to overwrite it?", Messages.getString("OracleAWExporter.Warning"), 0, 3, OracleAW11Exporter.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                                    ok = false;
                                }
                            }
                            if (ok) {
                                try {
                                    PrintWriter writer = new PrintWriter(new FileWriter(xmlFile));
                                    OracleAW11Exporter.this.metadataProvider.exportFullXML((Writer)writer, objects, null, false);
                                    writer.close();
                                }
                                catch (IOException ie) {
                                    ie.printStackTrace();
                                }
                            }
                        }
                        catch (Exception e) {
                            String error = e.toString();
                            LOGGER.error("Failure to write XML string to file: " + OracleAW11Exporter.this.fileName + "\n", e);
                            System.out.println("Failure to write XML string to file: " + OracleAW11Exporter.this.fileName + "\n" + error);
                        }
                        if (OracleAW11Exporter.this.buildAW) {
                            OracleAW11Exporter.this.monitor.setProgress(25);
                        } else {
                            OracleAW11Exporter.this.monitor.setProgress(40);
                        }
                        OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.CreateAnalyticWorkspace"));
                        OracleAW11Exporter.this.atached = true;
                        if (OracleAW11Exporter.this.buildAW) {
                            OracleAW11Exporter.this.monitor.setProgress(50);
                        } else {
                            OracleAW11Exporter.this.monitor.setProgress(75);
                        }
                        OracleAW11Exporter.this.created = true;
                        OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.CommitAnalyticWorkspace"));
                        OracleAW11Exporter.this.dp.getTransactionProvider().commitCurrentTransaction();
                        OracleAW11Exporter.this.commited = true;
                        if (OracleAW11Exporter.this.buildAW) {
                            try {
                                OracleAW11Exporter.this.monitor.setProgress(70);
                                OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.PopulatingAalyticWorkspace"));
                                OracleAW11Exporter.this.xml_build_global_aw(OracleAW11Exporter.this.awName);
                            }
                            catch (Exception e) {
                                System.out.println("The following error occurred while building  " + OracleAW11Exporter.this.awName + ":\n\t" + e.toString());
                            }
                        }
                        break block56;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        finally {
                            OracleAW11Exporter.this.shutdown();
                            if (OracleAW11Exporter.this.dp != null) {
                                OracleAW11Exporter.this.dp = null;
                            }
                            if (OracleAW11Exporter.this.created) {
                                OracleAW11Exporter.this.monitor.setProgress(95);
                                OracleAW11Exporter.this.monitor.setNote(Messages.getString("OracleAWExporter.DetachAnalyticWorkspace"));
                                OracleAW11Exporter.this.atached = false;
                            }
                        }
                    }
                    OracleAW11Exporter.this.monitor.setProgress(100);
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("OracleAWExporter.ExportedOk"));
                }
                OracleAW11Exporter.this.monitor.close();
                if (!OracleAW11Exporter.this.commited && !OracleAW11Exporter.this.exportType.equals(EXPORT_METADATA_TO_FILE)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OracleAWExporter.ErrorCreatingAnlyticalWorkspace"), OracleAW11Exporter.this.awName), Messages.getString("OracleAWExporter.Error"), 0);
                }
            }
            catch (Exception e) {
                OracleAW11Exporter.this.err = e.toString();
                LOGGER.error("Error Generate Analytical Workspace: ", e);
                if (OracleAW11Exporter.this.atached) {
                    OracleAW11Exporter.this.atached = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogReport lr2 = new LogReport(OracleAW11Exporter.this.mdmDesign.getAppView());
                        lr2.setName("Error Log");
                        lr2.setLog(OracleAW11Exporter.this.err);
                        lr2.showDialog(new Dimension(750, 550));
                    }
                });
            }
            finally {
                OracleAW11Exporter.this.closeConnection();
                System.gc();
            }
        }
    }

    class MeasureDesc {
        MdmMeasure awmeasure;
        oracle.dbtools.crest.model.design.multidimensional.Measure measure;
        String awmeasureName;
        Slice.MeasureWrapper mwrapper;

        MeasureDesc() {
        }
    }

    class LevelDesc {
        oracle.dbtools.crest.model.design.multidimensional.Level level;
        oracle.dbtools.crest.model.design.multidimensional.Dimension dim;
        MdmDimensionLevel olevel;
        MdmPrimaryDimension odimension;
        ContainedObject attribute;

        LevelDesc() {
        }
    }
}

