/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.awt.Component;
import java.awt.Cursor;
import java.sql.Connection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.RSGlossary;
import oracle.dbtools.crest.exports.reports.RSGlossaryTerms;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class GlossaryHandler {
    private ApplicationView appView;
    private ProgressDialog monitor;
    private Connection connection = null;
    private String comments;
    private Glossary glossary;
    private Map map;
    private static final Logger LOGGER = new Logger(GlossaryHandler.class);

    public GlossaryHandler(ApplicationView view, Connection connection, String comments, Glossary glossary) {
        this.appView = view;
        this.connection = connection;
        this.comments = comments;
        this.glossary = glossary;
        this.map = new TreeMap();
    }

    public void export() {
        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.monitor = new ProgressDialog(this.appView, "", 0, 100);
            try {
                this.monitor.setNote(Messages.getString("GlossaryHandler.ConnectingDatabase"));
                this.monitor.setProgress(1);
                if (this.checkDB()) {
                    this.monitor.setNote(Messages.getString("GlossaryHandler.ExportingGlossary"));
                    this.monitor.setProgress(5);
                    RSGlossary.export(this.glossary, this.map, this.connection, this.comments);
                    this.monitor.setNote(Messages.getString("GlossaryHandler.ExportingGlossaryTerms"));
                    this.monitor.setProgress(10);
                    RSGlossaryTerms.export(this.glossary, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("GlossaryHandler.ExportComplete"));
                    this.monitor.setProgress(100);
                    MessageDialogs.showMessage(Messages.getString("GlossaryHandler.GlossaryExportedSuccessfully"));
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            finally {
                this.monitor.close();
            }
        }
        catch (Exception e) {
            if (this.connection != null) {
                try {
                    this.connection.rollback();
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (e.toString().indexOf("ORA-01017") > -1) {
                LOGGER.error("Error Exporting Glossary to Reporting Schema: Error=" + e.getMessage());
                MessageDialogs.showErrorMessage(Messages.getString("GlossaryHandler.ErrorUserPassword"), true);
            } else {
                LOGGER.error("Error Exporting Glossary to Reporting Schema: ", e);
                MessageDialogs.showErrorMessage(Messages.getString("GlossaryHandler.ErrorSeeLogFile"), true);
            }
        }
        finally {
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDB() throws Exception {
        if (this.connection != null) {
            boolean autoCommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                float schemaVersion = SchemaFactory.schemaVersion(this.connection);
                if (schemaVersion == 0.0f) {
                    boolean bl = SchemaFactory.createSchema(this.connection);
                    return bl;
                }
                if (schemaVersion != 1.6f) {
                    throw new DifferentVersionException();
                }
            }
            catch (DifferentVersionException dve) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("GlossaryHandler.SchemaVersionOutOfDate"), Messages.getString("GlossaryHandler.Warning"), 2);
                boolean bl = false;
                return bl;
            }
            finally {
                this.connection.setAutoCommit(autoCommit);
            }
            return true;
        }
        return false;
    }
}

