/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;

public class RSExistenceDependanciesColumns
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, Table table, String exDepOVID) throws Exception {
        String query = "INSERT INTO DMRS_EXISTENCE_DEP_COLUMNS (Dependency_OVID, Discriminator_Value, Table_Name, Table_OVID, Column_Name, Column_OVID, Depend_As_Mandatory, Depend, Design_OVID)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Column dColumn = table.getDiscriminatorColumn();
        for (Column column : Arrays.asList(table.getElements())) {
            if (column == dColumn || column.isMandatory()) continue;
            Iterator vit = dColumn.getValueIterator();
            boolean seq = false;
            while (vit.hasNext()) {
                String key = (String)vit.next();
                Map s = table.getDiscriminatorColumn().getDependentColumnDescriptorsMap(key);
                Column.DependentColumnDescriptor desc = (Column.DependentColumnDescriptor)s.get(column.getObjectID());
                if (desc == null) continue;
                stmt.setString(1, exDepOVID);
                stmt.setString(2, desc.getDiscriminatorValue());
                stmt.setString(3, table.getName());
                stmt.setString(4, (String)map.get(table.getObjectID()));
                stmt.setString(5, desc.getColumn().getName());
                stmt.setString(6, (String)map.get(desc.getColumnID()));
                stmt.setString(7, desc.isDependAsMandatory() ? "Y" : "N");
                stmt.setString(8, desc.isDependOnValue() ? "Y" : "N");
                stmt.setString(9, (String)map.get(design.getObjectID()));
                stmt.execute();
            }
        }
        stmt.close();
        stmt = null;
    }
}

