/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.InfoStructure;

public class RSInfoStructureAttributes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, ModelIDObject modelIDObject) throws Exception {
        if (modelIDObject instanceof InfoStructure) {
            InfoStructure info = (InfoStructure)modelIDObject;
            int count = 0;
            String query = "INSERT INTO DMRS_INFO_STRUCT_ATTRS (Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Attribute_ID, Attribute_OVID, Attribute_Name, Entity_ID, Entity_OVID, Entity_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = connection.prepareStatement(query);
            String des_ovid = (String)map.get(design.getObjectID());
            String info_id = info.getObjectID();
            String info_ovid = (String)map.get(info.getObjectID());
            String info_name = info.getName();
            for (Attribute attr : info.getAttributes()) {
                Entity ent = attr.getEntity();
                stmt.setString(1, info_id);
                stmt.setString(2, info_ovid);
                stmt.setString(3, info_name);
                stmt.setString(4, attr.getObjectID());
                stmt.setString(5, (String)map.get(attr.getObjectID()));
                stmt.setString(6, attr.getName());
                stmt.setString(7, ent.getObjectID());
                stmt.setString(8, (String)map.get(ent.getObjectID()));
                stmt.setString(9, ent.getName());
                stmt.setString(10, des_ovid);
                stmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
            }
            if (count > 0) {
                count = 0;
                stmt.executeBatch();
            }
            stmt.close();
            stmt = null;
        }
    }
}

