/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;

public class RSProcessEntities
extends RSGeneral {
    private static final Logger LOGGER = new Logger(RSProcessEntities.class);

    public static void export(Design design, Map map, Connection connection) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_PROCESS_ENTITIES (Process_ID, Process_OVID, Entity_ID, Entity_OVID, Flow_ID, Flow_OVID, DFD_ID, DFD_OVID, Process_Name, Entity_Name, Flow_Name, DFD_Name, OP_Read, OP_Create, OP_Update, OP_Delete, CRUD_Code, Flow_Direction, Model_ID, Model_OVID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
            String dfdOVID = RSProcessEntities.getOrCreateOVID(map, dfd.getObjectID());
            if (dfd.getTopLevelDataFlowDesign() == null) {
                LOGGER.error("RSProcessEntities.export(): DataFlow Diagram (" + dfd.getName() + ") has no parent object and must be deleted from the file system.\n Delete the file and related directory - " + dfd.getSegmentedStorageName());
                continue;
            }
            String tlName = dfd.getTopLevelDataFlowDesign().getName();
            Iterator dfdit = dfd.getProcessSet().iterator();
            while (dfdit.hasNext()) {
                Process process = (Process)dfdit.next();
                if (process.getType() != 0) continue;
                String procOVID = new GUID().toString();
                map.put(process.getObjectID(), procOVID);
                for (Process.ProcessedObject po : process.getProcessedEntitiesAndFlows(false)) {
                    stmt.setString(1, process.getObjectID());
                    stmt.setString(2, procOVID);
                    stmt.setString(3, po.getObject().getObjectID());
                    stmt.setString(4, (String)map.get(po.getObject().getObjectID()));
                    stmt.setString(5, po.getFlow().getObjectID());
                    stmt.setString(6, RSProcessEntities.getOrCreateOVID(map, po.getFlow().getObjectID()));
                    stmt.setString(7, dfd.getObjectID());
                    stmt.setString(8, dfdOVID);
                    stmt.setString(9, process.getName());
                    stmt.setString(10, po.getObject().getName());
                    stmt.setString(11, po.getFlow().getName());
                    stmt.setString(12, tlName);
                    stmt.setString(13, po.isOpRead() ? "Y" : "N");
                    stmt.setString(14, po.isOpCreate() ? "Y" : "N");
                    stmt.setString(15, po.isOpUpdate() ? "Y" : "N");
                    stmt.setString(16, po.isOpDelete() ? "Y" : "N");
                    if (po.isOpRead()) {
                        stmt.setString(17, "R");
                    } else {
                        String crud = "";
                        if (po.isOpCreate()) {
                            crud = "C";
                        }
                        if (po.isOpUpdate()) {
                            crud = crud + "U";
                        }
                        if (po.isOpDelete()) {
                            crud = crud + "D";
                        }
                        stmt.setString(17, crud);
                    }
                    stmt.setString(18, po.isInbound() ? "IN" : "OUT");
                    stmt.setString(19, processModel.getObjectID());
                    stmt.setString(20, (String)map.get(processModel.getObjectID()));
                    stmt.setString(21, processModel.getName());
                    stmt.setString(22, (String)map.get(design.getObjectID()));
                    stmt.addBatch();
                    if (++count != 1000) continue;
                    count = 0;
                    stmt.executeBatch();
                }
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

