/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;

public class SchemaFactory {
    public static final float NO_SCHEMA_VERSION = 0.0f;
    public static final float FIRST_SCHEMA_VERSION = 0.1f;
    public static final float PERSISTENCE_VERSION = 1.6f;
    public static final float SUPERSEDED_VERSION = 1.5f;
    public static final float DATA_MODELER_REPORTS_VERSION = 1.0f;
    private static final Logger LOGGER = new Logger(SchemaFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float schemaVersion(Connection connection) throws Exception {
        Float version = Float.valueOf(0.0f);
        Statement version_stmt = null;
        ResultSet version_rset = null;
        String version_query = "SELECT DMRS_Persistence_Version from DMRS_INSTALLATION";
        Statement design_stmt = null;
        ResultSet design_rset = null;
        String design_query = "SELECT count(*) from DMRS_DESIGNS";
        try {
            version_stmt = connection.createStatement();
            version_rset = version_stmt.executeQuery(version_query);
            if (version_rset != null && version_rset.next() && (version = Float.valueOf(version_rset.getFloat(1))).floatValue() != 1.6f && version.floatValue() != 1.5f) {
                throw new DifferentVersionException();
            }
        }
        catch (SQLException s) {
            try {
                design_stmt = connection.createStatement();
                design_rset = design_stmt.executeQuery(design_query);
                if (design_rset != null) {
                    version = Float.valueOf(0.1f);
                }
            }
            catch (SQLException s3) {
                version = Float.valueOf(0.0f);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (version_rset != null) {
                    version_rset.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (version_stmt != null) {
                    version_stmt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (design_rset != null) {
                    design_rset.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (design_stmt != null) {
                    design_stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return version.floatValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSchema(Connection connection) {
        boolean bl;
        block25: {
            Statement st = connection.createStatement();
            String query = "";
            try {
                String created = "null";
                ResultSet rset = null;
                query = "select to_char(sysdate,'YYYY/MM/DD HH24:MI:SS') from dual";
                try {
                    rset = st.executeQuery(query);
                    if (rset != null && rset.next()) {
                        created = "to_timestamp('" + rset.getString(1) + "','YYYY/MM/DD HH24:MI:SS')";
                    }
                }
                catch (SQLException sQLException) {
                }
                finally {
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                query = "CREATE OR REPLACE FORCE VIEW DMRS_INSTALLATION AS select " + String.valueOf(1.6f) + " DMRS_Persistence_Version, " + String.valueOf(1.0f) + " DMRS_Reports_Version, " + created + " Created_On from dual with read only";
                st.execute(query);
                String repver = String.valueOf(1.0f).replace('.', '_');
                query = "CREATE VIEW DMRV_REPORTS_VERSION_" + repver + " AS select " + String.valueOf(1.6f) + " DMRS_Persistence_Version, " + String.valueOf(1.0f) + " DMRS_Reports_Version, " + created + " Created_On from dual with read only";
                st.execute(query);
                query = "CREATE TABLE DMRS_Designs (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Date_Published TIMESTAMP, Published_By VARCHAR2 (80), Persistence_Version NUMBER (5,2) NOT NULL, Version_Comments VARCHAR2 (4000))";
                st.execute(query);
                query = "CREATE TABLE DMRS_MODELS (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_Type VARCHAR2 (30) NOT NULL, RDBMS_Type VARCHAR2 (60))";
                st.execute(query);
                query = "CREATE TABLE DMRS_MODEL_SUBVIEWS (Subview_ID VARCHAR2 (70) NOT NULL, Subview_OVID VARCHAR2 (36) NOT NULL, Subview_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_MODEL_DISPLAYS (Display_ID VARCHAR2 (70) NOT NULL, Display_OVID VARCHAR2 (36) NOT NULL, Display_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_ATTRIBUTES (Attribute_Name VARCHAR2 (256) NOT NULL, Object_ID VARCHAR2 (80) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, Mandatory CHAR (1) NOT NULL, DataType_Kind VARCHAR2 (20) NOT NULL, Value_Type VARCHAR2 (10), Formula VARCHAR2 (4000), ScopeEntity_ID VARCHAR2 (70), ScopeEntity_OVID VARCHAR2 (36), Domain_ID VARCHAR2 (70), Domain_OVID VARCHAR2 (36), Logical_Type_ID VARCHAR2 (70), Logical_Type_OVID VARCHAR2 (36), Distinct_Type_ID VARCHAR2 (70), Distinct_Type_OVID VARCHAR2 (36), Structured_Type_ID VARCHAR2 (70), Structured_Type_OVID VARCHAR2 (36), Collection_Type_ID VARCHAR2 (70), Collection_Type_OVID VARCHAR2 (36), Check_Constraint_Name VARCHAR2 (256), Default_Value VARCHAR2 (512), Use_Domain_Constraint CHAR (1), Domain_Name VARCHAR2 (256), Logical_Type_Name VARCHAR2 (256), Structured_Type_Name VARCHAR2 (256), Distinct_Type_Name VARCHAR2 (256), Collection_Type_Name VARCHAR2 (256), Synonyms VARCHAR2 (4000), Preferred_Abbreviation VARCHAR2 (256), Relationship_ID VARCHAR2 (100), Relationship_OVID VARCHAR2 (36), Entity_Name VARCHAR2 (256) NOT NULL, PK_Flag VARCHAR2 (1), FK_Flag VARCHAR2 (1), Relationship_Name VARCHAR2 (256), Sequence NUMBER  NOT NULL, T_Size VARCHAR2 (20), T_Precision NUMBER, Char_Units CHAR (4),Native_Type VARCHAR2 (60),T_Scale NUMBER, Data_Source VARCHAR2 (256), ScopeEntity_Name VARCHAR2 (256), Sensitive_Type_OVID VARCHAR2 (36), Sensitive_Data_Descr VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_AVT (DataElement_ID VARCHAR2 (70) NOT NULL, DataElement_OVID VARCHAR2 (36) NOT NULL, Type VARCHAR2 (10), Sequence NUMBER NOT NULL, Value VARCHAR2 (512) NOT NULL, Short_Description VARCHAR2 (256), Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, Container_Name VARCHAR2 (256) NOT NULL, DataElement_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_BUSINESS_INFO (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Business_Info_ID VARCHAR2 (70) NOT NULL, Business_Info_OVID VARCHAR2 (36) NOT NULL, Business_Info_Name VARCHAR2 (256) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CHANGE_REQUESTS (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Change_Request_ID VARCHAR2 (70) NOT NULL, Change_Request_OVID VARCHAR2 (36) NOT NULL, Change_Request_Name VARCHAR2 (256) NOT NULL, Request_Status VARCHAR2 (30), Request_Date_String VARCHAR2 (30), Completion_Date_String VARCHAR2 (30), Is_Completed CHAR (1), Reason VARCHAR2 (4000))";
                st.execute(query);
                query = "CREATE TABLE DMRS_CHANGE_REQUEST_ELEMENTS (Change_Request_ID VARCHAR2 (70) NOT NULL, Change_Request_OVID VARCHAR2 (36) NOT NULL, Change_Request_Name VARCHAR2 (256) NOT NULL, Element_ID VARCHAR2 (70) NOT NULL, Element_OVID VARCHAR2 (36) NOT NULL, Element_Model_Name VARCHAR2 (256) NOT NULL, Element_Name VARCHAR2 (256) NOT NULL, Element_Type VARCHAR2 (30), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CHECK_CONSTRAINTS (DataElement_ID VARCHAR2 (70) NOT NULL, DataElement_OVID VARCHAR2 (36) NOT NULL, Type VARCHAR2 (10), Sequence NUMBER NOT NULL, Constraint_Name VARCHAR2 (256), Text VARCHAR2 (4000) NOT NULL, Database_Type VARCHAR2 (60) NOT NULL, Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, Container_Name VARCHAR2 (256) NOT NULL, DataElement_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CLASSIFICATION_TYPES (Type_ID VARCHAR2 (70) NOT NULL, Type_OVID VARCHAR2 (36) NOT NULL, Type_Name VARCHAR2 (256) NOT NULL, Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_ADDITIONAL_CT_OBJECTS (Type_OVID VARCHAR2 (36) NOT NULL,Object_OVID VARCHAR2 (36) NOT NULL,Object_ID VARCHAR2 (70) NOT NULL,Object_Type VARCHAR2 (10),Model_OVID VARCHAR2 (36) NOT NULL,Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_COLLECTION_TYPES (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Collection_Type_ID VARCHAR2 (70) NOT NULL, Collection_Type_OVID VARCHAR2 (36) NOT NULL, Collection_Type_Name VARCHAR2 (256) NOT NULL, C_Type VARCHAR2 (30), DataType_ID VARCHAR2 (70), DataType_OVID VARCHAR2 (36), DataType_Name VARCHAR2 (256), DT_Type VARCHAR2 (30), DT_Ref CHAR (1), Max_Element NUMBER, Predefined CHAR (1), Char_Units CHAR (4), T_Size VARCHAR2 (20), T_Precision NUMBER, T_Scale NUMBER, DataType_Kind VARCHAR2 (20), Domain_Name VARCHAR2 (256)) ";
                st.execute(query);
                query = "CREATE TABLE DMRS_COLUMNS (Column_Name VARCHAR2 (256) NOT NULL, Abbreviation VARCHAR2 (30), Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, Mandatory CHAR (1) NOT NULL, DataType_Kind VARCHAR2 (20) NOT NULL, Value_Type VARCHAR2 (10), Computed CHAR (1), Formula VARCHAR2 (4000), ScopeEntity_ID VARCHAR2 (70), ScopeEntity_OVID VARCHAR2 (36), Domain_ID VARCHAR2 (70), Domain_OVID VARCHAR2 (36), Logical_Type_ID VARCHAR2 (70), Logical_Type_OVID VARCHAR2 (36), Distinct_Type_ID VARCHAR2 (70), Distinct_Type_OVID VARCHAR2 (36), Structured_Type_ID VARCHAR2 (70), Structured_Type_OVID VARCHAR2 (36), Collection_Type_ID VARCHAR2 (70), Collection_Type_OVID VARCHAR2 (36), Check_Constraint_Name VARCHAR2 (256), Default_Value VARCHAR2 (512), Use_Domain_Constraint CHAR (1), Domain_Name VARCHAR2 (256), Logical_Type_Name VARCHAR2 (256), Structured_Type_Name VARCHAR2 (256), Distinct_Type_Name VARCHAR2 (256), Collection_Type_Name VARCHAR2 (256), Uses_Default CHAR (1), Engineer CHAR (1) NOT NULL, Table_Name VARCHAR2 (256) NOT NULL, PK_Flag VARCHAR2 (1), FK_Flag VARCHAR2 (1), Native_Type VARCHAR2 (60), Sequence NUMBER NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, T_Size VARCHAR2 (20), T_Precision NUMBER, T_Scale NUMBER, Char_Units CHAR (4), Personally_ID_Information CHAR (1), Sensitive_Information CHAR (1), Sensitive_Type_OVID VARCHAR2 (36), Sensitive_Data_Descr VARCHAR2 (256), Contains_PII VARCHAR2 (3), Mask_Type VARCHAR2 (10), Mask_Tymplate_OVID VARCHAR2 (36), Mask_For_None_Production CHAR (12), ScopeEntity_Name VARCHAR2 (256), Auto_Increment_Column CHAR (1), Identity_Column CHAR (1), Auto_Increment_Generate_Always CHAR (1), Auto_Increment_Start_With NUMBER, Auto_Increment_Increment_By NUMBER, Auto_Increment_Min_Value NUMBER, Auto_Increment_Max_Value NUMBER, Auto_Increment_Cycle CHAR (1), Auto_Increment_Disable_Cache CHAR (1), Auto_Increment_Cache NUMBER, Auto_Increment_Order CHAR (1), Auto_Increment_Sequence_Name VARCHAR2 (256), Auto_Increment_Trigger_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_Column_UI (Label VARCHAR2 (256), Format_Mask VARCHAR2 (50), Form_Display_Width NUMBER (4), Form_Maximum_Width NUMBER (4), Display_As VARCHAR2 (30), Form_Height NUMBER (4), Displayed_On_Forms CHAR (1), Displayed_On_Reports CHAR (1), Read_Only CHAR (1), Help_Text VARCHAR2 (4000), Object_ID VARCHAR2 (70) NOT NULL, Object_OVID VARCHAR2 (36) NOT NULL, Object_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CONSTR_INDEX_COLUMNS (Index_ID VARCHAR2 (70) NOT NULL, Index_OVID VARCHAR2 (36) NOT NULL, Column_ID VARCHAR2 (70) NOT NULL, Column_OVID VARCHAR2 (36) NOT NULL, Table_ID VARCHAR2 (70) NOT NULL, Table_OVID VARCHAR2 (36) NOT NULL, Index_Name VARCHAR2 (256) NOT NULL, Table_Name VARCHAR2 (256) NOT NULL, Column_Name VARCHAR2 (256) NOT NULL, Sequence NUMBER NOT NULL, Sort_Order VARCHAR2 (4), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CONSTR_FK_COLUMNS (Fk_ID VARCHAR2 (70) NOT NULL, Fk_OVID VARCHAR2 (36) NOT NULL, Column_ID VARCHAR2 (70) NOT NULL, Column_OVID VARCHAR2 (36) NOT NULL, Table_ID VARCHAR2 (70) NOT NULL, Table_OVID VARCHAR2 (36) NOT NULL, Index_Name VARCHAR2 (256) NOT NULL, Table_Name VARCHAR2 (256) NOT NULL, Column_Name VARCHAR2 (256) NOT NULL, Sequence NUMBER NOT NULL, Sort_Order VARCHAR2 (4), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CONTACTS (Contact_ID VARCHAR2 (70) NOT NULL, Contact_OVID VARCHAR2 (36) NOT NULL, Contact_Name VARCHAR2 (256) NOT NULL, Business_Info_ID VARCHAR2 (70) NOT NULL, Business_Info_OVID VARCHAR2 (36) NOT NULL, Business_Info_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CONTACT_EMAILS (Contact_ID VARCHAR2 (70) NOT NULL, Contact_OVID VARCHAR2 (36) NOT NULL, Contact_Name VARCHAR2 (256) NOT NULL, Email_ID VARCHAR2 (70) NOT NULL, Email_OVID VARCHAR2 (36) NOT NULL, Email_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CONTACT_LOCATIONS (Contact_ID VARCHAR2 (70) NOT NULL, Contact_OVID VARCHAR2 (36) NOT NULL, Contact_Name VARCHAR2 (256) NOT NULL, Location_ID VARCHAR2 (70) NOT NULL, Location_OVID VARCHAR2 (36) NOT NULL, Location_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CONTACT_RES_LOCATORS (Contact_ID VARCHAR2 (70) NOT NULL, Contact_OVID VARCHAR2 (36) NOT NULL, Contact_Name VARCHAR2 (256) NOT NULL, Resource_Locator_ID VARCHAR2 (70) NOT NULL, Resource_Locator_OVID VARCHAR2 (36) NOT NULL, Resource_Locator_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CONTACT_TELEPHONES (Contact_ID VARCHAR2 (70) NOT NULL, Contact_OVID VARCHAR2 (36) NOT NULL, Contact_Name VARCHAR2 (256) NOT NULL, Telephone_ID VARCHAR2 (70) NOT NULL, Telephone_OVID VARCHAR2 (36) NOT NULL, Telephone_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DATA_FLOW_DIAGRAM_INFOS (Diagram_ID VARCHAR2 (70) NOT NULL, Diagram_OVID VARCHAR2 (36) NOT NULL, Diagram_Name VARCHAR2 (256) NOT NULL, Info_Store_ID VARCHAR2 (70) NOT NULL, Info_Store_OVID VARCHAR2 (36) NOT NULL, Info_Store_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DOCUMENTS (Document_ID VARCHAR2 (70) NOT NULL, Document_OVID VARCHAR2 (36) NOT NULL, Document_Name VARCHAR2 (256) NOT NULL, Business_Info_ID VARCHAR2 (70) NOT NULL, Business_Info_OVID VARCHAR2 (36) NOT NULL, Business_Info_Name VARCHAR2 (256) NOT NULL, Parent_ID VARCHAR2 (70), Parent_OVID VARCHAR2 (36), Parent_Name VARCHAR2 (256), Doc_Reference VARCHAR2 (2000), Doc_Type VARCHAR2 (1000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DOCUMENT_ELEMENTS (Document_ID VARCHAR2 (70) NOT NULL, Document_OVID VARCHAR2 (36) NOT NULL, Document_Name VARCHAR2 (256) NOT NULL, Element_ID VARCHAR2 (70) NOT NULL, Element_OVID VARCHAR2 (36) NOT NULL, Element_Name VARCHAR2 (256) NOT NULL, Element_Type VARCHAR2 (30), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DOMAINS (Domain_ID VARCHAR2 (70) NOT NULL, Domain_Name VARCHAR2 (256) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Synonyms VARCHAR2 (4000), Logical_Type_ID VARCHAR2 (70) NOT NULL, Logical_Type_OVID VARCHAR2 (36) NOT NULL, T_Size NUMBER, T_Precision NUMBER, T_Scale NUMBER, Native_Type VARCHAR2 (60), LT_Name VARCHAR2 (256) NOT NULL, Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Default_Value VARCHAR2 (512), Unit_Of_Measure VARCHAR2 (30), Char_Units CHAR (4), Sensitive_Type_OVID VARCHAR2 (36), Sensitive_Data_Descr VARCHAR2 (256))";
                st.execute(query);
                query = "CREATE TABLE DMRS_DOMAIN_AVT (Domain_ID VARCHAR2 (70) NOT NULL, Domain_OVID VARCHAR2 (36) NOT NULL, Sequence NUMBER NOT NULL, Value VARCHAR2 (512) NOT NULL, Short_Description VARCHAR2 (256), Domain_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DOMAIN_CHECK_CONSTRAINTS (Domain_ID VARCHAR2 (70) NOT NULL, Domain_OVID VARCHAR2 (36) NOT NULL, Sequence NUMBER NOT NULL, Text VARCHAR2 (4000) NOT NULL, Database_Type VARCHAR2 (60) NOT NULL, Domain_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DOMAIN_VALUE_RANGES (Domain_ID VARCHAR2 (70) NOT NULL, Domain_OVID VARCHAR2 (36) NOT NULL, Sequence NUMBER NOT NULL, Begin_Value VARCHAR2 (256) NOT NULL, End_Value VARCHAR2 (256), Short_Description VARCHAR2 (256), Domain_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_Diagram_Elements (Name VARCHAR2 (256) NOT NULL, Long_Name VARCHAR2 (256), Type VARCHAR2 (30) NOT NULL, Geometry_Type VARCHAR2 (10) NOT NULL, Object_ID VARCHAR2 (80) NOT NULL, OVID VARCHAR2 (36) NOT NULL, View_ID VARCHAR2 (70), Source_ID VARCHAR2 (70), Source_OVID VARCHAR2 (36), Source_View_ID VARCHAR2 (70), Target_ID VARCHAR2 (70), Target_OVID VARCHAR2 (36), Target_View_ID VARCHAR2 (70), Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Location_X NUMBER (10,2), Location_Y NUMBER (10,2), Height NUMBER (10,2), Width NUMBER (10,2), BG_Color NUMBER (10), FG_Color NUMBER (10), Use_Default_Color CHAR (1), Formatting VARCHAR2 (4000), Points VARCHAR2 (4000), Diagram_OVID VARCHAR2 (36) NOT NULL, Diagram_ID VARCHAR2 (70) NOT NULL, Diagram_Name VARCHAR2 (256) NOT NULL, Source_Name VARCHAR2 (256), Target_Name VARCHAR2 (256), Model_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_Diagrams (Diagram_Name VARCHAR2 (256) NOT NULL, Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Diagram_Type VARCHAR2 (12) NOT NULL, Is_Display CHAR (1) NOT NULL, Visible CHAR (1) NOT NULL, Master_Diagram_ID VARCHAR2 (70) , Master_Diagram_OVID VARCHAR2 (36) , Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Subview_ID VARCHAR2 (70), Subview_OVID VARCHAR2 (36), Subview_Name VARCHAR2 (256), Display_ID VARCHAR2 (70), Display_OVID VARCHAR2 (36), Display_Name VARCHAR2 (256), Notation VARCHAR2 (30), Show_All_Details CHAR (1), Show_Names_Only CHAR (1), Show_Elements CHAR (1), Show_Datatype CHAR (1), Show_Keys CHAR (1), Autoroute CHAR (1), Box_In_box CHAR (1), Master_Diagram_Name VARCHAR2 (256) , Diagram_SVG CLOB, Diagram_PDF BLOB, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DISTINCT_TYPES (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Distinct_Type_ID VARCHAR2 (70) NOT NULL, Distinct_Type_OVID VARCHAR2 (36) NOT NULL, Distinct_Type_Name VARCHAR2 (256) NOT NULL, Logical_Type_ID VARCHAR2 (70), Logical_Type_OVID VARCHAR2 (36), Logical_Type_Name VARCHAR2 (256), T_Size VARCHAR2 (20), T_Precision NUMBER, T_Scale NUMBER)";
                st.execute(query);
                query = "CREATE TABLE DMRS_EMAILS (Email_ID VARCHAR2 (70) NOT NULL, Email_OVID VARCHAR2 (36) NOT NULL, Email_Name VARCHAR2 (256) NOT NULL, Business_Info_ID VARCHAR2 (70) NOT NULL, Business_Info_OVID VARCHAR2 (36) NOT NULL, Business_Info_Name VARCHAR2 (256) NOT NULL, Email_Address VARCHAR2 (2000), Email_Type VARCHAR2 (1000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_ENTITIES (Entity_Name VARCHAR2 (256) NOT NULL, Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Structured_Type_ID VARCHAR2 (70), Structured_Type_OVID VARCHAR2 (36), Structured_Type_Name VARCHAR2 (256), Number_Data_Elements NUMBER, Classification_Type_ID VARCHAR2 (70), Classification_Type_OVID VARCHAR2 (36), Classification_Type_Name VARCHAR2 (256), Allow_Type_Substitution CHAR (1), Create_Surrogate_Key VARCHAR2 (1), Min_Volume NUMBER , Expected_Volume NUMBER , Max_Volume NUMBER , Growth_Rate_Percents NUMBER, Growth_Rate_Interval VARCHAR2 (5), Normal_Form VARCHAR2 (6), Temporary_Object_Scope VARCHAR2 (30), Adequately_Normalized CHAR (1), Substitution_Parent VARCHAR2 (70), Substitution_Parent_OVID VARCHAR2 (36), Synonyms VARCHAR2 (4000), Synonym_To_Display VARCHAR2 (60), Preferred_Abbreviation VARCHAR2 (256), SuperTypeEntity_ID VARCHAR2 (70), SuperTypeEntity_OVID VARCHAR2 (36), Engineering_Strategy VARCHAR2 (25), Owner VARCHAR2 (50), Entity_Source VARCHAR2 (200), Model_Name VARCHAR2 (256), Substitution_Parent_Name VARCHAR2 (256), SuperTypeEntity_Name VARCHAR2 (256), Subt_Subtree_Generation VARCHAR2 (30), Subt_Apply_To_Model_OVID VARCHAR2 (36), Subt_References VARCHAR2 (30), Subt_Attributes_Inheritance VARCHAR2 (30), Subt_Generate_Discriminator VARCHAR2 (1), Subt_Use_Attribute_ID VARCHAR2 (70), Subt_Discriminator_Column_Name VARCHAR2 (30), Subt_Discriminator_Value VARCHAR2 (50), Subt_Complete_Subtypes VARCHAR2 (1), Design_OVID VARCHAR2 (36) NOT NULL, RemoteDesign_ID VARCHAR2 (256), RemoteModel_ID VARCHAR2 (256), RemoteObject_ID VARCHAR2 (256), RemoteObjectRltvStorageName VARCHAR2 (256), UsedAsRemoteObject CHAR (1))";
                st.execute(query);
                query = "CREATE TABLE DMRS_ENTITYVIEWS (EntityView_Name VARCHAR2 (256) NOT NULL, Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Structured_Type_ID VARCHAR2 (70), Structured_Type_OVID VARCHAR2 (36), Structured_Type_Name VARCHAR2 (256), User_Defined CHAR (1) NOT NULL, View_Type VARCHAR2 (12), Model_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL, RemoteDesign_ID VARCHAR2 (256), RemoteModel_ID VARCHAR2 (256), RemoteObject_ID VARCHAR2 (256), RemoteObjectRltvStorageName VARCHAR2 (256), UsedAsRemoteObject CHAR (1))";
                st.execute(query);
                query = "CREATE TABLE DMRS_EVENTS (Event_ID VARCHAR2 (70) NOT NULL, Event_OVID VARCHAR2 (36) NOT NULL, Event_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Flow_ID VARCHAR2 (70), Flow_OVID VARCHAR2 (36), Flow_Name VARCHAR2 (256), Event_Type VARCHAR2 (30), Times_When_Run VARCHAR2 (100), Day_Of_Week VARCHAR2 (100), Months VARCHAR2 (100), Frequency NUMBER (10), Time_Frequency NUMBER (10), Minute NUMBER (2), Hour NUMBER (2), Day_Of_Month NUMBER (2), Quarter NUMBER (1), Year NUMBER (4), On_Day CHAR (1), At_Time CHAR (1), Fiscal CHAR (1), Text VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_EXTERNAL_AGENTS (External_Agent_ID VARCHAR2 (70) NOT NULL, External_Agent_OVID VARCHAR2 (36) NOT NULL, External_Agent_Name VARCHAR2 (256) NOT NULL, Diagram_ID VARCHAR2 (70) NOT NULL, Diagram_OVID VARCHAR2 (36) NOT NULL, Diagram_Name VARCHAR2 (256) NOT NULL, External_Agent_Type VARCHAR2 (30), File_Location VARCHAR2 (256), File_Source VARCHAR2 (256), File_Name VARCHAR2 (256), File_Type VARCHAR2 (30), File_Owner VARCHAR2 (256), Data_Capture_Type VARCHAR2 (30), Field_Separator CHAR (1), Text_Delimiter CHAR (1), Skip_Records NUMBER (10), Self_Describing CHAR (1), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_EXT_AGENT_FLOWS (External_Agent_ID VARCHAR2 (70) NOT NULL, External_Agent_OVID VARCHAR2 (36) NOT NULL, External_Agent_Name VARCHAR2 (256) NOT NULL, Flow_ID VARCHAR2 (70) NOT NULL, Flow_OVID VARCHAR2 (36) NOT NULL, Flow_Name VARCHAR2 (256) NOT NULL, Incoming_Outgoing_Flag CHAR (1), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_EXT_AGENT_EXT_DATAS (External_Agent_ID VARCHAR2 (70) NOT NULL, External_Agent_OVID VARCHAR2 (36) NOT NULL, External_Agent_Name VARCHAR2 (256) NOT NULL, External_Data_ID VARCHAR2 (70) NOT NULL, External_Data_OVID VARCHAR2 (36) NOT NULL, External_Data_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_EXTERNAL_DATAS (External_Data_ID VARCHAR2 (70) NOT NULL, External_Data_OVID VARCHAR2 (36) NOT NULL, External_Data_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Logical_Type_ID VARCHAR2 (70), Logical_Type_OVID VARCHAR2 (36), Logical_Type_Name VARCHAR2 (256), Record_Structure_Type_ID VARCHAR2 (70), Record_Structure_Type_OVID VARCHAR2 (36), Record_Structure_Type_Name VARCHAR2 (256), Starting_Pos NUMBER (10), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_FLOW_INFO_STRUCTURES (Flow_ID VARCHAR2 (70) NOT NULL, Flow_OVID VARCHAR2 (36) NOT NULL, Flow_Name VARCHAR2 (256) NOT NULL, Info_Structure_ID VARCHAR2 (70) NOT NULL, Info_Structure_OVID VARCHAR2 (36) NOT NULL, Info_Structure_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_FLOWS (Flow_ID VARCHAR2 (70) NOT NULL, Flow_OVID VARCHAR2 (36) NOT NULL, Flow_Name VARCHAR2 (256) NOT NULL, Diagram_ID VARCHAR2 (70) NOT NULL, Diagram_OVID VARCHAR2 (36) NOT NULL, Diagram_Name VARCHAR2 (256) NOT NULL, Event_ID VARCHAR2 (70), Event_OVID VARCHAR2 (36), Event_Name VARCHAR2 (256), Source_ID VARCHAR2 (70), Source_OVID VARCHAR2 (36), Source_Name VARCHAR2 (256), Destination_ID VARCHAR2 (70), Destination_OVID VARCHAR2 (36), Destination_Name VARCHAR2 (256), Parent_ID VARCHAR2 (70), Parent_OVID VARCHAR2 (36), Parent_Name VARCHAR2 (256), Source_Type VARCHAR2 (30), Destination_Type VARCHAR2 (30), System_Objective VARCHAR2 (4000), Logging CHAR (1), Op_Create CHAR (1), Op_Read CHAR (1), Op_Update CHAR (1), Op_Delete CHAR (1), CRUD_Code VARCHAR2 (4), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_FOREIGNKEYS (FK_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Child_Table_Name VARCHAR2 (256) NOT NULL, Referred_Table_Name VARCHAR2 (256) NOT NULL, Engineer CHAR (1), Delete_Rule VARCHAR2 (10), Child_Table_ID VARCHAR2 (70) NOT NULL, Child_Table_OVID VARCHAR2 (36), Referred_Table_ID VARCHAR2 (70) NOT NULL, Referred_Table_OVID VARCHAR2 (36), Referred_Key_ID VARCHAR2 (70) NOT NULL, Referred_Key_OVID VARCHAR2 (36), Number_Of_Columns NUMBER NOT NULL, Mandatory CHAR (1), Transferable CHAR (1), In_Arc CHAR (1), Arc_ID VARCHAR2 (70), Model_Name VARCHAR2 (256), Referred_Key_Name VARCHAR2 (256), Discriminator_Column_OVID VARCHAR2 (36), Discriminator_Value VARCHAR2 (50), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_INDEXES (Index_Name VARCHAR2 (256) NOT NULL, Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, State VARCHAR2 (20) NOT NULL, Functional CHAR (1), Expression VARCHAR2 (4000), Engineer CHAR (1) NOT NULL, Table_Name VARCHAR2 (256) NOT NULL, Spatial_Index CHAR (1), Spatial_Layer_Type VARCHAR2 (15), Geodetic_Index CHAR (1), Number_Of_Dimensions NUMBER DEFAULT 2, Schema_OVID VARCHAR2 (36), Schema_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_INFO_STORES (Info_Store_ID VARCHAR2 (70) NOT NULL, Info_Store_OVID VARCHAR2 (36) NOT NULL, Info_Store_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Info_Store_Type VARCHAR2 (30), Object_Type VARCHAR2 (30), Implementation_Name VARCHAR2 (256), Location VARCHAR2 (256), Source VARCHAR2 (256), File_Name VARCHAR2 (256), File_Type VARCHAR2 (30), Owner VARCHAR2 (256), Rdbms_Site VARCHAR2 (256), Scope VARCHAR2 (30), Transfer_Type VARCHAR2 (30), Field_Separator VARCHAR2 (4), Text_Delimiter VARCHAR2 (4), Skip_Records NUMBER (10), Self_Describing CHAR (1), System_Objective VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_INFO_STRUCTURES (Info_Structure_ID VARCHAR2 (70) NOT NULL, Info_Structure_OVID VARCHAR2 (36) NOT NULL, Info_Structure_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Growth_Rate_Unit VARCHAR2 (30), Growth_Rate_Percent NUMBER (10), Volume NUMBER (10), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_INFO_STRUCT_ATTRS (Info_Structure_ID VARCHAR2 (70) NOT NULL, Info_Structure_OVID VARCHAR2 (36) NOT NULL, Info_Structure_Name VARCHAR2 (256) NOT NULL, Attribute_ID VARCHAR2 (70) NOT NULL, Attribute_OVID VARCHAR2 (36) NOT NULL, Attribute_Name VARCHAR2 (256) NOT NULL, Entity_ID VARCHAR2 (70) NOT NULL, Entity_OVID VARCHAR2 (36) NOT NULL, Entity_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_KEYS (Key_Name VARCHAR2 (256) NOT NULL, Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, State VARCHAR2 (20) NOT NULL, Synonyms VARCHAR2 (4000), Entity_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_KEY_ATTRIBUTES (Key_ID VARCHAR2 (70) NOT NULL, Key_OVID VARCHAR2 (36) NOT NULL, Attribute_ID VARCHAR2 (70) NOT NULL, Attribute_OVID VARCHAR2 (36) NOT NULL, Entity_ID VARCHAR2 (70) NOT NULL, Entity_OVID VARCHAR2 (36) NOT NULL, Key_Name VARCHAR2 (256) NOT NULL, Entity_Name VARCHAR2 (256) NOT NULL, Attribute_Name VARCHAR2 (256) NOT NULL, Sequence NUMBER, Relationship_ID VARCHAR2 (100), Relationship_OVID VARCHAR2 (36), Relationship_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_KEY_Elements (Key_ID VARCHAR2 (80) NOT NULL, Key_OVID VARCHAR2 (36) NOT NULL, Type CHAR (1), Element_ID VARCHAR2 (80) NOT NULL, Element_OVID VARCHAR2 (36) NOT NULL, Element_Name VARCHAR2 (256) NOT NULL, Sequence NUMBER, Source_Label VARCHAR2 (100), Target_Label VARCHAR2 (100), Entity_ID VARCHAR2 (70) NOT NULL, Key_Name VARCHAR2 (256) NOT NULL, Entity_OVID VARCHAR2 (36) NOT NULL, Entity_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_LOCATIONS (Location_ID VARCHAR2 (70) NOT NULL, Location_OVID VARCHAR2 (36) NOT NULL, Location_Name VARCHAR2 (256) NOT NULL, Business_Info_ID VARCHAR2 (70) NOT NULL, Business_Info_OVID VARCHAR2 (36) NOT NULL, Business_Info_Name VARCHAR2 (256) NOT NULL, Loc_Address VARCHAR2 (1000), Loc_City VARCHAR2 (1000), Loc_Post_Code VARCHAR2 (1000), Loc_Area VARCHAR2 (1000), Loc_Country VARCHAR2 (1000), Loc_Type VARCHAR2 (1000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_LOGICAL_TO_NATIVE (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Logical_Type_ID VARCHAR2 (70) NOT NULL, Logical_Type_OVID VARCHAR2 (36) NOT NULL, LT_Name VARCHAR2 (256) NOT NULL, Native_Type VARCHAR2 (60), RDBMS_Type VARCHAR2 (60) NOT NULL, RDBMS_Version VARCHAR2 (60) NOT NULL, Has_Size VARCHAR2 (1), Has_Precision VARCHAR2 (1), Has_Scale VARCHAR2 (1))";
                st.execute(query);
                query = "CREATE TABLE DMRS_LOGICAL_TYPES (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Logical_Type_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, LT_Name VARCHAR2 (256) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_MAPPINGS (Logical_Model_ID VARCHAR2 (70) NOT NULL, Logical_Model_OVID VARCHAR2 (36) NOT NULL, Logical_Model_Name VARCHAR2 (256) NOT NULL, Logical_Object_ID VARCHAR2 (80) NOT NULL, Logical_Object_OVID VARCHAR2 (36) NOT NULL, Logical_Object_Name VARCHAR2 (256) NOT NULL, Logical_Object_Type VARCHAR2 (30), Relational_Model_ID VARCHAR2 (70) NOT NULL, Relational_Model_OVID VARCHAR2 (36) NOT NULL, Relational_Model_Name VARCHAR2 (256) NOT NULL, Relational_Object_ID VARCHAR2 (70) NOT NULL, Relational_Object_OVID VARCHAR2 (36) NOT NULL, Relational_Object_Name VARCHAR2 (256) NOT NULL, Relational_Object_Type VARCHAR2 (30), Entity_ID VARCHAR2 (70), Entity_OVID VARCHAR2 (36), Entity_Name VARCHAR2 (256), Table_ID VARCHAR2 (70), Table_OVID VARCHAR2 (36), Table_Name VARCHAR2 (256), Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_MAPPING_TARGETS (Object_ID VARCHAR2 (70) NOT NULL, Object_OVID VARCHAR2 (36) NOT NULL, Object_Name VARCHAR2 (256) NOT NULL, Target_ID VARCHAR2 (70) NOT NULL, Target_OVID VARCHAR2 (36) NOT NULL, Target_Name VARCHAR2 (256) NOT NULL, Object_Type VARCHAR2 (30), Target_Type VARCHAR2 (30), Transformation_Type VARCHAR2 (30), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_MAPPING_TARGET_SOURCES (Object_ID VARCHAR2 (70) NOT NULL, Object_OVID VARCHAR2 (36) NOT NULL, Object_Name VARCHAR2 (256) NOT NULL, Target_ID VARCHAR2 (70) NOT NULL, Target_OVID VARCHAR2 (36) NOT NULL, Target_Name VARCHAR2 (256) NOT NULL, Source_ID VARCHAR2 (70) NOT NULL, Source_OVID VARCHAR2 (36) NOT NULL, Source_Name VARCHAR2 (256) NOT NULL, Object_Type VARCHAR2 (30), Target_Type VARCHAR2 (30), Source_Type VARCHAR2 (30), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_NATIVE_TO_LOGICAL (RDBMS_Type VARCHAR2 (60) NOT NULL, RDBMS_Version VARCHAR2 (60) NOT NULL, Native_Type VARCHAR2 (60), LT_Name VARCHAR2 (256) NOT NULL, Logical_Type_ID VARCHAR2 (70) NOT NULL, Logical_Type_OVID VARCHAR2 (36) NOT NULL, Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_Notes (Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Object_Name VARCHAR2 (256), Model_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_PK_OID_COLUMNS (Column_ID VARCHAR2 (70) NOT NULL, Column_OVID VARCHAR2 (36) NOT NULL, Table_ID VARCHAR2 (70) NOT NULL, Table_OVID VARCHAR2 (36) NOT NULL, Table_Name VARCHAR2 (256) NOT NULL, Column_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_PROCESS_ATTRIBUTES (Process_ID VARCHAR2 (70) NOT NULL, Process_OVID VARCHAR2 (36) NOT NULL, Entity_ID VARCHAR2 (70) NOT NULL, Entity_OVID VARCHAR2 (36) NOT NULL, Flow_ID VARCHAR2 (70) NOT NULL, Flow_OVID VARCHAR2 (36) NOT NULL, DFD_ID VARCHAR2 (70) NOT NULL, DFD_OVID VARCHAR2 (36) NOT NULL, Process_Name VARCHAR2 (256) NOT NULL, Entity_Name VARCHAR2 (256) NOT NULL, Flow_Name VARCHAR2 (256) NOT NULL, DFD_Name VARCHAR2 (256) NOT NULL, OP_Read CHAR (1), OP_Create CHAR (1), OP_Update CHAR (1), OP_Delete CHAR (1), CRUD_Code VARCHAR2 (4), Flow_Direction VARCHAR2 (3) NOT NULL, Attribute_ID VARCHAR2 (70) NOT NULL, Attribute_OVID VARCHAR2 (36) NOT NULL, Attribute_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_PROCESS_ENTITIES (Process_ID VARCHAR2 (70) NOT NULL, Process_OVID VARCHAR2 (36) NOT NULL, Entity_ID VARCHAR2 (70) NOT NULL, Entity_OVID VARCHAR2 (36) NOT NULL, Flow_ID VARCHAR2 (70) NOT NULL, Flow_OVID VARCHAR2 (36) NOT NULL, DFD_ID VARCHAR2 (70) NOT NULL, DFD_OVID VARCHAR2 (36) NOT NULL, Process_Name VARCHAR2 (256) NOT NULL, Entity_Name VARCHAR2 (256) NOT NULL, Flow_Name VARCHAR2 (256) NOT NULL, DFD_Name VARCHAR2 (256) NOT NULL, OP_Read CHAR (1), OP_Create CHAR (1), OP_Update CHAR (1), OP_Delete CHAR (1), CRUD_Code VARCHAR2 (4), Flow_Direction VARCHAR2 (3) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_PROCESSES (Process_ID VARCHAR2 (70) NOT NULL, Process_OVID VARCHAR2 (36) NOT NULL, Process_Name VARCHAR2 (256) NOT NULL, Diagram_ID VARCHAR2 (70) NOT NULL, Diagram_OVID VARCHAR2 (36) NOT NULL, Diagram_Name VARCHAR2 (256) NOT NULL, Transformation_Task_ID VARCHAR2 (70), Transformation_Task_OVID VARCHAR2 (36), Transformation_Task_Name VARCHAR2 (256), Parent_Process_ID VARCHAR2 (70), Parent_Process_OVID VARCHAR2 (36), Parent_Process_Name VARCHAR2 (256), Process_Number VARCHAR2 (30), Process_Type VARCHAR2 (30), Process_Mode VARCHAR2 (30), Priority VARCHAR2 (30), Frequency_Times NUMBER (10), Frequency_Time_Unit VARCHAR2 (30), Peak_Periods_String VARCHAR2 (30), Parameters_Wrappers_String VARCHAR2 (4000), Interactive_Max_Response_Time NUMBER (10), Interactive_Response_Time_Unit VARCHAR2 (30), Batch_Min_Transactions NUMBER (10), Batch_Time_Unit VARCHAR2 (30), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_RDBMS_SITES (Site_Name VARCHAR2 (256) NOT NULL, Site_ID VARCHAR2 (70), Site_OVID VARCHAR2 (36), RDBMS_Type NUMBER NOT NULL, Design_OVID VARCHAR2 (36))";
                st.execute(query);
                query = "CREATE TABLE DMRS_RECORD_STRUCTURES (Record_Structure_ID VARCHAR2 (70) NOT NULL, Record_Structure_OVID VARCHAR2 (36) NOT NULL, Record_Structure_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_RECORD_STRUCT_EXT_DATAS (Record_Structure_ID VARCHAR2 (70) NOT NULL, Record_Structure_OVID VARCHAR2 (36) NOT NULL, Record_Structure_Name VARCHAR2 (256) NOT NULL, External_Data_ID VARCHAR2 (70) NOT NULL, External_Data_OVID VARCHAR2 (36) NOT NULL, External_Data_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_RELATIONSHIPS (Relationship_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (80) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Object_ID VARCHAR2 (80) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Source_Entity_Name VARCHAR2 (256) NOT NULL, Target_Entity_Name VARCHAR2 (256) NOT NULL, Source_Label VARCHAR2 (100), Target_Label VARCHAR2 (100), SourceTo_Target_Cardinality VARCHAR2 (3) NOT NULL, TargetTo_Source_Cardinality VARCHAR2 (3) NOT NULL, Source_Optional CHAR (1) NOT NULL, Target_Optional CHAR (1) NOT NULL, Dominant_Role VARCHAR2 (256) NOT NULL, Identifying CHAR (1) NOT NULL, Source_ID VARCHAR2 (70) NOT NULL, Source_OVID VARCHAR2 (36) NOT NULL, Target_ID VARCHAR2 (70) NOT NULL, Target_OVID VARCHAR2 (36) NOT NULL, Number_Of_Attributes NUMBER NOT NULL, Transferable CHAR (1), In_Arc CHAR (1), Arc_ID VARCHAR2 (70), Model_Name VARCHAR2 (256), Source_Name VARCHAR2 (256), Target_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_RESOURCE_LOCATORS (Resource_Locator_ID VARCHAR2 (70) NOT NULL, Resource_Locator_OVID VARCHAR2 (36) NOT NULL, Resource_Locator_Name VARCHAR2 (256) NOT NULL, Business_Info_ID VARCHAR2 (70) NOT NULL, Business_Info_OVID VARCHAR2 (36) NOT NULL, Business_Info_Name VARCHAR2 (256) NOT NULL, Url VARCHAR2 (2000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_RESPONSIBLE_PARTIES (Responsible_Party_ID VARCHAR2 (70) NOT NULL, Responsible_Party_OVID VARCHAR2 (36) NOT NULL, Responsible_Party_Name VARCHAR2 (256) NOT NULL, Business_Info_ID VARCHAR2 (70) NOT NULL, Business_Info_OVID VARCHAR2 (36) NOT NULL, Business_Info_Name VARCHAR2 (256) NOT NULL, Parent_ID VARCHAR2 (70), Parent_OVID VARCHAR2 (36), Parent_Name VARCHAR2 (256), Responsibility VARCHAR2 (2000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_RES_PARTY_CONTACTS (Responsible_Party_ID VARCHAR2 (70) NOT NULL, Responsible_Party_OVID VARCHAR2 (36) NOT NULL, Responsible_Party_Name VARCHAR2 (256) NOT NULL, Contact_ID VARCHAR2 (70) NOT NULL, Contact_OVID VARCHAR2 (36) NOT NULL, Contact_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_RES_PARTY_ELEMENTS (Responsible_Party_ID VARCHAR2 (70) NOT NULL, Responsible_Party_OVID VARCHAR2 (36) NOT NULL, Responsible_Party_Name VARCHAR2 (256) NOT NULL, Element_ID VARCHAR2 (70) NOT NULL, Element_OVID VARCHAR2 (36) NOT NULL, Element_Name VARCHAR2 (256) NOT NULL, Element_Type VARCHAR2 (30), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_ROLES (Role_ID VARCHAR2 (70) NOT NULL, Role_OVID VARCHAR2 (36) NOT NULL, Role_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_ROLE_PROCESSES (Role_ID VARCHAR2 (70) NOT NULL, Role_OVID VARCHAR2 (36) NOT NULL, Role_Name VARCHAR2 (256) NOT NULL, Process_ID VARCHAR2 (70) NOT NULL, Process_OVID VARCHAR2 (36) NOT NULL, Process_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_SOURCE_INFO (Source_Info_OVID VARCHAR2 (36) NOT NULL, Source_Info_Type CHAR (1) NOT NULL, DDL_File_Name VARCHAR2 (256), DDL_Path_Name VARCHAR2 (2000), DDL_DB_Type VARCHAR2 (30), DataDict_Connection_Name VARCHAR2 (256), DataDict_Connection_Url VARCHAR2 (2000), DataDict_DB_Type VARCHAR2 (30), Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_SPATIAL_COLUMN_DEFINITION (Table_ID VARCHAR2 (70) NOT NULL, Table_OVID VARCHAR2 (36) NOT NULL, Definition_ID VARCHAR2 (70) NOT NULL, Definition_OVID VARCHAR2 (36) NOT NULL, Definition_Name VARCHAR2 (256) NOT NULL, Table_Name VARCHAR2 (256) NOT NULL, Column_ID VARCHAR2 (70), Column_OVID VARCHAR2 (36), Column_Name VARCHAR2 (256), Use_Function CHAR (1) NOT NULL, Function_Expression VARCHAR2 (4000), Coordinate_System_ID VARCHAR2 (70), Has_Spatial_Index CHAR (1) NOT NULL, Spatial_Index_ID VARCHAR2 (70), Spatial_Index_OVID VARCHAR2 (36), Spatial_Index_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_SPATIAL_DIMENSIONS (Definition_ID VARCHAR2 (70) NOT NULL, Definition_OVID VARCHAR2 (36) NOT NULL, Definition_Name VARCHAR2 (256) NOT NULL, Dimension_Name VARCHAR2 (256) NOT NULL, Low_Boundary NUMBER NOT NULL, Upper_Boundary NUMBER NOT NULL, Tolerance NUMBER, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_STRUCTURED_TYPES (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Structured_Type_ID VARCHAR2 (70) NOT NULL, Structured_Type_OVID VARCHAR2 (36) NOT NULL, Structured_Type_Name VARCHAR2 (256) NOT NULL, Super_Type_ID VARCHAR2 (70), Super_Type_OVID VARCHAR2 (36), Super_Type_Name VARCHAR2 (256), Predefined CHAR (1), ST_Final CHAR (1), ST_Instantiable CHAR (1))";
                st.execute(query);
                query = "CREATE TABLE DMRS_STRUCT_TYPE_ATTRS (Attribute_ID VARCHAR2 (70) NOT NULL, Attribute_OVID VARCHAR2 (36) NOT NULL, Attribute_Name VARCHAR2 (256) NOT NULL, Structured_Type_ID VARCHAR2 (70) NOT NULL, Structured_Type_OVID VARCHAR2 (36) NOT NULL, Structured_Type_Name VARCHAR2 (256) NOT NULL, Mandatory CHAR (1) NOT NULL, Reference CHAR (1) NOT NULL, T_Size VARCHAR2 (20), T_Precision NUMBER, T_Scale NUMBER, Type_ID VARCHAR2 (70), Type_OVID VARCHAR2 (36), Type_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL,DataType_Kind VARCHAR2 (20), Domain_Name VARCHAR2 (256),Char_Units CHAR (4))";
                st.execute(query);
                query = "CREATE TABLE DMRS_STRUCT_TYPE_METHODS ( Method_ID VARCHAR2 (70) NOT NULL, Method_OVID VARCHAR2 (36) NOT NULL, Method_Name VARCHAR2 (256) NOT NULL, Structured_Type_ID VARCHAR2 (70) NOT NULL, Structured_Type_OVID VARCHAR2 (36) NOT NULL, Structured_Type_Name VARCHAR2 (256) NOT NULL, Constructor CHAR (1), Overridden_Method_ID VARCHAR2 (70), Overridden_Method_OVID VARCHAR2 (36), Overridden_Method_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL,Overriding CHAR (1))";
                st.execute(query);
                query = "CREATE TABLE DMRS_STRUCT_TYPE_METHOD_PARS ( Parameter_ID VARCHAR2 (70) NOT NULL, Parameter_OVID VARCHAR2 (36) NOT NULL, Parameter_Name VARCHAR2 (256) NOT NULL, Method_ID VARCHAR2 (70) NOT NULL, Method_OVID VARCHAR2 (36) NOT NULL, Method_Name VARCHAR2 (256) NOT NULL, Return_Value CHAR (1) NOT NULL, Reference CHAR (1) NOT NULL, Seq NUMBER, T_Size VARCHAR2 (20), T_Precision NUMBER, T_Scale NUMBER, Type_ID VARCHAR2 (70), Type_OVID VARCHAR2 (36), Type_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL )";
                st.execute(query);
                query = "CREATE TABLE DMRS_TABLES (Table_Name VARCHAR2 (256) NOT NULL, Abbreviation VARCHAR2 (30), Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Structured_Type_ID VARCHAR2 (70), Structured_Type_OVID VARCHAR2 (36), Structured_Type_Name VARCHAR2 (256), Number_Data_Elements NUMBER, Classification_Type_ID VARCHAR2 (70), Classification_Type_OVID VARCHAR2 (36), Classification_Type_Name VARCHAR2 (256), Allow_Type_Substitution CHAR (1), Engineer_As_Relationship VARCHAR2 (1), Allow_Col_Reorder VARCHAR2 (1), Min_Volume NUMBER , Expected_Volume NUMBER , Max_Volume NUMBER , Growth_Rate_Percents NUMBER, Growth_Rate_Interval VARCHAR2 (5), Normal_Form VARCHAR2 (6), Temporary_Object_Scope VARCHAR2 (30), Adequately_Normalized CHAR (1), Substitution_Parent VARCHAR2 (70), Substitution_Parent_OVID VARCHAR2 (36), Engineer CHAR (1), Spatial_Table CHAR (1), OID_is_PK CHAR (1), OID_is_User_Defined CHAR (1), Include_Scripts_Into_DDL CHAR (1), Model_Name VARCHAR2 (256), Substitution_Parent_Name VARCHAR2 (256), Schema_OVID VARCHAR2 (36), Schema_Name VARCHAR2 (256), Source_Info_OVID VARCHAR2 (36), Source_DataDict_Schema_Name VARCHAR2 (256), Source_DataDict_Object_Name VARCHAR2 (256), Redaction_Policy_Name VARCHAR2 (50), Redaction_Policy_Enabled VARCHAR2 (1), Redaction_Policy_Expression VARCHAR2 (50), Design_OVID VARCHAR2 (36) NOT NULL, RemoteDesign_ID VARCHAR2 (256), RemoteModel_ID VARCHAR2 (256), RemoteObject_ID VARCHAR2 (256), RemoteObjectRltvStorageName VARCHAR2 (256), UsedAsRemoteObject CHAR (1))";
                st.execute(query);
                query = "CREATE TABLE DMRS_TABLEVIEWS (TableView_Name VARCHAR2 (256) NOT NULL, Object_ID VARCHAR2 (70) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Import_ID VARCHAR2 (70), Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Structured_Type_ID VARCHAR2 (70), Structured_Type_OVID VARCHAR2 (36), Structured_Type_Name VARCHAR2 (256), Where_Clause VARCHAR2 (4000), Having_Clause VARCHAR2 (4000), User_Defined CHAR (1) NOT NULL, Engineer CHAR (1), Allow_Type_Substitution CHAR (1), OID_Columns VARCHAR2 (256), Model_Name VARCHAR2 (256), Schema_OVID VARCHAR2 (36), Schema_Name VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL, RemoteDesign_ID VARCHAR2 (256), RemoteModel_ID VARCHAR2 (256), RemoteObject_ID VARCHAR2 (256), RemoteObjectRltvStorageName VARCHAR2 (256), UsedAsRemoteObject CHAR (1))";
                st.execute(query);
                query = "CREATE TABLE DMRS_TABLE_CONSTRAINTS (Table_ID VARCHAR2 (70) NOT NULL, Table_OVID VARCHAR2 (36) NOT NULL, Sequence NUMBER NOT NULL, Constraint_ID VARCHAR2 (70) NOT NULL, Constraint_OVID VARCHAR2 (36) NOT NULL, Constraint_Name VARCHAR2 (256) NOT NULL, Text VARCHAR2 (4000) NOT NULL, Table_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_COLUMN_GROUPS (Table_ID VARCHAR2 (70) NOT NULL, Table_OVID VARCHAR2 (36) NOT NULL, Sequence NUMBER NOT NULL, ColumnGroup_ID VARCHAR2 (70) NOT NULL, ColumnGroup_OVID VARCHAR2 (36) NOT NULL, ColumnGroup_Name VARCHAR2 (256) NOT NULL, Columns VARCHAR2 (4000), Notes VARCHAR2 (4000), Table_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CUBES (Cube_ID VARCHAR2 (70) NOT NULL, Cube_Name VARCHAR2 (256) NOT NULL, Cube_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Part_Dimension_ID VARCHAR2 (70), Part_Dimension_Name VARCHAR2 (256), Part_Dimension_OVID VARCHAR2 (36), Part_Hierarchy_ID VARCHAR2 (70), Part_Hierarchy_Name VARCHAR2 (256), Part_Hierarchy_OVID VARCHAR2 (36), Part_Level_ID VARCHAR2 (70), Part_Level_Name VARCHAR2 (256), Part_Level_OVID VARCHAR2 (36), Full_Cube_Slice_ID VARCHAR2 (70), Full_Cube_Slice_Name VARCHAR2 (256), Full_Cube_Slice_OVID VARCHAR2 (36), Oracle_Long_Name VARCHAR2 (2000), Oracle_Plural_Name VARCHAR2 (2000), Oracle_Short_Name VARCHAR2 (2000), Is_Compressed_Composites CHAR (1), Is_Global_Composites CHAR (1), Is_Partitioned CHAR (1), Is_Virtual CHAR (1), Part_Description VARCHAR2 (4000), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_CUBE_DIMENSIONS (Cube_ID VARCHAR2 (70) NOT NULL, Cube_Name VARCHAR2 (256) NOT NULL, Cube_OVID VARCHAR2 (36) NOT NULL, Dimension_ID VARCHAR2 (70) NOT NULL, Dimension_Name VARCHAR2 (256) NOT NULL, Dimension_OVID VARCHAR2 (36) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DIMENSIONS (Dimension_ID VARCHAR2 (70) NOT NULL, Dimension_Name VARCHAR2 (256) NOT NULL, Dimension_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Base_Entity_ID VARCHAR2 (70), Base_Entity_Name VARCHAR2 (256), Base_Entity_OVID VARCHAR2 (36), Base_Level_ID VARCHAR2 (70), Base_Level_Name VARCHAR2 (256), Base_Level_OVID VARCHAR2 (36), Oracle_Long_Name VARCHAR2 (2000), Oracle_Plural_Name VARCHAR2 (2000), Oracle_Short_Name VARCHAR2 (2000), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DIMENSION_CALC_ATTRS (Dimension_ID VARCHAR2 (70) NOT NULL, Dimension_Name VARCHAR2 (256) NOT NULL, Dimension_OVID VARCHAR2 (36) NOT NULL, Calc_Attribute_ID VARCHAR2 (70) NOT NULL, Calc_Attribute_Name VARCHAR2 (256) NOT NULL, Calc_Attribute_OVID VARCHAR2 (36) NOT NULL, Calculated_Expr VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DIMENSION_LEVELS (Dimension_ID VARCHAR2 (70) NOT NULL, Dimension_Name VARCHAR2 (256) NOT NULL, Dimension_OVID VARCHAR2 (36) NOT NULL, Level_ID VARCHAR2 (70) NOT NULL, Level_Name VARCHAR2 (256) NOT NULL, Level_OVID VARCHAR2 (36) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_FACT_ENTITIES (Cube_ID VARCHAR2 (70) NOT NULL, Cube_Name VARCHAR2 (256) NOT NULL, Cube_OVID VARCHAR2 (36) NOT NULL, Entity_ID VARCHAR2 (70) NOT NULL, Entity_Name VARCHAR2 (256) NOT NULL, Entity_OVID VARCHAR2 (36) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_FACT_ENTITIES_JOINS (Join_ID VARCHAR2 (70) NOT NULL, Join_Name VARCHAR2 (256) NOT NULL, Join_OVID VARCHAR2 (36) NOT NULL, Cube_ID VARCHAR2 (70) NOT NULL, Cube_Name VARCHAR2 (256) NOT NULL, Cube_OVID VARCHAR2 (36) NOT NULL, Left_Entity_ID VARCHAR2 (70), Left_Entity_Name VARCHAR2 (256), Left_Entity_OVID VARCHAR2 (36), Right_Entity_ID VARCHAR2 (70), Right_Entity_Name VARCHAR2 (256), Right_Entity_OVID VARCHAR2 (36), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_HIERARCHIES (Hierarchy_ID VARCHAR2 (70) NOT NULL, Hierarchy_Name VARCHAR2 (256) NOT NULL, Hierarchy_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Dimension_ID VARCHAR2 (70), Dimension_Name VARCHAR2 (256), Dimension_OVID VARCHAR2 (36), Oracle_Long_Name VARCHAR2 (2000), Oracle_Plural_Name VARCHAR2 (2000), Oracle_Short_Name VARCHAR2 (2000), Is_Default_Hierarchy CHAR (1), Is_Ragged_Hierarchy CHAR (1), Is_Value_Based_Hierarchy CHAR (1), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_HIERARCHY_LEVELS (Hierarchy_ID VARCHAR2 (70) NOT NULL, Hierarchy_Name VARCHAR2 (256) NOT NULL, Hierarchy_OVID VARCHAR2 (36) NOT NULL, Level_ID VARCHAR2 (70) NOT NULL, Level_Name VARCHAR2 (256) NOT NULL, Level_OVID VARCHAR2 (36) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_HIERARCHY_ROLLUP_LINKS (Hierarchy_ID VARCHAR2 (70) NOT NULL, Hierarchy_Name VARCHAR2 (256) NOT NULL, Hierarchy_OVID VARCHAR2 (36) NOT NULL, Rollup_Link_ID VARCHAR2 (70) NOT NULL, Rollup_Link_Name VARCHAR2 (256) NOT NULL, Rollup_Link_OVID VARCHAR2 (36) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_LEVELS (Level_ID VARCHAR2 (70) NOT NULL, Level_Name VARCHAR2 (256) NOT NULL, Level_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Entity_ID VARCHAR2 (70), Entity_Name VARCHAR2 (256), Entity_OVID VARCHAR2 (36), Name_Column_ID VARCHAR2 (70), Name_Column_Name VARCHAR2 (256), Name_Column_OVID VARCHAR2 (36), Value_Column_ID VARCHAR2 (70), Value_Column_Name VARCHAR2 (256), Value_Column_OVID VARCHAR2 (36), Oracle_Long_Name VARCHAR2 (2000), Oracle_Plural_Name VARCHAR2 (2000), Oracle_Short_Name VARCHAR2 (2000), Root_Identification VARCHAR2 (30), Identification_Value VARCHAR2 (2000), Selection_Criteria VARCHAR2 (4000), Selection_Criteria_Description VARCHAR2 (4000), Is_Value_Based_Hierarchy CHAR (1), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_LEVEL_ATTRS (Level_ID VARCHAR2 (70) NOT NULL, Level_Name VARCHAR2 (256) NOT NULL, Level_OVID VARCHAR2 (36) NOT NULL, Attribute_ID VARCHAR2 (70) NULL, Attribute_Name VARCHAR2 (256) NULL, Attribute_OVID VARCHAR2 (36) NULL, Is_Default_Attr CHAR (1), Is_Level_Key_Attr CHAR (1), Is_Parent_Key_Attr CHAR (1), Is_Descriptive_Key_Attr CHAR (1), Is_Calculated_Attr CHAR (1), Descriptive_Name VARCHAR2 (256), Descriptive_Is_Indexed CHAR (1), Descriptive_Slow_Changing VARCHAR2 (30), Calculated_Expr VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_MEASURES (Measure_ID VARCHAR2 (70) NOT NULL, Measure_Name VARCHAR2 (256) NOT NULL, Measure_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Cube_ID VARCHAR2 (70), Cube_Name VARCHAR2 (256), Cube_OVID VARCHAR2 (36), Fact_Object_ID VARCHAR2 (70), Fact_Object_Name VARCHAR2 (256), Fact_Object_OVID VARCHAR2 (36), Oracle_Long_Name VARCHAR2 (2000), Oracle_Plural_Name VARCHAR2 (2000), Oracle_Short_Name VARCHAR2 (2000), Fact_Object_Type VARCHAR2 (30), Additivity_Type VARCHAR2 (30), Is_Fact_Dimension CHAR (1), Is_Formula CHAR (1), Is_Custom_Formula CHAR (1), Formula VARCHAR2 (4000), Where_Clause VARCHAR2 (4000), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_MEASURE_AGGR_FUNCS (Measure_ID VARCHAR2 (70) NOT NULL, Measure_Name VARCHAR2 (256) NOT NULL, Measure_OVID VARCHAR2 (36) NOT NULL, Aggregate_Function_ID VARCHAR2 (70) NOT NULL, Aggregate_Function_Name VARCHAR2 (256) NOT NULL, Aggregate_Function_OVID VARCHAR2 (36) NOT NULL, Measure_Alias VARCHAR2 (256), Is_Default CHAR (1), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_AGGR_FUNC_DIMENSIONS (Aggregate_Function_ID VARCHAR2 (70) NOT NULL, Aggregate_Function_Name VARCHAR2 (256) NOT NULL, Aggregate_Function_OVID VARCHAR2 (36) NOT NULL, Dimension_ID VARCHAR2 (70) NOT NULL, Dimension_Name VARCHAR2 (256) NOT NULL, Dimension_OVID VARCHAR2 (36) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_AGGR_FUNC_LEVELS (Aggregate_Function_ID VARCHAR2 (70) NOT NULL, Aggregate_Function_Name VARCHAR2 (256) NOT NULL, Aggregate_Function_OVID VARCHAR2 (36) NOT NULL, Level_ID VARCHAR2 (70) NOT NULL, Level_Name VARCHAR2 (256) NOT NULL, Level_OVID VARCHAR2 (36) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_MEASURE_FOLDERS (Measure_Folder_ID VARCHAR2 (70) NOT NULL, Measure_Folder_Name VARCHAR2 (256) NOT NULL, Measure_Folder_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Parent_Folder_ID VARCHAR2 (70), Parent_Folder_Name VARCHAR2 (256), Parent_Folder_OVID VARCHAR2 (36), Oracle_Long_Name VARCHAR2 (2000), Oracle_Plural_Name VARCHAR2 (2000), Oracle_Short_Name VARCHAR2 (2000), Is_Leaf CHAR (1), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_MEASURE_FOLDER_MEASURES (Measure_Folder_ID VARCHAR2 (70) NOT NULL, Measure_Folder_Name VARCHAR2 (256) NOT NULL, Measure_Folder_OVID VARCHAR2 (36) NOT NULL, Measure_ID VARCHAR2 (70) NOT NULL, Measure_Name VARCHAR2 (256) NOT NULL, Measure_OVID VARCHAR2 (36) NOT NULL, Parent_Object_ID VARCHAR2 (70), Parent_Object_Name VARCHAR2 (256), Parent_Object_OVID VARCHAR2 (36), Parent_Object_Type VARCHAR2 (30), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_RAGGED_HIER_LINKS (Ragged_Hier_Link_ID VARCHAR2 (70) NOT NULL, Ragged_Hier_Link_Name VARCHAR2 (256) NOT NULL, Ragged_Hier_Link_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Parent_Level_ID VARCHAR2 (70), Parent_Level_Name VARCHAR2 (256), Parent_Level_OVID VARCHAR2 (36), Child_Level_ID VARCHAR2 (70), Child_Level_Name VARCHAR2 (256), Child_Level_OVID VARCHAR2 (36), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_RAGGED_HIER_LINK_ATTRS (Ragged_Hier_Link_ID VARCHAR2 (70) NOT NULL, Ragged_Hier_Link_Name VARCHAR2 (256) NOT NULL, Ragged_Hier_Link_OVID VARCHAR2 (36) NOT NULL, Attribute_ID VARCHAR2 (70) NOT NULL, Attribute_Name VARCHAR2 (256) NOT NULL, Attribute_OVID VARCHAR2 (36) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_ROLLUP_LINKS (Rollup_Link_ID VARCHAR2 (70) NOT NULL, Rollup_Link_Name VARCHAR2 (256) NOT NULL, Rollup_Link_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Parent_Object_ID VARCHAR2 (70), Parent_Object_Name VARCHAR2 (256), Parent_Object_OVID VARCHAR2 (36), Child_Object_ID VARCHAR2 (70), Child_Object_Name VARCHAR2 (256), Child_Object_OVID VARCHAR2 (36), Fact_Entity_ID VARCHAR2 (70), Fact_Entity_Name VARCHAR2 (256), Fact_Entity_OVID VARCHAR2 (36), Parent_Object_Type VARCHAR2 (30), Child_Object_Type VARCHAR2 (30), Oracle_Long_Name VARCHAR2 (2000), Oracle_Plural_Name VARCHAR2 (2000), Oracle_Short_Name VARCHAR2 (2000), Default_Aggr_Operator VARCHAR2 (256), Is_Role_Playing CHAR (1), Is_Sparse_Dimension CHAR (1), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_ROLLUP_LINK_ATTRS (Rollup_Link_ID VARCHAR2 (70) NOT NULL, Rollup_Link_Name VARCHAR2 (256) NOT NULL, Rollup_Link_OVID VARCHAR2 (36) NOT NULL, Attribute_ID VARCHAR2 (70) NOT NULL, Attribute_Name VARCHAR2 (256) NOT NULL, Attribute_OVID VARCHAR2 (36) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_SLICES (Slice_ID VARCHAR2 (70) NOT NULL, Slice_Name VARCHAR2 (256) NOT NULL, Slice_OVID VARCHAR2 (36) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Cube_ID VARCHAR2 (70), Cube_Name VARCHAR2 (256), Cube_OVID VARCHAR2 (36), Entity_ID VARCHAR2 (70), Entity_Name VARCHAR2 (256), Entity_OVID VARCHAR2 (36), Oracle_Long_Name VARCHAR2 (2000), Oracle_Plural_Name VARCHAR2 (2000), Oracle_Short_Name VARCHAR2 (2000), Is_Fully_Realized CHAR (1), Is_Read_Only CHAR (1), Description VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_SLICE_DIM_HIER_LEVEL (Slice_ID VARCHAR2 (70) NOT NULL, Slice_Name VARCHAR2 (256) NOT NULL, Slice_OVID VARCHAR2 (36) NOT NULL, Dimension_ID VARCHAR2 (70), Dimension_Name VARCHAR2 (256), Dimension_OVID VARCHAR2 (36), Hierarchy_ID VARCHAR2 (70), Hierarchy_Name VARCHAR2 (256), Hierarchy_OVID VARCHAR2 (36), Level_ID VARCHAR2 (70), Level_Name VARCHAR2 (256), Level_OVID VARCHAR2 (36), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_SLICE_MEASURES (Slice_ID VARCHAR2 (70) NOT NULL, Slice_Name VARCHAR2 (256) NOT NULL, Slice_OVID VARCHAR2 (36) NOT NULL, Measure_ID VARCHAR2 (70) NOT NULL, Measure_Name VARCHAR2 (256) NOT NULL, Measure_OVID VARCHAR2 (36) NOT NULL, Aggregate_Function_ID VARCHAR2 (70) NOT NULL, Aggregate_Function_Name VARCHAR2 (256) NOT NULL, Aggregate_Function_OVID VARCHAR2 (36) NOT NULL, Measure_Alias VARCHAR2 (256), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TABLE_INCLUDE_SCRIPTS (Table_ID VARCHAR2 (70) NOT NULL, Table_OVID VARCHAR2 (36) NOT NULL, Table_Name VARCHAR2 (256), Type VARCHAR2 (15), Sequence NUMBER NOT NULL, Text VARCHAR2 (4000) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TASK_PARAMS (Task_Params_ID VARCHAR2 (70) NOT NULL, Task_Params_OVID VARCHAR2 (36) NOT NULL, Task_Params_Name VARCHAR2 (256) NOT NULL, Transformation_Task_ID VARCHAR2 (70) NOT NULL, Transformation_Task_OVID VARCHAR2 (36) NOT NULL, Transformation_Task_Name VARCHAR2 (256) NOT NULL, Task_Params_Type VARCHAR2 (30), Multiplicity VARCHAR2 (30), System_Objective VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TASK_PARAMS_ITEMS (Task_Params_Item_ID VARCHAR2 (70) NOT NULL, Task_Params_Item_OVID VARCHAR2 (36) NOT NULL, Task_Params_Item_Name VARCHAR2 (256) NOT NULL, Task_Params_ID VARCHAR2 (70) NOT NULL, Task_Params_OVID VARCHAR2 (36) NOT NULL, Task_Params_Name VARCHAR2 (256) NOT NULL, Logical_Type_ID VARCHAR2 (70), Logical_Type_OVID VARCHAR2 (36), Logical_Type_Name VARCHAR2 (256), Task_Params_Item_Type VARCHAR2 (30), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TELEPHONES (Telephone_ID VARCHAR2 (70) NOT NULL, Telephone_OVID VARCHAR2 (36) NOT NULL, Telephone_Name VARCHAR2 (256) NOT NULL, Business_Info_ID VARCHAR2 (70) NOT NULL, Business_Info_OVID VARCHAR2 (36) NOT NULL, Business_Info_Name VARCHAR2 (256) NOT NULL, Phone_Number VARCHAR2 (1000), Phone_Type VARCHAR2 (1000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TRANSFORMATION_PACKAGES (Transformation_Package_ID VARCHAR2 (70) NOT NULL, Transformation_Package_OVID VARCHAR2 (36) NOT NULL, Transformation_Package_Name VARCHAR2 (256) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, System_Objective VARCHAR2 (4000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TRANSFORMATION_TASKS (Transformation_Task_ID VARCHAR2 (70) NOT NULL, Transformation_Task_OVID VARCHAR2 (36) NOT NULL, Transformation_Task_Name VARCHAR2 (256) NOT NULL, Transformation_Package_ID VARCHAR2 (70) NOT NULL, Transformation_Package_OVID VARCHAR2 (36) NOT NULL, Transformation_Package_Name VARCHAR2 (256) NOT NULL, Process_ID VARCHAR2 (70), Process_OVID VARCHAR2 (36), Process_Name VARCHAR2 (256), Top_Level CHAR (1), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TRANSFORMATION_TASK_INFOS (Transformation_Task_ID VARCHAR2 (70) NOT NULL, Transformation_Task_OVID VARCHAR2 (36) NOT NULL, Transformation_Task_Name VARCHAR2 (256) NOT NULL, Info_Store_ID VARCHAR2 (70) NOT NULL, Info_Store_OVID VARCHAR2 (36) NOT NULL, Info_Store_Name VARCHAR2 (256) NOT NULL, Source_Target_Flag CHAR (1), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TRANSFORMATION_FLOWS (Transformation_Flow_ID VARCHAR2 (70) NOT NULL, Transformation_Flow_OVID VARCHAR2 (36) NOT NULL, Transformation_Flow_Name VARCHAR2 (256) NOT NULL, Transformation_Task_ID VARCHAR2 (70) NOT NULL, Transformation_Task_OVID VARCHAR2 (36) NOT NULL, Transformation_Task_Name VARCHAR2 (256) NOT NULL, Source_ID VARCHAR2 (70), Source_OVID VARCHAR2 (36), Source_Name VARCHAR2 (256), Destination_ID VARCHAR2 (70), Destination_OVID VARCHAR2 (36), Destination_Name VARCHAR2 (256), Source_Type VARCHAR2 (30), Destination_Type VARCHAR2 (30), System_Objective VARCHAR2 (4000), Logging CHAR (1), Op_Create CHAR (1), Op_Read CHAR (1), Op_Update CHAR (1), Op_Delete CHAR (1), CRUD_Code VARCHAR2 (4), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TRANSFORMATIONS (Transformation_ID VARCHAR2 (70) NOT NULL, Transformation_OVID VARCHAR2 (36) NOT NULL, Transformation_Name VARCHAR2 (256) NOT NULL, Transformation_Task_ID VARCHAR2 (70) NOT NULL, Transformation_Task_OVID VARCHAR2 (36) NOT NULL, Transformation_Task_Name VARCHAR2 (256) NOT NULL, Filter_Condition VARCHAR2 (4000), Join_Condition VARCHAR2 (4000), Primary CHAR (1), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_VALUE_RANGES (DataElement_ID VARCHAR2 (70) NOT NULL, DataElement_OVID VARCHAR2 (36) NOT NULL, Type VARCHAR2 (10), Sequence NUMBER NOT NULL, Begin_Value VARCHAR2 (256) NOT NULL, End_Value VARCHAR2 (256), Short_Description VARCHAR2 (256), Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, Container_Name VARCHAR2 (256) NOT NULL, DataElement_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_VIEW_COLUMNS (View_OVID VARCHAR2 (36) NOT NULL, View_ID VARCHAR2 (70) NOT NULL, View_Name VARCHAR2 (256) NOT NULL, Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, Container_Name VARCHAR2 (256) NOT NULL, Container_Alias VARCHAR2 (256), Is_Expression CHAR (1), Column_ID VARCHAR2 (70) NOT NULL, Column_OVID VARCHAR2 (36) NOT NULL, Column_Name VARCHAR2 (256) NOT NULL, Column_Alias VARCHAR2 (256), Native_Type VARCHAR2 (60), Type CHAR (1), Expression VARCHAR2 (2000), Sequence NUMBER (3) NOT NULL, Personally_ID_Information CHAR (1), Sensitive_Information CHAR (1), Mask_For_None_Production CHAR (12), Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_VIEW_CONTAINERS (View_OVID VARCHAR2 (36) NOT NULL, View_ID VARCHAR2 (70) NOT NULL, View_Name VARCHAR2 (256) NOT NULL, Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, Container_Name VARCHAR2 (256) NOT NULL, Type CHAR (1) NOT NULL, Alias VARCHAR2 (256), Sequence NUMBER (3) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_VIEW_ORDER_GROUPBY (View_OVID VARCHAR2 (36) NOT NULL, View_ID VARCHAR2 (70) NOT NULL, View_Name VARCHAR2 (256) NOT NULL, Container_ID VARCHAR2 (70) NOT NULL, Container_OVID VARCHAR2 (36) NOT NULL, Container_Name VARCHAR2 (256) NOT NULL, Container_Alias VARCHAR2 (256), Is_Expression CHAR (1), Usage CHAR (1), Sequence NUMBER (3) NOT NULL, Column_ID VARCHAR2 (70), Column_OVID VARCHAR2 (36), Column_Name VARCHAR2 (256), Column_Alias VARCHAR2 (256), Sort_Order VARCHAR2 (4), Expression VARCHAR2 (2000), Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_Large_Text (Object_ID VARCHAR2 (80) NOT NULL, OVID VARCHAR2 (36) NOT NULL, Object_Name VARCHAR2 (256), Type VARCHAR2 (30), Text NCLOB NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_Model_Naming_Options (Object_type VARCHAR2 (30) NOT NULL, Max_Name_Length NUMBER (4) NOT NULL, Character_Case VARCHAR2 (10) NOT NULL, Valid_Characters VARCHAR2 (512) NOT NULL, Model_ID VARCHAR2 (70) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Model_Type VARCHAR2 (30) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_MEASUREMENTS (Design_ID VARCHAR2 (70) NOT NULL, Design_OVID VARCHAR2 (36) NOT NULL, Design_Name VARCHAR2 (256) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Model_Name VARCHAR2 (256) NOT NULL, Measurement_ID VARCHAR2 (70) NOT NULL, Measurement_OVID VARCHAR2 (36) NOT NULL, Measurement_Name VARCHAR2 (256) NOT NULL, Measurement_Value VARCHAR2 (50), Measurement_Unit VARCHAR2 (36), Measurement_Type VARCHAR2 (36), Measurement_CR_Date VARCHAR2 (30), Measurement_EF_Date VARCHAR2 (30),Object_Name VARCHAR2 (256), Object_Type VARCHAR2 (256),Object_Model  VARCHAR2 (256))";
                st.execute(query);
                query = "CREATE TABLE DMRS_SCHEMA_OBJECT (Design_OVID VARCHAR2 (36) NOT NULL, Model_OVID VARCHAR2 (36) NOT NULL, Object_ID VARCHAR2 (70) NOT NULL, Schema_OVID VARCHAR2 (36) NOT NULL, Schema_Name VARCHAR2 (256) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_DYNAMIC_PROPERTIES (Design_OVID VARCHAR2 (36), Object_OVID VARCHAR2 (36) NOT NULL, Object_ID VARCHAR2 (70) NOT NULL, Object_Name VARCHAR2 (100) NOT NULL, Object_Type VARCHAR2 (100) NOT NULL, Name VARCHAR2 (256), Value VARCHAR2 (4000))";
                st.execute(query);
                query = "CREATE TABLE DMRS_TABLE_ARCS (Object_OVID VARCHAR2 (36) NOT NULL,Object_ID VARCHAR2 (70) NOT NULL,Arc_Name VARCHAR2 (256) NOT NULL,Table_OVID VARCHAR2 (36) NOT NULL,Table_ID VARCHAR2 (70) NOT NULL,Mandatory CHAR (1) NOT NULL,Discriminator_Column_ID VARCHAR2 (70),Model_Name VARCHAR2 (256),Model_OVID VARCHAR2 (36) NOT NULL,Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_ENTITY_ARCS (Object_OVID VARCHAR2 (36) NOT NULL,Object_ID VARCHAR2 (70) NOT NULL,Arc_Name VARCHAR2 (256) NOT NULL,Entity_ID VARCHAR2 (70) NOT NULL,Model_Name VARCHAR2 (256),Model_OVID VARCHAR2 (36) NOT NULL,Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_SENSITIVE_TYPES (Object_OVID VARCHAR2 (36) NOT NULL,Object_ID VARCHAR2 (70) NOT NULL,Sensitive_Type_Name VARCHAR2 (256) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TSDP_POLICIES (Object_OVID VARCHAR2 (36) NOT NULL,Object_ID VARCHAR2 (70) NOT NULL,TSDP_Policy_Name VARCHAR2 (256) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_TSDP_SUB_POLICIES (Object_OVID VARCHAR2 (36) NOT NULL,Object_ID VARCHAR2 (70) NOT NULL,Container_ID VARCHAR2 (70) NOT NULL,Container_OVID VARCHAR2 (36) NOT NULL,Container_Name VARCHAR2 (50) NOT NULL,TSDP_SubPolicy_Name VARCHAR2 (256) NOT NULL,Expression VARCHAR2 (256),Mask_Type VARCHAR2 (10),Mask_Template VARCHAR2 (50),Datatype VARCHAR2 (50),Length VARCHAR2 (10),Parent_Schema VARCHAR2 (50),Parent_Table VARCHAR2 (50))";
                st.execute(query);
                query = "CREATE TABLE DMRS_MASK_TEMPLATES (Object_OVID VARCHAR2 (36) NOT NULL,Object_ID VARCHAR2 (70) NOT NULL,Mask_Template_Name VARCHAR2 (50) NOT NULL,Function_Type VARCHAR2 (10) NOT NULL,Data_Type VARCHAR2 (10) NOT NULL,Input_Format VARCHAR2 (50),Output_Format VARCHAR2 (50),Mask_Char VARCHAR2 (50),Mask_From NUMBER,Mask_To NUMBER,Pattern VARCHAR2 (50),Replace_String VARCHAR2 (50),Position NUMBER,Occurrence NUMBER,Match_Parameter VARCHAR2 (50),Month VARCHAR2 (10),Day VARCHAR2 (10),Year VARCHAR2 (10),Hour VARCHAR2 (10),Minute VARCHAR2 (10),Second VARCHAR2 (10),Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_EXISTENCE_DEP (Object_OVID VARCHAR2 (36) NOT NULL,Dependency_Name VARCHAR2 (256) NOT NULL,Table_OVID VARCHAR2 (36) NOT NULL,Generation_Level VARCHAR2 (20) NOT NULL,Discriminator_Column_OVID VARCHAR2 (36),Discriminator_Column_Name VARCHAR2 (256),Model_Name VARCHAR2 (256),Model_OVID VARCHAR2 (36) NOT NULL,Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_EXISTENCE_DEP_COLUMNS (Dependency_OVID VARCHAR2 (36) NOT NULL,Discriminator_Value VARCHAR2 (50),Table_Name VARCHAR2 (256) NOT NULL,Table_OVID VARCHAR2 (36) NOT NULL,Column_Name VARCHAR2 (256) NOT NULL,Column_OVID VARCHAR2 (36) NOT NULL,Depend_As_Mandatory VARCHAR2 (1),Depend VARCHAR2 (1),Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_FK_CD_CONSTRAINTS (Fk_OVID VARCHAR2 (36) NOT NULL,Constraint_OVID VARCHAR2 (36) NOT NULL,Constraint_Name VARCHAR2 (256) NOT NULL,Model_OVID VARCHAR2 (36) NOT NULL,Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE TABLE DMRS_FK_CD_CONSTRAINTS_COLS (Constraint_OVID VARCHAR2 (36) NOT NULL,Column_OVID VARCHAR2 (36) NOT NULL,Depend_As_Mandatory VARCHAR2 (1),Depend VARCHAR2 (1),Model_OVID VARCHAR2 (36) NOT NULL,Design_OVID VARCHAR2 (36) NOT NULL)";
                st.execute(query);
                query = "CREATE VIEW DMRV_DESIGNS (Design_ID, Design_OVID, Design_Name, Date_Published, Published_By, Persistence_Version, Version_Comments) AS select  Design_ID, Design_OVID, Design_Name, Date_Published, Published_By, Persistence_Version, Version_Comments from DMRS_DESIGNS";
                st.execute(query);
                query = "CREATE VIEW DMRV_MODELS (Design_ID, Design_OVID, Design_Name, Model_ID, Model_OVID, Model_Name, Model_Type, RDBMS_Type) AS select  Design_ID, Design_OVID, Design_Name, Model_ID, Model_OVID, Model_Name, Model_Type, RDBMS_Type from DMRS_MODELS";
                st.execute(query);
                query = "CREATE VIEW DMRV_MODEL_SUBVIEWS (Subview_ID, Subview_OVID, Subview_Name, Model_ID, Model_OVID, Model_Name, Design_OVID) AS select  Subview_ID, Subview_OVID, Subview_Name, Model_ID, Model_OVID, Model_Name, Design_OVID from DMRS_MODEL_SUBVIEWS";
                st.execute(query);
                query = "CREATE VIEW DMRV_MODEL_DISPLAYS (Display_ID, Display_OVID, Display_Name, Model_ID, Model_OVID, Model_Name, Design_OVID) AS select  Display_ID, Display_OVID, Display_Name, Model_ID, Model_OVID, Model_Name, Design_OVID from DMRS_MODEL_DISPLAYS";
                st.execute(query);
                query = "CREATE VIEW DMRV_ATTRIBUTES (Attribute_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, Mandatory, DataType_Kind, Value_Type, Formula, ScopeEntity_ID, ScopeEntity_OVID, Domain_ID, Domain_OVID, Logical_Type_ID, Logical_Type_OVID, Distinct_Type_ID, Distinct_Type_OVID, Structured_Type_ID, Structured_Type_OVID, Collection_Type_ID, Collection_Type_OVID, Check_Constraint_Name, Default_Value, Use_Domain_Constraint, Domain_Name, Logical_Type_Name, Structured_Type_Name, Distinct_Type_Name, Collection_Type_Name, Synonyms, Preferred_Abbreviation, Relationship_ID, Relationship_OVID, Entity_Name, PK_Flag, FK_Flag, Relationship_Name, Sequence, T_Size, T_Precision, Char_Units, Native_Type, T_Scale, Data_Source, ScopeEntity_Name, Design_OVID) AS select  Attribute_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, Mandatory, DataType_Kind, Value_Type, Formula, ScopeEntity_ID, ScopeEntity_OVID, Domain_ID, Domain_OVID, Logical_Type_ID, Logical_Type_OVID, Distinct_Type_ID, Distinct_Type_OVID, Structured_Type_ID, Structured_Type_OVID, Collection_Type_ID, Collection_Type_OVID, Check_Constraint_Name, Default_Value, Use_Domain_Constraint, Domain_Name, Logical_Type_Name, Structured_Type_Name, Distinct_Type_Name, Collection_Type_Name, Synonyms, Preferred_Abbreviation, Relationship_ID, Relationship_OVID, Entity_Name, PK_Flag, FK_Flag, Relationship_Name, Sequence, T_Size, T_Precision, Char_Units, Native_Type, T_Scale, Data_Source, ScopeEntity_Name, Design_OVID from DMRS_ATTRIBUTES";
                st.execute(query);
                query = "CREATE VIEW DMRV_AVT (DataElement_ID, DataElement_OVID, Type, Sequence, Value, Short_Description, Container_ID, Container_OVID, Container_Name, DataElement_Name, Design_OVID) AS select  DataElement_ID, DataElement_OVID, Type, Sequence, Value, Short_Description, Container_ID, Container_OVID, Container_Name, DataElement_Name, Design_OVID from DMRS_AVT";
                st.execute(query);
                query = "CREATE VIEW DMRV_BUSINESS_INFO (Design_ID, Design_OVID, Design_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name) AS select  Design_ID, Design_OVID, Design_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name from DMRS_BUSINESS_INFO";
                st.execute(query);
                query = "CREATE VIEW DMRV_CHANGE_REQUESTS (Design_ID, Design_OVID, Design_Name, Change_Request_ID, Change_Request_OVID, Change_Request_Name, Request_Status, Request_Date_String, Completion_Date_String, Is_Completed, Reason) AS select  Design_ID, Design_OVID, Design_Name, Change_Request_ID, Change_Request_OVID, Change_Request_Name, Request_Status, Request_Date_String, Completion_Date_String, Is_Completed, Reason from DMRS_CHANGE_REQUESTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CHANGE_REQUEST_ELEMENTS (Change_Request_ID, Change_Request_OVID, Change_Request_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID) AS select  Change_Request_ID, Change_Request_OVID, Change_Request_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID from DMRS_CHANGE_REQUEST_ELEMENTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CHECK_CONSTRAINTS (DataElement_ID, DataElement_OVID, Type, Sequence, Constraint_Name, Text, Database_Type, Container_ID, Container_OVID, Container_Name, DataElement_Name, Design_OVID) AS select  DataElement_ID, DataElement_OVID, Type, Sequence, Constraint_Name, Text, Database_Type, Container_ID, Container_OVID, Container_Name, DataElement_Name, Design_OVID from DMRS_CHECK_CONSTRAINTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CLASSIFICATION_TYPES (Type_ID, Type_OVID, Type_Name, Design_ID, Design_OVID, Design_Name) AS select  Type_ID, Type_OVID, Type_Name, Design_ID, Design_OVID, Design_Name from DMRS_CLASSIFICATION_TYPES";
                st.execute(query);
                query = "CREATE VIEW DMRV_COLLECTION_TYPES (Design_ID, Design_OVID, Design_Name, Collection_Type_ID, Collection_Type_OVID, Collection_Type_Name, C_Type, DataType_ID, DataType_OVID, DataType_Name, DT_Type, DT_Ref, Max_Element, Predefined) AS select  Design_ID, Design_OVID, Design_Name, Collection_Type_ID, Collection_Type_OVID, Collection_Type_Name, C_Type, DataType_ID, DataType_OVID, DataType_Name, DT_Type, DT_Ref, Max_Element, Predefined from DMRS_COLLECTION_TYPES";
                st.execute(query);
                query = "CREATE VIEW DMRV_COLUMNS (Column_Name, Abbreviation, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, Mandatory, DataType_Kind, Value_Type, Computed, Formula, ScopeEntity_ID, ScopeEntity_OVID, Domain_ID, Domain_OVID, Logical_Type_ID, Logical_Type_OVID, Distinct_Type_ID, Distinct_Type_OVID, Structured_Type_ID, Structured_Type_OVID, Collection_Type_ID, Collection_Type_OVID, Check_Constraint_Name, Default_Value, Use_Domain_Constraint, Domain_Name, Logical_Type_Name, Structured_Type_Name, Distinct_Type_Name, Collection_Type_Name, Uses_Default, Engineer, Table_Name, PK_Flag, FK_Flag, Native_Type, Sequence, Model_ID, Model_OVID, Model_Name, T_Size, T_Precision, T_Scale, Char_Units, Personally_ID_Information, Sensitive_Information, Mask_For_None_Production, ScopeEntity_Name, Auto_Increment_Column, Identity_Column, Auto_Increment_Generate_Always, Auto_Increment_Start_With, Auto_Increment_Increment_By, Auto_Increment_Min_Value, Auto_Increment_Max_Value, Auto_Increment_Cycle, Auto_Increment_Disable_Cache, Auto_Increment_Cache, Auto_Increment_Order, Auto_Increment_Sequence_Name, Auto_Increment_Trigger_Name, Design_OVID) AS select  Column_Name, Abbreviation, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, Mandatory, DataType_Kind, Value_Type, Computed, Formula, ScopeEntity_ID, ScopeEntity_OVID, Domain_ID, Domain_OVID, Logical_Type_ID, Logical_Type_OVID, Distinct_Type_ID, Distinct_Type_OVID, Structured_Type_ID, Structured_Type_OVID, Collection_Type_ID, Collection_Type_OVID, Check_Constraint_Name, Default_Value, Use_Domain_Constraint, Domain_Name, Logical_Type_Name, Structured_Type_Name, Distinct_Type_Name, Collection_Type_Name, Uses_Default, Engineer, Table_Name, PK_Flag, FK_Flag, Native_Type, Sequence, Model_ID, Model_OVID, Model_Name, T_Size, T_Precision, T_Scale, Char_Units, Personally_ID_Information, Sensitive_Information, Mask_For_None_Production, ScopeEntity_Name, Auto_Increment_Column, Identity_Column, Auto_Increment_Generate_Always, Auto_Increment_Start_With, Auto_Increment_Increment_By, Auto_Increment_Min_Value, Auto_Increment_Max_Value, Auto_Increment_Cycle, Auto_Increment_Disable_Cache, Auto_Increment_Cache, Auto_Increment_Order, Auto_Increment_Sequence_Name, Auto_Increment_Trigger_Name, Design_OVID from DMRS_COLUMNS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CONSTR_INDEX_COLUMNS (Index_ID, Index_OVID, Column_ID, Column_OVID, Table_ID, Table_OVID, Index_Name, Table_Name, Column_Name, Sequence, Sort_Order, Design_OVID) AS select  Index_ID, Index_OVID, Column_ID, Column_OVID, Table_ID, Table_OVID, Index_Name, Table_Name, Column_Name, Sequence, Sort_Order, Design_OVID from DMRS_CONSTR_INDEX_COLUMNS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CONSTR_FK_COLUMNS (Fk_ID, Fk_OVID, Column_ID, Column_OVID, Table_ID, Table_OVID, Index_Name, Table_Name, Column_Name, Sequence, Sort_Order, Design_OVID) AS select  Fk_ID, Fk_OVID, Column_ID, Column_OVID, Table_ID, Table_OVID, Index_Name, Table_Name, Column_Name, Sequence, Sort_Order, Design_OVID from DMRS_CONSTR_FK_COLUMNS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CONTACTS (Contact_ID, Contact_OVID, Contact_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Design_OVID) AS select  Contact_ID, Contact_OVID, Contact_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Design_OVID from DMRS_CONTACTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CONTACT_EMAILS (Contact_ID, Contact_OVID, Contact_Name, Email_ID, Email_OVID, Email_Name, Design_OVID) AS select  Contact_ID, Contact_OVID, Contact_Name, Email_ID, Email_OVID, Email_Name, Design_OVID from DMRS_CONTACT_EMAILS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CONTACT_LOCATIONS (Contact_ID, Contact_OVID, Contact_Name, Location_ID, Location_OVID, Location_Name, Design_OVID) AS select  Contact_ID, Contact_OVID, Contact_Name, Location_ID, Location_OVID, Location_Name, Design_OVID from DMRS_CONTACT_LOCATIONS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CONTACT_RES_LOCATORS (Contact_ID, Contact_OVID, Contact_Name, Resource_Locator_ID, Resource_Locator_OVID, Resource_Locator_Name, Design_OVID) AS select  Contact_ID, Contact_OVID, Contact_Name, Resource_Locator_ID, Resource_Locator_OVID, Resource_Locator_Name, Design_OVID from DMRS_CONTACT_RES_LOCATORS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CONTACT_TELEPHONES (Contact_ID, Contact_OVID, Contact_Name, Telephone_ID, Telephone_OVID, Telephone_Name, Design_OVID) AS select  Contact_ID, Contact_OVID, Contact_Name, Telephone_ID, Telephone_OVID, Telephone_Name, Design_OVID from DMRS_CONTACT_TELEPHONES";
                st.execute(query);
                query = "CREATE VIEW DMRV_COLUMN_UI (Label, Format_Mask, Form_Display_Width, Form_Maximum_Width, Display_As, Form_Height, Displayed_On_Forms, Displayed_On_Reports, Read_Only, Help_Text, Object_ID, Object_OVID, Object_Name, Design_OVID) AS select  Label, Format_Mask, Form_Display_Width, Form_Maximum_Width, Display_As, Form_Height, Displayed_On_Forms, Displayed_On_Reports, Read_Only, Help_Text, Object_ID, Object_OVID, Object_Name, Design_OVID from DMRS_COLUMN_UI";
                st.execute(query);
                query = "CREATE VIEW DMRV_DATA_FLOW_DIAGRAM_INFOS (Diagram_ID, Diagram_OVID, Diagram_Name, Info_Store_ID, Info_Store_OVID, Info_Store_Name, Design_OVID) AS select  Diagram_ID, Diagram_OVID, Diagram_Name, Info_Store_ID, Info_Store_OVID, Info_Store_Name, Design_OVID from DMRS_DATA_FLOW_DIAGRAM_INFOS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DOCUMENTS (Document_ID, Document_OVID, Document_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Parent_ID, Parent_OVID, Parent_Name, Doc_Reference, Doc_Type, Design_OVID) AS select  Document_ID, Document_OVID, Document_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Parent_ID, Parent_OVID, Parent_Name, Doc_Reference, Doc_Type, Design_OVID from DMRS_DOCUMENTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DOCUMENT_ELEMENTS (Document_ID, Document_OVID, Document_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID) AS select  Document_ID, Document_OVID, Document_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID from DMRS_DOCUMENT_ELEMENTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DOMAINS (Domain_ID, Domain_Name, OVID, Synonyms, Logical_Type_ID, Logical_Type_OVID, T_Size, T_Precision, T_Scale, Native_Type, LT_Name, Design_ID, Design_OVID, Design_Name, Default_Value, Unit_Of_Measure, Char_Units) AS select  Domain_ID, Domain_Name, OVID, Synonyms, Logical_Type_ID, Logical_Type_OVID, T_Size, T_Precision, T_Scale, Native_Type, LT_Name, Design_ID, Design_OVID, Design_Name, Default_Value, Unit_Of_Measure, Char_Units from DMRS_DOMAINS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DOMAIN_AVT (Domain_ID, Domain_OVID, Sequence, Value, Short_Description, Domain_Name, Design_OVID) AS select  Domain_ID, Domain_OVID, Sequence, Value, Short_Description, Domain_Name, Design_OVID from DMRS_DOMAIN_AVT";
                st.execute(query);
                query = "CREATE VIEW DMRV_DOMAIN_CHECK_CONSTRAINTS (Domain_ID, Domain_OVID, Sequence, Text, Database_Type, Domain_Name, Design_OVID) AS select  Domain_ID, Domain_OVID, Sequence, Text, Database_Type, Domain_Name, Design_OVID from DMRS_DOMAIN_CHECK_CONSTRAINTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DOMAIN_VALUE_RANGES (Domain_ID, Domain_OVID, Sequence, Begin_Value, End_Value, Short_Description, Domain_Name, Design_OVID) AS select  Domain_ID, Domain_OVID, Sequence, Begin_Value, End_Value, Short_Description, Domain_Name, Design_OVID from DMRS_DOMAIN_VALUE_RANGES";
                st.execute(query);
                query = "CREATE VIEW DMRV_DIAGRAM_ELEMENTS (Name, Type, Geometry_Type, Object_ID, OVID, View_ID, Source_ID, Source_OVID, Source_View_ID, Target_ID, Target_OVID, Target_View_ID, Model_ID, Model_OVID, Location_X, Height, Width, BG_Color, FG_Color, Use_Default_Color, Formatting, Points, Diagram_OVID, Diagram_ID, Diagram_Name, Source_Name, Target_Name, Model_Name, Design_OVID) AS select  Name, Type, Geometry_Type, Object_ID, OVID, View_ID, Source_ID, Source_OVID, Source_View_ID, Target_ID, Target_OVID, Target_View_ID, Model_ID, Model_OVID, Location_X, Height, Width, BG_Color, FG_Color, Use_Default_Color, Formatting, Points, Diagram_OVID, Diagram_ID, Diagram_Name, Source_Name, Target_Name, Model_Name, Design_OVID from DMRS_DIAGRAM_ELEMENTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DIAGRAMS (Diagram_Name, Object_ID, OVID, Diagram_Type, Is_Display, Visible, Master_Diagram_ID, Master_Diagram_OVID, Model_ID, Model_OVID, Model_Name, Subview_ID, Subview_OVID, Subview_Name, Display_ID, Display_OVID, Display_Name, Notation, Show_All_Details, Show_Names_Only, Show_Elements, Show_Datatype, Show_Keys, Autoroute, Box_In_box, Master_Diagram_Name, Diagram_SVG, Diagram_PDF, Design_OVID) AS select  Diagram_Name, Object_ID, OVID, Diagram_Type, Is_Display, Visible, Master_Diagram_ID, Master_Diagram_OVID, Model_ID, Model_OVID, Model_Name, Subview_ID, Subview_OVID, Subview_Name, Display_ID, Display_OVID, Display_Name, Notation, Show_All_Details, Show_Names_Only, Show_Elements, Show_Datatype, Show_Keys, Autoroute, Box_In_box, Master_Diagram_Name, Diagram_SVG, Diagram_PDF, Design_OVID from DMRS_DIAGRAMS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DISTINCT_TYPES (Design_ID, Design_OVID, Design_Name, Distinct_Type_ID, Distinct_Type_OVID, Distinct_Type_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, T_Size, T_Precision, T_Scale) AS select  Design_ID, Design_OVID, Design_Name, Distinct_Type_ID, Distinct_Type_OVID, Distinct_Type_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, T_Size, T_Precision, T_Scale from DMRS_DISTINCT_TYPES";
                st.execute(query);
                query = "CREATE VIEW DMRV_EMAILS (Email_ID, Email_OVID, Email_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Email_Address, Email_Type, Design_OVID) AS select  Email_ID, Email_OVID, Email_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Email_Address, Email_Type, Design_OVID from DMRS_EMAILS";
                st.execute(query);
                query = "CREATE VIEW DMRV_ENTITIES (Entity_Name, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Number_Data_Elements, Classification_Type_ID, Classification_Type_OVID, Classification_Type_Name, Allow_Type_Substitution, Min_Volume, Expected_Volume, Max_Volume, Growth_Rate_Percents, Growth_Rate_Interval, Normal_Form, Temporary_Object_Scope, Adequately_Normalized, Substitution_Parent, Substitution_Parent_OVID, Synonyms, Synonym_To_Display, Preferred_Abbreviation, SuperTypeEntity_ID, SuperTypeEntity_OVID, Engineering_Strategy, Owner, Entity_Source, Model_Name, Substitution_Parent_Name, SuperTypeEntity_Name, Design_OVID) AS select  Entity_Name, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Number_Data_Elements, Classification_Type_ID, Classification_Type_OVID, Classification_Type_Name, Allow_Type_Substitution, Min_Volume, Expected_Volume, Max_Volume, Growth_Rate_Percents, Growth_Rate_Interval, Normal_Form, Temporary_Object_Scope, Adequately_Normalized, Substitution_Parent, Substitution_Parent_OVID, Synonyms, Synonym_To_Display, Preferred_Abbreviation, SuperTypeEntity_ID, SuperTypeEntity_OVID, Engineering_Strategy, Owner, Entity_Source, Model_Name, Substitution_Parent_Name, SuperTypeEntity_Name, Design_OVID from DMRS_ENTITIES";
                st.execute(query);
                query = "CREATE VIEW DMRV_ENTITYVIEWS (EntityView_Name, Object_ID, OVID, Model_ID, Model_OVID, Import_ID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, User_Defined, View_Type, Model_Name, Design_OVID) AS select  EntityView_Name, Object_ID, OVID, Model_ID, Model_OVID, Import_ID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, User_Defined, View_Type, Model_Name, Design_OVID from DMRS_ENTITYVIEWS";
                st.execute(query);
                query = "CREATE VIEW DMRV_EVENTS (Event_ID, Event_OVID, Event_Name, Model_ID, Model_OVID, Model_Name, Flow_ID, Flow_OVID, Flow_Name, Event_Type, Times_When_Run, Day_Of_Week, Months, Frequency, Time_Frequency, Minute, Hour, Day_Of_Month, Quarter, Year, On_Day, At_Time, Fiscal, Text, Design_OVID) AS select  Event_ID, Event_OVID, Event_Name, Model_ID, Model_OVID, Model_Name, Flow_ID, Flow_OVID, Flow_Name, Event_Type, Times_When_Run, Day_Of_Week, Months, Frequency, Time_Frequency, Minute, Hour, Day_Of_Month, Quarter, Year, On_Day, At_Time, Fiscal, Text, Design_OVID from DMRS_EVENTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_EXTERNAL_AGENTS (External_Agent_ID, External_Agent_OVID, External_Agent_Name, Diagram_ID, Diagram_OVID, Diagram_Name, External_Agent_Type, File_Location, File_Source, File_Name, File_Type, File_Owner, Data_Capture_Type, Field_Separator, Text_Delimiter, Skip_Records, Self_Describing, Design_OVID) AS select  External_Agent_ID, External_Agent_OVID, External_Agent_Name, Diagram_ID, Diagram_OVID, Diagram_Name, External_Agent_Type, File_Location, File_Source, File_Name, File_Type, File_Owner, Data_Capture_Type, Field_Separator, Text_Delimiter, Skip_Records, Self_Describing, Design_OVID from DMRS_EXTERNAL_AGENTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_EXT_AGENT_FLOWS (External_Agent_ID, External_Agent_OVID, External_Agent_Name, Flow_ID, Flow_OVID, Flow_Name, Incoming_Outgoing_Flag, Design_OVID) AS select  External_Agent_ID, External_Agent_OVID, External_Agent_Name, Flow_ID, Flow_OVID, Flow_Name, Incoming_Outgoing_Flag, Design_OVID from DMRS_EXT_AGENT_FLOWS";
                st.execute(query);
                query = "CREATE VIEW DMRV_EXT_AGENT_EXT_DATAS (External_Agent_ID, External_Agent_OVID, External_Agent_Name, External_Data_ID, External_Data_OVID, External_Data_Name, Design_OVID) AS select  External_Agent_ID, External_Agent_OVID, External_Agent_Name, External_Data_ID, External_Data_OVID, External_Data_Name, Design_OVID from DMRS_EXT_AGENT_EXT_DATAS";
                st.execute(query);
                query = "CREATE VIEW DMRV_EXTERNAL_DATAS (External_Data_ID, External_Data_OVID, External_Data_Name, Model_ID, Model_OVID, Model_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, Record_Structure_Type_ID, Record_Structure_Type_OVID, Record_Structure_Type_Name, Starting_Pos, Description, Design_OVID) AS select  External_Data_ID, External_Data_OVID, External_Data_Name, Model_ID, Model_OVID, Model_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, Record_Structure_Type_ID, Record_Structure_Type_OVID, Record_Structure_Type_Name, Starting_Pos, Description, Design_OVID from DMRS_EXTERNAL_DATAS";
                st.execute(query);
                query = "CREATE VIEW DMRV_FLOW_INFO_STRUCTURES (Flow_ID, Flow_OVID, Flow_Name, Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Design_OVID) AS select  Flow_ID, Flow_OVID, Flow_Name, Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Design_OVID from DMRS_FLOW_INFO_STRUCTURES";
                st.execute(query);
                query = "CREATE VIEW DMRV_FLOWS (Flow_ID, Flow_OVID, Flow_Name, Diagram_ID, Diagram_OVID, Diagram_Name, Event_ID, Event_OVID, Event_Name, Source_ID, Source_OVID, Source_Name, Destination_ID, Destination_OVID, Destination_Name, Parent_ID, Parent_OVID, Parent_Name, Source_Type, Destination_Type, System_Objective, Logging, Op_Create, Op_Read, Op_Update, Op_Delete, CRUD_Code, Design_OVID) AS select  Flow_ID, Flow_OVID, Flow_Name, Diagram_ID, Diagram_OVID, Diagram_Name, Event_ID, Event_OVID, Event_Name, Source_ID, Source_OVID, Source_Name, Destination_ID, Destination_OVID, Destination_Name, Parent_ID, Parent_OVID, Parent_Name, Source_Type, Destination_Type, System_Objective, Logging, Op_Create, Op_Read, Op_Update, Op_Delete, CRUD_Code, Design_OVID from DMRS_FLOWS";
                st.execute(query);
                query = "CREATE VIEW DMRV_FOREIGNKEYS (FK_Name, Model_ID, Model_OVID, Object_ID, OVID, Import_ID, Child_Table_Name, Referred_Table_Name, Engineer, Delete_Rule, Child_Table_ID, Child_Table_OVID, Referred_Table_ID, Referred_Table_OVID, Referred_Key_ID, Referred_Key_OVID, Number_Of_Columns, Mandatory, Transferable, In_Arc, Arc_ID, Model_Name, Referred_Key_Name, Design_OVID) AS select  FK_Name, Model_ID, Model_OVID, Object_ID, OVID, Import_ID, Child_Table_Name, Referred_Table_Name, Engineer, Delete_Rule, Child_Table_ID, Child_Table_OVID, Referred_Table_ID, Referred_Table_OVID, Referred_Key_ID, Referred_Key_OVID, Number_Of_Columns, Mandatory, Transferable, In_Arc, Arc_ID, Model_Name, Referred_Key_Name, Design_OVID from DMRS_FOREIGNKEYS";
                st.execute(query);
                query = "CREATE VIEW DMRV_INDEXES (Index_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, State, Functional, Expression, Engineer, Table_Name, Spatial_Index, Spatial_Layer_Type, Geodetic_Index, Number_Of_Dimensions, Design_OVID) AS select  Index_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, State, Functional, Expression, Engineer, Table_Name, Spatial_Index, Spatial_Layer_Type, Geodetic_Index, Number_Of_Dimensions, Design_OVID from DMRS_INDEXES";
                st.execute(query);
                query = "CREATE VIEW DMRV_INFO_STORES (Info_Store_ID, Info_Store_OVID, Info_Store_Name, Model_ID, Model_OVID, Model_Name, Info_Store_Type, Object_Type, Implementation_Name, Location, Source, File_Name, File_Type, Owner, Rdbms_Site, Scope, Transfer_Type, Field_Separator, Text_Delimiter, Skip_Records, Self_Describing, System_Objective, Design_OVID) AS select  Info_Store_ID, Info_Store_OVID, Info_Store_Name, Model_ID, Model_OVID, Model_Name, Info_Store_Type, Object_Type, Implementation_Name, Location, Source, File_Name, File_Type, Owner, Rdbms_Site, Scope, Transfer_Type, Field_Separator, Text_Delimiter, Skip_Records, Self_Describing, System_Objective, Design_OVID from DMRS_INFO_STORES";
                st.execute(query);
                query = "CREATE VIEW DMRV_INFO_STRUCTURES (Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Model_ID, Model_OVID, Model_Name, Growth_Rate_Unit, Growth_Rate_Percent, Volume, Design_OVID) AS select  Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Model_ID, Model_OVID, Model_Name, Growth_Rate_Unit, Growth_Rate_Percent, Volume, Design_OVID from DMRS_INFO_STRUCTURES";
                st.execute(query);
                query = "CREATE VIEW DMRV_INFO_STRUCT_ATTRS (Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Attribute_ID, Attribute_OVID, Attribute_Name, Entity_ID, Entity_OVID, Entity_Name, Design_OVID) AS select  Info_Structure_ID, Info_Structure_OVID, Info_Structure_Name, Attribute_ID, Attribute_OVID, Attribute_Name, Entity_ID, Entity_OVID, Entity_Name, Design_OVID from DMRS_INFO_STRUCT_ATTRS";
                st.execute(query);
                query = "CREATE VIEW DMRV_TASK_PARAMS (Task_Params_ID, Task_Params_OVID, Task_Params_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Task_Params_Type, Multiplicity, System_Objective, Design_OVID) AS select  Task_Params_ID, Task_Params_OVID, Task_Params_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Task_Params_Type, Multiplicity, System_Objective, Design_OVID from DMRS_TASK_PARAMS";
                st.execute(query);
                query = "CREATE VIEW DMRV_TASK_PARAMS_ITEMS (Task_Params_Item_ID, Task_Params_Item_OVID, Task_Params_Item_Name, Task_Params_ID, Task_Params_OVID, Task_Params_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, Task_Params_Item_Type, Design_OVID) AS select  Task_Params_Item_ID, Task_Params_Item_OVID, Task_Params_Item_Name, Task_Params_ID, Task_Params_OVID, Task_Params_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, Task_Params_Item_Type, Design_OVID from DMRS_TASK_PARAMS_ITEMS";
                st.execute(query);
                query = "CREATE VIEW DMRV_KEYS (Key_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, State, Synonyms, Entity_Name, Design_OVID) AS select  Key_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, State, Synonyms, Entity_Name, Design_OVID from DMRS_KEYS";
                st.execute(query);
                query = "CREATE VIEW DMRV_KEY_ATTRIBUTES (Key_ID, Key_OVID, Attribute_ID, Attribute_OVID, Entity_ID, Entity_OVID, Key_Name, Entity_Name, Attribute_Name, Sequence, Relationship_ID, Relationship_OVID, Relationship_Name, Design_OVID) AS select  Key_ID, Key_OVID, Attribute_ID, Attribute_OVID, Entity_ID, Entity_OVID, Key_Name, Entity_Name, Attribute_Name, Sequence, Relationship_ID, Relationship_OVID, Relationship_Name, Design_OVID from DMRS_KEY_ATTRIBUTES";
                st.execute(query);
                query = "CREATE VIEW DMRV_KEY_ELEMENTS (Key_ID, Key_OVID, Type, Element_ID, Element_OVID, Element_Name, Sequence, Source_Label, Target_Label, Entity_ID, Key_Name, Entity_OVID, Entity_Name, Design_OVID) AS select  Key_ID, Key_OVID, Type, Element_ID, Element_OVID, Element_Name, Sequence, Source_Label, Target_Label, Entity_ID, Key_Name, Entity_OVID, Entity_Name, Design_OVID from DMRS_KEY_ELEMENTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_LOCATIONS (Location_ID, Location_OVID, Location_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Loc_Address, Loc_City, Loc_Post_Code, Loc_Area, Loc_Country, Loc_Type, Design_OVID) AS select  Location_ID, Location_OVID, Location_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Loc_Address, Loc_City, Loc_Post_Code, Loc_Area, Loc_Country, Loc_Type, Design_OVID from DMRS_LOCATIONS";
                st.execute(query);
                query = "CREATE VIEW DMRV_LOGICAL_TO_NATIVE (Design_ID, Design_OVID, Design_Name, Logical_Type_ID, Logical_Type_OVID, LT_Name, Native_Type, RDBMS_Type, RDBMS_Version, Has_Size, Has_Precision, Has_Scale) AS select  Design_ID, Design_OVID, Design_Name, Logical_Type_ID, Logical_Type_OVID, LT_Name, Native_Type, RDBMS_Type, RDBMS_Version, Has_Size, Has_Precision, Has_Scale from DMRS_LOGICAL_TO_NATIVE";
                st.execute(query);
                query = "CREATE VIEW DMRV_LOGICAL_TYPES (Design_ID, Design_OVID, Design_Name, Logical_Type_ID, OVID, LT_Name) AS select  Design_ID, Design_OVID, Design_Name, Logical_Type_ID, OVID, LT_Name from DMRS_LOGICAL_TYPES";
                st.execute(query);
                query = "CREATE VIEW DMRV_MAPPINGS (Logical_Model_ID, Logical_Model_OVID, Logical_Model_Name, Logical_Object_ID, Logical_Object_OVID, Logical_Object_Name, Logical_Object_Type, Relational_Model_ID, Relational_Model_OVID, Relational_Model_Name, Relational_Object_ID, Relational_Object_OVID, Relational_Object_Name, Relational_Object_Type, Entity_ID, Entity_OVID, Entity_Name, Table_ID, Table_OVID, Table_Name, Design_ID, Design_OVID, Design_Name) AS select  Logical_Model_ID, Logical_Model_OVID, Logical_Model_Name, Logical_Object_ID, Logical_Object_OVID, Logical_Object_Name, Logical_Object_Type, Relational_Model_ID, Relational_Model_OVID, Relational_Model_Name, Relational_Object_ID, Relational_Object_OVID, Relational_Object_Name, Relational_Object_Type, Entity_ID, Entity_OVID, Entity_Name, Table_ID, Table_OVID, Table_Name, Design_ID, Design_OVID, Design_Name from DMRS_MAPPINGS";
                st.execute(query);
                query = "CREATE VIEW DMRV_MAPPING_TARGETS (Object_ID, Object_OVID, Object_Name, Target_ID, Target_OVID, Target_Name, Object_Type, Target_Type, Transformation_Type, Description, Design_OVID) AS select  Object_ID, Object_OVID, Object_Name, Target_ID, Target_OVID, Target_Name, Object_Type, Target_Type, Transformation_Type, Description, Design_OVID from DMRS_MAPPING_TARGETS";
                st.execute(query);
                query = "CREATE VIEW DMRV_MAPPING_TARGET_SOURCES (Object_ID, Object_OVID, Object_Name, Target_ID, Target_OVID, Target_Name, Source_ID, Source_OVID, Source_Name, Object_Type, Target_Type, Source_Type, Design_OVID) AS select  Object_ID, Object_OVID, Object_Name, Target_ID, Target_OVID, Target_Name, Source_ID, Source_OVID, Source_Name, Object_Type, Target_Type, Source_Type, Design_OVID from DMRS_MAPPING_TARGET_SOURCES";
                st.execute(query);
                query = "CREATE VIEW DMRV_NATIVE_TO_LOGICAL (RDBMS_Type, RDBMS_Version, Native_Type, LT_Name, Logical_Type_ID, Logical_Type_OVID, Design_ID, Design_OVID, Design_Name) AS select  RDBMS_Type, RDBMS_Version, Native_Type, LT_Name, Logical_Type_ID, Logical_Type_OVID, Design_ID, Design_OVID, Design_Name from DMRS_NATIVE_TO_LOGICAL";
                st.execute(query);
                query = "CREATE VIEW DMRV_NOTES (Object_ID, OVID, Object_Name, Model_OVID, Model_ID, Model_Name, Design_OVID) AS select  Object_ID, OVID, Object_Name, Model_OVID, Model_ID, Model_Name, Design_OVID from DMRS_NOTES";
                st.execute(query);
                query = "CREATE VIEW DMRV_PK_OID_COLUMNS (Column_ID, Column_OVID, Table_ID, Table_OVID, Table_Name, Column_Name, Design_OVID) AS select  Column_ID, Column_OVID, Table_ID, Table_OVID, Table_Name, Column_Name, Design_OVID from DMRS_PK_OID_COLUMNS";
                st.execute(query);
                query = "CREATE VIEW DMRV_PROCESS_ATTRIBUTES (Process_ID, Process_OVID, Entity_ID, Entity_OVID, Flow_ID, Flow_OVID, DFD_ID, DFD_OVID, Process_Name, Entity_Name, Flow_Name, DFD_Name, OP_Read, OP_Create, OP_Update, OP_Delete, CRUD_Code, Flow_Direction, Attribute_ID, Attribute_OVID, Attribute_Name, Design_OVID) AS select  Process_ID, Process_OVID, Entity_ID, Entity_OVID, Flow_ID, Flow_OVID, DFD_ID, DFD_OVID, Process_Name, Entity_Name, Flow_Name, DFD_Name, OP_Read, OP_Create, OP_Update, OP_Delete, CRUD_Code, Flow_Direction, Attribute_ID, Attribute_OVID, Attribute_Name, Design_OVID from DMRS_PROCESS_ATTRIBUTES";
                st.execute(query);
                query = "CREATE VIEW DMRV_PROCESS_ENTITIES (Process_ID, Process_OVID, Entity_ID, Entity_OVID, Flow_ID, Flow_OVID, DFD_ID, DFD_OVID, Process_Name, Entity_Name, Flow_Name, DFD_Name, OP_Read, OP_Create, OP_Update, OP_Delete, CRUD_Code, Flow_Direction, Model_ID, Model_OVID, Model_Name, Design_OVID) AS select  Process_ID, Process_OVID, Entity_ID, Entity_OVID, Flow_ID, Flow_OVID, DFD_ID, DFD_OVID, Process_Name, Entity_Name, Flow_Name, DFD_Name, OP_Read, OP_Create, OP_Update, OP_Delete, CRUD_Code, Flow_Direction, Model_ID, Model_OVID, Model_Name, Design_OVID from DMRS_PROCESS_ENTITIES";
                st.execute(query);
                query = "CREATE VIEW DMRV_PROCESSES (Process_ID, Process_OVID, Process_Name, Diagram_ID, Diagram_OVID, Diagram_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Parent_Process_ID, Parent_Process_OVID, Parent_Process_Name, Process_Number, Process_Type, Process_Mode, Priority, Frequency_Times, Frequency_Time_Unit, Peak_Periods_String, Parameters_Wrappers_String, Interactive_Max_Response_Time, Interactive_Response_Time_Unit, Batch_Min_Transactions, Batch_Time_Unit, Design_OVID) AS select  Process_ID, Process_OVID, Process_Name, Diagram_ID, Diagram_OVID, Diagram_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Parent_Process_ID, Parent_Process_OVID, Parent_Process_Name, Process_Number, Process_Type, Process_Mode, Priority, Frequency_Times, Frequency_Time_Unit, Peak_Periods_String, Parameters_Wrappers_String, Interactive_Max_Response_Time, Interactive_Response_Time_Unit, Batch_Min_Transactions, Batch_Time_Unit, Design_OVID from DMRS_PROCESSES";
                st.execute(query);
                query = "CREATE VIEW DMRV_RDBMS_SITES (Site_Name, Site_ID, Site_OVID, RDBMS_Type, Design_OVID) AS select  Site_Name, Site_ID, Site_OVID, RDBMS_Type, Design_OVID from DMRS_RDBMS_SITES";
                st.execute(query);
                query = "CREATE VIEW DMRV_RECORD_STRUCTURES (Record_Structure_ID, Record_Structure_OVID, Record_Structure_Name, Model_ID, Model_OVID, Model_Name, Design_OVID) AS select  Record_Structure_ID, Record_Structure_OVID, Record_Structure_Name, Model_ID, Model_OVID, Model_Name, Design_OVID from DMRS_RECORD_STRUCTURES";
                st.execute(query);
                query = "CREATE VIEW DMRV_RECORD_STRUCT_EXT_DATAS (Record_Structure_ID, Record_Structure_OVID, Record_Structure_Name, External_Data_ID, External_Data_OVID, External_Data_Name, Design_OVID) AS select  Record_Structure_ID, Record_Structure_OVID, Record_Structure_Name, External_Data_ID, External_Data_OVID, External_Data_Name, Design_OVID from DMRS_RECORD_STRUCT_EXT_DATAS";
                st.execute(query);
                query = "CREATE VIEW DMRV_RELATIONSHIPS (Relationship_Name, Model_ID, Model_OVID, Object_ID, OVID, Import_ID, Source_Entity_Name, Target_Entity_Name, Source_Label, Target_Label, SourceTo_Target_Cardinality, TargetTo_Source_Cardinality, Source_Optional, Target_Optional, Dominant_Role, Identifying, Source_ID, Source_OVID, Target_ID, Target_OVID, Number_Of_Attributes, Transferable, In_Arc, Arc_ID, Model_Name, Design_OVID) AS select  Relationship_Name, Model_ID, Model_OVID, Object_ID, OVID, Import_ID, Source_Entity_Name, Target_Entity_Name, Source_Label, Target_Label, SourceTo_Target_Cardinality, TargetTo_Source_Cardinality, Source_Optional, Target_Optional, Dominant_Role, Identifying, Source_ID, Source_OVID, Target_ID, Target_OVID, Number_Of_Attributes, Transferable, In_Arc, Arc_ID, Model_Name, Design_OVID from DMRS_RELATIONSHIPS";
                st.execute(query);
                query = "CREATE VIEW DMRV_RESOURCE_LOCATORS (Resource_Locator_ID, Resource_Locator_OVID, Resource_Locator_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Url, Design_OVID) AS select  Resource_Locator_ID, Resource_Locator_OVID, Resource_Locator_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Url, Design_OVID from DMRS_RESOURCE_LOCATORS";
                st.execute(query);
                query = "CREATE VIEW DMRV_RESPONSIBLE_PARTIES (Responsible_Party_ID, Responsible_Party_OVID, Responsible_Party_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Parent_ID, Parent_OVID, Parent_Name, Responsibility, Design_OVID) AS select  Responsible_Party_ID, Responsible_Party_OVID, Responsible_Party_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Parent_ID, Parent_OVID, Parent_Name, Responsibility, Design_OVID from DMRS_RESPONSIBLE_PARTIES";
                st.execute(query);
                query = "CREATE VIEW DMRV_RES_PARTY_CONTACTS (Responsible_Party_ID, Responsible_Party_OVID, Responsible_Party_Name, Contact_ID, Contact_OVID, Contact_Name, Design_OVID) AS select  Responsible_Party_ID, Responsible_Party_OVID, Responsible_Party_Name, Contact_ID, Contact_OVID, Contact_Name, Design_OVID from DMRS_RES_PARTY_CONTACTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_RES_PARTY_ELEMENTS (Responsible_Party_ID, Responsible_Party_OVID, Responsible_Party_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID) AS select  Responsible_Party_ID, Responsible_Party_OVID, Responsible_Party_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID from DMRS_RES_PARTY_ELEMENTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_ROLES (Role_ID, Role_OVID, Role, Model_ID, Model_OVID, Model_Name, Description, Design_OVID) AS select  Role_ID, Role_OVID, Role_Name, Model_ID, Model_OVID, Model_Name, Description, Design_OVID from DMRS_ROLES";
                st.execute(query);
                query = "CREATE VIEW DMRV_ROLE_PROCESSES (Role_ID, Role_OVID, Role, Process_ID, Process_OVID, Process_Name, Design_OVID) AS select  Role_ID, Role_OVID, Role_Name, Process_ID, Process_OVID, Process_Name, Design_OVID from DMRS_ROLE_PROCESSES";
                st.execute(query);
                query = "CREATE VIEW DMRV_SOURCE_INFO (Source_Info_OVID, Source_Info_Type, DDL_File_Name, DDL_Path_Name, DDL_DB_Type, DataDict_Connection_Name, DataDict_Connection_Url, DataDict_DB_Type, Model_ID, Model_OVID, Model_Name, Design_OVID) AS select  Source_Info_OVID, Source_Info_Type, DDL_File_Name, DDL_Path_Name, DDL_DB_Type, DataDict_Connection_Name, DataDict_Connection_Url, DataDict_DB_Type, Model_ID, Model_OVID, Model_Name, Design_OVID from DMRS_SOURCE_INFO";
                st.execute(query);
                query = "CREATE VIEW DMRV_SPATIAL_COLUMN_DEFINITION (Table_ID, Table_OVID, Definition_ID, Definition_OVID, Definition_Name, Table_Name, Column_ID, Column_OVID, Column_Name, Use_Function, Function_Expression, Coordinate_System_ID, Has_Spatial_Index, Spatial_Index_ID, Spatial_Index_OVID, Spatial_Index_Name, Design_OVID) AS select  Table_ID, Table_OVID, Definition_ID, Definition_OVID, Definition_Name, Table_Name, Column_ID, Column_OVID, Column_Name, Use_Function, Function_Expression, Coordinate_System_ID, Has_Spatial_Index, Spatial_Index_ID, Spatial_Index_OVID, Spatial_Index_Name, Design_OVID from DMRS_SPATIAL_COLUMN_DEFINITION";
                st.execute(query);
                query = "CREATE VIEW DMRV_SPATIAL_DIMENSIONS (Definition_ID, Definition_OVID, Definition_Name, Dimension_Name, Low_Boundary, Upper_Boundary, Tolerance, Design_OVID) AS select  Definition_ID, Definition_OVID, Definition_Name, Dimension_Name, Low_Boundary, Upper_Boundary, Tolerance, Design_OVID from DMRS_SPATIAL_DIMENSIONS";
                st.execute(query);
                query = "CREATE VIEW DMRV_STRUCTURED_TYPES (Design_ID, Design_OVID, Design_Name, Model_OVID, Model_Name, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Super_Type_ID, Super_Type_OVID, Super_Type_Name, Predefined, ST_Final, ST_Instantiable) AS select  Design_ID, Design_OVID, Design_Name, Model_OVID, Model_Name, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Super_Type_ID, Super_Type_OVID, Super_Type_Name, Predefined, ST_Final, ST_Instantiable from DMRS_STRUCTURED_TYPES";
                st.execute(query);
                query = "CREATE VIEW DMRV_STRUCT_TYPE_ATTRS (Attribute_ID, Attribute_OVID, Attribute_Name, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Mandatory, Reference, T_Size, T_Precision, T_Scale, Type_ID, Type_OVID, Type_Name, Design_OVID) AS SELECT Attribute_ID, Attribute_OVID, Attribute_Name, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Mandatory, Reference, T_Size, T_Precision, T_Scale, Type_ID, Type_OVID, Type_Name, Design_OVID FROM DMRS_STRUCT_TYPE_ATTRS";
                st.execute(query);
                query = "CREATE VIEW DMRV_STRUCT_TYPE_METHODS (Method_ID, Method_OVID, Method_Name, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Body, Constructor, Overridden_Method_ID, Overridden_Method_OVID, Overridden_Method_Name, Design_OVID) AS SELECT stm.Method_ID, stm.Method_OVID, stm.Method_Name, stm.Structured_Type_ID, stm.Structured_Type_OVID, stm.Structured_Type_Name, lt.Text, stm.Constructor, stm.Overridden_Method_ID, stm.Overridden_Method_OVID, stm.Overridden_Method_Name, stm.Design_OVID FROM DMRS_STRUCT_TYPE_METHODS stm, DMRS_LARGE_TEXT lt WHERE stm.Method_id  = lt.Object_id";
                st.execute(query);
                query = "CREATE VIEW DMRV_STRUCT_TYPE_METHOD_PARS (Parameter_ID, Parameter_OVID, Parameter_Name, Method_ID, Method_OVID, Method_Name, Return_Value, Reference, Seq, T_Size, T_Precision, T_Scale, Type_ID, Type_OVID, Type_Name, Design_OVID) AS SELECT  Parameter_ID, Parameter_OVID, Parameter_Name, Method_ID, Method_OVID, Method_Name, Return_Value, Reference, Seq, T_Size, T_Precision, T_Scale, Type_ID, Type_OVID, Type_Name, Design_OVID FROM DMRS_STRUCT_TYPE_METHOD_PARS";
                st.execute(query);
                query = "CREATE VIEW DMRV_TABLES (Table_Name, Abbreviation, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Number_Data_Elements, Classification_Type_ID, Classification_Type_OVID, Classification_Type_Name, Allow_Type_Substitution, Min_Volume, Expected_Volume, Max_Volume, Growth_Rate_Percents, Growth_Rate_Interval, Normal_Form, Temporary_Object_Scope, Adequately_Normalized, Substitution_Parent, Substitution_Parent_OVID, Engineer, Spatial_Table, OID_is_PK, OID_is_User_Defined, Include_Scripts_Into_DDL, Model_Name, Substitution_Parent_Name, Source_Info_OVID, Source_DataDict_Schema_Name, Source_DataDict_Object_Name, Design_OVID) AS select  Table_Name, Abbreviation, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Number_Data_Elements, Classification_Type_ID, Classification_Type_OVID, Classification_Type_Name, Allow_Type_Substitution, Min_Volume, Expected_Volume, Max_Volume, Growth_Rate_Percents, Growth_Rate_Interval, Normal_Form, Temporary_Object_Scope, Adequately_Normalized, Substitution_Parent, Substitution_Parent_OVID, Engineer, Spatial_Table, OID_is_PK, OID_is_User_Defined, Include_Scripts_Into_DDL, Model_Name, Substitution_Parent_Name, Source_Info_OVID, Source_DataDict_Schema_Name, Source_DataDict_Object_Name, Design_OVID from DMRS_TABLES";
                st.execute(query);
                query = "CREATE VIEW DMRV_TABLEVIEWS (TableView_Name, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Where_Clause, Having_Clause, User_Defined, Engineer, Allow_Type_Substitution, OID_Columns, Model_Name, Design_OVID) AS select  TableView_Name, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Where_Clause, Having_Clause, User_Defined, Engineer, Allow_Type_Substitution, OID_Columns, Model_Name, Design_OVID from DMRS_TABLEVIEWS";
                st.execute(query);
                query = "CREATE VIEW DMRV_TABLE_CONSTRAINTS (Table_ID, Table_OVID, Sequence, Constraint_ID, Constraint_OVID, Constraint_Name, Text, Table_Name, Design_OVID) AS select  Table_ID, Table_OVID, Sequence, Constraint_ID, Constraint_OVID, Constraint_Name, Text, Table_Name, Design_OVID from DMRS_TABLE_CONSTRAINTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_COLUMN_GROUPS (Table_ID, Table_OVID, Sequence, ColumnGroup_ID, ColumnGroup_OVID, ColumnGroup_Name, Columns, Notes, Table_Name, Design_OVID) AS select  Table_ID, Table_OVID, Sequence, ColumnGroup_ID, ColumnGroup_OVID, ColumnGroup_Name, Columns, Notes, Table_Name, Design_OVID from DMRS_COLUMN_GROUPS";
                st.execute(query);
                query = "CREATE VIEW DMRV_CUBES (Cube_ID, Cube_Name, Cube_OVID, Model_ID, Model_Name, Model_OVID, Part_Dimension_ID, Part_Dimension_Name, Part_Dimension_OVID, Part_Hierarchy_ID, Part_Hierarchy_Name, Part_Hierarchy_OVID, Part_Level_ID, Part_Level_Name, Part_Level_OVID, Full_Cube_Slice_ID, Full_Cube_Slice_Name, Full_Cube_Slice_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Compressed_Composites, Is_Global_Composites, Is_Partitioned, Is_Virtual, Part_Description, Description, Design_OVID) AS select  Cube_ID, Cube_Name, Cube_OVID, Model_ID, Model_Name, Model_OVID, Part_Dimension_ID, Part_Dimension_Name, Part_Dimension_OVID, Part_Hierarchy_ID, Part_Hierarchy_Name, Part_Hierarchy_OVID, Part_Level_ID, Part_Level_Name, Part_Level_OVID, Full_Cube_Slice_ID, Full_Cube_Slice_Name, Full_Cube_Slice_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Compressed_Composites, Is_Global_Composites, Is_Partitioned, Is_Virtual, Part_Description, Description, Design_OVID from DMRS_CUBES";
                st.execute(query);
                query = "CREATE VIEW DMRV_CUBE_DIMENSIONS (Cube_ID, Cube_Name, Cube_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Design_OVID) AS select  Cube_ID, Cube_Name, Cube_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Design_OVID from DMRS_CUBE_DIMENSIONS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DIMENSIONS (Dimension_ID, Dimension_Name, Dimension_OVID, Model_ID, Model_Name, Model_OVID, Base_Entity_ID, Base_Entity_Name, Base_Entity_OVID, Base_Level_ID, Base_Level_Name, Base_Level_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Description, Design_OVID) AS select  Dimension_ID, Dimension_Name, Dimension_OVID, Model_ID, Model_Name, Model_OVID, Base_Entity_ID, Base_Entity_Name, Base_Entity_OVID, Base_Level_ID, Base_Level_Name, Base_Level_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Description, Design_OVID from DMRS_DIMENSIONS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DIMENSION_CALC_ATTRS (Dimension_ID, Dimension_Name, Dimension_OVID, Calc_Attribute_ID, Calc_Attribute_Name, Calc_Attribute_OVID, Calculated_Expr, Design_OVID) AS select  Dimension_ID, Dimension_Name, Dimension_OVID, Calc_Attribute_ID, Calc_Attribute_Name, Calc_Attribute_OVID, Calculated_Expr, Design_OVID from DMRS_DIMENSION_CALC_ATTRS";
                st.execute(query);
                query = "CREATE VIEW DMRV_DIMENSION_LEVELS (Dimension_ID, Dimension_Name, Dimension_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) AS select  Dimension_ID, Dimension_Name, Dimension_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID from DMRS_DIMENSION_LEVELS";
                st.execute(query);
                query = "CREATE VIEW DMRV_FACT_ENTITIES (Cube_ID, Cube_Name, Cube_OVID, Entity_ID, Entity_Name, Entity_OVID, Design_OVID) AS select  Cube_ID, Cube_Name, Cube_OVID, Entity_ID, Entity_Name, Entity_OVID, Design_OVID from DMRS_FACT_ENTITIES";
                st.execute(query);
                query = "CREATE VIEW DMRV_FACT_ENTITIES_JOINS (Join_ID, Join_Name, Join_OVID, Cube_ID, Cube_Name, Cube_OVID, Left_Entity_ID, Left_Entity_Name, Left_Entity_OVID, Right_Entity_ID, Right_Entity_Name, Right_Entity_OVID, Design_OVID) AS select  Join_ID, Join_Name, Join_OVID, Cube_ID, Cube_Name, Cube_OVID, Left_Entity_ID, Left_Entity_Name, Left_Entity_OVID, Right_Entity_ID, Right_Entity_Name, Right_Entity_OVID, Design_OVID from DMRS_FACT_ENTITIES_JOINS";
                st.execute(query);
                query = "CREATE VIEW DMRV_HIERARCHIES (Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Model_ID, Model_Name, Model_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Default_Hierarchy, Is_Ragged_Hierarchy, Is_Value_Based_Hierarchy, Description, Design_OVID) AS select  Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Model_ID, Model_Name, Model_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Default_Hierarchy, Is_Ragged_Hierarchy, Is_Value_Based_Hierarchy, Description, Design_OVID from DMRS_HIERARCHIES";
                st.execute(query);
                query = "CREATE VIEW DMRV_HIERARCHY_LEVELS (Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) AS select  Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID from DMRS_HIERARCHY_LEVELS";
                st.execute(query);
                query = "CREATE VIEW DMRV_HIERARCHY_ROLLUP_LINKS (Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Design_OVID) AS select  Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Design_OVID from DMRS_HIERARCHY_ROLLUP_LINKS";
                st.execute(query);
                query = "CREATE VIEW DMRV_LEVELS (Level_ID, Level_Name, Level_OVID, Model_ID, Model_Name, Model_OVID, Entity_ID, Entity_Name, Entity_OVID, Name_Column_ID, Name_Column_Name, Name_Column_OVID, Value_Column_ID, Value_Column_Name, Value_Column_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Root_Identification, Identification_Value, Selection_Criteria, Selection_Criteria_Description, Is_Value_Based_Hierarchy, Description, Design_OVID) AS select  Level_ID, Level_Name, Level_OVID, Model_ID, Model_Name, Model_OVID, Entity_ID, Entity_Name, Entity_OVID, Name_Column_ID, Name_Column_Name, Name_Column_OVID, Value_Column_ID, Value_Column_Name, Value_Column_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Root_Identification, Identification_Value, Selection_Criteria, Selection_Criteria_Description, Is_Value_Based_Hierarchy, Description, Design_OVID from DMRS_LEVELS";
                st.execute(query);
                query = "CREATE VIEW DMRV_LEVEL_ATTRS (Level_ID, Level_Name, Level_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Is_Default_Attr, Is_Level_Key_Attr, Is_Parent_Key_Attr, Is_Descriptive_Key_Attr, Is_Calculated_Attr, Descriptive_Name, Descriptive_Is_Indexed, Descriptive_Slow_Changing, Calculated_Expr, Design_OVID) AS select  Level_ID, Level_Name, Level_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Is_Default_Attr, Is_Level_Key_Attr, Is_Parent_Key_Attr, Is_Descriptive_Key_Attr, Is_Calculated_Attr, Descriptive_Name, Descriptive_Is_Indexed, Descriptive_Slow_Changing, Calculated_Expr, Design_OVID from DMRS_LEVEL_ATTRS";
                st.execute(query);
                query = "CREATE VIEW DMRV_MEASURES (Measure_ID, Measure_Name, Measure_OVID, Model_ID, Model_Name, Model_OVID, Cube_ID, Cube_Name, Cube_OVID, Fact_Object_ID, Fact_Object_Name, Fact_Object_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Fact_Object_Type, Additivity_Type, Is_Fact_Dimension, Is_Formula, Is_Custom_Formula, Formula, Where_Clause, Description, Design_OVID) AS select  Measure_ID, Measure_Name, Measure_OVID, Model_ID, Model_Name, Model_OVID, Cube_ID, Cube_Name, Cube_OVID, Fact_Object_ID, Fact_Object_Name, Fact_Object_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Fact_Object_Type, Additivity_Type, Is_Fact_Dimension, Is_Formula, Is_Custom_Formula, Formula, Where_Clause, Description, Design_OVID from DMRS_MEASURES";
                st.execute(query);
                query = "CREATE VIEW DMRV_MEASURE_AGGR_FUNCS (Measure_ID, Measure_Name, Measure_OVID, Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Measure_Alias, Is_Default, Design_OVID) AS select  Measure_ID, Measure_Name, Measure_OVID, Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Measure_Alias, Is_Default, Design_OVID from DMRS_MEASURE_AGGR_FUNCS";
                st.execute(query);
                query = "CREATE VIEW DMRV_AGGR_FUNC_DIMENSIONS (Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Design_OVID) AS select  Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Design_OVID from DMRS_AGGR_FUNC_DIMENSIONS";
                st.execute(query);
                query = "CREATE VIEW DMRV_AGGR_FUNC_LEVELS (Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) AS select  Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID from DMRS_AGGR_FUNC_LEVELS";
                st.execute(query);
                query = "CREATE VIEW DMRV_MEASURE_FOLDERS (Measure_Folder_ID, Measure_Folder_Name, Measure_Folder_OVID, Model_ID, Model_Name, Model_OVID, Parent_Folder_ID, Parent_Folder_Name, Parent_Folder_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Leaf, Description, Design_OVID) AS select  Measure_Folder_ID, Measure_Folder_Name, Measure_Folder_OVID, Model_ID, Model_Name, Model_OVID, Parent_Folder_ID, Parent_Folder_Name, Parent_Folder_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Leaf, Description, Design_OVID from DMRS_MEASURE_FOLDERS";
                st.execute(query);
                query = "CREATE VIEW DMRV_MEASURE_FOLDER_MEASURES (Measure_Folder_ID, Measure_Folder_Name, Measure_Folder_OVID, Measure_ID, Measure_Name, Measure_OVID, Parent_Object_ID, Parent_Object_Name, Parent_Object_OVID, Parent_Object_Type, Design_OVID) AS select  Measure_Folder_ID, Measure_Folder_Name, Measure_Folder_OVID, Measure_ID, Measure_Name, Measure_OVID, Parent_Object_ID, Parent_Object_Name, Parent_Object_OVID, Parent_Object_Type, Design_OVID from DMRS_MEASURE_FOLDER_MEASURES";
                st.execute(query);
                query = "CREATE VIEW DMRV_RAGGED_HIER_LINKS (Ragged_Hier_Link_ID, Ragged_Hier_Link_Name, Ragged_Hier_Link_OVID, Model_ID, Model_Name, Model_OVID, Parent_Level_ID, Parent_Level_Name, Parent_Level_OVID, Child_Level_ID, Child_Level_Name, Child_Level_OVID, Description, Design_OVID) AS select  Ragged_Hier_Link_ID, Ragged_Hier_Link_Name, Ragged_Hier_Link_OVID, Model_ID, Model_Name, Model_OVID, Parent_Level_ID, Parent_Level_Name, Parent_Level_OVID, Child_Level_ID, Child_Level_Name, Child_Level_OVID, Description, Design_OVID from DMRS_RAGGED_HIER_LINKS";
                st.execute(query);
                query = "CREATE VIEW DMRV_RAGGED_HIER_LINK_ATTRS (Ragged_Hier_Link_ID, Ragged_Hier_Link_Name, Ragged_Hier_Link_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Design_OVID) AS select  Ragged_Hier_Link_ID, Ragged_Hier_Link_Name, Ragged_Hier_Link_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Design_OVID from DMRS_RAGGED_HIER_LINK_ATTRS";
                st.execute(query);
                query = "CREATE VIEW DMRV_ROLLUP_LINKS (Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Model_ID, Model_Name, Model_OVID, Parent_Object_ID, Parent_Object_Name, Parent_Object_OVID, Child_Object_ID, Child_Object_Name, Child_Object_OVID, Fact_Entity_ID, Fact_Entity_Name, Fact_Entity_OVID, Parent_Object_Type, Child_Object_Type, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Default_Aggr_Operator, Is_Role_Playing, Is_Sparse_Dimension, Description, Design_OVID) AS select  Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Model_ID, Model_Name, Model_OVID, Parent_Object_ID, Parent_Object_Name, Parent_Object_OVID, Child_Object_ID, Child_Object_Name, Child_Object_OVID, Fact_Entity_ID, Fact_Entity_Name, Fact_Entity_OVID, Parent_Object_Type, Child_Object_Type, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Default_Aggr_Operator, Is_Role_Playing, Is_Sparse_Dimension, Description, Design_OVID from DMRS_ROLLUP_LINKS";
                st.execute(query);
                query = "CREATE VIEW DMRV_ROLLUP_LINK_ATTRS (Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Design_OVID) AS select  Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Design_OVID from DMRS_ROLLUP_LINK_ATTRS";
                st.execute(query);
                query = "CREATE VIEW DMRV_SLICES (Slice_ID, Slice_Name, Slice_OVID, Model_ID, Model_Name, Model_OVID, Cube_ID, Cube_Name, Cube_OVID, Entity_ID, Entity_Name, Entity_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Fully_Realized, Is_Read_Only, Description, Design_OVID) AS select  Slice_ID, Slice_Name, Slice_OVID, Model_ID, Model_Name, Model_OVID, Cube_ID, Cube_Name, Cube_OVID, Entity_ID, Entity_Name, Entity_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Fully_Realized, Is_Read_Only, Description, Design_OVID from DMRS_SLICES";
                st.execute(query);
                query = "CREATE VIEW DMRV_SLICE_DIM_HIER_LEVEL (Slice_ID, Slice_Name, Slice_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) AS select  Slice_ID, Slice_Name, Slice_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID from DMRS_SLICE_DIM_HIER_LEVEL";
                st.execute(query);
                query = "CREATE VIEW DMRV_SLICE_MEASURES (Slice_ID, Slice_Name, Slice_OVID, Measure_ID, Measure_Name, Measure_OVID, Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Measure_Alias, Design_OVID) AS select  Slice_ID, Slice_Name, Slice_OVID, Measure_ID, Measure_Name, Measure_OVID, Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Measure_Alias, Design_OVID from DMRS_SLICE_MEASURES";
                st.execute(query);
                query = "CREATE VIEW DMRV_TABLE_INCLUDE_SCRIPTS (Table_ID, Table_OVID, Table_Name, Type, Sequence, Text, Design_OVID) AS select  Table_ID, Table_OVID, Table_Name, Type, Sequence, Text, Design_OVID from DMRS_TABLE_INCLUDE_SCRIPTS";
                st.execute(query);
                query = "CREATE VIEW DMRV_TELEPHONES (Telephone_ID, Telephone_OVID, Telephone_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Phone_Number, Phone_Type, Design_OVID) AS select  Telephone_ID, Telephone_OVID, Telephone_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Phone_Number, Phone_Type, Design_OVID from DMRS_TELEPHONES";
                st.execute(query);
                query = "CREATE VIEW DMRV_TRANSFORMATION_PACKAGES (Transformation_Package_ID, Transformation_Package_OVID, Transformation_Package_Name, Model_ID, Model_OVID, Model_Name, System_Objective, Design_OVID) AS select  Transformation_Package_ID, Transformation_Package_OVID, Transformation_Package_Name, Model_ID, Model_OVID, Model_Name, System_Objective, Design_OVID from DMRS_TRANSFORMATION_PACKAGES";
                st.execute(query);
                query = "CREATE VIEW DMRV_TRANSFORMATION_TASKS (Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Transformation_Package_ID, Transformation_Package_OVID, Transformation_Package_Name, Process_ID, Process_OVID, Process_Name, Top_Level, Design_OVID) AS select  Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Transformation_Package_ID, Transformation_Package_OVID, Transformation_Package_Name, Process_ID, Process_OVID, Process_Name, Top_Level, Design_OVID from DMRS_TRANSFORMATION_TASKS";
                st.execute(query);
                query = "CREATE VIEW DMRV_TRANSFORMATION_TASK_INFOS (Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Info_Store_ID, Info_Store_OVID, Info_Store_Name, Source_Target_Flag, Design_OVID) AS select  Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Info_Store_ID, Info_Store_OVID, Info_Store_Name, Source_Target_Flag, Design_OVID from DMRS_TRANSFORMATION_TASK_INFOS";
                st.execute(query);
                query = "CREATE VIEW DMRV_TRANSFORMATION_FLOWS (Transformation_Flow_ID, Transformation_Flow_OVID, Transformation_Flow_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Source_ID, Source_OVID, Source_Name, Destination_ID, Destination_OVID, Destination_Name, Source_Type, Destination_Type, System_Objective, Logging, Op_Create, Op_Read, Op_Update, Op_Delete, CRUD_Code, Design_OVID) AS select  Transformation_Flow_ID, Transformation_Flow_OVID, Transformation_Flow_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Source_ID, Source_OVID, Source_Name, Destination_ID, Destination_OVID, Destination_Name, Source_Type, Destination_Type, System_Objective, Logging, Op_Create, Op_Read, Op_Update, Op_Delete, CRUD_Code, Design_OVID from DMRS_TRANSFORMATION_FLOWS";
                st.execute(query);
                query = "CREATE VIEW DMRV_TRANSFORMATIONS (Transformation_ID, Transformation_OVID, Transformation_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Filter_Condition, Join_Condition, Primary, Design_OVID) AS select  Transformation_ID, Transformation_OVID, Transformation_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Filter_Condition, Join_Condition, Primary, Design_OVID from DMRS_TRANSFORMATIONS";
                st.execute(query);
                query = "CREATE VIEW DMRV_VALUE_RANGES (DataElement_ID, DataElement_OVID, Type, Sequence, Begin_Value, End_Value, Short_Description, Container_ID, Container_OVID, Container_Name, DataElement_Name, Design_OVID) AS select  DataElement_ID, DataElement_OVID, Type, Sequence, Begin_Value, End_Value, Short_Description, Container_ID, Container_OVID, Container_Name, DataElement_Name, Design_OVID from DMRS_VALUE_RANGES";
                st.execute(query);
                query = "CREATE VIEW DMRV_VIEW_COLUMNS (View_OVID, View_ID, View_Name, Container_ID, Container_OVID, Container_Name, Container_Alias, Is_Expression, Column_ID, Column_OVID, Column_Name, Column_Alias, Native_Type, Type, Expression, Sequence, Personally_ID_Information, Sensitive_Information, Mask_For_None_Production, Model_ID, Model_OVID, Model_Name, Design_OVID) AS select  View_OVID, View_ID, View_Name, Container_ID, Container_OVID, Container_Name, Container_Alias, Is_Expression, Column_ID, Column_OVID, Column_Name, Column_Alias, Native_Type, Type, Expression, Sequence, Personally_ID_Information, Sensitive_Information, Mask_For_None_Production, Model_ID, Model_OVID, Model_Name, Design_OVID from DMRS_VIEW_COLUMNS";
                st.execute(query);
                query = "CREATE VIEW DMRV_VIEW_CONTAINERS (View_OVID, View_ID, View_Name, Container_ID, Container_OVID, Container_Name, Type, Alias, Sequence, Model_ID, Model_OVID, Model_Name, Design_OVID) AS select  View_OVID, View_ID, View_Name, Container_ID, Container_OVID, Container_Name, Type, Alias, Sequence, Model_ID, Model_OVID, Model_Name, Design_OVID from DMRS_VIEW_CONTAINERS";
                st.execute(query);
                query = "CREATE VIEW DMRV_VIEW_ORDER_GROUPBY (View_OVID, View_ID, View_Name, Container_ID, Container_OVID, Container_Name, Container_Alias, Is_Expression, Usage, Sequence, Column_ID, Column_OVID, Column_Name, Column_Alias, Sort_Order, Expression, Design_OVID) AS select  View_OVID, View_ID, View_Name, Container_ID, Container_OVID, Container_Name, Container_Alias, Is_Expression, Usage, Sequence, Column_ID, Column_OVID, Column_Name, Column_Alias, Sort_Order, Expression, Design_OVID from DMRS_VIEW_ORDER_GROUPBY";
                st.execute(query);
                query = "CREATE VIEW DMRV_LARGE_TEXT (Object_ID, OVID, Object_Name, Type, Text, Design_OVID) AS select  Object_ID, OVID, Object_Name, Type, Text, Design_OVID from DMRS_LARGE_TEXT";
                st.execute(query);
                query = "CREATE VIEW DMRV_MODEL_NAMING_OPTIONS (Object_type, Max_Name_Length, Character_Case, Valid_Characters, Model_ID, Model_OVID, Model_Name, Model_Type, Design_OVID) AS select  Object_type, Max_Name_Length, Character_Case, Valid_Characters, Model_ID, Model_OVID, Model_Name, Model_Type, Design_OVID from DMRS_MODEL_NAMING_OPTIONS";
                st.execute(query);
                query = "CREATE INDEX ATTRIBUTES_PK_IDX ON DMRS_ATTRIBUTES (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX BUSINESS_INFO_PK_IDX ON DMRS_BUSINESS_INFO(BUSINESS_INFO_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CHANGE_REQUESTS_PK_IDX ON DMRS_CHANGE_REQUESTS(CHANGE_REQUEST_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CHANGE_REQ_ELEMENTS_FK1_IDX ON DMRS_CHANGE_REQUEST_ELEMENTS(CHANGE_REQUEST_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CHANGE_REQ_ELEMENTS_FK2_IDX ON DMRS_CHANGE_REQUEST_ELEMENTS(ELEMENT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CLASS_TYPES_PK_IDX ON DMRS_CLASSIFICATION_TYPES (TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ADDITIONAL_CLASS_TYPES_PK_IDX ON DMRS_ADDITIONAL_CT_OBJECTS (Type_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DMRS_COLL_TYPES_PK_IDX ON DMRS_COLLECTION_TYPES (COLLECTION_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX COLUMNS_PK_IDX ON DMRS_COLUMNS (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX COLUMNS_FK_IDX ON DMRS_COLUMNS (CONTAINER_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX COLUMN_GROUPS_FK_IDX ON DMRS_COLUMN_GROUPS (TABLE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX COLUMN_UI_FK_IDX ON DMRS_COLUMN_UI (OBJECT_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CONSTR_INDEX_COLUMNS_FK_IDX ON DMRS_CONSTR_INDEX_COLUMNS (Index_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CONSTR_FK_COLUMNS_FK_IDX ON DMRS_CONSTR_FK_COLUMNS (Fk_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CONTACTS_PK_IDX ON DMRS_CONTACTS(CONTACT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CONTACT_EMAILS_FK1_IDX ON DMRS_CONTACT_EMAILS(CONTACT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CONTACT_LOCATIONS_FK1_IDX ON DMRS_CONTACT_LOCATIONS(CONTACT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CONTACT_RES_LOCATORS_FK1_IDX ON DMRS_CONTACT_RES_LOCATORS(CONTACT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CONTACT_TELEPHONES_FK1_IDX ON DMRS_CONTACT_TELEPHONES(CONTACT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CUBES_PK_IDX ON DMRS_CUBES (CUBE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CUBES_FK_IDX ON DMRS_CUBES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CUBE_DIMENSIONS_FK1_IDX ON DMRS_CUBE_DIMENSIONS (CUBE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CUBE_DIMENSIONS_FK2_IDX ON DMRS_CUBE_DIMENSIONS (DIMENSION_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DESIGNS_PK_IDX ON DMRS_DESIGNS (Design_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIAGRAMS_PK_IDX ON DMRS_DIAGRAMS (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIAGRAMS_FK_IDX ON DMRS_DIAGRAMS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIAGRAM_ELEMENTS_PK_IDX ON DMRS_DIAGRAM_ELEMENTS (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIAGRAM_ELEMENTS_FK_IDX ON DMRS_DIAGRAM_ELEMENTS (DIAGRAM_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DFD_INFOS_FK1_IDX ON DMRS_DATA_FLOW_DIAGRAM_INFOS (DIAGRAM_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DFD_INFOS_FK2_IDX ON DMRS_DATA_FLOW_DIAGRAM_INFOS (INFO_STORE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIMENSIONS_PK_IDX ON DMRS_DIMENSIONS (DIMENSION_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIMENSIONS_FK_IDX ON DMRS_DIMENSIONS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIMENSION_CALC_ATTRS_FK_IDX ON DMRS_DIMENSION_CALC_ATTRS (DIMENSION_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIMENSION_LEVELS_FK_IDX ON DMRS_DIMENSION_LEVELS (DIMENSION_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DISTINCT_TYPES_PK_IDX ON DMRS_DISTINCT_TYPES (DISTINCT_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DOCUMENTS_PK_IDX ON DMRS_DOCUMENTS(DOCUMENT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DOCUMENT_ELEMENTS_FK1_IDX ON DMRS_DOCUMENT_ELEMENTS(DOCUMENT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DOCUMENT_ELEMENTS_FK2_IDX ON DMRS_DOCUMENT_ELEMENTS(ELEMENT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DOMAINS_PK_IDX ON DMRS_DOMAINS (Domain_ID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DOMAINS_PK1_IDX ON DMRS_DOMAINS (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DOMAINS_FK_IDXv1 ON DMRS_DOMAINS (LOGICAL_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DOMAIN_AVT_FK_IDX ON DMRS_DOMAIN_AVT (DOMAIN_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DOMAIN_CHECK_CONSTR_FK_IDX ON DMRS_DOMAIN_CHECK_CONSTRAINTS (DOMAIN_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DOMAIN_VALUE_RANGES_FK_IDX ON DMRS_DOMAIN_VALUE_RANGES (DOMAIN_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EMAILS_PK_IDX ON DMRS_EMAILS(EMAIL_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ENTITIES_PK_IDX ON DMRS_ENTITIES (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ENTITIES_FK_IDX ON DMRS_ENTITIES (CLASSIFICATION_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ENTITIES_FK_IDXv1 ON DMRS_ENTITIES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ENTITYVIEWS_PK_IDX ON DMRS_ENTITYVIEWS (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ENTITYVIEWS_FK_IDX ON DMRS_ENTITYVIEWS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EVENTS_PK_IDX ON DMRS_EVENTS (EVENT_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EVENTS_FK_MODEL_IDX ON DMRS_EVENTS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EVENTS_FK_FLOW_IDX ON DMRS_EVENTS (FLOW_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXT_AGENTS_PK_IDX ON DMRS_EXTERNAL_AGENTS (EXTERNAL_AGENT_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXT_AGENTS_FK_DIAGRAM_IDX ON DMRS_EXTERNAL_AGENTS (DIAGRAM_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXT_AGENT_EXT_DATAS_FK1_IDX ON DMRS_EXT_AGENT_EXT_DATAS (EXTERNAL_AGENT_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXT_AGENT_EXT_DATAS_FK2_IDX ON DMRS_EXT_AGENT_EXT_DATAS (EXTERNAL_DATA_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXT_AGENT_FLOWS_FK1_IDX ON DMRS_EXT_AGENT_FLOWS (EXTERNAL_AGENT_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXT_AGENT_FLOWS_FK2_IDX ON DMRS_EXT_AGENT_FLOWS (FLOW_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXT_DATAS_PK_IDX ON DMRS_EXTERNAL_DATAS (EXTERNAL_DATA_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXT_DATAS_FK_MODEL_IDX ON DMRS_EXTERNAL_DATAS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FACT_ENTITIES_FK_IDX ON DMRS_FACT_ENTITIES (CUBE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FACT_ENTITIES_JOINS_FK_IDX ON DMRS_FACT_ENTITIES_JOINS (CUBE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FLOWS_PK_IDX ON DMRS_FLOWS (FLOW_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FLOWS_FK_DIAGRAM_IDX ON DMRS_FLOWS (DIAGRAM_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FLOW_INFO_STRUCTS_FK1_IDX ON DMRS_FLOW_INFO_STRUCTURES (FLOW_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FLOW_INFO_STRUCTS_FK2_IDX ON DMRS_FLOW_INFO_STRUCTURES (INFO_STRUCTURE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FOREIGNKEYS_PK_IDX ON DMRS_FOREIGNKEYS (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FOREIGNKEYS_FK_IDX ON DMRS_FOREIGNKEYS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX HIERARCHIES_PK_IDX ON DMRS_HIERARCHIES (HIERARCHY_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX HIERARCHIES_FK_IDX ON DMRS_HIERARCHIES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX HIERARCHY_LEVELS_FK1_IDX ON DMRS_HIERARCHY_LEVELS (HIERARCHY_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX HIERARCHY_LEVELS_FK2_IDX ON DMRS_HIERARCHY_LEVELS (LEVEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX HIERARCHY_ROLLUP_LINKS_FK1_IDX ON DMRS_HIERARCHY_ROLLUP_LINKS (HIERARCHY_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX HIERARCHY_ROLLUP_LINKS_FK2_IDX ON DMRS_HIERARCHY_ROLLUP_LINKS (ROLLUP_LINK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX INDEXES_PK_IDX ON DMRS_INDEXES (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX INDEXES_FK_IDX ON DMRS_INDEXES (CONTAINER_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX INFO_STORES_PK_IDX ON DMRS_INFO_STORES (INFO_STORE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX INFO_STORES_FK_MODEL_IDX ON DMRS_INFO_STORES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX INFO_STRUCTS_PK_IDX ON DMRS_INFO_STRUCTURES (INFO_STRUCTURE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX INFO_STRUCTS_FK_MODEL_IDX ON DMRS_INFO_STRUCTURES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX INFO_STRUCT_ATTR_FK_ISTR_IDX ON DMRS_INFO_STRUCT_ATTRS (INFO_STRUCTURE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX INFO_STRUCT_ATTR_FK_ATTR_IDX ON DMRS_INFO_STRUCT_ATTRS (ATTRIBUTE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TASK_PARAMS_PK_IDX ON DMRS_TASK_PARAMS (TASK_PARAMS_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TASK_PARAMS_FK_TASK_IDX ON DMRS_TASK_PARAMS (TRANSFORMATION_TASK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TASK_PARAMS_ITEMS_PK_IDX ON DMRS_TASK_PARAMS_ITEMS (TASK_PARAMS_ITEM_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TASK_PARAMS_ITEMS_FK_PARS_IDX ON DMRS_TASK_PARAMS_ITEMS (TASK_PARAMS_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX KEYS_PK_IDX ON DMRS_KEYS (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX KEYS_FK_IDX ON DMRS_KEYS (OVID, CONTAINER_OVID, STATE) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX KEY_ATTRIBUTES_FK_IDX ON DMRS_KEY_ATTRIBUTES (KEY_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX KEY_ELEMENTS_FK_IDX ON DMRS_KEY_ELEMENTS (KEY_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX LEVELS_PK_IDX ON DMRS_LEVELS (LEVEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX LEVELS_FK_IDX ON DMRS_LEVELS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX LEVEL_ATTRS_FK_IDX ON DMRS_LEVEL_ATTRS (LEVEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX LOCATIONS_PK_IDX ON DMRS_LOCATIONS(LOCATION_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX LOGICAL_TO_NATIVE_FK_IDXv1 ON DMRS_LOGICAL_TO_NATIVE (LOGICAL_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX LOGICAL_TYPES_PK_IDX ON DMRS_LOGICAL_TYPES (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DMRS_LARGE_TEXT_PK_IDX ON DMRS_LARGE_TEXT (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MAPPING_TARGETS_FK1_IDX ON DMRS_MAPPING_TARGETS (OBJECT_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MAPPING_TARGETS_FK2_IDX ON DMRS_MAPPING_TARGETS (TARGET_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MAPPING_TARGET_SOURCES_FK1_IDX ON DMRS_MAPPING_TARGET_SOURCES (OBJECT_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MAPPING_TARGET_SOURCES_FK2_IDX ON DMRS_MAPPING_TARGET_SOURCES (TARGET_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MAPPING_TARGET_SOURCES_FK3_IDX ON DMRS_MAPPING_TARGET_SOURCES (SOURCE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MEASURES_PK_IDX ON DMRS_MEASURES (MEASURE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MEASURES_FK_IDX ON DMRS_MEASURES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MEASURE_AGGR_FUNCS_FK_IDX ON DMRS_MEASURE_AGGR_FUNCS (MEASURE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX AGGR_FUNC_DIMENSIONS_FK_IDX ON DMRS_AGGR_FUNC_DIMENSIONS (AGGREGATE_FUNCTION_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX AGGR_FUNC_LEVELS_FK_IDX ON DMRS_AGGR_FUNC_LEVELS (AGGREGATE_FUNCTION_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MEASURE_FOLDERS_PK_IDX ON DMRS_MEASURE_FOLDERS (MEASURE_FOLDER_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MEASURE_FOLDERS_FK_IDX ON DMRS_MEASURE_FOLDERS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MEASURE_FOLDER_MEAS_FK_IDX ON DMRS_MEASURE_FOLDER_MEASURES (MEASURE_FOLDER_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MODELS_PK_IDX ON DMRS_MODELS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MODEL_SUBVIEWS_PK_IDX ON DMRS_MODEL_SUBVIEWS (SUBVIEW_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MODEL_SUBVIEWS_FK_IDX ON DMRS_MODEL_SUBVIEWS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MODEL_DISPLAYS_PK_IDX ON DMRS_MODEL_DISPLAYS (DISPLAY_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MODEL_DISPLAYS_FK_IDX ON DMRS_MODEL_DISPLAYS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MODEL_NAMING_OPTIONS_FK_IDX ON DMRS_MODEL_NAMING_OPTIONS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX NATIVE_TO_LOGICAL_FK_IDXv1 ON DMRS_NATIVE_TO_LOGICAL (LOGICAL_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX NOTES_PK_IDX ON DMRS_NOTES (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX NOTES_FK_IDX ON DMRS_NOTES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX PK_OID_COLUMNS_PK_IDX ON DMRS_PK_OID_COLUMNS (COLUMN_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX PK_OID_COLUMNS_FK_IDX ON DMRS_PK_OID_COLUMNS (TABLE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX PROCESS_ATTRS_PK_IDX ON DMRS_PROCESS_ATTRIBUTES (PROCESS_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX PROCESS_ENTS_PK_IDX ON DMRS_PROCESS_ENTITIES (PROCESS_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX PROCESSES_PK_IDX ON DMRS_PROCESSES (PROCESS_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX PROCESSES_FK_DIAGRAM_IDX ON DMRS_PROCESSES (DIAGRAM_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RAGGED_HIER_LINKS_PK_IDX ON DMRS_RAGGED_HIER_LINKS (RAGGED_HIER_LINK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RAGGED_HIER_LINKS_FK_IDX ON DMRS_RAGGED_HIER_LINKS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RAGGED_HIER_LINK_ATTRS_FK_IDX ON DMRS_RAGGED_HIER_LINK_ATTRS (RAGGED_HIER_LINK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RDBMS_SITES_PK_IDX ON DMRS_RDBMS_SITES (SITE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RECORD_STRUCTS_PK_IDX ON DMRS_RECORD_STRUCTURES (RECORD_STRUCTURE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RECORD_STRUCTS_FK_MODEL_IDX ON DMRS_RECORD_STRUCTURES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX REC_STRUCT_EXT_DATAS_FK1_IDX ON DMRS_RECORD_STRUCT_EXT_DATAS (RECORD_STRUCTURE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX REC_STRUCT_EXT_DATAS_FK2_IDX ON DMRS_RECORD_STRUCT_EXT_DATAS (EXTERNAL_DATA_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RELATIONSHIPS_PK_IDX ON DMRS_RELATIONSHIPS (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RELATIONSHIPS_FK_IDX ON DMRS_RELATIONSHIPS (TARGET_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RELATIONSHIPS_FK_IDXv1 ON DMRS_RELATIONSHIPS (SOURCE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RELATIONSHIPS_FK_IDXv2 ON DMRS_RELATIONSHIPS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RESOURCE_LOCATORS_PK_IDX ON DMRS_RESOURCE_LOCATORS (RESOURCE_LOCATOR_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RESPONSIBLE_PARTIES_PK_IDX ON DMRS_RESPONSIBLE_PARTIES (RESPONSIBLE_PARTY_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RES_PARTY_CONTACTS_FK1_IDX ON DMRS_RES_PARTY_CONTACTS (RESPONSIBLE_PARTY_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RES_PARTY_CONTACTS_FK2_IDX ON DMRS_RES_PARTY_CONTACTS (CONTACT_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RES_PARTY_ELEMENTS_FK1_IDX ON DMRS_RES_PARTY_ELEMENTS (RESPONSIBLE_PARTY_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX RES_PARTY_ELEMENTS_FK2_IDX ON DMRS_RES_PARTY_ELEMENTS (ELEMENT_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ROLES_PK_IDX ON DMRS_ROLES (ROLE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ROLES_FK_MODEL_IDX ON DMRS_ROLES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ROLE_PROCESSES_FK1_IDX ON DMRS_ROLE_PROCESSES (ROLE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ROLE_PROCESSES_FK2_IDX ON DMRS_ROLE_PROCESSES (PROCESS_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ROLLUP_LINKS_PK_IDX ON DMRS_ROLLUP_LINKS (ROLLUP_LINK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ROLLUP_LINKS_FK_IDX ON DMRS_ROLLUP_LINKS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ROLLUP_LINK_ATTRS_FK_IDX ON DMRS_ROLLUP_LINK_ATTRS (ROLLUP_LINK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX SLICES_PK_IDX ON DMRS_SLICES (SLICE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX SLICES_FK_IDX ON DMRS_SLICES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX SLICE_DIM_HIER_LEVEL_FK_IDX ON DMRS_SLICE_DIM_HIER_LEVEL (SLICE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX SLICE_MEASURES_FK_IDX ON DMRS_SLICE_MEASURES (SLICE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX SOURCE_INFO_PK_IDX ON DMRS_SOURCE_INFO (SOURCE_INFO_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX SPATIAL_COL_DEFINITION_PK_IDX ON DMRS_SPATIAL_COLUMN_DEFINITION (DEFINITION_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX SPATIAL_COL_DEFINITION_FK_IDX ON DMRS_SPATIAL_COLUMN_DEFINITION (TABLE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX SPATIAL_DIMENSIONS_FK_IDX ON DMRS_SPATIAL_DIMENSIONS (DEFINITION_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX STRUCTURED_TYPES_PK_IDX ON DMRS_STRUCTURED_TYPES (STRUCTURED_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX STRUCT_TYPE_ATTRS_FK_IDX ON DMRS_STRUCT_TYPE_ATTRS (STRUCTURED_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX STRUCT_TYPE_METHODS_FK_IDX ON DMRS_STRUCT_TYPE_METHODS (STRUCTURED_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX STRUCT_TYPE_METHOD_PARS_FK_IDX ON DMRS_STRUCT_TYPE_METHOD_PARS (METHOD_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TABLES_PK_IDX ON DMRS_TABLES (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TABLES_FK_IDX ON DMRS_TABLES (CLASSIFICATION_TYPE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TABLES_FK_IDXv1 ON DMRS_TABLES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TABLEVIEWS_PK_IDX ON DMRS_TABLEVIEWS (OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TABLEVIEWS_FK_IDX ON DMRS_TABLEVIEWS (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TABLE_CONSTRAINTS_FK_IDX ON DMRS_TABLE_CONSTRAINTS (TABLE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TABLE_INCLUDE_SCRIPTS_FK_IDX ON DMRS_TABLE_INCLUDE_SCRIPTS (TABLE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TELEPHONES_PK_IDX ON DMRS_TELEPHONES (TELEPHONE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORM_PACKS_PK_IDX ON DMRS_TRANSFORMATION_PACKAGES (TRANSFORMATION_PACKAGE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORM_PACKS_FK_MODEL_IDX ON DMRS_TRANSFORMATION_PACKAGES (MODEL_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORM_TASKS_PK_IDX ON DMRS_TRANSFORMATION_TASKS (TRANSFORMATION_TASK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORM_TASKS_FK_PACK_IDX ON DMRS_TRANSFORMATION_TASKS (TRANSFORMATION_PACKAGE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORM_TASK_INFOS_FK1_IDX ON DMRS_TRANSFORMATION_TASK_INFOS (TRANSFORMATION_TASK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORM_TASK_INFOS_FK2_IDX ON DMRS_TRANSFORMATION_TASK_INFOS (INFO_STORE_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORM_FLOWS_PK_IDX ON DMRS_TRANSFORMATION_FLOWS (TRANSFORMATION_FLOW_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORM_FLOWS_FK_TASK_IDX ON DMRS_TRANSFORMATION_FLOWS (TRANSFORMATION_TASK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORMS_PK_IDX ON DMRS_TRANSFORMATIONS (TRANSFORMATION_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TRANSFORMS_FK_TASK_IDX ON DMRS_TRANSFORMATIONS (TRANSFORMATION_TASK_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX VIEW_COLUMNS_FK_IDX ON DMRS_VIEW_COLUMNS (VIEW_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX VIEW_CONTAINERS_FK_IDX ON DMRS_VIEW_CONTAINERS (VIEW_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX VIEW_ORDER_GROUPBY_FK_IDX ON DMRS_VIEW_ORDER_GROUPBY (VIEW_OVID ASC) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ATTRIBUTES_CONTAINER_OVID_IDX ON DMRS_ATTRIBUTES(CONTAINER_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MAPPINGS_REL_OBJ_OVID_IDX ON DMRS_MAPPINGS(RELATIONAL_OBJECT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MAPPINGS_LOG_OBJ_OVID_IDX ON DMRS_MAPPINGS(LOGICAL_OBJECT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX VL_DATAELEMENT_OVID_IDX ON DMRS_VALUE_RANGES(DATAELEMENT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX AVT_DATAELEMENT_OVID_IDX ON DMRS_AVT(DATAELEMENT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX CC_DATAELEMENT_OVID_DX ON DMRS_CHECK_CONSTRAINTS(DATAELEMENT_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX PROCESS_ENTS_ENT_IDX ON DMRS_PROCESS_ENTITIES(ENTITY_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TABLES_NAME_IDX ON DMRS_TABLES(OVID, TABLE_NAME) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MODELS_NAME_IDX ON DMRS_MODELS (MODEL_OVID, MODEL_NAME, MODEL_TYPE) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DESIGNS__IDX ON DMRS_DESIGNS (DESIGN_ID, DESIGN_OVID, DESIGN_NAME, VERSION_COMMENTS, DATE_PUBLISHED) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIAGRAMS_NAME_IDX ON DMRS_DIAGRAMS (OVID, DIAGRAM_NAME, DIAGRAM_TYPE, IS_DISPLAY) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX DIAGRAM_ELEMENTS_NAME_IDX ON DMRS_DIAGRAM_ELEMENTS (NAME, OVID, TYPE, MODEL_OVID, DIAGRAM_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TABLE_ARC_NAME_IDX ON DMRS_TABLE_ARCS (Object_OVID, Arc_NAME) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX ENTITY_ARC_NAME_IDX ON DMRS_ENTITY_ARCS (Object_OVID, Arc_NAME) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX SENSITIVE_TYPE_NAME_IDX ON DMRS_SENSITIVE_TYPES (Object_OVID, Sensitive_Type_Name) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TSDP_POLICY_NAME_IDX ON DMRS_TSDP_POLICIES (Object_OVID, TSDP_Policy_Name) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX TSDP_SP_POLICY_NAME_IDX ON DMRS_TSDP_SUB_POLICIES (Object_OVID, TSDP_SubPolicy_Name) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX MASK_TEMPLATE_NAME_IDX ON DMRS_MASK_TEMPLATES (Object_OVID, Mask_Template_Name) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXISTENCE_DEP_NAME_IDX ON DMRS_EXISTENCE_DEP (Object_OVID, Dependency_Name) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX EXISTENCE_DEP_COL_NAME_IDX ON DMRS_EXISTENCE_DEP_COLUMNS (Dependency_OVID, Table_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FK_CD_CONSTR_NAME_IDX ON DMRS_FK_CD_CONSTRAINTS (Fk_OVID, Constraint_OVID) NOLOGGING";
                st.execute(query);
                query = "CREATE INDEX FK_CD_CONSTR_COL_NAME_IDX ON DMRS_FK_CD_CONSTRAINTS_COLS (Constraint_OVID, Column_OVID) NOLOGGING";
                st.execute(query);
                SchemaFactory.createGlossary(connection);
                query = "CREATE INDEX GLOSSARIES_OVID_IDX ON DMRS_GLOSSARIES (GLOSSARY_OVID)";
                st.execute(query);
                query = "CREATE OR REPLACE TYPE report_template AS OBJECT (reportType                 INTEGER, useDescriptionInfo          INTEGER, useQuantitativeInfo         INTEGER, useDiagrams                 INTEGER, useTableColumns             INTEGER, useTableColumnsComments     INTEGER, useTableIndexes             INTEGER, useTableConstraints         INTEGER, useTableFKReferringTo       INTEGER, useTableFKReferredFrom      INTEGER, useEntityAttributes         INTEGER, useEntityAttributesComments INTEGER, useEntityConstraints        INTEGER, useEntityIdentifiers        INTEGER, useEntityRelationships      INTEGER, useEntityIncomingProcesses  INTEGER, useEntityOutgoingProcesses  INTEGER, useDomainConstraints        INTEGER, useDomainUsedInTables       INTEGER, useDomainUsedInEntities     INTEGER, useSTAttributes             INTEGER, useSTAttributesComments     INTEGER, useSTMethods                INTEGER, useSTUsedInTables           INTEGER, useSTUsedInEntities         INTEGER, useCTUsedInTables           INTEGER, useCTUsedInEntities         INTEGER, useDTUsedInTables           INTEGER, useDTUsedInEntities         INTEGER, useCRImpactedObjects        INTEGER, useMRImpactedObjects        INTEGER)";
                st.execute(query);
                query = "CREATE OR REPLACE TYPE objects_list IS TABLE OF VARCHAR2(32767)";
                st.execute(query);
                SchemaFactory.loadPLSQLStoredProcedures(connection);
                bl = true;
                if (st == null) break block25;
            }
            catch (SQLException se) {
                boolean bl2;
                block26: {
                    try {
                        if (se.getMessage().indexOf("ORA-01031") > -1) {
                            LOGGER.error("SchemaFactory create : Error=" + se.getMessage());
                            MessageDialogs.showErrorMessage(Messages.getString("SchemaFactory.ErrUserPrivs"), true);
                        } else {
                            LOGGER.error("SchemaFactory create current query " + query);
                            LOGGER.error("SchemaFactory create", se);
                            MessageDialogs.showErrorMessage(Messages.getString("SchemaFactory.ErrMsgLogFile"), true);
                        }
                        bl2 = false;
                        if (st == null) break block26;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (st != null) {
                                st.close();
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.error("SchemaFactory create", e);
                            MessageDialogs.showErrorMessage(Messages.getString("SchemaFactory.ErrMsgLogFile"), true);
                            return false;
                        }
                    }
                    st.close();
                }
                return bl2;
            }
            st.close();
        }
        return bl;
    }

    public static List getTableNames() {
        return SchemaFactory.getTableNames(1.6f);
    }

    public static List getTableNames(float version) {
        ArrayList<String> list = new ArrayList<String>();
        if (version == 1.6f) {
            list.add("DMRS_Designs");
            list.add("DMRS_MODELS");
            list.add("DMRS_MODEL_SUBVIEWS");
            list.add("DMRS_MODEL_DISPLAYS");
            list.add("DMRS_AGGR_FUNC_DIMENSIONS");
            list.add("DMRS_AGGR_FUNC_LEVELS");
            list.add("DMRS_ATTRIBUTES");
            list.add("DMRS_AVT");
            list.add("DMRS_BUSINESS_INFO");
            list.add("DMRS_CHANGE_REQUESTS");
            list.add("DMRS_CHANGE_REQUEST_ELEMENTS");
            list.add("DMRS_CHECK_CONSTRAINTS");
            list.add("DMRS_CLASSIFICATION_TYPES");
            list.add("DMRS_ADDITIONAL_CT_OBJECTS");
            list.add("DMRS_COLLECTION_TYPES");
            list.add("DMRS_COLUMN_GROUPS");
            list.add("DMRS_Column_UI");
            list.add("DMRS_COLUMNS");
            list.add("DMRS_CONSTR_INDEX_COLUMNS");
            list.add("DMRS_CONSTR_FK_COLUMNS");
            list.add("DMRS_CONTACTS");
            list.add("DMRS_CONTACT_EMAILS");
            list.add("DMRS_CONTACT_LOCATIONS");
            list.add("DMRS_CONTACT_RES_LOCATORS");
            list.add("DMRS_CONTACT_TELEPHONES");
            list.add("DMRS_CUBES");
            list.add("DMRS_CUBE_DIMENSIONS");
            list.add("DMRS_DATA_FLOW_DIAGRAM_INFOS");
            list.add("DMRS_DIMENSIONS");
            list.add("DMRS_DIMENSION_CALC_ATTRS");
            list.add("DMRS_DIMENSION_LEVELS");
            list.add("DMRS_DOCUMENTS");
            list.add("DMRS_DOCUMENT_ELEMENTS");
            list.add("DMRS_DOMAINS");
            list.add("DMRS_DOMAIN_AVT");
            list.add("DMRS_DOMAIN_CHECK_CONSTRAINTS");
            list.add("DMRS_DOMAIN_VALUE_RANGES");
            list.add("DMRS_Diagram_Elements");
            list.add("DMRS_Diagrams");
            list.add("DMRS_DISTINCT_TYPES");
            list.add("DMRS_EMAILS");
            list.add("DMRS_ENTITIES");
            list.add("DMRS_ENTITYVIEWS");
            list.add("DMRS_EVENTS");
            list.add("DMRS_EXTERNAL_AGENTS");
            list.add("DMRS_EXT_AGENT_FLOWS");
            list.add("DMRS_EXT_AGENT_EXT_DATAS");
            list.add("DMRS_EXTERNAL_DATAS");
            list.add("DMRS_FACT_ENTITIES");
            list.add("DMRS_FACT_ENTITIES_JOINS");
            list.add("DMRS_FLOW_INFO_STRUCTURES");
            list.add("DMRS_FLOWS");
            list.add("DMRS_FOREIGNKEYS");
            list.add("DMRS_HIERARCHIES");
            list.add("DMRS_HIERARCHY_LEVELS");
            list.add("DMRS_HIERARCHY_ROLLUP_LINKS");
            list.add("DMRS_INDEXES");
            list.add("DMRS_INFO_STORES");
            list.add("DMRS_INFO_STRUCTURES");
            list.add("DMRS_INFO_STRUCT_ATTRS");
            list.add("DMRS_KEYS");
            list.add("DMRS_KEY_ATTRIBUTES");
            list.add("DMRS_KEY_Elements");
            list.add("DMRS_LEVELS");
            list.add("DMRS_LEVEL_ATTRS");
            list.add("DMRS_LOCATIONS");
            list.add("DMRS_LOGICAL_TO_NATIVE");
            list.add("DMRS_LOGICAL_TYPES");
            list.add("DMRS_MAPPINGS");
            list.add("DMRS_MAPPING_TARGETS");
            list.add("DMRS_MAPPING_TARGET_SOURCES");
            list.add("DMRS_MEASURES");
            list.add("DMRS_MEASURE_AGGR_FUNCS");
            list.add("DMRS_MEASURE_FOLDERS");
            list.add("DMRS_MEASURE_FOLDER_MEASURES");
            list.add("DMRS_NATIVE_TO_LOGICAL");
            list.add("DMRS_Notes");
            list.add("DMRS_PK_OID_COLUMNS");
            list.add("DMRS_PROCESS_ATTRIBUTES");
            list.add("DMRS_PROCESS_ENTITIES");
            list.add("DMRS_PROCESSES");
            list.add("DMRS_RAGGED_HIER_LINKS");
            list.add("DMRS_RAGGED_HIER_LINK_ATTRS");
            list.add("DMRS_RDBMS_SITES");
            list.add("DMRS_RECORD_STRUCTURES");
            list.add("DMRS_RECORD_STRUCT_EXT_DATAS");
            list.add("DMRS_RELATIONSHIPS");
            list.add("DMRS_RESOURCE_LOCATORS");
            list.add("DMRS_RESPONSIBLE_PARTIES");
            list.add("DMRS_RES_PARTY_CONTACTS");
            list.add("DMRS_RES_PARTY_ELEMENTS");
            list.add("DMRS_ROLES");
            list.add("DMRS_ROLE_PROCESSES");
            list.add("DMRS_ROLLUP_LINKS");
            list.add("DMRS_ROLLUP_LINK_ATTRS");
            list.add("DMRS_SLICES");
            list.add("DMRS_SLICE_DIM_HIER_LEVEL");
            list.add("DMRS_SLICE_MEASURES");
            list.add("DMRS_SOURCE_INFO");
            list.add("DMRS_SPATIAL_COLUMN_DEFINITION");
            list.add("DMRS_SPATIAL_DIMENSIONS");
            list.add("DMRS_STRUCTURED_TYPES");
            list.add("DMRS_STRUCT_TYPE_ATTRS");
            list.add("DMRS_STRUCT_TYPE_METHODS");
            list.add("DMRS_STRUCT_TYPE_METHOD_PARS");
            list.add("DMRS_TABLES");
            list.add("DMRS_TABLEVIEWS");
            list.add("DMRS_TABLE_CONSTRAINTS");
            list.add("DMRS_TABLE_INCLUDE_SCRIPTS");
            list.add("DMRS_TASK_PARAMS");
            list.add("DMRS_TASK_PARAMS_ITEMS");
            list.add("DMRS_TELEPHONES");
            list.add("DMRS_TRANSFORMATION_PACKAGES");
            list.add("DMRS_TRANSFORMATION_TASKS");
            list.add("DMRS_TRANSFORMATION_TASK_INFOS");
            list.add("DMRS_TRANSFORMATION_FLOWS");
            list.add("DMRS_TRANSFORMATIONS");
            list.add("DMRS_VALUE_RANGES");
            list.add("DMRS_VIEW_COLUMNS");
            list.add("DMRS_VIEW_CONTAINERS");
            list.add("DMRS_VIEW_ORDER_GROUPBY");
            list.add("DMRS_Large_Text");
            list.add("DMRS_Model_Naming_Options");
            list.add("DMRS_MEASUREMENTS");
            list.add("DMRS_SCHEMA_OBJECT");
            list.add("DMRS_DYNAMIC_PROPERTIES");
            list.add("DMRS_TABLE_ARCS");
            list.add("DMRS_ENTITY_ARCS");
            list.add("DMRS_SENSITIVE_TYPES");
            list.add("DMRS_TSDP_POLICIES");
            list.add("DMRS_TSDP_SUB_POLICIES");
            list.add("DMRS_MASK_TEMPLATES");
            list.add("DMRS_EXISTENCE_DEP");
            list.add("DMRS_EXISTENCE_DEP_COLUMNS");
            list.add("DMRS_FK_CD_CONSTRAINTS");
            list.add("DMRS_FK_CD_CONSTRAINTS_COLS");
        } else if (version == 1.5f) {
            list.add("DMRS_Designs");
            list.add("DMRS_MODELS");
            list.add("DMRS_MODEL_SUBVIEWS");
            list.add("DMRS_MODEL_DISPLAYS");
            list.add("DMRS_ATTRIBUTES");
            list.add("DMRS_AVT");
            list.add("DMRS_CHECK_CONSTRAINTS");
            list.add("DMRS_CLASSIFICATION_TYPES");
            list.add("DMRS_COLLECTION_TYPES");
            list.add("DMRS_COLUMNS");
            list.add("DMRS_CONSTR_INDEX_COLUMNS");
            list.add("DMRS_Column_UI");
            list.add("DMRS_DATA_FLOW_DIAGRAM_INFOS");
            list.add("DMRS_DOMAINS");
            list.add("DMRS_DOMAIN_AVT");
            list.add("DMRS_DOMAIN_CHECK_CONSTRAINTS");
            list.add("DMRS_DOMAIN_VALUE_RANGES");
            list.add("DMRS_Diagram_Elements");
            list.add("DMRS_Diagrams");
            list.add("DMRS_DISTINCT_TYPES");
            list.add("DMRS_ENTITIES");
            list.add("DMRS_ENTITYVIEWS");
            list.add("DMRS_EVENTS");
            list.add("DMRS_EXTERNAL_AGENTS");
            list.add("DMRS_EXT_AGENT_FLOWS");
            list.add("DMRS_EXT_AGENT_EXT_DATAS");
            list.add("DMRS_EXTERNAL_DATAS");
            list.add("DMRS_FLOW_INFO_STRUCTURES");
            list.add("DMRS_FLOWS");
            list.add("DMRS_FOREIGNKEYS");
            list.add("DMRS_INDEXES");
            list.add("DMRS_INFO_STORES");
            list.add("DMRS_INFO_STRUCTURES");
            list.add("DMRS_KEYS");
            list.add("DMRS_KEY_ATTRIBUTES");
            list.add("DMRS_KEY_Elements");
            list.add("DMRS_LOGICAL_TO_NATIVE");
            list.add("DMRS_LOGICAL_TYPES");
            list.add("DMRS_MAPPINGS");
            list.add("DMRS_NATIVE_TO_LOGICAL");
            list.add("DMRS_Notes");
            list.add("DMRS_PK_OID_COLUMNS");
            list.add("DMRS_PROCESS_ATTRIBUTES");
            list.add("DMRS_PROCESS_ENTITIES");
            list.add("DMRS_PROCESSES");
            list.add("DMRS_RDBMS_SITES");
            list.add("DMRS_RECORD_STRUCTURES");
            list.add("DMRS_RECORD_STRUCT_EXT_DATAS");
            list.add("DMRS_RELATIONSHIPS");
            list.add("DMRS_ROLES");
            list.add("DMRS_ROLE_PROCESSES");
            list.add("DMRS_SPATIAL_COLUMN_DEFINITION");
            list.add("DMRS_SPATIAL_DIMENSIONS");
            list.add("DMRS_STRUCTURED_TYPES");
            list.add("DMRS_STRUCT_TYPE_ATTRS");
            list.add("DMRS_STRUCT_TYPE_METHODS");
            list.add("DMRS_STRUCT_TYPE_METHOD_PARS");
            list.add("DMRS_TABLES");
            list.add("DMRS_COLUMN_GROUPS");
            list.add("DMRS_TABLEVIEWS");
            list.add("DMRS_TABLE_CONSTRAINTS");
            list.add("DMRS_TABLE_INCLUDE_SCRIPTS");
            list.add("DMRS_TASK_PARAMS");
            list.add("DMRS_TASK_PARAMS_ITEMS");
            list.add("DMRS_TRANSFORMATION_PACKAGES");
            list.add("DMRS_TRANSFORMATION_TASKS");
            list.add("DMRS_TRANSFORMATION_TASK_INFOS");
            list.add("DMRS_TRANSFORMATION_FLOWS");
            list.add("DMRS_TRANSFORMATIONS");
            list.add("DMRS_VALUE_RANGES");
            list.add("DMRS_VIEW_COLUMNS");
            list.add("DMRS_VIEW_CONTAINERS");
            list.add("DMRS_VIEW_ORDER_GROUPBY");
            list.add("DMRS_Large_Text");
            list.add("DMRS_Model_Naming_Options");
            list.add("DMRS_MEASUREMENTS");
            list.add("DMRS_SCHEMA_OBJECT");
        } else if (version == 0.1f) {
            list.add("DMRS_Designs");
            list.add("DMRS_MODELS");
            list.add("DMRS_ATTRIBUTES");
            list.add("DMRS_AVT");
            list.add("DMRS_CHECK_CONSTRAINTS");
            list.add("DMRS_CLASSIFICATION_TYPES");
            list.add("DMRS_COLUMNS");
            list.add("DMRS_CONSTR_INDEX_COLUMNS");
            list.add("DMRS_Column_UI");
            list.add("DMRS_DOMAINS");
            list.add("DMRS_DOMAIN_AVT");
            list.add("DMRS_DOMAIN_CHECK_CONSTRAINTS");
            list.add("DMRS_DOMAIN_VALUE_RANGES");
            list.add("DMRS_Diagram_Elements");
            list.add("DMRS_Diagrams");
            list.add("DMRS_ENTITIES");
            list.add("DMRS_ENTITYVIEWS");
            list.add("DMRS_FOREIGNKEYS");
            list.add("DMRS_INDEXES");
            list.add("DMRS_KEYS");
            list.add("DMRS_KEY_ATTRIBUTES");
            list.add("DMRS_KEY_Elements");
            list.add("DMRS_LOGICAL_TO_NATIVE");
            list.add("DMRS_LOGICAL_TYPES");
            list.add("DMRS_MAPPINGS");
            list.add("DMRS_NATIVE_TO_LOGICAL");
            list.add("DMRS_Notes");
            list.add("DMRS_PK_OID_COLUMNS");
            list.add("DMRS_PROCESS_ATTRIBUTES");
            list.add("DMRS_PROCESS_ENTITIES");
            list.add("DMRS_RDBMS_SITES");
            list.add("DMRS_RELATIONSHIPS");
            list.add("DMRS_SPATIAL_COLUMN_DEFINITION");
            list.add("DMRS_SPATIAL_DIMENSIONS");
            list.add("DMRS_TABLES");
            list.add("DMRS_COLUMN_GROUPS");
            list.add("DMRS_TABLEVIEWS");
            list.add("DMRS_TABLE_CONSTRAINTS");
            list.add("DMRS_TABLE_INCLUDE_SCRIPTS");
            list.add("DMRS_VALUE_RANGES");
            list.add("DMRS_Large_Text");
            list.add("DMRS_Model_Naming_Options");
        }
        return list;
    }

    public static List getViewNames() {
        return SchemaFactory.getViewNames(1.6f);
    }

    public static List getViewNames(float version) {
        ArrayList<String> list = new ArrayList<String>();
        String repver = String.valueOf(1.0f).replace('.', '_');
        if (version == 1.6f) {
            list.add("DMRV_REPORTS_VERSION_" + repver);
            list.add("DMRV_DESIGNS");
            list.add("DMRV_MODELS");
            list.add("DMRV_MODEL_SUBVIEWS");
            list.add("DMRV_MODEL_DISPLAYS");
            list.add("DMRV_AGGR_FUNC_DIMENSIONS");
            list.add("DMRV_AGGR_FUNC_LEVELS");
            list.add("DMRV_ATTRIBUTES");
            list.add("DMRV_AVT");
            list.add("DMRV_BUSINESS_INFO");
            list.add("DMRV_CHANGE_REQUESTS");
            list.add("DMRV_CHANGE_REQUEST_ELEMENTS");
            list.add("DMRV_CHECK_CONSTRAINTS");
            list.add("DMRV_CLASSIFICATION_TYPES");
            list.add("DMRV_COLLECTION_TYPES");
            list.add("DMRV_COLUMNS");
            list.add("DMRV_COLUMN_UI");
            list.add("DMRV_CONSTR_INDEX_COLUMNS");
            list.add("DMRV_CONSTR_FK_COLUMNS");
            list.add("DMRV_CONTACTS");
            list.add("DMRV_CONTACT_EMAILS");
            list.add("DMRV_CONTACT_LOCATIONS");
            list.add("DMRV_CONTACT_RES_LOCATORS");
            list.add("DMRV_CONTACT_TELEPHONES");
            list.add("DMRV_CUBES");
            list.add("DMRV_CUBE_DIMENSIONS");
            list.add("DMRV_DATA_FLOW_DIAGRAM_INFOS");
            list.add("DMRV_DOCUMENTS");
            list.add("DMRV_DOCUMENT_ELEMENTS");
            list.add("DMRV_DIMENSIONS");
            list.add("DMRV_DIMENSION_CALC_ATTRS");
            list.add("DMRV_DIMENSION_LEVELS");
            list.add("DMRV_DISTINCT_TYPES");
            list.add("DMRV_DOMAINS");
            list.add("DMRV_DOMAIN_AVT");
            list.add("DMRV_DOMAIN_CHECK_CONSTRAINTS");
            list.add("DMRV_DOMAIN_VALUE_RANGES");
            list.add("DMRV_DIAGRAM_ELEMENTS");
            list.add("DMRV_DIAGRAMS");
            list.add("DMRV_EMAILS");
            list.add("DMRV_ENTITIES");
            list.add("DMRV_ENTITYVIEWS");
            list.add("DMRV_EVENTS");
            list.add("DMRV_EXTERNAL_AGENTS");
            list.add("DMRV_EXT_AGENT_FLOWS");
            list.add("DMRV_EXT_AGENT_EXT_DATAS");
            list.add("DMRV_EXTERNAL_DATAS");
            list.add("DMRV_FACT_ENTITIES");
            list.add("DMRV_FACT_ENTITIES_JOINS");
            list.add("DMRV_FLOW_INFO_STRUCTURES");
            list.add("DMRV_FLOWS");
            list.add("DMRV_FOREIGNKEYS");
            list.add("DMRV_HIERARCHIES");
            list.add("DMRV_HIERARCHY_LEVELS");
            list.add("DMRV_HIERARCHY_ROLLUP_LINKS");
            list.add("DMRV_INDEXES");
            list.add("DMRV_INFO_STORES");
            list.add("DMRV_INFO_STRUCTURES");
            list.add("DMRV_INFO_STRUCT_ATTRS");
            list.add("DMRV_KEYS");
            list.add("DMRV_KEY_ATTRIBUTES");
            list.add("DMRV_KEY_ELEMENTS");
            list.add("DMRV_LEVELS");
            list.add("DMRV_LEVEL_ATTRS");
            list.add("DMRV_LOCATIONS");
            list.add("DMRV_LOGICAL_TO_NATIVE");
            list.add("DMRV_LOGICAL_TYPES");
            list.add("DMRV_MAPPINGS");
            list.add("DMRV_MAPPING_TARGETS");
            list.add("DMRV_MAPPING_TARGET_SOURCES");
            list.add("DMRV_MEASURES");
            list.add("DMRV_MEASURE_AGGR_FUNCS");
            list.add("DMRV_MEASURE_FOLDERS");
            list.add("DMRV_MEASURE_FOLDER_MEASURES");
            list.add("DMRV_NATIVE_TO_LOGICAL");
            list.add("DMRV_NOTES");
            list.add("DMRV_PK_OID_COLUMNS");
            list.add("DMRV_PROCESS_ATTRIBUTES");
            list.add("DMRV_PROCESS_ENTITIES");
            list.add("DMRV_PROCESSES");
            list.add("DMRV_RAGGED_HIER_LINKS");
            list.add("DMRV_RAGGED_HIER_LINK_ATTRS");
            list.add("DMRV_RDBMS_SITES");
            list.add("DMRV_RECORD_STRUCTURES");
            list.add("DMRV_RECORD_STRUCT_EXT_DATAS");
            list.add("DMRV_RELATIONSHIPS");
            list.add("DMRV_RESOURCE_LOCATORS");
            list.add("DMRV_RESPONSIBLE_PARTIES");
            list.add("DMRV_RES_PARTY_CONTACTS");
            list.add("DMRV_RES_PARTY_ELEMENTS");
            list.add("DMRV_ROLES");
            list.add("DMRV_ROLE_PROCESSES");
            list.add("DMRV_ROLLUP_LINKS");
            list.add("DMRV_ROLLUP_LINK_ATTRS");
            list.add("DMRV_SLICES");
            list.add("DMRV_SLICE_DIM_HIER_LEVEL");
            list.add("DMRV_SLICE_MEASURES");
            list.add("DMRV_SOURCE_INFO");
            list.add("DMRV_SPATIAL_COLUMN_DEFINITION");
            list.add("DMRV_SPATIAL_DIMENSIONS");
            list.add("DMRV_STRUCTURED_TYPES");
            list.add("DMRV_STRUCT_TYPE_ATTRS");
            list.add("DMRV_STRUCT_TYPE_METHODS");
            list.add("DMRV_STRUCT_TYPE_METHOD_PARS");
            list.add("DMRV_TABLES");
            list.add("DMRV_COLUMN_GROUPS");
            list.add("DMRV_TABLEVIEWS");
            list.add("DMRV_TABLE_CONSTRAINTS");
            list.add("DMRV_TABLE_INCLUDE_SCRIPTS");
            list.add("DMRV_TASK_PARAMS");
            list.add("DMRV_TASK_PARAMS_ITEMS");
            list.add("DMRV_TELEPHONES");
            list.add("DMRV_TRANSFORMATION_PACKAGES");
            list.add("DMRV_TRANSFORMATION_TASKS");
            list.add("DMRV_TRANSFORMATION_TASK_INFOS");
            list.add("DMRV_TRANSFORMATION_FLOWS");
            list.add("DMRV_TRANSFORMATIONS");
            list.add("DMRV_VALUE_RANGES");
            list.add("DMRV_VIEW_COLUMNS");
            list.add("DMRV_VIEW_CONTAINERS");
            list.add("DMRV_VIEW_ORDER_GROUPBY");
            list.add("DMRV_LARGE_TEXT");
            list.add("DMRV_MODEL_NAMING_OPTIONS");
        } else if (version == 1.5f) {
            list.add("DMRV_REPORTS_VERSION_" + repver);
            list.add("DMRV_DESIGNS");
            list.add("DMRV_MODELS");
            list.add("DMRV_MODEL_SUBVIEWS");
            list.add("DMRV_MODEL_DISPLAYS");
            list.add("DMRV_ATTRIBUTES");
            list.add("DMRV_AVT");
            list.add("DMRV_CHECK_CONSTRAINTS");
            list.add("DMRV_CLASSIFICATION_TYPES");
            list.add("DMRV_COLLECTION_TYPES");
            list.add("DMRV_COLUMNS");
            list.add("DMRV_CONSTR_INDEX_COLUMNS");
            list.add("DMRV_COLUMN_UI");
            list.add("DMRV_DATA_FLOW_DIAGRAM_INFOS");
            list.add("DMRV_DISTINCT_TYPES");
            list.add("DMRV_DOMAINS");
            list.add("DMRV_DOMAIN_AVT");
            list.add("DMRV_DOMAIN_CHECK_CONSTRAINTS");
            list.add("DMRV_DOMAIN_VALUE_RANGES");
            list.add("DMRV_DIAGRAM_ELEMENTS");
            list.add("DMRV_DIAGRAMS");
            list.add("DMRV_ENTITIES");
            list.add("DMRV_ENTITYVIEWS");
            list.add("DMRV_EVENTS");
            list.add("DMRV_EXTERNAL_AGENTS");
            list.add("DMRV_EXT_AGENT_FLOWS");
            list.add("DMRV_EXT_AGENT_EXT_DATAS");
            list.add("DMRV_EXTERNAL_DATAS");
            list.add("DMRV_FLOW_INFO_STRUCTURES");
            list.add("DMRV_FLOWS");
            list.add("DMRV_FOREIGNKEYS");
            list.add("DMRV_INDEXES");
            list.add("DMRV_INFO_STORES");
            list.add("DMRV_INFO_STRUCTURES");
            list.add("DMRV_KEYS");
            list.add("DMRV_KEY_ATTRIBUTES");
            list.add("DMRV_KEY_ELEMENTS");
            list.add("DMRV_LOGICAL_TO_NATIVE");
            list.add("DMRV_LOGICAL_TYPES");
            list.add("DMRV_MAPPINGS");
            list.add("DMRV_NATIVE_TO_LOGICAL");
            list.add("DMRV_NOTES");
            list.add("DMRV_PK_OID_COLUMNS");
            list.add("DMRV_PROCESS_ATTRIBUTES");
            list.add("DMRV_PROCESS_ENTITIES");
            list.add("DMRV_PROCESSES");
            list.add("DMRV_RDBMS_SITES");
            list.add("DMRV_RECORD_STRUCTURES");
            list.add("DMRV_RECORD_STRUCT_EXT_DATAS");
            list.add("DMRV_RELATIONSHIPS");
            list.add("DMRV_ROLES");
            list.add("DMRV_ROLE_PROCESSES");
            list.add("DMRV_SPATIAL_COLUMN_DEFINITION");
            list.add("DMRV_SPATIAL_DIMENSIONS");
            list.add("DMRV_STRUCTURED_TYPES");
            list.add("DMRV_STRUCT_TYPE_ATTRS");
            list.add("DMRV_STRUCT_TYPE_METHODS");
            list.add("DMRV_STRUCT_TYPE_METHOD_PARS");
            list.add("DMRV_TABLES");
            list.add("DMRV_COLUMN_GROUPS");
            list.add("DMRV_TABLEVIEWS");
            list.add("DMRV_TABLE_CONSTRAINTS");
            list.add("DMRV_TABLE_INCLUDE_SCRIPTS");
            list.add("DMRV_TASK_PARAMS");
            list.add("DMRV_TASK_PARAMS_ITEMS");
            list.add("DMRV_TRANSFORMATION_PACKAGES");
            list.add("DMRV_TRANSFORMATION_TASKS");
            list.add("DMRV_TRANSFORMATION_TASK_INFOS");
            list.add("DMRV_TRANSFORMATION_FLOWS");
            list.add("DMRV_TRANSFORMATIONS");
            list.add("DMRV_VALUE_RANGES");
            list.add("DMRV_VIEW_COLUMNS");
            list.add("DMRV_VIEW_CONTAINERS");
            list.add("DMRV_VIEW_ORDER_GROUPBY");
            list.add("DMRV_LARGE_TEXT");
            list.add("DMRV_MODEL_NAMING_OPTIONS");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createGlossary(Connection connection) throws Exception {
        boolean res = false;
        try (Statement st = connection.createStatement();){
            String query = "CREATE TABLE DMRS_GLOSSARIES (Glossary_ID VARCHAR2 (70) NOT NULL, Glossary_OVID VARCHAR2 (36) NOT NULL, Glossary_Name VARCHAR2 (256) NOT NULL, File_Name VARCHAR2 (256), Description VARCHAR2 (4000), Incomplete_Modifiers CHAR(1), Case_Sensitive CHAR(1), Unique_Abbrevs CHAR(1), Separator_Type VARCHAR2(10), Separator_Char CHAR(1), Date_Published TIMESTAMP NOT NULL, Published_By VARCHAR2 (80), Persistence_Version NUMBER (5,2) NOT NULL, Version_Comments VARCHAR2 (4000))";
            st.execute(query);
            query = "CREATE TABLE DMRS_GLOSSARY_TERMS (Term_ID VARCHAR2 (70) NOT NULL, Term_OVID VARCHAR2 (36) NOT NULL, Term_Name VARCHAR2 (256) NOT NULL, Short_Description VARCHAR2 (4000), Abbrev VARCHAR2 (256), Alt_Abbrev VARCHAR2 (256), Prime_Word CHAR (1), Class_Word CHAR (1), Modifier CHAR (1), Qualifier CHAR (1), Glossary_ID VARCHAR2 (70) NOT NULL, Glossary_OVID VARCHAR2 (36) NOT NULL, Glossary_Name VARCHAR2 (256) NOT NULL, Plural  VARCHAR2 (256))";
            st.execute(query);
            query = "CREATE VIEW DMRV_GLOSSARIES (Glossary_ID, Glossary_OVID, Glossary_Name, File_Name, Description, Incomplete_Modifiers, Case_Sensitive, Unique_Abbrevs, Separator_Type, Separator_Char, Date_Published, Published_By, Persistence_Version, Version_Comments) AS select  Glossary_ID, Glossary_OVID, Glossary_Name, File_Name, Description, Incomplete_Modifiers, Case_Sensitive, Unique_Abbrevs, Separator_Type, Separator_Char, Date_Published, Published_By, Persistence_Version, Version_Comments from DMRS_GLOSSARIES";
            st.execute(query);
            query = "CREATE VIEW DMRV_GLOSSARY_TERMS (Term_ID, Term_OVID, Term_Name, Short_Description, Abbrev, Alt_Abbrev, Prime_Word, Class_Word, Modifier, Qualifier, Glossary_ID, Glossary_OVID, Glossary_Name) AS select  Term_ID, Term_OVID, Term_Name, Short_Description, Abbrev, Alt_Abbrev, Prime_Word, Class_Word, Modifier, Qualifier, Glossary_ID, Glossary_OVID, Glossary_Name from DMRS_GLOSSARY_TERMS";
            st.execute(query);
            query = "CREATE VIEW DMRS_VDIAGRAMS (Diagram_Name, Object_Id, Ovid, Diagram_Type, Is_Display, Visible, Master_Diagram_Id, Master_Diagram_Ovid, Model_Id, Model_Ovid, Model_Name, Notation, Show_All_Details, Show_Names_Only, Show_Elements, Show_Datatype, Show_Keys, Autoroute, Box_In_Box, Diagram_Svg, Diagram_Pdf, Design_Ovid, Pdf_Name) As Select Diagram_Name, Object_Id, Ovid, Diagram_Type, Is_Display, Visible, Master_Diagram_Id, Master_Diagram_Ovid, Model_Id, Model_Ovid, Model_Name, Notation, Show_All_Details, Show_Names_Only, Show_Elements, Show_Datatype,Show_Keys, Autoroute, Box_In_Box, Diagram_Svg, Diagram_Pdf,  Design_Ovid, Diagram_Name||'.PDF' from DMRS_DIAGRAMS";
            st.execute(query);
            query = "CREATE INDEX GLOSSARY_TERMS_FK_IDX ON DMRS_GLOSSARY_TERMS (Glossary_OVID ASC)";
            st.execute(query);
            res = true;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadPLSQLStoredProcedures(Connection connection) throws Exception {
        boolean res = false;
        try (Statement st = connection.createStatement();){
            TreeMap<Integer, File> files = new TreeMap<Integer, File>();
            files.put(1, new File(ApplicationView.basePath, "reports/Pkg_Osdm_Utils.sql"));
            files.put(2, new File(ApplicationView.basePath, "reports/Pkg_Osdm_Utils_body.sql"));
            Set keys = files.keySet();
            for (Integer id : keys) {
                File currentFile = (File)files.get(id);
                if (!currentFile.exists()) {
                    LOGGER.error("File needed for reporting is missing :" + currentFile.getCanonicalPath());
                    break;
                }
                StringBuffer buffer = new StringBuffer();
                FileInputStream inputFileInputStream = new FileInputStream(currentFile);
                InputStreamReader inputInputStreamReader = new InputStreamReader(inputFileInputStream);
                BufferedReader inputBufferedReader = new BufferedReader(inputInputStreamReader);
                while (inputBufferedReader.ready()) {
                    buffer.append("\n").append(inputBufferedReader.readLine());
                }
                buffer = buffer.delete(buffer.length() - 1, buffer.length());
                st.executeUpdate(buffer.toString());
                inputBufferedReader.close();
                inputInputStreamReader.close();
                inputFileInputStream.close();
            }
        }
        return res;
    }

    public static boolean dropGlossary(Connection connection) {
        try {
            Statement st = connection.createStatement();
            String query = "";
            try {
                query = "DROP TABLE DMRS_GLOSSARIES CASCADE CONSTRAINTS";
                st.execute(query);
            }
            catch (SQLException e) {
                LOGGER.error("SchemaFactory.dropGlossary : Table=DMRS_GLOSSARIES : Error=" + e.getMessage());
            }
            try {
                query = "DROP TABLE DMRS_GLOSSARY_TERMS CASCADE CONSTRAINTS";
                st.execute(query);
            }
            catch (SQLException e) {
                LOGGER.error("SchemaFactory.dropGlossary : Table=DMRS_GLOSSARY_TERMS : Error=" + e.getMessage());
            }
            try {
                query = "DROP VIEW DMRV_GLOSSARIES";
                st.execute(query);
            }
            catch (SQLException e) {
                LOGGER.error("SchemaFactory.dropGlossary : View=DMRV_GLOSSARIES : Error=" + e.getMessage());
            }
            try {
                query = "DROP VIEW DMRV_GLOSSARY_TERMS";
                st.execute(query);
            }
            catch (SQLException e) {
                LOGGER.error("SchemaFactory.dropGlossary : View=DMRV_GLOSSARY_TERMS : Error=" + e.getMessage());
            }
            try {
                query = "DROP VIEW DMRS_VDIAGRAMS";
                st.execute(query);
            }
            catch (SQLException e) {
                LOGGER.error("SchemaFactory.dropVDiagrams : View=DMRS_VDIAGRAMS : Error=" + e.getMessage());
            }
            if (st != null) {
                st.close();
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("SchemaFactory dropGlossary", e);
            MessageDialogs.showErrorMessage(Messages.getString("SchemaFactory.ErrGlosssaryMsg"), true);
            return false;
        }
    }

    public static void dropRepository(Connection connection) {
        block21: {
            try {
                if (connection == null) break block21;
                connection.setAutoCommit(false);
                try {
                    PreparedStatement stmt;
                    String query;
                    PreparedStatement stmt2;
                    String query2;
                    float vers = SchemaFactory.schemaVersion(connection);
                    if (vers == 0.0f) {
                        MessageDialogs.showMessage(Messages.getString("SchemaFactory.RepositoryDoesNotExist"));
                        break block21;
                    }
                    for (String tbName : SchemaFactory.getTableNames(vers)) {
                        try {
                            query2 = "drop table " + tbName + " CASCADE CONSTRAINTS";
                            stmt2 = connection.prepareStatement(query2);
                            stmt2.execute();
                            stmt2.close();
                        }
                        catch (SQLException e) {
                            LOGGER.error("SchemaFactory.dropRepository : Table=" + tbName + " : Error=" + e.getMessage());
                        }
                    }
                    for (String vwName : SchemaFactory.getViewNames(vers)) {
                        try {
                            query2 = "drop view " + vwName;
                            stmt2 = connection.prepareStatement(query2);
                            stmt2.execute();
                            stmt2.close();
                        }
                        catch (SQLException e) {
                            LOGGER.error("SchemaFactory.dropRepository : View=" + vwName + " : Error=" + e.getMessage());
                        }
                    }
                    try {
                        query = "drop package pkg_osdm_utils";
                        stmt = connection.prepareStatement(query);
                        stmt.execute();
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("SchemaFactory.dropRepository : Package=pkg_osdm_utils : Error=" + e.getMessage());
                    }
                    try {
                        query = "drop type report_template";
                        stmt = connection.prepareStatement(query);
                        stmt.execute();
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("SchemaFactory.dropRepository : Type=report_template : Error=" + e.getMessage());
                    }
                    try {
                        query = "drop type objects_list";
                        stmt = connection.prepareStatement(query);
                        stmt.execute();
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("SchemaFactory.dropRepository : Type=objects_list : Error=" + e.getMessage());
                    }
                    SchemaFactory.dropGlossary(connection);
                    if (vers != 0.1f) {
                        try {
                            String view_query = "DROP VIEW DMRS_INSTALLATION";
                            PreparedStatement view_stmt = connection.prepareStatement(view_query);
                            view_stmt.execute();
                            view_stmt.close();
                        }
                        catch (SQLException e) {
                            LOGGER.error("SchemaFactory.dropRepository : View=DMRS_INSTALLATION : Error=" + e.getMessage());
                        }
                    }
                    connection.commit();
                    MessageDialogs.showMessage(Messages.getString("SchemaFactory.RepositoryDropped"));
                }
                catch (DifferentVersionException dve) {
                    MessageDialogs.showWarningMessage(Messages.getString("SchemaFactory.DBSchemaOutOfDate"));
                }
                catch (Exception e) {
                    connection.rollback();
                    LOGGER.error("SchemaFactory.dropRepository", e);
                    MessageDialogs.showErrorMessage(Messages.getString("SchemaFactory.UnableToDropRepository"), true);
                }
            }
            catch (Exception e) {
                LOGGER.error("SchemaFactory.dropRepository", e);
                MessageDialogs.showErrorMessage(Messages.getString("SchemaFactory.UnableToDropRepository"), true);
            }
        }
    }

    public static void enableIndexes(Connection connection) {
        if (connection != null) {
            try {
                float vers = SchemaFactory.schemaVersion(connection);
                if (vers == 0.0f) {
                    MessageDialogs.showMessage(Messages.getString("SchemaFactory.RepositoryDoesNotExist"));
                } else {
                    for (String idxName : SchemaFactory.getIndexNames()) {
                        try {
                            String query = "ALTER INDEX " + idxName + " REBUILD";
                            PreparedStatement stmt = connection.prepareStatement(query);
                            stmt.execute();
                            stmt.close();
                        }
                        catch (SQLException e) {
                            LOGGER.error("SchemaFactory.enableIndexes : Index=" + idxName + " : Error=" + e.getMessage());
                        }
                    }
                }
                MessageDialogs.showMessage(Messages.getString("SchemaFactory.IndexesRebuilded"));
            }
            catch (Exception e) {
                LOGGER.error("SchemaFactory.enableIndexes", e);
                MessageDialogs.showErrorMessage(Messages.getString("SchemaFactory.EnableIndexesErr"), true);
            }
        }
    }

    public static void disableIndexes(Connection connection) {
        if (connection != null) {
            try {
                float vers = SchemaFactory.schemaVersion(connection);
                if (vers == 0.0f) {
                    MessageDialogs.showMessage(Messages.getString("SchemaFactory.RepositoryDoesNotExist"));
                } else {
                    for (String idxName : SchemaFactory.getIndexNames()) {
                        try {
                            String query = "ALTER INDEX " + idxName + " UNUSABLE";
                            PreparedStatement stmt = connection.prepareStatement(query);
                            stmt.execute();
                            stmt.close();
                        }
                        catch (SQLException e) {
                            LOGGER.error("SchemaFactory.disableIndexes : Index=" + idxName + " : Error=" + e.getMessage());
                        }
                    }
                }
                MessageDialogs.showMessage(Messages.getString("SchemaFactory.IndexesDisabled"));
            }
            catch (Exception e) {
                LOGGER.error("SchemaFactory.enableIndexes", e);
                MessageDialogs.showErrorMessage(Messages.getString("SchemaFactory.DisableIndexesErr"), true);
            }
        }
    }

    public static List getIndexNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ATTRIBUTES_PK_IDX");
        list.add("BUSINESS_INFO_PK_IDX");
        list.add("CHANGE_REQUESTS_PK_IDX");
        list.add("CHANGE_REQ_ELEMENTS_FK1_IDX");
        list.add("CHANGE_REQ_ELEMENTS_FK2_IDX");
        list.add("CLASS_TYPES_PK_IDX");
        list.add("ADDITIONAL_CLASS_TYPES_PK_IDX");
        list.add("DMRS_COLL_TYPES_PK_IDX");
        list.add("COLUMNS_PK_IDX");
        list.add("COLUMNS_FK_IDX");
        list.add("COLUMN_GROUPS_FK_IDX");
        list.add("COLUMN_UI_FK_IDX");
        list.add("CONSTR_INDEX_COLUMNS_FK_IDX");
        list.add("CONTACTS_PK_IDX");
        list.add("CONTACT_EMAILS_FK1_IDX");
        list.add("CONTACT_LOCATIONS_FK1_IDX");
        list.add("CONTACT_RES_LOCATORS_FK1_IDX");
        list.add("CONTACT_TELEPHONES_FK1_IDX");
        list.add("CUBES_PK_IDX");
        list.add("CUBES_FK_IDX");
        list.add("CUBE_DIMENSIONS_FK1_IDX");
        list.add("CUBE_DIMENSIONS_FK2_IDX");
        list.add("DESIGNS_PK_IDX");
        list.add("DIAGRAMS_PK_IDX");
        list.add("DIAGRAMS_FK_IDX");
        list.add("DIAGRAM_ELEMENTS_PK_IDX");
        list.add("DIAGRAM_ELEMENTS_FK_IDX");
        list.add("DFD_INFOS_FK1_IDX");
        list.add("DFD_INFOS_FK2_IDX");
        list.add("DIMENSIONS_PK_IDX");
        list.add("DIMENSIONS_FK_IDX");
        list.add("DIMENSION_CALC_ATTRS_FK_IDX");
        list.add("DIMENSION_LEVELS_FK_IDX");
        list.add("DISTINCT_TYPES_PK_IDX");
        list.add("DOCUMENTS_PK_IDX");
        list.add("DOCUMENT_ELEMENTS_FK1_IDX");
        list.add("DOCUMENT_ELEMENTS_FK2_IDX");
        list.add("DOMAINS_PK_IDX");
        list.add("DOMAINS_PK1_IDX");
        list.add("DOMAINS_FK_IDXv1");
        list.add("DOMAIN_AVT_FK_IDX");
        list.add("DOMAIN_CHECK_CONSTR_FK_IDX");
        list.add("DOMAIN_VALUE_RANGES_FK_IDX");
        list.add("EMAILS_PK_IDX");
        list.add("ENTITIES_PK_IDX");
        list.add("ENTITIES_FK_IDX");
        list.add("ENTITIES_FK_IDXv1");
        list.add("ENTITYVIEWS_PK_IDX");
        list.add("ENTITYVIEWS_FK_IDX");
        list.add("EVENTS_PK_IDX");
        list.add("EVENTS_FK_MODEL_IDX");
        list.add("EVENTS_FK_FLOW_IDX");
        list.add("EXT_AGENTS_PK_IDX");
        list.add("EXT_AGENTS_FK_DIAGRAM_IDX");
        list.add("EXT_AGENT_EXT_DATAS_FK1_IDX");
        list.add("EXT_AGENT_EXT_DATAS_FK2_IDX");
        list.add("EXT_AGENT_FLOWS_FK1_IDX");
        list.add("EXT_AGENT_FLOWS_FK2_IDX");
        list.add("EXT_DATAS_PK_IDX");
        list.add("EXT_DATAS_FK_MODEL_IDX");
        list.add("FACT_ENTITIES_FK_IDX");
        list.add("FACT_ENTITIES_JOINS_FK_IDX");
        list.add("FLOWS_PK_IDX");
        list.add("FLOWS_FK_DIAGRAM_IDX");
        list.add("FLOW_INFO_STRUCTS_FK1_IDX");
        list.add("FLOW_INFO_STRUCTS_FK2_IDX");
        list.add("FOREIGNKEYS_PK_IDX");
        list.add("FOREIGNKEYS_FK_IDX");
        list.add("HIERARCHIES_PK_IDX");
        list.add("HIERARCHIES_FK_IDX");
        list.add("HIERARCHY_LEVELS_FK1_IDX");
        list.add("HIERARCHY_LEVELS_FK2_IDX");
        list.add("HIERARCHY_ROLLUP_LINKS_FK1_IDX");
        list.add("HIERARCHY_ROLLUP_LINKS_FK2_IDX");
        list.add("INDEXES_PK_IDX");
        list.add("INDEXES_FK_IDX");
        list.add("INFO_STORES_PK_IDX");
        list.add("INFO_STORES_FK_MODEL_IDX");
        list.add("INFO_STRUCTS_PK_IDX");
        list.add("INFO_STRUCTS_FK_MODEL_IDX");
        list.add("TASK_PARAMS_PK_IDX");
        list.add("TASK_PARAMS_FK_TASK_IDX");
        list.add("TASK_PARAMS_ITEMS_PK_IDX");
        list.add("TASK_PARAMS_ITEMS_FK_PARS_IDX");
        list.add("KEYS_PK_IDX");
        list.add("KEYS_FK_IDX");
        list.add("KEY_ATTRIBUTES_FK_IDX");
        list.add("KEY_ELEMENTS_FK_IDX");
        list.add("LEVELS_PK_IDX");
        list.add("LEVELS_FK_IDX");
        list.add("LEVEL_ATTRS_FK_IDX");
        list.add("LOCATIONS_PK_IDX");
        list.add("LOGICAL_TO_NATIVE_FK_IDXv1");
        list.add("LOGICAL_TYPES_PK_IDX");
        list.add("DMRS_LARGE_TEXT_PK_IDX");
        list.add("MAPPING_TARGETS_FK1_IDX");
        list.add("MAPPING_TARGETS_FK2_IDX");
        list.add("MAPPING_TARGET_SOURCES_FK1_IDX");
        list.add("MAPPING_TARGET_SOURCES_FK2_IDX");
        list.add("MAPPING_TARGET_SOURCES_FK3_IDX");
        list.add("MEASURES_PK_IDX");
        list.add("MEASURES_FK_IDX");
        list.add("MEASURE_AGGR_FUNCS_FK_IDX");
        list.add("AGGR_FUNC_DIMENSIONS_FK_IDX");
        list.add("AGGR_FUNC_LEVELS_FK_IDX");
        list.add("MEASURE_FOLDERS_PK_IDX");
        list.add("MEASURE_FOLDERS_FK_IDX");
        list.add("MEASURE_FOLDER_MEAS_FK_IDX");
        list.add("MODELS_PK_IDX");
        list.add("MODEL_SUBVIEWS_PK_IDX");
        list.add("MODEL_SUBVIEWS_FK_IDX");
        list.add("MODEL_DISPLAYS_PK_IDX");
        list.add("MODEL_DISPLAYS_FK_IDX");
        list.add("MODEL_NAMING_OPTIONS_FK_IDX");
        list.add("NATIVE_TO_LOGICAL_FK_IDXv1");
        list.add("NOTES_PK_IDX");
        list.add("NOTES_FK_IDX");
        list.add("PK_OID_COLUMNS_PK_IDX");
        list.add("PK_OID_COLUMNS_FK_IDX");
        list.add("PROCESS_ATTRS_PK_IDX");
        list.add("PROCESS_ENTS_PK_IDX");
        list.add("PROCESSES_PK_IDX");
        list.add("PROCESSES_FK_DIAGRAM_IDX");
        list.add("RAGGED_HIER_LINKS_PK_IDX");
        list.add("RAGGED_HIER_LINKS_FK_IDX");
        list.add("RAGGED_HIER_LINK_ATTRS_FK_IDX");
        list.add("RDBMS_SITES_PK_IDX");
        list.add("RECORD_STRUCTS_PK_IDX");
        list.add("RECORD_STRUCTS_FK_MODEL_IDX");
        list.add("REC_STRUCT_EXT_DATAS_FK1_IDX");
        list.add("REC_STRUCT_EXT_DATAS_FK2_IDX");
        list.add("RELATIONSHIPS_PK_IDX");
        list.add("RELATIONSHIPS_FK_IDX");
        list.add("RELATIONSHIPS_FK_IDXv1");
        list.add("RELATIONSHIPS_FK_IDXv2");
        list.add("RESOURCE_LOCATORS_PK_IDX");
        list.add("RESPONSIBLE_PARTIES_PK_IDX");
        list.add("RES_PARTY_CONTACTS_FK1_IDX");
        list.add("RES_PARTY_CONTACTS_FK2_IDX");
        list.add("RES_PARTY_ELEMENTS_FK1_IDX");
        list.add("RES_PARTY_ELEMENTS_FK2_IDX");
        list.add("ROLES_PK_IDX");
        list.add("ROLES_FK_MODEL_IDX");
        list.add("ROLE_PROCESSES_FK1_IDX");
        list.add("ROLE_PROCESSES_FK2_IDX");
        list.add("ROLLUP_LINKS_PK_IDX");
        list.add("ROLLUP_LINKS_FK_IDX");
        list.add("ROLLUP_LINK_ATTRS_FK_IDX");
        list.add("SLICES_PK_IDX");
        list.add("SLICES_FK_IDX");
        list.add("SLICE_DIM_HIER_LEVEL_FK_IDX");
        list.add("SLICE_MEASURES_FK_IDX");
        list.add("SPATIAL_COL_DEFINITION_PK_IDX");
        list.add("SPATIAL_COL_DEFINITION_FK_IDX");
        list.add("SPATIAL_DIMENSIONS_FK_IDX");
        list.add("STRUCTURED_TYPES_PK_IDX");
        list.add("STRUCT_TYPE_ATTRS_FK_IDX");
        list.add("STRUCT_TYPE_METHODS_FK_IDX");
        list.add("STRUCT_TYPE_METHOD_PARS_FK_IDX");
        list.add("TABLES_PK_IDX");
        list.add("TABLES_FK_IDX");
        list.add("TABLES_FK_IDXv1");
        list.add("TABLEVIEWS_PK_IDX");
        list.add("TABLEVIEWS_FK_IDX");
        list.add("TABLE_CONSTRAINTS_FK_IDX");
        list.add("TABLE_INCLUDE_SCRIPTS_FK_IDX");
        list.add("TELEPHONES_PK_IDX");
        list.add("TRANSFORM_PACKS_PK_IDX");
        list.add("TRANSFORM_PACKS_FK_MODEL_IDX");
        list.add("TRANSFORM_TASKS_PK_IDX");
        list.add("TRANSFORM_TASKS_FK_PACK_IDX");
        list.add("TRANSFORM_TASK_INFOS_FK1_IDX");
        list.add("TRANSFORM_TASK_INFOS_FK2_IDX");
        list.add("TRANSFORM_FLOWS_PK_IDX");
        list.add("TRANSFORM_FLOWS_FK_TASK_IDX");
        list.add("TRANSFORMS_PK_IDX");
        list.add("TRANSFORMS_FK_TASK_IDX");
        list.add("VIEW_COLUMNS_FK_IDX");
        list.add("VIEW_CONTAINERS_FK_IDX");
        list.add("VIEW_ORDER_GROUPBY_FK_IDX");
        list.add("ATTRIBUTES_CONTAINER_OVID_IDX");
        list.add("MAPPINGS_REL_OBJ_OVID_IDX");
        list.add("MAPPINGS_LOG_OBJ_OVID_IDX");
        list.add("VL_DATAELEMENT_OVID_IDX");
        list.add("AVT_DATAELEMENT_OVID_IDX");
        list.add("CC_DATAELEMENT_OVID_DX");
        list.add("PROCESS_ENTS_ENT_IDX");
        list.add("TABLES_NAME_IDX");
        list.add("MODELS_NAME_IDX");
        list.add("GLOSSARIES_OVID_IDX");
        list.add("DESIGNS__IDX");
        list.add("DIAGRAMS_NAME_IDX");
        list.add("DIAGRAM_ELEMENTS_NAME_IDX");
        list.add("TABLE_ARC_NAME_IDX");
        list.add("ENTITY_ARC_NAME_IDX");
        list.add("SENSITIVE_TYPE_NAME_IDX");
        list.add("TSDP_POLICY_NAME_IDX");
        list.add("TSDP_SP_POLICY_NAME_IDX");
        list.add("MASK_TEMPLATE_NAME_IDX");
        list.add("EXISTENCE_DEP_NAME_IDX");
        list.add("EXISTENCE_DEP_COL_NAME_IDX");
        list.add("FK_CD_CONSTR_NAME_IDX");
        list.add("FK_CD_CONSTR_COL_NAME_IDX");
        return list;
    }
}

