/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.crest.fcp.Icons;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.ide.model.Node;

public class DMDiagramNode
extends Node {
    private Component comp;

    public DMDiagramNode(URL url, Component comp) {
        super(url);
        this.comp = comp;
    }

    public Icon getIcon() {
        return Icons.getDiagramIcon();
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public String getShortLabel() {
        String name = null;
        String designName = null;
        if (this.comp instanceof DesignPartView) {
            name = ((DesignPartView)this.comp).getName();
            designName = ((DesignPartView)this.comp).getDesign().getName();
        } else if (this.comp instanceof DesignPartView.NamedTabbedPane) {
            name = ((DesignPartView.NamedTabbedPane)this.comp).getName();
            try {
                designName = ((DesignPartView.NamedTabbedPane)this.comp).getDesignPartView().getDesign().getName();
            }
            catch (Exception e) {
                name = null;
            }
        }
        if (name != null) {
            return name + " (" + designName + ")";
        }
        return Messages.getString("DataModelingNode.DataModelingS");
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public Component getComponent() {
        return this.comp;
    }

    public void clearInstances() {
        if (this.comp == null || this.comp instanceof DesignPartView || this.comp instanceof DesignPartView.NamedTabbedPane) {
            // empty if block
        }
        this.comp = null;
    }
}

