/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DDLComparisonPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class DDLComparisonPP
extends AbstractPP {
    private static final long serialVersionUID = 6172138404481530709L;
    private JCheckBox cbIncludePhysicalProperties;
    private JCheckBox cbIncludeStorageProperties;
    private JCheckBox cbUseDataTypeKind;
    private JCheckBox cbCaseSensitiveNames;
    private JCheckBox cbUseSchemaProperty;
    private JCheckBox cbUseColumnsOrderProperty;
    private JCheckBox cbIncludeSystemNames;

    public DDLComparisonPP() {
        this.setHelpID("DDL_COMPARISON_PREFS_PANEL");
        JPanel pnInner = new JPanel(new GridBagLayout());
        pnInner.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DDLComparisonOptions")));
        JPanel pnTop = new JPanel(new GridBagLayout());
        this.cbIncludePhysicalProperties = new JCheckBox(Messages.getString("OptionsDialog.IncludePhysicalPropertiesInCompare"));
        this.addItem(pnTop, this.cbIncludePhysicalProperties, 0, 0, 1, 1, 17, 1, 100);
        this.cbIncludeStorageProperties = new JCheckBox(Messages.getString("OptionsDialog.IncludeStoragePropertiesInCompare"));
        this.addItem(pnTop, this.cbIncludeStorageProperties, 0, 1, 1, 1, 17, 1, 100);
        this.cbCaseSensitiveNames = new JCheckBox(Messages.getString("OptionsDialog.CaseSensitiveNames"));
        this.addItem(pnTop, this.cbCaseSensitiveNames, 0, 2, 1, 1, 17, 1, 100);
        this.cbIncludeSystemNames = new JCheckBox(Messages.getString("OptionsDialog.IncludeSystemNamesInCompare"));
        this.addItem(pnTop, this.cbIncludeSystemNames, 0, 3, 1, 1, 17, 1, 100);
        this.cbUseDataTypeKind = new JCheckBox(Messages.getString("OptionsDialog.UseDataTypeKindProperty"));
        this.addItem(pnTop, this.cbUseDataTypeKind, 0, 4, 1, 1, 17, 1, 100);
        this.cbUseSchemaProperty = new JCheckBox(Messages.getString("OptionsDialog.UseSchemaProperty"));
        this.addItem(pnTop, this.cbUseSchemaProperty, 0, 5, 1, 1, 17, 1, 100);
        this.cbUseColumnsOrderProperty = new JCheckBox(Messages.getString("OptionsDialog.UseColumnsOrderProperty"));
        this.addItem(pnTop, this.cbUseColumnsOrderProperty, 0, 6, 1, 1, 17, 1, 100);
        pnInner.add((Component)pnTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(pnInner, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext tc) {
        this.cbIncludePhysicalProperties.setSelected(settings.isIncludePhysicalPropertiesInCompare());
        this.cbIncludeStorageProperties.setSelected(settings.isIncludeStoragePropertiesInCompare());
        this.cbUseDataTypeKind.setSelected(settings.isUseDataTypeKindInCompare());
        this.cbUseSchemaProperty.setSelected(settings.isUseSchemaPropertyInCompare());
        this.cbUseColumnsOrderProperty.setSelected(settings.isUseColumnsOrderPropertyInCompare());
        this.cbCaseSensitiveNames.setSelected(settings.isCaseSensitiveNamesInCompare());
        this.cbIncludeSystemNames.setSelected(settings.isIncludeSystemNamesInCompare());
    }

    public void onExit(TraversableContext tc) {
        settings.setIncludePhysicalPropertiesInCompare(this.cbIncludePhysicalProperties.isSelected());
        settings.setIncludeStoragePropertiesInCompare(this.cbIncludeStorageProperties.isSelected());
        settings.setUseDataTypeKindInCompare(this.cbUseDataTypeKind.isSelected());
        settings.setUseSchemaPropertyInCompare(this.cbUseSchemaProperty.isSelected());
        settings.setUseColumnsOrderPropertyInCompare(this.cbUseColumnsOrderProperty.isSelected());
        settings.setCaseSensitiveNamesInCompare(this.cbCaseSensitiveNames.isSelected());
        settings.setIncludeSystemNamesInCompare(this.cbIncludeSystemNames.isSelected());
        DDLComparisonPreferences preferences = this.getDDLComparisonPreferences(tc);
        preferences.setIncludePhysicalProperties(this.cbIncludePhysicalProperties.isSelected());
        preferences.setIncludeStorageProperties(this.cbIncludeStorageProperties.isSelected());
        preferences.setUseDataTypeKind(this.cbUseDataTypeKind.isSelected());
        preferences.setUseSchemaProperty(this.cbUseSchemaProperty.isSelected());
        preferences.setUseColumnsOrderProperty(this.cbUseColumnsOrderProperty.isSelected());
        preferences.setCaseSensitiveNames(this.cbCaseSensitiveNames.isSelected());
        preferences.setIncludeSystemNames(this.cbIncludeSystemNames.isSelected());
    }

    private DDLComparisonPreferences getDDLComparisonPreferences(TraversableContext tc) {
        return DDLComparisonPreferences.getInstance(tc.getPropertyStorage());
    }
}

