/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.startpage;

import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.crest.fcp.preferences.ModelingPreferences;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ControllerApplication;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.startpage.IStartPageProvider;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.PropertyStorage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class DataModelerStartPageProvider
implements IStartPageProvider {
    private static final Logger LOGGER = new Logger(DataModelerStartPageProvider.class);
    private ApplicationView appView = ApplicationView.getInstance();

    public String getCurrentVersionUrl() {
        return "http://www.oracle.com/ocom/groups/public/@otn/documents/webcontent/4414489.xml";
    }

    public MetaResource getStartPageMetaResource() {
        return new MetaResource(DataModelerStartPageProvider.class.getClassLoader(), "/oracle/dbtools/crest/fcp/startpage/StartPage.html");
    }

    public String getVersionId() {
        return "sqldeveloperCurrentVersion";
    }

    public void postProcess(Document doc) {
        ((EventTarget)((Object)doc.getElementById("selectDir"))).addEventListener("click", ev -> this.selectDesignsDir(doc, ev), false);
        this.setDesignsDir(doc, this.appView.getSettings().getDefaultDesignsPath());
        this.appendRecentList(doc);
    }

    private void appendRecentList(Document doc) {
        Element recentTab = doc.getElementById("recentTab");
        Element recentPane = doc.getElementById("recent");
        Element recentList = doc.getElementById("recentList");
        Element designsDirTab = doc.getElementById("designsDirTab");
        Element designDir = doc.getElementById("designDir");
        List list = this.appView.getSettings().getRecentDesigns();
        for (int i = list.size() - 1; i >= 0; --i) {
            ControllerApplication.Recent recent = (ControllerApplication.Recent)list.get(i);
            Element anchor = doc.createElement("a");
            anchor.setAttribute("href", "#");
            anchor.setAttribute("designName", recent.getDesignName());
            anchor.setAttribute("designPath", recent.getDesignPath());
            ((EventTarget)((Object)anchor)).addEventListener("click", ev -> this.openRecent(ev), false);
            anchor.setTextContent(Connections.getDisplayName((String)recent.getDesignName()));
            recentList.appendChild(anchor);
        }
        if (list.isEmpty()) {
            recentTab.setAttribute("class", "nav-link disabled");
            recentPane.setAttribute("class", "tab-pane container");
            designsDirTab.setAttribute("class", "nav-link active");
            designDir.setAttribute("class", "tab-pane active container");
        } else {
            designsDirTab.setAttribute("class", "nav-link");
            designDir.setAttribute("class", "tab-pane container");
            recentTab.setAttribute("class", "nav-link active");
            recentPane.setAttribute("class", "tab-pane active container");
        }
    }

    private void openRecent(Event ev) {
        ev.preventDefault();
        try {
            Element el = (Element)((Object)ev.getTarget());
            String designName = el.getAttribute("designName");
            String designPath = el.getAttribute("designPath");
            SwingUtilities.invokeLater(() -> {
                try {
                    MDBAction recent = this.appView.getSettings().getRecent(designName, designPath);
                    if (recent != null) {
                        recent.actionPerformed(null);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unable to open recent design: " + designName, e);
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error("Unable to open recent design.", t);
        }
    }

    private void selectDesignsDir(Document doc, Event ev) {
        ev.preventDefault();
        SwingUtilities.invokeLater(() -> {
            try {
                File file;
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)this.appView.getSettings().getDefaultDesignsPath()));
                fileChooser.setPathContext("dataModeler_OpenDesign");
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    Platform.runLater(() -> {
                        try {
                            this.setDesignsDir(doc, file.getAbsolutePath());
                            this.appView.getSettings().setDefaultDesignsPath(file.getAbsolutePath());
                            ModelingPreferences mp = ModelingPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
                            mp.setDefaultDesignsPath(file.getAbsolutePath());
                        }
                        catch (Throwable t) {
                            LOGGER.error(this.getClass(), t);
                        }
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to select default designs directory.", e);
            }
        });
    }

    private void setDesignsDir(Document doc, String dir) {
        if (dir != null && dir.length() > 0) {
            Element designsDirField = doc.getElementById("designsDirField");
            if (designsDirField != null) {
                designsDirField.setAttribute("value", dir);
            }
            this.appendDesignsList(doc, dir);
        }
    }

    private void appendDesignsList(Document doc, String dir) {
        File[] matches;
        Node child;
        Element designList = doc.getElementById("designList");
        while ((child = designList.getFirstChild()) != null) {
            designList.removeChild(child);
        }
        File folder = new File(dir);
        for (File file : matches = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String name) {
                return name.toLowerCase().endsWith(".dmd") || name.toLowerCase().endsWith(".dmdz") || name.toLowerCase().endsWith(".xml");
            }
        })) {
            String designName = file.getName().substring(0, file.getName().lastIndexOf(46));
            String designPath = dir;
            String designExt = file.getName().substring(file.getName().lastIndexOf(46));
            File designDir = new File(designPath, designName);
            if (!designDir.exists()) continue;
            Element anchor = doc.createElement("a");
            anchor.setAttribute("href", "#");
            anchor.setAttribute("designName", designName);
            anchor.setAttribute("designPath", designPath);
            anchor.setAttribute("designExt", designExt);
            ((EventTarget)((Object)anchor)).addEventListener("click", ev -> this.openDesign(ev), false);
            anchor.setTextContent(Connections.getDisplayName((String)designName));
            designList.appendChild(anchor);
        }
    }

    private void openDesign(Event ev) {
        ev.preventDefault();
        try {
            Element el = (Element)((Object)ev.getTarget());
            String designName = el.getAttribute("designName");
            String designPath = el.getAttribute("designPath");
            String designExt = el.getAttribute("designExt");
            SwingUtilities.invokeLater(() -> {
                try {
                    this.appView.getController().openDesign(designName, designPath, designExt);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to open design: " + designName, e);
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error("Unable to open design.", t);
        }
    }
}

