/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.UpdateableAction;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareFrame;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNAbstractCompareCommand;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.compare.CompareOptions;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNResloveUpdateConflict
extends UpdateableAction {
    public static int RESOLVE_CONFLICT = 1;
    public static int RESOLVE_CONFLICT_AS_TEXT = 2;
    public static int RESOLVE_TREE_CONFLICT = 3;
    public static String RESOLVE_CONFLICT_NAME = "Resolve Conflict";
    public static String RESOLVE_CONFLICT_AS_TEXT_NAME = "Resolve Conflict As Text";
    public static String RESOLVE_TREE_CONFLICT_NAME = "Resolve Tree Conflict";
    protected DataModelerChangeList chList;
    private int mode = RESOLVE_CONFLICT;

    public static SVNResloveUpdateConflict getResolveAction(DataModelerChangeList chList, int mode) {
        if (RESOLVE_CONFLICT == mode) {
            return new SVNResloveUpdateConflict(chList, RESOLVE_CONFLICT_NAME, mode);
        }
        if (RESOLVE_TREE_CONFLICT == mode) {
            return new SVNResloveUpdateConflict(chList, RESOLVE_TREE_CONFLICT_NAME, mode);
        }
        return new SVNResloveUpdateConflict(chList, RESOLVE_CONFLICT_AS_TEXT_NAME, mode);
    }

    public SVNResloveUpdateConflict(DataModelerChangeList chList, String itemName, int mode) {
        super(itemName);
        this.chList = chList;
        this.mode = mode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StorableObjectStatus status;
        final VersioningTreeNode node = this.chList.getPanel().getSelectedNode();
        if (node != null && "C".equals((status = node.getStorableObjectStatus()).getTextStatus()) && status instanceof SVNStorableObjectStatus) {
            final SVNStatus svnst = ((SVNStorableObjectStatus)status).getSVNStatus();
            if (svnst.getConflictNewFile() == null && svnst.getTreeConflict() == null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("SVNResolveUpdateConflict.UpdateWorkingCopy"), Messages.getString("SVNResolveUpdateConflict.ResolveConflict"), 2);
                return;
            }
            if (this.mode == RESOLVE_TREE_CONFLICT) {
                DataModelerAddin.getVCSClientHelper().doResolved(svnst.getFile());
                this.chList.refresh();
            } else {
                Object obj = this.chList.getScopeComboBox().getSelectedItem();
                if (obj instanceof Design) {
                    Design design = status.getDesign();
                    FileInputStream leftFile = null;
                    try {
                        leftFile = new FileInputStream(svnst.getConflictNewFile());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    FileInputStream rightFile = null;
                    try {
                        rightFile = new FileInputStream(svnst.getConflictWrkFile());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    if (leftFile != null && rightFile != null) {
                        if (this.mode == RESOLVE_CONFLICT) {
                            XMLMetadataComparator comparator = new XMLMetadataComparator(design, null, leftFile, "Repository - " + svnst.getCommittedRevision(), rightFile, "WC local", true);
                            Map mergedMap = comparator.showModal();
                            if (mergedMap != null) {
                                try {
                                    leftFile.close();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                try {
                                    rightFile.close();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                XMLFromMapTransformer.transformMapToXMLFile(mergedMap, svnst.getFile().getPath(), design.isCompressedDesign());
                                DataModelerAddin.getVCSClientHelper().doResolved(svnst.getFile());
                                this.updateDesignMergeConflictsList(design, svnst.getFile());
                                SVNAbstractCompareCommand.reloadIfSystemFile(node);
                                ArrayList<VersioningTreeNode> nodes = new ArrayList<VersioningTreeNode>();
                                nodes.add(node);
                                VersioningTreeNode.refresh(nodes, false);
                                SVNChangeListWindow.getSVNOutgoingChangesChangeList().refresh();
                            }
                        } else if (this.mode == RESOLVE_CONFLICT_AS_TEXT) {
                            CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences()).setShowCharDifferences(true);
                            VCSTextCompareFrame textCompareFrame = new VCSTextCompareFrame((Window)Ide.getMainWindow(), svnst.getFile(), leftFile, "Repository - " + svnst.getCommittedRevision(), rightFile, "WC local", true, false, status){

                                @Override
                                public void afterSave() {
                                    super.afterSave();
                                    DataModelerAddin.getVCSClientHelper().doResolved(svnst.getFile());
                                    SVNResloveUpdateConflict.this.updateDesignMergeConflictsList(status.getDesign(), svnst.getFile());
                                    SVNAbstractCompareCommand.reloadIfSystemFile(node);
                                    ArrayList<VersioningTreeNode> nodes = new ArrayList<VersioningTreeNode>();
                                    nodes.add(node);
                                    VersioningTreeNode.refresh(nodes, false);
                                    SVNChangeListWindow.getSVNOutgoingChangesChangeList().refresh();
                                }
                            };
                            textCompareFrame.showModal();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void update() {
        StorableObjectStatus status;
        VersioningTreeNode node = this.chList.getPanel().getSelectedNode();
        boolean enable = false;
        if (node != null && (status = node.getStorableObjectStatus()) != null) {
            SVNStatus svnst = null;
            if (status instanceof SVNStorableObjectStatus) {
                svnst = ((SVNStorableObjectStatus)status).getSVNStatus();
            }
            if ("C".equals(status.getTextStatus())) {
                if (svnst != null && svnst.getTreeConflict() == null && svnst.getConflictNewFile() == null) {
                    enable = false;
                } else {
                    enable = true;
                    boolean missing = false;
                    if (svnst.getTreeConflict() != null && (svnst.getTreeConflict().getConflictReason().getName().equalsIgnoreCase(SVNStatusType.MISSING.toString()) || svnst.getTreeConflict().getConflictReason().getName().equalsIgnoreCase(SVNStatusType.STATUS_DELETED.toString()) || svnst.getTreeConflict().getConflictAction().getName().equalsIgnoreCase(SVNStatusType.STATUS_DELETED.toString()))) {
                        missing = true;
                    }
                    if (this.mode != RESOLVE_TREE_CONFLICT && (missing || status.getFilePath().isDirectory())) {
                        enable = false;
                    } else if (this.mode == RESOLVE_TREE_CONFLICT) {
                        enable = missing;
                    }
                }
            } else if (this.mode == RESOLVE_TREE_CONFLICT && svnst.getTreeConflict() != null) {
                enable = true;
            }
        }
        this.setEnabled(enable);
    }

    private void updateDesignMergeConflictsList(Design design, File conflictedFile) {
        List<MergeConflict> allMergeConflicts = design.getDesignLevelSettings().getMergeConflicts();
        for (int i = 0; i < allMergeConflicts.size(); ++i) {
            MergeConflict mergeConflict = allMergeConflicts.get(i);
            if (!mergeConflict.getLocalFile().getAbsolutePath().equalsIgnoreCase(conflictedFile.getAbsolutePath())) continue;
            allMergeConflicts.remove(mergeConflict);
            break;
        }
    }
}

