/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.db2.SHColumnElements;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;

public class DomainHandlerReadDDL
implements StatementsConstants,
SectionConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;
    private LogicalDatatypeFactory factoryLogical;

    public DomainHandlerReadDDL(Design design) {
        this.design = design;
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    public void createDomains(LinkedList statements) {
        for (String statement : statements) {
            int positionCreate = statement.toLowerCase().indexOf("create table ");
            if (positionCreate == -1) continue;
            ArrayList columns = this.getColumns(statement);
            for (String oneColumn : columns) {
                this.createOneDomain(oneColumn);
            }
        }
    }

    private ArrayList getColumns(String statement) {
        ArrayList<String> tableColumns = new ArrayList<String>();
        String columnStatement = Token.getValBetweenBrackets(statement, 1);
        int positionOfConstraint = columnStatement.indexOf("CONSTRAINT");
        if (positionOfConstraint > -1) {
            if ((columnStatement = columnStatement.substring(0, positionOfConstraint).trim()).endsWith(",")) {
                columnStatement = columnStatement.substring(0, columnStatement.length() - 1).trim();
            }
        } else {
            int positionOfPK = columnStatement.indexOf("PRIMARY");
            if (positionOfPK != -1) {
                String finalCharOfStatement;
                String part = columnStatement.substring(positionOfPK);
                int positionOfBracket = (part = Token.cutTokenFromFront(part, "PRIMARY KEY")).indexOf("(");
                if (positionOfBracket == 0 && (finalCharOfStatement = (columnStatement = columnStatement.substring(0, positionOfPK).trim()).substring(columnStatement.length() - 1)).equals(",")) {
                    int positionKomma = columnStatement.length() - 1;
                    columnStatement = columnStatement.substring(0, positionKomma);
                }
            } else {
                int positionOfUnique = columnStatement.indexOf("UNIQUE");
                if (positionOfUnique != -1) {
                    String finalCharOfStatement;
                    String part = columnStatement.substring(positionOfUnique);
                    int positionOfBracket = (part = Token.cutTokenFromFront(part, "UNIQUE")).indexOf("(");
                    if (positionOfBracket == 0 && (finalCharOfStatement = (columnStatement = columnStatement.substring(0, positionOfUnique).trim()).substring(columnStatement.length() - 1)).equals(",")) {
                        int positionKomma = columnStatement.length() - 1;
                        columnStatement = columnStatement.substring(0, positionKomma);
                    }
                }
            }
        }
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracketNoClose(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracketNoClose(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString();
                }
            }
            tableColumns.add(oneColumn.trim());
        }
        return tableColumns;
    }

    private void createOneDomain(String statement) {
        SHColumnElements columnElements = new SHColumnElements();
        Map elements = columnElements.getElementsColumn(statement);
        String datatype = (String)elements.get("datatype");
        String[] parameters = new String[]{(String)elements.get("precision"), (String)elements.get("scale"), (String)elements.get("size")};
        if (datatype != null) {
            String nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(datatype);
            LogicalDatatype logicalDT = this.factoryLogical.searchLogicalDatatype(this.design, nameLogDT);
            this.factory.getInstance(this.design, logicalDT, null, 2, parameters, null);
        }
    }
}

