/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexOraclev9i
extends DDLStatementHandler {
    private Index index;
    private Table table;
    private ClusterIndexOracle clusterIndex;
    private BitmapJoinIndexOracle bitmapIndex;
    private String indexName = "";
    private boolean indexNameNeedsQuotes;
    private StorageDesignOracle stoDesign;
    private String userName;
    private IndexProxyOracle indexProxy = null;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateIndexOraclev9i.class);

    public SHCreateIndexOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateIndexOraclev9i.clearCR(line);
        if (Token.startsWithString(statement, "CREATE INDEX") || Token.startsWithString(statement, "CREATE UNIQUE INDEX") || Token.startsWithString(statement, "CREATE BITMAP INDEX")) {
            try {
                this.failed = false;
                this.index = null;
                this.createIndex(statement);
                RDBMSSite site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
                ArrayList<String> colNames = new ArrayList<String>();
                if (this.index != null) {
                    for (Column column : this.index.getElementsCollection()) {
                        colNames.add(column.getName());
                    }
                    Index idx = this.getUniqueIndexForColumnNames(this.table, colNames);
                    if (idx != null) {
                        PKProxyOracle pkProxy = (PKProxyOracle)this.stoDesign.getPKProxySet().getObjectGeneratedBy(idx);
                        if (pkProxy != null) {
                            pkProxy.setUsingIndex("BY INDEX NAME");
                            pkProxy.setExistingIndex(this.indexProxy);
                        } else {
                            UniqueOracle uk = (UniqueOracle)this.stoDesign.getUniqueSet().getObjectGeneratedBy(idx);
                            if (uk != null) {
                                uk.setUsingIndex("BY INDEX NAME");
                                uk.setExistingIndex(this.indexProxy);
                            }
                        }
                    }
                }
                if (this.failed) {
                    this.importLog.addFailedStatement(SHCreateIndexOraclev9i.FormatCR(line, "\n"));
                } else {
                    this.importLog.incrementImportedStatements();
                }
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateIndexOraclev9i.FormatCR(line, "\n"));
            }
            this.index = null;
            this.table = null;
            this.clusterIndex = null;
            this.bitmapIndex = null;
            this.indexName = "";
            this.stoDesign = null;
            this.userName = null;
            this.indexProxy = null;
        } else {
            this.nextHandler(line);
        }
    }

    private void createIndex(String statement) {
        try {
            this.statement = statement;
            this.indexName = this.initIndexName();
            if (this.isClusterIndex()) {
                this.createClusterIndex();
            } else if (this.isBitmapJoinIndex()) {
                this.createBitmapJoinIndex();
            } else {
                this.createTableIndex();
            }
        }
        catch (ObjectDoesNotExistException e) {
            StringBuffer message = new StringBuffer(e.getMessage());
            message.append(" in SHCreateIndex.createIndex");
            LOGGER.error(message.toString());
            this.importLog.addError("Creating index for statement " + statement + " for Oracle failed");
            this.failed = true;
        }
    }

    private boolean isClusterIndex() {
        return "CLUSTER".equalsIgnoreCase(Token.getTokenAfter(this.statement, "ON").trim());
    }

    private boolean isBitmapJoinIndex() {
        return this.statement.toLowerCase().indexOf("create bitmap index") > -1 && Token.hasToken(this.statement, "WHERE") && Token.hasToken(this.statement, "FROM");
    }

    private void createClusterIndex() {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (this.stoDesign != null) {
            this.clusterIndex = this.stoDesign.getClusterIndexSet().createClusterIndex();
            this.clusterIndex.setName(this.initIndexName());
            this.clusterIndex.setNameHasQuotes(this.indexNameNeedsQuotes);
            this.design.getRelationalDesign().stampModelObjectDDL(this.clusterIndex);
            UserOracle user = this.initUser();
            this.clusterIndex.setUser(user);
            this.clusterIndex.setCluster(this.getCluster());
            this.initAttributes(null, this.clusterIndex, this.statement);
        }
    }

    private void createBitmapJoinIndex() throws ObjectDoesNotExistException {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (this.stoDesign != null) {
            this.bitmapIndex = this.stoDesign.getBitmapJoinIndexSet().createBitmapJoinIndex();
            this.bitmapIndex.setName(this.initIndexName());
            this.bitmapIndex.setNameHasQuotes(this.indexNameNeedsQuotes);
            this.design.getRelationalDesign().stampModelObjectDDL(this.bitmapIndex);
            UserOracle user = this.initUser();
            this.bitmapIndex.setUser(user);
            this.initBaseTable(this.bitmapIndex);
            this.initDimensionTables(this.bitmapIndex);
            this.initIndexColumns(this.bitmapIndex);
            this.initJoinColumns(this.bitmapIndex);
            String afterPartitioning = this.initBitmapPartitioning();
            this.initAttributesBitmap(this.bitmapIndex, afterPartitioning);
        }
    }

    private void createTableIndex() throws ObjectDoesNotExistException {
        this.constructIndex();
        if (this.index != null) {
            this.initUnique();
            this.setColumnForIndex();
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            this.stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
            if (this.stoDesign != null) {
                this.indexProxy = (IndexProxyOracle)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID());
                if (this.indexProxy != null) {
                    UserOracle user = this.initUser();
                    if (user != null) {
                        String userName = user.getName();
                        SchemaObjectSet schemaSet = ((RelationalDesign)this.index.getDesignPart()).getSchemaObjectSet();
                        SchemaObject so = (SchemaObject)schemaSet.getByName(userName);
                        if (so == null && !userName.trim().equalsIgnoreCase("")) {
                            so = schemaSet.createSchemaObject(null);
                            so.setName(userName);
                            this.design.getRelationalDesign().stampModelObjectDDL(so);
                        }
                        if (user.getSchemaObject() == null) {
                            user.setSchemaObject(so);
                        }
                        if (user.getSchemaObject() != so) {
                            this.indexProxy.setUser(user);
                        }
                        this.index.setSchemaObject(so);
                    }
                    this.initBitmapIndex();
                    this.initIndextype();
                    this.statement = Token.getValAfterBrackets(this.statement, 1).trim();
                    String afterPartitioning = this.initPartitioned();
                    this.initAttributes(this.indexProxy, null, afterPartitioning);
                }
            }
        }
    }

    private String initIndexName() {
        String startOfName = Token.getStringAfterToken(this.statement, "INDEX");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
            this.userName = Token.getValBeforeCharacter(name, '.');
            name = Token.getValAfterCharacter(name, '.');
        }
        this.indexNameNeedsQuotes = startOfName.startsWith("\"") && !name.equals(name.toUpperCase());
        return name;
    }

    private UserOracle initUser() {
        if (this.userName != null) {
            UserOracle user = (UserOracle)this.stoDesign.getUserSet().getByName(this.userName);
            if (user == null) {
                user = this.stoDesign.getUserSet().createUser();
                user.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
            }
            return user;
        }
        return null;
    }

    private void initBaseTable(BitmapJoinIndexOracle bitmapIndex) throws ObjectDoesNotExistException {
        TableProxyOracle table;
        String tableName = Token.getQuotedNameAfterToken(this.statement, "ON");
        String user = null;
        int posPoint = tableName.lastIndexOf(46);
        if (posPoint > -1) {
            user = tableName.substring(0, posPoint).trim();
            tableName = tableName.substring(posPoint + 1).trim();
        }
        if ((table = ((TableProxySetOracle)this.stoDesign.getTableProxySet()).getByLongName(tableName, user)) == null) {
            this.importLog.addError("Reference table " + tableName + " does not exist");
            throw new ObjectDoesNotExistException("Table");
        }
        bitmapIndex.setTable(table);
    }

    private void initIndexColumns(BitmapJoinIndexOracle bitmapIndex) {
        String columns = Token.getStringAfterToken(this.statement, "ON");
        columns = Token.getValBetweenBrackets(columns);
        StringTokenizer tokenizer = new StringTokenizer(columns, ",");
        while (tokenizer.hasMoreTokens()) {
            ColumnProxyOracle column;
            String col = tokenizer.nextToken();
            String ascDesc = "ASC";
            String lastToken = Token.getLastToken(col);
            if (lastToken.equalsIgnoreCase("ASC")) {
                col = Token.getStringBeforeToken(col, "ASC");
            } else if (lastToken.equalsIgnoreCase("DESC")) {
                col = Token.getStringBeforeToken(col, "DESC");
                ascDesc = "DESC";
            }
            if ((column = this.getColumnProxy(col, bitmapIndex)) == null) continue;
            bitmapIndex.setIndexColumns(column.getObjectID());
            bitmapIndex.setIndexColumns(ascDesc);
        }
    }

    private ColumnProxyOracle getColumnProxy(String col, BitmapJoinIndexOracle bitmapIndex) {
        int dotIndex = (col = Token.getFirstName(col, '\"', '\"')).lastIndexOf(46);
        if (dotIndex > -1) {
            ColumnProxyOracle column;
            TableProxyOracle table;
            String name = col.substring(dotIndex + 1);
            String tbName = col.substring(0, dotIndex);
            String user = null;
            dotIndex = tbName.lastIndexOf(46);
            if (dotIndex > -1) {
                user = tbName.substring(0, dotIndex).trim();
                tbName = tbName.substring(dotIndex + 1);
            }
            if ((table = ((TableProxySetOracle)this.stoDesign.getTableProxySet()).getByLongName(tbName.trim(), user)) != null && (column = (ColumnProxyOracle)table.getColumnProxyByName(name.trim())) != null) {
                return column;
            }
        } else {
            ColumnProxyOracle column;
            String colName = col.trim();
            BitmapJoinIndexOracle.InlineList dimensionKeys = bitmapIndex.getDimensionKeySet();
            for (int i = 0; i < dimensionKeys.size(); i += 2) {
                ColumnProxyOracle column2;
                String dimTableId = (String)dimensionKeys.get(i);
                TableProxyOracle dimTable = (TableProxyOracle)this.stoDesign.getTableProxySet().getProxy(dimTableId);
                if (dimTable == null || (column2 = (ColumnProxyOracle)dimTable.getColumnProxyByName(colName)) == null) continue;
                return column2;
            }
            TableProxyOracle baseTable = bitmapIndex.getTable();
            if (baseTable != null && (column = (ColumnProxyOracle)baseTable.getColumnProxyByName(colName)) != null) {
                return column;
            }
        }
        return null;
    }

    private void initDimensionTables(BitmapJoinIndexOracle bitmapIndex) {
        String tables = Token.getStringAfterToken(this.statement, "FROM");
        tables = Token.getStringBeforeToken(tables, "WHERE");
        StringTokenizer tokenizer = new StringTokenizer(tables, ",");
        while (tokenizer.hasMoreTokens()) {
            String t = tokenizer.nextToken();
            String user = null;
            int dotIndex = t.lastIndexOf(46);
            if (dotIndex > -1) {
                user = t.substring(0, dotIndex).trim();
                t = t.substring(dotIndex + 1);
            }
            t = t.trim();
            TableProxyOracle table = ((TableProxySetOracle)this.stoDesign.getTableProxySet()).getByLongName(t, user);
            if (table == null || table.equals(bitmapIndex.getTable())) continue;
            bitmapIndex.setDimensionKeys(table.getObjectID());
            bitmapIndex.setDimensionKeys("");
        }
    }

    private void initJoinColumns(BitmapJoinIndexOracle bitmapIndex) {
        String joinColumns = Token.getStringAfterToken(this.statement, "WHERE");
        int index = joinColumns.lastIndexOf(61);
        String last = joinColumns.substring(index + 1).trim();
        last = Token.getFirstToken(last);
        joinColumns = joinColumns.substring(0, index + 1).trim() + ' ' + last;
        String[] tokenizer = joinColumns.split(" AND ");
        for (int i = 0; i < tokenizer.length; ++i) {
            String token = tokenizer[i];
            int eqIndex = token.indexOf(61);
            if (eqIndex <= -1) continue;
            String col1 = token.substring(0, eqIndex).trim();
            String col2 = token.substring(eqIndex + 1).trim();
            ColumnProxyOracle column1 = this.getColumnProxy(col1, bitmapIndex);
            ColumnProxyOracle column2 = this.getColumnProxy(col2, bitmapIndex);
            if (column1 == null || column2 == null) continue;
            if (column1.getTableProxy().getObjectID().equals(bitmapIndex.getTable().getObjectID())) {
                bitmapIndex.setJoinColumns(column2.getObjectID());
                bitmapIndex.setJoinColumns(column1.getObjectID());
                continue;
            }
            bitmapIndex.setJoinColumns(column1.getObjectID());
            bitmapIndex.setJoinColumns(column2.getObjectID());
        }
    }

    private void constructIndex() throws ObjectDoesNotExistException {
        int dotIndex;
        String tableName = Token.getQuotedNameAfterToken(this.statement, "ON");
        int bracketIndex = tableName.indexOf(40);
        if (bracketIndex > -1) {
            tableName = tableName.substring(0, bracketIndex).trim();
        }
        if ((dotIndex = tableName.indexOf(46)) > -1) {
            String userName = tableName.substring(0, dotIndex);
            tableName = tableName.substring(dotIndex + 1);
            this.table = SHAlterTableOraclev10g.getTableFor(userName, tableName, this.design);
        } else if (this.table == null) {
            this.table = SHAlterTableOraclev10g.getTableFor("", tableName, this.design);
        }
        if (this.table != null) {
            Index[] indexes = (Index[])this.table.getKeys();
            for (int i = 0; i < indexes.length; ++i) {
                Index ind = indexes[i];
                if (!ind.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = ind;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.index.setNameHasQuotes(this.indexNameNeedsQuotes);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        } else {
            this.importLog.addError("Reference table " + tableName + " does not exist");
            throw new ObjectDoesNotExistException("Table");
        }
    }

    private void initUnique() {
        String type;
        if (!this.index.isPK() && (type = Token.getTokenAfter(this.statement, "CREATE").trim()).equalsIgnoreCase("UNIQUE")) {
            this.index.setIndexState("Unique Plain Index");
        }
    }

    private void initBitmapIndex() {
        String type = Token.getTokenAfter(this.statement, "CREATE");
        this.indexProxy.setBitmapIndex(type.equalsIgnoreCase("BITMAP"));
    }

    private void initIndextype() {
        int indexOfIndextypeIs = this.statement.toUpperCase().indexOf(" INDEXTYPE IS ");
        if (indexOfIndextypeIs > -1) {
            String afterIndextypeIs = this.statement.substring(indexOfIndextypeIs + 14);
            this.indexProxy.setIndexType(Token.getFirstName(afterIndextypeIs, '\"', '\"'));
            String afterParameters = Token.getStringAfterToken(afterIndextypeIs, "PARAMETERS");
            this.indexProxy.setIndexDomainParameters(Token.getValBetweenQuotes(afterParameters));
        }
    }

    private void setColumnForIndex() throws ObjectDoesNotExistException {
        String columnString = Token.getValBetweenBrackets(this.statement, 1).trim();
        boolean functionString = Token.hasCloseAndOpenBrackets(columnString);
        if (functionString) {
            this.index.setIndexExpression(columnString);
            return;
        }
        Map columnCollection = this.getColumnsForTable();
        StringTokenizer columnToken = new StringTokenizer(columnString, ",");
        while (columnToken.hasMoreTokens()) {
            Column columnTable;
            String columnName = columnToken.nextToken().trim();
            String sortOrder = "ASC";
            if (Token.getLastToken(columnName).equalsIgnoreCase("ASC") || Token.getLastToken(columnName).equalsIgnoreCase("DESC")) {
                if (Token.getLastToken(columnName).equalsIgnoreCase("DESC")) {
                    sortOrder = "DESC";
                }
                columnName = columnName.substring(0, columnName.lastIndexOf(32));
            }
            if (columnName.trim().startsWith("\"")) {
                columnName = Token.removeQuotes(columnName);
            }
            if ((columnTable = (Column)columnCollection.get(columnName)) == null) {
                columnTable = (Column)columnCollection.get(columnName.toUpperCase());
            }
            if (columnTable != null) {
                this.index.add(columnTable);
                this.index.setColumnSortOrder(columnTable, sortOrder);
                continue;
            }
            this.index.removeAll();
            this.index.setIndexExpression(columnString);
        }
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> collectionColumns = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columns = (Column[])this.table.getElementsAndNestedElements();
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].getName();
                collectionColumns.put(columnName, columns[i]);
                collectionColumns.put(columnName.toUpperCase(), columns[i]);
            }
        }
        return collectionColumns;
    }

    private ClusterOracle getCluster() {
        String name = Token.getQuotedNameAfterToken(this.statement, "CLUSTER");
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            name = Token.getValAfterCharacter(name, '.');
        }
        if (!"".equalsIgnoreCase(name)) {
            return (ClusterOracle)this.stoDesign.getClusterSet().getByName(name);
        }
        return null;
    }

    private String initPartitioned() {
        String textAfterPartitioning = this.statement;
        if (Token.hasToken(this.statement, "GLOBAL")) {
            String line = Token.getStringAfter(this.statement, "PARTITION BY");
            String globalPartitionType = Token.getFirstToken(line);
            String partColumns = Token.getValBetweenBrackets(line, 1).trim();
            line = Token.getValAfterBrackets(line, 1);
            if (globalPartitionType.equalsIgnoreCase("RANGE")) {
                if (this.indexProxy instanceof IndexProxyOraclev9i) {
                    this.indexProxy.setIndexPartitioned("GLOBAL");
                } else {
                    this.indexProxy.setIndexPartitioned("GLOBAL BY RANGE");
                }
            } else if (globalPartitionType.equalsIgnoreCase("HASH") && this.indexProxy instanceof IndexProxyOraclev10g) {
                if (Token.getFirstToken(line).equalsIgnoreCase("PARTITIONS")) {
                    this.indexProxy.setIndexPartitioned("GLOBAL HASH PARTITIONED BY QUANTITY");
                } else {
                    this.indexProxy.setIndexPartitioned("GLOBAL HASH PARTITIONED BY LIST");
                }
            }
            IndexGlobalPartitionsListOracle globalPartitionList = this.stoDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
            this.design.getRelationalDesign().stampModelObjectDDL(globalPartitionList);
            this.indexProxy.setIndexGlobalPartitionsList(globalPartitionList);
            globalPartitionList.setIndex(this.indexProxy);
            globalPartitionList.setGlobalPartColumns(globalPartitionList.columnNamesToColumnIDs(partColumns));
            if (this.indexProxy.getIndexPartitioned().equals("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                TableSpaceOracle ts;
                String tsName;
                StringTokenizer tokenizer;
                IndexGlobalPartitionsListOraclev10g globalPartitionList10g = (IndexGlobalPartitionsListOraclev10g)globalPartitionList;
                line = Token.cutTokenFromFront(line, "PARTITIONS");
                String quantityToken = Token.getFirstToken(line);
                line = Token.cutTokenFromFront(line, quantityToken);
                try {
                    int quantity = Integer.parseInt(quantityToken);
                    globalPartitionList10g.setHashPQuantity(quantity);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong format in SHCreateIndexOraclev9i.initPartitioned : " + e.getMessage());
                    this.importLog.addWarning("Wrong PARTITIONS format in statement " + this.statement);
                }
                if (Token.startsWithString(line, "STORE IN")) {
                    String tableSpaces = Token.getValBetweenBrackets(line, 1);
                    line = Token.getValAfterBrackets(line, 1);
                    tokenizer = new StringTokenizer(tableSpaces, ",");
                    while (tokenizer.hasMoreTokens()) {
                        tsName = Token.getName(tokenizer.nextToken().trim());
                        ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
                        if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                            ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                            ts.setName(tsName);
                            this.design.getRelationalDesign().stampModelObjectDDL(ts);
                        }
                        if (ts == null) continue;
                        globalPartitionList10g.setHashPTableSpaces(ts.getObjectID());
                    }
                }
                if (Token.hasToken(line, "OVERFLOW") && Token.startsWithString(line = Token.getStringAfterToken(line, "OVERFLOW"), "STORE IN")) {
                    String tableSpaces = Token.getValBetweenBrackets(line, 1);
                    line = Token.getValAfterBrackets(line, 1);
                    tokenizer = new StringTokenizer(tableSpaces, ",");
                    while (tokenizer.hasMoreTokens()) {
                        tsName = Token.getName(tokenizer.nextToken().trim());
                        ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
                        if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                            ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                            ts.setName(tsName);
                            this.design.getRelationalDesign().stampModelObjectDDL(ts);
                        }
                        if (ts == null) continue;
                        globalPartitionList10g.setIOTOverflowHashPTSSet(ts.getObjectID());
                    }
                }
                textAfterPartitioning = line;
            } else {
                String partitions = Token.getValBetweenBrackets(line, 1).trim();
                textAfterPartitioning = Token.getValAfterBrackets(line, 1);
                StringTokenizer st = new StringTokenizer(partitions, ",");
                int pos = 0;
                while (st.hasMoreTokens()) {
                    TableSpaceOracle ts;
                    String tsName;
                    AbstractStorageObjectOracle partition;
                    ++pos;
                    String aPartition = st.nextToken();
                    while (Token.hasOpenBracket(aPartition) && st.hasMoreTokens()) {
                        aPartition = aPartition + ", " + st.nextToken();
                    }
                    String partName = Token.getQuotedNameAfterToken(aPartition, "PARTITION");
                    if (this.indexProxy.getIndexPartitioned().equals("GLOBAL HASH PARTITIONED BY LIST")) {
                        partition = ((StorageDesignOraclev10g)this.stoDesign).getIndexHashPartitionSet().createIndexHashPartition();
                        if (!(partName.equalsIgnoreCase("TABLESPACE") || partName.equalsIgnoreCase("OVERFLOW") || partName.equalsIgnoreCase("COMPRESS") || partName.equalsIgnoreCase("NOCOMPRESS") || partName.equalsIgnoreCase("LOB") || partName.equalsIgnoreCase("VARRAY"))) {
                            partition.setName(partName);
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(partition);
                        ((IndexHashPartitionOracle)partition).setIndexGlobalPartList(globalPartitionList);
                        this.indexProxy.getGlobalPartitions().add(partition);
                        String temp = aPartition;
                        while (Token.hasToken(temp, "TABLESPACE")) {
                            if (Token.hasOpenBracketNoClose(Token.getStringBeforeToken(temp, "TABLESPACE"))) {
                                temp = Token.getValAfterBrackets(temp, 1);
                                continue;
                            }
                            tsName = Token.getQuotedNameAfterToken(temp, "TABLESPACE");
                            if (!tsName.equals("")) {
                                ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
                                if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                    ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                                    ts.setName(tsName);
                                    this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                }
                                if (ts != null) {
                                    if (Token.getTokenBefore(temp, "TABLESPACE").equalsIgnoreCase("OVERFLOW")) {
                                        ((IndexHashPartitionOracle)partition).setOverflowTableSpace(ts);
                                    } else {
                                        ((IndexHashPartitionOracle)partition).setTableSpace(ts);
                                    }
                                }
                            }
                            temp = Token.getStringAfterToken(temp, "TABLESPACE");
                        }
                        continue;
                    }
                    partition = this.stoDesign.getIndexGlobalPartitionSet().createIndexGlobalPartition();
                    if (!partName.equalsIgnoreCase("VALUES")) {
                        partition.setName(partName);
                    }
                    this.design.getRelationalDesign().stampModelObjectDDL(partition);
                    ((IndexGlobalPartitionOracle)partition).setIndexGlobalPartList(globalPartitionList);
                    this.indexProxy.getGlobalPartitions().add(partition);
                    ((IndexGlobalPartitionOracle)partition).setPosition(pos);
                    aPartition = Token.getStringAfter(aPartition, "LESS THAN").trim();
                    String values = Token.getValBetweenBrackets(aPartition, 1).trim();
                    ((IndexGlobalPartitionOracle)partition).setValueList(values);
                    this.initPartSegment(aPartition, (IndexGlobalPartitionOracle)partition);
                    if (Token.hasToken(aPartition, "TABLESPACE")) {
                        tsName = Token.getQuotedNameAfterToken(aPartition, "TABLESPACE");
                        ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
                        if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                            ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                            ts.setName(tsName);
                            this.design.getRelationalDesign().stampModelObjectDDL(ts);
                        }
                        if (ts != null) {
                            ((IndexGlobalPartitionOracle)partition).setTableSpace(ts);
                        }
                    }
                    if (Token.hasToken(aPartition, "LOGGING")) {
                        ((IndexGlobalPartitionOracle)partition).setLogging("YES");
                        continue;
                    }
                    if (Token.hasToken(aPartition, "NOLOGGING")) {
                        ((IndexGlobalPartitionOracle)partition).setLogging("NO");
                        continue;
                    }
                    ((IndexGlobalPartitionOracle)partition).setLogging("");
                }
            }
        } else {
            if (Token.hasToken(this.statement, "LOCAL")) {
                this.indexProxy.setIndexPartitioned("LOCAL");
                return this.initLocalPartitioning(Token.getStringAfterToken(this.statement, "LOCAL"));
            }
            this.indexProxy.setIndexPartitioned("NON_PARTITIONED");
        }
        return textAfterPartitioning;
    }

    private String initLocalPartitioning(String partitioning) {
        String textAfterPartitioning;
        block15: {
            String partName;
            String token;
            StringTokenizer st;
            String partType;
            TableProxyOracle tableProxy;
            block16: {
                textAfterPartitioning = partitioning;
                tableProxy = (TableProxyOracle)this.stoDesign.getTableProxySet().getProxy(this.table.getObjectID());
                if (tableProxy == null || !tableProxy.getPartitioned().equalsIgnoreCase("YES")) break block15;
                partType = tableProxy.getPartitionList().getPartitionType();
                String subpartType = tableProxy.getPartitionList().getSubpartitionType();
                if (Token.startsWithString(partitioning, "STORE IN")) {
                    if (partType.equalsIgnoreCase("HASH BY QUANTITY") || partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || subpartType.equalsIgnoreCase("HASH")) {
                        String tablespaces = Token.getValBetweenBrackets(partitioning, 1);
                        StringTokenizer tokenizer = new StringTokenizer(tablespaces);
                        while (tokenizer.hasMoreTokens()) {
                            String tsName = Token.getName(tokenizer.nextToken());
                            TableSpaceOracle ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null) continue;
                            this.indexProxy.setHashSubPartitionsTableSpaces(ts.getObjectID());
                        }
                    }
                    textAfterPartitioning = partitioning = Token.getValAfterBrackets(partitioning, 1);
                }
                if (!partType.equalsIgnoreCase("RANGE") && !partType.equalsIgnoreCase("LIST") && !partType.equalsIgnoreCase("COMPOSITE BY HASH") && !partType.equalsIgnoreCase("COMPOSITE BY LIST")) break block16;
                if (!Token.hasToken(partitioning, "PARTITION")) break block15;
                textAfterPartitioning = Token.getValAfterBrackets(partitioning, 1);
                partitioning = Token.getValBetweenBrackets(partitioning, 1);
                st = new StringTokenizer(partitioning, ",");
                int pos = 0;
                while (st.hasMoreTokens()) {
                    StorageObjectCollection tablePartitions;
                    ++pos;
                    token = st.nextToken();
                    while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                        token = token + ", " + st.nextToken();
                    }
                    partName = Token.getQuotedNameAfterToken(token, "PARTITION").trim();
                    if ("".equalsIgnoreCase(partName) || pos > (tablePartitions = tableProxy.getPartitions()).size()) continue;
                    AbstractStorageObjectOracle partition = (AbstractStorageObjectOracle)tablePartitions.getElement(pos - 1);
                    this.initPartitionAttr(token, this.indexProxy, partition, partName, subpartType);
                }
                break block15;
            }
            if (partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") && Token.hasToken(partitioning, "PARTITION")) {
                textAfterPartitioning = Token.getValAfterBrackets(partitioning, 1);
                partitioning = Token.getValBetweenBrackets(partitioning, 1);
                st = new StringTokenizer(partitioning, ",");
                int pos = 0;
                while (st.hasMoreTokens()) {
                    LocalIndexProperties lip;
                    StorageObjectCollection tablePartitions;
                    ++pos;
                    token = st.nextToken();
                    while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                        token = token + ", " + st.nextToken();
                    }
                    partName = Token.getQuotedNameAfterToken(token, "PARTITION").trim();
                    if ("".equalsIgnoreCase(partName) || pos > (tablePartitions = tableProxy.getPartitions()).size()) continue;
                    HashPartitionOracle partition = (HashPartitionOracle)tablePartitions.getElement(pos - 1);
                    TableSpaceOracle ts = null;
                    if (Token.hasToken(token, "TABLESPACE")) {
                        String tsName = Token.getQuotedNameAfterToken(token, "TABLESPACE");
                        ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
                        if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                            ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                            ts.setName(tsName);
                            this.design.getRelationalDesign().stampModelObjectDDL(ts);
                        }
                    }
                    String compress = null;
                    if (Token.hasToken(token, "NOCOMPRESS")) {
                        compress = "NO";
                    } else if (Token.hasToken(token, "COMPRESS")) {
                        compress = "YES";
                    }
                    if (ts == null && compress == null && partName.equals(partition.getName()) || (lip = this.stoDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, this.indexProxy)) == null) continue;
                    lip.setIndex(this.indexProxy);
                    if (!partName.equalsIgnoreCase("TABLESPACE")) {
                        lip.setPartitionName(partName);
                    }
                    if (ts != null) {
                        lip.setTableSpace(ts);
                    }
                    if (compress == null) continue;
                    lip.setKeyCompress(compress);
                }
            }
        }
        return textAfterPartitioning;
    }

    private void setLocalIndexProperties(StorageObject subjectIndex, AbstractStorageObjectOracle partition, TableSpaceOracle ts, String logging, String compress, SegmentOracle segment, String hashTablespaces, String partitionName) {
        LocalIndexProperties lip = this.stoDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, subjectIndex);
        if (lip != null) {
            lip.setIndex(subjectIndex);
            lip.setPartitionName(partitionName);
            if (ts != null) {
                lip.setTableSpace(ts);
            }
            lip.setLogging(logging);
            lip.setKeyCompress(compress);
            lip.setSegment(segment);
            StringTokenizer tablespaces = new StringTokenizer(hashTablespaces);
            while (tablespaces.hasMoreTokens()) {
                String next = Token.getName(tablespaces.nextToken());
                TableSpaceOracle tsNext = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(next);
                if (tsNext == null) continue;
                lip.setHashSubPartitionsTableSpaces(tsNext.getObjectID());
            }
        }
    }

    private void initPartitionAttr(String token, StorageObject subjectIndex, AbstractStorageObjectOracle partition, String partitionName, String subpartType) {
        String line = token;
        String hashSPTablespaces = " ";
        if (Token.hasToken(line, "SUBPARTITION")) {
            line = Token.getStringBeforeToken(line, "SUBPARTITION");
            int ind = token.toUpperCase().indexOf("SUBPARTITION");
            token = token.substring(ind - 2);
            this.initIndexSubpartitionClause(token, subjectIndex, partition, subpartType);
        } else if (Token.hasToken(line, "STORE")) {
            line = Token.getStringBeforeToken(line, "STORE");
            token = Token.getStringAfter(token, "STORE");
            if (!(token = Token.getValBetweenBrackets(token)).equalsIgnoreCase("DEFAULT")) {
                hashSPTablespaces = token;
            }
        }
        SegmentOracle segment = null;
        if ((Token.hasToken(line, "PCTFREE") || Token.hasToken(line, "PCTUSED") || Token.hasToken(line, "INITRANS") || Token.hasToken(line, "MAXTRANS") || Token.hasToken(line, "STORAGE")) && (segment = this.stoDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(line, segment);
            this.initInitrans(line, segment);
            this.initMaxtrans(line, segment);
            this.initStorage(line, segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            segment = this.stoDesign.getSegmentSet().findEqual(segment);
        }
        TableSpaceOracle ts = null;
        if (Token.hasToken(line, "TABLESPACE")) {
            String tsName = Token.getQuotedNameAfterToken(line, "TABLESPACE");
            ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                ts.setName(tsName);
                this.design.getRelationalDesign().stampModelObjectDDL(ts);
            }
        }
        String logging = "";
        if (Token.hasToken(line, "NOLOGGING")) {
            logging = "NO";
        } else if (Token.hasToken(line, "LOGGING")) {
            logging = "YES";
        }
        String compress = "";
        if (Token.hasToken(token, "NOCOMPRESS")) {
            compress = "NO";
        } else if (Token.hasToken(token, "COMPRESS")) {
            compress = "YES";
        }
        this.setLocalIndexProperties(subjectIndex, partition, ts, logging, compress, segment, hashSPTablespaces, partitionName);
    }

    private void initIndexSubpartitionClause(String token, StorageObject subjectIndex, AbstractStorageObjectOracle partition, String subpartType) {
        token = Token.getValBetweenBrackets(token, 1);
        StringTokenizer tokenizer = new StringTokenizer(token, ",");
        int pos = 0;
        while (tokenizer.hasMoreTokens()) {
            LocalIndexProperties lip;
            ++pos;
            String oneToken = tokenizer.nextToken();
            String subpartName = Token.getQuotedNameAfterToken(oneToken, "SUBPARTITION").trim();
            if ("".equalsIgnoreCase(subpartName)) continue;
            StorageObjectCollection subpartitions = null;
            if (partition instanceof PartitionOracle) {
                if (subpartType.equalsIgnoreCase("HASH")) {
                    subpartitions = ((PartitionOracle)partition).getPartitions();
                } else if (subpartType.equalsIgnoreCase("LIST")) {
                    subpartitions = ((PartitionOracle)partition).getListPartitions();
                } else if (subpartType.equalsIgnoreCase("RANGE") && partition instanceof PartitionOraclev11g) {
                    subpartitions = ((PartitionOraclev11g)partition).getRangeSubpartitions();
                }
            } else if (partition instanceof ListPartitionOraclev11g) {
                if (subpartType.equalsIgnoreCase("HASH")) {
                    subpartitions = ((ListPartitionOraclev11g)partition).getHashSubpartitions();
                } else if (subpartType.equalsIgnoreCase("LIST")) {
                    subpartitions = ((ListPartitionOraclev11g)partition).getListSubpartitions();
                } else if (subpartType.equalsIgnoreCase("RANGE")) {
                    subpartitions = ((ListPartitionOraclev11g)partition).getRangeSubpartitions();
                }
            }
            if (subpartitions == null || pos > subpartitions.size()) continue;
            AbstractStorageObjectOracle subpartition = (AbstractStorageObjectOracle)subpartitions.getElement(pos - 1);
            TableSpaceOracle ts = null;
            if (Token.hasToken(oneToken, "TABLESPACE")) {
                String tsName = Token.getQuotedNameAfterToken(oneToken, "TABLESPACE");
                ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
                if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                    ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                    ts.setName(tsName);
                    this.design.getRelationalDesign().stampModelObjectDDL(ts);
                }
            }
            String compress = null;
            if (Token.hasToken(token, "NOCOMPRESS")) {
                compress = "NO";
            } else if (Token.hasToken(token, "COMPRESS")) {
                compress = "YES";
            }
            if (ts == null && compress == null && subpartName.equals(subpartition.getName()) || (lip = this.stoDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(subpartition, subjectIndex)) == null) continue;
            lip.setIndex(subjectIndex);
            if (!subpartName.equalsIgnoreCase("TABLESPACE")) {
                lip.setPartitionName(subpartName);
            }
            if (ts != null) {
                lip.setTableSpace(ts);
            }
            if (compress == null) continue;
            lip.setKeyCompress(compress);
        }
    }

    private void initPartSegment(String line, IndexGlobalPartitionOracle partition) {
        SegmentOracle segment = null;
        if (Token.hasToken(line, "PCTFREE") && (segment = this.stoDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(line, segment);
            this.initInitrans(line, segment);
            this.initMaxtrans(line, segment);
            this.initStorage(line, segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            SegmentOracle equalSegment = this.stoDesign.getSegmentSet().findEqual(segment);
            partition.setSegment(equalSegment);
        }
    }

    private void initAttributes(IndexProxyOracle ip, ClusterIndexOracle ci, String textToCheck) {
        if (Token.hasToken(textToCheck, "TABLESPACE")) {
            String tsName = Token.getQuotedNameAfterToken(textToCheck, "TABLESPACE");
            TableSpaceOracle ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                ts.setName(tsName);
                this.design.getRelationalDesign().stampModelObjectDDL(ts);
            }
            if (ts != null) {
                if (ip != null) {
                    ip.setTableSpace(ts);
                } else {
                    ci.setTableSpace(ts);
                }
            }
        }
        this.initSegment(ip, ci, textToCheck);
        this.initLogging(ip, ci, textToCheck);
        this.initOnline(ip, ci, textToCheck);
        this.initComputeStatistics(ip, ci, textToCheck);
        this.initCompress(ip, ci, textToCheck);
        this.initSortedRows(ip, ci, textToCheck);
        this.initInvisible(ip, ci, textToCheck);
        this.initParallel(ip, ci, textToCheck);
    }

    private void initAttributesBitmap(BitmapJoinIndexOracle index, String textToCheck) {
        String tsName;
        if (Token.hasToken(textToCheck, "TABLESPACE") && !(tsName = Token.getQuotedNameAfterToken(textToCheck, "TABLESPACE")).equalsIgnoreCase("DEFAULT")) {
            TableSpaceOracle ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                ts.setName(tsName);
                this.design.getRelationalDesign().stampModelObjectDDL(ts);
            }
            if (ts != null && index != null) {
                index.setTablespace(ts.getName());
            }
        }
        this.initSegment(index, textToCheck);
        this.initLogging(index, textToCheck);
        this.initOnline(index, textToCheck);
        this.initComputeStatistics(index, textToCheck);
        this.initSortedRows(index, textToCheck);
        this.initParallel(index, textToCheck);
    }

    private void initSegment(IndexProxyOracle ip, ClusterIndexOracle ci, String textToCheck) {
        SegmentOracle segment = null;
        if ((Token.hasToken(textToCheck, "PCTFREE") || Token.hasToken(textToCheck, "PCTUSED") || Token.hasToken(textToCheck, "INITRANS") || Token.hasToken(textToCheck, "MAXTRANS") || Token.hasToken(textToCheck, "STORAGE")) && (segment = this.stoDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(textToCheck, segment);
            this.initInitrans(textToCheck, segment);
            this.initMaxtrans(textToCheck, segment);
            this.initStorage(textToCheck, segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            SegmentOracle equalSegment = this.stoDesign.getSegmentSet().findEqual(segment);
            if (ip != null) {
                ip.setSegment(equalSegment);
            } else {
                ci.setSegment(equalSegment);
            }
        }
    }

    private void initSegment(BitmapJoinIndexOracle index, String textToCheck) {
        SegmentOracle segment = null;
        if ((Token.hasToken(textToCheck, "PCTFREE") || Token.hasToken(textToCheck, "PCTUSED") || Token.hasToken(textToCheck, "INITRANS") || Token.hasToken(textToCheck, "MAXTRANS") || Token.hasToken(textToCheck, "STORAGE")) && (segment = this.stoDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(textToCheck, segment);
            this.initInitrans(textToCheck, segment);
            this.initMaxtrans(textToCheck, segment);
            this.initStorage(textToCheck, segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            SegmentOracle equalSegment = this.stoDesign.getSegmentSet().findEqual(segment);
            index.setSegment(equalSegment);
        }
    }

    private void initPctFree(String line, SegmentOracle segment) {
        if (Token.hasToken(line, "PCTFREE") && segment.getAppView().getSettings().isIncludePctFreeInDDL()) {
            String pctFreeStr = Token.getTokenAfter(line, "PCTFREE");
            try {
                int pctFree = Integer.parseInt(pctFreeStr);
                segment.setPCTFree(pctFree);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initPctFree : " + e.getMessage());
            }
        }
    }

    private void initInitrans(String line, SegmentOracle segment) {
        if (Token.hasToken(line, "INITRANS") && segment.getAppView().getSettings().isIncludeInitransInDDL()) {
            String strValue = Token.getTokenAfter(line, "INITRANS");
            try {
                int value = Integer.parseInt(strValue);
                segment.setInitrans(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initInitrans : " + e.getMessage());
            }
        }
    }

    private void initMaxtrans(String line, SegmentOracle segment) {
        if (Token.hasToken(line, "MAXTRANS") && segment.getAppView().getSettings().isIncludeInitransInDDL()) {
            String strValue = Token.getTokenAfter(line, "MAXTRANS");
            try {
                int value = Integer.parseInt(strValue);
                segment.setMaxTrans(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initMaxtrans : " + e.getMessage());
            }
        }
    }

    private void initStorage(String line, SegmentOracle segment) {
        String stLine;
        if (Token.hasToken(line, "STORAGE") && Token.getFirstToken(stLine = Token.getStringAfter(line, "STORAGE")).equalsIgnoreCase("(")) {
            stLine = Token.getValBetweenBrackets(stLine, 1).trim();
            this.initInitial(stLine, segment, null);
            this.initNext(stLine, segment, null);
            this.initPCtIncrease(stLine, segment, null);
            this.initMinExtents(stLine, segment, null);
            this.initMaxExtents(stLine, segment, null);
            this.initFreeLists(stLine, segment, null);
            this.initFreeListGroups(stLine, segment, null);
            this.initSegBufferPool(stLine, segment, null);
        }
    }

    private void initInitial(String line, SegmentOracle segment, LobStorageOracle lobStorage) {
        if (Token.hasToken(line, "INITIAL") && segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "INITIAL").trim());
            try {
                long valueIE = Long.parseLong(str);
                if (segment != null) {
                    segment.setSCInitialExtent(valueIE);
                } else if (lobStorage != null) {
                    lobStorage.setSCInitialExtent(valueIE);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initInitial : " + e.getMessage());
            }
        }
    }

    private void initNext(String line, SegmentOracle segment, LobStorageOracle lobStorage) {
        if (Token.hasToken(line, "NEXT") && segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "NEXT").trim());
            try {
                long valueSO = Long.parseLong(str);
                if (segment != null) {
                    segment.setSCNextExtent(valueSO);
                } else if (lobStorage != null) {
                    lobStorage.setSCNextExtent(valueSO);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initNext : " + e.getMessage());
            }
        }
    }

    private void initPCtIncrease(String line, SegmentOracle segment, LobStorageOracle lobStorage) {
        if (Token.hasToken(line, "PCTINCREASE") && segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "PCTINCREASE").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCPctIncrease(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCPctIncrease(value);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initPCtIncrease : " + e.getMessage());
            }
        }
    }

    private void initMinExtents(String line, SegmentOracle segment, LobStorageOracle lobStorage) {
        if (Token.hasToken(line, "MINEXTENTS") && segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MINEXTENTS").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCMinExtents(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCMinExtents(value);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initMinExtents : " + e.getMessage());
            }
        }
    }

    private void initMaxExtents(String line, SegmentOracle segment, LobStorageOracle lobStorage) {
        if (Token.hasToken(line, "MAXEXTENTS") && segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MAXEXTENTS").trim());
            if (segment != null) {
                segment.setSCMaxExtents(str);
            } else {
                lobStorage.setSCMaxExtents(str);
            }
        }
    }

    private void initFreeLists(String line, SegmentOracle segment, LobStorageOracle lobStorage) {
        if (Token.hasToken(line, "FREELISTS") && segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "FREELISTS").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCFreeLists(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCFreeLists(value);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initFreeLists : " + e.getMessage());
            }
        }
    }

    private void initFreeListGroups(String line, SegmentOracle segment, LobStorageOracle lobStorage) {
        if (Token.hasToken(line, "GROUPS") && segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "GROUPS").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCFreelistGroups(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCFreelistGroups(value);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initFreeListGroups : " + e.getMessage());
            }
        }
    }

    private void initSegBufferPool(String line, SegmentOracle segment, LobStorageOracle lobStorage) {
        if (Token.hasToken(line, "BUFFER_POOL") && segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
            String str = Token.getQuotedNameAfterToken(line, "BUFFER_POOL").trim();
            if (segment != null) {
                segment.setSCBufferPool(str);
            } else if (lobStorage != null) {
                lobStorage.setSCBufferPool(str);
            }
        }
    }

    private void initLogging(IndexProxyOracle ip, ClusterIndexOracle ci, String textToCheck) {
        String loggingValue = Token.hasToken(textToCheck, "NOLOGGING") ? "NO" : (Token.hasToken(textToCheck, "LOGGING") ? "YES" : "");
        if (ip != null) {
            ip.setLogging(loggingValue);
        } else {
            ci.setLogging(loggingValue);
        }
    }

    private void initLogging(BitmapJoinIndexOracle index, String textToCheck) {
        if (Token.hasToken(textToCheck, "NOLOGGING")) {
            index.setLogging("NO");
        } else if (Token.hasToken(textToCheck, "LOGGING")) {
            index.setLogging("YES");
        } else {
            index.setLogging("");
        }
    }

    private void initOnline(IndexProxyOracle ip, ClusterIndexOracle ci, String textToCheck) {
        String online = "NO";
        if (Token.hasToken(textToCheck, "ONLINE")) {
            online = "YES";
        }
        if (ip != null) {
            ip.setOnline(online);
        } else {
            ci.setOnline(online);
        }
    }

    private void initOnline(BitmapJoinIndexOracle index, String textToCheck) {
        if (Token.hasToken(textToCheck, "ONLINE")) {
            index.setOnline("YES");
        } else {
            index.setOnline("NO");
        }
    }

    private void initComputeStatistics(IndexProxyOracle ip, ClusterIndexOracle ci, String textToCheck) {
        String computeStats = "NO";
        if (Token.hasString(textToCheck.toUpperCase(), "COMPUTE STATISTICS")) {
            computeStats = "YES";
        }
        if (ip != null) {
            ip.setComputeStatistics(computeStats);
        } else {
            ci.setComputeStatistics(computeStats);
        }
    }

    private void initComputeStatistics(BitmapJoinIndexOracle index, String textToCheck) {
        if (Token.hasString(textToCheck.toUpperCase(), "COMPUTE STATISTICS")) {
            index.setComputeStatistics("YES");
        }
    }

    private void initCompress(IndexProxyOracle ip, ClusterIndexOracle ci, String textToCheck) {
        int value = 0;
        if (Token.hasToken(textToCheck, "COMPRESS")) {
            try {
                value = Integer.parseInt(Token.getTokenAfter(textToCheck, "COMPRESS"));
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong COMPRESS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexOracle.initCompress : " + e.getMessage());
            }
        }
        if (ip != null) {
            ip.setCompress(value);
        } else {
            ci.setCompress(value);
        }
    }

    private void initSortedRows(IndexProxyOracle ip, ClusterIndexOracle ci, String textToCheck) {
        if (Token.hasToken(textToCheck, "NOSORT")) {
            if (ip != null) {
                ip.setSortedRows("NO");
            }
        } else if (Token.hasToken(textToCheck, "REVERSE")) {
            if (ip != null) {
                ip.setSortedRows("REVERSE");
            } else {
                ci.setReverse("YES");
            }
        } else if (ip != null) {
            ip.setSortedRows("SORTED");
        }
    }

    private void initSortedRows(BitmapJoinIndexOracle index, String textToCheck) {
        if (Token.hasToken(textToCheck, "NOSORT")) {
            index.setSortedRows("NO");
        } else if (Token.hasToken(textToCheck, "REVERSE")) {
            index.setSortedRows("REVERSE");
        } else if (Token.hasToken(textToCheck, "SORT")) {
            index.setSortedRows("SORTED");
        }
    }

    private void initInvisible(IndexProxyOracle ip, ClusterIndexOracle ci, String textToCheck) {
        if (Token.hasToken(textToCheck, "INVISIBLE") && ip instanceof IndexProxyOraclev10g) {
            ((IndexProxyOraclev10g)ip).setInvisible("YES");
        }
    }

    private void initParallel(IndexProxyOracle ip, ClusterIndexOracle ci, String textToCheck) {
        if (Token.hasToken(textToCheck, "PARALLEL")) {
            String degree = Token.getTokenAfter(textToCheck, "PARALLEL").trim();
            if (ip != null) {
                ip.setParallel("YES");
                try {
                    Integer.parseInt(degree);
                    ip.setDegree(degree);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                ci.setParallel("YES");
                try {
                    Integer.parseInt(degree);
                    ci.setDegree(degree);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (ip != null) {
            ip.setParallel("NO");
        } else {
            ci.setParallel("NO");
        }
    }

    private void initParallel(BitmapJoinIndexOracle index, String textToCheck) {
        if (Token.hasToken(textToCheck, "PARALLEL")) {
            index.setParallel("YES");
            String degree = Token.getTokenAfter(textToCheck, "PARALLEL").trim();
            try {
                Integer.parseInt(degree);
                index.setDegree(degree);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            index.setParallel("NO");
        }
    }

    private String initBitmapPartitioning() {
        String textAfterPartitioning;
        block11: {
            String partName;
            String token;
            StringTokenizer st;
            String partType;
            TableProxyOracle tableProxy;
            String partitioning;
            block12: {
                textAfterPartitioning = this.statement;
                if (!Token.hasToken(this.statement, "LOCAL")) break block11;
                this.bitmapIndex.setLocalPartitioning("YES");
                partitioning = Token.getStringAfterToken(this.statement, "LOCAL");
                tableProxy = this.bitmapIndex.getTable();
                if (tableProxy == null || !tableProxy.getPartitioned().equalsIgnoreCase("YES")) break block11;
                partType = tableProxy.getPartitionList().getPartitionType();
                String subpartType = tableProxy.getPartitionList().getSubpartitionType();
                if (Token.startsWithString(partitioning, "STORE IN")) {
                    if (partType.equalsIgnoreCase("HASH BY QUANTITY") || partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || subpartType.equalsIgnoreCase("HASH")) {
                        String tablespaces = Token.getValBetweenBrackets(partitioning, 1);
                        StringTokenizer tokenizer = new StringTokenizer(tablespaces);
                        while (tokenizer.hasMoreTokens()) {
                            String tsName = Token.getName(tokenizer.nextToken());
                            TableSpaceOracle ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null) continue;
                            this.bitmapIndex.setHashSubPartitionsTableSpaces(ts.getObjectID());
                        }
                    }
                    textAfterPartitioning = partitioning = Token.getValAfterBrackets(partitioning, 1);
                }
                if (!partType.equalsIgnoreCase("RANGE") && !partType.equalsIgnoreCase("LIST") && !partType.equalsIgnoreCase("COMPOSITE BY HASH") && !partType.equalsIgnoreCase("COMPOSITE BY LIST")) break block12;
                if (!Token.hasToken(partitioning, "PARTITION")) break block11;
                textAfterPartitioning = Token.getValAfterBrackets(partitioning, 1);
                partitioning = Token.getValBetweenBrackets(partitioning, 1);
                st = new StringTokenizer(partitioning, ",");
                int pos = 0;
                while (st.hasMoreTokens()) {
                    StorageObjectCollection tablePartitions;
                    ++pos;
                    token = st.nextToken();
                    while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                        token = token + ", " + st.nextToken();
                    }
                    partName = Token.getQuotedNameAfterToken(token, "PARTITION").trim();
                    if ("".equalsIgnoreCase(partName) || pos > (tablePartitions = tableProxy.getPartitions()).size()) continue;
                    AbstractStorageObjectOracle partition = (AbstractStorageObjectOracle)tablePartitions.getElement(pos - 1);
                    this.initPartitionAttr(token, this.bitmapIndex, partition, partName, subpartType);
                }
                break block11;
            }
            if (partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") && Token.hasToken(partitioning, "PARTITION")) {
                textAfterPartitioning = Token.getValAfterBrackets(partitioning, 1);
                partitioning = Token.getValBetweenBrackets(partitioning, 1);
                st = new StringTokenizer(partitioning, ",");
                int pos = 0;
                while (st.hasMoreTokens()) {
                    LocalIndexProperties lip;
                    StorageObjectCollection tablePartitions;
                    ++pos;
                    token = st.nextToken();
                    while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                        token = token + ", " + st.nextToken();
                    }
                    partName = Token.getQuotedNameAfterToken(token, "PARTITION").trim();
                    if ("".equalsIgnoreCase(partName) || pos > (tablePartitions = tableProxy.getPartitions()).size()) continue;
                    HashPartitionOracle partition = (HashPartitionOracle)tablePartitions.getElement(pos - 1);
                    TableSpaceOracle ts = null;
                    if (Token.hasToken(token, "TABLESPACE")) {
                        String tsName = Token.getQuotedNameAfterToken(token, "TABLESPACE");
                        ts = (TableSpaceOracle)this.stoDesign.getTableSpaceSet().getByName(tsName);
                        if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                            ts = this.stoDesign.getTableSpaceSet().createTableSpace();
                            ts.setName(tsName);
                            this.design.getRelationalDesign().stampModelObjectDDL(ts);
                        }
                    }
                    if (ts == null && partName.equals(partition.getName()) || (lip = this.stoDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, this.bitmapIndex)) == null) continue;
                    lip.setIndex(this.bitmapIndex);
                    if (!partName.equalsIgnoreCase("TABLESPACE")) {
                        lip.setPartitionName(partName);
                    }
                    if (ts == null) continue;
                    lip.setTableSpace(ts);
                }
            }
        }
        return textAfterPartitioning;
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }
}

