/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHColumnElementsOraclev9i;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class SHCreateTableOraclev9i
extends DDLStatementHandler
implements SectionConstants,
CreateTableHandler {
    private Table table = null;
    private RDBMSSite site = null;
    private StorageDesignOraclev9i storageDesign = null;
    private TableProxyOraclev9i tableProxy = null;
    private boolean createDomainsDuringImport;
    private String tableName;
    private ArrayList columns;
    protected List fkList;
    protected List refAtColumnList;
    protected List tableNodeList = new ArrayList();
    private String outSideBrackets;
    private String inSideBrackets;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateTableOraclev9i.class);
    private final String[] colPropsStartWords = new String[]{"COLUMN", "NESTED", "VARRAY", "XMLTYPE"};

    public SHCreateTableOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        block6: {
            String statement = SHCreateTableOraclev9i.clearCR(line);
            if ((Token.startsWithString(statement, "CREATE TABLE") || Token.startsWithString(statement, "CREATE GLOBAL TEMPORARY TABLE")) && statement.toUpperCase().indexOf("ORGANIZATION EXTERNAL") == -1) {
                try {
                    this.failed = false;
                    this.fkList = null;
                    this.refAtColumnList = null;
                    this.parseTable(statement);
                    if (this.fkList != null || this.refAtColumnList != null) {
                        FKRefNode fkNode = new FKRefNode();
                        fkNode.processedTable = this.table;
                        fkNode.fkStatements = this.fkList;
                        fkNode.refAtColumns = this.refAtColumnList;
                        this.tableNodeList.add(fkNode);
                    }
                    if (this.failed) {
                        this.importLog.addFailedStatement(SHCreateTableOraclev9i.FormatCR(line, "\n"));
                        break block6;
                    }
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception e) {
                    LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                    this.importLog.addFailedStatement(SHCreateTableOraclev9i.FormatCR(line, "\n"));
                }
            } else {
                this.nextHandler(line);
            }
        }
    }

    private void parseTable(String statement) {
        this.setStatement(statement);
        this.tableName = this.initTableName();
        this.table = this.design.getRelationalDesign().createTable();
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(this.site);
        this.tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.initUser();
        this.table.setName(this.tableName);
        if (!this.tableName.equals(this.tableName.toUpperCase())) {
            this.table.setNameHasQuotes(this.nameHasQuotes());
        }
        this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        this.createDomainsDuringImport = this.design.getAppView().getSettings().isCreateDomainsDuringImport();
        String temp = Token.getStringAfterToken(statement, "OF").trim();
        String stName = null;
        if ("".equalsIgnoreCase(temp)) {
            this.inSideBrackets = Token.getValBetweenBrackets(this.statement, 1).trim();
            this.outSideBrackets = Token.getValAfterBrackets(this.statement, 1).trim();
        } else {
            this.inSideBrackets = "";
            stName = Token.getFirstName(temp, '\"', '\"');
            this.outSideBrackets = Token.cutFirstToken2(temp);
            String nextToken = Token.getFirstToken(this.outSideBrackets);
            if (nextToken.equalsIgnoreCase("NOT") || nextToken.equalsIgnoreCase("SUBSTITUTABLE")) {
                this.table.setAllowTypeSubstitution(nextToken.equalsIgnoreCase("SUBSTITUTABLE"));
                this.outSideBrackets = Token.getStringAfterToken(this.outSideBrackets, "LEVELS");
            }
            if (this.outSideBrackets.startsWith("(")) {
                this.inSideBrackets = Token.getValBetweenBrackets(this.outSideBrackets, 1).trim();
                this.outSideBrackets = Token.getValAfterBrackets(this.outSideBrackets, 1).trim();
            }
        }
        boolean isBST = false;
        if (stName != null) {
            StructuredType type;
            int posPoint = stName.indexOf(46);
            if (posPoint > 0) {
                stName = Token.getValAfterCharacter(stName, '.');
            }
            if ((type = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(stName)) != null) {
                this.table.setBasedOnStructuredType(type);
                isBST = true;
                if (this.tableProxy.getIndexes().size() > 0) {
                    this.tableProxy.getIndexes().removeAll();
                }
            } else {
                LOGGER.error("Unable to find required Structured Type: " + stName);
            }
        }
        if (isBST) {
            String indexName;
            String oid;
            if (Token.hasString(statement.toUpperCase(), "OBJECT IDENTIFIER IS")) {
                String oid2 = Token.getStringAfter(statement, "OBJECT IDENTIFIER IS");
                if (oid2.toUpperCase().startsWith("PRIMARY KEY")) {
                    this.table.setOidIsPK(true);
                } else {
                    this.table.setUserDefinedOid(false);
                }
            }
            if (Token.hasToken(statement, "OIDINDEX") && !(oid = Token.getStringAfterToken(statement, "OIDINDEX")).startsWith("(") && !"".equalsIgnoreCase(indexName = Token.getFirstName(oid, '\"', '\"'))) {
                this.tableProxy.setOidIndexName(indexName);
            }
            if ("XMLTYPE".equalsIgnoreCase(stName)) {
                if (Token.hasString(statement.toUpperCase(), "XMLTYPE STORE AS")) {
                    String afterStoreAs = Token.getStringAfter(statement, "XMLTYPE STORE AS");
                    String token = Token.getFirstToken(afterStoreAs);
                    if (token.equalsIgnoreCase("OBJECT")) {
                        this.tableProxy.setStoreAs("OBJECT RELATIONAL");
                    } else if (token.equalsIgnoreCase("CLOB")) {
                        String tsName;
                        this.tableProxy.setStoreAs("CLOB");
                        String lobParameters = Token.getValBetweenBrackets(afterStoreAs, 1);
                        if (Token.hasToken(lobParameters, "TABLESPACE") && !(tsName = Token.getQuotedNameAfterToken(lobParameters, "TABLESPACE")).equals("")) {
                            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts != null) {
                                this.tableProxy.setXmlTypeTableSpace(ts);
                            }
                        }
                        if (Token.hasToken(lobParameters, "CHUNK")) {
                            try {
                                int value = Integer.parseInt(Token.getTokenAfter(lobParameters, "CHUNK").trim());
                                this.tableProxy.setChunk(value);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("wrong format in SHCreateTableOracle.parseTable : " + e.getMessage());
                                this.importLog.addWarning("Wrong CHUNK format in statement " + statement);
                            }
                        }
                        if (Token.hasToken(lobParameters, "PCTVERSION")) {
                            try {
                                this.tableProxy.setOldVersions(ColumnProxyOraclev9i.getOldVersionChoices()[1]);
                                int value = Integer.parseInt(Token.getTokenAfter(lobParameters, "PCTVERSION").trim());
                                this.tableProxy.setPCTVersion(value);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("wrong format in SHCreateTableOracle.parseTable : " + e.getMessage());
                                this.importLog.addWarning("Wrong PCTVERSION format in statement " + statement);
                            }
                        } else if (Token.hasToken(lobParameters, "RETENTION")) {
                            this.tableProxy.setOldVersions("RETENTION");
                        }
                        if (Token.hasToken(lobParameters, "FREEPOOLS")) {
                            try {
                                int value = Integer.parseInt(Token.getTokenAfter(lobParameters, "FREEPOOLS").trim());
                                this.tableProxy.setFreepools(value);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("wrong format in SHCreateTableOracle.parseTable : ", e);
                                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + statement);
                            }
                        }
                        if (Token.hasString(lobParameters.toUpperCase(Locale.ENGLISH), "STORAGE IN ROW")) {
                            String value = Token.getTokenBefore(lobParameters, "STORAGE IN ROW");
                            this.tableProxy.setStorageInRow(value.toUpperCase(Locale.ENGLISH));
                        }
                        if (Token.hasToken(lobParameters, "CACHE")) {
                            if (Token.hasString(lobParameters.toUpperCase(Locale.ENGLISH), "CACHE READS")) {
                                this.tableProxy.setXmlTypeCache("CACHE READS");
                            } else {
                                this.tableProxy.setXmlTypeCache("CACHE");
                            }
                        } else if (Token.hasToken(lobParameters, "NOCACHE")) {
                            this.tableProxy.setXmlTypeCache("NOCACHE");
                        }
                        if (Token.hasToken(lobParameters, "NOLOGGING")) {
                            this.tableProxy.setXmlTypeLogging("NO");
                        } else if (Token.hasToken(lobParameters, "LOGGING")) {
                            this.tableProxy.setXmlTypeLogging("YES");
                        }
                    }
                }
                if (Token.hasToken(statement, "ELEMENT")) {
                    String xmlSchemaUrl = "";
                    String element = Token.getQuotedNameAfterToken(statement, "ELEMENT");
                    int hashIndex = element.indexOf(35);
                    if (hashIndex > -1) {
                        xmlSchemaUrl = element.substring(0, hashIndex);
                        element = element.substring(hashIndex + 1);
                    } else if (Token.hasToken(statement, "XMLSCHEMA")) {
                        xmlSchemaUrl = Token.getQuotedNameAfterToken(statement, "XMLSCHEMA");
                    }
                    this.tableProxy.setXmlSchemaUrl(xmlSchemaUrl);
                    this.tableProxy.setXmlSchemaElement(element);
                }
            }
        }
        this.columns = this.initColumns();
        for (int col = 0; col < this.columns.size(); ++col) {
            Table exTable;
            String exTableName;
            String initially;
            TableCheckConstraintOracle tableCheckOracle;
            Map oneColumnMap = (Map)this.columns.get(col);
            boolean isConstraint = (Boolean)oneColumnMap.get("IS_CONSTRAINT");
            if (!isConstraint) {
                if (isBST) {
                    String columnName = (String)oneColumnMap.get("columnname");
                    Column bstColumn = (Column)this.table.getElementByName(columnName);
                    if (bstColumn == null) continue;
                    oneColumnMap.put("datatype", null);
                    oneColumnMap.put(NameElements.COL_STRUCTURED_TYPE, null);
                    this.initColumnProps(bstColumn, oneColumnMap);
                    continue;
                }
                this.initCol(oneColumnMap);
                continue;
            }
            this.initPKUK(oneColumnMap);
            boolean isTableConstraint = (Boolean)oneColumnMap.get("HAS_CHECK_CONSTRAINT");
            if (!isTableConstraint) continue;
            String constraintName = (String)oneColumnMap.get("CHECK_CONSTRAINT");
            String rule = (String)oneColumnMap.get("CHECK");
            if (constraintName.equals("")) {
                String shortTableName = this.tableName;
                if (shortTableName.length() > 24) {
                    shortTableName = shortTableName.substring(0, 24);
                }
                constraintName = "SYS_" + shortTableName + this.table.getCheckConstraints().size();
            }
            TableLevelConstraint constraint = this.table.createCheckConstraint(constraintName, rule);
            constraint.setName(constraintName);
            if (!constraintName.equals(constraintName.toUpperCase()) && oneColumnMap.get("CHK_NAME_QUOTED") != null) {
                constraint.setNameHasQuotes(true);
            }
            this.table.addCheckConstraint(constraint);
            this.design.getRelationalDesign().stampModelObjectDDL(constraint);
            if (this.tableProxy == null || (tableCheckOracle = this.tableProxy.getTableConstraint(constraint)) == null) continue;
            if (oneColumnMap.get("CHK_DEFERRABLE") != null) {
                boolean deferrable = (Boolean)oneColumnMap.get("CHK_DEFERRABLE");
                tableCheckOracle.setDeferrable(deferrable ? "YES" : "NO");
            }
            if ((initially = (String)oneColumnMap.get("CHK_INITIALLY")) != null) {
                tableCheckOracle.setInitially(initially.toUpperCase());
            }
            if (oneColumnMap.get("CHK_DISABLE") != null) {
                boolean disable = (Boolean)oneColumnMap.get("CHK_DISABLE");
                tableCheckOracle.setEnable(disable ? "NO" : "YES");
            }
            if (oneColumnMap.get("CHK_NOVALIDATE") != null) {
                boolean novalidate = (Boolean)oneColumnMap.get("CHK_NOVALIDATE");
                tableCheckOracle.setValidate(novalidate ? "NO" : "YES");
            }
            if ((exTableName = (String)oneColumnMap.get("CHK_EXCEPTIONS")) == null || (exTable = this.getReferencedTable(exTableName)) == null) continue;
            tableCheckOracle.setExceptionsTable((TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(exTable.getObjectID()));
        }
        if (this.tableProxy != null) {
            int lastBracketInd;
            this.initTemporary();
            String fullTextAfterBrackets = this.outSideBrackets;
            if (Token.hasToken(this.outSideBrackets, "PARTITION")) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "PARTITION");
            }
            String textBeforePartitions = this.outSideBrackets;
            if (Token.hasToken(this.outSideBrackets, "LOB")) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "LOB");
            }
            if (Token.hasToken(this.outSideBrackets, "XMLTYPE") && !"XMLTYPE".equalsIgnoreCase(stName)) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "XMLTYPE");
            }
            if (Token.hasToken(this.outSideBrackets, "VARRAY")) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "VARRAY");
            }
            if (this.outSideBrackets.toUpperCase().indexOf("NESTED TABLE") > -1) {
                this.outSideBrackets = Token.getStringBefore(this.outSideBrackets, "NESTED TABLE");
            }
            if (this.outSideBrackets.length() < fullTextAfterBrackets.length() && (lastBracketInd = fullTextAfterBrackets.lastIndexOf(")")) > -1) {
                this.outSideBrackets = this.outSideBrackets + ' ' + fullTextAfterBrackets.substring(lastBracketInd + 1).trim();
            }
            this.tableProxy.setOrganization("HEAP");
            if (Token.hasToken(this.outSideBrackets, "CLUSTER")) {
                this.initCluster();
            } else {
                String organization;
                boolean indexOrg = false;
                if (Token.hasToken(this.outSideBrackets, "ORGANIZATION") && (organization = Token.getTokenAfter(this.outSideBrackets, "ORGANIZATION")).equalsIgnoreCase("INDEX")) {
                    this.tableProxy.setOrganization("INDEX");
                    this.initIndexOrganizedTable();
                    indexOrg = true;
                }
                if (!indexOrg) {
                    this.initTableSpace(this.outSideBrackets);
                    this.initSegment(this.outSideBrackets);
                    this.initCompression();
                }
            }
            this.initCache();
            this.outSideBrackets = textBeforePartitions;
            this.initLobStorages(this.outSideBrackets, this.tableProxy);
            this.initColumnlProperties(this.outSideBrackets);
            this.outSideBrackets = fullTextAfterBrackets;
            this.initPartitions();
            this.initParallel();
            this.initMonitoring();
            this.initRowDependency();
            this.initRowMovement();
        }
    }

    private void initColumnlProperties(String state) {
        String initialText = Token.getStringToFirstMatch2(state, this.colPropsStartWords);
        String clausesToProcess = state.substring(initialText.length()).trim();
        while (clausesToProcess.length() > 0) {
            String clauseType = Token.getFirstToken(clausesToProcess);
            if (clauseType.equalsIgnoreCase("NESTED") && clausesToProcess.toUpperCase().startsWith("NESTED TABLE")) {
                clauseType = "NESTED TABLE";
            }
            String typeTokens = clauseType;
            if (clauseType.equalsIgnoreCase("XMLTYPE") && clausesToProcess.toUpperCase().startsWith("XMLTYPE COLUMN")) {
                typeTokens = "XMLTYPE COLUMN";
            }
            clausesToProcess = clausesToProcess.substring(typeTokens.length()).trim();
            String clauseBody = Token.getStringToFirstMatch2(clausesToProcess, this.colPropsStartWords);
            clausesToProcess = clausesToProcess.substring(clauseBody.length()).trim();
            while (!clausesToProcess.isEmpty() && Token.hasOpenBracket(clauseBody)) {
                String firstCharRemoved = clausesToProcess.substring(1);
                firstCharRemoved = Token.getStringToFirstMatch2(firstCharRemoved, this.colPropsStartWords);
                int strLength = firstCharRemoved.length() + 1;
                clauseBody = clauseBody + ' ' + clausesToProcess.substring(0, strLength);
                clausesToProcess = clausesToProcess.substring(strLength).trim();
            }
            if (clauseType.equalsIgnoreCase("COLUMN")) {
                this.initSubstitutableColumnClause(clauseBody);
                continue;
            }
            if (clauseType.equalsIgnoreCase("NESTED TABLE") || clauseType.equalsIgnoreCase("VARRAY")) {
                this.parseLine(clauseBody);
                continue;
            }
            if (!clauseType.equalsIgnoreCase("XMLTYPE")) continue;
            this.parseXmlTypeColumnProperties(clauseBody);
        }
    }

    private void parseXmlTypeColumnProperties(String line) {
        ColumnProxyOraclev9i columnProxy;
        String colname = Token.getFirstName(line, '\"', '\"');
        if (colname != null && (columnProxy = (ColumnProxyOraclev9i)this.tableProxy.getColumnProxyByName(colname)) != null) {
            if (Token.hasString(line.toUpperCase(), "STORE AS")) {
                String afterStoreAs = Token.getStringAfter(line, "STORE AS");
                String token = Token.getFirstToken(afterStoreAs);
                if (token.equalsIgnoreCase("OBJECT")) {
                    columnProxy.setStoreAs("OBJECT RELATIONAL");
                } else if (token.equalsIgnoreCase("CLOB")) {
                    columnProxy.setStoreAs("CLOB");
                    afterStoreAs = Token.cutTokenFromFront(afterStoreAs, "CLOB");
                    if (!afterStoreAs.equals("")) {
                        if (!afterStoreAs.startsWith("(")) {
                            afterStoreAs = Token.cutFirstToken2(afterStoreAs);
                        }
                        if (afterStoreAs.startsWith("(")) {
                            String tsName;
                            String lobParameters = Token.getValBetweenBrackets(afterStoreAs, 1);
                            if (Token.hasToken(lobParameters, "TABLESPACE") && !(tsName = Token.getQuotedNameAfterToken(lobParameters, "TABLESPACE")).equals("")) {
                                TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                                if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                    ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    ts.setName(tsName);
                                    this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                }
                                if (ts != null) {
                                    columnProxy.setTablespace(ts);
                                }
                            }
                            this.initXmlTypeStorage(lobParameters, columnProxy);
                        }
                    }
                }
            }
            if (Token.hasToken(line, "ELEMENT")) {
                String xmlSchemaUrl = "";
                String element = Token.getQuotedNameAfterToken(line, "ELEMENT");
                int hashIndex = element.indexOf(35);
                if (hashIndex > -1) {
                    xmlSchemaUrl = element.substring(0, hashIndex);
                    element = element.substring(hashIndex + 1);
                } else if (Token.hasToken(line, "XMLSCHEMA")) {
                    xmlSchemaUrl = Token.getQuotedNameAfterToken(line, "XMLSCHEMA");
                }
                columnProxy.setXmlSchemaUrl(xmlSchemaUrl);
                columnProxy.setXmlSchemaElement(element);
            }
        }
    }

    private void initXmlTypeStorage(String line, ColumnProxyOraclev9i columnProxy) {
        String stLine;
        if (Token.hasToken(line, "STORAGE") && Token.getFirstToken(stLine = Token.getStringAfter(line, "STORAGE")).equalsIgnoreCase("(")) {
            stLine = Token.getValBetweenBrackets(stLine, 1).trim();
            this.initInitial(stLine, null, null, columnProxy);
            this.initNext(stLine, null, null, columnProxy);
            this.initPCtIncrease(stLine, null, null, columnProxy);
            this.initMinExtents(stLine, null, null, columnProxy);
            this.initMaxExtents(stLine, null, null, columnProxy);
            this.initFreeLists(stLine, null, null, columnProxy);
            this.initFreeListGroups(stLine, null, null, columnProxy);
            this.initSegBufferPool(stLine, null, null, columnProxy);
        }
        this.initChunk(line, columnProxy);
        this.initRetention(line, columnProxy);
        this.initPctVersion(line, columnProxy);
        this.initFreePools(line, columnProxy);
        this.initStorageInRow(line, columnProxy);
        this.initLSCache(line, columnProxy);
        this.initLogging(line, columnProxy);
    }

    private void initChunk(String line, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "CHUNK")) {
            try {
                int value = Integer.parseInt(Token.getTokenAfter(line, "CHUNK").trim());
                columnProxy.setChunk(value);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTableOracle.initChunk : " + e.getMessage());
                this.importLog.addWarning("Wrong CHUNK format in statement " + this.statement);
            }
        }
    }

    private void initRetention(String line, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "RETENTION")) {
            columnProxy.setOldVersions("RETENTION");
        }
    }

    private void initFreePools(String line, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "FREEPOOLS")) {
            try {
                int value = Integer.parseInt(Token.getTokenAfter(line, "FREEPOOLS").trim());
                columnProxy.setFreepools(value);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTableOracle.initFreePools : ", e);
                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + this.statement);
            }
        }
    }

    private void initPctVersion(String line, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "PCTVERSION")) {
            try {
                columnProxy.setOldVersions(ColumnProxyOraclev9i.getOldVersionChoices()[1]);
                int value = Integer.parseInt(Token.getTokenAfter(line, "PCTVERSION").trim());
                columnProxy.setPCTVersion(value);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTableOracle.initPctVersion : " + e.getMessage());
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
            }
        }
    }

    private void initStorageInRow(String line, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasString(line.toUpperCase(Locale.ENGLISH), "STORAGE IN ROW")) {
            String value = Token.getTokenBefore(line, "STORAGE IN ROW");
            columnProxy.setStorageInRow(value.toUpperCase(Locale.ENGLISH));
        }
    }

    private void initLSCache(String line, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "CACHE")) {
            if (Token.hasString(line.toUpperCase(), "CACHE READS")) {
                columnProxy.setCache("CACHE READS");
            } else {
                columnProxy.setCache("CACHE");
            }
        } else if (Token.hasToken(line, "NOCACHE")) {
            columnProxy.setCache("NOCACHE");
        }
    }

    private void initLogging(String line, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "NOLOGGING")) {
            columnProxy.setLogging("NO");
        } else if (Token.hasToken(line, "LOGGING")) {
            columnProxy.setLogging("YES");
        } else {
            columnProxy.setLogging("");
        }
    }

    private boolean nameHasQuotes() {
        String startOfName = Token.getStringAfter(this.statement, "TABLE");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        if (name.indexOf(46) > 0) {
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
        }
        return startOfName.startsWith("\"");
    }

    private String initTableName() {
        int posPoint;
        String name = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        if (Token.hasOpenBracket(name)) {
            name = Token.getStringBefore(name, "(");
        }
        if ((posPoint = name.indexOf(46)) > 0) {
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    private void initUser() {
        String name = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        String userName = Token.getValBeforeCharacter(name, '.');
        if (!userName.trim().equalsIgnoreCase("")) {
            SchemaObject so;
            UserSetOracle userSet = this.storageDesign.getUserSet();
            UserOracle user = (UserOracle)userSet.getByName(userName);
            SchemaObjectSet schemaSet = ((RelationalDesign)this.table.getDesignPart()).getSchemaObjectSet();
            if (user == null) {
                user = userSet.createUser();
                user.setName(userName);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
            }
            if ((so = (SchemaObject)schemaSet.getByName(userName)) == null) {
                so = schemaSet.createSchemaObject(null);
                so.setName(userName);
                this.design.getRelationalDesign().stampModelObjectDDL(so);
            }
            if (user != null) {
                if (user.getSchemaObject() == null) {
                    user.setSchemaObject(so);
                }
                if (user.getSchemaObject() != so) {
                    this.tableProxy.setUser(user);
                }
            }
            if (so != null) {
                this.table.setSchemaObject(so);
            }
        }
    }

    private void setColumnsForIndex(Index index, String elements, ImportLogger importLog) throws ObjectDoesNotExistException {
        if (index != null) {
            StringTokenizer elemPK = new StringTokenizer(elements, ",");
            while (elemPK.hasMoreElements()) {
                String columnNamePK = elemPK.nextToken().trim();
                columnNamePK = Token.removeQuotes(columnNamePK).toUpperCase();
                Column column = (Column)index.getTable().getElementByName(columnNamePK);
                if (column != null) {
                    index.add(column);
                    continue;
                }
                importLog.addError("Column for index " + index.getName() + " doesn't exist.");
                throw new ObjectDoesNotExistException(columnNamePK);
            }
        }
    }

    private ArrayList initColumns() {
        ArrayList<Map> tableColumns = new ArrayList<Map>();
        String columnStatement = this.inSideBrackets;
        if (Token.hasToken(columnStatement, "SUPPLEMENTAL")) {
            String afterSupplemental;
            this.tableProxy.setSuplementalLogGroupName(Token.getTokenAfter(columnStatement, "GROUP"));
            String supplemental = Token.getStringAfter(columnStatement, "GROUP");
            String cols = Token.getValBetweenBrackets(supplemental);
            StringTokenizer tokenizer = new StringTokenizer(cols, ",");
            while (tokenizer.hasMoreTokens()) {
                String name = Token.getFirstName(tokenizer.nextToken(), '\"', '\"');
                ColumnProxy column = this.tableProxy.getColumnProxyByName(name);
                if (column == null) continue;
                this.tableProxy.setSuplementalLogColumns(column.getObjectID());
            }
            if (Token.getTokenAfter(supplemental, ")").equalsIgnoreCase("ALWAYS")) {
                this.tableProxy.setSuplementalLogConditions("ALWAYS");
                afterSupplemental = Token.getStringAfter(supplemental, "ALWAYS");
            } else {
                afterSupplemental = Token.getStringAfter(supplemental, ")");
            }
            String beforeSupplemental = Token.getStringBeforeToken(columnStatement, "SUPPLEMENTAL").trim();
            if (beforeSupplemental.endsWith(",")) {
                beforeSupplemental = beforeSupplemental.substring(0, beforeSupplemental.length() - 1);
            }
            columnStatement = beforeSupplemental + afterSupplemental;
        }
        SHColumnElementsOraclev9i elements = new SHColumnElementsOraclev9i();
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            Map elementsColumn;
            String oneColumn = columns.nextToken();
            if (Token.hasOpenBracket(oneColumn) || !Token.bracketsEquals(oneColumn, '\'', '\'')) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (columns.hasMoreTokens() && (Token.hasOpenBracket(oneColumn) || !Token.bracketsEquals(oneColumn, '\'', '\''))) {
                    oneColumnPast.append(",").append(columns.nextToken());
                    oneColumn = oneColumnPast.toString();
                }
            }
            if (Boolean.TRUE.equals((elementsColumn = elements.getElementsColumn(oneColumn.trim())).get("IS_CONSTRAINT")) && Token.hasToken(oneColumn, "FOREIGN")) {
                if (this.fkList == null) {
                    this.fkList = new ArrayList();
                }
                this.fkList.add(oneColumn);
                continue;
            }
            tableColumns.add(elementsColumn);
        }
        return tableColumns;
    }

    private void initPKUK(Map columnMap) {
        if (((Boolean)columnMap.get("PRIMARY KEY")).booleanValue()) {
            KeyObject existingPK = this.table.getPK();
            if (existingPK != null) {
                existingPK.remove();
            }
            this.initPrimaryKey(columnMap);
        } else if (((Boolean)columnMap.get("UNIQUE")).booleanValue()) {
            this.initUniqueKey(columnMap);
        }
    }

    public boolean initColumn(Map columnMap, Design design, Table table) {
        boolean isConstraint = (Boolean)columnMap.get("IS_CONSTRAINT");
        if (isConstraint) {
            return false;
        }
        this.table = table;
        this.tableName = table.getName();
        this.site = design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(this.site);
        this.tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        this.createDomainsDuringImport = design.getAppView().getSettings().isCreateDomainsDuringImport();
        this.fkList = null;
        this.refAtColumnList = null;
        this.initCol(columnMap);
        if (this.refAtColumnList != null || this.fkList != null) {
            FKRefNode fkNode = new FKRefNode();
            fkNode.processedTable = table;
            fkNode.fkStatements = this.fkList;
            fkNode.refAtColumns = this.refAtColumnList;
            this.tableNodeList.add(fkNode);
        }
        return true;
    }

    private void initCol(Map oneColumnMap) {
        String columnName = (String)oneColumnMap.get("columnname");
        Column column = this.table.createColumn(columnName);
        if (oneColumnMap.get("COL_NAME_QUOTED") != null && columnName != null && !columnName.equals(columnName.toUpperCase())) {
            column.setNameHasQuotes(true);
        }
        this.design.getRelationalDesign().stampModelObjectDDL(column);
        this.initColumnProps(column, oneColumnMap);
    }

    public void initColumnProps(Map columnMap, Design design, Table table, Column column) {
        this.table = table;
        this.tableName = table.getName();
        this.site = design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(this.site);
        this.tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        this.createDomainsDuringImport = design.getAppView().getSettings().isCreateDomainsDuringImport();
        this.fkList = null;
        this.refAtColumnList = null;
        this.initColumnProps(column, columnMap);
        if (this.refAtColumnList != null || this.fkList != null) {
            FKRefNode fkNode = new FKRefNode();
            fkNode.processedTable = table;
            fkNode.fkStatements = this.fkList;
            fkNode.refAtColumns = this.refAtColumnList;
            this.tableNodeList.add(fkNode);
        }
    }

    private void initColumnProps(Column column, Map oneColumnMap) {
        ColumnProxyOracle columnProxy;
        Object hasWithRowId;
        boolean hasCheckConstraint;
        String defaultValue;
        String datatype = (String)oneColumnMap.get("datatype");
        if (datatype != null) {
            String scale = (String)oneColumnMap.get("scale");
            String size = (String)oneColumnMap.get("size");
            String precision = (String)oneColumnMap.get("precision");
            String[] parameters = new String[]{precision, scale, size};
            String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
            usedDatatype = StandardDatatypeNames.getTransformedDatatypeName(usedDatatype, this.storageDesign.getRDBMSType());
            LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.storageDesign.getRDBMSType(), usedDatatype);
            if (this.createDomainsDuringImport) {
                String domainName = DomainFactory.createDomainName(logicalDT, parameters);
                Domain domain = this.getCorrespondingDomain(domainName);
                if (domain != null) {
                    column.setDomain(domain);
                } else {
                    StringBuffer message = new StringBuffer("domain is null in SHCreateTableOraclev9i.initColumnProps : ");
                    message.append(domainName);
                    LOGGER.error(message.toString());
                    this.importLog.addError("Null domain occurred while creating " + this.tableName);
                }
            } else {
                column.setLogicalDatatype(logicalDT);
                column.setUse((short)1);
                column.setDataTypeParameter("scale", scale);
                column.setDataTypeParameter("precision", precision);
                column.setDataTypeParameter("size", size);
            }
        } else {
            String stName = (String)oneColumnMap.get(NameElements.COL_STRUCTURED_TYPE);
            if (stName != null && !"".equalsIgnoreCase(stName)) {
                DistinctType dt;
                CollectionType ct;
                StructuredType st;
                boolean isRef = Token.hasToken(stName, "REF");
                int posPoint = (stName = isRef ? Token.getQuotedNameAfterToken(stName, "REF") : Token.getFirstName(stName, '\"', '\"')).indexOf(46);
                if (posPoint > 0) {
                    stName = Token.getValAfterCharacter(stName, '.');
                }
                if ((st = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(stName)) != null) {
                    column.setUse((short)3);
                    if (isRef) {
                        column.setReference(true);
                    }
                    column.setStructuredType(st);
                }
                if ((ct = (CollectionType)this.design.getDataTypesDesign().getCollectionTypeSet().getByName(stName)) != null) {
                    column.setCollectionType(ct);
                    column.setUse((short)4);
                }
                if ((dt = (DistinctType)this.design.getDataTypesDesign().getDistinctTypeSet().getByName(stName)) != null) {
                    column.setDistinctType(dt);
                    column.setUse((short)2);
                }
            }
        }
        boolean notNull = (Boolean)oneColumnMap.get("NOT NULL");
        if (notNull) {
            ColumnProxyOracle columnProxy2;
            column.setNullsAllowed(false);
            String constName = (String)oneColumnMap.get("NN_CONSTRAINT_NAME");
            if (constName != null && !constName.startsWith("SYS_C")) {
                column.setNotNullConstraintName(constName);
            }
            if (this.storageDesign != null && (columnProxy2 = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID())) != null) {
                Table exTable;
                String exTableName;
                String initially;
                if (oneColumnMap.get("NN_DEFERRABLE") != null) {
                    boolean deferrable = (Boolean)oneColumnMap.get("NN_DEFERRABLE");
                    columnProxy2.setNncDeferrable(deferrable ? "YES" : "NO");
                }
                if ((initially = (String)oneColumnMap.get("NN_INITIALLY")) != null) {
                    columnProxy2.setNncInitially(initially.toUpperCase());
                }
                if (oneColumnMap.get("NN_RELY") != null) {
                    boolean disable = (Boolean)oneColumnMap.get("NN_RELY");
                    columnProxy2.setNncRely(disable ? "NO" : "YES");
                }
                if (oneColumnMap.get("NN_DISABLE") != null) {
                    boolean disable = (Boolean)oneColumnMap.get("NN_DISABLE");
                    columnProxy2.setNncEnable(disable ? "NO" : "YES");
                }
                if (oneColumnMap.get("NN_NOVALIDATE") != null) {
                    boolean novalidate = (Boolean)oneColumnMap.get("NN_NOVALIDATE");
                    columnProxy2.setNncValidate(novalidate ? "NO" : "YES");
                }
                if ((exTableName = (String)oneColumnMap.get("NN_EXCEPTIONS")) != null && (exTable = this.getReferencedTable(exTableName)) != null) {
                    columnProxy2.setNncExceptionsTable((TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(exTable.getObjectID()));
                }
            }
        } else {
            Boolean nullAllowed = (Boolean)oneColumnMap.get("NULL");
            if (nullAllowed != null && nullAllowed.booleanValue()) {
                column.setNullsAllowed(true);
            }
        }
        boolean hasDefault = (Boolean)oneColumnMap.get("IS DEFAULT");
        if (hasDefault && !"".equalsIgnoreCase(defaultValue = (String)oneColumnMap.get("DEFAULT"))) {
            if (defaultValue.startsWith("'") || defaultValue.toUpperCase().startsWith("N'") || defaultValue.toUpperCase().startsWith("Q'") || defaultValue.toUpperCase().startsWith("NQ'") || defaultValue.startsWith("\"") || defaultValue.equalsIgnoreCase("NULL") || defaultValue.indexOf("(") > -1 || defaultValue.equalsIgnoreCase("CURRENT_DATE") || defaultValue.equalsIgnoreCase("CURRENT_TIMESTAMP") || defaultValue.equalsIgnoreCase("DBTIMEZONE") || defaultValue.equalsIgnoreCase("LOCALTIMESTAMP") || defaultValue.equalsIgnoreCase("SESSIONTIMEZONE") || defaultValue.equalsIgnoreCase("SYSDATE") || defaultValue.equalsIgnoreCase("SYSTIMESTAMP") || defaultValue.equalsIgnoreCase("UID") || defaultValue.equalsIgnoreCase("USER")) {
                column.setDefaultValue(defaultValue);
            } else {
                try {
                    Double.parseDouble(defaultValue);
                    column.setDefaultValue(defaultValue);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Bad default value for column " + column.getLongName());
                }
            }
        }
        this.initPKUK(oneColumnMap);
        String reference = (String)oneColumnMap.get("REFERENCES");
        if (reference != null) {
            Boolean novalidate;
            RefAtColNode refNode = new RefAtColNode();
            refNode.onDelete = (String)oneColumnMap.get("ON DELETE");
            refNode.columnName = (String)oneColumnMap.get("columnname");
            refNode.refColumn = (String)oneColumnMap.get("REFERENCED_COLUMN");
            refNode.referencedTable = reference;
            refNode.constraintName = (String)oneColumnMap.get("CONSTRAINT_NAME");
            refNode.constraintNameQuoted = oneColumnMap.get("REF_CONSTRAINT_NAME_QUOTED") != null;
            Boolean deferrable = (Boolean)oneColumnMap.get("REF_DEFERRABLE");
            if (deferrable != null) {
                refNode.deferrable = deferrable;
            }
            refNode.initially = (String)oneColumnMap.get("REF_INITIALLY");
            Boolean disable = (Boolean)oneColumnMap.get("REF_DISABLE");
            if (disable != null) {
                refNode.disable = disable;
            }
            if ((novalidate = (Boolean)oneColumnMap.get("REF_NOVALIDATE")) != null) {
                refNode.novalidate = novalidate;
            }
            refNode.exceptions = (String)oneColumnMap.get("REF_EXCEPTIONS");
            if (this.refAtColumnList == null) {
                this.refAtColumnList = new ArrayList();
            }
            this.refAtColumnList.add(refNode);
        }
        if (hasCheckConstraint = ((Boolean)oneColumnMap.get("HAS_CHECK_CONSTRAINT")).booleanValue()) {
            String constrName = (String)oneColumnMap.get("CHECK_CONSTRAINT");
            String check = (String)oneColumnMap.get("CHECK");
            if (check != null) {
                ColumnProxyOracle columnProxy3;
                this.initCheckConstraint(check, constrName, column);
                if (this.storageDesign != null && (columnProxy3 = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID())) != null) {
                    Table exTable;
                    String exTableName;
                    String initially;
                    if (oneColumnMap.get("CHK_DEFERRABLE") != null) {
                        boolean deferrable = (Boolean)oneColumnMap.get("CHK_DEFERRABLE");
                        columnProxy3.setDeferrable(deferrable ? "YES" : "NO");
                    }
                    if ((initially = (String)oneColumnMap.get("CHK_INITIALLY")) != null) {
                        columnProxy3.setInitially(initially.toUpperCase());
                    }
                    if (oneColumnMap.get("CHK_DISABLE") != null) {
                        boolean disable = (Boolean)oneColumnMap.get("CHK_DISABLE");
                        columnProxy3.setEnable(disable ? "NO" : "YES");
                    }
                    if (oneColumnMap.get("CHK_NOVALIDATE") != null) {
                        boolean novalidate = (Boolean)oneColumnMap.get("CHK_NOVALIDATE");
                        columnProxy3.setValidate(novalidate ? "NO" : "YES");
                    }
                    if ((exTableName = (String)oneColumnMap.get("CHK_EXCEPTIONS")) != null && (exTable = this.getReferencedTable(exTableName)) != null) {
                        columnProxy3.setExceptionsTable((TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(exTable.getObjectID()));
                    }
                }
            }
        }
        if ((hasWithRowId = oneColumnMap.get("WITH ROWID")) != null && (columnProxy = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID())) != null) {
            columnProxy.setWithRowId("YES");
        }
    }

    private void initPrimaryKey(Map oneColumnMap) {
        if (this.storageDesign != null) {
            String constName = (String)oneColumnMap.get("PKUK_CONSTRAINT_NAME");
            Index indexPK = this.table.createIndex();
            if (this.table.getBasedOnStructuredType() != null) {
                indexPK.setOidKey(true);
            }
            if (constName != null) {
                if ("".equals(constName)) {
                    NamingStandardRule nsr = this.table.getDesign().getDesignLevelSettings().getNamingStandardRule();
                    String tname = this.table.getName();
                    String abbrname = this.table.getAbbreviation();
                    if (abbrname == null || "".equals(abbrname)) {
                        abbrname = tname;
                    }
                    constName = ApplyNamingStandards.createPK_Name(tname, nsr, this.table.getDesignPart().getName(), abbrname);
                } else if (!constName.equals(constName.toUpperCase()) && oneColumnMap.get("PKUK_CONSTRAINT_NAME_QUOTED") != null) {
                    indexPK.setNameHasQuotes(true);
                }
                indexPK.setName(constName);
            }
            String elements = (String)oneColumnMap.get("VALUES");
            try {
                this.setColumnsForIndex(indexPK, elements, this.importLog);
                indexPK.makePK();
                this.design.getRelationalDesign().stampModelObjectDDL(indexPK);
            }
            catch (ObjectDoesNotExistException e) {
                StringBuffer message = new StringBuffer(e.getMessage());
                message.append(" in SHCreateTableOracle.initPrimaryKey");
                LOGGER.error(message.toString());
                this.importLog.addError("Columns for primary key " + indexPK.getName() + " don't exist.");
                this.failed = true;
            }
            if (indexPK != null) {
                PKProxyOraclev9i pk = (PKProxyOraclev9i)this.storageDesign.getPKProxySet().getProxy(indexPK.getObjectID());
                boolean isPKConstraint = (Boolean)oneColumnMap.get("IS_PK_CONSTRAINT");
                if (isPKConstraint && pk != null) {
                    boolean usingIndex;
                    Table exTable;
                    String exTableName;
                    String initially;
                    if (oneColumnMap.get("PKUK_DEFERRABLE") != null) {
                        boolean deferrable = (Boolean)oneColumnMap.get("PKUK_DEFERRABLE");
                        pk.setDeferrable(deferrable ? "YES" : "NO");
                    }
                    if ((initially = (String)oneColumnMap.get("PKUK_INITIALLY")) != null) {
                        pk.setInitially(initially.toUpperCase());
                    }
                    if (oneColumnMap.get("PKUK_DISABLE") != null) {
                        boolean disable = (Boolean)oneColumnMap.get("PKUK_DISABLE");
                        pk.setEnable(disable ? "NO" : "YES");
                    }
                    if (oneColumnMap.get("PKUK_NOVALIDATE") != null) {
                        boolean novalidate = (Boolean)oneColumnMap.get("PKUK_NOVALIDATE");
                        pk.setValidate(novalidate ? "NO" : "YES");
                    }
                    if ((exTableName = (String)oneColumnMap.get("PKUK_EXCEPTIONS")) != null && (exTable = this.getReferencedTable(exTableName)) != null) {
                        pk.setExceptionsTable((TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(exTable.getObjectID()));
                    }
                    if (usingIndex = ((Boolean)oneColumnMap.get("USING INDEX")).booleanValue()) {
                        pk.setUsingIndex("BY INDEX NAME");
                        if (oneColumnMap.get("BY CREATE INDEX STATEMENT") != null) {
                            pk.setUsingIndex("BY CREATE INDEX STATEMENT");
                            pk.setCreateIndexStatement((String)oneColumnMap.get("BY CREATE INDEX STATEMENT"));
                        } else if (oneColumnMap.get("GLOBAL") != null && ((Boolean)oneColumnMap.get("GLOBAL")).booleanValue()) {
                            IndexGlobalPartitionsListOraclev9i igpl = (IndexGlobalPartitionsListOraclev9i)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                            this.design.getRelationalDesign().stampModelObjectDDL(igpl);
                            pk.setIndexGlobalPL(igpl);
                            igpl.setIndex(pk);
                            pk.setUsingIndex("GLOBAL PARTITIONED");
                            String columnList = (String)oneColumnMap.get("COLUMN_LIST");
                            igpl.setGlobalPartColumns(igpl.columnNamesToColumnIDs(columnList));
                            String partitions = (String)oneColumnMap.get("PARTITIONS");
                            StringTokenizer st = new StringTokenizer(partitions, ",");
                            while (st.hasMoreTokens()) {
                                String token = st.nextToken();
                                if (Token.hasOpenBracket(token)) {
                                    while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                                        token = token + "," + st.nextToken();
                                    }
                                }
                                IndexGlobalPartitionOraclev9i igp = (IndexGlobalPartitionOraclev9i)this.storageDesign.getIndexGlobalPartitionSet().createIndexGlobalPartition();
                                this.design.getRelationalDesign().stampModelObjectDDL(igp);
                                String igpName = Token.getQuotedNameAfterToken(token, "PARTITION").trim();
                                igp.setName(igpName);
                                igp.setIndexGlobalPartList(igpl);
                                pk.getGlobalPartitions().add(igp);
                                String valueList = Token.getValBetweenBrackets(token, 1).trim();
                                igp.setValueList(valueList);
                                if (Token.hasToken(token, "TABLESPACE")) {
                                    String tsName = Token.getQuotedNameAfterToken(token, "TABLESPACE");
                                    TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                                    if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                        ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        ts.setName(tsName);
                                        this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                    }
                                    if (ts != null) {
                                        igp.setTableSpace(ts);
                                    }
                                }
                                if (Token.hasToken(token, "NOLOGGING")) {
                                    igp.setLogging("NO");
                                    continue;
                                }
                                if (Token.hasToken(token, "LOGGING")) {
                                    igp.setLogging("YES");
                                    continue;
                                }
                                igp.setLogging("");
                            }
                        } else if (oneColumnMap.get("LOCAL") != null && ((Boolean)oneColumnMap.get("LOCAL")).booleanValue()) {
                            pk.setUsingIndex("LOCAL PARTITIONED");
                        }
                        if (!pk.getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                            String loggingValue;
                            String tsName;
                            String maxTransStr;
                            String initransStr;
                            SegmentOraclev9i segment = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment();
                            this.design.getRelationalDesign().stampModelObjectDDL(segment);
                            String pctFreeStr = (String)oneColumnMap.get("PCTFREE");
                            if (!"".equalsIgnoreCase(pctFreeStr) && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                                try {
                                    int pctFree = Integer.parseInt(pctFreeStr);
                                    segment.setPCTFree(pctFree);
                                }
                                catch (NumberFormatException pctFree) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(initransStr = (String)oneColumnMap.get("INITRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                                try {
                                    int value = Integer.parseInt(initransStr);
                                    segment.setInitrans(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(maxTransStr = (String)oneColumnMap.get("MAXTRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                                try {
                                    int value = Integer.parseInt(maxTransStr);
                                    segment.setMaxTrans(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            boolean storage = false;
                            if (oneColumnMap.get("STORAGE") != null) {
                                storage = (Boolean)oneColumnMap.get("STORAGE");
                            }
                            if (storage) {
                                String groupsStr;
                                String freeListsStr;
                                String maxExtentsStr;
                                String minExtentsStr;
                                String pctIncStr;
                                String nextStr;
                                String initialStr = (String)oneColumnMap.get("INITIAL");
                                if (!"".equalsIgnoreCase(initialStr) && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                                    try {
                                        long value = Long.parseLong(this.getNumberOnly(initialStr));
                                        segment.setSCInitialExtent(value);
                                    }
                                    catch (NumberFormatException value) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(nextStr = (String)oneColumnMap.get("NEXT")) && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                                    try {
                                        long value = Long.parseLong(this.getNumberOnly(nextStr));
                                        segment.setSCNextExtent(value);
                                    }
                                    catch (NumberFormatException value) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(pctIncStr = (String)oneColumnMap.get("PCTINCREASE")) && this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                                    try {
                                        int value = Integer.parseInt(pctIncStr);
                                        segment.setSCPctIncrease(value);
                                    }
                                    catch (NumberFormatException value) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(minExtentsStr = (String)oneColumnMap.get("MINEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                                    try {
                                        int value = Integer.parseInt(minExtentsStr);
                                        segment.setSCMinExtents(value);
                                    }
                                    catch (NumberFormatException value) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(maxExtentsStr = (String)oneColumnMap.get("MAXEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                                    segment.setSCMaxExtents(maxExtentsStr);
                                }
                                if (!"".equalsIgnoreCase(freeListsStr = (String)oneColumnMap.get("FREELISTS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                                    try {
                                        int value = Integer.parseInt(freeListsStr);
                                        segment.setSCFreeLists(value);
                                    }
                                    catch (NumberFormatException value) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(groupsStr = (String)oneColumnMap.get("GROUPS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                                    try {
                                        int value = Integer.parseInt(groupsStr);
                                        segment.setSCFreelistGroups(value);
                                    }
                                    catch (NumberFormatException value) {
                                        // empty catch block
                                    }
                                }
                                String bufferPool = (String)oneColumnMap.get("BUFFER_POOL");
                                if (!"".equalsIgnoreCase(groupsStr) && this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                                    segment.setSCBufferPool(bufferPool);
                                }
                            }
                            if ((tsName = (String)oneColumnMap.get("TABLESPACE")) != null && !tsName.equals("")) {
                                TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                                if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                    ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    ts.setName(tsName);
                                    this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                }
                                if (ts != null) {
                                    pk.setTableSpace(ts);
                                }
                            }
                            if ((loggingValue = (String)oneColumnMap.get("LOGGING")) == null) {
                                loggingValue = "";
                            }
                            pk.setLogging(loggingValue);
                            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
                            pk.setIndexSegment(equalSegment);
                        }
                    }
                }
            }
        }
    }

    private void initUniqueKey(Map oneColumnMap) {
        if (this.storageDesign != null) {
            UniqueOraclev9i unique;
            String constName = (String)oneColumnMap.get("PKUK_CONSTRAINT_NAME");
            Index uniqueIndex = this.table.createIndex();
            if (constName != null) {
                uniqueIndex.setName(constName);
                if (!constName.equals(constName.toUpperCase()) && oneColumnMap.get("PKUK_CONSTRAINT_NAME_QUOTED") != null) {
                    uniqueIndex.setNameHasQuotes(true);
                }
            }
            String elements = (String)oneColumnMap.get("VALUES");
            try {
                this.setColumnsForIndex(uniqueIndex, elements, this.importLog);
                uniqueIndex.setIndexState("Unique Constraint");
                this.design.getRelationalDesign().stampModelObjectDDL(uniqueIndex);
            }
            catch (ObjectDoesNotExistException e) {
                StringBuffer message = new StringBuffer(e.getMessage());
                message.append(" in SHCreateTableOracle.initUniqueKey");
                LOGGER.error(message.toString());
                this.importLog.addError("Columns for unique key " + uniqueIndex.getName() + " don't exist.");
                this.failed = true;
            }
            if (uniqueIndex != null && (unique = (UniqueOraclev9i)this.storageDesign.getUniqueSet().getProxy(uniqueIndex.getObjectID())) != null) {
                boolean usingIndex;
                Table exTable;
                String exTableName;
                String initially;
                if (oneColumnMap.get("PKUK_DEFERRABLE") != null) {
                    boolean deferrable = (Boolean)oneColumnMap.get("PKUK_DEFERRABLE");
                    unique.setDeferrable(deferrable ? "YES" : "NO");
                }
                if ((initially = (String)oneColumnMap.get("PKUK_INITIALLY")) != null) {
                    unique.setInitially(initially.toUpperCase());
                }
                if (oneColumnMap.get("PKUK_DISABLE") != null) {
                    boolean disable = (Boolean)oneColumnMap.get("PKUK_DISABLE");
                    unique.setEnable(disable ? "NO" : "YES");
                }
                if (oneColumnMap.get("PKUK_NOVALIDATE") != null) {
                    boolean novalidate = (Boolean)oneColumnMap.get("PKUK_NOVALIDATE");
                    unique.setValidate(novalidate ? "NO" : "YES");
                }
                if ((exTableName = (String)oneColumnMap.get("PKUK_EXCEPTIONS")) != null && (exTable = this.getReferencedTable(exTableName)) != null) {
                    unique.setExceptionsTable((TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(exTable.getObjectID()));
                }
                if (usingIndex = ((Boolean)oneColumnMap.get("USING INDEX")).booleanValue()) {
                    unique.setUsingIndex("BY INDEX NAME");
                    if (oneColumnMap.get("BY CREATE INDEX STATEMENT") != null) {
                        unique.setUsingIndex("BY CREATE INDEX STATEMENT");
                        unique.setCreateIndexStatement((String)oneColumnMap.get("BY CREATE INDEX STATEMENT"));
                    } else if (oneColumnMap.get("GLOBAL") != null && ((Boolean)oneColumnMap.get("GLOBAL")).booleanValue()) {
                        IndexGlobalPartitionsListOraclev9i igpl = (IndexGlobalPartitionsListOraclev9i)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL(igpl);
                        unique.setUsingIndexGlobalPL(igpl);
                        igpl.setIndex(unique);
                        unique.setUsingIndex("GLOBAL PARTITIONED");
                        String columnList = (String)oneColumnMap.get("COLUMN_LIST");
                        igpl.setGlobalPartColumns(igpl.columnNamesToColumnIDs(columnList));
                        String partitions = (String)oneColumnMap.get("PARTITIONS");
                        StringTokenizer st = new StringTokenizer(partitions, ",");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (Token.hasOpenBracket(token)) {
                                while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                                    token = token + "," + st.nextToken();
                                }
                            }
                            IndexGlobalPartitionOraclev9i igp = (IndexGlobalPartitionOraclev9i)this.storageDesign.getIndexGlobalPartitionSet().createIndexGlobalPartition();
                            this.design.getRelationalDesign().stampModelObjectDDL(igp);
                            String igpName = Token.getQuotedNameAfterToken(token, "PARTITION").trim();
                            igp.setName(igpName);
                            igp.setIndexGlobalPartList(igpl);
                            unique.getGlobalPartitions().add(igp);
                            String valueList = Token.getValBetweenBrackets(token, 1).trim();
                            igp.setValueList(valueList);
                            if (Token.hasToken(token, "TABLESPACE")) {
                                String tsName = Token.getQuotedNameAfterToken(token, "TABLESPACE");
                                TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                                if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                    ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    ts.setName(tsName);
                                    this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                }
                                if (ts != null) {
                                    igp.setTableSpace(ts);
                                }
                            }
                            if (Token.hasToken(token, "NOLOGGING")) {
                                igp.setLogging("NO");
                                continue;
                            }
                            if (Token.hasToken(token, "LOGGING")) {
                                igp.setLogging("YES");
                                continue;
                            }
                            igp.setLogging("");
                        }
                    } else if (oneColumnMap.get("LOCAL") != null && ((Boolean)oneColumnMap.get("LOCAL")).booleanValue()) {
                        unique.setUsingIndex("LOCAL PARTITIONED");
                    }
                    if (!unique.getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        String loggingValue;
                        String tsName;
                        String maxTransStr;
                        String initransStr;
                        SegmentOraclev9i segment = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment();
                        this.design.getRelationalDesign().stampModelObjectDDL(segment);
                        String pctFreeStr = (String)oneColumnMap.get("PCTFREE");
                        if (!"".equalsIgnoreCase(pctFreeStr) && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                            try {
                                int pctFree = Integer.parseInt(pctFreeStr);
                                segment.setPCTFree(pctFree);
                            }
                            catch (NumberFormatException pctFree) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(initransStr = (String)oneColumnMap.get("INITRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                            try {
                                int value = Integer.parseInt(initransStr);
                                segment.setInitrans(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(maxTransStr = (String)oneColumnMap.get("MAXTRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                            try {
                                int value = Integer.parseInt(maxTransStr);
                                segment.setMaxTrans(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (oneColumnMap.get("STORAGE") != null && ((Boolean)oneColumnMap.get("STORAGE")).booleanValue()) {
                            String groupsStr;
                            String freeListsStr;
                            String maxExtentsStr;
                            String minExtentsStr;
                            String pctIncStr;
                            String nextStr;
                            String initialStr = (String)oneColumnMap.get("INITIAL");
                            if (!"".equalsIgnoreCase(initialStr) && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(initialStr));
                                    segment.setSCInitialExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(nextStr = (String)oneColumnMap.get("NEXT")) && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(nextStr));
                                    segment.setSCNextExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(pctIncStr = (String)oneColumnMap.get("PCTINCREASE")) && this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                                try {
                                    int value = Integer.parseInt(pctIncStr);
                                    segment.setSCPctIncrease(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(minExtentsStr = (String)oneColumnMap.get("MINEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                                try {
                                    int value = Integer.parseInt(minExtentsStr);
                                    segment.setSCMinExtents(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(maxExtentsStr = (String)oneColumnMap.get("MAXEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                                segment.setSCMaxExtents(maxExtentsStr);
                            }
                            if (!"".equalsIgnoreCase(freeListsStr = (String)oneColumnMap.get("FREELISTS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                                try {
                                    int value = Integer.parseInt(freeListsStr);
                                    segment.setSCFreeLists(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(groupsStr = (String)oneColumnMap.get("GROUPS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                                try {
                                    int value = Integer.parseInt(groupsStr);
                                    segment.setSCFreelistGroups(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            String bufferPool = (String)oneColumnMap.get("BUFFER_POOL");
                            if (!"".equalsIgnoreCase(groupsStr) && this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                                segment.setSCBufferPool(bufferPool);
                            }
                        }
                        if ((tsName = (String)oneColumnMap.get("TABLESPACE")) != null && !tsName.equals("")) {
                            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts != null) {
                                unique.setTableSpace(ts);
                            }
                        }
                        if ((loggingValue = (String)oneColumnMap.get("LOGGING")) == null) {
                            loggingValue = "";
                        }
                        unique.setLogging(loggingValue);
                        SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
                        unique.setIndexSegment(equalSegment);
                    }
                }
            }
        }
    }

    private void initCheckConstraint(String check, String name, Column column) {
        CheckConstraint constraint = new CheckConstraint();
        constraint.add(StorageDesignOraclev9i.RDBMS_TYPE, check);
        if (!"".equalsIgnoreCase(name) && name != null) {
            constraint.setName(name);
            column.setConstraintName(name);
        } else {
            String columnName = column.getName();
            if (columnName.length() > 25) {
                columnName = columnName.substring(0, 25);
            }
            name = columnName + "_CHCK";
            constraint.setName(name);
            column.setConstraintName("");
        }
        constraint.setDesign(this.design);
        column.setUseDomainConstraints(false);
        column.parseAndSetCheckConstraint(constraint);
    }

    private Domain getCorrespondingDomain(String nameDomain) {
        Domain result = null;
        DomainSet domainSet = this.design.getDomainSet();
        Iterator itDomSet = domainSet.iterator();
        while (itDomSet.hasNext()) {
            Domain domain = (Domain)itDomSet.next();
            if (!domain.getName().equalsIgnoreCase(nameDomain)) continue;
            result = domain;
            return result;
        }
        return result;
    }

    private void initTemporary() {
        if ("GLOBAL".equalsIgnoreCase(Token.getTokenAfter(this.statement, "CREATE"))) {
            this.tableProxy.setTemporary("YES");
            this.initOnCommit();
        } else {
            this.tableProxy.setTemporary("NO");
        }
    }

    private void initOnCommit() {
        String onCommit;
        String preserveRows = "NO";
        if (Token.hasToken(this.outSideBrackets, "COMMIT") && (onCommit = Token.getTokenAfter(this.outSideBrackets, "COMMIT")).equalsIgnoreCase("PRESERVE")) {
            preserveRows = "YES";
        }
        this.tableProxy.setTempPreserveRows(preserveRows);
    }

    private void initCluster() {
        ClusterOraclev9i cluster;
        String clusterName = Token.getQuotedNameAfterToken(this.outSideBrackets, "CLUSTER");
        if (clusterName.indexOf(46) > -1) {
            clusterName = clusterName.substring(clusterName.lastIndexOf(46) + 1);
        }
        if ((cluster = (ClusterOraclev9i)this.storageDesign.getClusterSet().getByName(clusterName)) != null) {
            this.tableProxy.setCluster(cluster);
            String clusterCols = Token.getStringAfter(this.outSideBrackets, "CLUSTER");
            clusterCols = Token.getValBetweenBrackets(clusterCols, 1);
            StringTokenizer tokenizer = new StringTokenizer(clusterCols, ",");
            while (tokenizer.hasMoreTokens()) {
                String name = Token.getFirstName(tokenizer.nextToken(), '\"', '\"');
                ColumnProxy column = this.tableProxy.getColumnProxyByName(name);
                if (column == null) continue;
                this.tableProxy.setClusterColumns(column.getObjectID());
            }
        }
    }

    private void initIndexOrganizedTable() {
        String colName;
        ColumnProxyOraclev9i col;
        String iot = Token.getStringAfter(this.outSideBrackets, "ORGANIZATION");
        iot = Token.cutFirstToken(iot);
        String afterOverflow = "";
        if (Token.hasToken(iot, "OVERFLOW")) {
            afterOverflow = Token.getStringAfterToken(iot, "OVERFLOW");
            iot = Token.getStringBeforeToken(iot, "OVERFLOW");
        }
        this.initSegment(iot);
        if (Token.hasToken(iot, "PCTTHRESHOLD")) {
            String threshold = Token.getTokenAfter(iot, "PCTTHRESHOLD");
            try {
                this.tableProxy.setIotPctThreshold(Integer.parseInt(threshold));
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTTHRESHOLD format in statement " + this.statement);
                LOGGER.error("Wrong syntax near " + iot, e);
            }
        }
        if (Token.hasToken(iot, "COMPRESS")) {
            String compress = Token.getTokenAfter(iot, "COMPRESS");
            try {
                this.tableProxy.setIotCompress(Integer.parseInt(compress));
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong COMPRESS format in statement " + this.statement);
                LOGGER.error("Wrong syntax near " + iot, e);
            }
        }
        if (Token.hasString(iot.toUpperCase(), "MAPPING TABLE")) {
            this.tableProxy.setIOTMappingTable("YES");
        }
        if (Token.hasToken(iot, "INCLUDING") && (col = (ColumnProxyOraclev9i)this.tableProxy.getColumnProxyByName(colName = Token.getQuotedNameAfterToken(iot, "INCLUDING"))) != null) {
            this.tableProxy.setIotIncluding(col);
        }
        this.initTableSpace(iot);
        if (!afterOverflow.equals("")) {
            this.initOverflowSegment(afterOverflow);
            if (Token.hasToken(afterOverflow, "NOLOGGING")) {
                this.tableProxy.setIotOverflowLogging("NO");
            } else if (Token.hasToken(afterOverflow, "LOGGING")) {
                this.tableProxy.setIotOverflowLogging("YES");
            } else {
                this.tableProxy.setIotOverflowLogging("");
            }
            if (Token.hasToken(afterOverflow, "TABLESPACE")) {
                String tsName = Token.getQuotedNameAfterToken(afterOverflow, "TABLESPACE");
                TableSpaceOraclev9i tablespace = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                if (tablespace == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                    tablespace = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tablespace.setName(tsName);
                    this.design.getRelationalDesign().stampModelObjectDDL(tablespace);
                }
                if (tablespace != null) {
                    this.tableProxy.setIotOverflowTablespace(tablespace);
                }
            }
        }
    }

    private void initOverflowSegment(String string) {
        SegmentOraclev9i segment = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segment = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segment);
            this.initPctUsed(string, segment);
            this.initInitrans(string, segment);
            this.initMaxtrans(string, segment);
            this.initStorage(string, segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
            this.tableProxy.setIotOverflowSegment(equalSegment);
        }
    }

    private void initTableSpace(String text) {
        if (Token.hasToken(text, "TABLESPACE")) {
            String tsName = Token.getQuotedNameAfterToken(text, "TABLESPACE");
            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                ts.setName(tsName);
                this.design.getRelationalDesign().stampModelObjectDDL(ts);
            }
            if (ts != null) {
                this.tableProxy.setTableSpace(ts);
            }
        }
    }

    private void initCompression() {
        if (Token.hasToken(this.outSideBrackets, "COMPRESS")) {
            this.tableProxy.setDataSegmentCompression("YES");
        } else {
            this.tableProxy.setDataSegmentCompression("NO");
        }
    }

    private void initSegment(String text) {
        SegmentOraclev9i segment = null;
        if ((Token.hasToken(text, "PCTFREE") || Token.hasToken(text, "PCTUSED") || Token.hasToken(text, "INITRANS") || Token.hasToken(text, "MAXTRANS") || Token.hasToken(text, "STORAGE")) && (segment = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(text, segment);
            this.initPctUsed(text, segment);
            this.initInitrans(text, segment);
            this.initMaxtrans(text, segment);
            this.initStorage(text, segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
            this.tableProxy.setSegment(equalSegment);
        }
        this.initLogging(text);
    }

    private void initPctFree(String line, SegmentOraclev9i segment) {
        String pctFreeStr = Token.getTokenAfter(line, "PCTFREE").trim();
        try {
            if (!"".equals(pctFreeStr) && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                int pctFree = Integer.parseInt(pctFreeStr);
                segment.setPCTFree(pctFree);
            }
        }
        catch (NumberFormatException e) {
            this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
            LOGGER.error("wrong format in SHCreateTableOracle.initPctFree : " + e.getMessage());
        }
    }

    private void initPctUsed(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "PCTUSED") && this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
            String strValue = Token.getTokenAfter(line, "PCTUSED").trim();
            try {
                int value = Integer.parseInt(strValue);
                segment.setPCTUsed(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTUSED format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initPctUsed : " + e.getMessage());
            }
        }
    }

    private void initInitrans(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "INITRANS") && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
            String strValue = Token.getTokenAfter(line, "INITRANS").trim();
            try {
                int value = Integer.parseInt(strValue);
                segment.setInitrans(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initInitrans : " + e.getMessage());
            }
        }
    }

    private void initMaxtrans(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "MAXTRANS") && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
            String strValue = Token.getTokenAfter(line, "MAXTRANS").trim();
            try {
                int value = Integer.parseInt(strValue);
                segment.setMaxTrans(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initMaxtrans : " + e.getMessage());
            }
        }
    }

    private void initStorage(String line, SegmentOraclev9i segment) {
        String stLine = Token.getStringAfter(line, "STORAGE").trim();
        if (stLine.length() > 0) {
            if (stLine.startsWith("(")) {
                stLine = Token.getValBetweenBrackets(stLine, 1).trim();
                this.initInitial(stLine, segment, null, null);
                this.initNext(stLine, segment, null, null);
                this.initPCtIncrease(stLine, segment, null, null);
                this.initMinExtents(stLine, segment, null, null);
                this.initMaxExtents(stLine, segment, null, null);
                this.initFreeLists(stLine, segment, null, null);
                this.initFreeListGroups(stLine, segment, null, null);
                this.initSegBufferPool(stLine, segment, null, null);
            } else {
                this.initStorage(stLine, segment);
            }
        }
    }

    private void initInitial(String line, SegmentOraclev9i segment, LobStorageOraclev9i lobStorage, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "INITIAL") && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "INITIAL").trim());
            try {
                long valueIE = Long.parseLong(str);
                if (segment != null) {
                    segment.setSCInitialExtent(valueIE);
                } else if (lobStorage != null) {
                    lobStorage.setSCInitialExtent(valueIE);
                } else if (columnProxy != null) {
                    columnProxy.setSCInitialExtent(valueIE);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initInitial : " + e.getMessage());
            }
        }
    }

    private void initNext(String line, SegmentOraclev9i segment, LobStorageOraclev9i lobStorage, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "NEXT") && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "NEXT").trim());
            try {
                long valueSO = Long.parseLong(str);
                if (segment != null) {
                    segment.setSCNextExtent(valueSO);
                } else if (lobStorage != null) {
                    lobStorage.setSCNextExtent(valueSO);
                } else if (columnProxy != null) {
                    columnProxy.setSCNextExtent(valueSO);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initNext : " + e.getMessage());
            }
        }
    }

    private void initPCtIncrease(String line, SegmentOraclev9i segment, LobStorageOraclev9i lobStorage, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "PCTINCREASE") && this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "PCTINCREASE").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCPctIncrease(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCPctIncrease(value);
                } else if (columnProxy != null) {
                    columnProxy.setSCPctIncrease(value);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initPCtIncrease : " + e.getMessage());
            }
        }
    }

    private void initMinExtents(String line, SegmentOraclev9i segment, LobStorageOraclev9i lobStorage, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "MINEXTENTS") && this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MINEXTENTS").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCMinExtents(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCMinExtents(value);
                } else if (columnProxy != null) {
                    columnProxy.setSCMinExtents(value);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initMinExtents : " + e.getMessage());
            }
        }
    }

    private void initMaxExtents(String line, SegmentOraclev9i segment, LobStorageOraclev9i lobStorage, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "MAXEXTENTS") && this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MAXEXTENTS").trim());
            if (segment != null) {
                segment.setSCMaxExtents(str);
            } else if (lobStorage != null) {
                lobStorage.setSCMaxExtents(str);
            } else if (columnProxy != null) {
                columnProxy.setSCMaxExtents(str);
            }
        }
    }

    private void initFreeLists(String line, SegmentOraclev9i segment, LobStorageOraclev9i lobStorage, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "FREELISTS") && this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "FREELISTS").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCFreeLists(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCFreeLists(value);
                } else if (columnProxy != null) {
                    columnProxy.setSCFreeLists(value);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initFreeLists : " + e.getMessage());
            }
        }
    }

    private void initFreeListGroups(String line, SegmentOraclev9i segment, LobStorageOraclev9i lobStorage, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "GROUPS") && this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "GROUPS").trim());
            try {
                int value = Integer.parseInt(str);
                if (segment != null) {
                    segment.setSCFreelistGroups(value);
                } else if (lobStorage != null) {
                    lobStorage.setSCFreelistGroups(value);
                } else if (columnProxy != null) {
                    columnProxy.setSCFreelistGroups(value);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initFreeListGroups : " + e.getMessage());
            }
        }
    }

    private void initSegBufferPool(String line, SegmentOraclev9i segment, LobStorageOraclev9i lobStorage, ColumnProxyOraclev9i columnProxy) {
        if (Token.hasToken(line, "BUFFER_POOL") && this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
            String str = Token.getQuotedNameAfterToken(line, "BUFFER_POOL");
            if (segment != null) {
                segment.setSCBufferPool(str);
            } else if (lobStorage != null) {
                lobStorage.setSCBufferPool(str);
            } else if (columnProxy != null) {
                columnProxy.setSCBufferPool(str);
            }
        }
    }

    private void initLogging(String text) {
        if (Token.hasToken(text, "NOLOGGING")) {
            this.tableProxy.setLogging("NO");
        } else if (Token.hasToken(text, "LOGGING")) {
            this.tableProxy.setLogging("YES");
        } else {
            this.tableProxy.setLogging("");
        }
    }

    private void initCache() {
        if (Token.hasToken(this.outSideBrackets, "CACHE")) {
            this.tableProxy.setCache("YES");
        } else {
            this.tableProxy.setCache("NO");
        }
    }

    private void initMonitoring() {
        if (Token.hasToken(this.outSideBrackets, "MONITORING")) {
            this.tableProxy.setMonitoring("YES");
        } else {
            this.tableProxy.setMonitoring("NO");
        }
    }

    private void initRowMovement() {
        String rowMovement = "DISABLE";
        if (Token.hasString(this.outSideBrackets.toUpperCase(), "ROW MOVEMENT") && Token.getTokenBefore(this.outSideBrackets, "ROW MOVEMENT").equalsIgnoreCase("ENABLE")) {
            rowMovement = "ENABLE";
        }
        this.tableProxy.setParttitionedRowMovement(rowMovement);
    }

    private void initParallel() {
        if (Token.hasToken(this.outSideBrackets, "PARALLEL")) {
            this.tableProxy.setParallel("YES");
            String degree = Token.getTokenAfter(this.outSideBrackets, "PARALLEL").trim();
            try {
                Integer.parseInt(degree);
                this.tableProxy.setDegree(degree);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.tableProxy.setParallel("NO");
        }
    }

    private void initRowDependency() {
        if (Token.hasToken(this.outSideBrackets, "ROWDEPENDENCIES")) {
            this.tableProxy.setRowDependency("YES");
        } else {
            this.tableProxy.setRowDependency("NO");
        }
    }

    public void initPartitionsForSnapshotTable(String partitionClause, TableProxyOraclev9i tableProxy) {
        if (tableProxy != null) {
            this.outSideBrackets = partitionClause;
            this.tableProxy = tableProxy;
            this.table = (Table)tableProxy.getObject();
            this.storageDesign = (StorageDesignOraclev9i)tableProxy.getStorageDesign();
            this.initPartitions();
        }
    }

    private void initPartitions() {
        if (Token.hasString(this.outSideBrackets.toUpperCase(), "PARTITION BY")) {
            PartitionListOraclev9i partList = (PartitionListOraclev9i)this.storageDesign.getPartitionListSet().createPartitionList();
            this.design.getRelationalDesign().stampModelObjectDDL(partList);
            partList.setTable(this.tableProxy);
            String line = Token.getStringAfter(this.outSideBrackets, "PARTITION BY");
            String partType = Token.getFirstToken(line);
            int bracketIndex = partType.indexOf("(");
            if (bracketIndex > -1) {
                partType = partType.substring(0, bracketIndex);
            }
            String columnList = Token.getValBetweenBrackets(line, 1).trim();
            line = Token.getValAfterBrackets(line, 1);
            StringTokenizer partColumns = new StringTokenizer(columnList, ",");
            while (partColumns.hasMoreTokens()) {
                partList.setColumnList(Token.getName(partColumns.nextToken().trim()));
            }
            if (partType.equalsIgnoreCase("RANGE")) {
                if (Token.hasString(line.toUpperCase(), "SUBPARTITION BY HASH")) {
                    partList.setPartitionType("COMPOSITE BY HASH");
                    line = this.doSubPartByHash(line, partList);
                } else if (Token.hasString(line.toUpperCase(), "SUBPARTITION BY LIST")) {
                    partList.setPartitionType("COMPOSITE BY LIST");
                    line = this.doSubPartByList(line, partList);
                } else {
                    partList.setPartitionType("RANGE");
                }
                this.doRangePartitions(line, partList);
            } else if (partType.equalsIgnoreCase("HASH")) {
                partList.setPartitionType("HASH BY LIST OF PARTITIONS");
                if (line.charAt(0) == '(') {
                    String partitions = Token.getValBetweenBrackets(line, 1).trim();
                    StringTokenizer st = new StringTokenizer(partitions, ",");
                    while (st.hasMoreTokens()) {
                        String tsName;
                        String token = st.nextToken();
                        while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                            token = token + "," + st.nextToken();
                        }
                        if (!Token.hasToken(token, "PARTITION")) continue;
                        String afterPartition = Token.getStringAfter(token, "PARTITION");
                        String partName = Token.getFirstName(afterPartition, '\"', '\"');
                        HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)this.storageDesign.getHashPartitionSet().createHashPartition();
                        if (!(partName.equalsIgnoreCase("TABLESPACE") || partName.equalsIgnoreCase("OVERFLOW") || partName.equalsIgnoreCase("LOB") || partName.equalsIgnoreCase("VARRAY"))) {
                            hashPartition.setName(partName);
                            if (afterPartition.startsWith("\"") && !partName.equals(partName.toUpperCase())) {
                                hashPartition.setNameHasQuotes(true);
                            }
                        } else {
                            hashPartition.setName("SYS_" + hashPartition.getName());
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(hashPartition);
                        hashPartition.setPartitionList(partList);
                        String partitionDetails = token;
                        if (Token.hasToken(partitionDetails, "LOB")) {
                            partitionDetails = Token.getStringBeforeToken(partitionDetails, "LOB");
                        }
                        if (partitionDetails.toUpperCase().indexOf("NESTED TABLE") > -1) {
                            partitionDetails = Token.getStringBefore(partitionDetails, "NESTED TABLE");
                        }
                        String beforeOverflow = partitionDetails;
                        if (Token.hasToken(partitionDetails, "OVERFLOW")) {
                            beforeOverflow = Token.getStringBeforeToken(partitionDetails, "OVERFLOW");
                        }
                        if (!(tsName = Token.getQuotedNameAfterToken(beforeOverflow, "TABLESPACE")).equals("")) {
                            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts != null) {
                                hashPartition.setTableSpace(ts);
                            }
                        }
                        this.initLobItems(token, hashPartition);
                    }
                } else if (Token.isTokenEqualTo(line, 1, "PARTITIONS")) {
                    TableSpaceOracle ts;
                    String tsName;
                    StringTokenizer tokenizer;
                    partList.setPartitionType("HASH BY QUANTITY");
                    line = Token.cutTokenFromFront(line, "PARTITIONS");
                    String quantityToken = Token.getFirstToken(line);
                    line = Token.cutTokenFromFront(line, quantityToken);
                    try {
                        int quantity = Integer.parseInt(quantityToken);
                        partList.setHashPQuantity(quantity);
                    }
                    catch (NumberFormatException e) {
                        this.importLog.addWarning("Wrong PARTITIONS format in statement " + this.statement);
                        LOGGER.error("wrong format in SHCreateTableOraclev9i.initPartitions : " + e.getMessage());
                    }
                    if (Token.startsWithString(line, "STORE IN")) {
                        String tableSpaces = Token.getValBetweenBrackets(line, 1);
                        line = Token.getValAfterBrackets(line, 1);
                        tokenizer = new StringTokenizer(tableSpaces, ",");
                        while (tokenizer.hasMoreTokens()) {
                            tsName = Token.getName(tokenizer.nextToken().trim());
                            ts = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts == null) continue;
                            partList.setHashPTableSpaces(ts.getObjectID());
                        }
                    }
                    if (Token.hasToken(line, "OVERFLOW") && Token.startsWithString(line = Token.getStringAfterToken(line, "OVERFLOW"), "STORE IN")) {
                        String tableSpaces = Token.getValBetweenBrackets(line, 1);
                        line = Token.getValAfterBrackets(line, 1);
                        tokenizer = new StringTokenizer(tableSpaces, ",");
                        while (tokenizer.hasMoreTokens()) {
                            tsName = Token.getName(tokenizer.nextToken().trim());
                            ts = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts == null) continue;
                            partList.setIOTOverflowHashPTSSet(ts.getObjectID());
                        }
                    }
                }
            } else if (partType.equalsIgnoreCase("LIST")) {
                partList.setPartitionType("LIST");
                if (Token.hasCloseAndOpenBrackets(line)) {
                    String partitions = Token.getValBetweenBrackets(line, 1).trim();
                    StringTokenizer st = new StringTokenizer(partitions, ",");
                    while (st.hasMoreTokens()) {
                        String partitionDetails;
                        String token = st.nextToken();
                        while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                            token = token + "," + st.nextToken();
                        }
                        if (!Token.hasToken(token, "PARTITION")) continue;
                        String afterPartition = Token.getStringAfter(token, "PARTITION");
                        String partName = Token.getFirstName(afterPartition, '\"', '\"');
                        ListPartitionOraclev9i partition = (ListPartitionOraclev9i)this.storageDesign.getListPartitionSet().createListPartition();
                        if (!partName.equalsIgnoreCase("VALUES")) {
                            partition.setName(partName);
                            if (afterPartition.startsWith("\"") && !partName.equals(partName.toUpperCase())) {
                                partition.setNameHasQuotes(true);
                            }
                        } else {
                            partition.setName("SYS_" + partition.getName());
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(partition);
                        partition.setPartitionList(partList);
                        if (Token.hasToken(token, "VALUES")) {
                            String values = Token.getStringAfter(token, "VALUES");
                            if ((values = Token.getValBetweenBrackets(values, 1).trim()).equalsIgnoreCase("DEFAULT")) {
                                partition.setColumns("DEFAULT");
                            } else {
                                partition.setColumns(values);
                            }
                        }
                        if (Token.hasToken(partitionDetails = token, "LOB")) {
                            partitionDetails = Token.getStringBeforeToken(partitionDetails, "LOB");
                        }
                        if (partitionDetails.toUpperCase().indexOf("NESTED TABLE") > -1) {
                            partitionDetails = Token.getStringBefore(partitionDetails, "NESTED TABLE");
                        }
                        String beforeOverflow = partitionDetails;
                        if (Token.hasToken(partitionDetails, "OVERFLOW")) {
                            beforeOverflow = Token.getStringBeforeToken(partitionDetails, "OVERFLOW");
                        }
                        this.initPartSegment(beforeOverflow, partition);
                        String tsName = Token.getQuotedNameAfterToken(beforeOverflow, "TABLESPACE");
                        if (!tsName.equals("")) {
                            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts != null) {
                                partition.setTablespace(ts);
                            }
                        }
                        if (Token.hasToken(partitionDetails, "LOGGING")) {
                            partition.setLogging("YES");
                        } else if (Token.hasToken(partitionDetails, "NOLOGGING")) {
                            partition.setLogging("NO");
                        } else {
                            partition.setLogging("");
                        }
                        if (Token.hasToken(partitionDetails, "COMPRESS")) {
                            partition.setDataSegmentCompression("YES");
                        } else if (Token.hasToken(partitionDetails, "NOCOMPRESS")) {
                            partition.setDataSegmentCompression("NO");
                        }
                        this.initLobStorages(token, partition);
                    }
                }
            }
            this.tableProxy.setPartitionList(partList);
        }
    }

    private String doSubPartByHash(String line, PartitionListOraclev9i partList) {
        block16: {
            block15: {
                line = Token.getStringAfter(line, "SUBPARTITION BY HASH");
                String subPartColumnList = Token.getValBetweenBrackets(line, 1);
                StringTokenizer subPartColumns = new StringTokenizer(subPartColumnList, ",");
                while (subPartColumns.hasMoreTokens()) {
                    partList.setSubPartitionsColumnList(Token.getName(subPartColumns.nextToken().trim()));
                }
                if (!Token.getFirstToken(line = Token.getValAfterBrackets(line, 1)).equalsIgnoreCase("SUBPARTITIONS")) break block15;
                line = Token.cutTokenFromFront(line, "SUBPARTITIONS");
                String quantityToken = Token.getFirstToken(line);
                line = Token.cutTokenFromFront(line, quantityToken);
                try {
                    int quantity = Integer.parseInt(quantityToken);
                    partList.setSubPartitionsQuantity(quantity);
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong SUBPARTITIONS format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateTableOracle.doSubPartByHash : " + e.getMessage());
                }
                if (!Token.startsWithString(line, "STORE IN")) break block16;
                String tableSpaces = Token.getValBetweenBrackets(line, 1);
                line = Token.getValAfterBrackets(line, 1);
                StringTokenizer tokenizer = new StringTokenizer(tableSpaces, ",");
                while (tokenizer.hasMoreTokens()) {
                    String tsName = Token.getName(tokenizer.nextToken().trim());
                    TableSpaceOracle ts = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(tsName);
                    if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                        ts = this.storageDesign.getTableSpaceSet().createTableSpace();
                        ts.setName(tsName);
                        this.design.getRelationalDesign().stampModelObjectDDL(ts);
                    }
                    if (ts == null) continue;
                    partList.setSubPartitionsTableSpaces(ts.getObjectID());
                }
                break block16;
            }
            if (Token.getFirstToken(line).equalsIgnoreCase("SUBPARTITION") && Token.getFirstToken(Token.cutTokenFromFront(line, "SUBPARTITION")).equalsIgnoreCase("TEMPLATE")) {
                partList.setUseSubpartStorageTemplate("YES");
                String templates = Token.getStringAfter(line, "TEMPLATE");
                if (!templates.startsWith("(")) {
                    String quantityToken = Token.getFirstToken(templates);
                    line = Token.cutTokenFromFront(templates, quantityToken);
                    try {
                        int quantity = Integer.parseInt(quantityToken);
                        partList.setSubPartitionsQuantity(quantity);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("wrong format in SHCreateTableOracle.doSubPartByHash : " + e.getMessage());
                        this.importLog.addWarning("Wrong SUBPARTITION TEMPLATE format in statement " + this.statement);
                    }
                } else {
                    String subPartitions = Token.getValBetweenBrackets(templates, 1).trim();
                    line = Token.getValAfterBrackets(templates, 1);
                    StringTokenizer st = new StringTokenizer(subPartitions, ",");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                            token = token + "," + st.nextToken();
                        }
                        if (!Token.hasToken(token, "SUBPARTITION")) continue;
                        String afterSubpartition = Token.getStringAfter(token, "SUBPARTITION");
                        String partName = Token.getFirstName(afterSubpartition, '\"', '\"');
                        HashPartitionOraclev9i partition = (HashPartitionOraclev9i)this.storageDesign.getHashPartitionSet().createHashPartition();
                        if (!(partName.equalsIgnoreCase("TABLESPACE") || partName.equalsIgnoreCase("OVERFLOW") || partName.equalsIgnoreCase("COMPRESS") || partName.equalsIgnoreCase("NOCOMPRESS") || partName.equalsIgnoreCase("LOB") || partName.equalsIgnoreCase("VARRAY"))) {
                            partition.setName(partName);
                            if (afterSubpartition.startsWith("\"") && !partName.equals(partName.toUpperCase())) {
                                partition.setNameHasQuotes(true);
                            }
                        } else {
                            partition.setName("SYS_" + partition.getName());
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(partition);
                        partition.setPartOfStorageTable(this.tableProxy);
                        this.initHashSubPartition(token, partition);
                    }
                }
            }
        }
        return line;
    }

    private void initHashSubPartition(String subPartBody, HashPartitionOraclev9i subPart) {
        String temp = subPartBody;
        while (Token.hasToken(temp, "TABLESPACE")) {
            if (Token.hasOpenBracketNoClose(Token.getStringBeforeToken(temp, "TABLESPACE"))) {
                temp = Token.getValAfterBrackets(temp, 1);
                continue;
            }
            String tsName = Token.getQuotedNameAfterToken(temp, "TABLESPACE");
            if (tsName.indexOf(",") > 0) {
                tsName = Token.getStringBefore(tsName, ",").trim();
            }
            if (!tsName.equals("")) {
                TableSpaceOracle ts = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(tsName);
                if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                    ts = this.storageDesign.getTableSpaceSet().createTableSpace();
                    ts.setName(tsName);
                    this.design.getRelationalDesign().stampModelObjectDDL(ts);
                }
                if (ts != null) {
                    if (Token.getTokenBefore(temp, "TABLESPACE").equalsIgnoreCase("OVERFLOW")) {
                        subPart.setIotOverflowTablespace(ts);
                    } else {
                        subPart.setTableSpace(ts);
                    }
                }
            }
            temp = Token.getStringAfterToken(temp, "TABLESPACE");
        }
        this.initLobItems(subPartBody, subPart);
    }

    private String doSubPartByList(String line, PartitionListOraclev9i partList) {
        line = Token.getStringAfter(line, "SUBPARTITION BY LIST");
        String subPartColumns = Token.getValBetweenBrackets(line, 1).trim();
        partList.setSubPartitionsColumnList(Token.getName(subPartColumns));
        line = Token.getValAfterBrackets(line, 1);
        if (Token.getFirstToken(line).equalsIgnoreCase("SUBPARTITION") && Token.getFirstToken(Token.cutTokenFromFront(line, "SUBPARTITION")).equalsIgnoreCase("TEMPLATE")) {
            partList.setUseSubpartStorageTemplate("YES");
            String templates = Token.getStringAfter(line, "TEMPLATE");
            String subPartitions = Token.getValBetweenBrackets(templates, 1).trim();
            line = Token.getValAfterBrackets(templates, 1);
            StringTokenizer st = new StringTokenizer(subPartitions, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                    token = token + "," + st.nextToken();
                }
                if (!Token.hasToken(token, "SUBPARTITION")) continue;
                String afterSubpartition = Token.getStringAfter(token, "SUBPARTITION");
                String partName = Token.getFirstName(afterSubpartition, '\"', '\"');
                ListStorageTemplatePartitionOraclev9i template = (ListStorageTemplatePartitionOraclev9i)this.storageDesign.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                if (!partName.equalsIgnoreCase("VALUES")) {
                    template.setName(partName);
                    if (afterSubpartition.startsWith("\"") && !partName.equals(partName.toUpperCase())) {
                        template.setNameHasQuotes(true);
                    }
                } else {
                    template.setName("SYS_" + template.getName());
                }
                this.design.getRelationalDesign().stampModelObjectDDL(template);
                template.setPartOfStorageTable(this.tableProxy);
                this.initListSubPartition(token, template);
            }
        }
        return line;
    }

    private void initListSubPartition(String subPartBody, ListStorageTemplatePartitionOraclev9i subPart) {
        String tsName;
        String beforeTablespace;
        if (Token.hasToken(subPartBody, "VALUES")) {
            String values = Token.getStringAfter(subPartBody, "VALUES");
            if ((values = Token.getValBetweenBrackets(values, 1).trim()).equalsIgnoreCase("DEFAULT")) {
                subPart.setValueList("DEFAULT");
            } else {
                subPart.setValueList(values);
            }
        }
        if ((beforeTablespace = Token.getStringBeforeToken(subPartBody, "TABLESPACE")).length() > 0 && !Token.endsWithOpenBracket(beforeTablespace) && !(tsName = Token.getQuotedNameAfterToken(subPartBody, "TABLESPACE")).equals("")) {
            TableSpaceOraclev9i ts;
            if (tsName.indexOf(",") > 0) {
                tsName = Token.getStringBefore(tsName, ",").trim();
            }
            if ((ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName)) == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                ts.setName(tsName);
                this.design.getRelationalDesign().stampModelObjectDDL(ts);
            }
            if (ts != null) {
                subPart.setTablespace(ts);
            }
        }
        this.initLobItems(subPartBody, subPart);
    }

    private void initLobItems(String lobString, StorageObject owningObject) {
        while (Token.hasToken(lobString, "LOB")) {
            String tableSpaceName;
            String lobLine = Token.getStringAfter(lobString, "LOB");
            String lobItemName = Token.getFirstName(Token.getValBetweenBrackets(lobLine, 1), '\"', '\"');
            HashPartitionLobItemOraclev9i lobItem = (HashPartitionLobItemOraclev9i)this.storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
            this.design.getRelationalDesign().stampModelObjectDDL(lobItem);
            if (owningObject instanceof HashPartitionOracle) {
                lobItem.setHashPartition((HashPartitionOracle)owningObject);
            } else if (owningObject instanceof ListStorageTemplatePartitionOracle) {
                lobItem.setListTemplatePartition((ListStorageTemplatePartitionOracle)owningObject);
            }
            lobItem.setLobColumn(this.tableProxy.getColumnProxyByName(lobItemName));
            lobLine = Token.getStringAfter(lobLine, "STORE AS");
            String lsName = Token.getFirstName(lobLine, '\"', '\"');
            int bracketIndex = lsName.indexOf("(");
            if (bracketIndex >= 0) {
                lsName = lsName.substring(0, bracketIndex);
            }
            if (lsName.length() > 0) {
                lobItem.setName(lsName);
            } else {
                lobItem.setName("SYS_" + lobItemName);
            }
            String beforeTS = Token.getStringBeforeToken(lobLine, "TABLESPACE");
            if (beforeTS.length() > 0 && !Token.hasToken(beforeTS, "LOB") && !(tableSpaceName = Token.getQuotedNameAfterToken(lobLine, "TABLESPACE")).equals("")) {
                TableSpaceOraclev9i tableSpace = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tableSpaceName);
                if (tableSpace == null && !"SYSTEM".equalsIgnoreCase(tableSpaceName)) {
                    tableSpace = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpace.setName(tableSpaceName);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
                }
                if (tableSpace != null) {
                    lobItem.setTableSpace(tableSpace);
                }
            }
            lobString = lobLine;
        }
    }

    private void doRangePartitions(String line, PartitionListOraclev9i partList) {
        String subPartitions = Token.getValBetweenBrackets(line, 1).trim();
        StringTokenizer st = new StringTokenizer(subPartitions, ",");
        int pos = 0;
        while (st.hasMoreTokens()) {
            String partitionDetails;
            ++pos;
            String token = st.nextToken();
            while (Token.hasOpenBracket(token) && st.hasMoreTokens()) {
                token = token + "," + st.nextToken();
            }
            if (!Token.hasToken(token, "PARTITION")) continue;
            String afterPartition = Token.getStringAfter(token, "PARTITION");
            String partName = Token.getFirstName(afterPartition, '\"', '\"');
            PartitionOraclev9i partition = (PartitionOraclev9i)this.storageDesign.getPartitionSet().createPartition();
            if (!partName.equalsIgnoreCase("VALUES")) {
                partition.setName(partName);
                if (afterPartition.startsWith("\"") && !partName.equals(partName.toUpperCase())) {
                    partition.setNameHasQuotes(true);
                }
            } else {
                partition.setName("SYS_" + partition.getName());
            }
            this.design.getRelationalDesign().stampModelObjectDDL(partition);
            partition.setPartitionList(partList);
            partition.setPosition(pos);
            token = Token.getStringAfter(token, "LESS THAN");
            String values = Token.getValBetweenBrackets(token, 1).trim();
            partition.setValueList(values);
            String beforeSubpartitions = token = Token.getValAfterBrackets(token, 1);
            if (Token.hasToken(token, "SUBPARTITION")) {
                beforeSubpartitions = Token.getStringBeforeToken(token, "SUBPARTITION");
            }
            if (Token.hasToken(partitionDetails = beforeSubpartitions, "LOB")) {
                partitionDetails = Token.getStringBeforeToken(partitionDetails, "LOB");
            }
            if (partitionDetails.toUpperCase().indexOf("NESTED TABLE") > -1) {
                partitionDetails = Token.getStringBefore(partitionDetails, "NESTED TABLE");
            }
            String beforeOverflow = partitionDetails;
            if (Token.hasToken(partitionDetails, "OVERFLOW")) {
                beforeOverflow = Token.getStringBeforeToken(partitionDetails, "OVERFLOW");
                this.initOverflowSegment(Token.getStringAfter(partitionDetails, "OVERFLOW"), partition);
            }
            this.initPartSegment(beforeOverflow, partition);
            String tsName = Token.getQuotedNameAfterToken(beforeOverflow, "TABLESPACE");
            if (!tsName.equals("")) {
                TableSpaceOraclev9i ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                    ts = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                    ts.setName(tsName);
                    this.design.getRelationalDesign().stampModelObjectDDL(ts);
                }
                if (ts != null) {
                    partition.setTableSpace(ts);
                }
            }
            if (Token.hasToken(partitionDetails, "LOGGING")) {
                partition.setLogging("YES");
            } else if (Token.hasToken(partitionDetails, "NOLOGGING")) {
                partition.setLogging("NO");
            } else {
                partition.setLogging("");
            }
            if (Token.hasToken(partitionDetails, "COMPRESS")) {
                partition.setDataSegmentCompression("YES");
            } else if (Token.hasToken(partitionDetails, "NOCOMPRESS")) {
                partition.setDataSegmentCompression("NO");
            }
            this.initLobStorages(beforeSubpartitions, partition);
            this.initSubPartitions(token, partition, partList.getPartitionType());
        }
    }

    private void initPartSegment(String line, ListPartitionOraclev9i partition) {
        SegmentOraclev9i segment = null;
        if ((Token.hasToken(line, "PCTFREE") || Token.hasToken(line, "PCTUSED") || Token.hasToken(line, "INITRANS") || Token.hasToken(line, "MAXTRANS") || Token.hasToken(line, "STORAGE")) && (segment = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(line, segment);
            this.initPctUsed(line, segment);
            this.initInitrans(line, segment);
            this.initMaxtrans(line, segment);
            this.initStorage(line, segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
            partition.setSegment(equalSegment);
        }
    }

    private void initPartSegment(String line, PartitionOraclev9i partition) {
        SegmentOraclev9i segment = null;
        if ((Token.hasToken(line, "PCTFREE") || Token.hasToken(line, "PCTUSED") || Token.hasToken(line, "INITRANS") || Token.hasToken(line, "MAXTRANS") || Token.hasToken(line, "STORAGE")) && (segment = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(line, segment);
            this.initPctUsed(line, segment);
            this.initInitrans(line, segment);
            this.initMaxtrans(line, segment);
            this.initStorage(line, segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
            partition.setSegment(equalSegment);
        }
    }

    private void initSubPartitions(String line, PartitionOraclev9i partition, String partType) {
        block17: {
            String temp;
            block16: {
                temp = line;
                if (!"COMPOSITE BY LIST".equalsIgnoreCase(partType)) break block16;
                while (Token.hasToken(temp, "SUBPARTITION")) {
                    temp = Token.getStringAfter(temp, "SUBPARTITION");
                    String subpartName = Token.getFirstName(temp, '\"', '\"');
                    String subPartBody = Token.getStringBeforeToken(temp, "SUBPARTITION");
                    if (subPartBody.length() == 0) {
                        subPartBody = temp;
                    }
                    ListStorageTemplatePartitionOraclev9i subpartition = (ListStorageTemplatePartitionOraclev9i)this.storageDesign.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(subpartition);
                    if (!subpartName.equalsIgnoreCase("VALUES")) {
                        subpartition.setName(subpartName);
                        if (temp.startsWith("\"") && !subpartName.equals(subpartName.toUpperCase())) {
                            subpartition.setNameHasQuotes(true);
                        }
                    } else {
                        subpartition.setName("SYS_" + subpartition.getName());
                    }
                    subpartition.setSubPartitionOf(partition);
                    this.initListSubPartition(subPartBody, subpartition);
                }
                break block17;
            }
            if (!"COMPOSITE BY HASH".equalsIgnoreCase(partType)) break block17;
            if (Token.hasToken(line, "SUBPARTITIONS")) {
                try {
                    int quantity = Integer.parseInt(Token.getTokenAfter(line, "SUBPARTITIONS").trim());
                    partition.setSubPartitionsQuantity(quantity);
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong SUBPARTITIONS format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateTableOraclev9i.initSubPartitions : " + e.getMessage());
                }
                String afterStoreIn = Token.getStringAfter(line, "STORE IN");
                String tableSpaces = Token.getValBetweenBrackets(afterStoreIn, 1);
                StringTokenizer st = new StringTokenizer(tableSpaces, ",");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken().trim();
                    TableSpaceOracle ts = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(name);
                    if (ts == null && !"SYSTEM".equalsIgnoreCase(name)) {
                        ts = this.storageDesign.getTableSpaceSet().createTableSpace();
                        ts.setName(name);
                        this.design.getRelationalDesign().stampModelObjectDDL(ts);
                    }
                    if (ts == null) continue;
                    partition.setSubPartitionsTableSpaces(ts.getObjectID());
                }
            } else {
                while (Token.hasToken(temp, "SUBPARTITION")) {
                    temp = Token.getStringAfter(temp, "SUBPARTITION");
                    String subpartName = Token.getFirstName(temp, '\"', '\"');
                    String subPartBody = Token.getStringBeforeToken(temp, "SUBPARTITION");
                    if (subPartBody.length() == 0) {
                        subPartBody = temp;
                    }
                    HashPartitionOraclev9i subpartition = (HashPartitionOraclev9i)this.storageDesign.getHashPartitionSet().createHashPartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(subpartition);
                    if (!(subpartName.equalsIgnoreCase("TABLESPACE") || subpartName.equalsIgnoreCase("OVERFLOW") || subpartName.equalsIgnoreCase("COMPRESS") || subpartName.equalsIgnoreCase("NOCOMPRESS") || subpartName.equalsIgnoreCase("LOB") || subpartName.equalsIgnoreCase("VARRAY"))) {
                        subpartition.setName(subpartName);
                        if (temp.startsWith("\"") && !subpartName.equals(subpartName.toUpperCase())) {
                            subpartition.setNameHasQuotes(true);
                        }
                    } else {
                        subpartition.setName("SYS_" + subpartition.getName());
                    }
                    subpartition.setSubPartitionOf(partition);
                    this.initHashSubPartition(subPartBody, subpartition);
                }
            }
        }
    }

    private void initLobStorages(String lobString, StorageObject owningObject) {
        while (Token.hasToken(lobString, "LOB")) {
            String params;
            String tsName;
            LobStorageOraclev9i lobStorage = (LobStorageOraclev9i)this.storageDesign.getLobStorageSet().createLobStorage();
            this.design.getRelationalDesign().stampModelObjectDDL(lobStorage);
            if (owningObject instanceof TableProxyOracle) {
                lobStorage.setTable((TableProxyOracle)owningObject);
            } else if (owningObject instanceof PartitionOracle) {
                lobStorage.setPartition((PartitionOracle)owningObject);
            } else if (owningObject instanceof ListPartitionOracle) {
                lobStorage.setListPartition((ListPartitionOracle)owningObject);
            }
            String temp = Token.getStringAfter(lobString, "LOB");
            String lobColumns = Token.getValBetweenBrackets(temp, 1).replaceAll("\"", "").trim();
            lobStorage.setColumn(lobColumns);
            temp = Token.getStringAfter(temp, "STORE AS");
            String lsName = Token.getFirstName(temp, '\"', '\"');
            int bracketIndex = lsName.indexOf("(");
            if (bracketIndex >= 0) {
                lsName = lsName.substring(0, bracketIndex);
            }
            if (lsName.length() > 0) {
                lobStorage.setLobSegmentName(lsName);
            }
            if (!(tsName = Token.getQuotedNameAfterToken(params = Token.getValBetweenBrackets(temp, 1).trim(), "TABLESPACE")).equals("")) {
                TableSpaceOraclev9i tableSpace = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(tsName);
                if (tableSpace == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                    tableSpace = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpace.setName(tsName);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
                }
                if (tableSpace != null) {
                    lobStorage.setTableSpace(tableSpace);
                }
            }
            this.initLobStorageStorage(params, lobStorage);
            lobString = temp;
        }
    }

    private void initOverflowSegment(String line, PartitionOraclev9i partition) {
        SegmentOraclev9i segment = null;
        if ((Token.hasToken(line, "PCTFREE") || Token.hasToken(line, "PCTUSED") || Token.hasToken(line, "INITRANS") || Token.hasToken(line, "MAXTRANS") || Token.hasToken(line, "STORAGE")) && (segment = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(line, segment);
            this.initPctUsed(line, segment);
            this.initInitrans(line, segment);
            this.initMaxtrans(line, segment);
            this.initStorage(line, segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
            partition.setIOTOverflowSegment(equalSegment);
        }
    }

    private void initLobStorageStorage(String line, LobStorageOraclev9i lobStorage) {
        String stLine;
        if (Token.hasToken(line, "STORAGE") && Token.getFirstToken(stLine = Token.getStringAfter(line, "STORAGE")).equalsIgnoreCase("(")) {
            stLine = Token.getValBetweenBrackets(stLine, 1).trim();
            this.initInitial(stLine, null, lobStorage, null);
            this.initNext(stLine, null, lobStorage, null);
            this.initPCtIncrease(stLine, null, lobStorage, null);
            this.initMinExtents(stLine, null, lobStorage, null);
            this.initMaxExtents(stLine, null, lobStorage, null);
            this.initFreeLists(stLine, null, lobStorage, null);
            this.initFreeListGroups(stLine, null, lobStorage, null);
            this.initSegBufferPool(stLine, null, lobStorage, null);
        }
        this.initChunk(line, lobStorage);
        this.initRetention(line, lobStorage);
        this.initPctVersion(line, lobStorage);
        this.initFreePools(line, lobStorage);
        this.initStorageInRow(line, lobStorage);
        this.initLSCache(line, lobStorage);
        this.initLogging(line, lobStorage);
    }

    private void initChunk(String line, LobStorageOraclev9i lobStorage) {
        if (Token.hasToken(line, "CHUNK")) {
            try {
                int value = Integer.parseInt(Token.getTokenAfter(line, "CHUNK").trim());
                lobStorage.setChunk(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong chunk format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initChunk : " + e.getMessage());
            }
        }
    }

    private void initRetention(String line, LobStorageOraclev9i lobStorage) {
        if (Token.hasToken(line, "RETENTION")) {
            lobStorage.setOldVersions("RETENTION");
        }
    }

    private void initFreePools(String line, LobStorageOraclev9i lobStorage) {
        if (Token.hasToken(line, "FREEPOOLS")) {
            try {
                int value = Integer.parseInt(Token.getTokenAfter(line, "FREEPOOLS").trim());
                lobStorage.setFreepools(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initFreePools : ", e);
            }
        }
    }

    private void initPctVersion(String line, LobStorageOraclev9i lobStorage) {
        if (Token.hasToken(line, "PCTVERSION")) {
            try {
                lobStorage.setOldVersions(LobStorageOracle.OLD_VERSIONS[1]);
                int value = Integer.parseInt(Token.getTokenAfter(line, "PCTVERSION").trim());
                lobStorage.setPCTVersion(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initPctVersion : " + e.getMessage());
            }
        }
    }

    private void initStorageInRow(String line, LobStorageOraclev9i lobStorage) {
        if (Token.hasString(line.toUpperCase(), "STORAGE IN ROW")) {
            String value = Token.getTokenBefore(line, "STORAGE IN ROW");
            lobStorage.setStorageInRow(value);
        }
    }

    private void initLSCache(String line, LobStorageOraclev9i lobStorage) {
        if (Token.hasToken(line, "CACHE")) {
            if (Token.hasString(line.toUpperCase(), "CACHE READS")) {
                lobStorage.setCache("CACHE READS");
            } else {
                lobStorage.setCache("CACHE");
            }
        } else if (Token.hasToken(line, "NOCACHE")) {
            lobStorage.setCache("NOCACHE");
        }
    }

    private void initLogging(String line, LobStorageOraclev9i lobStorage) {
        if (Token.hasToken(line, "NOLOGGING")) {
            lobStorage.setLogging("NO");
        } else if (Token.hasToken(line, "LOGGING")) {
            lobStorage.setLogging("YES");
        } else {
            lobStorage.setLogging("");
        }
    }

    private Table getReferencedTable(String reference) {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table tableReferenced = null;
        String tableName = reference;
        int dotIndex = reference.indexOf(46);
        if (dotIndex > -1) {
            String userName = reference.substring(0, dotIndex);
            tableName = reference.substring(dotIndex + 1);
            tableReferenced = tableSet.getBySchemaAndName(userName, tableName);
        }
        if (tableReferenced == null && (tableReferenced = (Table)tableSet.getByName(tableName)) == null) {
            this.importLog.addError("Table with name " + reference + " does not exist.");
        }
        return tableReferenced;
    }

    private void addForeignKey(String line, Table processedTable) {
        String nameFK = null;
        boolean nameHasQuotes = false;
        if (Token.hasToken(line, "CONSTRAINT")) {
            nameFK = Token.getStringAfterToken(line, "CONSTRAINT");
            nameHasQuotes = nameFK.startsWith("\"");
            nameFK = Token.getFirstName(nameFK, '\"', '\"');
        } else {
            nameFK = Token.getQuotedNameAfterToken(line, "KEY");
            int brpos = nameFK.indexOf("(");
            if (brpos > 0) {
                nameFK = nameFK.substring(0, brpos);
            } else if (brpos == 0) {
                nameFK = null;
            }
        }
        int positionBracket = line.indexOf(41);
        String firstBrackets = line.substring(0, positionBracket + 1).trim();
        String columns = Token.getValBetweenBrackets(firstBrackets);
        List columnNames = this.getColumnNames(columns);
        ArrayList<Column> columnsRef = new ArrayList<Column>();
        Column[] columnSet = (Column[])processedTable.getElements();
        for (String name : columnNames) {
            for (int ci = 0; ci < columnSet.length; ++ci) {
                String colname = columnSet[ci].getName().trim();
                if (!name.equalsIgnoreCase(colname)) continue;
                columnsRef.add(columnSet[ci]);
            }
        }
        String nameReferenced = Token.getFirstName(line = Token.getStringAfterToken(line, "REFERENCES"), '\"', '\"');
        Table tableRef = this.getReferencedTable(nameReferenced);
        if (tableRef != null) {
            Index index = null;
            boolean hasBrackets = Token.hasString(line, "(");
            if (hasBrackets) {
                String columnsReferenced = Token.getValBetweenBrackets(line, 1);
                List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                index = this.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
            } else {
                index = (Index)tableRef.getPK();
            }
            if (index != null) {
                FKProxyOracle fkProxy;
                FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                FKIndexAssociation fkass = processedTable.addFK(index, null, reference);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                KeyObject fkIndex = fkass.getLocalFKIndex();
                if (nameFK != null) {
                    fkass.setName(nameFK);
                    fkIndex.setName(nameFK);
                    if (nameHasQuotes && !nameFK.equals(nameFK.toUpperCase())) {
                        fkIndex.setNameHasQuotes(true);
                    }
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                String onDelete = Token.getStringAfter(line, "ON DELETE").toUpperCase();
                if (onDelete.length() > 0 && (onDelete = onDelete.startsWith("CASCADE") ? "CASCADE" : (onDelete.startsWith("SET NULL") ? "SET NULL" : null)) != null) {
                    fkass.setDeleteRule(onDelete);
                }
                if ((fkProxy = (FKProxyOracle)this.storageDesign.getFKProxySet().getProxy(fkIndex.getObjectID())) != null) {
                    String exTableName;
                    Table exTable;
                    String str;
                    if (Token.hasToken(line, "DEFERRABLE") && !(str = Token.getTokenBefore(line, "DEFERRABLE")).equalsIgnoreCase("NOT")) {
                        fkProxy.setDeferrable("YES");
                    }
                    if ((str = Token.getStringAfter(line, "INITIALLY")).length() > 0) {
                        String initially = Token.getFirstToken(str);
                        fkProxy.setInitially(initially.toUpperCase());
                    }
                    if (Token.hasToken(line, "DISABLE")) {
                        fkProxy.setEnable("NO");
                        if (!Token.hasToken(line, "VALIDATE")) {
                            fkProxy.setValidate("NO");
                        }
                    }
                    if (Token.hasToken(line, "NOVALIDATE")) {
                        fkProxy.setValidate("NO");
                    }
                    if ((str = Token.getStringAfter(line, "EXCEPTIONS")).length() > 0 && (exTable = this.getReferencedTable(exTableName = Token.getNameAfterToken(str, "INTO", '\"', '\"'))) != null) {
                        fkProxy.setExceptionsTable((TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(exTable.getObjectID()));
                    }
                }
            }
        }
    }

    private List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String token = tokColumns.nextToken().trim();
            token = Token.removeQuotes(token);
            columns.add(token.trim());
        }
        return columns;
    }

    private void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            if (column.isPartOfFKIndexAssociation(fkAss)) continue;
            Column indexColumn = (Column)index.getElements()[p];
            fkAss.swapAndRemoveFKColumn(indexColumn, column, pkCol[p]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    Column getColumnByName(Table processedTable, String columnName) {
        Column[] cols = (Column[])processedTable.getElements();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].getName().equalsIgnoreCase(columnName)) continue;
            return cols[i];
        }
        return null;
    }

    private void processRefAtColumn(RefAtColNode refNode, Table processedTable) {
        Table referencedtable = this.getReferencedTable(refNode.referencedTable);
        if (referencedtable != null) {
            Index indexOfreference;
            ArrayList<String> refColName = new ArrayList<String>();
            if (refNode.refColumn != null) {
                refColName.add(refNode.refColumn);
                indexOfreference = this.getUniqueIndexForColumnNames(referencedtable, refColName);
            } else {
                indexOfreference = (Index)referencedtable.getPK();
            }
            if (indexOfreference != null) {
                FKIndexAssociation fk = processedTable.addFK(indexOfreference);
                this.design.getRelationalDesign().stampModelObjectDDL(fk);
                KeyObject fkIndex = fk.getLocalFKIndex();
                if (refNode.constraintName != null) {
                    fk.setName(refNode.constraintName);
                    fkIndex.setName(refNode.constraintName);
                    if (refNode.constraintNameQuoted && !refNode.constraintName.equals(refNode.constraintName.toUpperCase())) {
                        fkIndex.setNameHasQuotes(true);
                    }
                }
                ArrayList<Column> columnsRef = new ArrayList<Column>();
                Column column = this.getColumnByName(processedTable, refNode.columnName);
                if (column != null) {
                    FKProxyOracle fkProxy;
                    columnsRef.add(column);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fk, columnsRef, indexOfreference);
                    } else {
                        this.fixFKColumns(fk, columnsRef, indexOfreference);
                    }
                    if (refNode.onDelete != null) {
                        fk.setDeleteRule(refNode.onDelete.toUpperCase());
                    }
                    if ((fkProxy = (FKProxyOracle)this.storageDesign.getFKProxySet().getProxy(fkIndex.getObjectID())) != null) {
                        Table exTable;
                        if (refNode.deferrable) {
                            fkProxy.setDeferrable("YES");
                        }
                        if (refNode.initially != null) {
                            fkProxy.setInitially(refNode.initially.toUpperCase());
                        }
                        if (refNode.disable) {
                            fkProxy.setEnable("NO");
                        }
                        if (refNode.novalidate) {
                            fkProxy.setValidate("NO");
                        }
                        if (refNode.exceptions != null && (exTable = this.getReferencedTable(refNode.exceptions)) != null) {
                            fkProxy.setExceptionsTable((TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(exTable.getObjectID()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode node : this.tableNodeList) {
            if (node.fkStatements != null) {
                for (String line : node.fkStatements) {
                    this.addForeignKey(line, node.processedTable);
                }
            }
            if (node.refAtColumns == null) continue;
            Iterator itcolref = node.refAtColumns.iterator();
            while (itcolref.hasNext()) {
                this.processRefAtColumn((RefAtColNode)itcolref.next(), node.processedTable);
            }
        }
    }

    private void parseLine(String line) {
        ColumnProxyOraclev9i columnProxy;
        String colname = Token.getFirstName(line, '\"', '\"');
        if (colname != null && (columnProxy = (ColumnProxyOraclev9i)this.tableProxy.getColumnProxyByName(colname)) != null) {
            this.initSubstitutableColumnClause(line, columnProxy);
            if (Token.hasString(line.toUpperCase(), "STORE AS")) {
                if (Token.hasString(line.toUpperCase(), "STORE AS LOB")) {
                    String afterLob = Token.getStringAfter(line, "STORE AS LOB");
                    if (!afterLob.equals("") && !afterLob.startsWith("(")) {
                        columnProxy.setLobSegname(Token.getFirstName(afterLob, '\"', '\"'));
                    }
                } else {
                    String afterReturn;
                    String afterStoreAs = Token.getStringAfter(line, "STORE AS");
                    columnProxy.setNtStorageTable(Token.getFirstName(afterStoreAs, '\"', '\"'));
                    if (Token.hasCloseAndOpenBrackets(afterStoreAs)) {
                        String additionalNTS = Token.getValBetweenBrackets(afterStoreAs, 1).trim();
                        columnProxy.setAdditionalNTS(additionalNTS);
                    }
                    if (!(afterReturn = Token.getStringAfter(line, "RETURN")).isEmpty()) {
                        String nReturn = Token.getFirstToken(afterReturn);
                        if (nReturn.equalsIgnoreCase("AS")) {
                            afterReturn = Token.cutTokenFromFront(afterReturn, "AS");
                            nReturn = Token.getFirstToken(afterReturn);
                        }
                        columnProxy.setNtReturn(nReturn.toUpperCase());
                    }
                }
            }
        }
    }

    private void initSubstitutableColumnClause(String state) {
        ColumnProxyOraclev9i columnProxy;
        String colname = Token.getFirstName(state, '\"', '\"');
        if (colname != null && (columnProxy = (ColumnProxyOraclev9i)this.tableProxy.getColumnProxyByName(colname)) != null) {
            this.initSubstitutableColumnClause(state, columnProxy);
        }
    }

    private void initSubstitutableColumnClause(String state, ColumnProxyOraclev9i columnProxy) {
        String betweenBrackets;
        if (Token.hasToken(state, "SUBSTITUTABLE")) {
            if (Token.hasString(state.toUpperCase(), "NOT SUBSTITUTABLE")) {
                Column column = (Column)columnProxy.getObject();
                column.setAllowSubtypeSubstitution(false);
                columnProxy.setSubtitutable("NO");
            } else {
                columnProxy.setSubtitutable("YES");
            }
        } else if (Token.hasCloseAndOpenBrackets(state) && Token.hasToken(betweenBrackets = Token.getValBetweenBrackets(state, 1), "ONLY")) {
            String type = Token.getQuotedNameAfterToken(betweenBrackets, "ONLY");
            columnProxy.setElementType(type);
            Column column = (Column)columnProxy.getObject();
            column.setAllowSubtypeSubstitution(true);
            if (!column.getDataType().equals(type)) {
                columnProxy.setSubtitutable("ONLY FOR TYPE");
            } else {
                columnProxy.setSubtitutable("YES");
            }
        }
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String constraintName;
        String referencedTable;
        String refColumn;
        String onDelete;
        boolean constraintNameQuoted;
        boolean deferrable;
        String initially;
        boolean disable;
        boolean novalidate;
        String exceptions;

        RefAtColNode() {
        }
    }
}

