/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHGrantPermissionsSqlServer
extends DDLStatementHandlerSqlServer {
    private PermissionsSqlServer permissions;
    private StorageDesignSqlServerv2k storageDesign;
    private TableProxySqlServer table = null;
    private TableViewProxySqlServer view = null;
    private DataBaseSqlServer db = null;
    private static final Logger LOGGER = new Logger(SHGrantPermissionsSqlServer.class);

    public SHGrantPermissionsSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHGrantPermissionsSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "GRANT") && Token.hasToken(statement, "ON")) {
            try {
                this.grantPermissions(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHGrantPermissionsSqlServer.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void grantPermissions(String statement) {
        this.statement = statement.replaceAll("\"", "");
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            RelationalObjectProxy proxy = this.initOn();
            ArrayList users = this.initUsersAndRoles();
            if (proxy != null) {
                for (int i = 0; i < users.size(); ++i) {
                    if (this.getPermissionForUser((StorageObject)users.get(i), proxy) != null) {
                        this.permissions = this.getPermissionForUser((StorageObject)users.get(i), proxy);
                    } else {
                        this.permissions = this.storageDesign.getPermissionsSet().createPermissions();
                        this.design.getRelationalDesign().stampModelObjectDDL(this.permissions);
                    }
                    if (this.permissions == null) continue;
                    this.initPrivileges();
                    this.initOnObject(proxy);
                    this.initTo(users.get(i));
                    this.initAs();
                }
            }
        }
    }

    private PermissionsSqlServer getPermissionForUser(StorageObject user, RelationalObjectProxy proxy) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        PermissionsSqlServer perm = null;
        while (it.hasNext()) {
            perm = (PermissionsSqlServer)it.next();
            if (perm.getUser() != user && perm.getRole() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
            return perm;
        }
        return null;
    }

    private ArrayList initUsersAndRoles() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        String to = Token.getStringAfter(this.statement, "TO").trim();
        if (to.toLowerCase().indexOf(" as ") > -1) {
            to = Token.getStringBefore(to, "AS").trim();
        }
        if (to.toLowerCase().indexOf(" with ") > -1) {
            to = Token.getStringBefore(to, "WITH").trim();
        }
        if (!to.equalsIgnoreCase("")) {
            StringTokenizer tokenizer = new StringTokenizer(to, ",");
            String userOrRole = null;
            if (this.table != null) {
                this.db = this.table.getDatabase();
            } else if (this.view != null) {
                this.db = this.view.getDataBase();
            }
            if (this.db != null) {
                while (tokenizer.hasMoreTokens()) {
                    userOrRole = tokenizer.nextToken().trim();
                    userOrRole = Token.getValBetweenSquareBrackets(userOrRole);
                    StorageObjectCollection users = this.db.getUsers();
                    StorageObjectCollection roles = this.db.getRoles();
                    if (users.getByName(userOrRole) != null) {
                        list.add(users.getByName(userOrRole));
                        continue;
                    }
                    if (roles.getByName(userOrRole) == null) continue;
                    list.add(roles.getByName(userOrRole));
                }
            }
        }
        return list;
    }

    private void initPrivileges() {
        StringTokenizer tokenizer;
        String priv = Token.getStringAfter(this.statement.toUpperCase(), "GRANT");
        if (Token.hasCloseAndOpenBrackets(priv = Token.getStringBefore(priv, "ON").trim())) {
            String columns = Token.getValBetweenBrackets(priv).trim();
            priv = Token.getStringBefore(priv, "(").trim();
            this.initColumns(columns, priv);
        }
        if (this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1) {
            tokenizer = new StringTokenizer(priv, ",");
            String pr = null;
            while (tokenizer.hasMoreTokens()) {
                pr = tokenizer.nextToken().trim();
                this.permissions.setPrivilegesWithGrantOption(pr);
            }
        } else {
            tokenizer = new StringTokenizer(priv, ",");
            String pr = null;
            while (tokenizer.hasMoreTokens()) {
                pr = tokenizer.nextToken().trim();
                this.permissions.setPrivileges(pr);
            }
        }
    }

    private void initColumns(String columns, String priv) {
        StringTokenizer tokenizer = new StringTokenizer(columns, ",");
        String column = null;
        while (tokenizer.hasMoreTokens()) {
            column = tokenizer.nextToken().trim();
            if ((column.equalsIgnoreCase("") || this.table == null || this.table.getColumnProxyByName(column) == null) && (this.view == null || this.view.getColumnProxyByName(column) == null)) continue;
            column = column + ", " + priv;
            this.permissions.setColumnList(column);
        }
    }

    private RelationalObjectProxy initOn() {
        String on = Token.getStringAfterToken(this.statement, "ON").trim();
        on = Token.getStringBefore(on, "TO").trim();
        if (!(on = Token.getValBetweenSquareBrackets(on)).equalsIgnoreCase("")) {
            this.table = ((TableProxySetSqlServer)this.storageDesign.getTableProxySet()).getByName(on);
            if (this.table != null) {
                return this.table;
            }
            this.view = ((TableViewProxySetSqlServer)this.storageDesign.getTableViewProxySet()).getByName(on);
            if (this.view != null) {
                return this.view;
            }
        }
        LOGGER.error("SHGrantPermissionsSqlServer.initOn(): wrong syntax!");
        this.importLog.addError("Error in setting object of permission " + this.statement);
        return null;
    }

    private void initOnObject(RelationalObjectProxy proxy) {
        if (proxy instanceof TableProxySqlServer) {
            this.permissions.setTable((TableProxySqlServer)proxy);
        } else if (proxy instanceof TableViewProxySqlServer) {
            this.permissions.setView((TableViewProxySqlServer)proxy);
        }
    }

    private void initTo(Object object) {
        String to = Token.getStringAfter(this.statement.toUpperCase(), "TO").trim();
        if (to.toLowerCase().indexOf(" as ") > -1) {
            to = Token.getStringBefore(to, "AS").trim();
        }
        if (!to.equalsIgnoreCase("")) {
            if (this.table != null) {
                this.db = this.table.getDatabase();
            } else if (this.view != null) {
                this.db = this.view.getDataBase();
            }
            if (this.db != null) {
                if (object instanceof UserSqlServer) {
                    this.permissions.setUser((UserSqlServer)object);
                } else if (object instanceof RoleSqlServer) {
                    this.permissions.setRole((RoleSqlServer)object);
                }
            }
        } else {
            LOGGER.error("SHGrantPrivilegesSqlServer.initTo(): wrong syntax!");
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }

    private void initAs() {
        if (this.statement.toLowerCase().indexOf(" as ") > -1) {
            StorageObjectCollection roles;
            String role = Token.getStringAfter(this.statement.toUpperCase(), "AS").trim();
            role = Token.getValBetweenSquareBrackets(role);
            if (this.db != null && (roles = this.db.getRoles()).getByName(role) != null) {
                this.permissions.setAsRole((RoleSqlServer)roles.getByName(role));
            }
        }
    }
}

