/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateAliasUDB
extends DDLStatementHandler {
    private String schemaName = null;
    private static final Logger LOGGER = new Logger(SHCreateAliasUDB.class);

    public SHCreateAliasUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateAliasUDB.clearCR(line);
        if (Token.startsWithString(statement, "create alias") || Token.startsWithString(statement, "create synonym")) {
            try {
                this.parseAlias(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateAliasUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseAlias(String statement) {
        this.statement = statement;
        String aliasName = this.initAliasName();
        String refObjName = this.getNameOnly(Token.getTokenAfter(this.statement, "FOR").trim());
        Table table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(refObjName);
        TableView view = null;
        if (table == null) {
            view = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(refObjName);
        }
        if (table != null || view != null) {
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
            AliasUDB alias = storageDesign.getAliasSet().createAlias();
            alias.setName(aliasName);
            this.design.getRelationalDesign().stampModelObjectDDL(alias);
            this.initSchema(alias, storageDesign);
            if (table != null) {
                TableProxyUDB tableProxy = (TableProxyUDB)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                alias.setReferencedObject(tableProxy);
            } else if (view != null) {
                TableViewProxyUDB tableViewProxy = (TableViewProxyUDB)storageDesign.getTableViewProxySet().getProxy(view.getObjectID());
                alias.setReferencedObject(tableViewProxy);
            }
        } else {
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
            AliasUDB alias = storageDesign.getAliasSet().createAlias();
            alias.setName(aliasName);
            this.design.getRelationalDesign().stampModelObjectDDL(alias);
            this.initSchema(alias, storageDesign);
            SchemaUDB schema = (SchemaUDB)storageDesign.getSchemaSet().getByName(refObjName);
            if (schema != null) {
                alias.setReferencedObject(schema);
            } else {
                AliasUDB anotherAlias = (AliasUDB)storageDesign.getAliasSet().getByName(refObjName);
                if (anotherAlias != null) {
                    alias.setReferencedObject(anotherAlias);
                }
            }
        }
    }

    private String initAliasName() {
        String name = Token.getTokenAfter(this.statement, "ALIAS").trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.schemaName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "ALIAS"), '.');
            name = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "ALIAS"), '.');
        }
        return name;
    }

    private void initSchema(AliasUDB alias, StorageDesignUDB storageDesign) {
        SchemaUDB schema;
        if (this.schemaName != null && (schema = (SchemaUDB)storageDesign.getSchemaSet().getByName(this.schemaName)) != null) {
            alias.setSchema(schema);
        }
    }
}

