/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DataBaseUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseUDBv81
extends DDLStatementHandler {
    private DataBaseUDBv81 database;
    private static final Logger LOGGER = new Logger(SHCreateDatabaseUDBv81.class);

    public SHCreateDatabaseUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDatabaseUDBv81.clearCR(line);
        if ((Token.startsWithString(statement, "create database") || Token.startsWithString(statement, "create db ")) && !Token.startsWithString(statement, "create database partition group")) {
            try {
                this.parseDatabase(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB 8.1 failed!", e);
                this.importLog.addFailedStatement(SHCreateDatabaseUDBv81.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseDatabase(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDBv81 stoDesign = (StorageDesignUDBv81)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            this.database = (DataBaseUDBv81)stoDesign.getDataBaseSet().createDataBase();
            String nameDB = this.initDatabaseName();
            this.database.setName(nameDB);
            this.initAutomaticStorage();
            this.initOnPath();
            this.initAlias();
            this.initCodeSet();
            this.initTerritory();
            this.initCollate();
            this.initNumSegs();
            this.initDFTExtentSize();
            this.initCatalogTableSpace();
            this.initUserTableSpace();
            this.initTempTableSpace();
            this.initWith();
            this.initAutoConfigure();
            this.design.getRelationalDesign().stampModelObjectDDL(this.database);
        }
    }

    private String initDatabaseName() {
        return Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
    }

    private void initAutomaticStorage() {
        if (Token.hasToken(this.statement, "AUTOMATIC") && Token.hasToken(this.statement, "STORAGE")) {
            String autoStorage = Token.getTokenAfter(this.statement, "STORAGE");
            this.database.setAutomaticStorage(autoStorage);
        }
    }

    private void initOnPath() {
        if (Token.hasToken(this.statement, "ON")) {
            String nextToken;
            StringBuffer buf = new StringBuffer(Token.getTokenAfter(this.statement, "ON"));
            String pathsEtc = Token.getStringAfterToken(this.statement, "ON");
            while (buf.toString().endsWith(",")) {
                pathsEtc = pathsEtc.substring(pathsEtc.indexOf(",") + 1);
                String nextPath = Token.getFirstToken(pathsEtc);
                buf.append(' ').append(nextPath);
            }
            this.database.setOnPath(buf.toString());
            if (Token.hasToken(pathsEtc, "DBPATH") && (nextToken = Token.getTokenAfter(pathsEtc, "DBPATH")).equals("ON")) {
                String dbPath = Token.getTokenAfter(pathsEtc, "ON");
                this.database.setDBPathOn(dbPath);
            }
        }
    }

    private void initAlias() {
        if (Token.hasToken(this.statement, "ALIAS")) {
            String alias = Token.getTokenAfter(this.statement, "ALIAS");
            this.database.setAlias(alias);
        }
    }

    private void initCodeSet() {
        if (Token.hasToken(this.statement, "CODESET")) {
            String codeSet = Token.getTokenAfter(this.statement, "CODESET");
            this.database.setCodeSet(codeSet);
        }
    }

    private void initTerritory() {
        if (Token.hasToken(this.statement, "TERRITORY")) {
            String territory = Token.getTokenAfter(this.statement, "TERRITORY");
            this.database.setTerritory(territory);
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String collate = Token.getStringAfterToken(this.statement, "COLLATE");
            collate = Token.getTokenAfter(collate, "USING");
            String[] colSeq = DataBaseUDBv81.getAvailableCollatingSequences();
            for (int i = 0; i < colSeq.length; ++i) {
                if (!colSeq[i].equalsIgnoreCase(collate)) continue;
                this.database.setCollatingSequence(colSeq[i]);
                break;
            }
        }
    }

    private void initNumSegs() {
        if (Token.hasToken(this.statement, "NUMSEGS")) {
            try {
                int numSegs = Integer.parseInt(Token.getTokenAfter(this.statement, "NUMSEGS"));
                this.database.setSegmentNumber(numSegs);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong NUMSEGS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initNumSegs : " + e.getMessage());
            }
        }
    }

    private void initDFTExtentSize() {
        if (Token.hasToken(this.statement, "DFT_EXTENT_SZ")) {
            try {
                int dftExtSize = Integer.parseInt(Token.getTokenAfter(this.statement, "DFT_EXTENT_SZ"));
                this.database.setDefaultExtentSize(dftExtSize);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong DFT_EXTENT_SZ format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initDFTExtentSize : " + e.getMessage());
            }
        }
    }

    private void initCatalogTableSpace() {
        if (Token.hasToken(this.statement, "CATALOG")) {
            String part = this.statement.substring(this.statement.indexOf("CATALOG") + "CATALOG".length()).trim();
            TableSpaceUDB tableSpace = ((StorageDesignUDBv81)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            this.database.setCatalogTableSpace(tableSpace);
            tableSpace.setName("CatalogTS_For_" + this.database.getName());
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
            if (Token.hasToken(part, "USER")) {
                part = part.substring(0, part.indexOf("USER")).trim();
            } else if (Token.hasToken(part, "TEMPORARY")) {
                part = part.substring(0, part.indexOf("TEMPORARY")).trim();
            }
            this.initTableSpaceOptions(part, tableSpace);
        }
    }

    private void initUserTableSpace() {
        if (Token.hasToken(this.statement, "USER")) {
            String part = this.statement.substring(this.statement.indexOf("USER") + "USER".length()).trim();
            TableSpaceUDB tableSpace = ((StorageDesignUDBv81)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            this.database.setUserTableSpace(tableSpace);
            tableSpace.setName("UserTS_For_" + this.database.getName());
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
            if (Token.hasToken(part, "TEMPORARY")) {
                part = part.substring(0, part.indexOf("TEMPORARY")).trim();
            }
            this.initTableSpaceOptions(part, tableSpace);
        }
    }

    private void initTempTableSpace() {
        if (Token.hasToken(this.statement, "TEMPORARY")) {
            String part = this.statement.substring(this.statement.indexOf("TEMPORARY") + "TEMPORARY".length()).trim();
            TableSpaceUDB tableSpace = ((StorageDesignUDBv81)this.database.getStorageDesign()).getTableSpaceSet().createTableSpace();
            tableSpace.setName("TempTS_For_" + this.database.getName());
            this.database.setTemporaryTableSpace(tableSpace);
            this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
            this.initTableSpaceOptions(part, tableSpace);
        }
    }

    private void initTableSpaceOptions(String part, TableSpaceUDB tableSpace) {
        String dropped;
        tableSpace.setDBDefOnly(true);
        if (Token.hasToken(part, "BY")) {
            String managedBy = Token.getTokenAfter(part, "BY").trim();
            tableSpace.setManagedBy(managedBy);
        }
        if (Token.hasToken(part, "USING") && Token.getTokenAfter(part, "USING").trim().startsWith("(")) {
            String temp = part;
            while (temp.indexOf("USING") > -1 && Token.getTokenAfter(part, "USING").trim().startsWith("(")) {
                String val = Token.getValBetweenBrackets(temp, 1);
                temp = Token.getValAfterBrackets(temp, 1);
                ContainerUDB container = ((StorageDesignUDB)tableSpace.getStorageDesign()).getContainerSet().createContainer();
                this.design.getRelationalDesign().stampModelObjectDDL(container);
                if (container == null) continue;
                container.setTableSpace(tableSpace);
                container.setContainers(val);
            }
        }
        if (Token.hasToken(part, "EXTENTSIZE")) {
            tableSpace.setExtentSize(Token.getTokenAfter(part, "EXTENTSIZE"));
        }
        if (Token.hasToken(part, "PREFETCHSIZE")) {
            tableSpace.setPrefetchSize(Token.getTokenAfter(part, "PREFETCHSIZE"));
        }
        if (Token.hasToken(part, "OVERHEAD")) {
            try {
                float overhead = Float.parseFloat(Token.getTokenAfter(part, "OVERHEAD"));
                tableSpace.setOverhead(overhead);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong OVERHEAD format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initTableSpaceOptions : " + e.getMessage());
            }
        }
        if (Token.hasToken(part, "TRANSFERRATE")) {
            try {
                float transferRate = Float.parseFloat(Token.getTokenAfter(part, "TRANSFERRATE"));
                tableSpace.setTransferRate(transferRate);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong TRANSFERRATE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateDatabaseUDB.initTableSpaceOptions : " + e.getMessage());
            }
        }
        if (Token.hasToken(part, "RECOVERY") && "ON".equalsIgnoreCase(dropped = Token.getTokenAfter(part, "RECOVERY").trim())) {
            tableSpace.setDroppedTableRecovery(true);
        }
    }

    private void initWith() {
        if (Token.hasToken(this.statement, "WITH")) {
            String comment = Token.getStringAfterToken(this.statement, "WITH");
            if (!"".equalsIgnoreCase(comment = Token.getValBetweenDoubleQuotes(comment))) {
                this.database.setCommentInRDBMS(comment);
            }
        }
    }

    private void initAutoConfigure() {
        if (Token.hasToken(this.statement, "AUTOCONFIGURE")) {
            this.database.setAutoConfigure(true);
            String options = Token.getStringAfterToken(this.statement, "AUTOCONFIGURE");
            if (Token.hasToken(this.statement, "APPLY")) {
                options = Token.getStringBefore(this.statement, "APPLY");
                String apply = Token.getStringAfterToken(this.statement, "APPLY");
                if (apply.toUpperCase().indexOf("DB ONLY") > -1) {
                    this.database.setApplyChanges("DB ONLY");
                } else if (apply.toUpperCase().indexOf("DB AND DBM") > -1) {
                    this.database.setApplyChanges("DB AND DBM");
                } else if (apply.toUpperCase().indexOf("NONE") > -1) {
                    this.database.setApplyChanges("NONE");
                }
            }
            String option = "";
            if (Token.hasToken(options, "mem_percent")) {
                this.database.setUseMemPercent(true);
                option = Token.getTokenAfter(options, "mem_percent");
                try {
                    this.database.setMemPercent(Integer.parseInt(option));
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong MEM_PERCENT format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near MEM_PERCENT: " + e.getMessage());
                }
            }
            if (Token.hasToken(options, "workload_type")) {
                this.database.setUseWorkloadType(true);
                option = Token.getTokenAfter(options, "workload_type");
                this.database.setWorkloadType(option);
            }
            if (Token.hasToken(options, "num_stmts")) {
                this.database.setUseNumStmts(true);
                option = Token.getTokenAfter(options, "num_stmts");
                try {
                    this.database.setNumStmts(Integer.parseInt(option));
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong NUM_STMTS format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near NUM_STMTS: " + e.getMessage());
                }
            }
            if (Token.hasToken(options, "tpm")) {
                this.database.setUseTpm(true);
                option = Token.getTokenAfter(options, "tpm");
                try {
                    this.database.setTpm(Integer.parseInt(option));
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong TRM format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near TPM: " + e.getMessage());
                }
            }
            if (Token.hasToken(options, "admin_property")) {
                this.database.setUseAdminProperty(true);
                option = Token.getTokenAfter(options, "admin_property");
                this.database.setAdminProperty(option);
            }
            if (Token.hasToken(options, "num_local_apps")) {
                this.database.setUseNumLocalApps(true);
                option = Token.getTokenAfter(options, "num_local_apps");
                try {
                    this.database.setNumLocalApps(Integer.parseInt(option));
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong NUM_LOCAL_APPS format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near NUM_LOCAL_APPS: " + e.getMessage());
                }
            }
            if (Token.hasToken(options, "num_remote_apps")) {
                this.database.setUseNumRemoteApps(true);
                option = Token.getTokenAfter(options, "num_remote_apps");
                try {
                    this.database.setNumRemoteApps(Integer.parseInt(option));
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong NUM_REMOTE_APPS format in statement " + this.statement);
                    LOGGER.error("Wrong syntax near NUM_REMOTE_APPS: " + e.getMessage());
                }
            }
            if (Token.hasToken(options, "isolation")) {
                this.database.setUseIsolation(true);
                option = Token.getTokenAfter(options, "isolation");
                this.database.setIsolation(option);
            }
            if (Token.hasToken(options, "bp_resizeable")) {
                this.database.setUseBpResizeable(true);
                option = Token.getTokenAfter(options, "bp_resizeable");
                this.database.setBpResizeable(option);
            }
        }
    }
}

