/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.udb.AggregateFunctionsUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTableUDB;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHColumnElementsUDBv81;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StagingTableUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.ColumnProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxySetUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceSetUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTableUDBv81
extends DDLStatementHandler
implements SectionConstants,
CreateTableHandler {
    private Table table = null;
    private RDBMSSite site = null;
    private StorageDesignUDBv81 storageDesign = null;
    private TableProxyUDBv81 tableProxy = null;
    private boolean createDomainsDuringImport;
    private String tableName;
    private String ownerName = null;
    private ArrayList columns;
    protected List fkList;
    protected List refAtColumnList;
    protected List tableNodeList = new ArrayList();
    private boolean dataCapture;
    private String outSideBrackets;
    private String inSideBrackets;
    private static final String NOT_FEDERATED = "NOT FEDERATED";
    private static final String VALUE_COMPRESSION = "VALUE COMPRESSION";
    private static final String OPTIONS = "OPTIONS";
    private static final String REMOTE_SERVER = "REMOTE_SERVER";
    private static final String REMOTE_SCHEMA = "REMOTE_SCHEMA";
    private static final String REMOTE_TABNAME = "REMOTE_TABNAME";
    private static final String ORGANIZE_BY = "ORGANIZE BY";
    private static final String DIMENSIONS = "DIMENSIONS";
    private String fullselect;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateTableUDBv81.class);

    public SHCreateTableUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        block5: {
            String statement = SHCreateTableUDBv81.clearCR(line);
            this.fullselect = line;
            if (Token.startsWithString(statement, "create table") || Token.startsWithString(statement, "create or replace table") || Token.startsWithString(statement, "create summary table")) {
                try {
                    this.failed = false;
                    this.fkList = new ArrayList();
                    this.refAtColumnList = new ArrayList();
                    this.parseTable(statement);
                    FKRefNode fkNode = new FKRefNode();
                    fkNode.processedTable = this.table;
                    fkNode.fkStatements = this.fkList;
                    fkNode.refAtColumns = this.refAtColumnList;
                    this.tableNodeList.add(fkNode);
                    if (this.failed) {
                        this.importLog.addFailedStatement(line);
                        break block5;
                    }
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception e) {
                    LOGGER.error(" Parsing " + statement + " for UDB 8.1 failed!", e);
                    this.importLog.addFailedStatement(line);
                }
            } else {
                this.nextHandler(line);
            }
        }
    }

    public void parseTable(String statement) throws Exception {
        this.setStatement(statement);
        this.ownerName = null;
        if (Token.hasCloseAndOpenBrackets(statement)) {
            this.inSideBrackets = Token.getValBetweenBrackets(this.statement, 1).trim();
            this.outSideBrackets = Token.getValAfterBrackets(this.statement, 1).trim();
        }
        boolean isBST = false;
        if (Token.hasToken(this.outSideBrackets, "FOR")) {
            this.initStagingTable(this.outSideBrackets);
        } else if ("".equalsIgnoreCase(this.inSideBrackets) && Token.hasToken(statement, "FOR")) {
            this.initStagingTable(statement);
        } else {
            this.createDomainsDuringImport = this.design.getAppView().getSettings().isCreateDomainsDuringImport();
            this.tableName = this.initTableName();
            if (Token.getTokenAfter(statement, this.tableName).trim().equalsIgnoreCase("OF")) {
                StructuredType type;
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignUDBv81)this.design.getStorageDesign(this.site);
                this.table = this.design.getRelationalDesign().createTable();
                if (this.ownerName != null && !"".equals(this.ownerName)) {
                    this.table.setSchema(this.ownerName);
                }
                this.table.setName(this.tableName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.table);
                this.tableProxy = (TableProxyUDBv81)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
                isBST = true;
                String temp = Token.getStringAfterToken(statement, "OF").trim();
                String stName = Token.getFirstToken(temp).trim();
                int posPoint = stName.indexOf(46);
                if (posPoint > 0) {
                    stName = Token.getValAfterCharacter(stName, '.');
                }
                if ((type = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(stName)) != null) {
                    this.table.setBasedOnStructuredType(type);
                    if (this.tableProxy.getIndexes().size() > 0) {
                        this.tableProxy.getIndexes().removeAll();
                    }
                } else {
                    LOGGER.error("Unable to find required Structured Type: " + stName);
                }
                if (Token.hasToken(statement, "HIERARCHY")) {
                    String hierarchyName = Token.getTokenAfter(statement, "HIERARCHY").trim();
                    this.tableProxy.setHierarchyName(hierarchyName);
                } else if (Token.hasToken(statement, "UNDER")) {
                    Table superTable;
                    String superTableName = Token.getTokenAfter(statement, "UNDER").trim();
                    posPoint = superTableName.indexOf(46);
                    if (posPoint > 0) {
                        superTableName = Token.getValAfterCharacter(superTableName, '.');
                    }
                    if ((superTable = (Table)this.design.getRelationalDesign().getTableSet().getByName(superTableName)) != null) {
                        ContainerView parentTV = (ContainerView)superTable.getTopView();
                        ContainerView childTV = (ContainerView)this.table.getTopView();
                        if (parentTV != null && childTV != null) {
                            TypeSubstitution ts = this.design.getRelationalDesign().createTypeSubstitution();
                            this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            ts.setChildCV(childTV);
                            ts.setParentCV(parentTV);
                            ts.addToAllDPVs();
                        }
                    }
                }
                if (Token.hasString(statement, "REF IS")) {
                    String oidColumnName = Token.getStringAfter(statement, "REF IS").trim();
                    oidColumnName = Token.getFirstToken(oidColumnName).trim();
                    this.table.getOidElement().setName(oidColumnName);
                }
            } else if (Token.hasCloseAndOpenBrackets(this.statement)) {
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignUDBv81)this.design.getStorageDesign(this.site);
                this.table = this.design.getRelationalDesign().createTable();
                if (this.ownerName != null && !"".equals(this.ownerName)) {
                    this.table.setSchema(this.ownerName);
                }
                this.table.setName(this.tableName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.table);
                this.tableProxy = (TableProxyUDBv81)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
                if (statement.toUpperCase().indexOf("AS (SELECT") > -1 || statement.toUpperCase().indexOf("AS ( SELECT") > -1) {
                    if (statement.toUpperCase().indexOf("AS (SELECT") > -1) {
                        this.inSideBrackets = Token.getStringBefore(statement, "AS (SELECT");
                    } else if (statement.toUpperCase().indexOf("AS ( SELECT") > -1) {
                        this.inSideBrackets = Token.getStringBefore(statement, "AS ( SELECT");
                    }
                    this.inSideBrackets = Token.getValBetweenBrackets(this.inSideBrackets);
                    if (!this.initCols()) {
                        this.initCol();
                    }
                    this.processSummaryQuery();
                } else {
                    this.columns = this.initColumns();
                    for (int col = 0; col < this.columns.size(); ++col) {
                        Map oneColumnMap = (Map)this.columns.get(col);
                        boolean isConstraint = (Boolean)oneColumnMap.get("IS_CONSTRAINT");
                        if (!isConstraint) {
                            String reference;
                            String colName = (String)oneColumnMap.get("columnname");
                            colName = Token.getName(colName);
                            Column column = this.table.createColumn(colName);
                            this.design.getRelationalDesign().stampModelObjectDDL(column);
                            String datatype = (String)oneColumnMap.get("datatype");
                            if (datatype != null) {
                                String scale = (String)oneColumnMap.get("scale");
                                String size = (String)oneColumnMap.get("size");
                                String precision = (String)oneColumnMap.get("precision");
                                String[] parameters = new String[]{precision, scale, size};
                                String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                                if (this.createDomainsDuringImport) {
                                    Domain domain = null;
                                    String typeName = (String)oneColumnMap.get("typename");
                                    if (typeName != null) {
                                        DomainSet domains = this.design.getDomainSet();
                                        domain = (Domain)domains.getByName(typeName);
                                    }
                                    String domainName = "";
                                    if (domain == null) {
                                        domainName = DomainFactory.createDomainName(logicalDT, parameters);
                                        domain = this.getCorrespondingDomain(domainName);
                                    }
                                    if (domain != null) {
                                        column.setDomain(domain);
                                    } else {
                                        StringBuffer message = new StringBuffer("domain is null in SHCreateTableUDBv81.parseTable : ");
                                        message.append(domainName);
                                        LOGGER.error(message.toString());
                                        this.importLog.addError("Null domain occurred while creating " + this.tableName);
                                    }
                                } else {
                                    column.setLogicalDatatype(logicalDT);
                                    column.setUse((short)1);
                                    column.setDataTypeParameter("scale", scale);
                                    column.setDataTypeParameter("precision", precision);
                                    column.setDataTypeParameter("size", size);
                                }
                            } else {
                                String stName = (String)oneColumnMap.get(NameElements.COL_STRUCTURED_TYPE);
                                if (stName != null && !"".equalsIgnoreCase(stName)) {
                                    StructuredType st;
                                    boolean isRef = Token.hasToken(stName, "REF");
                                    int posPoint = (stName = isRef ? Token.getTokenAfter(stName, "REF") : Token.getFirstToken(stName)).indexOf(46);
                                    if (posPoint > 0) {
                                        stName = Token.getValAfterCharacter(stName, '.');
                                    }
                                    if ((st = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(stName)) != null) {
                                        column.setUse((short)3);
                                        if (isRef) {
                                            column.setReference(true);
                                        }
                                        column.setStructuredType(st);
                                    }
                                }
                            }
                            boolean notNull = (Boolean)oneColumnMap.get("NOT NULL");
                            column.setNullsAllowed(!notNull);
                            String defaultElement = (String)oneColumnMap.get("DEFAULT");
                            boolean isPK = (Boolean)oneColumnMap.get("PRIMARY KEY");
                            if (isPK) {
                                Index pk = this.table.createIndex();
                                pk.add(column);
                                pk.makePK();
                                this.design.getRelationalDesign().stampModelObjectDDL(pk);
                            } else {
                                boolean isUnique = (Boolean)oneColumnMap.get("UNIQUE");
                                if (isUnique) {
                                    Index unique = this.table.createIndex();
                                    unique.add(column);
                                    unique.setIndexState("Unique Constraint");
                                    this.design.getRelationalDesign().stampModelObjectDDL(unique);
                                }
                            }
                            if (this.storageDesign != null) {
                                String queryOptimization;
                                boolean compressSystemDefault;
                                String identity;
                                boolean fileControl;
                                ColumnProxyUDBv81 columnProxy = (ColumnProxyUDBv81)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
                                String[] defaultChoises = ColumnProxyUDB.getDefaultValueChoices();
                                String forElement = (String)oneColumnMap.get("FOR");
                                if (forElement != null && "BIT".equalsIgnoreCase(forElement)) {
                                    columnProxy.setForBitData(true);
                                }
                                if (defaultElement != null) {
                                    boolean def = (Boolean)oneColumnMap.get("IS DEFAULT");
                                    columnProxy.setDefault(def);
                                    if (defaultElement.equalsIgnoreCase(defaultChoises[2]) || defaultElement.equalsIgnoreCase(defaultChoises[3])) {
                                        columnProxy.setDefaultValue(defaultElement);
                                    } else {
                                        columnProxy.setDefaultValue(defaultChoises[1]);
                                        columnProxy.setDefaultValueConstant(defaultElement);
                                        column.setDefaultValue(defaultElement);
                                    }
                                }
                                if (datatype != null && datatype.equalsIgnoreCase("BLOB")) {
                                    boolean notLogged = (Boolean)oneColumnMap.get("NOT LOGGED");
                                    columnProxy.setLogging(notLogged ? "NOT LOGGED" : "LOGGED");
                                    boolean compact = (Boolean)oneColumnMap.get("COMPACT");
                                    columnProxy.setCompact(compact ? "YES" : "NO");
                                }
                                if (datatype != null && datatype.equalsIgnoreCase("DATALINK") && (fileControl = ((Boolean)oneColumnMap.get("INTEGRITY")).booleanValue())) {
                                    columnProxy.setLinkControl("FILE");
                                    String readPermission = (String)oneColumnMap.get("READ");
                                    columnProxy.setReadPermission(readPermission);
                                    String writePermission = (String)oneColumnMap.get("WRITE");
                                    columnProxy.setWritePermission(writePermission);
                                    String recovery = (String)oneColumnMap.get("RECOVERY");
                                    if ("YES".equalsIgnoreCase(recovery)) {
                                        columnProxy.setRecovery("YES");
                                    }
                                    String unLink = (String)oneColumnMap.get("UNLINK");
                                    columnProxy.setOnUnlink(unLink);
                                }
                                if ((identity = (String)oneColumnMap.get("GENERATED")) != null) {
                                    String generateExpression;
                                    String maxValue;
                                    String minValue;
                                    String order;
                                    String cycle;
                                    String cache;
                                    String incrementBy;
                                    columnProxy.setUseIdentity(true);
                                    for (int i = 0; i < ColumnProxyUDB.getGenerateValues().length; ++i) {
                                        String value = ColumnProxyUDB.getGenerateValues()[i];
                                        if (!identity.equalsIgnoreCase(value)) continue;
                                        columnProxy.setGenerate(value);
                                        break;
                                    }
                                    HashMap<String, Object> autoIncProps = new HashMap<String, Object>();
                                    String startWith = (String)oneColumnMap.get("START");
                                    if (startWith != null) {
                                        columnProxy.setStartWith(startWith);
                                        autoIncProps.put("START", startWith);
                                    }
                                    if ((incrementBy = (String)oneColumnMap.get("INCREMENT")) != null) {
                                        try {
                                            int incrementByValue = Integer.parseInt(incrementBy);
                                            columnProxy.setIncrementBy(incrementByValue);
                                            autoIncProps.put("INCREMENT", incrementByValue);
                                        }
                                        catch (NumberFormatException e) {
                                            StringBuffer message = new StringBuffer("wrong Format for Increment value in SHCreateTableUDBv81 -> Init Identity: ");
                                            LOGGER.error(message.toString());
                                            this.importLog.addWarning("Wrong INCREMENT format in statement " + statement);
                                        }
                                    }
                                    if ((cache = (String)oneColumnMap.get("CACHE")) != null) {
                                        columnProxy.setCache(cache);
                                        autoIncProps.put("CACHE", cache);
                                    }
                                    if ((cycle = (String)oneColumnMap.get("CYCLE")) != null) {
                                        columnProxy.setCycle(cycle);
                                        autoIncProps.put("CYCLE", cycle);
                                    }
                                    if ((order = (String)oneColumnMap.get("ORDER")) != null) {
                                        columnProxy.setOrder(order);
                                        autoIncProps.put("ORDER", order);
                                    }
                                    if ((minValue = (String)oneColumnMap.get("MINVALUE")) != null) {
                                        columnProxy.setMinValue(minValue);
                                        autoIncProps.put("MINVALUE", minValue);
                                    }
                                    if ((maxValue = (String)oneColumnMap.get("MAXVALUE")) != null) {
                                        columnProxy.setMaxValue(maxValue);
                                        autoIncProps.put("MAXVALUE", maxValue);
                                    }
                                    if ((generateExpression = (String)oneColumnMap.get("GENERATION_EXPRESSION")) != null) {
                                        column.setComputed(true);
                                        column.setFormulaDesc(generateExpression);
                                    } else {
                                        column.setIdentityColumn(true);
                                        column.setAutoIncrementColumn(true);
                                        this.setAutoIncrementProperties(column, autoIncProps);
                                    }
                                }
                                if (compressSystemDefault = ((Boolean)oneColumnMap.get("COMPRESS SYSTEM DEFAULT")).booleanValue()) {
                                    columnProxy.setCompressSystemDefault("YES");
                                } else {
                                    columnProxy.setCompressSystemDefault("NO");
                                }
                                String validation = (String)oneColumnMap.get("VALIDATION");
                                if (validation != null) {
                                    columnProxy.setValidation(validation);
                                }
                                if ((queryOptimization = (String)oneColumnMap.get("QUERY OPTIMIZATION")) != null) {
                                    columnProxy.setQueryOptimization(queryOptimization);
                                }
                            }
                            if ((reference = (String)oneColumnMap.get("REFERENCES")) != null) {
                                RefAtColNode refNode = new RefAtColNode();
                                int posPoint = reference.indexOf(46);
                                if (posPoint > 0) {
                                    reference = Token.getValAfterCharacter(reference, '.');
                                }
                                refNode.onDelete = (String)oneColumnMap.get("ON DELETE");
                                refNode.columnName = (String)oneColumnMap.get("columnname");
                                refNode.refColumn = (String)oneColumnMap.get("REFERENCED_COLUMN");
                                refNode.referencedTable = reference;
                                this.refAtColumnList.add(refNode);
                            }
                            String constr = (String)oneColumnMap.get("CONSTRAINT");
                            String check = (String)oneColumnMap.get("CHECK");
                            if (check == null) continue;
                            this.initCheckConstraint(check, constr, column);
                            continue;
                        }
                        String name = (String)oneColumnMap.get("CONSTRAINT_NAME");
                        boolean isPK = (Boolean)oneColumnMap.get("PRIMARY KEY");
                        if (isPK) {
                            Index pk = this.table.createIndex();
                            this.design.getRelationalDesign().stampModelObjectDDL(pk);
                            if (!"".equalsIgnoreCase(name)) {
                                pk.setName(name);
                            } else {
                                if (this.tableName.length() > 125) {
                                    this.tableName = this.tableName.substring(0, 125);
                                }
                                pk.setName(this.tableName + "_PK");
                            }
                            String elements = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                            try {
                                SHCreateTableUDB.setColumnsForIndexPK(pk, elements, this.importLog);
                                pk.makePK();
                            }
                            catch (ObjectDoesNotExistException e) {
                                StringBuffer message = new StringBuffer(e.getMessage());
                                message.append(" in SHCreateTableUDBv81.parseTable:PRIMARY KEY");
                                LOGGER.error(message.toString());
                                this.importLog.addError("Columns for primary key " + pk.getName() + " don't exist.");
                                this.failed = true;
                            }
                            continue;
                        }
                        boolean isUnique = (Boolean)oneColumnMap.get("UNIQUE");
                        if (isUnique) {
                            Index unique = this.table.createIndex();
                            this.design.getRelationalDesign().stampModelObjectDDL(unique);
                            if (!"".equalsIgnoreCase(name)) {
                                unique.setName(name);
                            } else {
                                if (this.tableName.length() > 123) {
                                    this.tableName = this.tableName.substring(0, 123);
                                }
                                unique.setName(this.tableName + "_UK" + this.table.getUKeys().size());
                            }
                            String elements = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                            try {
                                SHCreateTableUDB.setColumnsForIndexPK(unique, elements, this.importLog);
                                unique.setIndexState("Unique Constraint");
                            }
                            catch (ObjectDoesNotExistException e) {
                                StringBuffer message = new StringBuffer(e.getMessage());
                                message.append(" in SHCreateTableUDBv81.parseTable:UNIQUE");
                                LOGGER.error(message.toString());
                                this.importLog.addError("Columns for unique key " + unique.getName() + " don't exist.");
                                this.failed = true;
                            }
                            unique.setIndexState("Unique Constraint");
                            continue;
                        }
                        boolean isTableConstraint = (Boolean)oneColumnMap.get("CHECK");
                        if (!isTableConstraint) continue;
                        String rule = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                        if (this.tableName.length() > 123) {
                            this.tableName = this.tableName.substring(0, 123);
                        }
                        TableLevelConstraint constraint = this.table.createCheckConstraint(this.tableName + "_CK" + this.table.getCheckConstraints().size(), rule);
                        if (!"".equalsIgnoreCase(name)) {
                            constraint.setName(name);
                        }
                        this.table.addCheckConstraint(constraint);
                        this.design.getRelationalDesign().stampModelObjectDDL(constraint);
                    }
                }
            }
            if (this.tableProxy != null) {
                this.initOwner();
                if (!isBST) {
                    this.initDimensions();
                    this.initFederated();
                    this.initTableSpace();
                    this.initIndexTableSpace();
                    this.initLongTableSpace();
                    this.initDataCapture();
                    if (this.storageDesign instanceof StorageDesignUDBv9) {
                        this.initDistributeByHash();
                    } else {
                        this.initPartitioningKey();
                        this.initHashing();
                    }
                    this.initValueCompression();
                    this.initRestrictOnDrop();
                    this.initLoggedInitially();
                    this.initRemoteOptions();
                }
            }
        }
    }

    private void setAutoIncrementProperties(Column column, Map autoIncProps) {
        if (autoIncProps.get("START") != null) {
            column.setAutoIncrementStartWith((String)autoIncProps.get("START"));
        }
        if (autoIncProps.get("INCREMENT") != null) {
            column.setAutoIncrementIncrementBy((Integer)autoIncProps.get("INCREMENT"));
        }
        if (autoIncProps.get("CACHE") != null) {
            column.setAutoIncrementDisableCache("NO".equalsIgnoreCase((String)autoIncProps.get("CACHE")));
            column.setAutoIncrementCache("NO".equalsIgnoreCase((String)autoIncProps.get("CACHE")) ? 0 : Integer.valueOf((String)autoIncProps.get("CACHE")));
        }
        if (autoIncProps.get("CYCLE") != null) {
            column.setAutoIncrementCycle("YES".equalsIgnoreCase((String)autoIncProps.get("CYCLE")));
        }
        if (autoIncProps.get("MAXVALUE") != null) {
            column.setAutoIncrementMaxValue((String)autoIncProps.get("MAXVALUE"));
        }
        if (autoIncProps.get("MINVALUE") != null) {
            column.setAutoIncrementMinValue((String)autoIncProps.get("MINVALUE"));
        }
        if (autoIncProps.get("ORDER") != null) {
            column.setAutoIncrementOrder("YES".equalsIgnoreCase((String)autoIncProps.get("ORDER")));
        }
    }

    private boolean initCols() {
        String columnStatement = this.inSideBrackets;
        columnStatement = Token.getNamesOnly(columnStatement);
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracketNoClose(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracketNoClose(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString().trim();
                }
            }
            Column col = this.table.createColumn(oneColumn);
            this.design.getRelationalDesign().stampModelObjectDDL(col);
        }
        return false;
    }

    public void initCol() {
        if (Token.hasToken(this.statement, "AS")) {
            this.table.setTypeID("4");
            String stmt = Token.getStringAfter(this.statement, "SELECT").trim();
            if (Token.hasToken(this.statement, "FROM")) {
                int fromInd = stmt.indexOf("FROM");
                String beforeFrom = stmt.substring(0, fromInd);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")")) {
                    fromInd = stmt.indexOf("FROM", fromInd + 1);
                    beforeFrom = stmt.substring(0, fromInd);
                }
                stmt = beforeFrom;
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            String columnAlias = null;
            ContainedObject[] columnDefs = this.table.getElements();
            int columnIndex = 0;
            while (tokenizer.hasMoreTokens()) {
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")") && tokenizer.hasMoreTokens()) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                if (Token.hasToken(column, "AS")) {
                    int asIndex = column.lastIndexOf(" AS ");
                    columnAlias = column.substring(asIndex + 4);
                    columnAlias = Token.getFirstName(columnAlias, '\"', '\"');
                    column = column.substring(0, asIndex);
                } else {
                    if ((column = Token.encodeQuotedString(column)).indexOf(" ") > -1) {
                        if (column.charAt(column.length() - 1) == '\"') {
                            columnAlias = column.substring(0, column.length() - 1);
                            int lastIndex = columnAlias.lastIndexOf(34);
                            columnAlias = columnAlias.substring(lastIndex) + "\"";
                            column = column.substring(0, lastIndex - 1);
                        } else if (column.charAt(column.length() - 1) == '\'') {
                            columnAlias = column.substring(0, column.length() - 1);
                            int lastIndex = columnAlias.lastIndexOf(39);
                            columnAlias = columnAlias.substring(lastIndex) + "'";
                            column = column.substring(0, lastIndex - 1);
                        } else {
                            String last = Token.getLastToken(column);
                            if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                                columnAlias = last;
                                column = column.substring(0, column.lastIndexOf(last)).trim();
                            }
                        }
                    }
                    column = Token.decodeQuotedString(column);
                }
                column = Token.removeQuotes(column);
                String tblName = null;
                if (column.endsWith(".*") || !Token.hasCloseAndOpenBrackets(column) && column.indexOf(43) == -1 && column.indexOf(45) == -1 && column.indexOf(42) == -1 && column.indexOf(47) == -1 && column.indexOf(58) == -1 && column.indexOf("||") == -1 && !Token.hasToken(column, "CONCAT") && column.indexOf(46) > -1) {
                    tblName = column.substring(0, column.lastIndexOf(46));
                    column = column.substring(column.lastIndexOf(46) + 1);
                    if (tblName.indexOf(46) > -1) {
                        tblName = tblName.substring(tblName.lastIndexOf(46) + 1);
                        tblName = Token.getName(tblName);
                    }
                }
                Column col = null;
                if (column.equals("*")) {
                    if (!Token.hasToken(this.statement, "FROM")) continue;
                    stmt = Token.getStringAfter(this.statement, "FROM").trim();
                    int pos = -1;
                    if (Token.hasToken(stmt, "WHERE")) {
                        pos = stmt.indexOf("WHERE");
                    } else if (Token.hasToken(stmt, "GROUP")) {
                        pos = stmt.indexOf("GROUP");
                    }
                    if (pos > -1) {
                        stmt = stmt.substring(0, pos);
                    }
                    StringTokenizer st = new StringTokenizer(stmt, ",");
                    while (st.hasMoreTokens()) {
                        String tableName = st.nextToken().trim();
                        if ((tableName = Token.getFirstName(tableName, '\"', '\"')).indexOf(46) > -1) {
                            tableName = tableName.substring(tableName.lastIndexOf(46) + 1);
                        }
                        if (tblName != null && !tblName.equalsIgnoreCase(tableName)) continue;
                        ContainerObject tbl = (Table)this.storageDesign.getPhysicalDesign().getTableSet().getByName(tableName);
                        if (tbl == null) {
                            tbl = (ContainerObject)this.storageDesign.getPhysicalDesign().getTableViewSet().getByName(tableName);
                        }
                        if (tbl == null) continue;
                        for (ContainedObjectWithDomain refCol : ((ContainerObject)tbl).getElementsCollection()) {
                            if (columnIndex < columnDefs.length) {
                                col = (Column)columnDefs[columnIndex++];
                            } else {
                                col = this.table.createColumn(refCol.getName());
                                this.design.getRelationalDesign().stampModelObjectDDL(col);
                            }
                            if (!(refCol instanceof Column)) continue;
                            this.copyDatatype((Column)refCol, col);
                        }
                    }
                    continue;
                }
                if (columnIndex < columnDefs.length) {
                    col = (Column)columnDefs[columnIndex++];
                } else {
                    String columnName = columnAlias;
                    if (columnAlias == null || columnAlias.isEmpty()) {
                        columnName = column;
                    }
                    columnName = Token.getName(columnName);
                    col = this.table.createColumn(columnName);
                    this.design.getRelationalDesign().stampModelObjectDDL(col);
                }
                if (column.isEmpty() || !Token.hasToken(this.statement, "FROM")) continue;
                stmt = Token.getStringAfter(this.statement, "FROM").trim();
                int pos = -1;
                if (Token.hasToken(stmt, "WHERE")) {
                    pos = stmt.indexOf("WHERE");
                } else if (Token.hasToken(stmt, "GROUP")) {
                    pos = stmt.indexOf("GROUP");
                }
                if (pos > -1) {
                    stmt = stmt.substring(0, pos);
                }
                boolean columnFound = false;
                StringTokenizer st = new StringTokenizer(stmt, ",");
                while (st.hasMoreTokens()) {
                    ContainedObjectWithDomain col2;
                    String tableName = st.nextToken().trim();
                    if ((tableName = Token.getFirstName(tableName, '\"', '\"')).indexOf(46) > -1) {
                        tableName = tableName.substring(tableName.lastIndexOf(46) + 1);
                    }
                    if (tblName != null && !tblName.equalsIgnoreCase(tableName)) continue;
                    ContainerObject tbl = (Table)this.storageDesign.getPhysicalDesign().getTableSet().getByName(tableName);
                    if (tbl == null) {
                        tbl = (ContainerObject)this.storageDesign.getPhysicalDesign().getTableViewSet().getByName(tableName);
                    }
                    if (tbl == null || (col2 = (ContainedObjectWithDomain)tbl.getElementByName(column)) == null) continue;
                    col.setName(col2.getName());
                    if (col2 instanceof Column) {
                        this.copyDatatype((Column)col2, col);
                    }
                    columnFound = true;
                    break;
                }
                if (columnFound) continue;
                if (this.isAggregateFunction(column)) {
                    col.setSourceType("Aggregate");
                } else {
                    col.setSourceType("Derived");
                }
                col.setFormulaDesc(column);
            }
        }
    }

    private void copyDatatype(Column fromColumn, Column toColumn) {
        short use = fromColumn.getUse();
        toColumn.setUse(use);
        if (use == 0) {
            toColumn.setDomain(fromColumn.getDomain());
        } else if (use == 1) {
            toColumn.setLogicalDatatype(fromColumn.getLogicalDatatype());
            toColumn.setDataTypeSize(fromColumn.getSize());
            toColumn.setDataTypePrecision(fromColumn.getPrecision());
            toColumn.setDataTypeScale(fromColumn.getScale());
        } else if (use == 3) {
            toColumn.setReference(fromColumn.isReference());
            toColumn.setStructuredType(fromColumn.getStructuredType());
        } else if (use == 4) {
            toColumn.setCollectionType(fromColumn.getCollectionType());
        } else if (use == 2) {
            toColumn.setDistinctType(fromColumn.getDistinctType());
        }
        toColumn.setNullsAllowed(fromColumn.getNullsAllowed());
    }

    private boolean isAggregateFunction(String function) {
        String[] functions = AggregateFunctionsUDB.FUNCTIONS_V8;
        for (int i = 0; i < functions.length; ++i) {
            String token = functions[i];
            if (!function.toUpperCase().startsWith(token.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private void processSummaryQuery() {
        String summary = Token.getStringAfter(this.statement, "AS ( SELECT");
        if (summary.isEmpty()) {
            summary = Token.getStringAfter(this.statement, "AS (SELECT");
        }
        if (!summary.isEmpty()) {
            this.table.setMaterializedQueryTable(true);
            this.table.setTypeID("4");
            this.tableProxy.setSummaryQuery("YES");
            this.fullselect = this.fullselect.trim();
            String beforeSelect = Token.getStringBeforeToken(this.fullselect, "SELECT");
            if (!beforeSelect.isEmpty()) {
                String brackettedSelect = "(" + this.fullselect.substring(beforeSelect.length()).trim();
                this.fullselect = Token.getValBetweenBrackets(brackettedSelect, 1).trim();
                this.table.setUserDefinedSQL(this.fullselect);
                this.table.setSyntaxProvider("DB2");
            }
            summary = "(" + summary;
            if ((summary = Token.getValAfterBrackets(summary, 1)).toUpperCase().startsWith("DEFINITION ONLY")) {
                this.tableProxy.setSummaryStatus("DEFINITION ONLY");
                this.processCopyOption(summary.substring(15).trim());
            } else {
                this.processRefreshableOptions(summary);
            }
        }
    }

    private void processRefreshableOptions(String summary) {
        if (summary.toUpperCase().startsWith("DATA INITIALLY DEFERRED")) {
            if (Token.hasString(summary, "ENABLE")) {
                this.tableProxy.setSummaryQueryOptimization("ENABLE");
            } else {
                this.tableProxy.setSummaryQueryOptimization("DISABLE");
            }
            if (Token.hasString(summary, "IMMEDIATE")) {
                this.tableProxy.setSummaryRefreshOptions("IMMEDIATE");
            } else {
                this.tableProxy.setSummaryQueryOptimization("DEFERRED");
            }
            if (Token.hasString(summary, "MAINTAINED BY USER")) {
                this.tableProxy.setSummaryRefreshOptions("BY USER");
            } else {
                this.tableProxy.setSummaryQueryOptimization("BY SYSTEM");
            }
        }
    }

    private void processCopyOption(String summary) {
        if (Token.hasString(summary, "INCLUDING COLUMN DEFAULTS") || Token.hasString(summary, "INCLUDING DEFAULTS")) {
            this.tableProxy.setSummaryCopyColumnDefaults("INCLUDING");
        } else if (Token.hasString(summary, "EXCLUDING COLUMN DEFAULTS") || Token.hasString(summary, "EXCLUDING DEFAULTS")) {
            this.tableProxy.setSummaryCopyColumnDefaults("EXCLUDING");
        } else {
            this.tableProxy.setSummaryCopyColumnDefaults("NONE");
        }
        if (summary.toUpperCase().startsWith("INCLUDING IDENTITY")) {
            this.tableProxy.setSummaryIdentityColumn("INCLUDING");
        } else {
            this.tableProxy.setSummaryIdentityColumn("EXCLUDING");
        }
    }

    private String initTableName() {
        String name = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        if (name.indexOf(40) > -1) {
            name = Token.getStringBefore(name, "(").trim();
        }
        if (name.indexOf(46) > -1) {
            this.ownerName = name.substring(0, name.indexOf(46)).trim();
            name = name.substring(name.indexOf(46) + 1).trim();
        }
        return name;
    }

    private ArrayList initColumns() {
        ArrayList<Map> tableColumns = new ArrayList<Map>();
        String columnStatement = this.inSideBrackets;
        SHColumnElementsUDBv81 elements = new SHColumnElementsUDBv81();
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            Map elementsColumn;
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracketNoClose(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracketNoClose(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString().trim();
                }
            }
            if (Boolean.TRUE.equals((elementsColumn = elements.getElementsColumn(oneColumn.trim(), Token.hasToken(this.statement, "AS") && Token.hasToken(this.statement, "SELECT"))).get("IS_CONSTRAINT")) && oneColumn.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(oneColumn);
                continue;
            }
            tableColumns.add(elementsColumn);
        }
        return tableColumns;
    }

    private boolean getDataCapture() {
        String dataCapture = Token.getTokenAfter(this.outSideBrackets, "CAPTURE");
        return dataCapture.equalsIgnoreCase("CHANGES");
    }

    private void initCheckConstraint(String check, String name, Column column) {
        CheckConstraint constraint = new CheckConstraint();
        constraint.add(this.storageDesign.getRDBMSType(), check);
        if (!"".equalsIgnoreCase(name) && name != null) {
            constraint.setName(name);
            column.setConstraintName(name);
        } else {
            String columnName = column.getName();
            if (columnName.length() > 13) {
                columnName = columnName.substring(0, 13);
            }
            name = columnName + "_CHCK";
            constraint.setName(name);
            column.setConstraintName(name);
        }
        column.setUseDomainConstraints(false);
        column.parseAndSetCheckConstraint(constraint);
    }

    public Table getTable() {
        return this.table;
    }

    private Domain getCorrespondingDomain(String nameDomain) {
        Domain result = null;
        DomainSet domainSet = this.design.getDomainSet();
        Iterator itDomSet = domainSet.iterator();
        while (itDomSet.hasNext()) {
            Domain domain = (Domain)itDomSet.next();
            if (!domain.getName().equalsIgnoreCase(nameDomain)) continue;
            result = domain;
            return result;
        }
        return result;
    }

    private TableSpaceUDBv81 getTableSpace(String tsName) {
        TableSpaceUDBv81 result = null;
        TableSpaceSetUDBv81 tablespaceSet = (TableSpaceSetUDBv81)this.storageDesign.getTableSpaceSet();
        for (TableSpaceUDBv81 ts : tablespaceSet) {
            if (!ts.getName().equalsIgnoreCase(tsName)) continue;
            result = ts;
            break;
        }
        return result;
    }

    private void initTableSpace() {
        if (Token.hasToken(this.outSideBrackets, "IN")) {
            TableSpaceUDB ts;
            String tsName = Token.getTokenAfter(this.outSideBrackets, "IN").trim();
            if (tsName.indexOf(46) > 0) {
                tsName = Token.getValAfterCharacter(tsName, '.');
            }
            if ((ts = this.getTableSpace(tsName = Token.removeQuotes(tsName))) == null) {
                ts = this.storageDesign.getTableSpaceSet().createTableSpace();
                ts.setName(tsName);
                this.design.getRelationalDesign().stampModelObjectDDL(ts);
            }
            if (ts != null) {
                this.tableProxy.setTableSpace(ts);
            } else {
                LOGGER.error("Tablespace " + tsName + " does not exist in statement " + this.statement);
                this.importLog.addWarning("Tablespace " + tsName + " does not exist in statement " + this.statement);
            }
        }
    }

    private void initIndexTableSpace() {
        if (Token.hasToken(this.outSideBrackets, "INDEX")) {
            TableSpaceUDBv81 ts;
            String part = this.outSideBrackets;
            while (!Token.getFirstToken(part).equalsIgnoreCase("INDEX")) {
                part = Token.cutFirstToken(part);
            }
            String tsName = Token.getTokenAfter(part, "IN").trim();
            if (tsName.indexOf(46) > 0) {
                tsName = Token.getValAfterCharacter(tsName, '.');
            }
            if ((ts = this.getTableSpace(tsName)) != null) {
                this.tableProxy.setIndexInTableSpace(ts);
            }
        }
    }

    private void initLongTableSpace() {
        if (Token.hasToken(this.outSideBrackets, "LONG")) {
            TableSpaceUDBv81 ts;
            String part = this.outSideBrackets;
            while (!Token.getFirstToken(part).equalsIgnoreCase("LONG")) {
                part = Token.cutFirstToken(part);
            }
            String tsName = Token.getTokenAfter(part, "IN").trim();
            if (tsName.indexOf(46) > 0) {
                tsName = Token.getValAfterCharacter(tsName, '.');
            }
            if ((ts = this.getTableSpace(tsName)) != null) {
                this.tableProxy.setLongInTableSpace(ts);
            }
        }
    }

    private void initOwner() {
        if (this.ownerName != null) {
            SchemaUDB schema = (SchemaUDB)this.storageDesign.getSchemaSet().getByName(this.ownerName);
            if (schema == null) {
                schema = this.storageDesign.getSchemaSet().createSchema();
                schema.setName(this.ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(schema);
            }
            if (schema != null) {
                this.tableProxy.setSchema(schema);
            } else {
                OwnerUDB owner = (OwnerUDB)((StorageDesignUDB)this.tableProxy.getStorageDesign()).getOwnerSet().getByName(this.ownerName);
                if (owner == null) {
                    owner = (OwnerUDB)((StorageDesignUDB)this.tableProxy.getStorageDesign()).getOwnerSet().createElement(null);
                    owner.setName(this.ownerName);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                this.tableProxy.setOwner(owner);
            }
        } else if (this.getOwner() != null) {
            this.tableProxy.setOwner((OwnerUDB)this.getOwner());
        }
    }

    private void initDimensions() {
        if (Token.hasString(this.statement.toUpperCase(), ORGANIZE_BY)) {
            int closeBraketIndex;
            this.tableProxy.setOrganizeByDimensions(true);
            String dimensions = Token.getStringAfter(this.statement, ORGANIZE_BY);
            if (dimensions.trim().toUpperCase().startsWith(DIMENSIONS)) {
                dimensions = Token.cutFirstToken(dimensions);
            }
            if ((closeBraketIndex = Token.getCloseBracketIndex(dimensions)) > -1) {
                dimensions = dimensions.substring(0, closeBraketIndex + 2);
                this.tableProxy.setDimensions(dimensions);
            }
        }
    }

    private void initFederated() {
        if (Token.hasString(this.statement.toUpperCase(), "FEDERATED")) {
            this.tableProxy.setFederated("FEDERATED");
        } else if (Token.hasString(this.statement.toUpperCase(), NOT_FEDERATED)) {
            this.tableProxy.setFederated(NOT_FEDERATED);
        }
    }

    private void initDataCapture() {
        this.dataCapture = this.getDataCapture();
        this.tableProxy.setDataCapture(this.dataCapture ? "CHANGES" : "NONE");
    }

    private void initPartitioningKey() {
        if (Token.hasToken(this.outSideBrackets, "PARTITIONING")) {
            String partKey = this.outSideBrackets;
            while (!Token.getFirstToken(partKey).equalsIgnoreCase("PARTITIONING")) {
                partKey = Token.cutFirstToken(partKey);
            }
            partKey = Token.getValBetweenBrackets(partKey, 1).trim();
            StringTokenizer tokenizer = new StringTokenizer(partKey, ",");
            while (tokenizer.hasMoreTokens()) {
                this.tableProxy.setPartitioningKey(tokenizer.nextToken().trim());
            }
        }
    }

    private void initHashing() {
        if (Token.hasToken(this.outSideBrackets, "HASHING")) {
            this.tableProxy.setPartKeyHashing(true);
        }
    }

    private void initDistributeByHash() {
        if (Token.hasToken(this.outSideBrackets, "DISTRIBUTE")) {
            String partKey = this.outSideBrackets;
            while (!Token.getFirstToken(partKey).equalsIgnoreCase("DISTRIBUTE")) {
                partKey = Token.cutFirstToken(partKey);
            }
            if (Token.hasToken(partKey, "HASH")) {
                this.tableProxy.setPartKeyHashing(true);
            }
            partKey = Token.getValBetweenBrackets(partKey, 1).trim();
            StringTokenizer tokenizer = new StringTokenizer(partKey, ",");
            while (tokenizer.hasMoreTokens()) {
                this.tableProxy.setPartitioningKey(tokenizer.nextToken().trim());
            }
        }
    }

    private void initValueCompression() {
        if (Token.hasString(this.outSideBrackets.toUpperCase(), VALUE_COMPRESSION)) {
            this.tableProxy.setValueCompression("YES");
        }
    }

    private void initRestrictOnDrop() {
        if (Token.hasString(this.outSideBrackets.toUpperCase(), "WITH RESTRICT ON DROP")) {
            this.tableProxy.setRestrictOnDrop("YES");
        }
    }

    private void initLoggedInitially() {
        if (Token.hasToken(this.outSideBrackets, "INITIALLY")) {
            this.tableProxy.setInitialLogging(false);
        }
    }

    private void initRemoteOptions() {
        if (Token.hasToken(this.outSideBrackets, OPTIONS)) {
            this.tableProxy.setUseRemoteOptions(true);
            String remoteOptions = Token.getStringAfterToken(this.outSideBrackets, OPTIONS);
            remoteOptions = Token.getValBetweenBrackets(remoteOptions);
            if (Token.hasString(remoteOptions, REMOTE_SERVER)) {
                String remoteServer = Token.getValBetweenFirstQuotationMarks(remoteOptions.substring(remoteOptions.toUpperCase().indexOf(REMOTE_SERVER)));
                this.tableProxy.setRoRemoteServer(remoteServer);
            } else {
                LOGGER.error("REMOTE_SERVER is not specified!");
            }
            if (Token.hasString(remoteOptions, REMOTE_SCHEMA)) {
                String remoteSchema = Token.getValBetweenFirstQuotationMarks(remoteOptions.substring(remoteOptions.toUpperCase().indexOf(REMOTE_SCHEMA)));
                this.tableProxy.setRoRemoteSchema(remoteSchema);
            }
            if (Token.hasString(remoteOptions, REMOTE_TABNAME)) {
                String remoteTabName = Token.getValBetweenFirstQuotationMarks(remoteOptions.substring(remoteOptions.toUpperCase().indexOf(REMOTE_TABNAME)));
                this.tableProxy.setRoRemoteSchema(remoteTabName);
            }
        }
    }

    private Table getReferencedTable(String reference) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table tableReferenced = (Table)tableSet.getByName(reference);
        if (tableReferenced != null) {
            return tableReferenced;
        }
        this.importLog.addError("Table with name " + reference + " does not exist.");
        throw new ObjectDoesNotExistException("Table with name " + reference);
    }

    private void addForeignKey(String line, Table processedTable) {
        block15: {
            Table tableRef;
            ArrayList<Column> columnsRef;
            String nameFK;
            block16: {
                nameFK = null;
                if (Token.hasToken(line, "CONSTRAINT")) {
                    nameFK = Token.getTokenAfter(line, "CONSTRAINT");
                } else {
                    String tableName = this.table.getName();
                    if (tableName.length() > 123) {
                        tableName = tableName.substring(0, 123);
                    }
                    nameFK = tableName + "_FK" + this.table.getFKAssociationsCount();
                }
                int positionBracket = line.indexOf(41);
                String firstBrackets = line.substring(0, positionBracket + 1).trim();
                String columns = Token.getValBetweenBrackets(firstBrackets);
                List columnNames = this.getColumnNames(columns);
                columnsRef = new ArrayList<Column>();
                Column[] columnSet = (Column[])processedTable.getElements();
                for (String name : columnNames) {
                    for (int ci = 0; ci < columnSet.length; ++ci) {
                        String colname = columnSet[ci].getName().trim();
                        if (!name.equalsIgnoreCase(colname)) continue;
                        columnsRef.add(columnSet[ci]);
                    }
                }
                int positionReference = line.toUpperCase().indexOf("REFERENCES");
                line = line.substring(positionReference);
                String nameReferenced = Token.getTokenAfter(line, "REFERENCES");
                String nameRef = this.getNameFor(nameReferenced);
                tableRef = this.getTableFor(nameRef = Token.removeQuotes(nameRef));
                if (tableRef == null) break block15;
                boolean hasBrackets = Token.hasString(line, "(");
                if (!hasBrackets) break block16;
                String columnsReferenced = Token.getValBetweenBrackets(line);
                List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                if (index == null) break block15;
                FKIndexAssociation fkass = processedTable.addFK(index, null, reference);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                if (nameFK != null) {
                    fkass.setName(nameFK);
                    fkass.getLocalFKIndex().setName(nameFK);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(line, "DELETE");
                if (!hasOnDelete) break block15;
                String onDelete = Token.getTokenAfter(line, "DELETE").trim();
                String[] choisesDelete = fkass.getDeleteRuleChoices();
                for (int choise = 0; choise < choisesDelete.length; ++choise) {
                    if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                    fkass.setDeleteRule(choisesDelete[choise]);
                    break block15;
                }
                break block15;
            }
            FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
            Index index = (Index)tableRef.getPK();
            if (index != null) {
                FKIndexAssociation fkass = processedTable.addFK(index, null, reference);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                if (nameFK != null) {
                    fkass.setName(nameFK);
                    fkass.getLocalFKIndex().setName(nameFK);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(line, "DELETE");
                if (hasOnDelete) {
                    String onDelete = Token.getTokenAfter(line, "DELETE").trim();
                    String[] choisesDelete = fkass.getDeleteRuleChoices();
                    for (int choise = 0; choise < choisesDelete.length; ++choise) {
                        if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                        fkass.setDeleteRule(choisesDelete[choise]);
                        break;
                    }
                }
            }
        }
    }

    private List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String token = tokColumns.nextToken().trim();
            token = Token.removeQuotes(token);
            columns.add(token.trim());
        }
        return columns;
    }

    private String getNameFor(String name) {
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            StringTokenizer tokenName = new StringTokenizer(name, ".");
            String itemName = null;
            do {
                String partName;
                itemName = partName = tokenName.nextToken().trim();
            } while (tokenName.hasMoreTokens());
            int posPointKomma = itemName.indexOf(59);
            if (posPointKomma > 0) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            return itemName;
        }
        int posPointKomma = name.indexOf(59);
        if (posPointKomma > 0) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private Table getTableFor(String tableName) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator itTableSet = tableSet.iterator();
        while (itTableSet.hasNext()) {
            Table tableFromSet = (Table)itTableSet.next();
            if (!tableFromSet.getName().equalsIgnoreCase(tableName)) continue;
            table = tableFromSet;
            break;
        }
        return table;
    }

    private void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            if (column.isPartOfFKIndexAssociation(fkAss)) continue;
            Column indexColumn = (Column)index.getElements()[p];
            fkAss.swapAndRemoveFKColumn(indexColumn, column, pkCol[p]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    Column getColumnByName(Table processedTable, String columnName) {
        Column[] cols = (Column[])processedTable.getElements();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].getName().equalsIgnoreCase(columnName)) continue;
            return cols[i];
        }
        return null;
    }

    private void processRefAtColumn(RefAtColNode refNode, Table processedTable) {
        String reference = this.getNameFor(refNode.referencedTable);
        Table referencedtable = null;
        try {
            referencedtable = this.getReferencedTable(reference);
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error("Unknown reference table in statement " + this.statement, e);
            this.importLog.addError("Unknown reference table in statement " + this.statement);
        }
        if (referencedtable != null) {
            Index indexOfreference;
            ArrayList<String> refColName = new ArrayList<String>();
            if (refNode.refColumn != null) {
                refColName.add(refNode.refColumn);
                indexOfreference = this.getUniqueIndexForColumnNames(referencedtable, refColName);
            } else {
                indexOfreference = (Index)referencedtable.getPK();
            }
            if (indexOfreference != null) {
                FKIndexAssociation fk = processedTable.addFK(indexOfreference);
                this.design.getRelationalDesign().stampModelObjectDDL(fk);
                ArrayList<Column> columnsRef = new ArrayList<Column>();
                Column column = this.getColumnByName(processedTable, refNode.columnName);
                if (column != null) {
                    columnsRef.add(column);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fk, columnsRef, indexOfreference);
                    } else {
                        this.fixFKColumns(fk, columnsRef, indexOfreference);
                    }
                    if (refNode.onDelete != null) {
                        String[] choisesDelete = fk.getDeleteRuleChoices();
                        for (int choise = 0; choise < choisesDelete.length; ++choise) {
                            if (!refNode.onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                            fk.setDeleteRule(choisesDelete[choise]);
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode node : this.tableNodeList) {
            for (String line : node.fkStatements) {
                this.addForeignKey(line, node.processedTable);
            }
            Iterator itcolref = node.refAtColumns.iterator();
            while (itcolref.hasNext()) {
                this.processRefAtColumn((RefAtColNode)itcolref.next(), node.processedTable);
            }
        }
    }

    private void initStagingTable(String statement) throws Exception {
        if (Token.hasToken(statement, "FOR")) {
            String columns;
            String name = this.initTableName();
            this.site = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignUDBv81)this.design.getStorageDesign(this.site);
            StagingTableUDB staging = this.storageDesign.getStagingTableSet().createStagingTable();
            staging.setName(name);
            this.design.getRelationalDesign().stampModelObjectDDL(staging);
            String tableName = Token.getTokenAfter(statement, "FOR");
            TableProxyUDBv81 table = (TableProxyUDBv81)((TableProxySetUDBv81)this.storageDesign.getTableProxySet()).getByName(tableName);
            if (table != null) {
                staging.setTable(table);
            } else {
                LOGGER.error("Table " + tableName + " does not exist!");
                this.importLog.addError("Table " + tableName + " does not exist");
            }
            if (Token.hasCloseAndOpenBrackets(statement) && !"".equalsIgnoreCase(columns = Token.getValBetweenBrackets(statement))) {
                staging.setDefineColumnNames(true);
                StringTokenizer token = new StringTokenizer(columns, ",");
                while (token.hasMoreTokens()) {
                    staging.setColumns(token.nextToken());
                }
            }
        } else {
            LOGGER.error(" Parsing " + statement + " for UDB failed! Wrong syntax!");
            throw new Exception();
        }
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

