/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.editor.UDPLibrary;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.editor.UserDefinedPropertyGroup;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public class MOHTable
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLE";
    protected static final String COL_OBJECT_TYPE = "COLUMN";
    protected static final String SYSTEM_TABLE = "SYSTEM TABLE";
    private final String NOT_NULL_PATTERN = " IS NOT NULL";
    protected static final String SIZE = "size";
    protected static final String SCALE = "scale";
    protected static final String PRECISION = "precision";
    public static String HIVE_NAME = "hiveName";
    public static String HIVE_SCHEMA = "hiveSchema";
    public static String HIVE_DATA_TYPE = "hiveDataType";
    public static String HIVE_PART_COLS = "hivePartCols";
    public static String HIVE_PART_COLS_ID = "hivePartColsID";
    public static String HIVE_TABLE_TYPE = "hiveTableType";
    public static String HIVE_COLLECTIN_DELIM = "hive_collection.delim";
    public static String HIVE_FIELD_DELIM = "hive_field.delim";
    public static String HIVE_LINE_DELIM = "hive_line.delim";
    public static String HIVE_MAPKEY_DELIM = "hive_mapkey.delim";
    public static String HIVE_SERIALIZATION_FORMAT = "hive_serialization.format";
    public static String HIVE_SERIALIZATION_NULL_FORMAT = "hive_serialization.null.format";
    public static String HIVE_BUCKED_COLS = "hiveBucketCols";
    public static String HIVE_SORT_COLS = "hiveSortCols";
    public static String HIVE_SKEWED_COLS = "hiveSkewedCols";
    public static String HIVE_SKEWED_VALUES = "hiveSkewedValues";
    public static String HIVE_NUMBUCKET = "hiveNumBuckets";
    public static String HIVE_COMPRESSED = "hiveCompressed";
    public static String HIVE_INPUT_FORMAT = "hiveInputFormat";
    public static String HIVE_OUTPUT_FORMAT = "hiveOutputFormat";
    public static String HIVE_SERDE_LIBRARY = "hiveSerDeLibrary";
    public static String HIVE_LOCATION = "hiveLocation";
    public static String HIVE_DDL = "hiveDDL";
    public static String COLLECTION_DELIM = "collection.delim";
    public static String FIELD_DELIM = "field.delim";
    public static String LINE_DELIM = "line.delim";
    public static String MAPKEY_DELIM = "mapkey.delim";
    public static String SERIALIZATION_FORMAT = "serialization.format";
    public static String SERIALIZATION_NULL_FORMAT = "serialization.null.format";
    public static String REDSHIFT_DISTKEY_COLUMN = "redshiftDistekeyColumn";
    public static String REDSHIFT_DISTKEY_COLUMN_ID = "redshiftDistekeyColumnID";
    public static String REDSHIFT_SORTKEY_COLUMNS = "redshiftSortkeyColumns";
    public static String REDSHIFT_SORTKEY_COLUMN_IDS = "redshiftSortkeyColumnIDs";
    public static String REDSHIFT_DIST_STYLE = "redshiftDistStyle";
    public static String REDSHIFT_SORTKEY_INDEX = "redshiftSortkeyIndex";
    private DataTypesDesign relDT;
    public static boolean CHECK_BDA_ROW_PROCESSING = false;
    PreparedStatement checkSt;
    PreparedStatement nullSchemaSt;
    private static final Hashtable SYNONYM_TABLE = new Hashtable();
    private static final Hashtable HIVE_SYNONYM_TABLE = new Hashtable();
    private static final Logger LOGGER;

    public MOHTable(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected ResultSet getTables(DatabaseMetaData dbmd, DBObject dbo, boolean all, String[] table_types) throws Exception {
        if (all) {
            return dbmd.getTables(null, dbo.getName(), "%", table_types);
        }
        return dbmd.getTables(null, dbo.getSchema(), dbo.getName(), table_types);
    }

    protected ResultSet getColumns(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        return dbmd.getColumns(null, dboTable.getSchema(), dboTable.getName(), "%");
    }

    protected ResultSet getPrimaryKeys(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        return dbmd.getPrimaryKeys(null, dboTable.getSchema(), dboTable.getName());
    }

    protected ResultSet getIndexInfo(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        return dbmd.getIndexInfo(null, dboTable.getSchema(), dboTable.getName(), false, false);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        DatabaseMetaData dbmd = sqlConnection.getMetaData();
        String[] table_types = this.getTableTypes(dbmd);
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            ResultSet rs = this.getTables(dbmd, dboNext, true, table_types);
            while (rs.next()) {
                String catalog = rs.getString(1);
                String schema = rs.getString(2);
                if (schema == null) {
                    schema = dboNext.getName();
                }
                String objName = rs.getString(3);
                String type = rs.getString(4);
                if (objName == null) continue;
                DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), objName, OBJECT_TYPE, schema);
                list.add(dboTable);
                String remarks = rs.getString(5);
                if (remarks == null) continue;
                dboTable.setComments(remarks);
            }
            rs.close();
        }
        return list;
    }

    String[] getTableTypes(DatabaseMetaData dbmd) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ResultSet trs = dbmd.getTableTypes();
            while (trs.next()) {
                String type = trs.getString(1);
                if ("VIRTUAL_VIEW".equalsIgnoreCase(type) || "INDEX_TABLE".equalsIgnoreCase(type) || "VIEW".equalsIgnoreCase(type) || list.contains(type) || type.toUpperCase().indexOf(OBJECT_TYPE) <= -1) continue;
                list.add(type);
            }
            trs.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (list.size() == 0) {
            return new String[]{OBJECT_TYPE, SYSTEM_TABLE};
        }
        return list.toArray(new String[0]);
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        int st_size2;
        boolean first = true;
        RelationalDesign reld = this.getRelationalDesign().getRelatedSyncModel();
        if (reld != null) {
            this.relDT = reld.getDesign().getDataTypesDesign();
        }
        boolean hiveUDPCreated = false;
        int st_size = this.getDesign().getDataTypesDesign().getStructuredTypeSet().size();
        DatabaseMetaData dbmd = sqlConnection.getMetaData();
        String dbProductName = dbmd.getDatabaseProductName().toUpperCase();
        StorageDesign stDes = this.getStorageDesign();
        RDBMSType dbtype = this.getStorageDesign().getRDBMSType();
        ArrayList<DBObject> tables = new ArrayList<DBObject>();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dboTable = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dboTable.getType())) continue;
            try {
                Table table = this.getRelationalDesign().createTable();
                table.setSchema(dboTable.getSchema());
                table.setName(dboTable.getName());
                dboTable.setTable(table);
                tables.add(dboTable);
                String remarks = dboTable.getComments();
                if (remarks != null) {
                    table.setCommentInRDBMS(remarks);
                }
                this.stampModelObject(table, dboTable);
                if (dbProductName.indexOf("HIVE") > -1 || dbProductName.indexOf("IMPALA") > -1) {
                    if (!hiveUDPCreated) {
                        MOHTable.createHiveUDPLibrary(this.getDesign());
                        hiveUDPCreated = true;
                    }
                    HashMap<String, DirectoryOracle> map = new HashMap<String, DirectoryOracle>();
                    table.setProperty(HIVE_NAME, dboTable.getName());
                    table.setProperty(HIVE_SCHEMA, dboTable.getSchema());
                    table.setProperty(HIVE_DDL, "true");
                    table.setTypeID("6");
                    TableProxyOracle tp = null;
                    if (stDes instanceof StorageDesignOraclev12c) {
                        SchemaObject sch;
                        UserOracle user;
                        tp = (TableProxyOracle)stDes.getStorageObject(table.getObjectID());
                        if (tp != null) {
                            tp.setOrganization("EXTERNAL");
                            tp.setAccessDriverType("ORACLE_HIVE");
                        }
                        if ((user = (UserOracle)((StorageDesignOraclev12c)stDes).getUserSet().getByName(dboTable.getSchema())) == null) {
                            user = ((StorageDesignOraclev12c)stDes).createUserOracle();
                            user.setName(dboTable.getSchema());
                        }
                        if ((sch = (SchemaObject)this.getRelationalDesign().getSchemaObjectSet().getByName(dboTable.getSchema())) != null) {
                            user.setSchemaObject(sch);
                        }
                    }
                    Statement stmt = sqlConnection.createStatement();
                    String sql = "describe formatted ";
                    sql = dboTable.getSchema() != null && !"".equals(dboTable.getSchema()) ? sql + dboTable.getSchema() + "." + dboTable.getName() : sql + dboTable.getName();
                    ResultSet rs = stmt.executeQuery(sql);
                    if (rs != null) {
                        this.processHiveTable(rs, table, dbProductName, dbtype);
                        rs.close();
                        if (stDes instanceof StorageDesignOraclev12c && tp != null) {
                            StorageDesignOracle stor = (StorageDesignOracle)stDes;
                            String location = table.getProperty(HIVE_LOCATION);
                            int ind = location.lastIndexOf(47);
                            if (location != null && !"".equals(location)) {
                                String locDir = ind > 0 ? location.substring(0, ind) : location;
                                DirectoryOracle dir = (DirectoryOracle)map.get(locDir);
                                if (dir == null) {
                                    dir = stor.getDirectorySet().getDirectoryByDirPath(locDir);
                                    if (dir == null) {
                                        dir = stor.getDirectorySet().createDirectory();
                                        dir.setDirPath(locDir);
                                    }
                                    map.put(locDir, dir);
                                }
                                tp.setDefaultDir(dir);
                                tp.setLocation(location);
                                if (CHECK_BDA_ROW_PROCESSING && this.isDelimitedFile(table)) {
                                    tp.setBigDataRowProcessing("c");
                                }
                            }
                        }
                    }
                } else {
                    this.handleColumns(dbmd, dboTable, table);
                    this.handlePKS(dbmd, dboTable, table);
                    this.handleIndexes(dbmd, dboTable, table);
                    if (first || this.isSupportInformation_Schema()) {
                        first = false;
                        this.handleCheckConstraint(sqlConnection, dboTable, table);
                    }
                    table.resetIdentityColumn();
                }
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dboTable);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("MOHTABLE - error in import from database", e);
            }
        }
        if (dbProductName.indexOf("POSTGRESQL") > -1) {
            TimeLog.log("processRedshiftSpecifics - begin");
            this.processRedshiftSpecifics(sqlConnection, tables);
            TimeLog.log("processRedshiftSpecifics - end");
        }
        if ((st_size2 = this.getDesign().getDataTypesDesign().getStructuredTypeSet().size()) > st_size) {
            Iterator it = this.getDesign().getDataTypesDesign().getDTReferenceSet().iterator();
            while (it.hasNext()) {
                DTReference ref = (DTReference)it.next();
                ref.addToAllDPVs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRedshiftSpecifics(Connection sqlConnection, List selectedObjects) throws SQLException {
        HashMap<String, ArrayList<DBObject>> map = new HashMap<String, ArrayList<DBObject>>();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            ArrayList<DBObject> list;
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            String schema = dbo.getSchema();
            if (schema == null) {
                schema = "null";
            }
            if ((list = (ArrayList<DBObject>)map.get(schema)) == null) {
                list = new ArrayList<DBObject>();
                map.put(schema, list);
            }
            list.add(dbo);
        }
        if (map.size() > 0) {
            Statement sp_st = null;
            Statement ps = null;
            String sp_sql = "set search_path to ";
            String sql = "select p.tablename, p.column, p.distkey, p.sortkey from pg_table_def p where schemaname=? and tablename = ? and (distkey = true or sortkey>0) order by sortkey";
            try {
                sp_st = sqlConnection.createStatement();
                ps = sqlConnection.prepareStatement(sql);
                for (String schema : map.keySet()) {
                    try {
                        sp_st.execute(sp_sql + schema);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LOGGER.error("processRedshiftSpecifics - error in seting the search path", e);
                    }
                    for (DBObject dbo : (List)map.get(schema)) {
                        ArrayList<String> columns = new ArrayList<String>();
                        ArrayList<String> columnIDs = new ArrayList<String>();
                        Table table = (Table)dbo.getTable();
                        String tname = dbo.getName();
                        ps.setString(1, schema);
                        ps.setString(2, tname);
                        Index ind = null;
                        ResultSet rs = ps.executeQuery();
                        while (rs.next()) {
                            String cname = rs.getString(2);
                            String distkey = rs.getString(3);
                            int skey = rs.getInt(4);
                            ContainedObject col = table.getElementByName(cname);
                            if (col == null) continue;
                            if ("true".equals(distkey)) {
                                table.setProperty(REDSHIFT_DISTKEY_COLUMN, col.getName());
                                table.setProperty(REDSHIFT_DISTKEY_COLUMN_ID, col.getObjectID());
                            }
                            if (skey <= 0) continue;
                            if (ind == null) {
                                ind = table.createIndex();
                                ind.setName(tname + "_SortKey");
                                ind.setProperty(REDSHIFT_SORTKEY_INDEX, "true");
                            }
                            ind.add(col);
                            columns.add(cname);
                            columnIDs.add(col.getObjectID());
                        }
                        if (columns.size() > 0) {
                            table.setProperty(REDSHIFT_SORTKEY_COLUMNS, StringUtilities.getAsCommaDelimitedString(columns));
                            table.setProperty(REDSHIFT_SORTKEY_COLUMN_IDS, StringUtilities.getAsCommaDelimitedString(columnIDs));
                        }
                        rs.close();
                    }
                }
                sp_st.execute(sp_sql + "DEFAULT");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("processRedshiftSpecifics - error in processing Redshift specifics", e);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
                if (sp_st != null) {
                    sp_st.close();
                }
            }
        }
    }

    private boolean isDelimitedFile(Table table) {
        String prop = table.getProperty(HIVE_FIELD_DELIM);
        if (prop != null && !"".equals(prop)) {
            return true;
        }
        prop = table.getProperty(HIVE_LINE_DELIM);
        if (prop != null && !"".equals(prop)) {
            return true;
        }
        prop = table.getProperty(HIVE_COLLECTIN_DELIM);
        if (prop != null && !"".equals(prop)) {
            return true;
        }
        prop = table.getProperty(HIVE_MAPKEY_DELIM);
        return prop != null && !"".equals(prop);
    }

    private void processHiveTable(ResultSet rs, Table table, String dbProductName, RDBMSType dbtype) throws Exception {
        boolean col = false;
        boolean empty = false;
        boolean pcol = false;
        boolean part = false;
        ArrayList<ModelIDObject> pcols = new ArrayList<ModelIDObject>();
        while (rs.next()) {
            String c1 = rs.getString(1);
            String c2 = rs.getString(2);
            String c3 = rs.getString(3);
            if (c1 != null) {
                c1 = c1.trim();
            }
            if (c2 != null) {
                c2 = c2.trim();
            }
            if (c3 != null) {
                c3 = c3.trim();
            }
            if ("# Partition Information".equals(c1)) {
                part = true;
                continue;
            }
            if ("# col_name".equals(c1) && !part) {
                col = true;
                continue;
            }
            if ("# col_name".equals(c1) && part) {
                pcol = true;
                part = false;
                continue;
            }
            if (col && (c1 == null || "".equals(c1))) {
                if (empty = !empty) continue;
                col = false;
                continue;
            }
            if (pcol && (c1 == null || "".equals(c1))) {
                if (empty = !empty) continue;
                pcol = false;
                continue;
            }
            if ((col || pcol) && empty) {
                String col_name = c1;
                String dataType = c2;
                String comment = c3;
                Column column = new Column(table.getDesignPart());
                column.setName(col_name);
                if (comment != null && !"None".equalsIgnoreCase(comment)) {
                    column.setCommentInRDBMS(comment);
                }
                column.setProperty(HIVE_NAME, col_name);
                table.addColumn(column);
                if (pcol) {
                    pcols.add(column);
                }
                this.stampModelObject((ModelObject)column, table.getName(), col_name);
                column.setProperty(HIVE_DATA_TYPE, dataType);
                if (dataType != null && this.isHivePrimitiveType(dataType)) {
                    LogicalDatatype logDatatype = this.getLogicalDatatype(dataType, dataType, dbProductName, dbtype);
                    if (logDatatype != null) {
                        this.setHiveDataType(column, logDatatype, dataType);
                        continue;
                    }
                    System.out.println("Unable to find logical datatype for: " + dataType);
                    continue;
                }
                if (dataType == null) continue;
                DesignObject type = this.getDatatypeFromHive(dataType, this.getDesign().getDataTypesDesign(), dbProductName, dbtype);
                if (type instanceof LogicalDatatype) {
                    column.setUse((short)1);
                    column.setLogicalDatatype((LogicalDatatype)type);
                    continue;
                }
                if (type instanceof StructuredType) {
                    column.setUse((short)3);
                    column.setStructuredType((StructuredType)type);
                    continue;
                }
                if (!(type instanceof CollectionType)) continue;
                column.setUse((short)4);
                column.setCollectionType((CollectionType)type);
                continue;
            }
            this.processTableProperties(table, c1, c2, c3);
        }
        if (pcols.size() > 0) {
            String partCols = this.getNames(pcols);
            table.setProperty(HIVE_PART_COLS, partCols);
            partCols = this.getIDs(pcols);
            table.setProperty(HIVE_PART_COLS_ID, partCols);
        }
    }

    private void setHiveDataType(Column column, LogicalDatatype logDatatype, String dataType) {
        column.setUse((short)1);
        column.setLogicalDatatype(logDatatype);
        if ("STRING".equalsIgnoreCase(dataType)) {
            this.setLogicalTypeParams(column, logDatatype, "max", 0);
        } else if ("BINARY".equalsIgnoreCase(dataType)) {
            column.setDataTypeSize("2000");
        } else {
            int ind = dataType.indexOf(40);
            if (ind > 0) {
                String inbr = Token.getValBetweenBrackets(dataType, 1);
                String[] params = inbr.split(",");
                if (params.length == 1) {
                    this.setLogicalTypeParams(column, logDatatype, params[0], 0);
                } else if (params.length == 2) {
                    int scale = 0;
                    try {
                        scale = Integer.parseInt(params[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setLogicalTypeParams(column, logDatatype, params[0], scale);
                }
            } else {
                this.setLogicalTypeParams(column, logDatatype, "0", 0);
            }
        }
    }

    private void setHiveDataType(TypeElement te, LogicalDatatype logDatatype, String dataType) {
        te.setType(logDatatype);
        if (!"STRING".equalsIgnoreCase(dataType)) {
            if ("BINARY".equalsIgnoreCase(dataType)) {
                te.setSize("2000");
            } else {
                int ind = dataType.indexOf(40);
                if (ind > 0) {
                    String inbr = Token.getValBetweenBrackets(dataType, 1);
                    String[] params = inbr.split(",");
                    if (params.length == 1) {
                        String dt_upper = dataType.toUpperCase();
                        if (dt_upper.startsWith("VARCHAR") || dt_upper.startsWith("CHAR")) {
                            te.setSize(params[0]);
                        } else {
                            int prec2 = 0;
                            try {
                                prec2 = Integer.parseInt(params[0]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (prec2 != 0) {
                                te.setPrecision(prec2);
                            }
                        }
                    } else if (params.length == 2) {
                        int prec = 0;
                        try {
                            prec = Integer.parseInt(params[0]);
                        }
                        catch (Exception prec2) {
                            // empty catch block
                        }
                        if (prec != 0) {
                            te.setPrecision(prec);
                            int scale = 0;
                            try {
                                scale = Integer.parseInt(params[1]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (scale != 0) {
                                te.setScale(scale);
                            }
                        }
                    }
                }
            }
        }
    }

    private void processTableProperties(Table table, String c1, String c2, String c3) {
        if ("Bucket Columns:".equals(c1)) {
            if (c2.length() > 2) {
                String cols = c2.substring(1, c2.length() - 1);
                table.setProperty(HIVE_BUCKED_COLS, cols);
            }
        } else if ("Sort Columns:".equals(c1)) {
            if (c2.length() > 2) {
                String cols = c2.substring(1, c2.length() - 1);
                String decoded = null;
                try {
                    String[] spl;
                    for (String part : spl = cols.split("Order")) {
                        String name;
                        int ind;
                        String t;
                        String[] tspl;
                        if ("".equals(part) || (tspl = (t = Token.getValBetweenBrackets(part, 1)).split(",")).length != 2 || (ind = tspl[0].indexOf(58) + 1) <= 0) continue;
                        String col = name = tspl[0].substring(ind);
                        ind = tspl[1].indexOf(58) + 1;
                        if (ind <= 0) continue;
                        String order = tspl[1].substring(ind);
                        col = "1".equals(order) ? col + " ASC" : col + " DESC";
                        decoded = decoded == null ? col : decoded + "," + col;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (decoded != null) {
                    table.setProperty(HIVE_SORT_COLS, decoded);
                } else {
                    table.setProperty(HIVE_SORT_COLS, cols);
                }
            }
        } else if ("Num Buckets:".equals(c1)) {
            if (!c2.equals("-1")) {
                table.setProperty(HIVE_NUMBUCKET, c2);
            }
        } else if ("Location:".equals(c1)) {
            table.setProperty(HIVE_LOCATION, c2);
        } else if ("Table Type:".equals(c1)) {
            table.setProperty(HIVE_TABLE_TYPE, c2);
        } else if (COLLECTION_DELIM.equals(c2) || "colelction.delim".equals(c2)) {
            table.setProperty(HIVE_COLLECTIN_DELIM, c3);
        } else if (FIELD_DELIM.equals(c2)) {
            table.setProperty(HIVE_FIELD_DELIM, c3);
        } else if (MAPKEY_DELIM.equals(c2)) {
            table.setProperty(HIVE_MAPKEY_DELIM, c3);
        } else if (LINE_DELIM.equals(c2)) {
            table.setProperty(HIVE_LINE_DELIM, c3);
        } else if (SERIALIZATION_FORMAT.equals(c2)) {
            table.setProperty(HIVE_SERIALIZATION_FORMAT, c3);
        } else if (SERIALIZATION_NULL_FORMAT.equals(c2)) {
            table.setProperty(HIVE_SERIALIZATION_NULL_FORMAT, c3);
        } else if ("Compressed:".equals(c1)) {
            table.setProperty(HIVE_COMPRESSED, c2);
        } else if ("SerDe Library:".equals(c1)) {
            table.setProperty(HIVE_SERDE_LIBRARY, c2);
        } else if ("InputFormat:".equals(c1)) {
            table.setProperty(HIVE_INPUT_FORMAT, c2);
        } else if ("OutputFormat:".equals(c1)) {
            table.setProperty(HIVE_OUTPUT_FORMAT, c2);
        } else if ("Skewed Columns:".equals(c1)) {
            if (c2.length() > 2) {
                String cols = c2.substring(1, c2.length() - 1);
                table.setProperty(HIVE_SKEWED_COLS, cols);
            }
        } else if ("Skewed Values:".equals(c1) && c2.length() > 2) {
            String cols = c2.substring(1, c2.length() - 1);
            table.setProperty(HIVE_SKEWED_VALUES, cols);
        }
    }

    private String getNames(List<ModelIDObject> list) {
        String res = null;
        for (ModelIDObject obj : list) {
            if (res == null) {
                res = obj.getName();
                continue;
            }
            res = res + "," + obj.getName();
        }
        return res;
    }

    private String getIDs(List<ModelIDObject> list) {
        String res = null;
        for (ModelIDObject obj : list) {
            if (res == null) {
                res = obj.getObjectID();
                continue;
            }
            res = res + "," + obj.getObjectID();
        }
        return res;
    }

    private DesignObject getDatatypeFromHive(String dataType, DataTypesDesign dtDes, String dbProductName, RDBMSType dbtype) {
        if (this.isHivePrimitiveType(dataType)) {
            LogicalDatatype logDatatype = this.getLogicalDatatype(dataType, dataType, dbProductName, dbtype);
            return logDatatype;
        }
        String dt = dataType.replaceAll("<", "(").replaceAll(">", ")").toLowerCase();
        if (dt.startsWith("map")) {
            StructuredType st = dtDes.getStructuredTypeSet().findByChangedHiveType(dt);
            if (st != null) {
                st.setHiveType(StructuredType.MAP);
                return st;
            }
            String def = Token.getValBetweenBrackets(dt, 1);
            String[] parts = def.split(",");
            if (parts.length > 1) {
                String valueType = parts[1];
                String name = "Map_" + parts[0] + "_" + valueType;
                if (parts.length > 2) {
                    for (int i = 2; i < parts.length; ++i) {
                        valueType = valueType + "," + parts[i];
                    }
                }
                DesignObject type = this.getDatatypeFromHive(valueType, dtDes, dbProductName, dbtype);
                if (!this.isHivePrimitiveType(parts[1])) {
                    name = "Map_" + parts[0] + "_" + type.getName();
                }
                if (st == null) {
                    StructuredType ste;
                    if (this.relDT != null && (ste = this.relDT.getStructuredTypeSet().findByChangedHiveType(dt)) != null) {
                        name = ste.getName();
                    }
                    st = dtDes.createStructuredType();
                    st.setName(name);
                    TypeElement te = st.createTypeElement("key");
                    LogicalDatatype logDatatype = this.getLogicalDatatype(parts[0], parts[0], dbProductName, dbtype);
                    if (logDatatype != null) {
                        te.setType(logDatatype);
                    }
                    this.setHiveDataType(te, logDatatype, parts[0]);
                    TypeElement tev = st.createTypeElement("value");
                    tev.setType(type);
                    if (type instanceof LogicalDatatype) {
                        this.setHiveDataType(tev, (LogicalDatatype)type, valueType);
                    }
                }
                st.setHiveType(StructuredType.MAP);
                return st;
            }
        } else {
            if (dt.startsWith("array")) {
                CollectionType ct = dtDes.getCollectionTypeSet().findByChangedHiveType(dt);
                if (ct != null) {
                    return ct;
                }
                String existingName = null;
                if (this.relDT != null && (ct = this.relDT.getCollectionTypeSet().findByChangedHiveType(dt)) != null) {
                    existingName = ct.getName();
                    ct = null;
                }
                String def = Token.getValBetweenBrackets(dt, 1);
                String name = "Array_" + def;
                DesignObject type = this.getDatatypeFromHive(def, dtDes, dbProductName, dbtype);
                if (!this.isHivePrimitiveType(def)) {
                    name = "Array_" + type.getName();
                }
                if (existingName != null) {
                    name = existingName;
                }
                if (ct == null) {
                    ct = dtDes.createCollectionType();
                    ct.setName(name);
                    TypeElement te = ct.getElementType();
                    te.setType(type);
                }
                return ct;
            }
            if (dt.startsWith("struct")) {
                return this.getDataTypeforStruct(dt, dtDes, dbProductName, dbtype);
            }
            if (dt.startsWith("uniontype")) {
                return this.getDataTypeforUniontype(dt, dtDes, dbProductName, dbtype);
            }
        }
        return dtDes.getDesign().getLogicalDatatypeSet().getDefaultType();
    }

    private StructuredType getDataTypeforUniontype(String un_type, DataTypesDesign dtDes, String dbProductName, RDBMSType dbtype) {
        StructuredType ste = dtDes.getStructuredTypeSet().findByChangedHiveType(un_type);
        if (ste != null) {
            ste.setHiveType(StructuredType.UNIONTYPE);
            return ste;
        }
        String existingName = null;
        if (this.relDT != null && (ste = this.relDT.getStructuredTypeSet().findByChangedHiveType(un_type)) != null) {
            existingName = ste.getName();
        }
        StructuredType st = dtDes.createStructuredType();
        if (existingName != null) {
            st.setName(existingName);
        } else {
            st.setName("UNIONTYPE_" + dtDes.getStructuredTypeSet().size());
        }
        String def = Token.getValBetweenBrackets(un_type, 1);
        StringTokenizer types = new StringTokenizer(def, ",");
        int ind = 0;
        while (types.hasMoreTokens()) {
            DesignObject type;
            String oneAttribute = types.nextToken().trim();
            if (Token.hasOpenBracket(oneAttribute)) {
                StringBuffer oneColumnPast = new StringBuffer(oneAttribute);
                while (Token.hasOpenBracket(oneAttribute) && types.hasMoreTokens()) {
                    oneColumnPast.append(",").append(types.nextToken().trim());
                    oneAttribute = oneColumnPast.toString();
                }
            }
            if ((type = this.getDatatypeFromHive(oneAttribute = oneAttribute.trim(), dtDes, dbProductName, dbtype)) == null) continue;
            TypeElement te = st.createTypeElement();
            te.setName("attr_" + ++ind);
            te.setType(type);
            if (type instanceof LogicalDatatype) {
                this.setHiveDataType(te, (LogicalDatatype)type, oneAttribute);
            }
            if (!(type instanceof StructuredType)) continue;
            te.updateReference();
        }
        st.setHiveType(StructuredType.UNIONTYPE);
        return st;
    }

    private StructuredType getDataTypeforStruct(String struct, DataTypesDesign dtDes, String dbProductName, RDBMSType dbtype) {
        StructuredType ste = dtDes.getStructuredTypeSet().findByChangedHiveType(struct);
        if (ste != null) {
            ste.setHiveType("");
            return ste;
        }
        String existingName = null;
        if (this.relDT != null && (ste = this.relDT.getStructuredTypeSet().findByChangedHiveType(struct)) != null) {
            existingName = ste.getName();
        }
        StructuredType st = dtDes.createStructuredType();
        if (existingName != null) {
            st.setName(existingName);
        }
        String def = Token.getValBetweenBrackets(struct, 1);
        StringTokenizer types = new StringTokenizer(def, ",");
        while (types.hasMoreTokens()) {
            String oneAttribute = types.nextToken().trim();
            if (Token.hasOpenBracket(oneAttribute)) {
                StringBuffer oneColumnPast = new StringBuffer(oneAttribute);
                while (Token.hasOpenBracket(oneAttribute) && types.hasMoreTokens()) {
                    oneColumnPast.append(",").append(types.nextToken().trim());
                    oneAttribute = oneColumnPast.toString();
                }
            }
            oneAttribute = oneAttribute.trim();
            int ind = oneAttribute.indexOf(58);
            String name = oneAttribute.substring(0, ind);
            String dtype = oneAttribute.substring(ind + 1);
            DesignObject type = this.getDatatypeFromHive(dtype, dtDes, dbProductName, dbtype);
            if (type == null) continue;
            TypeElement te = st.createTypeElement(name);
            te.setType(type);
            if (type instanceof LogicalDatatype) {
                this.setHiveDataType(te, (LogicalDatatype)type, dtype);
            }
            if (!(type instanceof StructuredType)) continue;
            te.updateReference();
        }
        st.setHiveType("");
        return st;
    }

    boolean isHivePrimitiveType(String type) {
        if (type.startsWith("map<") || type.startsWith("map(")) {
            return false;
        }
        if (type.startsWith("struct<") || type.startsWith("struct(")) {
            return false;
        }
        if (type.startsWith("uniontype<") || type.startsWith("uniontype(")) {
            return false;
        }
        return !type.startsWith("array<") && !type.startsWith("array(");
    }

    protected void handleCheckConstraint(Connection sqlConnection, DBObject dbo, Table table) {
        try {
            String query;
            StringBuffer sql;
            ResultSet rs = null;
            if (dbo.getSchema() != null && !"".equals(dbo.getSchema())) {
                if (this.checkSt == null) {
                    sql = new StringBuffer();
                    sql.append("SELECT t.table_schema, \n");
                    sql.append("  t.table_name, \n");
                    sql.append("  t.constraint_name, \n");
                    sql.append("  t.constraint_type, \n");
                    sql.append("  t.is_deferrable, \n");
                    sql.append("  t.initially_deferred, \n");
                    sql.append("  c.check_clause \n");
                    sql.append("FROM information_schema.check_constraints c, \n");
                    sql.append("  information_schema.table_constraints t \n");
                    sql.append("WHERE t.table_schema    = ? \n");
                    sql.append("AND t.table_name        = ? \n");
                    sql.append("AND t.constraint_type   = 'CHECK' \n");
                    sql.append("AND c.constraint_name   = t.constraint_name \n");
                    sql.append("AND c.constraint_schema = t.constraint_schema");
                    query = sql.toString();
                    this.checkSt = sqlConnection.prepareStatement(query);
                }
                this.checkSt.setString(1, dbo.getSchema());
                this.checkSt.setString(2, dbo.getName());
                rs = this.checkSt.executeQuery();
            } else {
                if (this.nullSchemaSt == null) {
                    sql = new StringBuffer();
                    sql.append("SELECT t.table_schema, \n");
                    sql.append("  t.table_name, \n");
                    sql.append("  t.constraint_name, \n");
                    sql.append("  t.constraint_type, \n");
                    sql.append("  t.is_deferrable, \n");
                    sql.append("  t.initially_deferred, \n");
                    sql.append("  c.check_clause \n");
                    sql.append("FROM information_schema.check_constraints c, \n");
                    sql.append("  information_schema.table_constraints t \n");
                    sql.append("WHERE \n");
                    sql.append(" t.table_name        = ? \n");
                    sql.append("AND t.constraint_type   = 'CHECK' \n");
                    sql.append("AND c.constraint_name   = t.constraint_name \n");
                    sql.append("AND c.constraint_schema = t.constraint_schema");
                    query = sql.toString();
                    this.nullSchemaSt = sqlConnection.prepareStatement(query);
                }
                this.nullSchemaSt.setString(1, dbo.getName());
                rs = this.nullSchemaSt.executeQuery();
            }
            if (rs != null) {
                while (rs.next()) {
                    String constrName = rs.getString(3);
                    String checkClause = rs.getString(7);
                    if (checkClause == null || this.isNotNullCheck(checkClause, table)) continue;
                    TableLevelConstraint constraint = table.createCheckConstraint(constrName, checkClause);
                    table.addCheckConstraint(constraint);
                }
                rs.close();
            }
            this.setSupportInformation_Schema(true);
        }
        catch (SQLException e) {
            this.setSupportInformation_Schema(false);
        }
    }

    private boolean isNotNullCheck(String check, Table table) {
        String constr = check.toUpperCase();
        for (Column col : table.getElementsCollection()) {
            if (!col.isMandatory() || !constr.equalsIgnoreCase(col.getName() + " IS NOT NULL")) continue;
            return true;
        }
        return false;
    }

    protected void setLogicalTypeParams(Column column, LogicalDatatype logDatatype, String size, int decimalDigits) {
        try {
            Map m = logDatatype.getToPhysical();
            MDDataType datatype = logDatatype.createDataType(this.getDbmeHandler().getRDBMSSite().getType().getName(), m);
            if (!(datatype instanceof MDImplicitSized)) {
                if (datatype instanceof MDPackedSized) {
                    if (!"0".equals(size)) {
                        column.setDataTypeParameter(PRECISION, String.valueOf(size));
                    }
                    if (decimalDigits > 0) {
                        column.setDataTypeParameter(SCALE, String.valueOf(decimalDigits));
                    }
                } else if (!"0".equals(size)) {
                    column.setDataTypeParameter(SIZE, String.valueOf(size));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleColumns(DatabaseMetaData dbmd, DBObject dboTable, Table table) throws Exception {
        String dbProductName = dbmd.getDatabaseProductName();
        ResultSet rsColumns = this.getColumns(dbmd, dboTable);
        RDBMSType dbtype = this.getStorageDesign().getRDBMSType();
        if (rsColumns != null) {
            while (rsColumns.next()) {
                int ind22;
                String colName = rsColumns.getString("COLUMN_NAME");
                short datatype = rsColumns.getShort("DATA_TYPE");
                String colDatatype = MOHTable.getSQLDataType(datatype);
                String dataTypeName = rsColumns.getString("TYPE_NAME");
                if (colDatatype == null && dataTypeName != null) {
                    colDatatype = dataTypeName;
                }
                String seed = null;
                String step = null;
                int colSize = 0;
                int colDecimalDigits = 0;
                String defaultValue = null;
                String colIsNullable = null;
                String colIsAutoIncrement = null;
                try {
                    colSize = rsColumns.getInt("COLUMN_SIZE");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    colDecimalDigits = rsColumns.getInt("DECIMAL_DIGITS");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    defaultValue = rsColumns.getString("COLUMN_DEF");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dbProductName.indexOf("PostgreSQL") > -1 && defaultValue != null && defaultValue.indexOf("identity") > -1 && (ind22 = defaultValue.indexOf("(")) > 0) {
                    String ident = defaultValue.substring(ind22);
                    ind22 = ident.indexOf("'");
                    boolean k = false;
                    if (ind22 > 0 && (ind22 = (ident = ident.substring(ind22)).indexOf("'")) > -1 && (ind22 = (ident = ident.substring(ind22 + 1)).indexOf("'")) > 0) {
                        String[] parts = (ident = ident.substring(0, ind22)).split(",");
                        if (parts.length >= 1) {
                            defaultValue = null;
                            seed = parts[0];
                        }
                        if (parts.length > 1) {
                            step = parts[1];
                        }
                    }
                }
                try {
                    colIsNullable = this.getColumn(rsColumns, "IS_NULLABLE");
                }
                catch (Exception ind22) {
                    // empty catch block
                }
                try {
                    if (dbProductName.toUpperCase().indexOf("HIVE") == -1) {
                        colIsAutoIncrement = this.getColumn(rsColumns, "IS_AUTOINCREMENT");
                    }
                }
                catch (Exception ind22) {
                    // empty catch block
                }
                String remarks = null;
                try {
                    remarks = this.getColumn(rsColumns, "REMARKS");
                }
                catch (Exception ident) {
                    // empty catch block
                }
                Column column = new Column(table.getDesignPart());
                column.setName(colName);
                if (remarks != null) {
                    column.setCommentInRDBMS(remarks);
                }
                if (seed != null) {
                    column.setIdentityColumn(true);
                    column.setAutoIncrementColumn(true);
                    column.setAutoIncrementStartWith(seed);
                    int increment = 1;
                    if (step != null) {
                        increment = Integer.valueOf(step);
                    }
                    column.setAutoIncrementIncrementBy(increment);
                }
                if (colDatatype != null) {
                    LogicalDatatype logDatatype = this.getLogicalDatatype(colDatatype, dataTypeName, dbProductName, dbtype);
                    if (logDatatype != null) {
                        column.setUse((short)1);
                        column.setLogicalDatatype(logDatatype);
                        if (dbProductName.toUpperCase().indexOf("HIVE") > -1) {
                            this.setHiveDataType(column, logDatatype, dataTypeName);
                        } else {
                            this.setLogicalTypeParams(column, logDatatype, String.valueOf(colSize), colDecimalDigits);
                        }
                    } else {
                        System.out.println("Unable to find logical datatype for: " + colDatatype);
                    }
                }
                if (defaultValue != null) {
                    column.setDefaultValue(defaultValue);
                }
                if (colIsNullable != null) {
                    if ("YES".equalsIgnoreCase(colIsNullable)) {
                        column.setNullsAllowed(true);
                    } else {
                        column.setNullsAllowed(false);
                    }
                }
                if (colIsAutoIncrement != null && "YES".equalsIgnoreCase(colIsAutoIncrement)) {
                    column.setAutoIncrementColumn(true);
                }
                table.addColumn(column);
                this.stampModelObject((ModelObject)column, table.getName(), colName);
            }
            rsColumns.close();
        }
    }

    public LogicalDatatype getLogicalDatatype(String colDatatype, String dataTypeName, String dbProductName, RDBMSType dbtype) {
        String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
        Hashtable stable = null;
        if ("MYSQL".equalsIgnoreCase(dbProductName)) {
            stable = SYNONYM_TABLE;
        } else if (dbProductName.indexOf("HIVE") > -1) {
            LogicalDatatype logDatatype;
            stable = HIVE_SYNONYM_TABLE;
            int ind = dataTypeName.indexOf(40);
            String type = dataTypeName;
            if (ind > 0) {
                type = dataTypeName.substring(0, ind);
            }
            if ((logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByName(type)) != null) {
                return logDatatype;
            }
        }
        if ("timestamp".equalsIgnoreCase(colDatatype) && "timestamptz".equalsIgnoreCase(dataTypeName)) {
            colDatatype = "TIMESTAMP WITH TIME ZONE";
            dataTypeName = "TIMESTAMP WITH TIME ZONE";
            nameDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
        }
        if (stable != null) {
            int ind;
            String dt = (String)stable.get(colDatatype.toUpperCase());
            if (dt == null && dataTypeName != null) {
                dt = (String)stable.get(dataTypeName.toUpperCase());
            }
            if (dt == null && (ind = colDatatype.indexOf(32)) > 0) {
                dt = colDatatype.substring(0, ind);
                dt = (String)stable.get(dt.toUpperCase());
            }
            if (dt != null) {
                nameDatatype = dt;
            }
        }
        LogicalDatatype logDatatype = null;
        NativeDBType nt = null;
        if (logDatatype == null && (nt = StandardDatatypeNames.getNativeDBType(dbtype, dataTypeName)) != null) {
            logDatatype = nt.getLogicalDatatype();
        }
        if (logDatatype == null) {
            logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, nameDatatype);
        }
        if (logDatatype == null) {
            logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(colDatatype, dbtype.getName());
        }
        if (logDatatype == null) {
            String nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(nameDatatype);
            logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByName(nameLogDT);
        }
        return logDatatype;
    }

    protected void handlePKS(DatabaseMetaData dbmd, DBObject dboTable, Table table) throws Exception {
        ResultSet rsPKs = this.getPrimaryKeys(dbmd, dboTable);
        TreeMap<String, String> map = new TreeMap<String, String>();
        String name = null;
        boolean hasPK = false;
        if (rsPKs != null) {
            while (rsPKs.next()) {
                String columnName = this.getColumn(rsPKs, "COLUMN_NAME");
                String seq = rsPKs.getString("KEY_SEQ");
                name = this.getColumn(rsPKs, "PK_NAME");
                map.put(seq, columnName);
                hasPK = true;
            }
            rsPKs.close();
            if (hasPK) {
                Index index;
                if (name != null) {
                    index = (Index)table.getKeySet().getByName(name);
                    if (index == null) {
                        index = table.createIndex();
                        index.setName(name);
                        this.stampModelObject((ModelObject)index, table.getSchema(), name);
                    }
                } else {
                    index = table.createIndex();
                }
                for (String columnName : map.values()) {
                    Column column;
                    if (columnName == null || (column = (Column)table.getElementByName(columnName)) == null) continue;
                    index.add(column);
                }
                index.setIndexState("Primary Constraint");
            }
        }
    }

    protected void handleIndexes(DatabaseMetaData dbmd, DBObject dboTable, Table table) throws Exception {
        ResultSet rsIndexes = this.getIndexInfo(dbmd, dboTable);
        if (rsIndexes != null) {
            while (rsIndexes.next()) {
                Index index;
                String pkTABLE_CAT = rsIndexes.getString(1);
                String pkTABLE_SCHEM = rsIndexes.getString(2);
                String pkTABLE_NAME = rsIndexes.getString(3);
                boolean indNON_UNIQUE = rsIndexes.getBoolean(4);
                String ind_QUALIFIER = rsIndexes.getString(5);
                String ind_NAME = rsIndexes.getString(6);
                int ind_TYPE = rsIndexes.getInt(7);
                String colORDINAL_POSITION = rsIndexes.getString(8);
                String col_NAME = rsIndexes.getString(9);
                String colASC_OR_DESC = rsIndexes.getString(10);
                String rowCARDINALITY = rsIndexes.getString(11);
                String numPAGES = rsIndexes.getString(12);
                String indFILTER_CONDITION = rsIndexes.getString(13);
                if (ind_TYPE <= 0) continue;
                String name = ind_NAME;
                if (name != null) {
                    index = (Index)table.getKeySet().getByName(name);
                    if (index == null) {
                        index = table.createIndex();
                        index.setName(name);
                        this.stampModelObject((ModelObject)index, table.getSchema(), index.getName());
                    } else if (index.isPK()) {
                        continue;
                    }
                } else {
                    index = table.createIndex();
                }
                String columnName = col_NAME;
                Column column = (Column)table.getElementByName(columnName);
                if (column != null) {
                    index.add(column);
                    String sortOrder = colASC_OR_DESC;
                    if ("D".equalsIgnoreCase(sortOrder)) {
                        index.setColumnSortOrder(column, "DESC");
                    }
                } else {
                    System.out.println("Unable to find column: " + columnName);
                }
                if (indNON_UNIQUE) continue;
                index.setIndexState("Unique Constraint");
            }
            rsIndexes.close();
        }
    }

    public static void createHiveUDPLibrary(Design design) {
        UDPLibrary library = new UDPLibrary();
        UserDefinedPropertyGroup group = new UserDefinedPropertyGroup("Hive");
        library.getUDPGroups().add(group);
        library.setFileName("UDPLibraryImportedFrom_Hive.udposdm");
        ArrayList<UserDefinedProperty> udpList = new ArrayList<UserDefinedProperty>();
        UserDefinedProperty udp2 = new UserDefinedProperty(null, HIVE_NAME, UserDefinedProperty.TEXT);
        udp2.setDisplayName("Hive Name");
        udp2.getObjectsVisibilityMap().put(Table.class, false);
        udp2.getObjectsVisibilityMap().put(Column.class, false);
        udp2.setGroup(group);
        udpList.add(udp2);
        udp2 = new UserDefinedProperty(null, HIVE_SCHEMA, UserDefinedProperty.TEXT);
        udp2.setDisplayName("Hive Schema");
        udp2.getObjectsVisibilityMap().put(Table.class, false);
        udp2.setGroup(group);
        udpList.add(udp2);
        udp2 = new UserDefinedProperty(null, HIVE_DATA_TYPE, UserDefinedProperty.TEXT);
        udp2.setDisplayName("HiveDataType");
        udp2.getObjectsVisibilityMap().put(Column.class, false);
        udp2.setGroup(group);
        udpList.add(udp2);
        for (UserDefinedProperty udp2 : udpList) {
            udp2.setLibrary(library);
            library.getPropertiesList().add(udp2);
        }
        design.getAppView().getUDPLibrariesPersistence().merge(library, XMLTransformationManager.getDefaultSystemTypesPath());
        design.getAppView().getUDPLibrariesPersistence().load(design, design.getAppView());
    }

    static {
        SYNONYM_TABLE.put("TEXT", "CLOB");
        SYNONYM_TABLE.put("MEDIUMTEXT", "CLOB");
        SYNONYM_TABLE.put("TINYTEXT", "CLOB");
        SYNONYM_TABLE.put("LONGTEXT", "CLOB");
        SYNONYM_TABLE.put("LONG", "CLOB");
        SYNONYM_TABLE.put("BLOB", "BLOB");
        SYNONYM_TABLE.put("TINYBLOB", "BLOB");
        SYNONYM_TABLE.put("MEDIUMBLOB", "BLOB");
        SYNONYM_TABLE.put("LONGBLOB", "BLOB");
        SYNONYM_TABLE.put("TINYINT", "SMALLINT");
        SYNONYM_TABLE.put("MEDIUMINT", "SMALLINT");
        SYNONYM_TABLE.put("DATETIME", "DATE");
        SYNONYM_TABLE.put("YEAR", "DATE");
        SYNONYM_TABLE.put("TIME", "DATE");
        HIVE_SYNONYM_TABLE.put("SMALLINT", "SMALLINT");
        HIVE_SYNONYM_TABLE.put("INT", "INTEGER");
        HIVE_SYNONYM_TABLE.put("TINYINT", "SMALLINT");
        HIVE_SYNONYM_TABLE.put("BIGINT", "BIGINT");
        HIVE_SYNONYM_TABLE.put("BOOLEAN", "SMALLINT");
        HIVE_SYNONYM_TABLE.put("BIGDECIMAL", "NUMBER");
        HIVE_SYNONYM_TABLE.put("FLOAT", "BINARY_FLOAT");
        HIVE_SYNONYM_TABLE.put("DOUBLE", "BINARY_DOUBLE");
        HIVE_SYNONYM_TABLE.put("TIMESTAMP", "TIMESTAMP");
        HIVE_SYNONYM_TABLE.put("VARCHAR", "VARCHAR2");
        HIVE_SYNONYM_TABLE.put("CHAR", "CHAR");
        HIVE_SYNONYM_TABLE.put("BINARY", "RAW");
        HIVE_SYNONYM_TABLE.put("STRING", "VARCHAR2");
        LOGGER = new Logger(MOHTable.class);
    }
}

