/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHAuxTableDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "AUX TABLE";
    private static final Logger LOGGER = new Logger(MOHAuxTableDB2.class);

    public MOHAuxTableDB2(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String ownerName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TSNAME from SYSIBM.SYSTABLES ");
                buffer.append("WHERE TYPE = 'X' and NAME = '");
                buffer.append(dbo.getName()).append("' and CREATOR = '").append(ownerName).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHAuxTableDB2.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        TableSpaceDB2 ts;
                        AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                        String tsname = rs.getString(1);
                        AUXTableDB2 aux = storage.getAUXTableSet().createAUXTable();
                        aux.setName(name);
                        this.stampModelObject(aux, dbo);
                        Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                        if (owner == null) {
                            owner = (Owner)storage.getOwnerSet().createElement(ownerName);
                            owner.setName(ownerName);
                            this.stampModelObject((ModelObject)owner, "", ownerName);
                        }
                        if (owner != null) {
                            aux.setOwner(owner);
                        }
                        if ((ts = (TableSpaceDB2)storage.getTableSpaceSet().getByName(tsname)) != null) {
                            aux.setTableSpace(ts);
                        }
                        this.initProps(sqlConnection, aux, ownerName);
                        this.initAuxIndexes(sqlConnection, aux, ownerName);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initProps(Connection sqlConnection, AUXTableDB2 aux, String ownerName) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT TBNAME, COLNAME, PARTITION ");
            buffer.append("from SYSIBM.SYSAUXRELS ");
            buffer.append("WHERE AUXTBNAME = '");
            buffer.append(aux.getName()).append("'");
            buffer.append(" AND AUXTBOWNER = '");
            buffer.append(ownerName).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHAuxTableDB2.initProps():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tableName = rs.getString(1);
                String colName = rs.getString(2);
                int partition = rs.getInt(3);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storage = (AbstractStorageDesignDB2)storageDesign;
                    TableProxyDB2 table = ((TableProxySetDB2)storage.getTableProxySet()).getByName(tableName);
                    if (table != null) {
                        aux.setTable(table);
                        ColumnProxyDB2 col = (ColumnProxyDB2)table.getColumnProxyByName(colName);
                        if (col != null) {
                            aux.setColumn(col);
                        }
                    }
                    aux.setPartNumber(partition);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initAuxIndexes(Connection sqlConnection, AUXTableDB2 aux, String ownerName) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT i.NAME, i.PGSIZE, i.BPOOL, ");
            buffer.append("i.CLOSERULE, i.COPY, i.CREATOR ");
            buffer.append("from SYSIBM.SYSINDEXES i ");
            buffer.append("WHERE i.TBNAME = '");
            buffer.append(aux.getName()).append("'");
            buffer.append(" AND i.TBCREATOR = '");
            buffer.append(ownerName).append("'");
            buffer.append(" AND not exists (");
            buffer.append(" select 1 from sysibm.systabconst t ");
            buffer.append("where ");
            buffer.append("t.ixowner = i.creator and ");
            buffer.append("t.ixname = i.name)");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHAuxTableDB2.initAuxIndexes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                int pieceSize = rs.getInt(2);
                String bpName = rs.getString(3);
                String close = rs.getString(4);
                String copy = rs.getString(5);
                String owner = rs.getString(6);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storage = (AbstractStorageDesignDB2)storageDesign;
                    AUXTableIndexDB2 index = storage.getAUXTableIndexSet().createAUXTableIndex();
                    index.setAuxTable(aux);
                    index.setName(name);
                    this.stampModelObject((ModelObject)index, ownerName, name);
                    Owner o = (Owner)storage.getOwnerSet().getByName(owner);
                    if (o != null) {
                        index.setOwner(o);
                    }
                    index.setPieceSize(pieceSize + " K");
                    BufferPoolDB2 bp = (BufferPoolDB2)storage.getBufferPoolSet().getByName(bpName);
                    if (bp != null) {
                        index.setBufferPool(bp);
                    }
                    if ("Y".equalsIgnoreCase(close)) {
                        index.setClose(true);
                    } else {
                        index.setClose(false);
                    }
                    if ("Y".equalsIgnoreCase(copy)) {
                        index.setCopy(true);
                    } else {
                        index.setCopy(false);
                    }
                    this.initStorageTemplate(sqlConnection, index);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initStorageTemplate(Connection sqlConnection, AUXTableIndexDB2 index) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT VCATNAME, STORNAME, PQTY, SQTY, ");
            buffer.append("FREEPAGE, PCTFREE, GBPCACHE ");
            buffer.append("from SYSIBM.SYSINDEXPART ");
            buffer.append("WHERE IXNAME = '");
            buffer.append(index.getName()).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHAuxTableDB2.initStorageTemplate():", e);
        }
        if (rs != null) {
            if (rs.next()) {
                String vcatName = rs.getString(1);
                String sgName = rs.getString(2).trim();
                int pqty = rs.getInt(3);
                int sqty = rs.getInt(4);
                int freepage = rs.getInt(5);
                int pctfree = rs.getInt(6);
                String gbcache = rs.getString(7);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storage = (AbstractStorageDesignDB2)storageDesign;
                    StorageTemplateDB2 st = storage.getStorageTemplateSet().createStorageTemplate();
                    index.setStorageTemplate(st);
                    if (!"".equalsIgnoreCase(sgName)) {
                        StorageGroupDB2 sg = (StorageGroupDB2)storage.getStorageGroupSet().getByName(sgName);
                        if (sg != null) {
                            st.setStorageGroup(sg);
                        }
                    } else {
                        VCatDB2 vcat = (VCatDB2)storage.getVCatSet().getByName(vcatName);
                        if (vcat != null) {
                            st.setVCat(vcat);
                        }
                    }
                    st.setSgPriqty(pqty);
                    st.setSgSeqty(sqty);
                    st.setFreePage(freepage);
                    st.setPctFree(pctfree);
                    if ("A".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("ALL");
                    } else if ("N".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("NONE");
                    } else if ("S".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("SYSTEM");
                    } else if ("".equalsIgnoreCase(gbcache)) {
                        st.setGbCache("CHANGED");
                    }
                    StorageTemplateDB2 realst = storage.getStorageTemplateSet().removeIfExistEqual(st);
                    if (realst != index.getStorageTemplate()) {
                        index.setStorageTemplate(realst);
                    }
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT name from SYSIBM.SYSTABLES").append(' ');
                buffer.append("WHERE TYPE = 'X' and CREATOR = '");
                buffer.append(dboNext.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHAuxTableDB2.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, OBJECT_TYPE, dboNext.getName());
                    list.add(dboTable);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

