/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.odbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.odbc.MOHForeignKeyODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHTableODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHViewODBC;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;

public final class DBMExtractionHandlerODBC
extends AbstractDBMExtractionHandler {
    private static final String DB_NAME_UDB = "UDB";
    private static final String DB_NAME_ORACLE = "ORACLE";
    private static final String DB_NAME_SQL_SERVER = "SQL SERVER";
    private static DBMExtractionHandlerODBC dbmExtractionHandler;
    private List mohObjects = null;

    public DBMExtractionHandlerODBC(StorageDesign sd) {
        super(sd);
    }

    @Override
    public List getSchemas(Connection conn) throws Exception {
        boolean schemaInTable = false;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (conn != null) {
            DatabaseMetaData dbmd = conn.getMetaData();
            try {
                dbmd.isCatalogAtStart();
                String sch = dbmd.getSchemaTerm();
                schemaInTable = "schema".equalsIgnoreCase(sch) ? true : dbmd.supportsSchemasInTableDefinitions();
                dbmd.getCatalogTerm();
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
            ResultSet resultSet = null;
            boolean isFirst = true;
            if (schemaInTable) {
                try {
                    resultSet = dbmd.getSchemas();
                    if (!resultSet.next()) {
                        resultSet = dbmd.getCatalogs();
                        DBMExtractionHandlerODBC.setSchemaBased(false);
                    } else {
                        isFirst = false;
                        DBMExtractionHandlerODBC.setSchemaBased(true);
                    }
                }
                catch (SQLException e) {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    resultSet = dbmd.getCatalogs();
                    DBMExtractionHandlerODBC.setSchemaBased(false);
                }
                int colnum = 1;
                try {
                    colnum = resultSet.getMetaData().getColumnCount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (DBMExtractionHandlerODBC.isSchemaBased()) {
                    String catalog;
                    DBObject dbo;
                    String schema;
                    if (!isFirst) {
                        schema = resultSet.getString(1);
                        dbo = new DBObject(false, schema);
                        if (colnum > 1) {
                            catalog = resultSet.getString(2);
                            dbo.setCatalog(catalog);
                        }
                        list.add(dbo);
                    }
                    while (resultSet.next()) {
                        schema = resultSet.getString(1);
                        dbo = new DBObject(false, schema);
                        if (colnum > 1) {
                            catalog = resultSet.getString(2);
                            dbo.setCatalog(catalog);
                        }
                        list.add(dbo);
                    }
                } else {
                    DBObject dbo;
                    String schema;
                    if (!isFirst) {
                        schema = resultSet.getString(1);
                        dbo = new DBObject(false, schema);
                        list.add(dbo);
                    }
                    while (resultSet.next()) {
                        schema = resultSet.getString(1);
                        dbo = new DBObject(false, schema);
                        list.add(dbo);
                    }
                }
                resultSet.close();
            } else {
                DBObject dbo;
                String schema;
                try {
                    resultSet = dbmd.getCatalogs();
                    if (!resultSet.next()) {
                        resultSet = dbmd.getSchemas();
                        DBMExtractionHandlerODBC.setSchemaBased(true);
                    } else {
                        isFirst = false;
                        DBMExtractionHandlerODBC.setSchemaBased(false);
                    }
                }
                catch (SQLException e) {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    resultSet = dbmd.getSchemas();
                    DBMExtractionHandlerODBC.setSchemaBased(true);
                }
                if (!isFirst) {
                    schema = resultSet.getString(1);
                    dbo = new DBObject(false, schema);
                    list.add(dbo);
                }
                while (resultSet.next()) {
                    schema = resultSet.getString(1);
                    dbo = new DBObject(false, schema);
                    list.add(dbo);
                }
                resultSet.close();
            }
        }
        return list;
    }

    public static AbstractDBMExtractionHandler getInstance() {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerODBC(null);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    @Override
    public List getMOHObjects(Connection conn) {
        if (conn != null) {
            this.init(conn);
        }
        if (this.mohObjects == null) {
            this.mohObjects = new ArrayList();
            this.mohObjects.add(new MOHTableODBC(this));
            this.mohObjects.add(new MOHForeignKeyODBC(this));
            this.mohObjects.add(new MOHViewODBC(this));
        }
        return this.mohObjects;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        if (this.dbMajorVersion == -1) {
            String version = this.dbProductVersion.indexOf(46) > -1 ? this.dbProductVersion.substring(0, this.dbProductVersion.indexOf(46)) : this.dbProductVersion;
            try {
                this.dbMajorVersion = Integer.parseInt(version);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RDBMSSiteSet rdbmsSiteSet = this.getDesign().getRDBMSSiteSet();
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_ORACLE) > -1 || this.dbProductName.toUpperCase().indexOf("HIVE") > -1 || this.dbProductName.toUpperCase().indexOf("IMPALA") > -1) {
            switch (this.dbMajorVersion) {
                case 8: 
                case 9: {
                    return rdbmsSiteSet.get(StorageDesignOraclev9i.RDBMS_TYPE);
                }
                case 10: {
                    return rdbmsSiteSet.get(StorageDesignOraclev10g.RDBMS_TYPE);
                }
                case 11: {
                    return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
                }
                case 12: {
                    if (this.dbMinorVersion < 2) {
                        return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
                    }
                    return rdbmsSiteSet.get(StorageDesignOraclev12cR2.RDBMS_TYPE);
                }
            }
            if (this.dbProductName.toUpperCase().indexOf("HIVE") > -1 || this.dbProductName.toUpperCase().indexOf("IMPALA") > -1) {
                return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
            }
            return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_SQL_SERVER) > -1) {
            return rdbmsSiteSet.get(StorageDesignSqlServerv2k5.RDBMS_TYPE);
        }
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_UDB) > -1) {
            switch (this.dbMajorVersion) {
                case 7: {
                    return rdbmsSiteSet.get(StorageDesignUDBv71.RDBMS_TYPE);
                }
                case 8: {
                    return rdbmsSiteSet.get(StorageDesignUDBv81.RDBMS_TYPE);
                }
                case 9: {
                    return rdbmsSiteSet.get(StorageDesignUDBv9.RDBMS_TYPE);
                }
            }
            return rdbmsSiteSet.get(StorageDesignUDBv9.RDBMS_TYPE);
        }
        StorageDesign sd = this.getRelationalDesign().getStorageDesign();
        if (sd != null) {
            return sd.getRDBMSSite();
        }
        switch (this.dbMajorVersion) {
            case 7: {
                return rdbmsSiteSet.get(StorageDesignDB2v70.RDBMS_TYPE);
            }
            case 8: {
                return rdbmsSiteSet.get(StorageDesignDB2v80.RDBMS_TYPE);
            }
        }
        return rdbmsSiteSet.get(StorageDesignDB2v80.RDBMS_TYPE);
    }

    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        if (this.storageDesign == null) {
            this.storageDesign = ApplicationView.getInstance().getCurrentDesign().getRelationalDesign().getStorageDesign();
        }
        if (!this.isNullStorageDesign(this.getStorageDesign())) {
            super.generateDesign(conn, selectedObjects, importLog, monitor);
        }
    }
}

