/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class MOHPlSqlStorageObjectOracle<T>
extends AbstractMOHandler {
    protected boolean dbaUser;
    private static String WRAPPED = "WRAPPED";

    public MOHPlSqlStorageObjectOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHPlSqlStorageObjectOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    public abstract Logger getLogger();

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract " + this.getType() + " begin");
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            if (statement == null) {
                boolean ora11g = this.getDbmeHandler().getDBMajorVersion() >= 11;
                String typeColumn = ora11g ? "OBJECT_TYPE" : "TYPE";
                String nameColumn = ora11g ? "OBJECT_NAME" : "NAME";
                String filterCondition = this.getFilterConditionOracle(nameColumn);
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("DISTINCT").append(' ');
                buffer.append(nameColumn).append(' ');
                buffer.append("FROM").append(' ');
                if (ora11g) {
                    buffer.append(this.dbaUser ? "dba_procedures" : "all_procedures").append(' ');
                } else {
                    buffer.append(this.dbaUser ? "dba_source" : "all_source").append(' ');
                }
                buffer.append("WHERE").append(' ');
                buffer.append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append(typeColumn).append('=').append('\'').append(this.getType()).append('\'').append(' ');
                if (filterCondition != null) {
                    buffer.append("AND").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ');
                buffer.append(nameColumn);
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                this.getLogger().error("extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String name = rs.getString(1);
                DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), name, this.getType(), dboNext.getName());
                list.add(dbo);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("Extract " + this.getType() + " end");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        try (PreparedStatement statement = this.prepareStatement(sqlConnection);){
            for (int i = 0; i < selectedObjects.size(); ++i) {
                this.generate(statement, (DBObject)selectedObjects.get(i), importLog);
            }
        }
    }

    protected PreparedStatement prepareStatement(Connection sqlConnection) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TEXT").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_source" : "all_source").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TYPE").append('=').append('\'');
        buffer.append(this.getType()).append('\'').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("line");
        String sql = buffer.toString();
        return sqlConnection.prepareStatement(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T generate(PreparedStatement statement, DBObject dbObject, ImportLogger importLog) throws Exception {
        T result = null;
        if (this.canBeGenerated(dbObject)) {
            ResultSet rs = null;
            try {
                statement.setString(1, dbObject.getSchema());
                statement.setString(2, dbObject.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                this.getLogger().error("generate():", e);
            }
            if (rs != null) {
                String source;
                boolean wrapped = false;
                StringBuilder sourceStringBuilder = new StringBuilder();
                try {
                    int count = 0;
                    while (rs.next()) {
                        String text = rs.getString("TEXT");
                        if (count == 0) {
                            String afterName;
                            int nameIndex;
                            String upperCaseName = dbObject.getName().toUpperCase();
                            String upperCaseText = text.toUpperCase().trim();
                            if (upperCaseText.startsWith(this.getType()) && (nameIndex = upperCaseText.indexOf(upperCaseName, this.getType().length())) > -1 && !(afterName = upperCaseText.substring(nameIndex + upperCaseName.length())).isEmpty() && (afterName = afterName.substring(1).trim()).startsWith(WRAPPED)) {
                                wrapped = true;
                                break;
                            }
                        }
                        ++count;
                        sourceStringBuilder.append(text);
                    }
                }
                finally {
                    rs.close();
                }
                if ((source = wrapped ? this.getType() + ' ' + dbObject.getName() + ' ' + WRAPPED : sourceStringBuilder.toString().trim()).length() > 0) {
                    StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
                    if (storageDesign != null) {
                        result = this.generateObject(storageDesign, dbObject, source);
                    } else {
                        this.getLogger().error("Unable to find Storage Design!");
                    }
                }
            }
            this.incrementImported(dbObject, importLog);
        }
        return result;
    }

    protected boolean canBeGenerated(DBObject dbObject) {
        return this.getType().equalsIgnoreCase(dbObject.getType());
    }

    protected void incrementImported(DBObject dbObject, ImportLogger importLog) {
        importLog.incrementImportedStatements();
        this.addToHandledObjects(dbObject);
    }

    public abstract T generateObject(StorageDesignOracle var1, DBObject var2, String var3);
}

