/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableSpaceOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTableSpaceOracle.class);
    protected boolean dbaUser;

    public MOHTableSpaceOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHTableSpaceOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            String filterCondition = this.getFilterConditionOracle("TABLESPACE_NAME");
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("NOT").append(' ').append("IN").append(' ');
            buffer.append('(').append('\'');
            buffer.append("SYSTEM").append('\'').append(')').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("CONTENTS").append("<>");
            buffer.append('\'').append("UNDO").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("NOT").append(' ').append('(');
            buffer.append("CONTENTS").append('=').append('\'');
            buffer.append("TEMPORARY").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("EXTENT_MANAGEMENT").append('=').append('\'');
            buffer.append("LOCAL").append('\'').append(')').append(' ');
            if (filterCondition != null) {
                buffer.append("AND").append(' ').append(filterCondition).append(' ');
            }
            buffer.append("ORDER BY").append(' ');
            buffer.append("TABLESPACE_NAME");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            System.out.println("MOHTableSpaceOracle.extract(): " + e.getMessage());
            LOGGER.error("MOHTableSpaceOracle.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tsName = rs.getString(1);
                DBObject dboTs = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tsName, OBJECT_TYPE);
                list.add(dboTs);
            }
            rs.close();
        }
        statement.close();
        return list;
    }

    private String getTablespaceQuery(StorageDesign storageDesign, boolean allProps) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("INITIAL_EXTENT").append(',');
        buffer.append("NEXT_EXTENT").append(',');
        buffer.append("MIN_EXTENTS").append(',');
        buffer.append("MAX_EXTENTS").append(',');
        buffer.append("PCT_INCREASE").append(',');
        buffer.append("MIN_EXTLEN").append(',');
        buffer.append("STATUS").append(',');
        buffer.append("CONTENTS").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("EXTENT_MANAGEMENT").append(',');
        buffer.append("ALLOCATION_TYPE");
        if (storageDesign instanceof StorageDesignOraclev10g) {
            buffer.append(',');
            buffer.append("BIGFILE").append(',');
            buffer.append("DEF_TAB_COMPRESSION");
        }
        if (storageDesign instanceof StorageDesignOraclev11g) {
            buffer.append(',');
            buffer.append("ENCRYPTED").append(',');
            buffer.append("COMPRESS_FOR");
            if (storageDesign instanceof StorageDesignOraclev12c && allProps) {
                buffer.append(',');
                buffer.append("DEF_INMEMORY").append(',');
                buffer.append("DEF_INMEMORY_PRIORITY").append(',');
                buffer.append("DEF_INMEMORY_DISTRIBUTE").append(',');
                buffer.append("DEF_INMEMORY_COMPRESSION").append(',');
                buffer.append("DEF_INMEMORY_DUPLICATE");
            }
        }
        buffer.append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("TABLESPACE_NAME").append('=').append(' ').append('?');
        buffer.append("AND").append(' ');
        buffer.append("CONTENTS").append(' ').append("<>").append(' ');
        buffer.append('\'').append("UNDO").append('\'').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("NOT").append(' ').append('(');
        buffer.append("CONTENTS").append('=').append('\'');
        buffer.append("TEMPORARY").append('\'').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("EXTENT_MANAGEMENT").append('=').append('\'');
        buffer.append("LOCAL").append('\'').append(')').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("TABLESPACE_NAME");
        return buffer.toString();
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        Statement statement = null;
        boolean allProps = true;
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            ResultSet rs = null;
            try {
                try {
                    if (statement == null) {
                        String query = this.getTablespaceQuery(storageDesign, allProps);
                        statement = sqlConnection.prepareStatement(query);
                    }
                    statement.setString(1, dbo.getName());
                    rs = statement.executeQuery();
                }
                catch (SQLSyntaxErrorException e) {
                    if (allProps) {
                        allProps = false;
                        if (statement != null) {
                            statement.close();
                        }
                        String query = this.getTablespaceQuery(storageDesign, allProps);
                        statement = sqlConnection.prepareStatement(query);
                        statement.setString(1, dbo.getName());
                        rs = statement.executeQuery();
                    }
                    throw e;
                }
                if (rs != null) {
                    if (rs.next()) {
                        if (storageDesign instanceof StorageDesignOracle) {
                            TableSpaceOracle tableSpace = ((StorageDesignOracle)storageDesign).getTableSpaceSet().createTableSpace();
                            tableSpace.setName(dbo.getName());
                            this.setProperties(tableSpace, rs, allProps);
                            this.stampModelObject(tableSpace, dbo);
                        } else {
                            LOGGER.error("Unable to find Storage Design!");
                        }
                    }
                    rs.close();
                }
            }
            catch (Exception e) {
                System.out.println("MOHTableSpaceOracle.generate(): " + e.getMessage());
                LOGGER.error("MOHTableSpaceOracle.generate():", e);
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setProperties(TableSpaceOracle tableSpace, ResultSet resultSet, boolean allProps) throws Exception {
        long initialExtent = resultSet.getLong("INITIAL_EXTENT");
        long nextExtent = resultSet.getLong("NEXT_EXTENT");
        int minExtents = Integer.MAX_VALUE;
        int maxExtents = Integer.MAX_VALUE;
        try {
            minExtents = resultSet.getInt("MIN_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in min_extent", e);
        }
        try {
            maxExtents = resultSet.getInt("MAX_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in max_extent", e);
        }
        int pctIncrease = resultSet.getInt("PCT_INCREASE");
        int minExtLen = resultSet.getInt("MIN_EXTLEN");
        String status = resultSet.getString("STATUS");
        String contents = resultSet.getString("CONTENTS");
        String logging = resultSet.getString("LOGGING");
        String extentManagement = resultSet.getString("EXTENT_MANAGEMENT");
        String allocationType = resultSet.getString("ALLOCATION_TYPE");
        tableSpace.setDSInitialExtent(initialExtent);
        tableSpace.setDSNextExtent(nextExtent);
        tableSpace.setDSMinExtents(minExtents);
        tableSpace.setDSMaxExtents(String.valueOf(maxExtents));
        tableSpace.setDSPctIncrease(pctIncrease);
        tableSpace.setMinExtLen(minExtLen);
        tableSpace.setStatus(status.trim());
        tableSpace.setContents(contents.trim());
        tableSpace.setLogging(logging.trim());
        tableSpace.setExtentManagement(extentManagement.trim());
        if ("UNIFORM".equalsIgnoreCase(allocationType.trim())) {
            tableSpace.setEMLocalSubtype("UNIFORM");
            try {
                tableSpace.setEMUniformSize(resultSet.getInt("NEXT_EXTENT"));
            }
            catch (Exception e) {
                LOGGER.error("error in next_extent", e);
            }
        }
        if (tableSpace instanceof TableSpaceOraclev10g) {
            TableSpaceOraclev10g tableSpacev10g = (TableSpaceOraclev10g)tableSpace;
            String bigfile = resultSet.getString("BIGFILE");
            if ("YES".equals(bigfile)) {
                tableSpacev10g.setFileType("BIGFILE");
            } else if ("NO".equals(bigfile)) {
                tableSpacev10g.setFileType("SMALLFILE");
            }
            String compression = resultSet.getString("DEF_TAB_COMPRESSION");
            if ("ENABLED".equals(compression)) {
                tableSpacev10g.setDSCompression("COMPRESS");
            } else if ("DISABLED".equals(compression)) {
                tableSpacev10g.setDSCompression("NOCOMPRESS");
            }
            if (this.getStorageDesign() instanceof StorageDesignOraclev11g) {
                String encrypted = resultSet.getString("ENCRYPTED");
                tableSpacev10g.setEncrypt(encrypted);
                String compressFor = resultSet.getString("COMPRESS_FOR");
                if (compressFor != null) {
                    int rowLevelLockingIndex = compressFor.indexOf(" ROW LEVEL LOCKING");
                    if (rowLevelLockingIndex > -1) {
                        compressFor = compressFor.substring(0, rowLevelLockingIndex);
                    }
                    tableSpacev10g.setCompressionType(compressFor);
                }
                if (this.getStorageDesign() instanceof StorageDesignOraclev12c && allProps) {
                    String inMemory = resultSet.getString("DEF_INMEMORY");
                    if ("DISABLED".equals(inMemory)) {
                        tableSpacev10g.setInMemory("NO");
                    } else if ("ENABLED".equals(inMemory)) {
                        tableSpacev10g.setInMemory("YES");
                        tableSpacev10g.setInMemoryPriority(resultSet.getString("DEF_INMEMORY_PRIORITY"));
                        tableSpacev10g.setInMemoryDistribute(resultSet.getString("DEF_INMEMORY_DISTRIBUTE"));
                        tableSpacev10g.setInMemoryCompression(resultSet.getString("DEF_INMEMORY_COMPRESSION"));
                        tableSpacev10g.setInMemoryDuplicate(resultSet.getString("DEF_INMEMORY_DUPLICATE"));
                    }
                }
            }
        }
    }
}

