/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v10g;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHBitmapIndexesv10g
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "BITMAP JOIN";
    private static final Logger LOGGER = new Logger(MOHBitmapIndexesv10g.class);
    protected boolean dbaUser;
    PreparedStatement col_statement = null;
    PreparedStatement jcol_statement = null;

    public MOHBitmapIndexesv10g(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHBitmapIndexesv10g(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        this.jcol_statement = null;
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        for (BitmapJoinIndexOracle bmjInd : sd.getBitmapJoinIndexSet()) {
            this.initJoinColumns(sqlConnection, bmjInd, bmjInd.getUser().getName(), importLog);
        }
        if (this.jcol_statement != null) {
            this.jcol_statement.close();
        }
    }

    public void generateOld(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        this.col_statement = null;
        this.jcol_statement = null;
        ResultSet rs = null;
        Iterator it = this.getStorageDesign().getTableProxySet().iterator();
        TableProxyOracle table = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("OWNER").append(',');
        buffer.append("INDEX_NAME").append(',');
        buffer.append("INDEX_TYPE").append(',');
        buffer.append("TABLE_OWNER").append(',');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("TABLE_TYPE").append(',');
        buffer.append("UNIQUENESS").append(',');
        buffer.append("COMPRESSION").append(',');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("INI_TRANS").append(',');
        buffer.append("MAX_TRANS").append(',');
        buffer.append("INITIAL_EXTENT").append(',');
        buffer.append("NEXT_EXTENT").append(',');
        buffer.append("MIN_EXTENTS").append(',');
        buffer.append("MAX_EXTENTS").append(',');
        buffer.append("PCT_INCREASE").append(',');
        buffer.append("INCLUDE_COLUMN").append(',');
        buffer.append("FREELISTS").append(',');
        buffer.append("FREELIST_GROUPS").append(',');
        buffer.append("PCT_FREE").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("DEGREE").append(',');
        buffer.append("PARTITIONED").append(',');
        buffer.append("TEMPORARY").append(',');
        buffer.append("GENERATED").append(',');
        buffer.append("SECONDARY").append(',');
        buffer.append("BUFFER_POOL").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_indexes" : "all_indexes").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("TABLE_OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("JOIN_INDEX").append('=').append('\'');
        buffer.append("YES").append('\'');
        String sql = buffer.toString();
        Statement statement = null;
        while (it.hasNext()) {
            if (statement == null) {
                statement = sqlConnection.prepareStatement(sql);
            }
            table = (TableProxyOracle)it.next();
            try {
                statement.setString(1, table.getObject().getSchema());
                statement.setString(2, table.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHBitmapIndexesv10g.generate(): " + e.getMessage());
                LOGGER.error("MOHBitmapIndexesv10g.generate(): ", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                String owner = rs.getString("TABLE_OWNER");
                String localPartitioning = rs.getString("PARTITIONED");
                String tablespace = rs.getString("TABLESPACE_NAME");
                String logging = rs.getString("LOGGING");
                BitmapJoinIndexOracle bitmapIndex = ((StorageDesignOracle)this.getStorageDesign()).getBitmapJoinIndexSet().createBitmapJoinIndex();
                UserOracle user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(owner);
                bitmapIndex.setName(indexName);
                bitmapIndex.setUser(user);
                bitmapIndex.setTable(table);
                bitmapIndex.setLocalPartitioning(localPartitioning);
                if (tablespace != null) {
                    bitmapIndex.setTablespace(tablespace);
                }
                bitmapIndex.setLogging(logging);
                this.stampModelObject((ModelObject)bitmapIndex, owner, indexName);
                this.initIndexColumns(sqlConnection, bitmapIndex, owner, importLog);
                this.initJoinColumns(sqlConnection, bitmapIndex, owner, importLog);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.jcol_statement != null) {
            this.jcol_statement.close();
        }
    }

    public void initJoinColumns(Connection sqlConnection, BitmapJoinIndexOracle bitmapIndex, String owner, ImportLogger importLog) throws SQLException {
        if (this.jcol_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("INNER_TABLE_OWNER").append(',');
            buffer.append("INNER_TABLE_NAME").append(',');
            buffer.append("INNER_TABLE_COLUMN").append(',');
            buffer.append("OUTER_TABLE_OWNER").append(',');
            buffer.append("OUTER_TABLE_NAME").append(',');
            buffer.append("OUTER_TABLE_COLUMN").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_join_ind_columns" : "all_join_ind_columns").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("INDEX_OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("INDEX_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.jcol_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.jcol_statement.setString(1, owner);
            this.jcol_statement.setString(2, bitmapIndex.getName());
            rs = this.jcol_statement.executeQuery();
            HashMap<Table, ArrayList<String>> map = new HashMap<Table, ArrayList<String>>();
            if (rs != null) {
                while (rs.next()) {
                    String innerTableOwner = rs.getString("INNER_TABLE_OWNER");
                    String innerTable = rs.getString("INNER_TABLE_NAME");
                    String innerColumn = rs.getString("INNER_TABLE_COLUMN");
                    String outerTableOwner = rs.getString("OUTER_TABLE_OWNER");
                    String outerTable = rs.getString("OUTER_TABLE_NAME");
                    String outerColumn = rs.getString("OUTER_TABLE_COLUMN");
                    Table iTable = this.getRelationalDesign().getTableSet().getBySchemaAndName(innerTableOwner, innerTable);
                    Table oTable = this.getRelationalDesign().getTableSet().getBySchemaAndName(outerTableOwner, outerTable);
                    if (iTable == null || oTable == null) continue;
                    Column iColumn = (Column)iTable.getElementByName(innerColumn);
                    Column oColumn = (Column)oTable.getElementByName(outerColumn);
                    if (iColumn == null || oColumn == null) continue;
                    bitmapIndex.setJoinColumns(oColumn.getObjectID());
                    bitmapIndex.setJoinColumns(iColumn.getObjectID());
                    ArrayList<String> list = (ArrayList<String>)map.get(oTable);
                    if (list == null) {
                        list = new ArrayList<String>();
                        map.put(oTable, list);
                    }
                    list.add(oColumn.getName());
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                Index index = this.getUniqueIndexForColumnNames((Table)entry.getKey(), (List)entry.getValue());
                if (index == null) continue;
                bitmapIndex.setDimensionKeys(((Table)entry.getKey()).getObjectID());
                bitmapIndex.setDimensionKeys(index.getObjectID());
            }
        }
        catch (Exception e) {
            LOGGER.error("MOHBitmapIndexesv10g.initJoinColumns():", e);
        }
    }

    private void initIndexColumns(Connection sqlConnection, BitmapJoinIndexOracle bitmapIndex, String owner, ImportLogger importLog) throws SQLException {
        if (this.col_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("TABLE_OWNER").append(',');
            buffer.append("TABLE_NAME").append(',');
            buffer.append("COLUMN_NAME").append(',');
            buffer.append("COLUMN_POSITION").append(',');
            buffer.append("DESCEND").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_ind_columns" : "all_ind_columns").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("INDEX_OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("INDEX_NAME").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("COLUMN_POSITION");
            String sql = buffer.toString();
            this.col_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.col_statement.setString(1, owner);
            this.col_statement.setString(2, bitmapIndex.getName());
            rs = this.col_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    String tableName = rs.getString("TABLE_NAME");
                    Table table = (Table)this.getRelationalDesign().getTableSet().getByName(tableName);
                    if (table != null) {
                        Column column = (Column)table.getElementByName(columnName);
                        String descend = rs.getString("DESCEND");
                        if (column != null) {
                            bitmapIndex.setIndexColumns(column.getObjectID());
                            bitmapIndex.setIndexColumns(descend);
                            continue;
                        }
                        importLog.addWarning("Column " + columnName + " is not imported");
                        continue;
                    }
                    importLog.addWarning("Table " + tableName + " is not imported");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("MOHBitmapIndexesv10g.initIndexColumns():", e);
        }
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        ArrayList copy = new ArrayList();
        copy.addAll(names);
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            for (int j = 0; j < names.size(); ++j) {
                if (!columns[i].getName().equalsIgnoreCase((String)names.get(j))) continue;
                copy.remove(names.get(j));
            }
        }
        return copy.size() == 0;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        if (sd != null) {
            Object[] ips;
            for (Object obj : ips = sd.getIndexProxySet().toArray()) {
                Index ind;
                IndexProxyOracle ip = (IndexProxyOracle)obj;
                if (ip.getBitmapJoinIndex() == null || (ind = (Index)ip.getObject()) == null) continue;
                ind.remove();
            }
        }
    }
}

