/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPartitionFunctionSqlServerv2k5
extends MOHandlerSqlServer {
    private StorageDesignSqlServerv2k5 storage;
    private DataBaseSqlServerv2k5 database;
    private List boundaryValues = new ArrayList();
    private static final Logger LOGGER = new Logger(MOHPartitionFunctionSqlServerv2k5.class);

    public MOHPartitionFunctionSqlServerv2k5(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        if (this.getStorageDesign() instanceof StorageDesignSqlServerv2k5) {
            this.storage = (StorageDesignSqlServerv2k5)this.getStorageDesign();
            for (DataBaseSqlServerv2k5 this.database : this.storage.getDataBaseSet()) {
                if (this.database.isNullInstance()) continue;
                this.initPartitionFunctions(sqlConnection, importLog);
            }
        }
    }

    private void initPartitionFunctions(Connection sqlConnection, ImportLogger importLog) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        String db = this.database.getName();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ').append(MOHPartitionFunctionSqlServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("name, function_id, fanout part_number, ");
            buffer.append("boundary_value_on_right ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.partition_functions");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initPartitionFunctions():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String function_id = rs.getString(2);
                String isRight = rs.getString(4);
                PartitionFunctionSqlServerv2k5 partFunc = (PartitionFunctionSqlServerv2k5)this.storage.getPartitionFunctionSet().createPartitionFunction();
                partFunc.setName(name);
                partFunc.setDatabase(this.database);
                this.stampModelObject((ModelObject)partFunc, this.database, name);
                if (isRight.equals("1")) {
                    partFunc.setRangeType("RIGHT");
                }
                this.initDataType(sqlConnection, partFunc, function_id);
                this.initBoundaryValues(sqlConnection, partFunc, function_id);
                this.initPartitionSchemes(sqlConnection, partFunc, function_id);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initPartitionSchemes(Connection sqlConnection, PartitionFunctionSqlServerv2k5 partFunc, String id) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        String db = this.database.getName();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ').append(MOHPartitionFunctionSqlServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("name, data_space_id as partition_scheme_id ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.partition_schemes ");
            buffer.append("WHERE").append(" type = 'PS' ");
            buffer.append("AND").append(" function_id = ").append(id);
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initPartitionSchemes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String partScheme_id = rs.getString(2);
                PartitionSchemeSqlServerv2k5 partScheme = (PartitionSchemeSqlServerv2k5)this.storage.getPartitionSchemeSet().createPartitionScheme();
                partScheme.setName(name);
                partScheme.setPartitionFunction(partFunc);
                this.stampModelObject((ModelObject)partScheme, this.database, name);
                this.initMapping(sqlConnection, partScheme, partScheme_id);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initMapping(Connection sqlConnection, PartitionSchemeSqlServerv2k5 partScheme, String id) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        String db = this.database.getName();
        ArrayList<String> list = new ArrayList<String>();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ').append(MOHPartitionFunctionSqlServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append(" fg.name as fg_name, partition_scheme_id,destination_id,ds.data_space_id  ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.destination_data_spaces ds,sys.filegroups fg ");
            buffer.append("WHERE").append(" partition_scheme_id =  ").append(id);
            buffer.append("AND").append(" ds.data_space_id = fg.data_space_id  ");
            buffer.append("order by partition_scheme_id, destination_id");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initMappingType():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String fgName = rs.getString(1);
                list.add(fgName);
            }
        }
        if (statement != null) {
            statement.close();
        }
        if (list.size() > 0) {
            String type = this.getMappingType(list);
            partScheme.setMappingType(type);
            if (partScheme.isSingleFileGroupSelected()) {
                String fgName = (String)list.get(0);
                FileGroupSqlServerv2k5 fileGroup = (FileGroupSqlServerv2k5)this.database.getFilegroups().getByName(fgName);
                if (fileGroup != null) {
                    partScheme.setSingleFileGroup(fileGroup);
                }
            } else {
                ListIterator it = this.getBoundaryValues().listIterator();
                while (it.hasNext()) {
                    String boundaryVal = (String)it.next();
                    partScheme.setMappingTable(boundaryVal);
                    String filegroup = "";
                    int index = it.nextIndex() - 1;
                    if (index < list.size()) {
                        filegroup = (String)list.get(index);
                    }
                    partScheme.setMappingTable(filegroup);
                }
                partScheme.setMappingTable("MAXVALUE");
                partScheme.setMappingTable((String)list.get(list.size() - 1));
            }
        }
    }

    private String getMappingType(List list) {
        Iterator it = list.iterator();
        String fg = (String)list.get(0);
        while (it.hasNext()) {
            String obj = (String)it.next();
            if (fg.equals(obj)) continue;
            return "MULTIPLE FILE GROUPS";
        }
        return "SINGLE FILE GROUP";
    }

    private void initBoundaryValues(Connection sqlConnection, PartitionFunctionSqlServerv2k5 partFunc, String id) throws Exception {
        this.getBoundaryValues().clear();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        String db = this.database.getName();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ').append(MOHPartitionFunctionSqlServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("function_id, boundary_id, parameter_id, cast(value as varchar) as b_value ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.partition_range_values ");
            buffer.append("WHERE").append(' ');
            buffer.append("function_id = ").append(id);
            buffer.append(" order by ").append("boundary_id");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initBoundaryValues():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                Object value = rs.getObject(4);
                this.addBoundaryValues(value);
                partFunc.setBoundaryValues(value.toString());
                partFunc.setBoundaryValues("");
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initDataType(Connection sqlConnection, PartitionFunctionSqlServerv2k5 partFunc, String id) throws Exception {
        this.getBoundaryValues().clear();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        String db = this.database.getName();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ').append(MOHPartitionFunctionSqlServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("t.name datatype,par.max_length, par.precision,par.scale ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.partition_parameters par, sys.types t ");
            buffer.append("WHERE").append(' ');
            buffer.append("function_id = ").append(id);
            buffer.append(" and par.system_type_id = t.system_type_id ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionFunctionSqlServerv2k5.initBoundaryValues():", e);
        }
        if (rs != null && rs.next()) {
            String type = rs.getString(1);
            int length = rs.getInt(2);
            int precision = rs.getInt(3);
            int scale = rs.getInt(4);
            if (length != 0) {
                type = type + "(" + length + ")";
            } else if (precision != 0) {
                type = type + "(" + precision;
                if (scale != 0) {
                    type = type + "," + scale;
                }
                type = type + ")";
            }
            partFunc.setInputType(type);
        }
        if (statement != null) {
            statement.close();
        }
    }

    public List getBoundaryValues() {
        return this.boundaryValues;
    }

    public void addBoundaryValues(Object boundaryValues) {
        this.boundaryValues.add(boundaryValues);
    }
}

