/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ODExtractionController {
    private ProgressDialog monitor;
    private String oldDesignPath;
    private String designName;
    private boolean inExistingDesign;
    private static final Logger LOGGER = new Logger(ODExtractionController.class);
    private ApplicationView view;
    private Design design;
    ImportLogger importLog;

    public ODExtractionController(ApplicationView view) {
        this.view = view;
        this.design = view.getCurrentDesign();
    }

    public ODExtractionHandler getExtractionHandler() {
        return ODExtractionHandler.getInstance(this.view);
    }

    public List getWorkAreas(Connection connection) throws Exception {
        return this.getExtractionHandler().getWorkAreas(connection);
    }

    public List getApplicationSystems(Connection connection, List workAreas) throws Exception {
        return this.getExtractionHandler().getApplicationSystems(connection, workAreas);
    }

    public List getODObjects(Connection connection, List appSystems) throws Exception {
        return this.getExtractionHandler().getODObjects(connection, appSystems);
    }

    public String getDBProductVersion() {
        return this.getExtractionHandler().getDBProductVersion();
    }

    public String getDBProductName() {
        return this.getExtractionHandler().getDBProductName();
    }

    public void generateDesign(Connection connection, Properties cd, List selectedObjects, boolean inExistingDesign) throws Exception {
        RDBMSSite site;
        this.inExistingDesign = inExistingDesign;
        this.oldDesignPath = this.view.getCurrentDesign().getDesignPath();
        String dsnName = ConnectionInfo.getConnectionName(cd);
        this.designName = !inExistingDesign ? dsnName : this.view.getDesignName();
        this.view.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
        if (this.view.designExists(this.designName)) {
            this.view.deleteDesign(this.designName);
        }
        if (this.view != null && !inExistingDesign) {
            this.view.setDesignName(this.designName);
        }
        if (!inExistingDesign) {
            this.design.setFileName(this.designName);
        }
        if (inExistingDesign) {
            RelationalDesign newRelDesign = this.design.addRelationalDesign(dsnName);
            this.design.setRelationalDesign(newRelDesign);
        }
        if ((site = this.getExtractionHandler().getRDBMSSite()) != null) {
            this.design.setSelectedRDBMSSite(site);
        }
        new Thread(new Runner(connection, selectedObjects)).start();
    }

    public void showRelationalSubViews() {
        for (RelationalDesign pDesign : this.design.getRelationalDesigns()) {
            if (!pDesign.isLoaded()) continue;
            pDesign.setMainViewVisible(true);
            Iterator itsv = pDesign.getDesignSubviews().iterator();
            while (itsv.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)itsv.next();
                if (!ph.getDesignPartView().mustBeVisible()) continue;
                ph.setVisible(true);
            }
        }
    }

    public List getBranches(Connection connection) {
        try {
            return this.getExtractionHandler().getBranches(connection);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList();
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private void createAppSystemsSubViews(List selectedObjects) {
        if (this.getExtractionHandler().getSelectedAppSystems().size() > 1) {
            try {
                String appPrefix = "APPSYS_";
                String folderPrefix = "FOLDER_";
                for (ODObject odObject : selectedObjects) {
                    ContainerView tv;
                    DesignPartView dpv;
                    String appName;
                    String prefix;
                    String id = odObject.getParentID();
                    if ("ENTITY".equalsIgnoreCase(odObject.getType())) {
                        Entity entity;
                        id = id + "_L";
                        prefix = odObject.containerType.equalsIgnoreCase("APP") ? appPrefix : folderPrefix;
                        appName = odObject.getParentName();
                        dpv = this.design.getLogicalDesign().getSubViewByID(id);
                        if (dpv == null) {
                            dpv = this.design.getLogicalDesign().getSubViewByName(prefix + appName);
                        }
                        if (dpv == null) {
                            dpv = this.design.getLogicalDesign().createDesignPartSubView();
                            dpv.setName(prefix + appName);
                            dpv.setMustBeVisible(false);
                            dpv.setDPVId(id);
                        }
                        if ((entity = (Entity)this.getExtractionHandler().getImportedObject(odObject.getIrid())) == null) continue;
                        tv = entity.getTopView().createViewSynonim(dpv);
                        ((TVEntity)tv).addTVRelations();
                        tv.addTVTypeSubstitutions();
                        continue;
                    }
                    if (!"TABLE".equalsIgnoreCase(odObject.getType()) && !"VIEW".equalsIgnoreCase(odObject.getType())) continue;
                    id = id + "_R";
                    prefix = odObject.containerType.equalsIgnoreCase("APP") ? appPrefix : folderPrefix;
                    appName = odObject.getParentName();
                    dpv = this.design.getRelationalDesign().getSubViewByID(id);
                    if (dpv == null) {
                        dpv = this.design.getRelationalDesign().getSubViewByName(prefix + appName);
                    }
                    if (dpv == null) {
                        dpv = this.design.getRelationalDesign().createDesignPartSubView();
                        dpv.setName(prefix + appName);
                        dpv.setMustBeVisible(false);
                        dpv.setDPVId(id);
                    }
                    if ("TABLE".equalsIgnoreCase(odObject.getType())) {
                        Table table = (Table)this.getExtractionHandler().getImportedObject(odObject.getIrid());
                        if (table == null) continue;
                        tv = table.getTopView().createViewSynonim(dpv);
                        ((TVTable)tv).addTVFKRelations();
                        tv.addTVTypeSubstitutions();
                        continue;
                    }
                    TableView view = (TableView)this.getExtractionHandler().getImportedObject(odObject.getIrid());
                    if (view == null) continue;
                    tv = view.getTopView().createViewSynonim(dpv);
                    tv.addTVTypeSubstitutions();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error creating AppSystems SubViews:", e);
            }
        }
    }

    private void rearrangeSubViews() {
        ((DPVLogical)this.design.getLogicalDesign().getMainView()).resizeEntities();
        ((DPVLogical)this.design.getLogicalDesign().getMainView()).rearrangeNewDiagram(false);
        Iterator itd = this.design.getLogicalDesign().getLogicalDesignSubviews().iterator();
        while (itd.hasNext()) {
            DesignPartViewPlaceHolder dpvp = (DesignPartViewPlaceHolder)itd.next();
            DesignPartView dpv = dpvp.getDesignPartView();
            ((DPVLogical)dpv).resizeEntities();
            ((DPVLogical)dpv).rearrangeNewDiagram(false);
        }
        for (RelationalDesign pDesign : this.design.getRelationalDesigns()) {
            Iterator itsv = pDesign.getDesignSubviews().iterator();
            while (itsv.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)itsv.next();
                DesignPartView dpv = ph.getDesignPartView();
                ((DPVRelational)dpv).rearrangeNewDiagram();
            }
        }
    }

    private class Runner
    implements Runnable {
        private Connection connection;
        private List selectedObjects;
        private int selectedObjectsCount;

        public Runner(Connection connection, List selectedObjects) {
            this.connection = connection;
            this.selectedObjects = selectedObjects;
            this.selectedObjectsCount = selectedObjects.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ODExtractionController.this.design.closeAllDiagrams();
                ODExtractionController.this.importLog = new ImportLogger();
                try {
                    ODExtractionController.this.monitor = new ProgressDialog(ODExtractionController.this.view, "", 0, 100);
                    try {
                        ODExtractionController.this.view.setImporting(true);
                        ODExtractionController.this.design.setPropagatePKChahges(false);
                        ApplicationView.canLogging = false;
                        try {
                            ODExtractionController.this.monitor.setProgress(5);
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.GenerateDesign"));
                            ODExtractionController.this.monitor.setProgress(10);
                            ODExtractionController.this.getExtractionHandler().generateDesign(this.connection, this.selectedObjects, ODExtractionController.this.importLog, ODExtractionController.this.monitor);
                            if (ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign) {
                                String msg = ((StorageDesign.NullStorageDesign)ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite())).getName();
                                LOGGER.error("Error Generate Design: " + msg);
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ODExtractionController.UnableToGenerateDesign"), msg, 0);
                            }
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.RearrangeTypes"));
                            ODExtractionController.this.monitor.setProgress(80);
                            try {
                                ODExtractionController.this.design.getDataTypesDesign().rearrangeTypes();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Types", e);
                            }
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.RearrangeEntities"));
                            ODExtractionController.this.monitor.setProgress(85);
                            try {
                                ODExtractionController.this.design.getLogicalDesign().rearrangeViews();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Views", e);
                            }
                            try {
                                ODExtractionController.this.design.getRelationalDesign().createArcsFromTableCheckConstraints();
                            }
                            catch (Exception e) {
                                LOGGER.error("Error in creating Arcs from table Check constraints", e);
                            }
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.RearrangeTables"));
                            ODExtractionController.this.monitor.setProgress(90);
                            try {
                                ((DPVRelational)ODExtractionController.this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Tables", e);
                            }
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.RearrangeViews"));
                            ODExtractionController.this.monitor.setProgress(93);
                            ODExtractionController.this.monitor.setNote(Messages.getString("ODExtractionController.CreateAppSystemsSubViews"));
                            ODExtractionController.this.monitor.setProgress(97);
                            ODExtractionController.this.createAppSystemsSubViews(this.selectedObjects);
                            ODExtractionController.this.rearrangeSubViews();
                            ODExtractionController.this.design.getRelationalDesign().showFKArcs();
                            ODExtractionController.this.design.setDirty(true);
                            if (!(ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign)) {
                                ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                                ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()).setTempModel(false);
                                ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()).setDirty(true);
                                ODExtractionController.this.design.getStorageDesign(ODExtractionController.this.design.getSelectedRDBMSSite()).sortCollections();
                            }
                            ODExtractionController.this.monitor.setProgress(100);
                            if (ODExtractionController.this.inExistingDesign) {
                                ODExtractionController.this.view.getCurrentDesign().setDesignPath(ODExtractionController.this.oldDesignPath);
                            } else {
                                ODExtractionController.this.view.getCurrentDesign().setDesignPath("");
                            }
                            ODExtractionController.this.view.synchronizeTitle();
                            System.gc();
                        }
                        finally {
                            if (ODExtractionController.this.design != null) {
                                ODExtractionController.this.design.setPropagatePKChahges(true);
                            }
                            ApplicationView.canLogging = true;
                            ODExtractionController.this.view.setImporting(false);
                        }
                        if (ODExtractionController.this.design != null) {
                            Iterator it = ODExtractionController.this.design.getLogicalDesign().getArcSet().iterator();
                            while (it.hasNext()) {
                                Arc arc = (Arc)it.next();
                                Entity ent = arc.getEntity();
                                Iterator itd = ODExtractionController.this.design.getLogicalDesign().getLogicalDesignSubviews().iterator();
                                while (itd.hasNext()) {
                                    DesignPartViewPlaceHolder dpvp = (DesignPartViewPlaceHolder)itd.next();
                                    DesignPartView dpv = dpvp.getDesignPartView();
                                    TVEntity tv = (TVEntity)ent.getFirstViewForDPV(dpv);
                                    if (tv == null) continue;
                                    tv.addArcs();
                                }
                            }
                        }
                    }
                    finally {
                        ODExtractionController.this.view.getCurrentDesign().setDesignPath(ODExtractionController.this.oldDesignPath);
                        ODExtractionController.this.monitor.close();
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ODExtractionController.this.design.getRelationalDesign().sortCollections();
                            ODExtractionController.this.design.getLogicalDesign().sortCollections();
                            ODExtractionController.this.design.getDataTypesDesign().sortCollections();
                            if (ODExtractionController.this.design.getLogicalDesign().getEntitySet().size() > 0) {
                                // empty if block
                            }
                            Iterator it = ODExtractionController.this.design.getLogicalDesign().getDesignSubviews().iterator();
                            while (it.hasNext()) {
                                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
                                if (!ph.getDesignPartView().mustBeVisible()) continue;
                                ph.setVisible(true);
                                ph.getDesignPartView().straightenLines();
                            }
                            if (ODExtractionController.this.design.getRelationalDesign().getTableSet().size() > 0) {
                                // empty if block
                            }
                            if (ODExtractionController.this.view.getSettings().showImportLog()) {
                                LogReport logPanel = new LogReport(ODExtractionController.this.view);
                                logPanel.setLog(ODExtractionController.this.importLog.generateDDLReport(ODExtractionController.this.view, Runner.this.selectedObjectsCount));
                                logPanel.showDialog(new Dimension(750, 550));
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception e) {
                ODExtractionController.this.design.destroyAll(false);
                ODExtractionController.this.design = null;
                LOGGER.error("Error Generate Design: " + ODExtractionController.this.view.getDesignName(), e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ODExtractionController.UnableToGenerateDesign"), Messages.getString("ODExtractionController.ErrorGenerateDesign"), 0);
            }
        }
    }
}

