/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.MDUser;
import oracle.dbtools.crest.model.MDUserFactory;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.NameValidator;
import oracle.dbtools.crest.model.ObjectChange;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapImplementation;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.wc.SVNStatus;

public abstract class ModelIDObject
extends ModelObject
implements PropertyMap,
RepositoryObject,
ID_ObjectPropertyTranslator,
StorableObject {
    private ObjectChange creation = new ObjectChange();
    private ObjectChange change = new ObjectChange();
    public boolean dirty = false;
    private String comment = "";
    private String notes = "";
    protected String id;
    protected String shortID;
    protected int pathID = 0;
    public static final String USER_GENERATED = "User generated";
    private String generatorID = "User generated";
    private Set listeners = new HashSet();
    private boolean shouldEngineer = true;
    private PropertyMap properties;
    private boolean temporaryWriteable = false;
    private String ownerDesignName;
    private boolean existsInRepository;
    private boolean nameFixed = false;
    private String commentInRDBMS;
    private boolean markedGenerate = true;
    private boolean dropEnabled = false;
    private boolean isDialogVisible = false;
    public boolean showModal = false;
    private boolean shouldMerge = true;
    protected transient boolean readOnly;
    private boolean showForFirstTime = false;
    private int numID;
    private JDialog propsDialog = null;
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private boolean checkedOut = false;
    private String checkedOutBy = "";
    private boolean checkedOutByMe = false;
    protected RepositoryObject pac_Element;
    protected String segmentedStorageName;
    protected String directorySegmentName = "";
    private static StringBuffer idbuf = new StringBuffer();
    private String remoteObjectID = "";
    private String remoteModelID = "";
    private String remoteDesignID = "";
    private String remoteObjectRelativeStorageName = "";
    private List<ModelIDObject> parsedDependOnList;
    private boolean parsedForDependency = false;
    private String parsedDependOnString;
    protected boolean nameHasQuotes = false;
    private boolean loadedCompletely = false;
    private boolean usedAsRemoteObject = false;
    private boolean restoredFromSavedDelete = false;
    private static final Logger LOGGER = new Logger(ModelIDObject.class);
    private SVNStorableObjectStatus svnStorableObjectStatus = null;

    public abstract String getObjectTypeName();

    public String getOldObjectTypeName() {
        return this.getObjectTypeName();
    }

    public void setComment(String comment) {
        if (this.isWriteable()) {
            this.comment = comment != null ? comment : "";
        }
    }

    public void setNotes(String notes) {
        if (this.isWriteable()) {
            this.notes = notes != null ? notes : "";
        }
    }

    public String getComment() {
        return this.comment;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setCommentInRDBMS(String comment) {
        if (comment != null && !"null".equalsIgnoreCase(comment)) {
            this.commentInRDBMS = comment;
        }
    }

    public String getCommentInRDBMS() {
        String result = this.commentInRDBMS;
        result = result == null ? "" : result;
        return result;
    }

    public ObjectChange getCreation() {
        return this.creation;
    }

    public String getCreationTime() {
        return this.getCreation().getTimeString();
    }

    public MDUser getCreator() {
        return this.getCreation().getUser();
    }

    public void setCreator(MDUser user) {
        if (this.isWriteable()) {
            this.getCreation().setUser(user);
        }
    }

    public ObjectChange getChange() {
        return this.change;
    }

    public MDUser getChanger() {
        return this.getChange().getUser();
    }

    public void setChanger(MDUser user) {
        if (this.isWriteable() && !this.getChange().getUser().getName().equals(user.getName())) {
            this.getChange().setUser(user);
            this.fireChange(ObjectChangeEvent.CHANGER_CHANGED);
        }
    }

    public String getChangeTime() {
        return this.getChange().getTimeString();
    }

    public void setObjectID(String id) {
        if (this.id != null && !this.id.equals(id) && this.getDesign() != null) {
            this.getDesign().updateDesignObjectId(this.id, id);
        }
        this.id = id;
        this.resetShortID();
    }

    protected void resetShortID() {
        if (this.id == null) {
            this.id = this.getObjectID();
        }
        this.shortID = ModelIDObject.getShortID(this.id);
    }

    public static String getShortID(String longID) {
        String result = longID;
        if (longID != null && !"".equalsIgnoreCase(longID)) {
            String[] parts = longID.split("-");
            if (parts.length == 6) {
                idbuf.setLength(0);
                idbuf.append(parts[0]).append('-').append(parts[1]).append('-').append(parts[5]);
                result = idbuf.toString();
                idbuf.setLength(0);
            } else if (parts.length == 5) {
                idbuf.setLength(0);
                idbuf.append(parts[0]).append('-').append(parts[4]);
                result = idbuf.toString();
                idbuf.setLength(0);
            } else {
                result = longID;
            }
        }
        return result;
    }

    public String getObjectID() {
        return this.id;
    }

    public String getShortObjectID() {
        if (this.shortID == null) {
            this.resetShortID();
        }
        return this.shortID;
    }

    public int getPathID() {
        return this.pathID;
    }

    public void setPathID(int pathID) {
        this.pathID = pathID;
    }

    public String getPathIDString() {
        return String.valueOf(this.getPathID());
    }

    public String createGlobalID() {
        this.setObjectID(this.getAppView().getIDGenerator().createNewID());
        return this.getObjectID();
    }

    public String getGeneratorID() {
        return this.generatorID;
    }

    public DesignObject getGenerator() {
        return this.getDesign().getDesignObject(this.getGeneratorID());
    }

    public void setGeneratorID(String value) {
        if (this.isWriteable()) {
            this.generatorID = value;
        }
    }

    public abstract String getIDPrefix();

    public void setReadOnly(boolean value) {
        if (this.isReadOnly() != value) {
            this.readOnly = value;
        }
    }

    public void setTemporaryWriteable(boolean value) {
        this.temporaryWriteable = value;
    }

    public boolean isTemporaryWriteable() {
        return this.temporaryWriteable;
    }

    public final void setReadWritable(boolean value) {
        this.setReadOnly(!value);
    }

    public boolean isReadOnly() {
        if (this.getRepositoryOID() != null && this.getDesign().isLoadFromDB() && !this.getDesign().isLoading()) {
            return !this.isCheckedOutByMe();
        }
        return this.readOnly;
    }

    @Override
    public final boolean isWriteable() {
        return !this.isReadOnly();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.getChange().setTimeNow();
            this.getChange().setUser(MDUserFactory.getInstance().getCurrentUser());
        }
    }

    @Override
    public boolean setName(String name) {
        if (!this.isNameFixed() && super.setName(name)) {
            ElementSet set = this.getSet();
            if (set != null && set.canSort()) {
                set.sort();
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
            return true;
        }
        return false;
    }

    public void setNameFixed(boolean value) {
        if (this.nameFixed != value) {
            this.nameFixed = value;
            this.setDirty(true);
        }
    }

    public boolean isNameFixed() {
        return this.nameFixed;
    }

    public void setShouldEngineer(boolean value) {
        this.setShouldEngineer(value, true);
    }

    public void setShouldEngineer(boolean value, boolean setDirty) {
        if (this.shouldEngineer != value) {
            this.shouldEngineer = value;
            if (setDirty) {
                this.setDirty(true);
            }
        }
    }

    public boolean getShouldEngineer() {
        return this.shouldEngineer;
    }

    protected Set getListeners() {
        return this.listeners;
    }

    protected abstract void fireChange(ObjectChangeEvent var1);

    public void addReplaceLabeledComment(String label, String comment) {
        String oldComment = this.getComment();
        oldComment = StringUtilities.removeAllBetween(oldComment, StringUtilities.labeledStart(label), StringUtilities.labeledEnd());
        this.setComment(new StringBuffer(oldComment).append(StringUtilities.labeledComment(label, comment)).toString());
    }

    public void removeLabeledComment(String label) {
        String oldComment = this.getComment();
        this.setComment(StringUtilities.removeAllBetween(oldComment, StringUtilities.labeledStart(label), StringUtilities.labeledEnd()));
    }

    public boolean isSystemObject() {
        return false;
    }

    public boolean belongsToDesign() {
        return this.belongsToDesign(this.getDesign());
    }

    public boolean shouldBeDroppedIndirectly() {
        return false;
    }

    public boolean belongsToDesign(Design design) {
        if (design.getCurrentOperation() == 5) {
            return true;
        }
        return this.getOwnerDesignName().equals(design.getName());
    }

    public String getOwnerDesignName() {
        if (this.isSystemObject()) {
            return Design.getSystemDesignName();
        }
        String value = this.ownerDesignName;
        if (value == null || "".equals(value)) {
            return this.getDesign().getFileName();
        }
        return value;
    }

    public void setOwnerDesignName(String designName) {
        if (!this.isSystemObject()) {
            this.ownerDesignName = designName;
        }
    }

    public boolean hasOwnerDesignName() {
        return !this.getDesign().isNewDesign() && this.ownerDesignName != null;
    }

    @Override
    public void setProperty(String key, String value) {
        this.getProperties().setProperty(key, value);
    }

    public void setOwnerDesign() {
        this.setOwnerDesign(this.getDesign());
    }

    public void setOwnerDesign(Design design) {
        this.setOwnerDesignName(design.getFileName());
    }

    @Override
    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    @Override
    public boolean hasProperty(String key) {
        if (this.properties == null) {
            return false;
        }
        return this.getProperties().hasProperty(key);
    }

    @Override
    public boolean hasProperty(String key, String value) {
        if (this.properties == null) {
            return false;
        }
        return this.getProperties().hasProperty(key, value);
    }

    @Override
    public void removeProperty(String key) {
        this.getProperties().removeProperty(key);
    }

    @Override
    public void clearProperties() {
        this.getProperties().clearProperties();
        this.properties = null;
    }

    @Override
    public Iterator getPropertyNames() {
        if (this.properties == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.getProperties().getPropertyNames();
    }

    protected PropertyMap getProperties() {
        if (this.properties == null) {
            this.properties = new PropertyMapImplementation();
        }
        return this.properties;
    }

    public void setPersisted(boolean value) {
        this.existsInRepository = value;
    }

    public boolean getPersisted() {
        return this.existsInRepository;
    }

    public void remove() {
        LOGGER.error("Remove not implemented for " + this.getObjectTypeName());
    }

    public int getMaxNameLength() {
        return 18;
    }

    public String getFilePath() {
        return this.getStorageName();
    }

    public void setFilePath(String filePath) {
    }

    public boolean isDropEnabled() {
        if (!ApplicationView.DROP_GENERATED_OBJECTS_ONLY) {
            return this.dropEnabled;
        }
        return this.dropEnabled && this.isMarkedGenerate();
    }

    public void setDropEnabled(boolean dropEnabled) {
        this.dropEnabled = dropEnabled;
    }

    public boolean isMarkedGenerate() {
        return this.markedGenerate;
    }

    public void setMarkedGenerate(boolean markedGenerate) {
        this.markedGenerate = markedGenerate;
    }

    public boolean isDialogVisible() {
        if (this.isDialogVisible && this.propsDialog != null) {
            this.propsDialog.toFront();
        }
        return this.isDialogVisible;
    }

    public void setDialogVisible(boolean isDialogVisible, JDialog dialog) {
        this.isDialogVisible = isDialogVisible;
        this.propsDialog = dialog;
    }

    public void showPropertyDialog() {
    }

    public void showPropertyDialogOnNew() {
        if (this.getAppView().getSettings().showPropertiesDialogOnNew()) {
            this.showForFirstTime = true;
            try {
                try {
                    this.showPropertyDialog();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.showForFirstTime = false;
            }
        }
    }

    public boolean shouldBeMerge() {
        return this.shouldMerge;
    }

    public void setShouldMerge(boolean shouldMerge) {
        this.shouldMerge = shouldMerge;
    }

    public boolean showForFirstTime() {
        return this.showForFirstTime;
    }

    public void setShowForFirstTime(boolean showForFirstTime) {
        this.showForFirstTime = showForFirstTime;
    }

    public int getNumID() {
        return this.numID;
    }

    public void setNumID(int numID) {
        this.numID = numID;
    }

    public void closePropertiesDialog() {
        if (this.propsDialog != null) {
            try {
                this.propsDialog.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JDialog getPropertiesDialog() {
        return this.propsDialog;
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public void setRepositoryOID(String repositoryOID) {
        this.repositoryOID = repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public void setRepositoryOVID(String repositoryOVID) {
        this.repositoryOVID = repositoryOVID;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public void setCheckedOut(boolean checkedOut) {
        this.checkedOut = checkedOut;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public void setCheckedOutBy(String checkedOutBy) {
        this.checkedOutBy = checkedOutBy;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public void setCheckedOutByMe(boolean checkedOutByMe) {
        this.checkedOutByMe = checkedOutByMe;
    }

    @Override
    public boolean canBedeleted() {
        return true;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return this.getPAC_Element() == null;
    }

    @Override
    public void setPAC_Element(RepositoryObject object) {
        this.pac_Element = object;
    }

    public String getCreatedBy() {
        return this.getCreator().getName();
    }

    public void setCreatedBy(String user) {
        this.getCreation().setUser(MDUserFactory.getInstance().getUser(user));
    }

    public String getChangedBy() {
        return this.getChanger().getName();
    }

    public void setChangedBy(String user) {
        this.getChange().setUser(MDUserFactory.getInstance().getUser(user));
    }

    public String getCreatedTime() {
        return this.getCreation().getTimeString("UTC");
    }

    public void setCreatedTime(String timeString) {
        if (timeString != null && !"".equals(timeString)) {
            this.getCreation().setTimeString(timeString);
        }
    }

    public String getChangedTime() {
        return this.getChange().getTimeString("UTC");
    }

    public void setChangedTime(String timeString) {
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        Design design = this.getDesign();
        if (design != null) {
            DesignObject result = design.getDesignObject(id);
            if (result == null) {
                Map map = design.getCorrespondenceMap();
                if (map != null) {
                    return map.get(id);
                }
            } else {
                return result;
            }
        }
        return null;
    }

    @Override
    public String translateObjectToID(String propertyName, Object object) {
        if (object != null && object instanceof ModelIDObject) {
            return ((ModelIDObject)object).getObjectID();
        }
        return null;
    }

    @Override
    public String getStoragePath() {
        return null;
    }

    @Override
    public String getStorageName() {
        return null;
    }

    public String getSegmentedStorageName() {
        if (this.segmentedStorageName == null) {
            return this.getStorageName();
        }
        return this.segmentedStorageName;
    }

    public void setSegmentedStorageName(String segmentedStorageName) {
        this.segmentedStorageName = segmentedStorageName;
    }

    public String getDirectorySegmentName() {
        return this.directorySegmentName;
    }

    public void setDirectorySegmentName(String directorySegmentName) {
        this.directorySegmentName = directorySegmentName;
    }

    public void setDirectorySegmentName(String directorySegmentName, boolean clear) {
        this.directorySegmentName = directorySegmentName;
    }

    public String replaceIDsInValue(String value) {
        if (value != null && !"".equals(value)) {
            Map map;
            String res = "";
            if (this.getDesign() != null && (map = this.getDesign().getCorrespondenceMap()) != null) {
                StringTokenizer st = null;
                if (value.indexOf(44) > 0) {
                    st = new StringTokenizer(value, ",");
                } else if (value.trim().indexOf(32) > 0) {
                    st = new StringTokenizer(value.trim(), " ");
                }
                if (st != null) {
                    boolean first = true;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        String id = token.trim();
                        ModelIDObject obj = (ModelIDObject)map.get(id);
                        if (obj != null && obj.getObjectID() != id) {
                            token = obj.getObjectID();
                        }
                        if (first) {
                            res = token;
                            first = false;
                            continue;
                        }
                        res = res + "," + token;
                    }
                    return res;
                }
                ModelIDObject obj = (ModelIDObject)map.get(value);
                if (obj != null) {
                    String newID = obj.getObjectID();
                    return newID;
                }
            }
        }
        return value;
    }

    public ElementSet getSet() {
        return null;
    }

    public boolean isDataObject() {
        return true;
    }

    public boolean isRemoteObject() {
        return this.remoteObjectID != null && !"".equalsIgnoreCase(this.remoteObjectID);
    }

    public String getRemoteObjectID() {
        return this.remoteObjectID;
    }

    public void setRemoteObjectID(String remoteObjectID) {
        this.remoteObjectID = remoteObjectID;
    }

    public String getRemoteModelID() {
        return this.remoteModelID;
    }

    public void setRemoteModelID(String remoteModelID) {
        this.remoteModelID = remoteModelID;
    }

    public String getRemoteObjectStorageName() {
        String dpath = this.getDesign().getDesignStoragePath(this.getRemoteDesignID());
        if (dpath != null) {
            return dpath + this.getRemoteObjectRelativeStorageName();
        }
        return this.getRemoteObjectRelativeStorageName();
    }

    public ArrayList<SearchDockable> getAllSearchDockables() {
        return null;
    }

    public void addSearchDockable(SearchDockable sd) {
    }

    public SearchDockable getLastNonPinnedSearchDockable() {
        return null;
    }

    public int getSearchDockableIdSequence() {
        return 0;
    }

    public void closeAllSearchDockables() {
    }

    public String getRemoteDesignID() {
        return this.remoteDesignID;
    }

    public void setRemoteDesignID(String remoteDesignID) {
        this.remoteDesignID = remoteDesignID;
    }

    public String getRemoteObjectRelativeStorageName() {
        return this.remoteObjectRelativeStorageName;
    }

    public void setRemoteObjectRelativeStorageName(String remoteObjectRelativeStorageName) {
        this.remoteObjectRelativeStorageName = remoteObjectRelativeStorageName;
    }

    public String getRelativeStorageName() {
        String dpath = this.getDesign().getStoragePath();
        String stName = this.getSegmentedStorageName();
        if (stName.indexOf(dpath) == 0) {
            return stName.substring(dpath.length());
        }
        return null;
    }

    public void setAllRemoteObjectIDsAndPath(ModelIDObject remoteObject) {
        if (remoteObject.isRemoteObject()) {
            this.setRemoteObjectID(remoteObject.getRemoteObjectID());
            this.setRemoteModelID(remoteObject.getRemoteModelID());
            this.setRemoteDesignID(remoteObject.getRemoteDesignID());
            this.setRemoteObjectRelativeStorageName(remoteObject.getRemoteObjectRelativeStorageName());
        } else {
            this.setRemoteObjectID(remoteObject.getObjectID());
            this.setRemoteModelID(remoteObject.getModelID());
            this.setRemoteDesignID(remoteObject.getDesign().getObjectID());
            this.setRemoteObjectRelativeStorageName(remoteObject.getRelativeStorageName());
            if (!remoteObject.isUsedAsRemoteObject()) {
                remoteObject.setUsedAsRemoteObject(true);
                if (!remoteObject.isDirty()) {
                    remoteObject.setDirty(true);
                }
            }
        }
    }

    public void copyAllRemoteObjectIDsAndPath(ModelIDObject target) {
        if (this.isRemoteObject()) {
            target.setRemoteObjectID(this.getRemoteObjectID());
            target.setRemoteModelID(this.getRemoteModelID());
            target.setRemoteDesignID(this.getRemoteDesignID());
            target.setRemoteObjectRelativeStorageName(this.getRemoteObjectRelativeStorageName());
        }
    }

    public String getModelID() {
        return null;
    }

    public void copyDynamicProperties(ModelIDObject obj) {
        obj.clearProperties();
        Iterator it = this.getPropertyNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            String value = this.getProperty(propName);
            if (value == null) continue;
            obj.setProperty(propName, value);
        }
    }

    public List<ModelIDObject> getParsedDependOnList() {
        if (this.parsedDependOnList == null) {
            this.parsedDependOnList = new ArrayList<ModelIDObject>();
        }
        if (this.parsedDependOnList.size() == 0) {
            ModelIDObject.parseInlineIdList(this.parsedDependOnString, this.parsedDependOnList, this);
        }
        return this.parsedDependOnList;
    }

    public boolean isParsedForDependency() {
        return this.parsedForDependency;
    }

    public void setParsedForDependency(boolean parsedForDependency) {
        this.parsedForDependency = parsedForDependency;
    }

    public String getParsedDependOnString() {
        if (this.parsedDependOnList != null && this.parsedDependOnList.size() > 0) {
            this.parsedDependOnString = ModelIDObject.getInlineIdList(this.parsedDependOnList);
        }
        return this.parsedDependOnString;
    }

    public void setParsedDependOnString(String parsedDependOnString) {
        this.parsedDependOnString = parsedDependOnString;
    }

    public static String getInlineIdList(List<ModelIDObject> list) {
        if (list.size() > 0) {
            boolean first = true;
            StringBuffer sb = new StringBuffer();
            for (ModelIDObject obj : list) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append(obj.getObjectID());
            }
        }
        return null;
    }

    public static void parseInlineIdList(String idlist, List<ModelIDObject> list, ModelIDObject idTranslator) {
        if (idlist != null && !"".equals(idlist)) {
            String[] ids = idlist.split(",");
            if (ids.length == 0) {
                ids = idlist.split(" ");
            }
            for (int i = 0; i < ids.length; ++i) {
                ModelIDObject obj = (ModelIDObject)idTranslator.translateIdToObject("parsedDependOnID", ids[i]);
                if (obj == null) continue;
                list.add(obj);
            }
        }
    }

    public boolean getNameHasQuotes() {
        return this.nameHasQuotes;
    }

    public void setNameHasQuotes(boolean nameHasQuotes) {
        this.nameHasQuotes = nameHasQuotes;
    }

    public String getFormatedName(NameValidator sd) {
        return this.getFormatedName(sd, false);
    }

    public String getFormatedName(NameValidator sd, boolean quoted) {
        String fname = this.getName();
        if (quoted || this.getNameHasQuotes() || !sd.isValidName(fname)) {
            return sd.getLeftQuotingChar() + fname + sd.getRightQuotingChar();
        }
        return fname;
    }

    @Override
    public boolean isLoadedCompletely() {
        return this.loadedCompletely;
    }

    @Override
    public void setLoadedCompletely(boolean loadedCompletely) {
        this.loadedCompletely = loadedCompletely;
    }

    public boolean isUsedAsRemoteObject() {
        return this.usedAsRemoteObject;
    }

    public void setUsedAsRemoteObject(boolean usedAsRemoteObject) {
        this.usedAsRemoteObject = usedAsRemoteObject;
    }

    public SVNStorableObjectStatus getSVNStorableObjectStatus() {
        if (!this.getDesign().isVersioned()) {
            return null;
        }
        String sn = this.getSegmentedStorageName();
        if (this.svnStorableObjectStatus == null && sn != null && sn.length() > 0) {
            ISVNStatus isvnStatus;
            File objFile = new File(sn);
            if (objFile.exists() && (isvnStatus = SVNClientHelper.getInstance().getSingleStatusLocal(objFile)) != null) {
                this.svnStorableObjectStatus = new SVNStorableObjectStatus(this.getDesign(), isvnStatus, false, false);
            }
        } else if (this.svnStorableObjectStatus.getISVNStatus() == null) {
            this.svnStorableObjectStatus.setTextStatus("");
        }
        return this.svnStorableObjectStatus;
    }

    public SVNStorableObjectStatus getSVNStorableObjectStatus(boolean checkStatus) {
        if (!this.getDesign().isVersioned()) {
            return null;
        }
        String sn = this.getSegmentedStorageName();
        if (this.svnStorableObjectStatus == null && checkStatus && sn != null && sn.length() > 0) {
            ISVNStatus isvnStatus;
            File objFile = new File(sn);
            if (objFile.exists() && (isvnStatus = SVNClientHelper.getInstance().getSingleStatusLocal(objFile)) != null) {
                this.svnStorableObjectStatus = new SVNStorableObjectStatus(this.getDesign(), isvnStatus, false, false);
            }
        } else if (this.svnStorableObjectStatus == null && sn != null && sn.length() > 0) {
            try {
                SVNUrl searchUrl = new SVNUrl("file://" + sn);
                Design.SVNStatusAndPropertiesPair svnStatusAndPropertiesPair = this.getDesign().getSVNPropertiesCache().get(searchUrl);
                if (svnStatusAndPropertiesPair == null) {
                    svnStatusAndPropertiesPair = this.getDesign().getSVNPropertiesCache().get(new SVNUrl("file://" + this.getSegmentedStorageName()));
                }
                if (svnStatusAndPropertiesPair != null) {
                    return svnStatusAndPropertiesPair.svnStatus;
                }
            }
            catch (MalformedURLException e) {
                LOGGER.error("ModelIDObject getSVNStorableObjectStatus(...) MalformedURLException:" + e.toString());
            }
            File objFile = new File(sn);
            this.svnStorableObjectStatus = new SVNStorableObjectStatus(this);
        }
        return this.svnStorableObjectStatus;
    }

    public void setSVNStorableObjectStatus(SVNStorableObjectStatus status) {
        this.svnStorableObjectStatus = status;
    }

    public void updateSVNStorableObjectStatus() {
        SVNStatus svnStatus;
        if (this.getDesign().isVersioned() && this.getSegmentedStorageName() != null && (svnStatus = SVNClientHelper.getInstance().getSingleStatus(new File(this.getSegmentedStorageName()))) != null) {
            this.svnStorableObjectStatus = new SVNStorableObjectStatus(this.getDesign(), svnStatus, false, false);
        }
    }

    public boolean isRestoredFromSavedDelete() {
        return this.restoredFromSavedDelete;
    }

    public void setRestoredFromSavedDelete(boolean restoredFromSavedDelete) {
        this.restoredFromSavedDelete = restoredFromSavedDelete;
    }

    private String normalizePath(String path) {
        if (path == null) {
            return path;
        }
        char[] pathChars = path.toCharArray();
        for (int i = 0; i < pathChars.length; ++i) {
            if (pathChars[i] != '/' && pathChars[i] != '\\') continue;
            pathChars[i] = File.separatorChar;
        }
        return new String(pathChars);
    }

    public boolean hasDDLPreview() {
        return false;
    }
}

