/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.fcp.vcs.DeletedFile;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.FKArcComparator;
import oracle.dbtools.crest.model.design.compare.FKComparator;
import oracle.dbtools.crest.model.design.compare.IndexComparator;
import oracle.dbtools.crest.model.design.compare.NoteComparator;
import oracle.dbtools.crest.model.design.compare.PropertyFilter;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableConstraintComparator;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.ValidTimeDimensionComparator;
import oracle.dbtools.crest.model.design.compare.ViewIndexComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.ArcComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.AttributeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDIndexComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDModelComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDTableComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDViewIndexComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CollectionTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.DistinctTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.EntityComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.EntityViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.InheritanceRelationComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.KeyComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.LogicalSubViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MethodComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MethodParamComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.RelationComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.RelationalSubViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.StructuredTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.TypeElementComparator;
import oracle.dbtools.crest.model.design.compare.storage.db2.TriggerDB2Comparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.BitmapJoinIndexComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.CollectionTypeComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ColumnComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ContextComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.DataFileComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.DimensionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.DirectoryComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.FKComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.FunctionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.HashPartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.HashSubpartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.HashSubpartitionTemplateComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.HierarchyComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.IndexComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.IndexGlobalPartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.IndexGlobalPartitioningComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.IndexHashPartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.LevelComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ListPartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ListSubpartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ListSubpartitionTemplateComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.LobStorageComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.MethodComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.MethodParamComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.PKUKComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.PackageComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.PartitioningComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.PermissionsComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.QuotaItemComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.RangePartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.RangeSubpartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.RangeSubpartitionTemplateComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.RoleComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SequenceComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SnapshotComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StoredProcedureComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StructuredTypeComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SynonymComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableConstraintComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableViewComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TablespaceComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TemporaryTablespaceComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TriggerOracleComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.UndoTablespaceComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.UserComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.sqlserver.SequenceSqlServerComparator;
import oracle.dbtools.crest.model.design.compare.storage.sqlserver.TriggerSqlServerComparator;
import oracle.dbtools.crest.model.design.compare.storage.udb.TriggerUDBComparator;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesignEstimates;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesignEstimates;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignEstimates;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesignSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2Estimates;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracleEstimates;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServerEstimates;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDBEstimates;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.format.DefaultFCAgent;
import oracle.dbtools.crest.util.options.format.DefaultFCCube;
import oracle.dbtools.crest.util.options.format.DefaultFCDimension;
import oracle.dbtools.crest.util.options.format.DefaultFCEntity;
import oracle.dbtools.crest.util.options.format.DefaultFCInOutParams;
import oracle.dbtools.crest.util.options.format.DefaultFCInfoStore;
import oracle.dbtools.crest.util.options.format.DefaultFCLabel;
import oracle.dbtools.crest.util.options.format.DefaultFCLegend;
import oracle.dbtools.crest.util.options.format.DefaultFCLevel;
import oracle.dbtools.crest.util.options.format.DefaultFCLogicalView;
import oracle.dbtools.crest.util.options.format.DefaultFCNote;
import oracle.dbtools.crest.util.options.format.DefaultFCProcess;
import oracle.dbtools.crest.util.options.format.DefaultFCRelationalView;
import oracle.dbtools.crest.util.options.format.DefaultFCStructuredType;
import oracle.dbtools.crest.util.options.format.DefaultFCTable;
import oracle.dbtools.crest.util.options.format.DefaultFCTransformation;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLWCDTInheritance;
import oracle.dbtools.crest.util.options.format.DefaultLWCDTReference;
import oracle.dbtools.crest.util.options.format.DefaultLWCFlow;
import oracle.dbtools.crest.util.options.format.DefaultLWCForeignKey;
import oracle.dbtools.crest.util.options.format.DefaultLWCInheritanceRelation;
import oracle.dbtools.crest.util.options.format.DefaultLWCLink;
import oracle.dbtools.crest.util.options.format.DefaultLWCRelation;
import oracle.dbtools.crest.util.options.format.DefaultLWCTypeSubstitution;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.dbtools.crest.util.options.format.DefaultRALabel;
import oracle.dbtools.crest.util.options.namingstandards.GlossaryFile;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.dbtools.crest.util.options.namingstandards.WordRule;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DesignLevelSettings {
    public static String fileVersion = "";
    public static final String DESIGN_LEVEL_SETTINGS_FILE_NAME = "dl_settings.xml";
    private static final String SETTINGS_VERSION = "version";
    public static final String SETTINGS_ELEMENT = "settings";
    public static final String SUBSTITUTION_PATTERNS = "substitution_patterns";
    public static final String OLD_STRING = "oldstring";
    public static final String NEW_STRING = "newstring";
    public static final String SELECTED = "selected";
    public static final String COMMENTS = "comments";
    public static final String CASE_SENSITIVE = "casesensitive";
    public static final String COLOR = "color";
    public static final String FOREGROUND_COLOR = "fgcolor";
    public static final String PREFIX = "prefix";
    public static final String WIDTH = "width";
    public static final String CLASSNAME = "classname";
    public static final String ATTRIBUTE = "attribute";
    public static final String VALUE = "value";
    public static final String CLASSIFICATION_TYPES = "classification_types";
    public static final String NAMING_STANDARD_RULE = "naming_standard_rules";
    public static final String LOGICAL = "logical";
    public static final String SEPARATOR = "separator";
    public static final String LOGICALCHAR = "char";
    public static final String ENTITY = "entity";
    public static final String RELATIONAL = "relational";
    public static final String MANDATORY = "mandatory";
    public static final String TYPE = "type";
    public static final String COLUMN = "column";
    public static final String DOMAIN = "domain";
    public static final String DOMAINS = "domains";
    public static final String TABLE = "table";
    public static final String TAG_VALUE = "value";
    public static final String TAG_NAME = "name";
    public static final String LOGICALTYPE_FOR_DOMAIN_PRESENTATION = "logical_type_for_domain_presentation";
    public static final String AUTOMATIC_PK_GENERATION = "automatic_pk_generation";
    public static final String AUTOMATIC_UK_GENERATION = "automatic_uk_generation";
    public static final String AUTOMATIC_FK_GENERATION = "automatic_fk_generation";
    public static final String PRESERVE_DDL_GENERATION_OPTIONS = "preserve_ddl_generation_options";
    public static final String COMPARE_MAPPING_ELEMENTS = "comparemapping";
    public static final String COMPARE_MAPPING_ELEMENT = "mapping";
    public static final String COMPARE_MAPPING_SOURCE_PARENT = "sourceparent";
    public static final String COMPARE_MAPPING_TARGET_PARENT = "targetparent";
    public static final String COMPARE_MAPPING_SOURCE_OBJECT = "sourceobject";
    public static final String COMPARE_MAPPING_TARGET_OBJECT = "targetobject";
    public static final String COMPARE_MAPPING_SELECTED = "selected";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String NO_BACKGROUND_COLOR = "noBackgroundColor";
    public static final String NO_FOREGROUND_COLOR = "noForegroundColor";
    public static final String DEFAULT_FONTS_AND_COLORS = "default_fonts_and_colors";
    public static final String DEFAULT_LINE_WIDTHS_AND_COLORS = "default_line_widths_and_colors";
    public static final String FC_OBJECT = "fc_object";
    public static final String LWC_OBJECT = "lwc_object";
    public static final String ABBREVIATED_ONLY = "abbreviated_only";
    public static final String CONSTRAINTS = "constraints";
    public static final String PK_VALUE = "pk";
    public static final String FK_VALUE = "fk";
    public static final String CK_VALUE = "ck";
    public static final String UN_VALUE = "un";
    public static final String IDX_VALUE = "idx";
    public static final String AUTOMATIC_IDX_VALUE = "automatic_idx";
    public static final String COLCK_VALUE = "colck";
    public static final String COLNNC_VALUE = "colnnc";
    public static final String COLUMN_FK_VALUE = "column_foreign_key";
    public static final String UI_VALUE = "ui";
    public static final String RELATION_ATTRIBUTE_VALUE = "relation_attribute";
    public static final String SURROGATE_KEY = "surrogate_key";
    public static final String SURROGATE_KEY_COL = "surrogate_key_col";
    public static final String DISCRIMINATOR_COL = "discriminator_col";
    public static final String GLOSSARY = "glossaries";
    public static final String GLOSSARIES = "glossary_file";
    public static final char NEW_LINE = '\n';
    public static final char TAB = '\t';
    public static final String USE_GLOBAL_DESIGN_LEVEL_SETTINGS = "use_global_design_level_settings";
    private List<MergeConflict> mergeConflicts = new ArrayList<MergeConflict>();
    private List<DeletedFile> deletedFiles = new ArrayList<DeletedFile>();
    private boolean logicalTypeForDomainPresentation = false;
    private List substitutionList = new ArrayList();
    private List classificationTypeList;
    private NamingStandardRule namingRule;
    private boolean automaticUKGeneration;
    private boolean automaticPKGeneration;
    private boolean automaticFKGeneration;
    private boolean preserveDDLGenerationOptions;
    private CompareMapping compareMapping;
    public List defaultFCObjects = new ArrayList();
    public List defaultLWCObjects = new ArrayList();
    private List dynamicPropertiesList = new ArrayList();
    private boolean useGlobalDesignLevelSettings;
    private Design design;
    public static Map<String, String> compClassToNameMap = new TreeMap<String, String>();
    public static Map<String, String> compNameToClassMap = new TreeMap<String, String>();
    private boolean usePreferredClassificationTypes;
    public static final String USE_PREFERRED_CLASSIFICATION_TYPES = "use_preferred_classification_types";
    public static final String DESIGN_ESTIMATES = "design_estimates";
    public static final String LOGICAL_MODEL_ESTIMATES = "logical_model_estimates";
    public static final String ENTITIES = "entities";
    public static final String RELATIONS = "relations";
    public static final String VIEWS = "views";
    public static final String ARCS = "arcs";
    public static final String DATA_TYPES_MODEL_ESTIMATES = "data_types_model_estimates";
    public static final String STRUCTURED_TYPES = "structured_types";
    public static final String COLLECTION_TYPES = "collection_types";
    public static final String DISTINCT_TYPES = "distinct_types";
    public static final String RELATIONAL_MODEL_ESTIMATES = "relational_model_estimates";
    public static final String RELATIONAL_MODEL_ = "relational_model_";
    public static final String _ESTIMATES = "_estimates";
    public static final String RELATIONAL_MODEL_NAME = "relational_model_name";
    public static final String TABLES = "tables";
    public static final String FOREIGN_KEYS = "foreign_keys";
    public static final String SCHEMAS = "schemas";
    public static final String SUBVIEWS = "subviews";
    public static final String PHYSICAL_MODELS_ESTIMATES = "physical_models_estimates";
    public static final String PHYSICAL_MODEL_ = "physical_model_";
    public static final String PHYSICAL_MODEL_NAME = "physical_model_name";
    public static final String CLUSTERS = "clusters";
    public static final String CONTEXTS = "contexts";
    public static final String DBS = "dBs";
    public static final String DIMENSIONS = "dimensions";
    public static final String DIRECTORIES = "directories";
    public static final String DISKGROUPS = "diskGroups";
    public static final String EXTERNALTABLES = "externalTables";
    public static final String SNAPSHOTS = "snapshots";
    public static final String ROLES = "roles";
    public static final String ROLLBACKSEGMENTS = "rollbackSegments";
    public static final String SEGMENTS = "segments";
    public static final String SEQUENCES = "sequences";
    public static final String STOREDPROCEDURES = "storedProcedures";
    public static final String FUNCTIONS = "functions";
    public static final String PACKAGES = "packages";
    public static final String COLLECTIONTYPES = "collectionTypes";
    public static final String STRUCTUREDTYPES = "structuredTypes";
    public static final String SYNONYMS = "synonyms";
    public static final String TABLESPACES = "tableSpaces";
    public static final String TEMPORARYTABLESPACES = "temporaryTableSpaces";
    public static final String UNDOTABLESPACES = "undoTableSpaces";
    public static final String USERS = "users";
    public static final String TRIGGERS = "triggers";
    public static final String DATA_BASES = "data_bases";
    public static final String LOGINS = "logins";
    public static final String USER_DEFINED_TYPES = "user_defined_types";
    public static final String ALIASES = "aliases";
    public static final String AUX_TABLES = "aux_tables";
    public static final String BUFFER_POOLS = "buffer_pools";
    public static final String OWNERS = "owners";
    public static final String STORAGE_TEMPLATES = "storage_templates";
    public static final String STORED_PROCEDURES = "stored_procedures";
    public static final String VCATS = "vcats";
    public static final String VOLUMES = "volumes";
    public static final String DB_PARTITIONS = "db_partitions";
    public static final String USER_GROUPS = "user_groups";
    public static final String TABLE_SPACES = "table_spaces";
    private static final Logger LOGGER = new Logger(DesignLevelSettings.class);

    public DesignLevelSettings(Design design) {
        this.design = design;
        this.loadDefaultValues();
        this.loadDesignLevelSettingsFile(XMLTransformationManager.getDefaultSystemTypesPath());
    }

    public DesignLevelSettings(Design design, boolean defaultsOnly) {
        this.design = design;
        this.loadDefaultValues();
        if (!defaultsOnly) {
            this.loadDesignLevelSettingsFile(XMLTransformationManager.getDefaultSystemTypesPath());
        }
    }

    private void loadDefaultValues() {
        this.initDefaultFCObjects();
        this.initDefaultLWCObjects();
        this.initDefaultClassificationTypes();
    }

    public NamingStandardRule getNamingStandardRule() {
        if (this.namingRule == null) {
            this.namingRule = new NamingStandardRule();
        }
        return this.namingRule;
    }

    public boolean isLogicalTypeForDomainPresentation() {
        return this.logicalTypeForDomainPresentation;
    }

    public void setLogicalTypeForDomainPresentation(boolean logicalTypeForDomainPresentation) {
        this.logicalTypeForDomainPresentation = logicalTypeForDomainPresentation;
    }

    public CompareMapping getCompareMapping() {
        if (this.compareMapping == null) {
            this.compareMapping = new CompareMapping();
        }
        return this.compareMapping;
    }

    public List getSubstitutionList() {
        return this.substitutionList;
    }

    public List getClassificationTypeList() {
        if (this.classificationTypeList == null) {
            this.classificationTypeList = new ArrayList();
        }
        return this.classificationTypeList;
    }

    public ClassificationType getClassificationTypeByID(String typeID) {
        for (ClassificationType typeExists : this.classificationTypeList) {
            if (!typeExists.equalID(typeID)) continue;
            return typeExists;
        }
        return null;
    }

    public String getClassificationTypeNameByID(String typeID) {
        if (this.getClassificationTypeByID(typeID) != null) {
            return this.getClassificationTypeByID(typeID).getTypeName();
        }
        return "";
    }

    public ClassificationType getClassificationTypeByName(String name) {
        for (ClassificationType nameExists : this.classificationTypeList) {
            if (!nameExists.getTypeName().equalsIgnoreCase(name)) continue;
            return nameExists;
        }
        return null;
    }

    public Object[] getClassificationTypeNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(null);
        for (ClassificationType ct : this.classificationTypeList) {
            list.add(ct.getTypeName());
        }
        return list.toArray();
    }

    public void setNamingStandardRule(NamingStandardRule namingStandardRule) {
        this.namingRule = namingStandardRule;
    }

    public void setAutomaticUKGeneration(boolean automaticUKGeneration) {
        this.automaticUKGeneration = automaticUKGeneration;
    }

    public boolean isAutomaticUKGeneration() {
        return this.automaticUKGeneration;
    }

    public boolean isAutomaticPKGeneration() {
        return this.automaticPKGeneration;
    }

    public void setAutomaticPKGeneration(boolean automaticPKGeneration) {
        this.automaticPKGeneration = automaticPKGeneration;
    }

    public void setAutomaticFKGeneration(boolean automaticFKGeneration) {
        this.automaticFKGeneration = automaticFKGeneration;
    }

    public boolean isAutomaticFKGeneration() {
        return this.automaticFKGeneration;
    }

    public void setPreserveDDLGenerationOptions(boolean preserveDDLGenerationOptions) {
        this.preserveDDLGenerationOptions = preserveDDLGenerationOptions;
    }

    public boolean isPreserveDDLGenerationOptions() {
        return this.preserveDDLGenerationOptions;
    }

    public boolean isUseGlobalDesignLevelSettings() {
        return this.useGlobalDesignLevelSettings;
    }

    public void setUseGlobalDesignLevelSettings(boolean useGlobalDesignLevelSettings) {
        this.useGlobalDesignLevelSettings = useGlobalDesignLevelSettings;
    }

    public CompareMapping getCompareMappingList() {
        if (this.compareMapping == null) {
            this.compareMapping = new CompareMapping();
        }
        return this.compareMapping;
    }

    public void saveDesignLevelLSettingsFile(String path) {
        try {
            long rev;
            File file = new File(path);
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(this.getDesignLevelSettingsAsString());
            osw.close();
            if (Extension.isSVNExtensionLoaded() && file.exists() && this.design.isVersioned() && (rev = SVNClientHelper.getInstance().getRevision(file)) == -1L) {
                SVNClientHelper.getInstance().doAdd(file);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to Save Design Level Settings: ", e);
        }
    }

    public void loadDesignLevelSettings(Document doc) {
        try {
            fileVersion = doc.getDocumentElement().getAttribute(SETTINGS_VERSION);
            String value = this.getValue(doc, LOGICALTYPE_FOR_DOMAIN_PRESENTATION);
            if (!"".equalsIgnoreCase(value)) {
                this.logicalTypeForDomainPresentation = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, AUTOMATIC_PK_GENERATION))) {
                this.automaticPKGeneration = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, AUTOMATIC_UK_GENERATION))) {
                this.automaticUKGeneration = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, AUTOMATIC_FK_GENERATION))) {
                this.automaticFKGeneration = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, PRESERVE_DDL_GENERATION_OPTIONS))) {
                this.preserveDDLGenerationOptions = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_GLOBAL_DESIGN_LEVEL_SETTINGS))) {
                this.useGlobalDesignLevelSettings = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, USE_PREFERRED_CLASSIFICATION_TYPES))) {
                this.usePreferredClassificationTypes = Boolean.valueOf(value);
            }
            this.initCompareMappings(doc);
            this.initSubstitutionPatterns(doc);
            this.initClassificationTypes(doc);
            this.initDefaultFontsAndColors(doc);
            this.initDefaultLineWidthsAndColors(doc);
            this.initNamingStandardRule(doc);
            this.initEngineeringParams(doc);
            this.initEngineeringCompare(doc);
            this.initModelCompare(doc);
            this.initModelCompareStorage(doc);
            this.initNamingOptions(doc);
            this.initMergeConflicts(doc);
            this.initDeletedFiles(doc);
            this.initDynamicProperties(doc);
            this.initEstimates(doc);
        }
        catch (Exception e) {
            LOGGER.error("Unable to load design level Settings: ", e);
        }
    }

    private void initSubstitutionPatterns(Document doc) {
        Element element;
        this.substitutionList.clear();
        NodeList list = doc.getElementsByTagName(SUBSTITUTION_PATTERNS);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            NodeList lsDialogs = element.getElementsByTagName("*");
            int dialogLength = lsDialogs.getLength();
            for (int i = 0; i < dialogLength; ++i) {
                Element dialog = (Element)lsDialogs.item(i);
                if (dialog == null) continue;
                try {
                    String oldString = dialog.getAttribute(OLD_STRING);
                    String newString = dialog.getAttribute(NEW_STRING);
                    boolean selected = Boolean.valueOf(dialog.getAttribute("selected"));
                    boolean caseSensitive = Boolean.valueOf(dialog.getAttribute(CASE_SENSITIVE));
                    String comments = dialog.getAttribute(COMMENTS);
                    SubstitutionPattern substPattern = new SubstitutionPattern(oldString, newString, selected, caseSensitive, comments);
                    this.substitutionList.add(substPattern);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    private void initClassificationTypes(Document doc) {
        Element element;
        this.getClassificationTypeList().clear();
        this.initDefaultClassificationTypes();
        NodeList list = doc.getElementsByTagName(CLASSIFICATION_TYPES);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            NodeList types = element.getElementsByTagName(TYPE);
            int typesLength = types.getLength();
            for (int i = 0; i < typesLength; ++i) {
                Element elem = (Element)types.item(i);
                if (elem == null) continue;
                try {
                    String elementName = elem.getAttribute(TAG_NAME);
                    int elementColor = Integer.parseInt(elem.getAttribute(COLOR));
                    int fgColor = Color.BLUE.getRGB();
                    try {
                        fgColor = Integer.parseInt(elem.getAttribute(FOREGROUND_COLOR));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String elementPrefix = elem.getAttribute(PREFIX);
                    String elementID = elem.getAttribute("id");
                    boolean elementPreferred = Boolean.valueOf(elem.getAttribute("preferred"));
                    boolean isReadOnly = false;
                    if (elementID.equals("1") || elementID.equals("2") || elementID.equals("3") || elementID.equals("4") || elementID.equals("6") || elementID.equals("5")) {
                        isReadOnly = true;
                    }
                    ClassificationType classType = null;
                    classType = !elementID.equalsIgnoreCase("") ? this.getClassificationTypeByID(elementID) : this.getClassificationTypeByName(elementName);
                    if (classType != null) {
                        classType.setTypeName(elementName);
                        classType.setTypePrefix(elementPrefix);
                        classType.setTypeColor(new Color(elementColor, true));
                        classType.setForegroundColor(new Color(fgColor, true));
                        classType.setReadOnly(isReadOnly);
                        classType.setPreferred(elementPreferred);
                    } else {
                        classType = new ClassificationType(elementName, new Color(elementColor, true), new Color(fgColor, true), "", isReadOnly, elementPrefix, elementPreferred);
                        if (!"".equalsIgnoreCase(elementID)) {
                            classType.setTypeID(elementID);
                        }
                        this.getClassificationTypeList().add(classType);
                    }
                    Element fontsElm = this.getFirstElementByTagName("fonts", elem);
                    if (fontsElm == null) continue;
                    NodeList fonts = fontsElm.getElementsByTagName("font_object");
                    int fontsLength = fonts.getLength();
                    for (int j = 0; j < fontsLength; ++j) {
                        Element font = (Element)fonts.item(j);
                        String type = font.getAttribute("fo_type");
                        FontObject fo = classType.getDefaultFCObject().getFontObject(type);
                        if (fo == null) continue;
                        int fontColor = Integer.parseInt(font.getAttribute("font_color"));
                        String fontName = font.getAttribute("font_name");
                        int fontSize = Integer.parseInt(font.getAttribute("font_size"));
                        int fontStyle = Integer.parseInt(font.getAttribute("font_style"));
                        fo.setColor(new Color(fontColor, true));
                        fo.setFont(new Font(fontName, fontStyle, fontSize));
                    }
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Unable to initialize classification types: ", e);
                }
            }
        }
    }

    public void initDefaultClassificationTypes() {
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_FACT, new Color(255, 226, 198), Color.BLUE, "1", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_DIMENSION, new Color(228, 208, 253), Color.BLUE, "2", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_LOGGING, new Color(228, 228, 228), Color.BLUE, "3", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_SUMMARY, new Color(207, 244, 202), Color.BLUE, "4", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_TEMPORARY, new Color(255, 255, 255), Color.BLUE, "5", true, "", false));
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_EXTERNAL, new Color(244, 255, 244), Color.BLUE, "6", true, "", false));
    }

    private void initDefaultFontsAndColors(Document doc) {
        Element element;
        NodeList list = doc.getElementsByTagName(DEFAULT_FONTS_AND_COLORS);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            NodeList fos = element.getElementsByTagName(FC_OBJECT);
            int fosLength = fos.getLength();
            for (int i = 0; i < fosLength; ++i) {
                Element foElm = (Element)fos.item(i);
                if (foElm == null) continue;
                try {
                    Element fontsElm;
                    String strNoFG;
                    String className = foElm.getAttribute(CLASSNAME);
                    DefaultFontAndColor dfc = this.getDefaultFCObject(className);
                    if (dfc == null) continue;
                    int background = Integer.parseInt(foElm.getAttribute(BACKGROUND));
                    int foreground = Integer.parseInt(foElm.getAttribute(FOREGROUND));
                    dfc.setBackgroundColor(new Color(background, true));
                    dfc.setForegroundColor(new Color(foreground, true));
                    String strNoBG = foElm.getAttribute(NO_BACKGROUND_COLOR);
                    if (!strNoBG.isEmpty()) {
                        boolean noBackgroundColor = Boolean.parseBoolean(strNoBG);
                        dfc.setNoBackgroundColor(noBackgroundColor);
                    }
                    if (!(strNoFG = foElm.getAttribute(NO_FOREGROUND_COLOR)).isEmpty()) {
                        boolean noForegroundColor = Boolean.parseBoolean(strNoFG);
                        dfc.setNoForegroundColor(noForegroundColor);
                    }
                    if ((fontsElm = this.getFirstElementByTagName("fonts", foElm)) == null) continue;
                    NodeList fonts = fontsElm.getElementsByTagName("font_object");
                    int fontsLength = fonts.getLength();
                    for (int j = 0; j < fontsLength; ++j) {
                        Element font = (Element)fonts.item(j);
                        String type = font.getAttribute("fo_type");
                        FontObject fo = dfc.getFontObject(type);
                        if (fo == null) continue;
                        int fontColor = Integer.parseInt(font.getAttribute("font_color"));
                        String fontName = font.getAttribute("font_name");
                        int fontSize = Integer.parseInt(font.getAttribute("font_size"));
                        int fontStyle = Integer.parseInt(font.getAttribute("font_style"));
                        fo.setColor(new Color(fontColor, true));
                        fo.setFont(new Font(fontName, fontStyle, fontSize));
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void initDefaultLineWidthsAndColors(Document doc) {
        Element element;
        NodeList list = doc.getElementsByTagName(DEFAULT_LINE_WIDTHS_AND_COLORS);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            NodeList fos = element.getElementsByTagName(LWC_OBJECT);
            int fosLength = fos.getLength();
            for (int i = 0; i < fosLength; ++i) {
                Element foElm = (Element)fos.item(i);
                if (foElm == null) continue;
                try {
                    String className = foElm.getAttribute(CLASSNAME);
                    DefaultLineWidthAndColor dlwc = this.getDefaultLWCObject(className);
                    if (dlwc == null) continue;
                    int color = Integer.parseInt(foElm.getAttribute(COLOR));
                    int width = Integer.parseInt(foElm.getAttribute(WIDTH));
                    dlwc.setColor(new Color(color, true));
                    dlwc.setWidth(width);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    private void initNamingStandardRule(Document doc) {
        Element element = this.getFirstElementByTagName(NAMING_STANDARD_RULE, doc.getDocumentElement());
        if (element != null) {
            Element el;
            Element domElm;
            boolean opt;
            Element relElm;
            boolean opt2;
            Element elem;
            Element logElm = this.getFirstElementByTagName(LOGICAL, element);
            if (logElm != null) {
                try {
                    Element el2 = this.getFirstElementByTagName(SEPARATOR, logElm);
                    if (el2 != null) {
                        this.getNamingStandardRule().setLogicalSep(el2.getAttribute("value"));
                        this.getNamingStandardRule().setLogicalChar(el2.getAttribute(LOGICALCHAR));
                    }
                    this.getNamingStandardRule().getEntitiesList().clear();
                    Element entity = this.getFirstElementByTagName(ENTITY, logElm);
                    if (entity != null) {
                        NodeList ent = entity.getElementsByTagName("value");
                        int entLength = ent.getLength();
                        for (int j = 0; j < entLength; ++j) {
                            Element elem2 = (Element)ent.item(j);
                            String type = elem2.getAttribute(TYPE);
                            boolean opt3 = Boolean.valueOf(elem2.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getEntitiesList().add(new WordRule(type, opt3));
                        }
                    }
                    this.getNamingStandardRule().getAttributesList().clear();
                    Element attribute = this.getFirstElementByTagName(ATTRIBUTE, logElm);
                    if (attribute != null) {
                        NodeList atr = attribute.getElementsByTagName("value");
                        int atrLength = atr.getLength();
                        for (int j = 0; j < atrLength; ++j) {
                            elem = (Element)atr.item(j);
                            String type = elem.getAttribute(TYPE);
                            opt2 = Boolean.valueOf(elem.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getAttributesList().add(new WordRule(type, opt2));
                        }
                    }
                }
                catch (Exception el2) {
                    // empty catch block
                }
            }
            if ((relElm = this.getFirstElementByTagName(RELATIONAL, element)) != null) {
                try {
                    Element el3 = this.getFirstElementByTagName(SEPARATOR, relElm);
                    if (el3 != null) {
                        this.getNamingStandardRule().setRelSep(el3.getAttribute("value"));
                        String abbr = el3.getAttribute(ABBREVIATED_ONLY);
                        if (abbr != null && !"".equalsIgnoreCase(abbr)) {
                            if ("true".equalsIgnoreCase(abbr)) {
                                this.getNamingStandardRule().setAbbreviatedOnly(true);
                            } else {
                                this.getNamingStandardRule().setAbbreviatedOnly(false);
                            }
                        }
                    }
                    this.getNamingStandardRule().getTablesList().clear();
                    Element table = this.getFirstElementByTagName(TABLE, relElm);
                    if (table != null) {
                        NodeList tbl = table.getElementsByTagName("value");
                        int tblLength = tbl.getLength();
                        for (int j = 0; j < tblLength; ++j) {
                            elem = (Element)tbl.item(j);
                            String type = elem.getAttribute(TYPE);
                            opt2 = Boolean.valueOf(elem.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getTablesList().add(new WordRule(type, opt2));
                        }
                    }
                    this.getNamingStandardRule().getColumnsList().clear();
                    Element column = this.getFirstElementByTagName(COLUMN, relElm);
                    if (column != null) {
                        NodeList clm = column.getElementsByTagName("value");
                        int clmLength = clm.getLength();
                        for (int j = 0; j < clmLength; ++j) {
                            Element elem3 = (Element)clm.item(j);
                            String type = elem3.getAttribute(TYPE);
                            opt = Boolean.valueOf(elem3.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getColumnsList().add(new WordRule(type, opt));
                        }
                    }
                }
                catch (Exception el3) {
                    // empty catch block
                }
            }
            if ((domElm = this.getFirstElementByTagName(DOMAINS, element)) != null) {
                try {
                    el = this.getFirstElementByTagName(SEPARATOR, domElm);
                    if (el != null) {
                        this.getNamingStandardRule().setDomainsSep(el.getAttribute("value"));
                    }
                    this.getNamingStandardRule().getDomainsList().clear();
                    Element domain = this.getFirstElementByTagName(DOMAIN, domElm);
                    if (domain != null) {
                        NodeList dom = domain.getElementsByTagName("value");
                        int domLength = dom.getLength();
                        for (int j = 0; j < domLength; ++j) {
                            Element elem4 = (Element)dom.item(j);
                            String type = elem4.getAttribute(TYPE);
                            opt = Boolean.valueOf(elem4.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getDomainsList().add(new WordRule(type, opt));
                        }
                    }
                }
                catch (Exception el4) {
                    // empty catch block
                }
            }
            if ((el = this.getFirstElementByTagName(CONSTRAINTS, element)) != null) {
                Element valueElement = this.getFirstElementByTagName(PK_VALUE, el);
                if (valueElement != null) {
                    this.getNamingStandardRule().setPkConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(FK_VALUE, el)) != null) {
                    this.getNamingStandardRule().setFkConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(CK_VALUE, el)) != null) {
                    this.getNamingStandardRule().setCkConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(UN_VALUE, el)) != null) {
                    this.getNamingStandardRule().setUnConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(IDX_VALUE, el)) != null) {
                    this.getNamingStandardRule().setIdxConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(AUTOMATIC_IDX_VALUE, el)) != null) {
                    this.getNamingStandardRule().setAutomaticIdxConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(COLCK_VALUE, el)) != null) {
                    this.getNamingStandardRule().setColckConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(COLNNC_VALUE, el)) != null) {
                    this.getNamingStandardRule().setColNNConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(COLUMN_FK_VALUE, el)) != null) {
                    this.getNamingStandardRule().setFkColumn(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(UI_VALUE, el)) != null) {
                    this.getNamingStandardRule().setUIConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(RELATION_ATTRIBUTE_VALUE, el)) != null) {
                    this.getNamingStandardRule().setRelationAttribute(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(SURROGATE_KEY, el)) != null) {
                    this.getNamingStandardRule().setSurrogateKey(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(SURROGATE_KEY_COL, el)) != null) {
                    this.getNamingStandardRule().setSurrogateKeyColumn(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(DISCRIMINATOR_COL, el)) != null) {
                    this.getNamingStandardRule().setDiscriminatorColumn(valueElement.getAttribute("value"));
                }
            }
            Element e = this.getFirstElementByTagName(GLOSSARY, element);
            this.getNamingStandardRule().getGlossariesList().clear();
            if (e != null) {
                NodeList nodes = e.getElementsByTagName(GLOSSARIES);
                int nodesLength = nodes.getLength();
                for (int i = 0; i < nodesLength; ++i) {
                    Element elm = (Element)nodes.item(i);
                    String value = elm.getAttribute("value");
                    this.getNamingStandardRule().getGlossariesList().add(new GlossaryFile(value));
                }
            }
        }
    }

    private void initNamingOptions(Document doc) {
        ArrayList<DesignPart> allModels = new ArrayList<DesignPart>();
        for (DesignPart dp : this.design.getRelationalDesigns()) {
            allModels.add(dp);
        }
        allModels.add(this.design.getLogicalDesign());
        NodeList elems = doc.getElementsByTagName("model_options");
        for (int i = 0; i < elems.getLength(); ++i) {
            Element modelOption = (Element)elems.item(i);
            String modelID = modelOption.getAttribute("objectid");
            for (DesignPart design : allModels) {
                if (!design.getObjectID().equals(modelID)) continue;
                NodeList namingOptions = modelOption.getElementsByTagName("naming_option");
                for (int j = 0; j < namingOptions.getLength(); ++j) {
                    Element namingOption = (Element)namingOptions.item(j);
                    String className = namingOption.getAttribute("class_name");
                    int maxNameLength = Integer.parseInt(namingOption.getAttribute("max_name_length"));
                    int caseType = Integer.parseInt(namingOption.getAttribute("case_type"));
                    String validChars = namingOption.getAttribute("valid_characters");
                    boolean allValid = Boolean.valueOf(namingOption.getAttribute("all_valid"));
                    NamingOptionsHolder noh = design.getNamingOptionsHolderFor(className);
                    noh.setCaseType(caseType);
                    noh.setIsValid(allValid);
                    noh.setMaxNameLength(maxNameLength);
                    noh.setValidChars(validChars);
                }
            }
        }
    }

    private void initMergeConflicts(Document doc) {
        NodeList mergeConflictsNodes = doc.getElementsByTagName("merge_conflict");
        List<MergeConflict> mergeConflicts = this.getMergeConflicts();
        mergeConflicts.clear();
        for (int i = 0; i < mergeConflictsNodes.getLength(); ++i) {
            ISVNStatus isvnStatus;
            Element mergeConflictElement = (Element)mergeConflictsNodes.item(i);
            String localFile = mergeConflictElement.getAttribute("path");
            String localLabel = mergeConflictElement.getAttribute("local_version_extension");
            String repositoryLabel = mergeConflictElement.getAttribute("remote_version_extension");
            String textStatus = mergeConflictElement.getAttribute("text_status");
            String propertyStatus = mergeConflictElement.getAttribute("property_status");
            File conflictNodeFile = new File(this.design.getDesignPath() + localFile);
            if (!conflictNodeFile.exists() || !(isvnStatus = SVNClientHelper.getInstance().getSingleStatusLocal(conflictNodeFile)).getTextStatus().toString().equalsIgnoreCase(SVNStatusType.CONFLICTED.toString())) continue;
            mergeConflicts.add(new MergeConflict(conflictNodeFile, conflictNodeFile.getName(), localLabel, repositoryLabel, textStatus, propertyStatus));
        }
    }

    private void initDeletedFiles(Document doc) {
        NodeList deletedFilesNodes = doc.getElementsByTagName("deleted_file");
        List<DeletedFile> deletedFiles = this.getDeletedFiles();
        deletedFiles.clear();
        for (int i = 0; i < deletedFilesNodes.getLength(); ++i) {
            Element deletedFileElement = (Element)deletedFilesNodes.item(i);
            String deletedFilePath = deletedFileElement.getAttribute("path");
            String deletedFileUrl = deletedFileElement.getAttribute("url");
            Long deletedFileRevision = Long.valueOf(deletedFileElement.getAttribute("revision"));
            deletedFiles.add(new DeletedFile(new File(this.design.getDesignPath() + deletedFilePath), deletedFileUrl, deletedFileRevision));
        }
    }

    private void initDynamicProperties(Document doc) {
        this.getDynamicPropertiesList().clear();
        NodeList engParams = doc.getDocumentElement().getElementsByTagName("property");
        int length = engParams.getLength();
        for (int i = 0; i < length; ++i) {
            Element elm = (Element)engParams.item(i);
            if (!elm.getParentNode().getNodeName().equalsIgnoreCase("dynamic_properties")) continue;
            String name = elm.getAttribute(TAG_NAME);
            String type = elm.getAttribute("object_type");
            String presentationName = elm.getAttribute("presentation_name");
            boolean exists = false;
            for (DPObject dpo : this.getDynamicPropertiesList()) {
                if (!dpo.getName().equals(name) || !dpo.getType().equals(type) || !dpo.getPresentationName().equals(presentationName)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.getDynamicPropertiesList().add(new DPObject(name, type, presentationName, true));
        }
    }

    private void initEstimates(Document doc) {
        RelationalDesignSet relationalDesignSet;
        Element wElm;
        int quantity;
        Element elm;
        NodeList designEstimates = doc.getDocumentElement().getElementsByTagName(LOGICAL_MODEL_ESTIMATES);
        if (designEstimates.getLength() > 0) {
            elm = (Element)designEstimates.item(0);
            quantity = 0;
            LogicalDesignEstimates logicalDesignEstimates = this.design.getLogicalDesign().getLogicalDesignEstimates();
            wElm = this.getFirstElementByTagName(ENTITIES, elm);
            if (wElm != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                logicalDesignEstimates.setEntitiesQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(RELATIONS, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                logicalDesignEstimates.setRelationsQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(VIEWS, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                logicalDesignEstimates.setViewsQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(ARCS, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                logicalDesignEstimates.setArcsQuantity(quantity);
            }
        }
        if ((designEstimates = doc.getDocumentElement().getElementsByTagName(DATA_TYPES_MODEL_ESTIMATES)).getLength() > 0) {
            elm = (Element)designEstimates.item(0);
            quantity = 0;
            DataTypesDesignEstimates dataTypesDesignEstimates = this.design.getDataTypesDesign().getDataTypesDesignEstimates();
            wElm = this.getFirstElementByTagName(STRUCTURED_TYPES, elm);
            if (wElm != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                dataTypesDesignEstimates.setStructuredTypesQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(COLLECTION_TYPES, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                dataTypesDesignEstimates.setCollectionTypesQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(DISTINCT_TYPES, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                dataTypesDesignEstimates.setDistinctTypesQuantity(quantity);
            }
        }
        if ((relationalDesignSet = this.design.getRelationalDesigns()).size() > 0) {
            for (int i = 0; i < relationalDesignSet.size(); ++i) {
                RelationalDesign reltionalDesign = (RelationalDesign)relationalDesignSet.getElement(i);
                RelationalDesignEstimates relationalDesignEstimates = reltionalDesign.getRelationalDesignEstimates();
                String findKey = RELATIONAL_MODEL_ + i + _ESTIMATES;
                designEstimates = doc.getDocumentElement().getElementsByTagName(findKey);
                if (designEstimates.getLength() <= 0) continue;
                int quantity2 = 0;
                Element elm2 = (Element)designEstimates.item(0);
                Element wElm2 = this.getFirstElementByTagName(RELATIONAL_MODEL_NAME, elm2);
                wElm2 = this.getFirstElementByTagName(TABLES, elm2);
                if (wElm2 != null) {
                    quantity2 = new Integer(wElm2.getAttribute("value"));
                    relationalDesignEstimates.setTablesQuantity(quantity2);
                }
                if ((wElm2 = this.getFirstElementByTagName(VIEWS, elm2)) != null) {
                    quantity2 = new Integer(wElm2.getAttribute("value"));
                    relationalDesignEstimates.setViewsQuantity(quantity2);
                }
                if ((wElm2 = this.getFirstElementByTagName(FOREIGN_KEYS, elm2)) != null) {
                    quantity2 = new Integer(wElm2.getAttribute("value"));
                    relationalDesignEstimates.setForeignKeysQuantity(quantity2);
                }
                if ((wElm2 = this.getFirstElementByTagName(SCHEMAS, elm2)) != null) {
                    quantity2 = new Integer(wElm2.getAttribute("value"));
                    relationalDesignEstimates.setSchemasQuantity(quantity2);
                }
                if ((wElm2 = this.getFirstElementByTagName(SUBVIEWS, elm2)) != null) {
                    quantity2 = new Integer(wElm2.getAttribute("value"));
                    relationalDesignEstimates.setSubviewsQuantity(quantity2);
                }
                if ((wElm2 = this.getFirstElementByTagName(ARCS, elm2)) == null) continue;
                quantity2 = new Integer(wElm2.getAttribute("value"));
                relationalDesignEstimates.setArcsQuantity(quantity2);
            }
        }
    }

    public void initPhysicalModelsEstimates(Document doc, RelationalDesign relationalDesign) {
        StorageDesignSet storageDesignSet = relationalDesign.getSorageDesigns();
        for (int i = 0; i < storageDesignSet.size(); ++i) {
            Element wElm;
            Element elm;
            int quantity;
            NodeList designEstimates;
            StorageDesign storageDesign = (StorageDesign)storageDesignSet.getElement(i);
            RDBMSType rdbmsType = storageDesign.getRDBMSType();
            String findKey = PHYSICAL_MODEL_ + relationalDesign.getObjectID() + "_" + this.replaceSpecCharsWithUnderscores(storageDesign.getName());
            if (rdbmsType.equals(StorageDesignOraclev12cR2.RDBMS_TYPE) || rdbmsType.equals(StorageDesignOraclev12c.RDBMS_TYPE) || rdbmsType.equals(StorageDesignOraclev11g.RDBMS_TYPE) || rdbmsType.equals(StorageDesignOraclev10g.RDBMS_TYPE) || rdbmsType.equals(StorageDesignOraclev9i.RDBMS_TYPE)) {
                StorageDesignOracleEstimates storageDesignOracleEstimates = ((StorageDesignOracle)storageDesign).getStorageDesignOracleEstimates();
                designEstimates = doc.getDocumentElement().getElementsByTagName(findKey);
                if (designEstimates.getLength() <= 0) continue;
                quantity = 0;
                elm = (Element)designEstimates.item(0);
                wElm = this.getFirstElementByTagName(PHYSICAL_MODEL_NAME, elm);
                wElm = this.getFirstElementByTagName(CLUSTERS, elm);
                if (wElm != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setClustersQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(CONTEXTS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setContextsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(DBS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setDBsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(DIMENSIONS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setDimensionsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(DIRECTORIES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setDirectoriesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(DISKGROUPS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setDiskGroupsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(EXTERNALTABLES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setExternalTablesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(SNAPSHOTS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setSnapshotsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(ROLES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setRolesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(ROLLBACKSEGMENTS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setRollbackSegmentsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(SEGMENTS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setSegmentsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(SEQUENCES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setSequencesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(STOREDPROCEDURES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setStoredProceduresQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(FUNCTIONS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setFunctionsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(PACKAGES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setPackagesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(COLLECTIONTYPES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setCollectionTypesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(STRUCTUREDTYPES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setStructuredTypesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(SYNONYMS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setSynonymsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(TABLES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setTablesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(TABLESPACES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setTableSpacesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(TEMPORARYTABLESPACES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setTemporaryTableSpacesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(UNDOTABLESPACES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setUndoTableSpacesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(USERS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setUsersQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(VIEWS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignOracleEstimates.setViewsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(TRIGGERS, elm)) == null) continue;
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignOracleEstimates.setTriggersQuantity(quantity);
                continue;
            }
            if (rdbmsType.equals(StorageDesignSqlServerv2k12.RDBMS_TYPE) || rdbmsType.equals(StorageDesignSqlServerv2k8.RDBMS_TYPE) || rdbmsType.equals(StorageDesignSqlServerv2k5.RDBMS_TYPE) || rdbmsType.equals(StorageDesignSqlServerv2k.RDBMS_TYPE)) {
                StorageDesignSqlServerEstimates storageDesignSqlServerEstimates = ((StorageDesignSqlServer)storageDesign).getStorageDesignSqlServerEstimates();
                designEstimates = doc.getDocumentElement().getElementsByTagName(findKey);
                if (designEstimates.getLength() <= 0) continue;
                quantity = 0;
                elm = (Element)designEstimates.item(0);
                wElm = this.getFirstElementByTagName(PHYSICAL_MODEL_NAME, elm);
                wElm = this.getFirstElementByTagName(DATA_BASES, elm);
                if (wElm != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignSqlServerEstimates.setDataBasesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(LOGINS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignSqlServerEstimates.setLoginsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(TABLES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignSqlServerEstimates.setTablesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(VIEWS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignSqlServerEstimates.setViewsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(USER_DEFINED_TYPES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignSqlServerEstimates.setUserDefinedTypesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(TRIGGERS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignSqlServerEstimates.setTriggersQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(USERS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    storageDesignSqlServerEstimates.setUsersQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(ROLES, elm)) == null) continue;
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignSqlServerEstimates.setRolesQuantity(quantity);
                continue;
            }
            if (rdbmsType.equals(StorageDesignDB2v70.RDBMS_TYPE) || rdbmsType.equals(StorageDesignDB2v80.RDBMS_TYPE)) {
                AbstractStorageDesignDB2Estimates abstractStorageDesignDB2Estimates = ((AbstractStorageDesignDB2)storageDesign).getAbstractStorageDesignDB2Estimates();
                designEstimates = doc.getDocumentElement().getElementsByTagName(findKey);
                if (designEstimates.getLength() <= 0) continue;
                quantity = 0;
                elm = (Element)designEstimates.item(0);
                wElm = this.getFirstElementByTagName(PHYSICAL_MODEL_NAME, elm);
                wElm = this.getFirstElementByTagName(ALIASES, elm);
                if (wElm != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setAliasesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(AUX_TABLES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setAuxTablesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(BUFFER_POOLS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setBufferPoolsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(DATA_BASES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setDataBasesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(OWNERS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setOwnersQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(STORAGE_TEMPLATES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setStorageTemplatesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(STORED_PROCEDURES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setStoredProceduresQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(SEQUENCES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setSequencesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(TABLES, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setTablesQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(VCATS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setVCATsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(VIEWS, elm)) != null) {
                    quantity = new Integer(wElm.getAttribute("value"));
                    abstractStorageDesignDB2Estimates.setViewsQuantity(quantity);
                }
                if ((wElm = this.getFirstElementByTagName(VOLUMES, elm)) == null) continue;
                quantity = new Integer(wElm.getAttribute("value"));
                abstractStorageDesignDB2Estimates.setVolumesQuantity(quantity);
                continue;
            }
            if (!rdbmsType.equals(StorageDesignUDBv71.RDBMS_TYPE) && !rdbmsType.equals(StorageDesignUDBv81.RDBMS_TYPE) && !rdbmsType.equals(StorageDesignUDBv9.RDBMS_TYPE)) continue;
            StorageDesignUDBEstimates storageDesignUDBEstimates = ((StorageDesignUDB)storageDesign).getStorageDesignUDBEstimates();
            designEstimates = doc.getDocumentElement().getElementsByTagName(findKey);
            if (designEstimates.getLength() <= 0) continue;
            quantity = 0;
            elm = (Element)designEstimates.item(0);
            wElm = this.getFirstElementByTagName(PHYSICAL_MODEL_NAME, elm);
            wElm = this.getFirstElementByTagName(ALIASES, elm);
            if (wElm != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setAliasesQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(BUFFER_POOLS, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setBufferPoolsQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(DATA_BASES, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setDataBasesQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(DB_PARTITIONS, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setDbPartitionsQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(OWNERS, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setOwnersQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(USER_GROUPS, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setUserGroupsQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(SCHEMAS, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setSchemasQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(SEQUENCES, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setSequencesQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(STORED_PROCEDURES, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setStoredProceduresQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(FUNCTIONS, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setFunctionsQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(TABLES, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setTablesQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(TABLE_SPACES, elm)) != null) {
                quantity = new Integer(wElm.getAttribute("value"));
                storageDesignUDBEstimates.setTableSpacesQuantity(quantity);
            }
            if ((wElm = this.getFirstElementByTagName(TRIGGERS, elm)) == null) continue;
            quantity = new Integer(wElm.getAttribute("value"));
            storageDesignUDBEstimates.setTriggersQuantity(quantity);
        }
    }

    public void initPhysicalModelsEstimates(RelationalDesign relationalDesign) {
        try {
            File file = new File(relationalDesign.getDesign().getStoragePath(), DESIGN_LEVEL_SETTINGS_FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.initPhysicalModelsEstimates(doc, relationalDesign);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load Design Level Settings: ", e);
        }
    }

    private void initCompareMappings(Document doc) {
        try {
            this.getCompareMapping().clearCompareMappingsList();
            NodeList nodeList = doc.getElementsByTagName(COMPARE_MAPPING_ELEMENT);
            int nlLength = nodeList.getLength();
            for (int i = 0; i < nlLength; ++i) {
                Element element = (Element)nodeList.item(i);
                if (element == null) continue;
                String sourceParent = element.getAttribute(COMPARE_MAPPING_SOURCE_PARENT);
                String targetParent = element.getAttribute(COMPARE_MAPPING_TARGET_PARENT);
                String sourceObject = element.getAttribute(COMPARE_MAPPING_SOURCE_OBJECT);
                String targetObject = element.getAttribute(COMPARE_MAPPING_TARGET_OBJECT);
                CompareMappingObject compObj = new CompareMappingObject(sourceParent, sourceObject, targetParent, targetObject);
                this.getCompareMapping().addCompareMappingObject(compObj);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to initialize Compare mappings: ", e);
        }
    }

    public Element getFirstElementByTagName(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            Element elem = (Element)nodes.item(0);
            return elem;
        }
        return null;
    }

    private void initDefaultFCObjects() {
        this.defaultFCObjects.clear();
        DefaultFCEntity dfcEntity = new DefaultFCEntity("Entity", new Color(164, 225, 255), Color.BLUE);
        DefaultFCLogicalView dfcLogicalView = new DefaultFCLogicalView("Logical View", new Color(255, 155, 106), Color.BLUE);
        DefaultFCTable dfcTable = new DefaultFCTable("Table", new Color(255, 255, 180), Color.BLUE);
        DefaultFCRelationalView dfcRelView = new DefaultFCRelationalView("Relational View", new Color(150, 255, 150), Color.BLUE);
        DefaultFCStructuredType dfcStructuredType = new DefaultFCStructuredType("Structured Type", new Color(140, 250, 220), Color.BLACK);
        DefaultFCCube dfcCube = new DefaultFCCube("Cube", new Color(255, 226, 198), Color.BLACK);
        DefaultFCDimension dfcDimension = new DefaultFCDimension("Dimension", new Color(0, 250, 20), Color.BLACK);
        DefaultFCLevel dfcLevel = new DefaultFCLevel("Level", new Color(228, 208, 253), Color.BLACK);
        DefaultFCProcess dfcProcess = new DefaultFCProcess("Process", new Color(255, 255, 150), Color.BLACK);
        DefaultFCAgent dfcAgent = new DefaultFCAgent("External Agent", new Color(170, 255, 170), Color.BLACK);
        DefaultFCInfoStore dfcInfoStore = new DefaultFCInfoStore("Information Store", new Color(100, 205, 255), Color.BLACK);
        DefaultFCInOutParams dfcInOutParams = new DefaultFCInOutParams("In-Out Parameters", new Color(250, 250, 250), Color.BLACK);
        DefaultFCTransformation dfcTransformation = new DefaultFCTransformation("Transformation", new Color(255, 255, 213), Color.BLACK);
        DefaultFCNote dfcNote = new DefaultFCNote("Note", Color.LIGHT_GRAY, Color.BLACK);
        DefaultFCLabel dfcLabel = new DefaultFCLabel("Label", Color.WHITE, Color.BLACK);
        DefaultRALabel dfcRA = new DefaultRALabel("Relationship Attributes", new Color(255, 153, 102), Color.BLACK);
        DefaultFCLegend dfcLegend = new DefaultFCLegend("Legend", Color.WHITE, Color.BLACK);
        this.defaultFCObjects.add(dfcEntity);
        this.defaultFCObjects.add(dfcLogicalView);
        this.defaultFCObjects.add(dfcTable);
        this.defaultFCObjects.add(dfcRelView);
        this.defaultFCObjects.add(dfcStructuredType);
        this.defaultFCObjects.add(dfcCube);
        this.defaultFCObjects.add(dfcDimension);
        this.defaultFCObjects.add(dfcLevel);
        this.defaultFCObjects.add(dfcProcess);
        this.defaultFCObjects.add(dfcAgent);
        this.defaultFCObjects.add(dfcInfoStore);
        this.defaultFCObjects.add(dfcInOutParams);
        this.defaultFCObjects.add(dfcTransformation);
        this.defaultFCObjects.add(dfcNote);
        this.defaultFCObjects.add(dfcLabel);
        this.defaultFCObjects.add(dfcRA);
        this.defaultFCObjects.add(dfcLegend);
    }

    private void initDefaultLWCObjects() {
        this.defaultLWCObjects.clear();
        DefaultLWCRelation dlwcRelation = new DefaultLWCRelation("Logical Relation", Color.BLACK, 1);
        DefaultLWCInheritanceRelation dlwcInheritance = new DefaultLWCInheritanceRelation("Logical Inheritance", Color.RED, 1);
        DefaultLWCForeignKey dlwcForeignKey = new DefaultLWCForeignKey("Relational Foreign Key", Color.BLACK, 1);
        DefaultLWCTypeSubstitution dlwcTypeSubstitution = new DefaultLWCTypeSubstitution("Type Substitution", new Color(0, 200, 20), 1);
        DefaultLWCDTReference dlwcDTReference = new DefaultLWCDTReference("Datatype Reference", Color.BLUE, 1);
        DefaultLWCDTInheritance dlwcDTInheritance = new DefaultLWCDTInheritance("Datatype Inheritance", Color.RED, 1);
        DefaultLWCLink dlwcLink = new DefaultLWCLink("Multidimentional Link", Color.BLUE, 1);
        DefaultLWCLink dlwcHierarchy = new DefaultLWCLink("Multidimensional Hierarchy", new Color(0, 200, 20), 1);
        DefaultLWCFlow dlwcFlow = new DefaultLWCFlow("Process Flow", Color.RED, 1);
        this.defaultLWCObjects.add(dlwcRelation);
        this.defaultLWCObjects.add(dlwcInheritance);
        this.defaultLWCObjects.add(dlwcForeignKey);
        this.defaultLWCObjects.add(dlwcTypeSubstitution);
        this.defaultLWCObjects.add(dlwcDTReference);
        this.defaultLWCObjects.add(dlwcDTInheritance);
        this.defaultLWCObjects.add(dlwcLink);
        this.defaultLWCObjects.add(dlwcHierarchy);
        this.defaultLWCObjects.add(dlwcFlow);
    }

    public DefaultFontAndColor getDefaultFCObject(String className) {
        for (DefaultFontAndColor dfc : this.defaultFCObjects) {
            if (!dfc.getClassName().equalsIgnoreCase(className)) continue;
            return dfc;
        }
        return null;
    }

    public DefaultLineWidthAndColor getDefaultLWCObject(String className) {
        for (DefaultLineWidthAndColor dlwc : this.defaultLWCObjects) {
            if (!dlwc.getClassName().equalsIgnoreCase(className)) continue;
            return dlwc;
        }
        return null;
    }

    public List getDefaultFCObjects() {
        return this.defaultFCObjects;
    }

    public List getDefaultLWCObjects() {
        return this.defaultLWCObjects;
    }

    private void addDesignLevelSettings(StringBuffer buffer) {
        this.appendElement(LOGICALTYPE_FOR_DOMAIN_PRESENTATION, Boolean.toString(this.logicalTypeForDomainPresentation), buffer);
        this.appendElement(AUTOMATIC_PK_GENERATION, Boolean.toString(this.automaticPKGeneration), buffer);
        this.appendElement(AUTOMATIC_UK_GENERATION, Boolean.toString(this.automaticUKGeneration), buffer);
        this.appendElement(AUTOMATIC_FK_GENERATION, Boolean.toString(this.automaticFKGeneration), buffer);
        this.appendElement(PRESERVE_DDL_GENERATION_OPTIONS, Boolean.toString(this.preserveDDLGenerationOptions), buffer);
        this.appendElement(USE_GLOBAL_DESIGN_LEVEL_SETTINGS, Boolean.toString(this.useGlobalDesignLevelSettings), buffer);
        this.appendElement(USE_PREFERRED_CLASSIFICATION_TYPES, Boolean.toString(this.usePreferredClassificationTypes), buffer);
        this.appendSubstitutionPatterns(buffer);
        this.appendClassificationTypes(buffer);
        this.appendDefaultFontsAndColors(buffer);
        this.appendDefaultLineWidthsAndColors(buffer);
        this.appendNamingStandardRules(buffer);
        this.appendCompareMappings(buffer);
        this.appendEngineeringParams(buffer);
        this.appendEngineeringCompare(buffer);
        this.appendModelCompare(buffer);
        this.appendModelCompareStorage(buffer);
        this.appendNamingOptions(buffer);
        this.appendDeletedFiles(buffer);
        this.appendDynamicProperties(buffer);
        this.appendEstimates(buffer);
    }

    private void appendSubstitutionPatterns(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(SUBSTITUTION_PATTERNS).append('>');
        for (SubstitutionPattern substPattern : this.substitutionList) {
            String sourceString = substPattern.getSourceString().trim();
            if (sourceString.length() == 0) continue;
            buffer.append('\n');
            buffer.append('\t').append('\t');
            buffer.append("<substitutions").append(' ');
            buffer.append("oldstring=\"").append(substPattern.getSourceString()).append("\" ");
            buffer.append("newstring=\"").append(String.valueOf(substPattern.getReplacementString())).append("\" ");
            buffer.append("selected=\"").append(String.valueOf(substPattern.isSelected())).append("\" ");
            buffer.append("casesensitive=\"").append(String.valueOf(substPattern.isCaseSensitive())).append("\" ");
            buffer.append("comments=\"").append(String.valueOf(substPattern.getComments())).append("\" ");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(SUBSTITUTION_PATTERNS).append(">");
    }

    private void appendClassificationTypes(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(CLASSIFICATION_TYPES).append('>');
        for (ClassificationType classificationType : this.getClassificationTypeList()) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(TYPE).append(' ');
            buffer.append("name=\"").append(classificationType.getTypeName()).append("\" ");
            buffer.append("color=\"").append(classificationType.getTypeColor().getRGB()).append("\" ");
            buffer.append("fgcolor=\"").append(classificationType.getForegroundColor().getRGB()).append("\" ");
            buffer.append("prefix=\"").append(classificationType.getTypePrefix()).append("\" ");
            buffer.append("id=\"").append(classificationType.getTypeID()).append("\" ");
            buffer.append("preferred=\"").append(classificationType.isPreferred()).append("\" ");
            buffer.append('>');
            buffer.append('\n');
            buffer.append('\t').append('\t').append('<').append("fonts").append('>');
            for (FontObject fo : classificationType.getDefaultFCObject().getEditableFonts()) {
                this.appendFontObject(buffer, fo);
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("fonts").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append(TYPE).append(">");
        }
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(CLASSIFICATION_TYPES).append(">");
    }

    private void appendFontObject(StringBuffer buffer, FontObject fo) {
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("font_object").append(' ');
        buffer.append("fo_type=\"").append(fo.getType()).append("\" ");
        buffer.append("font_color=\"").append(fo.getColor().getRGB()).append("\" ");
        buffer.append("font_name=\"").append(fo.getFont().getName()).append("\" ");
        buffer.append("font_size=\"").append(fo.getFont().getSize()).append("\" ");
        buffer.append("font_style=\"").append(fo.getFont().getStyle()).append("\"");
        buffer.append("/>");
    }

    private void appendDefaultFontsAndColors(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(DEFAULT_FONTS_AND_COLORS).append('>');
        for (DefaultFontAndColor dfc : this.defaultFCObjects) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(FC_OBJECT).append(' ');
            buffer.append("classname=\"").append(dfc.getClassName()).append("\" ");
            buffer.append("background=\"").append(dfc.getBackgroundColor().getRGB()).append("\" ");
            buffer.append("foreground=\"").append(dfc.getForegroundColor().getRGB()).append("\" ");
            buffer.append("noBackgroundColor=\"").append(dfc.getNoBackgroundColor()).append("\" ");
            buffer.append("noForegroundColor=\"").append(dfc.getNoForegroundColor()).append("\"");
            buffer.append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('<').append("fonts").append('>');
            for (FontObject fo : dfc.getEditableFonts()) {
                this.appendFontObject(buffer, fo);
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("fonts").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append(FC_OBJECT).append(">");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(DEFAULT_FONTS_AND_COLORS).append(">");
    }

    private void appendDefaultLineWidthsAndColors(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(DEFAULT_LINE_WIDTHS_AND_COLORS).append('>');
        for (DefaultLineWidthAndColor dlwc : this.defaultLWCObjects) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(LWC_OBJECT).append(' ');
            buffer.append("classname=\"").append(dlwc.getClassName()).append("\" ");
            buffer.append("color=\"").append(dlwc.getColor().getRGB()).append("\" ");
            buffer.append("width=\"").append(dlwc.getWidth()).append("\"");
            buffer.append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append(LWC_OBJECT).append(">");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(DEFAULT_LINE_WIDTHS_AND_COLORS).append(">");
    }

    private void appendNamingStandardRules(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append("<").append(NAMING_STANDARD_RULE).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(LOGICAL).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(SEPARATOR).append(' ');
        if (this.namingRule == null) {
            this.namingRule = this.getNamingStandardRule();
        }
        buffer.append("value= \"").append(this.namingRule.getLogicalSep()).append("\"").append(' ');
        buffer.append("char=\"").append(this.namingRule.getLogicalChar()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(ENTITY).append(">");
        this.getListElements(this.namingRule.getEntitiesList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(ENTITY).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(ATTRIBUTE).append(">");
        this.getListElements(this.namingRule.getAttributesList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(ATTRIBUTE).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(LOGICAL).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(RELATIONAL).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(SEPARATOR).append(' ');
        buffer.append("value= \"").append(this.namingRule.getRelSep()).append("\"").append(' ');
        buffer.append("abbreviated_only=\"").append(this.namingRule.isAbbreviatedOnly()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(TABLE).append(">");
        this.getListElements(this.namingRule.getTablesList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(TABLE).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(COLUMN).append(">");
        this.getListElements(this.namingRule.getColumnsList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(COLUMN).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(RELATIONAL).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(DOMAINS).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(SEPARATOR).append(' ');
        buffer.append("value= \"").append(this.namingRule.getDomainsSep()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(DOMAIN).append(">");
        this.getListElements(this.namingRule.getDomainsList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(DOMAIN).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(DOMAINS).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(CONSTRAINTS).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("pk value=\"").append(this.namingRule.getPkConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("fk value=\"").append(this.namingRule.getFkConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("ck value=\"").append(this.namingRule.getCkConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("un value=\"").append(this.namingRule.getUnConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("idx value=\"").append(this.namingRule.getIdxConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("automatic_idx value=\"").append(this.namingRule.getAutomaticIdxConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("colck value=\"").append(this.namingRule.getColckConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("colnnc value=\"").append(this.namingRule.getColNNConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("column_foreign_key value=\"").append(this.namingRule.getFkColumn()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("ui value=\"").append(this.namingRule.getUIConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("relation_attribute value=\"").append(this.namingRule.getRelationAttribute()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("surrogate_key value=\"").append(this.namingRule.getSurrogateKey()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("surrogate_key_col value=\"").append(this.namingRule.getSurrogateKeyColumn()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("discriminator_col value=\"").append(this.namingRule.getDiscriminatorColumn()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(CONSTRAINTS).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(GLOSSARY).append(">");
        for (GlossaryFile gl : this.namingRule.getGlossariesList()) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(GLOSSARIES).append(' ');
            buffer.append("value=\"").append(gl.getFilePath()).append("\"");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(GLOSSARY).append(">");
        buffer.append('\n');
        buffer.append('\t').append("</").append(NAMING_STANDARD_RULE).append(">");
    }

    public void appendCompareMappings(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(COMPARE_MAPPING_ELEMENTS).append('>');
        Iterator<String> it = this.getCompareMapping().getCompareMap().keySet().iterator();
        while (it.hasNext()) {
            buffer.append('\n');
            CompareMappingObject mappingObj = this.getCompareMapping().getCompareMap().get(it.next());
            buffer.append('\t').append('<').append(COMPARE_MAPPING_ELEMENT).append(' ');
            buffer.append(COMPARE_MAPPING_SOURCE_PARENT).append(' ').append("=\"").append(mappingObj.getSourceParentName()).append("\"").append(' ');
            buffer.append(COMPARE_MAPPING_SOURCE_OBJECT).append(' ').append("=\"").append(mappingObj.getSourceObjectName()).append("\"").append(' ');
            buffer.append(COMPARE_MAPPING_TARGET_PARENT).append(' ').append("=\"").append(mappingObj.getTargetParentName()).append("\"").append(' ');
            buffer.append(COMPARE_MAPPING_TARGET_OBJECT).append(' ').append("=\"").append(mappingObj.getTargetObjectName()).append("\"").append(' ');
            buffer.append("selected").append(' ').append("=\"").append(mappingObj.isSelected()).append("\" />");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(COMPARE_MAPPING_ELEMENTS).append('>');
    }

    private void appendEngineeringParams(StringBuffer buffer) {
        if (this.design != null) {
            buffer.append('\n');
            buffer.append('\t').append("<").append("engineering_params").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("delete_without_origin").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isDeleteWithoutOrigin()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("engineer_coordinates").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isEngineerCoordinates()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("engineer_generated").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isEngineerGenerated()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("show_engineering_intree").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isShowEngineeringInTree()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("apply_naming_std").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isApplyNameStandardization()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("use_pref_abbreviation").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isUsePreferredAbbreviation()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("upload_directory").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.getUnloadDirectory()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("date_format").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.getEngDateFormat()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("timestamp_format").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.getEngTimestampFormat()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("timestamp_tz_format").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.getEngTimestampWTZFormat()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append("</").append("engineering_params").append(">");
        }
    }

    private void appendEngineeringCompare(StringBuffer buffer) {
        if (this.design != null) {
            buffer.append('\n');
            buffer.append('\t').append("<").append("eng_compare");
            buffer.append(' ').append("show_sel_prop_only").append("=\"").append(this.design.getShowSelPropsOnly()).append("\"");
            buffer.append(' ').append("not_apply_for_new_objects").append("=\"").append(this.design.getNotForNewObjects()).append("\"");
            buffer.append(' ').append("exclude_from_tree").append("=\"").append(this.design.getExcludeFromTree()).append("\"").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("entity_table").append(">");
            for (EngPropertyHolder propHolder : this.design.getEntTablePropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("entity_table").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("attribute_column").append(">");
            for (EngPropertyHolder propHolder : this.design.getAttrColPropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("attribute_column").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("key_index").append(">");
            for (EngPropertyHolder propHolder : this.design.getKeyIdxPropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("key_index").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("relation_fk").append(">");
            for (EngPropertyHolder propHolder : this.design.getRelFKPropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("relation_fk").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("relation_table").append(">");
            for (EngPropertyHolder propHolder : this.design.getRelTablePropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("relation_table").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("entityview_view").append(">");
            for (EngPropertyHolder propHolder : this.design.getViewPropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("entityview_view").append(">");
            buffer.append('\n');
            buffer.append('\t').append("</").append("eng_compare").append(">");
        }
    }

    private void appendModelCompare(StringBuffer buffer) {
        if (this.design != null) {
            buffer.append('\n');
            buffer.append('\t').append("<").append("model_compare_props_filter").append(">");
            this.addPropertiesFiltersToBuffer(this.design, buffer, false);
            buffer.append('\n');
            buffer.append('\t').append("</").append("model_compare_props_filter").append(">");
            buffer.append('\n');
            buffer.append('\t').append("<").append("model_compare_dyn_props_filter").append(">");
            this.addPropertiesFiltersToBuffer(this.design, buffer, true);
            buffer.append('\n');
            buffer.append('\t').append("</").append("model_compare_dyn_props_filter").append(">");
        }
    }

    private void appendModelCompareStorage(StringBuffer buffer) {
        if (this.design != null) {
            buffer.append('\n');
            buffer.append('\t').append("<").append("model_compare_storage_props_filter").append(">");
            this.addFiltersToBuffer(this.design.getStoragePropertiesFilterList(IndexComparator.class, false), "index_comparator", buffer);
            this.addFiltersToBuffer(this.design.getStoragePropertiesFilterList(SnapshotComparator.class, false), "snapshot_comparator", buffer);
            this.addFiltersToBuffer(this.design.getStoragePropertiesFilterList(TableComparator.class, false), "table_comparator", buffer);
            this.addFiltersToBuffer(this.design.getStoragePropertiesFilterList(BitmapJoinIndexComparatorOracle.class, false), "bitmap_join_index_oracle_comparator", buffer);
            buffer.append('\n');
            buffer.append('\t').append("</").append("model_compare_storage_props_filter").append(">");
        }
    }

    private void appendNamingOptions(StringBuffer buffer) {
        NamingOptionsHolder holder;
        Iterator noIterator;
        buffer.append('\n');
        buffer.append('\t').append("<").append("naming_options").append(">");
        for (RelationalDesign relDesign : this.design.getRelationalDesigns()) {
            noIterator = relDesign.getNamingOptionsHolderList().iterator();
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("model_options").append(" ").append("objectid").append("=\"").append(relDesign.getObjectID()).append("\"").append(">");
            while (noIterator.hasNext()) {
                holder = (NamingOptionsHolder)noIterator.next();
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("naming_option").append(" ");
                buffer.append("class_name").append("=\"").append(holder.getClassName().getName()).append("\"").append(" ");
                buffer.append("max_name_length").append("=\"").append(holder.getMaxNameLength()).append("\"").append(" ");
                buffer.append("case_type").append("=\"").append(holder.getCaseType()).append("\"").append(" ");
                buffer.append("valid_characters").append("=\"").append(StringUtilities.encodeAttributeValue(holder.getValidChars())).append("\"").append(" ");
                buffer.append("all_valid").append("=\"").append(holder.getIsValid()).append("\"").append(" />");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("model_options").append(">");
        }
        LogicalDesign logDesign = this.design.getLogicalDesign();
        noIterator = logDesign.getNamingOptionsHolderList().iterator();
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append("model_options").append(" ").append("objectid").append("=\"").append(logDesign.getObjectID()).append("\"").append(">");
        while (noIterator.hasNext()) {
            holder = (NamingOptionsHolder)noIterator.next();
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append("naming_option").append(" ");
            buffer.append("class_name").append("=\"").append(holder.getClassName().getName()).append("\"").append(" ");
            buffer.append("max_name_length").append("=\"").append(holder.getMaxNameLength()).append("\"").append(" ");
            buffer.append("case_type").append("=\"").append(holder.getCaseType()).append("\"").append(" ");
            buffer.append("valid_characters").append("=\"").append(holder.getValidChars()).append("\"").append(" ");
            buffer.append("all_valid").append("=\"").append(holder.getIsValid()).append("\"").append(" />");
        }
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append("model_options").append(">");
        buffer.append('\n');
        buffer.append('\t').append("</").append("naming_options").append(">");
    }

    private void appendMergeConflicts(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append("<").append("merge_conflicts").append(">");
        for (MergeConflict mergeConflict : this.getMergeConflicts()) {
            String mergeConflictPath = mergeConflict.getLocalFile().getPath().replace(this.design.getDesignPath(), "");
            String localVersionExtension = mergeConflict.getBaseLabel();
            String remoteVersionExtension = mergeConflict.getRepositoryLabel();
            String textStatus = mergeConflict.getStorableObjectStatus().getTextStatus();
            String propertyStatus = mergeConflict.getStorableObjectStatus().getPropertyStatus();
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("merge_conflict").append(" ");
            buffer.append("path").append("=\"").append(mergeConflictPath).append("\" ");
            buffer.append("local_version_extension").append("=\"").append(localVersionExtension).append("\" ");
            buffer.append("remote_version_extension").append("=\"").append(remoteVersionExtension).append("\" ");
            buffer.append("text_status").append("=\"").append(textStatus).append("\" ");
            buffer.append("property_status").append("=\"").append(propertyStatus).append("\"");
            buffer.append(" />");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append("merge_conflicts").append(">");
    }

    private void appendDeletedFiles(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append("<").append("deleted_files").append(">");
        for (DeletedFile deletedFile : this.getDeletedFiles()) {
            String deletedFilePath = deletedFile.getLocalFile().getPath().replace(this.design.getDesignPath(), "");
            String deletedFileUrl = deletedFile.getUrl();
            String deletedFileRevision = deletedFile.getRevision().toString();
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("deleted_file").append(" ");
            buffer.append("path").append("=\"").append(deletedFilePath).append("\" ");
            buffer.append("url").append("=\"").append(deletedFileUrl).append("\" ");
            buffer.append("revision").append("=\"").append(deletedFileRevision).append("\" ");
            buffer.append(" />");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append("deleted_files").append(">");
    }

    private void appendDynamicProperties(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append("<").append("dynamic_properties").append(">");
        for (DPObject o : this.getDynamicPropertiesList()) {
            if (o.getPresentationName().trim().equals("") && !o.isVisible()) continue;
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("property").append(" ");
            buffer.append(TAG_NAME).append("=\"").append(o.getName()).append("\" ");
            buffer.append("object_type").append("=\"").append(o.getType()).append("\" ");
            buffer.append("presentation_name").append("=\"").append(o.getPresentationName()).append("\"");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append("dynamic_properties").append(">");
    }

    private void appendEstimates(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append("<").append(DESIGN_ESTIMATES).append(">");
        if (this.design == null) {
            this.design = ApplicationView.getInstance().getCurrentDesign();
        }
        if (this.design != null) {
            LogicalDesignEstimates logicalDesignEstimates = this.design.getLogicalDesign().getLogicalDesignEstimates();
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(LOGICAL_MODEL_ESTIMATES).append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(ENTITIES).append(" ").append("value").append("=\"").append(logicalDesignEstimates.getEntitiesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(RELATIONS).append(" ").append("value").append("=\"").append(logicalDesignEstimates.getRelationsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(VIEWS).append(" ").append("value").append("=\"").append(logicalDesignEstimates.getViewsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(ARCS).append(" ").append("value").append("=\"").append(logicalDesignEstimates.getViewsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append(LOGICAL_MODEL_ESTIMATES).append(">");
            DataTypesDesignEstimates dataTypesDesignEstimates = this.design.getDataTypesDesign().getDataTypesDesignEstimates();
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(DATA_TYPES_MODEL_ESTIMATES).append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(STRUCTURED_TYPES).append(" ").append("value").append("=\"").append(dataTypesDesignEstimates.getStructuredTypesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(COLLECTION_TYPES).append(" ").append("value").append("=\"").append(dataTypesDesignEstimates.getCollectionTypesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(DISTINCT_TYPES).append(" ").append("value").append("=\"").append(dataTypesDesignEstimates.getDistinctTypesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append(DATA_TYPES_MODEL_ESTIMATES).append(">");
            RelationalDesignSet relationalDesignSet = this.design.getRelationalDesigns();
            if (relationalDesignSet.size() > 0) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append("<").append(RELATIONAL_MODEL_ESTIMATES).append(">");
                for (int i = 0; i < relationalDesignSet.size(); ++i) {
                    RelationalDesign relationalDesign = (RelationalDesign)relationalDesignSet.getElement(i);
                    this.appendRelationalModelEstimates(buffer, relationalDesign, i);
                }
                buffer.append('\n');
                buffer.append('\t').append('\t').append("</").append(RELATIONAL_MODEL_ESTIMATES).append(">");
            }
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(DESIGN_ESTIMATES).append(">");
    }

    private void appendRelationalModelEstimates(StringBuffer buffer, RelationalDesign relationalDesign, int i) {
        RelationalDesignEstimates relationalDesignEstimates = relationalDesign.getRelationalDesignEstimates();
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(RELATIONAL_MODEL_).append(i).append(_ESTIMATES).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append('\t').append("<").append(RELATIONAL_MODEL_NAME).append(" ").append("value").append("=\"").append(relationalDesign.getName()).append("\"/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append('\t').append("<").append(TABLES).append(" ").append("value").append("=\"").append(relationalDesignEstimates.getTablesQuantity()).append("\"/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append('\t').append("<").append(VIEWS).append(" ").append("value").append("=\"").append(relationalDesignEstimates.getViewsQuantity()).append("\"/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append('\t').append("<").append(FOREIGN_KEYS).append(" ").append("value").append("=\"").append(relationalDesignEstimates.getForeignKeysQuantity()).append("\"/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append('\t').append("<").append(SCHEMAS).append(" ").append("value").append("=\"").append(relationalDesignEstimates.getSchemasQuantity()).append("\"/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append('\t').append("<").append(SUBVIEWS).append(" ").append("value").append("=\"").append(relationalDesignEstimates.getSubviewsQuantity()).append("\"/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append('\t').append("<").append(ARCS).append(" ").append("value").append("=\"").append(relationalDesignEstimates.getArcsQuantity()).append("\"/>");
        this.appendPhysicalModelsEstimates(buffer, relationalDesign);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(RELATIONAL_MODEL_).append(i).append(_ESTIMATES).append(">");
    }

    private void appendPhysicalModelsEstimates(StringBuffer buffer, RelationalDesign relationalDesign) {
        StorageDesignSet storageDesignSet = relationalDesign.getSorageDesigns();
        if (storageDesignSet.size() > 0) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append("<").append(PHYSICAL_MODELS_ESTIMATES).append(">");
            for (int i = 0; i < storageDesignSet.size(); ++i) {
                StorageDesign storageDesign = (StorageDesign)storageDesignSet.getElement(i);
                this.appendPhysicallModelEstimates(buffer, relationalDesign, storageDesign);
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append("</").append(PHYSICAL_MODELS_ESTIMATES).append(">");
        }
    }

    private void appendPhysicallModelEstimates(StringBuffer buffer, RelationalDesign relationalDesign, StorageDesign storageDesign) {
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(PHYSICAL_MODEL_).append(relationalDesign.getObjectID()).append("_").append(this.replaceSpecCharsWithUnderscores(storageDesign.getName())).append(">");
        RDBMSType rdbmsType = storageDesign.getRDBMSType();
        if (rdbmsType.equals(StorageDesignOraclev12cR2.RDBMS_TYPE) || rdbmsType.equals(StorageDesignOraclev12c.RDBMS_TYPE) || rdbmsType.equals(StorageDesignOraclev11g.RDBMS_TYPE) || rdbmsType.equals(StorageDesignOraclev10g.RDBMS_TYPE) || rdbmsType.equals(StorageDesignOraclev9i.RDBMS_TYPE)) {
            StorageDesignOracleEstimates storageDesignOracleEstimates = ((StorageDesignOracle)storageDesign).getStorageDesignOracleEstimates();
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(PHYSICAL_MODEL_NAME).append(" ").append("value").append("=\"").append(storageDesign.getName()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(CLUSTERS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getClustersQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(CONTEXTS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getContextsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(DBS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getDBsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(DIMENSIONS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getDimensionsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(DIRECTORIES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getDirectoriesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(DISKGROUPS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getDiskGroupsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(EXTERNALTABLES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getExternalTablesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(SNAPSHOTS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getSnapshotsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(ROLES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getRolesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(ROLLBACKSEGMENTS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getRollbackSegmentsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(SEGMENTS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getSegmentsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(SEQUENCES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getSequencesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(STOREDPROCEDURES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getStoredProceduresQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(FUNCTIONS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getFunctionsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(PACKAGES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getPackagesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(COLLECTIONTYPES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getCollectionTypesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(STRUCTUREDTYPES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getStructuredTypesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(SYNONYMS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getSynonymsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TABLES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getTablesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TABLESPACES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getTableSpacesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TEMPORARYTABLESPACES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getTemporaryTableSpacesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(UNDOTABLESPACES).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getUndoTableSpacesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(USERS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getUsersQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(VIEWS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getViewsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TRIGGERS).append(" ").append("value").append("=\"").append(storageDesignOracleEstimates.getTriggersQuantity()).append("\"/>");
        } else if (rdbmsType.equals(StorageDesignSqlServerv2k12.RDBMS_TYPE) || rdbmsType.equals(StorageDesignSqlServerv2k8.RDBMS_TYPE) || rdbmsType.equals(StorageDesignSqlServerv2k5.RDBMS_TYPE) || rdbmsType.equals(StorageDesignSqlServerv2k.RDBMS_TYPE)) {
            StorageDesignSqlServerEstimates storageDesignSqlServerEstimates = ((StorageDesignSqlServer)storageDesign).getStorageDesignSqlServerEstimates();
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(PHYSICAL_MODEL_NAME).append(" ").append("value").append("=\"").append(storageDesign.getName()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(DATA_BASES).append(" ").append("value").append("=\"").append(storageDesignSqlServerEstimates.getDataBasesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(LOGINS).append(" ").append("value").append("=\"").append(storageDesignSqlServerEstimates.getLoginsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TABLES).append(" ").append("value").append("=\"").append(storageDesignSqlServerEstimates.getTablesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(VIEWS).append(" ").append("value").append("=\"").append(storageDesignSqlServerEstimates.getViewsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(USER_DEFINED_TYPES).append(" ").append("value").append("=\"").append(storageDesignSqlServerEstimates.getUserDefinedTypesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TRIGGERS).append(" ").append("value").append("=\"").append(storageDesignSqlServerEstimates.getTriggersQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(USERS).append(" ").append("value").append("=\"").append(storageDesignSqlServerEstimates.getUsersQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(ROLES).append(" ").append("value").append("=\"").append(storageDesignSqlServerEstimates.getRolesQuantity()).append("\"/>");
        } else if (rdbmsType.equals(StorageDesignDB2v70.RDBMS_TYPE) || rdbmsType.equals(StorageDesignDB2v80.RDBMS_TYPE)) {
            AbstractStorageDesignDB2Estimates abstractStorageDesignDB2Estimates = ((AbstractStorageDesignDB2)storageDesign).getAbstractStorageDesignDB2Estimates();
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(PHYSICAL_MODEL_NAME).append(" ").append("value").append("=\"").append(storageDesign.getName()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(ALIASES).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getAliasesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(AUX_TABLES).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getAuxTablesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(BUFFER_POOLS).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getBufferPoolsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(DATA_BASES).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getDataBasesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(OWNERS).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getOwnersQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(STORAGE_TEMPLATES).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getStorageTemplatesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(STORED_PROCEDURES).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getStoredProceduresQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(SEQUENCES).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getSequencesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TABLES).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getTablesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(VCATS).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getVCATsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(VIEWS).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getViewsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(VOLUMES).append(" ").append("value").append("=\"").append(abstractStorageDesignDB2Estimates.getVolumesQuantity()).append("\"/>");
        } else if (rdbmsType.equals(StorageDesignUDBv71.RDBMS_TYPE) || rdbmsType.equals(StorageDesignUDBv81.RDBMS_TYPE) || rdbmsType.equals(StorageDesignUDBv9.RDBMS_TYPE)) {
            StorageDesignUDBEstimates storageDesignUDBEstimates = ((StorageDesignUDB)storageDesign).getStorageDesignUDBEstimates();
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(PHYSICAL_MODEL_NAME).append(" ").append("value").append("=\"").append(storageDesign.getName()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(ALIASES).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getAliasesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(BUFFER_POOLS).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getBufferPoolsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(DATA_BASES).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getDataBasesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(DB_PARTITIONS).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getDbPartitionsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(OWNERS).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getOwnersQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(USER_GROUPS).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getUserGroupsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(SCHEMAS).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getSchemasQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(SEQUENCES).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getSequencesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(STORED_PROCEDURES).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getStoredProceduresQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(FUNCTIONS).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getFunctionsQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TABLES).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getTablesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TABLE_SPACES).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getTableSpacesQuantity()).append("\"/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("<").append(TRIGGERS).append(" ").append("value").append("=\"").append(storageDesignUDBEstimates.getTriggersQuantity()).append("\"/>");
        }
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append('\t').append("</").append(PHYSICAL_MODEL_).append(relationalDesign.getObjectID()).append("_").append(this.replaceSpecCharsWithUnderscores(storageDesign.getName())).append(">");
    }

    private void initEngineeringParams(Document doc) {
        Element element;
        if (this.design != null && (element = this.getFirstElementByTagName("engineering_params", doc.getDocumentElement())) != null) {
            Element e = this.getFirstElementByTagName("delete_without_origin", element);
            if (e != null) {
                this.design.setDeleteWithoutOrigin("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("engineer_coordinates", element)) != null) {
                this.design.setEngineerCoordinates("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("engineer_generated", element)) != null) {
                this.design.setEngineerGenerated("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("show_engineering_intree", element)) != null) {
                this.design.setShowEngineeringInTree("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("apply_naming_std", element)) != null && !"".equals(e.getAttribute("value"))) {
                this.design.setApplyNameStandardization("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("use_pref_abbreviation", element)) != null && !"".equals(e.getAttribute("value"))) {
                this.design.setUsePreferredAbbreviation("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("upload_directory", element)) != null) {
                this.design.setUnloadDirectory(StringUtilities.decodeAttributeValue(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("date_format", element)) != null) {
                this.design.setEngDateFormat(StringUtilities.decodeAttributeValue(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("timestamp_format", element)) != null) {
                this.design.setEngTimestampFormat(StringUtilities.decodeAttributeValue(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("timestamp_tz_format", element)) != null) {
                this.design.setEngTimestampWTZFormat(StringUtilities.decodeAttributeValue(e.getAttribute("value")));
            }
        }
    }

    private void initEngineeringCompare(Document doc) {
        if (this.design != null) {
            NodeList elems = doc.getElementsByTagName("eng_compare");
            for (int i = 0; i < elems.getLength(); ++i) {
                Element e = (Element)elems.item(i);
                String showSelOnly = StringUtilities.decodeAttributeValue(e.getAttribute("show_sel_prop_only"));
                String notApply = StringUtilities.decodeAttributeValue(e.getAttribute("not_apply_for_new_objects"));
                String exclFromTree = StringUtilities.decodeAttributeValue(e.getAttribute("exclude_from_tree"));
                this.design.setShowSelPropsOnly(Boolean.valueOf(showSelOnly));
                this.design.setNotForNewObjects(Boolean.valueOf(notApply));
                this.design.setExcludeFromTree(Boolean.valueOf(exclFromTree));
            }
            NodeList engParams = doc.getDocumentElement().getElementsByTagName("property");
            int length = engParams.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)engParams.item(i);
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("entity_table")) {
                    this.addToList(elm, this.design.getEntTablePropertyList());
                    continue;
                }
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("attribute_column")) {
                    this.addToList(elm, this.design.getAttrColPropertyList());
                    continue;
                }
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("key_index")) {
                    this.addToList(elm, this.design.getKeyIdxPropertyList());
                    continue;
                }
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("relation_fk")) {
                    this.addToList(elm, this.design.getRelFKPropertyList());
                    continue;
                }
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("relation_table")) {
                    this.addToList(elm, this.design.getRelTablePropertyList());
                    continue;
                }
                if (!elm.getParentNode().getNodeName().equalsIgnoreCase("entityview_view")) continue;
                this.addToList(elm, this.design.getViewPropertyList());
            }
        }
    }

    private void initModelCompare(Document doc) {
        if (this.design != null) {
            String nodeName;
            Element elem;
            int i;
            int length;
            NodeList elemParams;
            Element modelCompare;
            this.design.clearPropertiesAndStoragePropsFilters();
            this.design.clearDynamicPropertiesFilters();
            NodeList elems = doc.getElementsByTagName("model_compare_props_filter");
            if (elems != null && elems.getLength() > 0) {
                modelCompare = (Element)elems.item(0);
                elemParams = modelCompare.getElementsByTagName("property_filter");
                length = elemParams.getLength();
                for (i = 0; i < length; ++i) {
                    elem = (Element)elemParams.item(i);
                    nodeName = elem.getParentNode().getNodeName();
                    this.addPropertyFilterToList(this.design, elem, nodeName, false);
                }
            }
            if ((elems = doc.getElementsByTagName("model_compare_dyn_props_filter")) != null && elems.getLength() > 0) {
                modelCompare = (Element)elems.item(0);
                elemParams = modelCompare.getElementsByTagName("property_filter");
                length = elemParams.getLength();
                for (i = 0; i < length; ++i) {
                    elem = (Element)elemParams.item(i);
                    nodeName = elem.getParentNode().getNodeName();
                    this.addPropertyFilterToList(this.design, elem, nodeName, true);
                }
            }
        }
    }

    private void initModelCompareStorage(Document doc) {
        NodeList elems;
        if (this.design != null && (elems = doc.getElementsByTagName("model_compare_storage_props_filter")) != null && elems.getLength() > 0) {
            Element modelCompare = (Element)elems.item(0);
            NodeList elemParams = modelCompare.getElementsByTagName("property_filter");
            int length = elemParams.getLength();
            for (int i = 0; i < length; ++i) {
                Element elem = (Element)elemParams.item(i);
                String nodeName = elem.getParentNode().getNodeName();
                if (nodeName.equals("index_comparator")) {
                    this.addFilterToList(elem, this.design.getStoragePropertiesFilterList(IndexComparator.class, true));
                    continue;
                }
                if (nodeName.equals("snapshot_comparator")) {
                    this.addFilterToList(elem, this.design.getStoragePropertiesFilterList(SnapshotComparator.class, true));
                    continue;
                }
                if (nodeName.equals("table_comparator")) {
                    this.addFilterToList(elem, this.design.getStoragePropertiesFilterList(TableComparator.class, true));
                    continue;
                }
                if (!nodeName.equals("bitmap_join_index_oracle_comparator")) continue;
                this.addFilterToList(elem, this.design.getStoragePropertiesFilterList(BitmapJoinIndexComparatorOracle.class, true));
            }
        }
    }

    private void appendElement(String elmName, String value, StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(elmName).append(' ').append("value").append("=\"").append(value).append("\" />");
    }

    public void getListElements(List list, StringBuffer buffer) {
        for (WordRule wr : list) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append("<").append("value").append(' ');
            buffer.append("type=\"").append(wr.getWordType()).append("\"").append(' ');
            buffer.append("mandatory=\"").append(wr.isMandatory()).append("\"");
            buffer.append("/>");
        }
    }

    private void addFiltersToBuffer(List filterList, String filterTag, StringBuffer buffer) {
        StringBuffer buf = new StringBuffer();
        buf.append('\n');
        buf.append('\t').append('\t').append("<").append(filterTag).append(">");
        boolean found = this.addFilterToBuffer(filterList, buf);
        buf.append('\n');
        buf.append('\t').append('\t').append("</").append(filterTag).append(">");
        if (found) {
            buffer.append(buf);
        }
    }

    private void addPropertiesFiltersToBuffer(Design design, StringBuffer buffer, boolean dynamicProp) {
        for (Map.Entry<String, String> entry : compClassToNameMap.entrySet()) {
            List filterList = !dynamicProp ? design.getPropertiesFilterList(entry.getKey(), false) : design.getDynamicPropertiesFilterList(entry.getKey(), false);
            String filterTag = entry.getValue();
            StringBuffer buf = new StringBuffer();
            buf.append('\n');
            buf.append('\t').append('\t').append("<").append(filterTag).append(">");
            boolean found = this.addFilterToBuffer(filterList, buf);
            buf.append('\n');
            buf.append('\t').append('\t').append("</").append(filterTag).append(">");
            if (!found) continue;
            buffer.append(buf);
        }
    }

    private String getValue(Document doc, String tagName) {
        Element element;
        NodeList list = doc.getElementsByTagName(tagName);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            return element.getAttribute("value");
        }
        return "";
    }

    private boolean addFilterToBuffer(List filterList, StringBuffer buffer) {
        boolean found = false;
        for (PropertyFilter propFilter : filterList) {
            if (propFilter.isSelected()) continue;
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append("property_filter").append(' ');
            buffer.append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propFilter.getName())).append("\"").append(' ');
            buffer.append("selected").append("=\"").append(propFilter.isSelected()).append("\"").append("/>");
            found = true;
        }
        return found;
    }

    private void addFilterToList(Element elem, List filterList) {
        String propName = StringUtilities.decodeAttributeValue(elem.getAttribute(TAG_NAME));
        String selected = StringUtilities.decodeAttributeValue(elem.getAttribute("selected"));
        PropertyFilter pf = new PropertyFilter(propName);
        pf.setSelected(Boolean.valueOf(selected));
        filterList.add(pf);
    }

    private void addPropertyFilterToList(Design design, Element elem, String nodeName, boolean dynamic) {
        List filterList;
        String cl = compNameToClassMap.get(nodeName);
        if (cl != null && (filterList = dynamic ? design.getDynamicPropertiesFilterList(cl, true) : design.getPropertiesFilterList(cl, true)) != null) {
            String propName = StringUtilities.decodeAttributeValue(elem.getAttribute(TAG_NAME));
            String selected = StringUtilities.decodeAttributeValue(elem.getAttribute("selected"));
            PropertyFilter pf = new PropertyFilter(propName);
            pf.setSelected(Boolean.valueOf(selected));
            filterList.add(pf);
        }
    }

    private void addToList(Element elem, List elemList) {
        String propName = StringUtilities.decodeAttributeValue(elem.getAttribute(TAG_NAME));
        String selected = StringUtilities.decodeAttributeValue(elem.getAttribute("selected"));
        for (EngPropertyHolder h : elemList) {
            if (!propName.equalsIgnoreCase(h.getName())) continue;
            h.setSelected(Boolean.valueOf(selected));
            break;
        }
    }

    public String getDesignLevelSettingsAsString() {
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append('\n');
        buffer.append('<').append(SETTINGS_ELEMENT).append('>');
        this.addDesignLevelSettings(buffer);
        buffer.append('\n');
        buffer.append("</").append(SETTINGS_ELEMENT).append('>');
        return buffer.toString();
    }

    public String getMergeConflictsAsString() {
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append('\n');
        buffer.append('<').append(SETTINGS_ELEMENT).append('>');
        this.appendMergeConflicts(buffer);
        buffer.append('\n');
        buffer.append("</").append(SETTINGS_ELEMENT).append('>');
        return buffer.toString();
    }

    public void loadDesignLevellSettingsFromString(String dlSettings) {
        try {
            StringReader sr = new StringReader(dlSettings);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(sr);
            Document doc = builder.parse(inputSource);
            this.loadDesignLevelSettings(doc);
        }
        catch (Exception e) {
            LOGGER.error("Unable to initialize Settings: ", e);
        }
    }

    public void loadDesignLevelSettingsFile(String designPath) {
        try {
            File file = new File(designPath, DESIGN_LEVEL_SETTINGS_FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.loadDesignLevelSettings(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load Design Level Settings: ", e);
        }
    }

    public List<MergeConflict> getMergeConflicts() {
        return this.mergeConflicts;
    }

    public List<DeletedFile> getDeletedFiles() {
        return this.deletedFiles;
    }

    public String toString() {
        return "Design Level Settings";
    }

    public List<DPObject> getDynamicPropertiesList() {
        return this.dynamicPropertiesList;
    }

    private static void initComparatorsFiltersMaps() {
        compClassToNameMap.put(ColumnComparator.class.getName(), "column_comparator");
        compClassToNameMap.put(FKComparator.class.getName(), "fk_comparator");
        compClassToNameMap.put(FKArcComparator.class.getName(), "fk_arc_comparator");
        compClassToNameMap.put(IndexComparator.class.getName(), "index_comparator");
        compClassToNameMap.put(NoteComparator.class.getName(), "note_comparator");
        compClassToNameMap.put(TableComparator.class.getName(), "table_comparator");
        compClassToNameMap.put(TableConstraintComparator.class.getName(), "table_constraint_comparator");
        compClassToNameMap.put(TableViewComparator.class.getName(), "table_view_comparator");
        compClassToNameMap.put(ValidTimeDimensionComparator.class.getName(), "valid_time_dimension_comparator");
        compClassToNameMap.put(ViewIndexComparator.class.getName(), "view_index_comparator");
        compClassToNameMap.put(ArcComparator.class.getName(), "arc_comparator");
        compClassToNameMap.put(AttributeComparator.class.getName(), "attribute_comparator");
        compClassToNameMap.put(CollectionTypeComparator.class.getName(), "collection_type_comparator");
        compClassToNameMap.put(CWDIndexComparator.class.getName(), "cwd_index_comparator");
        compClassToNameMap.put(CWDModelComparator.class.getName(), "cwd_model_comparator");
        compClassToNameMap.put(CWDTableComparator.class.getName(), "cwd_table_comparator");
        compClassToNameMap.put(CWDViewIndexComparator.class.getName(), "cwd_view_index_comparator");
        compClassToNameMap.put(DistinctTypeComparator.class.getName(), "distinct_type_comparator");
        compClassToNameMap.put(EntityComparator.class.getName(), "entity_comparator");
        compClassToNameMap.put(EntityViewComparator.class.getName(), "entity_view_comparator");
        compClassToNameMap.put(InheritanceRelationComparator.class.getName(), "inheritance_relation_comparator");
        compClassToNameMap.put(KeyComparator.class.getName(), "key_comparator");
        compClassToNameMap.put(LogicalSubViewComparator.class.getName(), "logical_subview_comparator");
        compClassToNameMap.put(MethodComparator.class.getName(), "method_comparator");
        compClassToNameMap.put(MethodParamComparator.class.getName(), "method_param_comparator");
        compClassToNameMap.put(RelationalSubViewComparator.class.getName(), "relational_subview_comparator");
        compClassToNameMap.put(RelationComparator.class.getName(), "relation_comparator");
        compClassToNameMap.put(StructuredTypeComparator.class.getName(), "structured_type_comparator");
        compClassToNameMap.put(TypeElementComparator.class.getName(), "type_element_comparator");
        compClassToNameMap.put(BitmapJoinIndexComparatorOracle.class.getName(), "bitmap_join_index_oracle_comparator");
        compClassToNameMap.put(CollectionTypeComparatorOracle.class.getName(), "collection_type_oracle_comparator");
        compClassToNameMap.put(ColumnComparatorOracle.class.getName(), "column_oracle_comparator");
        compClassToNameMap.put(ContextComparatorOracle.class.getName(), "context_oracle_comparator");
        compClassToNameMap.put(DataFileComparatorOracle.class.getName(), "data_file_oracle_comparator");
        compClassToNameMap.put(DimensionComparatorOracle.class.getName(), "dimension_oracle_comparator");
        compClassToNameMap.put(DirectoryComparatorOracle.class.getName(), "directory_oracle_comparator");
        compClassToNameMap.put(FKComparatorOracle.class.getName(), "fk_oracle_comparator");
        compClassToNameMap.put(FunctionComparatorOracle.class.getName(), "function_oracle_comparator");
        compClassToNameMap.put(HashPartitionComparatorOracle.class.getName(), "hash_partition_oracle_comparator");
        compClassToNameMap.put(HashSubpartitionComparatorOracle.class.getName(), "hash_subpartition_oracle_comparator");
        compClassToNameMap.put(HashSubpartitionTemplateComparatorOracle.class.getName(), "hash_subpartition_template_oracle_comparator");
        compClassToNameMap.put(HierarchyComparatorOracle.class.getName(), "hierarchy_oracle_comparator");
        compClassToNameMap.put(IndexComparatorOracle.class.getName(), "index_oracle_comparator");
        compClassToNameMap.put(IndexGlobalPartitionComparatorOracle.class.getName(), "index_global_partition_oracle_comparator");
        compClassToNameMap.put(IndexGlobalPartitioningComparatorOracle.class.getName(), "index_global_partitioning_oracle_comparator");
        compClassToNameMap.put(IndexHashPartitionComparatorOracle.class.getName(), "index_hash_partition_oracle_comparator");
        compClassToNameMap.put(LevelComparatorOracle.class.getName(), "level_oracle_comparator");
        compClassToNameMap.put(ListPartitionComparatorOracle.class.getName(), "list_partition_oracle_comparator");
        compClassToNameMap.put(ListSubpartitionComparatorOracle.class.getName(), "list_subpartition_oracle_comparator");
        compClassToNameMap.put(ListSubpartitionTemplateComparatorOracle.class.getName(), "list_subpartition_template_oracle_comparator");
        compClassToNameMap.put(LobStorageComparatorOracle.class.getName(), "lob_storage_oracle_comparator");
        compClassToNameMap.put(MethodComparatorOracle.class.getName(), "method_oracle_comparator");
        compClassToNameMap.put(MethodParamComparatorOracle.class.getName(), "method_param_oracle_comparator");
        compClassToNameMap.put(PackageComparatorOracle.class.getName(), "package_oracle_comparator");
        compClassToNameMap.put(PartitioningComparatorOracle.class.getName(), "partitioning_oracle_comparator");
        compClassToNameMap.put(PermissionsComparatorOracle.class.getName(), "permissions_oracle_comparator");
        compClassToNameMap.put(PKUKComparatorOracle.class.getName(), "pkuk_oracle_comparator");
        compClassToNameMap.put(QuotaItemComparatorOracle.class.getName(), "quota_item_oracle_comparator");
        compClassToNameMap.put(RangePartitionComparatorOracle.class.getName(), "range_partition_oracle_comparator");
        compClassToNameMap.put(RangeSubpartitionComparatorOracle.class.getName(), "range_subpartition_oracle_comparator");
        compClassToNameMap.put(RangeSubpartitionTemplateComparatorOracle.class.getName(), "range_subpartition_template_oracle_comparator");
        compClassToNameMap.put(RoleComparatorOracle.class.getName(), "role_oracle_comparator");
        compClassToNameMap.put(SequenceComparatorOracle.class.getName(), "sequence_oracle_comparator");
        compClassToNameMap.put(SnapshotComparator.class.getName(), "snapshot_comparator");
        compClassToNameMap.put(StoredProcedureComparatorOracle.class.getName(), "stored_procedure_oracle_comparator");
        compClassToNameMap.put(StructuredTypeComparatorOracle.class.getName(), "structured_type_oracle_comparator");
        compClassToNameMap.put(SynonymComparatorOracle.class.getName(), "synonym_oracle_comparator");
        compClassToNameMap.put(TableComparatorOracle.class.getName(), "table_oracle_comparator");
        compClassToNameMap.put(TableConstraintComparatorOracle.class.getName(), "table_constraint_oracle_comparator");
        compClassToNameMap.put(TableViewComparatorOracle.class.getName(), "table_view_oracle_comparator");
        compClassToNameMap.put(TablespaceComparatorOracle.class.getName(), "tablespace_oracle_comparator");
        compClassToNameMap.put(TemporaryTablespaceComparatorOracle.class.getName(), "temporary_tablespace_oracle_comparator");
        compClassToNameMap.put(TriggerOracleComparator.class.getName(), "trigger_oracle_comparator");
        compClassToNameMap.put(UndoTablespaceComparatorOracle.class.getName(), "undo_tablespace_oracle_comparator");
        compClassToNameMap.put(UserComparatorOracle.class.getName(), "user_oracle_comparator");
        compClassToNameMap.put(SequenceSqlServerComparator.class.getName(), "sequence_sqlserver_comparator");
        compClassToNameMap.put(TriggerSqlServerComparator.class.getName(), "trigger_sqlserver_comparator");
        compClassToNameMap.put(TriggerDB2Comparator.class.getName(), "trigger_db2_comparator");
        compClassToNameMap.put(TriggerUDBComparator.class.getName(), "trigger_udb_comparator");
        for (Map.Entry<String, String> entry : compClassToNameMap.entrySet()) {
            String obj = compNameToClassMap.get(entry.getValue());
            if (obj != null) {
                LOGGER.error("Duplicated Class to Name difinition form Comp filters -" + entry.getValue() + " - " + entry.getKey());
            }
            compNameToClassMap.put(entry.getValue(), entry.getKey());
        }
    }

    public List getPreferredClassificationTypes() {
        ArrayList<ClassificationType> list = new ArrayList<ClassificationType>();
        for (ClassificationType classificationType : this.getClassificationTypeList()) {
            if (!classificationType.isPreferred()) continue;
            list.add(classificationType);
        }
        return list;
    }

    public Object[] getPreferredClassificationTypeNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(null);
        for (ClassificationType ct : this.getPreferredClassificationTypes()) {
            list.add(ct.getTypeName());
        }
        return list.toArray();
    }

    public boolean isUsePreferredClassificationTypes() {
        return this.usePreferredClassificationTypes;
    }

    public void setUsePreferredClassificationTypes(boolean usePreferredClassificationTypes) {
        this.usePreferredClassificationTypes = usePreferredClassificationTypes;
    }

    private String replaceSpecCharsWithUnderscores(String s) {
        char[] charArray = s.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != ' ' && charArray[i] != '/' && charArray[i] != '\\') continue;
            charArray[i] = 95;
        }
        return new String(charArray);
    }

    static {
        DesignLevelSettings.initComparatorsFiltersMaps();
    }

    public class DPObject {
        private String name;
        private String presentationName;
        private boolean visible;
        private String type;

        public DPObject(String name, String type, String presentationName, boolean visible) {
            this.name = name;
            this.type = type;
            this.presentationName = presentationName;
            this.visible = visible;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        public void setPresentationName(String presentationName) {
            this.presentationName = presentationName;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

