/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.RemoteObjectListener;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.FontObjectWr;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class DesignObject
extends ModelIDObject
implements LongNameObject,
RemoteObjectListener {
    protected String oldName = null;
    protected DesignObjectSet containerSet = DesignObjectSet.NULL_SET;
    private boolean isBeingRemoved = false;
    private boolean removed = false;
    private TopView topView = null;
    private DesignPart designPart;
    private ArrayList measurements;
    private ArrayList requests;
    private List documents;
    private List responsibleParties;
    private Design importedDesign;
    private String importedId;
    private boolean visible = true;
    private static final Logger LOGGER;
    private Map engineerTo = new Hashtable();
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    private boolean useDefaultColor = true;
    protected boolean noBackgroundColor = false;
    protected boolean noForegroundColor = false;
    private int lineWidth = 1;
    protected boolean backup = false;
    private Set remoteObjectListeners = new HashSet();
    private boolean deprecated = false;
    private boolean useDDLTransformationScript = false;
    private boolean copyForIncrementalDDL = false;
    private boolean ordsDropSchema = false;
    private String ordsAlias = "";
    private boolean ordsEnable = false;
    private boolean ordsAuth = false;
    private static final String[] excludeProps;
    protected boolean selected;
    private float loadedVersion = 0.0f;
    public static final DesignObject[] PROTOTYPE;

    public DesignObject(DesignPart designPart) {
        this.designPart = designPart;
        if (designPart != null) {
            this.name = null;
            this.setDesign(designPart.getDesign());
            if (designPart.isLoaded()) {
                this.setDirty(true);
            }
        }
    }

    public void setDesignObjectSet(DesignObjectSet set) {
        this.containerSet = set;
        if (set == null) {
            this.containerSet = DesignObjectSet.NULL_SET;
        }
    }

    public DesignObjectSet getDesignObjectSet() {
        return this.containerSet;
    }

    public float getVersion() {
        return 1.0f;
    }

    @Override
    public boolean setName(String name) {
        if (this.isWriteable() && !this.isNameFixed()) {
            String variant;
            ContainerObject co;
            String schema;
            String newName;
            if (name != null && name.equals(this.name)) {
                return true;
            }
            NameSpaceController nsc = this.containerSet.getNameSpaceController();
            if (nsc != null) {
                return this.setNameNew(name);
            }
            boolean useShortName = this instanceof ContainerObject && !(this instanceof Table) && !(this instanceof TableView);
            String oldName = useShortName ? this.getName() : this.getLongName();
            String oldShortName = this.name;
            this.name = name;
            String string = newName = useShortName ? this.getName() : this.getLongName();
            if (this instanceof ContainedObject) {
                if (((ContainedObject)this).isNested()) {
                    return true;
                }
                if (this instanceof Column && ((Column)this).getContainer() != null && !"".equals(schema = ((Column)this).getContainer().getSchema())) {
                    oldName = schema + "." + oldName;
                    newName = schema + "." + newName;
                }
            }
            if (newName.equalsIgnoreCase(oldShortName)) {
                return true;
            }
            if (this.isBackup() && !(this instanceof Index)) {
                return true;
            }
            if (!newName.endsWith(name) && !(this instanceof Relation)) {
                this.name = oldShortName;
                return false;
            }
            if (this.containerSet.changeName(oldName, newName, this)) {
                this.oldName = oldShortName;
                this.fireChange(ObjectChangeEvent.NAME_CHANGED);
                return true;
            }
            schema = null;
            if (this instanceof ContainerObject && (co = (ContainerObject)this).getSchemaObject() != null) {
                schema = co.getSchemaObject().getName();
            }
            if ((variant = this.attemptNameVariant(schema, newName)) != null) {
                String newShortName;
                int prefixLength = newName.length() - name.length();
                this.name = newShortName = variant.substring(prefixLength);
                if (this.containerSet.changeName(oldName, variant, this)) {
                    this.oldName = oldShortName;
                    this.fireChange(ObjectChangeEvent.NAME_CHANGED);
                    return true;
                }
                this.name = oldShortName;
                return false;
            }
            this.name = oldShortName;
        }
        return false;
    }

    protected boolean setNameNew(String name) {
        if (this.isWriteable() && !this.isNameFixed()) {
            String variant;
            ContainerObject co;
            String newName;
            if (name != null && name.equals(this.name)) {
                return true;
            }
            String schema = null;
            String longName = this.getLongName();
            boolean useShortName = this instanceof ContainerObject || this instanceof FKIndexAssociation;
            String oldName = useShortName ? this.getName() : this.getLongName();
            String oldShortName = this.name;
            this.name = name;
            int ind = longName.lastIndexOf(oldShortName);
            if (ind > 1) {
                schema = longName.substring(0, ind - 1);
            }
            if ((newName = name).equalsIgnoreCase(oldShortName)) {
                return true;
            }
            if (this.isBackup() && !(this instanceof Index)) {
                return true;
            }
            if (this.containerSet.changeName(schema, oldName, newName, this)) {
                this.oldName = oldShortName;
                this.fireChange(ObjectChangeEvent.NAME_CHANGED);
                return true;
            }
            if (this instanceof ContainerObject && (co = (ContainerObject)this).getSchemaObject() != null) {
                schema = co.getSchemaObject().getName();
            }
            if ((variant = this.attemptNameVariant(schema, newName)) != null) {
                String newShortName;
                int prefixLength = newName.length() - name.length();
                this.name = newShortName = variant.substring(prefixLength);
                if (this.containerSet.changeName(schema, oldName, variant, this)) {
                    this.oldName = oldShortName;
                    this.fireChange(ObjectChangeEvent.NAME_CHANGED);
                    return true;
                }
                this.name = oldShortName;
                return false;
            }
            this.name = oldShortName;
        }
        return false;
    }

    protected String attemptNameVariant(String schema, String name) {
        if (this.getDesignObjectSet() != null && this.getDesignObjectSet().getCreateNameVariants()) {
            NameSpaceController nsc = this.getDesignObjectSet().getNameSpaceController();
            if (nsc != null) {
                return nsc.createNameVariant(schema, name, this);
            }
            String newName = this.getDesignObjectSet().createNameVariant(schema, name);
            return newName;
        }
        return null;
    }

    protected String attemptNameVariant(String name) {
        if (this.getDesignObjectSet() != null && this.getDesignObjectSet().getCreateNameVariants()) {
            NameSpaceController nsc = this.getDesignObjectSet().getNameSpaceController();
            if (nsc != null) {
                return nsc.createNameVariant(null, name, this);
            }
            String newName = this.getDesignObjectSet().createNameVariant(name);
            return newName;
        }
        return null;
    }

    @Override
    public String getName() {
        if ((this.name == null || "".equals(this.name)) && this.containerSet != null) {
            this.name = this.containerSet.createName(this);
        }
        return this.name;
    }

    public String getOldName() {
        if (this.oldName == null) {
            return this.getName();
        }
        return this.oldName;
    }

    public void setOldName(String name) {
        this.oldName = name;
    }

    public static DesignObject[] getDesignObjectPrototypeArray() {
        return PROTOTYPE;
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public String getVeryLongName() {
        return this.getLongName();
    }

    public String getLongNameDDL() {
        if (this.getDesign().getAppView().getSettings().isIncludeSchemaInDDL()) {
            return this.getLongName();
        }
        return this.getName();
    }

    public String getVeryLongNameDDL() {
        if (this.getDesign().getAppView().getSettings().isIncludeSchemaInDDL()) {
            return this.getVeryLongName();
        }
        return this.getLongName();
    }

    @Override
    public String toString() {
        return this.getLongName();
    }

    public List getMeasurements() {
        if (this.measurements == null) {
            this.measurements = new ArrayList();
        }
        return this.measurements;
    }

    public void addMeasurement(Measurement m) {
        if (!this.getMeasurements().contains(m)) {
            this.getMeasurements().add(m);
        }
        if (!this.isBackup()) {
            if (m.getDesignPart() instanceof LogicalDesign) {
                ((LogicalDesign)m.getDesignPart()).getMeasurementSet().add(m);
            } else if (m.getDesignPart() instanceof RelationalDesign) {
                ((RelationalDesign)m.getDesignPart()).getMeasurementSet().add(m);
            } else if (m.getDesignPart() instanceof ProcessModel) {
                ((ProcessModel)m.getDesignPart()).getMeasurementSet().add(m);
            }
            this.getDesign().addDesignObject(m);
        }
    }

    public void removeMeasurement(Measurement m) {
        this.getDesign().removeDesignObject(m);
        if (m.getDesignPart() instanceof LogicalDesign) {
            ((LogicalDesign)m.getDesignPart()).getMeasurementSet().remove(m);
        } else if (m.getDesignPart() instanceof RelationalDesign) {
            ((RelationalDesign)m.getDesignPart()).getMeasurementSet().remove(m);
        } else if (m.getDesignPart() instanceof ProcessModel) {
            ((ProcessModel)m.getDesignPart()).getMeasurementSet().remove(m);
        }
        this.getMeasurements().remove(m);
    }

    public Measurement createMeasurement() {
        Measurement m = new Measurement(this.getDesignPart());
        m.setObject(this);
        this.addMeasurement(m);
        return m;
    }

    public Measurement getMeasurementByID(String id) {
        for (Measurement m : this.getMeasurements()) {
            if (!m.getObjectID().equals(id)) continue;
            return m;
        }
        return null;
    }

    public List getRequests() {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        return this.requests;
    }

    public void addRequest(ChangeRequest request) {
        request.setObject(this);
        if (!this.getRequests().contains(request)) {
            this.getRequests().add(request);
        }
    }

    public void removeRequest(ChangeRequest request) {
        this.getRequests().remove(request);
    }

    public ChangeRequest getRequestByID(String id) {
        for (DesignObject dobj : this.getRequests()) {
            if (!dobj.getObjectID().equals(id)) continue;
            return (ChangeRequest)dobj;
        }
        return null;
    }

    public void clearRequests() {
        for (int i = 0; i < this.getRequests().size(); ++i) {
            ChangeRequest request = (ChangeRequest)this.getRequests().get(i);
            request.removeObject(this);
        }
        this.getRequests().clear();
    }

    public List getDocuments() {
        if (this.documents == null) {
            this.documents = new ArrayList();
        }
        return this.documents;
    }

    public void addDocument(BIDocument document) {
        if (!this.getDocuments().contains(document)) {
            this.getDocuments().add(document);
            document.addElement(this);
        }
    }

    public void removeDocument(BIDocument document) {
        this.getDocuments().remove(document);
        document.removeElement(this);
    }

    public BIDocument getDocumentByID(String id) {
        for (DesignObject dobj : this.getDocuments()) {
            if (!dobj.getObjectID().equals(id)) continue;
            return (BIDocument)dobj;
        }
        return null;
    }

    public void clearDocuments() {
        for (int i = 0; i < this.getDocuments().size(); ++i) {
            BIDocument doc = (BIDocument)this.getDocuments().get(i);
            doc.removeElement(this);
        }
        this.getDocuments().clear();
    }

    public List getResponsibleParties() {
        if (this.responsibleParties == null) {
            this.responsibleParties = new ArrayList();
        }
        return this.responsibleParties;
    }

    public void addResponsibleParty(BIResponsibleParty party) {
        if (!this.getResponsibleParties().contains(party)) {
            this.getResponsibleParties().add(party);
            party.addElement(this);
        }
    }

    public void removeResponsibleParty(BIResponsibleParty party) {
        this.getResponsibleParties().remove(party);
        party.removeElement(this);
    }

    public void clearResponsibleParties() {
        for (int i = 0; i < this.getResponsibleParties().size(); ++i) {
            BIResponsibleParty party = (BIResponsibleParty)this.getResponsibleParties().get(i);
            party.removeElement(this);
        }
        this.getResponsibleParties().clear();
    }

    public BIResponsibleParty getPartyByID(String id) {
        for (DesignObject dobj : this.getResponsibleParties()) {
            if (!dobj.getObjectID().equals(id)) continue;
            return (BIResponsibleParty)dobj;
        }
        return null;
    }

    @Override
    public abstract String getObjectTypeName();

    public abstract boolean isDesignLevelAccessibleObject();

    @Override
    public void remove() {
        if (!this.getIsBeingRemoved()) {
            this.setIsBeingRemoved(true);
            if (this.getDesignObjectSet() != null) {
                this.getDesignObjectSet().remove(this);
            }
            ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
            Object saveAffected = event.getAffected();
            event.setAffected(this);
            this.fireChange(event);
            event.setAffected(saveAffected);
            this.setIsBeingRemoved(false);
            this.removed = true;
            RepositoryObject pac = this.getPAC_Element();
            if (pac != null) {
                pac.setDirty(true);
            }
            this.closePropertiesDialog();
        }
    }

    public void removeViewSynonim(TopView tv) {
    }

    protected void setIsBeingRemoved(boolean value) {
        this.isBeingRemoved = value;
    }

    public boolean getIsBeingRemoved() {
        return this.isBeingRemoved;
    }

    public void addObjectListener(ObjectListener listener) {
        if (!this.getListeners().contains(listener)) {
            this.getListeners().add(listener);
        }
    }

    public void removeObjectListener(ObjectListener listener) {
        this.getListeners().remove(listener);
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
        if (this.getDesignPart() != null && this.getDesignPart().isLoaded() && !this.getDesign().isLoading()) {
            this.setDirty(true);
            this.getDesignPart().setObjectListChanged(true);
            this.getChange().setTimeNow();
        }
        ObjectListener[] listeners = this.getListeners().toArray(new ObjectListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            try {
                if (listeners[i] == null) continue;
                listeners[i].changed(this, event);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Listener caused exception: ", e);
            }
        }
    }

    protected void fireChangeNoDirty(ObjectChangeEvent event) {
        Object saveAffected = event.getAffected();
        event.setAffected(this);
        Object[] array = this.getListeners().toArray();
        for (int i = 0; i < array.length; ++i) {
            ObjectListener listener = (ObjectListener)array[i];
            listener.changed(this, event);
        }
        event.setAffected(saveAffected);
    }

    public void fireNameChangedNoDirty() {
        this.fireChangeNoDirty(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getGeneratorLongName() {
        DesignObject generator = this.getDesign().getDesignObject(this.getGeneratorID());
        if (generator != null) {
            return ((ModelObject)generator).getLongName();
        }
        return "None";
    }

    public boolean isContainedObject() {
        return false;
    }

    public void setTopView(TopView view) {
        this.topView = view;
    }

    public TopView getTopView() {
        return this.getFirstViewForDPV(this.getDesignPart().getMainView());
    }

    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return this.topView;
    }

    public TopView getFirstViewWithoutPresentation(DesignPartView dpv) {
        for (TopView tv : this.getViewsForDPV(dpv)) {
            if (tv.getCellView() != null && tv.getCellView().getCell() != null) continue;
            return tv;
        }
        return null;
    }

    public int getViewNumber(TopView tv) {
        return 0;
    }

    public int getViewsCountForDPV(DesignPartView dpv) {
        return 0;
    }

    public void resetViewNumbers() {
        TopView tv = this.getTopView();
        if (tv != null) {
            tv.setViewNumber(this.getViewNumber(tv));
        }
    }

    public int getTopViewsCount() {
        return 1;
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public void setDesignPart(DesignPart designPart) {
        this.designPart = designPart;
    }

    public String getDesignPartId() {
        return this.getDesignPart().getObjectID();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean hasAliveGenerator() {
        return true;
    }

    public boolean shouldBeEngineered() {
        if (this.getShouldEngineer()) {
            if (this.getDesign().isEngineerGenerated()) {
                return true;
            }
            if ("User generated".equalsIgnoreCase(this.getGeneratorID())) {
                return true;
            }
        }
        return false;
    }

    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        return false;
    }

    public boolean hasGUIView() {
        return true;
    }

    public Design getImportedDesign() {
        return this.importedDesign;
    }

    public void setImportedDesign(Design importedDesign) {
        if (this.importedDesign != importedDesign) {
            this.importedDesign = importedDesign;
        }
    }

    public String getImportedId() {
        return this.importedId;
    }

    public void setImportedId(String importedId) {
        if (importedId != null && importedId.equals(this.importedId)) {
            return;
        }
        this.importedId = importedId;
    }

    protected void copyFormatOptions(DesignObject desObject) {
        if (this.useDefaultColor()) {
            desObject.setUseDefaultColor(true);
        } else {
            desObject.setUseDefaultColor(false);
            desObject.setBackgroundColor(this.getBackgroundColor());
            desObject.setForegroundColor(this.getForegroundColor());
            desObject.setNoBackgroundColor(this.getNoBackgroundColor());
            desObject.setNoForegroundColor(this.getNoForegroundColor());
            desObject.setLineWidth(this.getLineWidth());
        }
    }

    public void copy(DesignObject desObject) {
        this.copyDefaults(desObject);
        DesignObject.copySourceStamp(this, desObject);
        desObject.setGeneratorID(this.getGeneratorID());
    }

    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) {
        this.copy(desObject);
    }

    public void copyDefaults(DesignObject desObject) {
        int i;
        desObject.setName(this.getName());
        desObject.setNameHasQuotes(this.getNameHasQuotes());
        desObject.setMarkedGenerate(this.isMarkedGenerate());
        desObject.setComment(this.getComment());
        desObject.setCommentInRDBMS(this.getCommentInRDBMS());
        desObject.setNotes(this.getNotes());
        desObject.setShouldEngineer(this.getShouldEngineer());
        desObject.setDeprecated(this.isDeprecated());
        desObject.setUseDDLTransformationScript(this.isUseDDLTransformationScript());
        desObject.getMeasurements().clear();
        desObject.clearRequests();
        desObject.getResponsibleParties().clear();
        desObject.getDocuments().clear();
        for (i = 0; i < this.getMeasurements().size(); ++i) {
            desObject.addMeasurement((Measurement)this.getMeasurements().get(i));
        }
        for (i = 0; i < this.getRequests().size(); ++i) {
            desObject.addRequest((ChangeRequest)this.getRequests().get(i));
        }
        for (i = 0; i < this.getResponsibleParties().size(); ++i) {
            desObject.addResponsibleParty((BIResponsibleParty)this.getResponsibleParties().get(i));
        }
        for (i = 0; i < this.getDocuments().size(); ++i) {
            desObject.addDocument((BIDocument)this.getDocuments().get(i));
        }
        this.copyDynamicProperties(desObject);
        this.copyFormatOptions(desObject);
    }

    private static void copySourceStamp(ModelObject source, ModelObject target) {
        if (source != null && target != null) {
            if (!"".equals(source.getSourceConnName()) && "".equals(target.getSourceConnName())) {
                if (target instanceof DesignObject && ((DesignObject)target).isBackup()) {
                    target.setSourceConnName(source.getSourceConnName());
                    target.setSourceObjName(source.getSourceObjName());
                    target.setSourceObjSchema(source.getSourceObjSchema());
                } else if (DesignObject.validTargetStamp(source, target)) {
                    DesignObject.setTargetDesignStamp(source, target);
                    target.setSourceConnName(source.getSourceConnName());
                    target.setSourceObjName(source.getSourceObjName());
                    target.setSourceObjSchema(source.getSourceObjSchema());
                }
            }
            if (!"".equals(source.getSourceDDLFile()) && "".equals(target.getSourceDDLFile())) {
                target.setSourceDDLFile(source.getSourceDDLFile());
            }
        }
    }

    private static boolean validTargetStamp(ModelObject source, ModelObject target) {
        if (source instanceof DesignObject && target instanceof DesignObject ? ((DesignObject)source).getDesignPart().equals(((DesignObject)target).getDesignPart()) : source instanceof StorageObject && target instanceof StorageObject && ((StorageObject)source).getStorageDesign().getPhysicalDesign().equals(((StorageObject)target).getStorageDesign().getPhysicalDesign())) {
            return false;
        }
        Class<?> srcClass = source.getClass();
        String srcIndexState = "";
        if (source instanceof Index) {
            srcIndexState = ((Index)source).getIndexState();
        }
        String srcConnName = source.getSourceConnName();
        String srcObjName = source.getSourceObjName();
        String srcObjSchema = source.getSourceObjSchema();
        RelationalDesign tgtDes = null;
        if (target instanceof DesignObject) {
            tgtDes = (RelationalDesign)((DesignObject)target).getDesignPart();
        } else if (target instanceof StorageObject) {
            tgtDes = ((StorageObject)target).getStorageDesign().getPhysicalDesign();
        }
        List tgtObjs = tgtDes.getAllImportedObjects();
        for (int i = 0; i < tgtObjs.size(); ++i) {
            ModelObject tgtObj = (ModelObject)tgtObjs.get(i);
            if (!(source instanceof Index && tgtObj instanceof Index ? ((Index)tgtObj).getIndexState().equalsIgnoreCase(srcIndexState) && tgtObj.getSourceConnName().equalsIgnoreCase(srcConnName) && tgtObj.getSourceObjName().equalsIgnoreCase(srcObjName) && tgtObj.getSourceObjSchema().equalsIgnoreCase(srcObjSchema) : tgtObj.getClass().equals(srcClass) && tgtObj.getSourceConnName().equalsIgnoreCase(srcConnName) && tgtObj.getSourceObjName().equalsIgnoreCase(srcObjName) && tgtObj.getSourceObjSchema().equalsIgnoreCase(srcObjSchema))) continue;
            return false;
        }
        return true;
    }

    private static void setTargetDesignStamp(ModelObject source, ModelObject target) {
        String srcConnName = source.getSourceConnName();
        RelationalDesign srcDes = null;
        RelationalDesign tgtDes = null;
        if (source instanceof DesignObject && target instanceof DesignObject) {
            srcDes = (RelationalDesign)((DesignObject)source).getDesignPart();
            tgtDes = (RelationalDesign)((DesignObject)target).getDesignPart();
        } else if (source instanceof StorageObject && target instanceof StorageObject) {
            srcDes = ((StorageObject)source).getStorageDesign().getPhysicalDesign();
            tgtDes = ((StorageObject)target).getStorageDesign().getPhysicalDesign();
        }
        DBConnectionStamp stamp = srcDes.getImportConnectionStamp(srcDes.findImportConnectionStamp(srcConnName));
        if (stamp != null) {
            tgtDes.addImportConnectionStamp(stamp);
        }
    }

    private void applyChangesInDefaultsTo(DesignObject desObject) {
        this.copyDefaults(desObject);
    }

    public void applyChangesTo(DesignObject anotherState) {
        this.applyChangesInDefaultsTo(anotherState);
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canPaste() {
        return false;
    }

    public void paste() {
    }

    public float getLoadedVersion() {
        return this.loadedVersion;
    }

    public void setLoadedVersion(float loadedVersion) {
        this.loadedVersion = loadedVersion;
    }

    public void clearEngineerTo() {
        this.engineerTo.clear();
    }

    public Map getEngineerTo() {
        if (this.getDesignPart() instanceof LogicalDesign && !(this instanceof Domain)) {
            Object[] keys = this.engineerTo.keySet().toArray();
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (this.getDesign().getRelationalDesigns().getById((String)key) != null) continue;
                this.engineerTo.remove(key);
            }
            for (RelationalDesign pd : this.getDesign().getRelationalDesigns()) {
                if (this.engineerTo.containsKey(pd.getObjectID())) continue;
                this.setEngineerTo(pd.getObjectID(), true);
            }
        } else {
            this.engineerTo.clear();
        }
        return this.engineerTo;
    }

    public void setEngineerTo(String rdID, boolean engineer) {
        this.engineerTo.put(rdID, engineer);
    }

    public boolean getEngineerTo(String rdID) {
        Object value = this.engineerTo.get(rdID);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return "true".equalsIgnoreCase((String)value);
            }
        }
        return true;
    }

    public boolean getShouldEngineer(String rdID) {
        return this.getEngineerTo(rdID);
    }

    @Override
    public void setShouldEngineer(boolean value, boolean setDirty) {
        if (this.getDesignPart() instanceof LogicalDesign && !(this instanceof Domain)) {
            boolean oldvalue = true;
            String phDesID = this.getDesign().getRelationalDesign().getObjectID();
            Object val = this.getEngineerTo().get(phDesID);
            if (val != null) {
                oldvalue = "true".equals(val.toString());
            }
            if (oldvalue != value) {
                this.getEngineerTo().put(phDesID, value);
                if (setDirty) {
                    this.setDirty(true);
                }
            }
        } else {
            super.setShouldEngineer(value, setDirty);
        }
    }

    @Override
    public boolean getShouldEngineer() {
        if (this.getDesignPart() instanceof LogicalDesign && !(this instanceof Domain)) {
            String phDesID = this.getDesign().getRelationalDesign().getObjectID();
            Object val = this.getEngineerTo().get(phDesID);
            if (val != null) {
                return "true".equals(val.toString());
            }
            return true;
        }
        return super.getShouldEngineer();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public TopViewCollection getViewsForDPV(DesignPartView dpv) {
        TopViewCollection tvc = new TopViewCollection();
        tvc.setDPV(dpv);
        return tvc;
    }

    public TopView getTopViewByID(DesignPartView dpv, String id, int viewnumber) {
        TopViewCollection tvc = this.getViewsForDPV(dpv);
        for (TopView tv : tvc) {
            if (!tv.getViewID().equals(id)) continue;
            return tv;
        }
        int i = 0;
        for (TopView tv : tvc) {
            if (viewnumber == i) {
                tv.setViewNumber(viewnumber);
                return tv;
            }
            ++i;
        }
        return null;
    }

    public TopView getTopViewByID(DesignPartView dpv, String id) {
        int pos;
        int i = 0;
        if (this.getDesign().getLoadedVersion() < 2.4f && (pos = id.indexOf(35)) > -1 && pos < id.length() - 1) {
            String vn = id.substring(pos + 1);
            try {
                i = Integer.parseInt(vn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getTopViewByID(dpv, id, i);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public boolean useDefaultColor() {
        return this.useDefaultColor;
    }

    public void setUseDefaultColor(boolean useDefaultColor) {
        this.useDefaultColor = useDefaultColor;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public boolean canBedeleted() {
        if (this.getDesign().isRepositoryRelated()) {
            return this.getDesignPart().isCheckedOutByMe();
        }
        return true;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public List getFontObjectWrappers() {
        return Collections.EMPTY_LIST;
    }

    public FontObjectWr createFontObjectWr() {
        return new FontObjectWr();
    }

    public void addFontObjectWrapper(FontObjectWr foWr) {
        if (this instanceof EditableFonts) {
            TopView tv = this.getTopView();
            boolean fontEnabled = true;
            if (tv != null) {
                List fonts = tv.getEditableFonts();
                String type = foWr.getFoType();
                if (type != null) {
                    FontObject fo = tv.getFontObject(type);
                    if (fo != null) {
                        fontEnabled = fo.isFontEnabled();
                        fonts.remove(fo);
                    }
                    fo = new FontObject(type, new Font(foWr.getFontName(), foWr.getFontStyle(), foWr.getFontSize()), new Color(foWr.getColor_RGB(), true), fontEnabled);
                    fonts.add(fo);
                }
            }
        }
    }

    @Override
    public String getDirectorySegmentName() {
        if ("".equals(this.directorySegmentName)) {
            this.directorySegmentName = this.getDesignObjectSet().getSegmentName(this);
        }
        return this.directorySegmentName;
    }

    @Override
    public String getSegmentedStorageName() {
        if (this.segmentedStorageName == null) {
            String sname = this.getDirectorySegmentName();
            if (!"".equals(sname)) {
                String sn = this.getStorageName();
                if (sn != null && !"".equals(sn)) {
                    File file = new File(sn);
                    String fname = file.getName();
                    this.segmentedStorageName = file.getParent() + File.separatorChar + sname + File.separatorChar + fname;
                }
            } else {
                return super.getSegmentedStorageName();
            }
        }
        return this.segmentedStorageName;
    }

    @Override
    public void setDirectorySegmentName(String directorySegmentName, boolean clear) {
        if (directorySegmentName != null && !"".equals(directorySegmentName)) {
            this.getDesignObjectSet().addSegmentEntry(directorySegmentName, this.getObjectID(), clear);
        }
        this.directorySegmentName = directorySegmentName;
        this.segmentedStorageName = null;
    }

    @Override
    public void setDirectorySegmentName(String directorySegmentName) {
        this.setDirectorySegmentName(directorySegmentName, true);
    }

    public String getSchema() {
        return "";
    }

    public boolean hasProxyToDelete() {
        return false;
    }

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        return this.getDesignPart().getSelectedRDBMSSite();
    }

    @Override
    public ElementSet getSet() {
        return this.getDesignObjectSet();
    }

    public Collection getAffectedDPVs() {
        return Collections.EMPTY_SET;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public void clearAll() {
    }

    public DesignObject getTempObject() {
        return null;
    }

    @Override
    public void remoteObjectChanged(DesignObject remoteObject) {
        this.updateFromRemoteObject(false);
    }

    public void updateFromRemoteObject(boolean addListener) {
        if (this.isRemoteObject()) {
            boolean oldDirty = this.isDirty();
            int strat = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
            this.getDesign().getAppView().getSettings().setDeleteFKColumnStrategy(0);
            Design rdes = this.getDesign().getDesignByID(this.getRemoteDesignID());
            DesignObject desObj = null;
            if (rdes != null) {
                desObj = rdes.getDesignObject(this.getRemoteObjectID());
            }
            if (desObj != null) {
                String oldstatus = "";
                try {
                    oldstatus = ApplicationView.getInstance().getXMLTransformationManager().getFilteredXMLString(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    desObj.copy(this, null, true);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (!desObj.isUsedAsRemoteObject()) {
                    desObj.setUsedAsRemoteObject(true);
                    if (!desObj.isDirty()) {
                        desObj.setDirty(true);
                    }
                }
                String newstatus = "";
                try {
                    newstatus = ApplicationView.getInstance().getXMLTransformationManager().getFilteredXMLString(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!"".equals(oldstatus) && !oldstatus.equals(newstatus)) {
                    this.setDirty(true);
                } else {
                    this.setDirty(oldDirty);
                }
                if (addListener) {
                    desObj.addRemoteObjectListener(this);
                }
            } else {
                String remStor = this.getRemoteObjectStorageName();
                if (!"".equalsIgnoreCase(remStor)) {
                    File file = new File(remStor);
                    if (file.exists()) {
                        DesignObject temp = this.getTempObject();
                        if (temp != null) {
                            String oldstatus = "";
                            try {
                                oldstatus = ApplicationView.getInstance().getXMLTransformationManager().getFilteredXMLString(this);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.getAppView().getXMLTransformationManager().transformFromXMLToObject(temp, new File(this.getRemoteObjectStorageName()), this.getDesign().isCompressedDesign(), true, Arrays.asList(excludeProps));
                            HashMap<String, DesignObject> copiedMap = new HashMap<String, DesignObject>();
                            copiedMap.put(temp.getObjectID(), this);
                            temp.copy(this, copiedMap, true);
                            temp = null;
                            String newstatus = "";
                            try {
                                newstatus = ApplicationView.getInstance().getXMLTransformationManager().getFilteredXMLString(this);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!"".equals(oldstatus) && !oldstatus.equals(newstatus)) {
                                this.setDirty(true);
                            } else {
                                this.setDirty(oldDirty);
                            }
                        }
                    } else {
                        LOGGER.error("DesignObject.updateFromRemoteObject -file for remote object doesn't exist:\n Remote:" + remStor + "\n Local:" + this.getSegmentedStorageName());
                    }
                }
            }
            this.getDesign().getAppView().getSettings().setDeleteFKColumnStrategy(strat);
        }
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    @Override
    public String getModelID() {
        return this.getDesignPart().getObjectID();
    }

    @Override
    public void setObjectID(String id) {
        String old = this.id;
        super.setObjectID(id);
        if (old != null && !old.equals(id)) {
            this.fireChange(ObjectChangeEvent.OBJECT_ID_CHANED);
        }
    }

    public void addRemoteObjectListener(DesignObject listener) {
        this.remoteObjectListeners.add(listener);
    }

    public void removeRemoteObjectListener(DesignObject listener) {
        this.remoteObjectListeners.remove(listener);
    }

    public void updateRemoteObjectListeners() {
        Object[] array = this.remoteObjectListeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            try {
                ((RemoteObjectListener)array[i]).remoteObjectChanged(this);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("RemoteObjectListener caused exception", e);
            }
        }
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isCopyForIncrementalDDL() {
        return this.copyForIncrementalDDL;
    }

    public void setCopyForIncrementalDDL(boolean copyForIncrementalDDL) {
        this.copyForIncrementalDDL = copyForIncrementalDDL;
    }

    public boolean isUseDDLTransformationScript() {
        return this.useDDLTransformationScript;
    }

    public void setUseDDLTransformationScript(boolean useDDLTransformationScript) {
        this.useDDLTransformationScript = useDDLTransformationScript;
    }

    public boolean isORDSDropSchema() {
        return this.ordsDropSchema;
    }

    public void setORDSDropSchema(boolean ordsDropSchema) {
        this.ordsDropSchema = ordsDropSchema;
    }

    public String getORDSAlias() {
        return this.ordsAlias;
    }

    public String getORDSAliasNotEmpty() {
        if (StringUtilities.isEmpty(this.ordsAlias)) {
            return this.getName().toLowerCase();
        }
        return this.ordsAlias;
    }

    public void setORDSAlias(String ordsAlias) {
        this.ordsAlias = !ordsAlias.equalsIgnoreCase(this.getName()) ? ordsAlias : "";
    }

    public boolean isORDSEnable() {
        return this.ordsEnable;
    }

    public void setORDSEnable(boolean ordsEnable) {
        this.ordsEnable = ordsEnable;
    }

    public boolean isORDSAuth() {
        return this.ordsAuth;
    }

    public void setORDSAuth(boolean ordsAuth) {
        this.ordsAuth = ordsAuth;
    }

    public boolean getNoBackgroundColor() {
        return this.noBackgroundColor;
    }

    public void setNoBackgroundColor(boolean noBackgroundColor) {
        this.noBackgroundColor = noBackgroundColor;
    }

    public boolean getNoForegroundColor() {
        return this.noForegroundColor;
    }

    public void setNoForegroundColor(boolean noForegroundColor) {
        this.noForegroundColor = noForegroundColor;
    }

    static {
        excludeProps = new String[]{"id", "objectID", "remoteObjectID", "remoteModelID", "remoteObjectStorageName"};
        LOGGER = new Logger(DesignObject.class);
        PROTOTYPE = new DesignObject[0];
    }
}

