/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;

public class Measurement
extends DesignObject {
    public static final String OBJECT_TYPE = "Measurement";
    private String value = "";
    private String unit = "";
    private String type = "";
    private String creationDate = "";
    private String effectiveDate = "";
    private DesignObject object;
    public static final String[] TYPE_STATES_DISPLAY = new String[]{Messages.getString("Measurement.Measure"), Messages.getString("Measurement.Estimate"), Messages.getString("Measurement.Plan"), Messages.getString("Measurement.Minimum"), Messages.getString("Measurement.Maximum"), Messages.getString("Measurement.Average")};
    public static final String[] TYPE_STATES_INTERNAL = new String[]{"Measure", "Estimate", "Plan", "Minimum", "Maximum", "Average"};
    private static Set typeSet = null;

    public Measurement(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return OBJECT_TYPE;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        if (creationDate != null && creationDate.equals(this.creationDate)) {
            return;
        }
        this.creationDate = creationDate;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        if (effectiveDate != null && effectiveDate.equals(this.effectiveDate)) {
            return;
        }
        this.effectiveDate = effectiveDate;
    }

    public DesignObject getObject() {
        return this.object;
    }

    public void setObject(DesignObject object) {
        if (this.object != object) {
            this.object = object;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null && type.equals(this.type)) {
            return;
        }
        if (this.checkType(type)) {
            this.type = type;
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        if (unit != null && unit.equals(this.unit)) {
            return;
        }
        this.unit = unit;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (this.value != value) {
            this.value = value;
        }
    }

    private boolean checkType(String value) {
        if (typeSet == null) {
            typeSet = new HashSet();
            typeSet.addAll(Arrays.asList(TYPE_STATES_INTERNAL));
        }
        return typeSet.contains(value);
    }

    public String getObjectLongName() {
        if (this.object != null) {
            return this.object.getLongName();
        }
        return "";
    }
}

