/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.EmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.db2.TriggerDB2Comparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.BitmapJoinIndexComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ContextComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.DataFileComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.DimensionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.DirectoryComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.DiskGroupComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.FunctionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.HashPartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.HashSubpartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.HashSubpartitionTemplateComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.HierarchyComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.IndexGlobalPartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.IndexHashPartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.LevelComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ListPartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ListSubpartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ListSubpartitionTemplateComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.LobStorageComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.MViewLogComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.PackageComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.PermissionsComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.QuotaItemComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.RangePartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.RangeSubpartitionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.RangeSubpartitionTemplateComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.RoleComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StoredProcedureComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SynonymComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TablespaceComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TemporaryTablespaceComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TriggerOracleComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.UndoTablespaceComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.UserComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.sqlserver.TriggerSqlServerComparator;
import oracle.dbtools.crest.model.design.compare.storage.udb.TriggerUDBComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ContextOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DiskGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.compare.StringComparator;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class StoragePropertiesComparator
extends PropertiesComparator {
    private static final Logger LOGGER = new Logger(StoragePropertiesComparator.class);
    static StringComparator StringComparator = new StringComparator();
    private static final int USAGE_PARTITION = 1;
    private static final int USAGE_SUBPARTITION = 2;
    private static final int USAGE_SUBPARTITION_TEMPLATE = 3;
    private StorageObject left_so;
    private StorageObject right_so;
    protected ClassDescription classDescr;

    public StoragePropertiesComparator(StorageObject left_so, StorageObject right_so) {
        super(left_so, right_so);
        Map physComparatorsMap;
        MetaDataManager mdManager;
        StorageObject leftOrRight_so;
        this.left_so = left_so;
        this.right_so = right_so;
        StorageObject storageObject = leftOrRight_so = left_so != null ? left_so : right_so;
        if (leftOrRight_so != null && (mdManager = leftOrRight_so.getAppView().getXMLTransformationManager().getMetaDataManager()) != null) {
            this.classDescr = mdManager.getClassDescription(leftOrRight_so.getClass().getName());
        }
        if (right_so != null && (physComparatorsMap = CompareModelToModel.getCurrentPhysComparatorsMap()) != null) {
            physComparatorsMap.put(right_so.getObjectID(), this);
        }
    }

    public static PropertiesComparator getNewInstance(ModelIDObject leftObj, ModelIDObject rightObj) {
        PropertiesComparator newPropsComparator = null;
        if (leftObj != null && rightObj != null && leftObj.getClass() != rightObj.getClass()) {
            newPropsComparator = new EmptyPropertiesComparator(leftObj, rightObj);
        } else {
            ModelIDObject obj;
            ModelIDObject modelIDObject = obj = leftObj != null ? leftObj : rightObj;
            if (obj instanceof Trigger) {
                if (obj instanceof TriggerOracle) {
                    newPropsComparator = new TriggerOracleComparator((TriggerOracle)leftObj, (TriggerOracle)rightObj);
                } else if (obj instanceof TriggerSqlServer) {
                    newPropsComparator = new TriggerSqlServerComparator((TriggerSqlServer)leftObj, (TriggerSqlServer)rightObj);
                } else if (obj instanceof TriggerDB2) {
                    newPropsComparator = new TriggerDB2Comparator((TriggerDB2)leftObj, (TriggerDB2)rightObj);
                } else if (obj instanceof TriggerUDB) {
                    newPropsComparator = new TriggerUDBComparator((TriggerUDB)leftObj, (TriggerUDB)rightObj);
                }
            } else if (obj instanceof AbstractStorageObjectOracle) {
                if (obj instanceof MaterializedViewLogOracle) {
                    newPropsComparator = new MViewLogComparator((MaterializedViewLogOracle)leftObj, (MaterializedViewLogOracle)rightObj);
                } else if (obj instanceof UserOracle) {
                    newPropsComparator = new UserComparatorOracle((UserOracle)leftObj, (UserOracle)rightObj);
                } else if (obj instanceof RoleOracle) {
                    newPropsComparator = new RoleComparatorOracle((RoleOracle)leftObj, (RoleOracle)rightObj);
                } else if (obj instanceof PermissionsOracle) {
                    newPropsComparator = new PermissionsComparatorOracle((PermissionsOracle)leftObj, (PermissionsOracle)rightObj);
                } else if (obj instanceof FunctionOracle) {
                    newPropsComparator = new FunctionComparatorOracle((FunctionOracle)leftObj, (FunctionOracle)rightObj);
                } else if (obj instanceof StoredProcedureOracle) {
                    newPropsComparator = new StoredProcedureComparatorOracle((StoredProcedureOracle)leftObj, (StoredProcedureOracle)rightObj);
                } else if (obj instanceof PackageOracle) {
                    newPropsComparator = new PackageComparatorOracle((PackageOracle)leftObj, (PackageOracle)rightObj);
                } else if (obj instanceof SynonymOracle) {
                    newPropsComparator = new SynonymComparatorOracle((SynonymOracle)leftObj, (SynonymOracle)rightObj);
                } else if (obj instanceof LobStorageOracle) {
                    newPropsComparator = new LobStorageComparatorOracle((LobStorageOracle)leftObj, (LobStorageOracle)rightObj);
                } else if (obj instanceof TableSpaceOracle) {
                    newPropsComparator = new TablespaceComparatorOracle((TableSpaceOracle)leftObj, (TableSpaceOracle)rightObj);
                } else if (obj instanceof TemporaryTablespaceOracle) {
                    newPropsComparator = new TemporaryTablespaceComparatorOracle((TemporaryTablespaceOracle)leftObj, (TemporaryTablespaceOracle)rightObj);
                } else if (obj instanceof UndoTablespaceOracle) {
                    newPropsComparator = new UndoTablespaceComparatorOracle((UndoTablespaceOracle)leftObj, (UndoTablespaceOracle)rightObj);
                } else if (obj instanceof DataFileOracle) {
                    newPropsComparator = new DataFileComparatorOracle((DataFileOracle)leftObj, (DataFileOracle)rightObj);
                } else if (obj instanceof PartitionOracle) {
                    int partitionUsage = StoragePropertiesComparator.getPartitionUsage(obj, ((PartitionOracle)obj).getPartitionList());
                    if (partitionUsage == 1) {
                        newPropsComparator = new RangePartitionComparatorOracle((PartitionOracle)leftObj, (PartitionOracle)rightObj);
                    } else if (partitionUsage == 2) {
                        newPropsComparator = new RangeSubpartitionComparatorOracle((PartitionOracle)leftObj, (PartitionOracle)rightObj);
                    } else if (partitionUsage == 3) {
                        newPropsComparator = new RangeSubpartitionTemplateComparatorOracle((PartitionOracle)leftObj, (PartitionOracle)rightObj);
                    }
                } else if (obj instanceof HashPartitionOracle) {
                    HashPartitionOracle hashPartition = (HashPartitionOracle)obj;
                    newPropsComparator = hashPartition.getSubPartitionOf() != null ? new HashSubpartitionComparatorOracle((HashPartitionOracle)leftObj, (HashPartitionOracle)rightObj) : (hashPartition.getPartOfStorageTable() != null ? new HashSubpartitionTemplateComparatorOracle((HashPartitionOracle)leftObj, (HashPartitionOracle)rightObj) : new HashPartitionComparatorOracle((HashPartitionOracle)leftObj, (HashPartitionOracle)rightObj));
                } else if (obj instanceof ListPartitionOracle) {
                    newPropsComparator = new ListPartitionComparatorOracle((ListPartitionOracle)leftObj, (ListPartitionOracle)rightObj);
                } else if (obj instanceof ListStorageTemplatePartitionOracle) {
                    ListStorageTemplatePartitionOracle listSubpartition = (ListStorageTemplatePartitionOracle)obj;
                    newPropsComparator = listSubpartition.getSubPartitionOf() != null ? new ListSubpartitionComparatorOracle((ListStorageTemplatePartitionOracle)leftObj, (ListStorageTemplatePartitionOracle)rightObj) : new ListSubpartitionTemplateComparatorOracle((ListStorageTemplatePartitionOracle)leftObj, (ListStorageTemplatePartitionOracle)rightObj);
                } else if (obj instanceof IndexGlobalPartitionOracle) {
                    newPropsComparator = new IndexGlobalPartitionComparatorOracle((IndexGlobalPartitionOracle)leftObj, (IndexGlobalPartitionOracle)rightObj);
                } else if (obj instanceof IndexHashPartitionOracle) {
                    newPropsComparator = new IndexHashPartitionComparatorOracle((IndexHashPartitionOracle)leftObj, (IndexHashPartitionOracle)rightObj);
                } else if (obj instanceof BitmapJoinIndexOracle) {
                    newPropsComparator = new BitmapJoinIndexComparatorOracle((BitmapJoinIndexOracle)leftObj, (BitmapJoinIndexOracle)rightObj);
                } else if (obj instanceof ContextOracle) {
                    newPropsComparator = new ContextComparatorOracle((ContextOracle)leftObj, (ContextOracle)rightObj);
                } else if (obj instanceof DirectoryOracle) {
                    newPropsComparator = new DirectoryComparatorOracle((DirectoryOracle)leftObj, (DirectoryOracle)rightObj);
                } else if (obj instanceof DimensionOracle) {
                    newPropsComparator = new DimensionComparatorOracle((DimensionOracle)leftObj, (DimensionOracle)rightObj);
                } else if (obj instanceof LevelOracle) {
                    newPropsComparator = new LevelComparatorOracle((LevelOracle)leftObj, (LevelOracle)rightObj);
                } else if (obj instanceof HierarchyOracle) {
                    newPropsComparator = new HierarchyComparatorOracle((HierarchyOracle)leftObj, (HierarchyOracle)rightObj);
                } else if (obj instanceof QuotaItemOracle) {
                    newPropsComparator = new QuotaItemComparatorOracle((QuotaItemOracle)leftObj, (QuotaItemOracle)rightObj);
                } else if (obj instanceof DiskGroupOraclev10g) {
                    newPropsComparator = new DiskGroupComparatorOracle((DiskGroupOraclev10g)leftObj, (DiskGroupOraclev10g)rightObj);
                }
            }
        }
        return newPropsComparator;
    }

    private static int getPartitionUsage(ModelIDObject partitionObject, PartitionListOracle partitionList) {
        if (partitionList != null) {
            StorageObjectCollection ownerPartitions = null;
            StorageObjectCollection ownerSubpartTemplates = null;
            TableProxyOracle tableProxy = partitionList.getTable();
            if (tableProxy != null) {
                ownerPartitions = tableProxy.getPartitions();
                ownerSubpartTemplates = tableProxy.getListStorageTemplates();
            } else if (partitionList.getSnapshot() != null) {
                ownerPartitions = partitionList.getSnapshot().getPartitionsCollection();
            }
            if (ownerPartitions != null && ownerPartitions.contains(partitionObject)) {
                return 1;
            }
            if (ownerSubpartTemplates != null && ownerSubpartTemplates.contains(partitionObject)) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    @Override
    public String getLeftName() {
        if (this.left_so != null) {
            return this.left_so.getName();
        }
        return "";
    }

    @Override
    public String getRightName() {
        if (this.right_so != null) {
            return this.right_so.getName();
        }
        return "";
    }

    @Override
    protected void initNameProperty() {
        PropertyHolder ph = new PropertyHolder(NAME);
        ph.setLeftValue(this.left_so != null ? this.left_so.getName() : "");
        ph.setRightValue(this.right_so != null ? this.right_so.getName() : "");
        if (this.isExcludedFromComparison(NAME) || this.isExcludeNamesFromComparison(ph)) {
            ph.setExcluded(true);
        } else if (!(this.left_so == null || this.right_so == null || ph.getLeftValue().equals(ph.getRightValue()) || !this.caseSensitive && ph.getLeftValue().equalsIgnoreCase(ph.getRightValue()) || this.left_so instanceof RelationalObjectProxy && !this.left_so.isNameChanged() && !this.right_so.isNameChanged())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    protected void initCommentProperty() {
        if (!DDL_ONLY) {
            PropertyHolder ph = new PropertyHolder(COMMENT);
            ph.setLeftValue(this.left_so != null ? this.left_so.getComment() : "");
            ph.setRightValue(this.right_so != null ? this.right_so.getComment() : "");
            if (this.isExcludedFromComparison(COMMENT)) {
                ph.setExcluded(true);
            } else if (this.left_so != null && this.right_so != null && !ph.getLeftValue().equals(ph.getRightValue()) && (!(this.left_so instanceof RelationalObjectProxy) || ((RelationalObjectProxy)this.left_so).isCommentChanged() || ((RelationalObjectProxy)this.right_so).isCommentChanged())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    protected void initCommentInRDBMSProperty() {
        PropertyHolder ph = new PropertyHolder(COMMENT_IN_RDBMS);
        ph.setLeftValue(this.left_so != null ? this.left_so.getCommentInRDBMS() : "");
        ph.setRightValue(this.right_so != null ? this.right_so.getCommentInRDBMS() : "");
        if (this.isExcludedFromComparison(COMMENT_IN_RDBMS)) {
            ph.setExcluded(true);
        } else if (this.left_so != null && this.right_so != null && !ph.getLeftValue().equals(ph.getRightValue()) && (!(this.left_so instanceof RelationalObjectProxy) || ((RelationalObjectProxy)this.left_so).isCommentInRDBMSChanged() || ((RelationalObjectProxy)this.right_so).isCommentInRDBMSChanged())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    protected void initNotesProperty() {
        if (!DDL_ONLY) {
            PropertyHolder ph = new PropertyHolder(NOTES);
            ph.setLeftValue(this.left_so != null ? this.left_so.getNotes() : "");
            ph.setRightValue(this.right_so != null ? this.right_so.getNotes() : "");
            if (this.isExcludedFromComparison(NOTES)) {
                ph.setExcluded(true);
            } else if (this.left_so != null && this.right_so != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    protected PropertyHolder initProperty(String propertyName, String xmlPropertyName) {
        return this.initProperty(propertyName, xmlPropertyName, xmlPropertyName, false);
    }

    protected PropertyHolder initProperty(String propertyName, String xmlPropertyForCompare, String xmlPropertyForMerge) {
        return this.initProperty(propertyName, xmlPropertyForCompare, xmlPropertyForMerge, true);
    }

    protected PropertyHolder initProperty(String propertyName, String xmlPropertyForCompare, String xmlPropertyForMerge, boolean ignoreCase) {
        if (propertyName.endsWith(":")) {
            propertyName = propertyName.substring(0, propertyName.length() - 1);
        }
        PropertyHolder ph = new PropertyHolder(propertyName);
        ClassDescription.PropertyDescription propDescr = null;
        if (this.classDescr != null) {
            if (xmlPropertyForMerge != null) {
                propDescr = this.classDescr.getPropertyDescriptionByName(xmlPropertyForMerge);
                ph.setPropertyDescription(propDescr);
            }
            if (!xmlPropertyForCompare.equals(xmlPropertyForMerge)) {
                propDescr = this.classDescr.getPropertyDescriptionByNameInclRO(xmlPropertyForCompare);
            }
        }
        this.initPropertyHolder(ph, propDescr);
        if (this.isExcludedFromComparison(propertyName)) {
            ph.setExcluded(true);
        } else if (this.left_so != null && this.right_so != null) {
            if (ignoreCase) {
                if (!ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
        return ph;
    }

    protected void initPropertyHolder(PropertyHolder ph, ClassDescription.PropertyDescription propDescr) {
        String leftValue = "";
        String rightValue = "";
        if (propDescr != null) {
            try {
                Object rightObject;
                Object leftObject;
                Method getter = propDescr.getter;
                if (getter == null && propDescr.getterName != null) {
                    StorageObject leftOrRight_so = this.left_so != null ? this.left_so : this.right_so;
                    getter = leftOrRight_so.getClass().getMethod(propDescr.getterName, new Class[0]);
                }
                if (this.left_so != null && (leftObject = getter.invoke((Object)this.left_so, new Object[0])) != null) {
                    leftValue = leftObject.toString();
                }
                if (this.right_so != null && (rightObject = getter.invoke((Object)this.right_so, new Object[0])) != null) {
                    rightValue = rightObject.toString();
                }
            }
            catch (Exception e) {
                LOGGER.error(" Error in Comparator Method for StorageProperty " + ph.getName(), e);
            }
        }
        ph.setLeftValue(leftValue);
        ph.setRightValue(rightValue);
    }

    protected void initProperty(String propertyName, String leftValue, String rightValue, String xmlPropertyForMerge) {
        if (propertyName.endsWith(":")) {
            propertyName = propertyName.substring(0, propertyName.length() - 1);
        }
        PropertyHolder ph = new PropertyHolder(propertyName);
        ph.setLeftValue(leftValue);
        ph.setRightValue(rightValue);
        if (this.isExcludedFromComparison(propertyName)) {
            ph.setExcluded(true);
        } else if (this.left_so != null && this.right_so != null && !leftValue.equals(rightValue)) {
            ph.setModified(true);
            ph.setSelected(true);
            if (xmlPropertyForMerge != null && this.classDescr != null) {
                ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName(xmlPropertyForMerge);
                ph.setPropertyDescription(propDescr);
            }
        }
        this.propertiesList.add(ph);
    }

    @Override
    public void copySelectedProperties() {
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_so != null && this.right_so != null) {
            for (PropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(NAME)) {
                    if (!this.right_so.setName(this.left_so.getName())) continue;
                    this.right_so.setNameHasQuotes(this.left_so.getNameHasQuotes());
                    continue;
                }
                if (ph.getName().equals(COMMENT_IN_RDBMS)) {
                    this.right_so.setCommentInRDBMS(this.left_so.getCommentInRDBMS());
                    continue;
                }
                if (ph.getName().equals(COMMENT)) {
                    this.right_so.setComment(this.left_so.getComment());
                    continue;
                }
                if (!ph.getName().equals(NOTES)) continue;
                this.right_so.setNotes(this.left_so.getNotes());
            }
            this.right_so.setDirty(this.isDirty());
        }
    }

    public List<ClassDescription.PropertyDescription> getPropsToMerge() {
        ArrayList<ClassDescription.PropertyDescription> propsList = new ArrayList<ClassDescription.PropertyDescription>();
        if (this.left_so != null && this.left_so.shouldBeMerge()) {
            boolean propUpdated = false;
            for (PropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(NAME)) {
                    if (this.right_so.setName(this.left_so.getName())) {
                        this.right_so.setNameHasQuotes(this.left_so.getNameHasQuotes());
                    }
                } else if (ph.getName().equals(COMMENT_IN_RDBMS)) {
                    if (this.right_so instanceof RelationalObjectProxy) {
                        ((RelationalObjectProxy)this.right_so).setCommentInRDBMSChanged(true);
                    }
                    this.right_so.setCommentInRDBMS(this.left_so.getCommentInRDBMS());
                } else if (ph.getName().equals(COMMENT)) {
                    if (this.right_so instanceof RelationalObjectProxy) {
                        ((RelationalObjectProxy)this.right_so).setCommentChanged(true);
                    }
                    this.right_so.setComment(this.left_so.getComment());
                } else if (ph.getName().equals(NOTES)) {
                    this.right_so.setNotes(this.left_so.getNotes());
                } else {
                    ClassDescription.PropertyDescription propDescr = ph.getPropertyDescription();
                    if (propDescr != null) {
                        propsList.add(propDescr);
                    }
                }
                propUpdated = true;
            }
            if (propUpdated) {
                this.right_so.setDirty(true);
            }
        }
        return propsList;
    }

    public List getCollectionsToExclude() {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    public String getID() {
        if (this.left_so != null && this.right_so != null) {
            return this.left_so.getObjectID() + this.right_so.getObjectID();
        }
        if (this.left_so != null) {
            return this.left_so.getObjectID();
        }
        if (this.right_so != null) {
            return this.right_so.getObjectID();
        }
        return "null";
    }

    @Override
    protected boolean hasToBeDrop() {
        return this.left_so == null && this.right_so != null;
    }

    public void setDroped(boolean isDrop) {
        this.isDroped = isDrop;
    }

    public boolean isDroped() {
        return this.isDroped;
    }

    @Override
    public String getChoosedPropertyValue(String propertyName) {
        for (EngPropertyHolder st_ph : this.propertiesList) {
            if (!st_ph.getName().equals(propertyName)) continue;
            if (this.left_so == null) {
                return st_ph.getRightValue();
            }
            if (this.right_so == null) {
                return st_ph.getLeftValue();
            }
            if (st_ph.isSelected()) {
                return st_ph.getLeftValue();
            }
            return st_ph.getRightValue();
        }
        return "";
    }

    @Override
    public boolean isTargetSelected(String propertyName) {
        if (this.left_so == null) {
            return true;
        }
        if (this.right_so == null) {
            return false;
        }
        for (EngPropertyHolder st_ph : this.propertiesList) {
            if (!st_ph.getName().equals(propertyName)) continue;
            return !st_ph.isSelected();
        }
        return true;
    }

    protected static String getPropertyNameOracle(String messageKey) {
        return StoragePropertiesComparator.removeColon(Messages.getString(messageKey));
    }

    protected static String getPropertyNameSqlServer(String messageKey) {
        return StoragePropertiesComparator.removeColon(oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages.getString(messageKey));
    }

    protected static String getPropertyNameDB2(String messageKey) {
        return StoragePropertiesComparator.removeColon(oracle.dbtools.crest.swingui.editor.storage.db2.Messages.getString(messageKey));
    }

    protected static String getPropertyNameUDB(String messageKey) {
        return StoragePropertiesComparator.removeColon(oracle.dbtools.crest.swingui.editor.storage.udb.Messages.getString(messageKey));
    }

    protected String listToString(List<String> list) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> sortList = new ArrayList<String>(list);
        sortList.sort(StringComparator);
        for (int i = 0; i < sortList.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append((String)sortList.get(i));
        }
        return buffer.toString();
    }
}

