/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SupplementalLogGroup;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class TableComparatorOracle
extends StoragePropertiesComparator {
    public static final String TEMPORARY = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Temporary");
    public static final String TEMPORARY_TABLESPACE = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.TemporaryTablespace");
    public static final String ORGANIZATION = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Organization");
    public static final String LOGGING = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Logging");
    public static final String MONITORING = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Monitoring");
    public static final String PARALLEL = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Parallel");
    public static final String DEGREE = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Degree");
    public static final String ROW_DEPENDENCY = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.RowDependency");
    public static final String PARTITIONED = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Partitioned");
    public static final String ROW_MOVEMENT = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.RowMovement");
    public static final String DATA_COMPRESSION = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.DataCompression");
    public static final String COMPRESSION_TYPE = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.CompressionType");
    public static final String IMPLEMENT_AS_MATERIALIZED_VIEW = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.ImplementAsSnapshot");
    public static final String CLUSTER = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Cluster");
    public static final String CLUSTER_COLUMNS = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.ClusterColumns");
    public static final String OID_INDEX_NAME = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.OIDIndexName");
    public static final String OID_INDEX_SEGMENT = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.OIDIndexSegment");
    public static final String IOT_COMPRESS = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.IOTCompress");
    public static final String IOT_PCT_THRESHOLD = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.IOTPCTThreshold");
    public static final String IOT_INCLUDING = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.IOTIncluding");
    public static final String OVERFLOW_TABLESPACE = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.OverflowTablespace");
    public static final String OVERFLOW_LOGGING = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.OverflowLogging");
    public static final String OVERFLOW_SEGMENT = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.OverflowSegment");
    public static final String MAPPING_TABLE = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.MappingTable");
    public static final String ACCESS_DRIVER = TableComparatorOracle.getPropertyNameOracle("ExternalTableOraclePropertyDialog.AccessDriver");
    public static final String DEFAULT_DIR = TableComparatorOracle.getPropertyNameOracle("ExternalTableOraclePropertyDialog.DefaultDir");
    public static final String ACCESS_PARAMS = TableComparatorOracle.getPropertyNameOracle("ExternalTableOraclePropertyDialog.AccessParams");
    public static final String LOCATION = TableComparatorOracle.getPropertyNameOracle("ExternalTableOraclePropertyDialog.Location");
    public static final String LOCATIONS = TableComparatorOracle.getPropertyNameOracle("ExternalTableOraclePropertyDialog.Locations");
    public static final String PROJECT_COLUMN = TableComparatorOracle.getPropertyNameOracle("ExternalTableOraclePropertyDialog.ProjectColumn");
    public static final String REJECT_LIMIT = TableComparatorOracle.getPropertyNameOracle("ExternalTableOraclePropertyDialog.RejectLimit");
    public static final String OPAQUE_FORMAT_SPEC = TableComparatorOracle.getPropertyNameOracle("ExternalTableOraclePropertyDialog.OpaqueFormatSpec");
    public static final String CLOB_SUBQUERY = TableComparatorOracle.getPropertyNameOracle("ExternalTableOraclePropertyDialog.CLOBSubquery");
    public static final String LOG_GROUP_NAME = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.GroupName");
    public static final String LOG_CONDITION = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Condition");
    public static final String SUPPLEMENTAL_COLUMNS = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.SupplementalColumns");
    public static final String XML_SCHEMA_URL = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.XMLSchemaURL");
    public static final String XML_SCHEMA_ELEMENT = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.XMLSchemaElem");
    public static final String ALLOW_ANY_SCHEMA = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.AllowAnySchema");
    public static final String ALLOW_NON_SCHEMA = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.AllowNonSchema");
    public static final String STORE_AS = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.StoreAs");
    public static final String LOB_STORAGE_TYPE = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.LobStorageType");
    public static final String LOB_SEGMENT_NAME = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.LobSegmentName");
    public static final String XMLTYPE_TABLESPACE = Messages.getString("ColumnComparatorOracle.XMLTYPETablespace");
    public static final String STORAGE_IN_ROW = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.StorageInRow");
    public static final String XMLTYPE_LOGGING = Messages.getString("ColumnComparatorOracle.XMLTYPELogging");
    public static final String CHUNK = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.Chunk");
    public static final String OLD_VERSIONS = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.OldVersions");
    public static final String PCT_VERSION = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.PCTVersion");
    public static final String FREEPOOLS = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.FreePools");
    public static final String IN_MEMORY = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemory");
    public static final String IN_MEMORY_COMPRESSION = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemoryCompression");
    public static final String IN_MEMORY_PRIORITY = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemoryPriority");
    public static final String IN_MEMORY_DISTRIBUTE = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemoryDistribute");
    public static final String IN_MEMORY_DUPLICATE = TableComparatorOracle.getPropertyNameOracle("TablePropertyDialogOracle.InMemoryDuplicate");
    private ToStringComparator toStringComparator = new ToStringComparator();
    public static String SUPPLEMENTAL_GROUPS = "Supplemental Groups";
    public static String SUPPLEMENTAL_ID_KEYS = "Supplemental Log ID Keys";
    private TableProxyOracle sourceTableProxy;
    private TableProxyOracle targetTableProxy;

    public TableComparatorOracle(TableProxyOracle sourceTableProxy, TableProxyOracle targetTableProxy) {
        super(sourceTableProxy, targetTableProxy);
        this.sourceTableProxy = sourceTableProxy;
        this.targetTableProxy = targetTableProxy;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        StorageDesign storageDesign = null;
        if (this.sourceTableProxy != null) {
            storageDesign = this.sourceTableProxy.getStorageDesign();
        } else if (this.targetTableProxy != null) {
            storageDesign = this.targetTableProxy.getStorageDesign();
        }
        this.initNameProperty();
        this.initCommentProperty();
        this.initCommentInRDBMSProperty();
        this.initProperty(USER_NAME, "user");
        this.initTemporaryProperty();
        this.initProperty(PRESERVE_ROWS, "tempPreserveRows");
        if (storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(TEMPORARY_TABLESPACE, "temporaryTablespace");
        }
        PropertyHolder organizationPH = this.initProperty(ORGANIZATION, "organization");
        this.initProperty(LOGGING, "logging");
        this.initProperty(CACHE, "cache");
        if (!(storageDesign instanceof StorageDesignOraclev10g)) {
            this.initProperty(MONITORING, "monitoring");
        }
        this.initProperty(PARALLEL, "parallel");
        this.initProperty(DEGREE, "degree");
        this.initProperty(ROW_DEPENDENCY, "rowDependency");
        this.initProperty(PARTITIONED, "partitioned");
        this.initProperty(ROW_MOVEMENT, "partitionedRowMovement");
        this.initProperty(DATA_COMPRESSION, "dataSegmentCompression");
        if (storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(COMPRESSION_TYPE, "compressionType");
        }
        this.initProperty(IMPLEMENT_AS_MATERIALIZED_VIEW, "materializedView");
        this.initProperty(CLUSTER, "cluster");
        this.initProperty(CLUSTER_COLUMNS, "allClusterColumns", "clusterColumns");
        this.initProperty(OID_INDEX_NAME, "oidIndexName");
        this.initOidIndexStorageProperty();
        this.initProperty(IOT_COMPRESS, "iotCompress");
        this.initProperty(IOT_PCT_THRESHOLD, "iotPctThreshold");
        this.initProperty(IOT_INCLUDING, "iotIncluding");
        this.initProperty(OVERFLOW_TABLESPACE, "iotOverflowTablespace");
        this.initProperty(OVERFLOW_LOGGING, "iotOverflowLogging");
        this.initOverflowStorageProperty();
        this.initProperty(MAPPING_TABLE, "iotMappingTable");
        PropertyHolder accessDriverPH = this.initProperty(ACCESS_DRIVER, "accessDriverType");
        this.initProperty(DEFAULT_DIR, "defaultdir");
        this.initProperty(ACCESS_PARAMS, "accessParametersType");
        this.initProperty(LOCATIONS, "locationsAsString");
        this.initProperty(PROJECT_COLUMN, "projectColumn");
        PropertyHolder rejectLimitPH = this.initProperty(REJECT_LIMIT, "rejectLimit");
        this.initProperty(OPAQUE_FORMAT_SPEC, "opaqueFormatSpec");
        this.initProperty(CLOB_SUBQUERY, "clobSubquery");
        this.initProperty(SUPPLEMENTAL_ID_KEYS, "supplementalLogIDKeys", "supplementalLogIDKeys");
        this.initProperty(SUPPLEMENTAL_GROUPS, "something", "something");
        this.initProperty(XML_SCHEMA_URL, "xmlSchemaUrl");
        this.initProperty(XML_SCHEMA_ELEMENT, "xmlSchemaElement");
        if (storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(ALLOW_ANY_SCHEMA, "allowAnySchema");
            this.initProperty(ALLOW_NON_SCHEMA, "allowNonSchema");
        }
        this.initProperty(STORE_AS, "storeAs");
        if (storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(LOB_STORAGE_TYPE, "lobStorageType");
        }
        this.initProperty(LOB_SEGMENT_NAME, "lobSegmentName");
        this.initProperty(XMLTYPE_TABLESPACE, "xmlTypeTableSpace");
        this.initProperty(STORAGE_IN_ROW, "storageInRow");
        this.initProperty(XMLTYPE_LOGGING, "xmlTypeLogging");
        this.initProperty(CACHE, "xmlTypeCache");
        this.initProperty(CHUNK, "chunk");
        this.initProperty(OLD_VERSIONS, "oldVersions");
        this.initProperty(PCT_VERSION, "pctVersion");
        this.initProperty(FREEPOOLS, "freepools");
        if (storageDesign instanceof StorageDesignOraclev12c) {
            this.initProperty(IN_MEMORY, "inMemory");
            this.initProperty(IN_MEMORY_COMPRESSION, "inMemoryCompression");
            this.initProperty(IN_MEMORY_PRIORITY, "inMemoryPriority");
            this.initProperty(IN_MEMORY_DISTRIBUTE, "inMemoryDistribute");
            this.initProperty(IN_MEMORY_DUPLICATE, "inMemoryDuplicate");
        }
        if (!"EXTERNAL".equals(organizationPH.getLeftValue()) && !"EXTERNAL".equals(organizationPH.getRightValue())) {
            accessDriverPH.setModified(false);
            accessDriverPH.setSelected(false);
            rejectLimitPH.setModified(false);
            rejectLimitPH.setSelected(false);
        }
    }

    private void initTemporaryProperty() {
        PropertyHolder ph = new PropertyHolder(TEMPORARY);
        ph.setLeftValue(this.sourceTableProxy != null ? this.sourceTableProxy.getTemporary() : "");
        ph.setRightValue(this.targetTableProxy != null ? this.targetTableProxy.getTemporary() : "");
        if (this.isExcludedFromComparison(TEMPORARY)) {
            ph.setExcluded(true);
        } else if (this.sourceTableProxy != null && this.targetTableProxy != null && !ph.getLeftValue().equals(ph.getRightValue()) && (this.sourceTableProxy.isTemporaryChanged() || this.targetTableProxy.isTemporaryChanged())) {
            ph.setModified(true);
            ph.setSelected(true);
            if (this.classDescr != null) {
                ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("temporary");
                ph.setPropertyDescription(propDescr);
            }
        }
        this.propertiesList.add(ph);
    }

    private void initOverflowStorageProperty() {
        PropertyHolder ph = new PropertyHolder(OVERFLOW_SEGMENT);
        SegmentOracle leftOverflowSegment = this.sourceTableProxy != null ? this.sourceTableProxy.getIotOverflowSegment() : null;
        SegmentOracle rightOverflowSegment = this.targetTableProxy != null ? this.targetTableProxy.getIotOverflowSegment() : null;
        ph.setLeftValue(leftOverflowSegment != null ? leftOverflowSegment.getName() : "");
        ph.setRightValue(rightOverflowSegment != null ? rightOverflowSegment.getName() : "");
        if (this.isExcludedFromComparison(OVERFLOW_SEGMENT)) {
            ph.setExcluded(true);
        } else if (!(this.sourceTableProxy == null || this.targetTableProxy == null || leftOverflowSegment == null && rightOverflowSegment == null || leftOverflowSegment != null && rightOverflowSegment != null && leftOverflowSegment.isEqualTo(rightOverflowSegment))) {
            if (ApplicationView.getInstance().getSettings().isIncludeStoragePropertiesInCompare()) {
                ph.setModified(true);
                ph.setSelected(true);
                if (this.classDescr != null) {
                    ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("iotOverflowSegment");
                    ph.setPropertyDescription(propDescr);
                }
            } else {
                ph.setExcluded(true);
            }
        }
        this.propertiesList.add(ph);
    }

    private void initOidIndexStorageProperty() {
        PropertyHolder ph = new PropertyHolder(OID_INDEX_SEGMENT);
        SegmentOracle leftOidIndexSegment = this.sourceTableProxy != null ? this.sourceTableProxy.getOidIndexSegment() : null;
        SegmentOracle rightOidIndexSegment = this.targetTableProxy != null ? this.targetTableProxy.getOidIndexSegment() : null;
        ph.setLeftValue(leftOidIndexSegment != null ? leftOidIndexSegment.getName() : "");
        ph.setRightValue(rightOidIndexSegment != null ? rightOidIndexSegment.getName() : "");
        if (this.isExcludedFromComparison(OID_INDEX_SEGMENT)) {
            ph.setExcluded(true);
        } else if (!(this.sourceTableProxy == null || this.targetTableProxy == null || leftOidIndexSegment == null && rightOidIndexSegment == null || leftOidIndexSegment != null && rightOidIndexSegment != null && leftOidIndexSegment.isEqualTo(rightOidIndexSegment))) {
            if (ApplicationView.getInstance().getSettings().isIncludeStoragePropertiesInCompare()) {
                ph.setModified(true);
                ph.setSelected(true);
                if (this.classDescr != null) {
                    ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("oidIndexSegment");
                    ph.setPropertyDescription(propDescr);
                }
            } else {
                ph.setExcluded(true);
            }
        }
        this.propertiesList.add(ph);
    }

    @Override
    public List<ClassDescription.PropertyDescription> getPropsToMerge() {
        List<ClassDescription.PropertyDescription> propsList = super.getPropsToMerge();
        if (this.getChoosedPropertyValue(PARTITIONED).equalsIgnoreCase(YES) && this.classDescr != null) {
            ClassDescription.PropertyDescription partListPD = this.classDescr.getPropertyDescriptionByName("partitionList");
            propsList.add(partListPD);
        }
        return propsList;
    }

    @Override
    public List getCollectionsToExclude() {
        List list = super.getCollectionsToExclude();
        PropertyHolder ph = (PropertyHolder)this.getPropertyHolderByName(SUPPLEMENTAL_GROUPS);
        if (!ph.isSelected()) {
            list.add("loggingGroups");
        }
        return list;
    }

    @Override
    protected void initPropertyHolder(PropertyHolder ph, ClassDescription.PropertyDescription propDescr) {
        if (SUPPLEMENTAL_GROUPS.equalsIgnoreCase(ph.getName())) {
            String leftValue = "";
            String rightValue = "";
            if (this.sourceTableProxy != null) {
                leftValue = this.getSortedSupplGroupsPresentation(this.sourceTableProxy.getLoggingGroups());
            }
            if (this.targetTableProxy != null) {
                rightValue = this.getSortedSupplGroupsPresentation(this.targetTableProxy.getLoggingGroups());
            }
            ph.setLeftValue(leftValue);
            ph.setRightValue(rightValue);
        } else {
            super.initPropertyHolder(ph, propDescr);
        }
    }

    String getSortedSupplGroupsPresentation(List<SupplementalLogGroup> list) {
        ArrayList<String> plist = new ArrayList<String>();
        for (SupplementalLogGroup sg : list) {
            plist.add(sg.getComparatorPresentation());
        }
        Collections.sort(plist);
        String res = "";
        for (String s : plist) {
            if (res.isEmpty()) {
                res = s;
                continue;
            }
            res = res + "\n" + s;
        }
        return res;
    }

    public TableProxyOracle getTargetTableProxy() {
        return this.targetTableProxy;
    }

    public TableProxyOracle getSourceTableProxy() {
        return this.sourceTableProxy;
    }

    class MatchingSG {
        SupplementalLogGroup left;
        SupplementalLogGroup right;

        MatchingSG() {
        }
    }
}

