/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.engineering.AttributeColumnComparator;
import oracle.dbtools.crest.model.design.engineering.DesignObjectComparator;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.engineering.EntViewTableViewComparator;
import oracle.dbtools.crest.model.design.engineering.EntitySubViewTableSubViewComparator;
import oracle.dbtools.crest.model.design.engineering.EntityTableComparator;
import oracle.dbtools.crest.model.design.engineering.FEEntityHierarchy;
import oracle.dbtools.crest.model.design.engineering.KeyIndexComparator;
import oracle.dbtools.crest.model.design.engineering.RelationFKComparator;
import oracle.dbtools.crest.model.design.engineering.RelationTableComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;

public class FE_LogicalToRelational
extends EngineeringObjectSelection {
    private static String NEW_FK = Messages.getString("FE_LogicalToRelational.NewFK");
    private RelationalDesign phdes;
    private LogicalDesign ldes;
    private EngineeringObjectSelection relationalRoot;
    private Map comparatorsMap = new TreeMap();
    private List deletedMappings = new ArrayList();
    private ExtendedMap xmap;
    private String targetDesPartID;
    private List entitylist = new ArrayList();
    private List relations = new ArrayList();
    private List entViewList = new ArrayList();
    DesignPartView dpv;
    private List roots;
    private Map multiMapped = new TreeMap();
    private boolean entireLogical = true;
    private static String NO_GENERATION = "no generation";

    public FE_LogicalToRelational(LogicalDesign ldes, RelationalDesign phdes, DesignPartView dpv) {
        super(ldes.getName());
        this.setDesign(ldes.getDesign());
        this.phdes = phdes;
        this.ldes = ldes;
        this.dpv = dpv;
        this.targetDesPartID = phdes.getObjectID();
        this.xmap = ldes.getDesign().getExtendedMap();
        this.setName(ldes.getName());
        this.relationalRoot = new EngineeringObjectSelection(phdes.getName());
        this.relationalRoot.setName(phdes.getName());
        this.setCorrespondentNode(this.relationalRoot);
        this.relationalRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.relationalRoot);
        if (dpv == ldes.getMainView()) {
            ldes.getEntitySet().addAllElementsTo(this.entitylist);
            ldes.getRelationSet().addAllElementsTo(this.relations);
            ldes.getEntityViewSet().addAllElementsTo(this.entViewList);
            this.entireLogical = true;
        } else {
            ContainerWithKeyObject ent;
            this.entireLogical = false;
            Iterator it = ldes.getEntitySet().iterator();
            while (it.hasNext()) {
                ent = (Entity)it.next();
                if (ent.getFirstViewForDPV(dpv) == null) continue;
                this.entitylist.add(ent);
            }
            it = ldes.getRelationSet().iterator();
            while (it.hasNext()) {
                Relation rel = (Relation)it.next();
                if (rel.getFirstViewForDPV(dpv) == null) continue;
                this.relations.add(rel);
            }
            it = ldes.getEntityViewSet().iterator();
            while (it.hasNext()) {
                ent = (EntityView)it.next();
                if (ent.getFirstViewForDPV(dpv) == null) continue;
                this.entViewList.add(ent);
            }
        }
        this.addFromLogicalModel();
    }

    private void setEmptyComparator(EngineeringObjectSelection node) {
        node.setPropertiesComparator(new EngEmptyPropertiesComparator(null, null));
    }

    private void addEntity(Entity entity, EngineeringObjectSelection allEntsel, EngineeringObjectSelection allTabsel) {
        List mlist = this.ldes.getDesign().getExtendedMap().getMappingsForDesignPart(entity, this.phdes.getObjectID());
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : mlist) {
            if (mapping.getInheritanceType() != 0 && mapping.getInheritanceType() != 3 && mapping.getInheritanceType() != 2 && mapping.getInheritanceType() != 1) continue;
            list.add(mapping);
        }
        int ind = 0;
        do {
            EngineeringObjectSelection tabsel;
            Table table;
            EngineeringObjectSelection entsel;
            XtdMapping mapping = null;
            DesignObject obj = null;
            if (ind < list.size() && !((obj = (mapping = (XtdMapping)list.get(ind)).getObjectMappedTo(entity)) instanceof Table)) {
                ++ind;
                continue;
            }
            ++ind;
            if (list.size() == 0) {
                String newName;
                if (!entity.shouldBeEngineered() && entity.getDesign().getExcludeFromTree()) continue;
                entsel = new EngineeringObjectSelection((ModelIDObject)entity, mapping);
                entsel.setSelected(entity.getShouldEngineer());
                table = (Table)obj;
                tabsel = null;
                String name = newName = this.getDesign().transformNameFromLogicalToRelational(entity);
                tabsel = new EngineeringObjectSelection(name);
                tabsel.setElementDescriptor(Table.class);
                XtdMapping del_mapping = entity.getDeletedMapping(this.phdes.getObjectID());
                if (del_mapping == null || !this.getDesign().isApplyNameStandardization()) {
                    // empty if block
                }
                EntityTableComparator comp = new EntityTableComparator(entity, table, entity.getDesign().getEntTablePropertyList());
                tabsel.setPropertiesComparator(comp);
                entsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                entsel.setStatus(2);
                tabsel.setStatus(2);
                entsel.setCorrespondentNode(tabsel);
                tabsel.setCorrespondentNode(entsel);
                boolean showDetails = true;
                this.setEditableStatus(entity, entsel, table, tabsel, mapping, showDetails);
                if (entity.isHierarchicalEntityType() && !showDetails) {
                    entsel.setEditable(false);
                }
                allTabsel.addChild(tabsel);
                allEntsel.addChild(entsel);
                continue;
            }
            if (mapping == null || !mapping.isFwEngineer() && entity.getDesign().getExcludeFromTree()) continue;
            entsel = new EngineeringObjectSelection((ModelIDObject)entity, mapping);
            entsel.setSelected(entity.getShouldEngineer());
            table = (Table)obj;
            tabsel = new EngineeringObjectSelection(table);
            EntityTableComparator comp = new EntityTableComparator(entity, table, entity.getDesign().getEntTablePropertyList());
            tabsel.setPropertiesComparator(comp);
            entsel.setPropertiesComparator(comp);
            tabsel.setSelected(entity.getShouldEngineer());
            this.comparatorsMap.put(comp.getID(), comp);
            entsel.setCorrespondentNode(tabsel);
            tabsel.setCorrespondentNode(entsel);
            boolean showDetails = !entity.isHierarchicalEntityType() || entity.isHierarchicalEntityType() && ind >= list.size();
            this.setEditableStatus(entity, entsel, table, tabsel, mapping, showDetails);
            if (entity.isHierarchicalEntityType() && !showDetails) {
                entsel.setEditable(false);
            }
            allTabsel.addChild(tabsel);
            allEntsel.addChild(entsel);
        } while (ind < list.size());
    }

    private void addEntityMulti(Entity entity, EngineeringObjectSelection allEntsel, EngineeringObjectSelection allTabsel) {
        List list = this.ldes.getDesign().getExtendedMap().getMappingsForDesignPart(entity, this.phdes.getObjectID());
        for (XtdMapping mapping : list) {
            DesignObject obj = mapping.getObjectMappedTo(entity);
            if (!(obj instanceof Table)) continue;
            EngineeringObjectSelection entsel = new EngineeringObjectSelection((ModelIDObject)entity, mapping);
            Table table = (Table)obj;
            EngineeringObjectSelection tabsel = null;
            if (table != null) {
                tabsel = new EngineeringObjectSelection((ModelIDObject)table, mapping);
                EntityTableComparator comp = new EntityTableComparator(entity, table, entity.getDesign().getEntTablePropertyList());
                tabsel.setPropertiesComparator(comp);
                entsel.setPropertiesComparator(comp);
                tabsel.setSelected(comp.isModified());
                this.comparatorsMap.put(comp.getID(), comp);
            } else {
                String newName;
                String name = newName = this.getDesign().transformNameFromLogicalToRelational(entity);
                tabsel = new EngineeringObjectSelection(name);
                tabsel.setElementDescriptor(Table.class);
                XtdMapping del_mapping = entity.getDeletedMapping(this.phdes.getObjectID());
                if (del_mapping == null || !this.getDesign().isApplyNameStandardization()) {
                    // empty if block
                }
                EntityTableComparator comp = new EntityTableComparator(entity, table, entity.getDesign().getEntTablePropertyList());
                tabsel.setPropertiesComparator(comp);
                entsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                entsel.setStatus(2);
                tabsel.setStatus(2);
            }
            entsel.setCorrespondentNode(tabsel);
            tabsel.setCorrespondentNode(entsel);
            this.setEditableStatus(entity, entsel, table, tabsel, mapping, true);
            allTabsel.addChild(tabsel);
            allEntsel.addChild(entsel);
        }
    }

    private void addEntityView(EntityView entityView, EngineeringObjectSelection allEntViewSel, EngineeringObjectSelection allTabViewSel) {
        EngineeringObjectSelection entViewSel = new EngineeringObjectSelection(entityView);
        entViewSel.setSelected(entityView.getShouldEngineer());
        TableView tableView = entityView.getEngTableView(this.phdes);
        EngineeringObjectSelection tabViewSel = null;
        if (tableView != null && (entityView.shouldBeEngineered() || !entityView.getDesign().getExcludeFromTree())) {
            tabViewSel = new EngineeringObjectSelection(tableView);
            EntViewTableViewComparator comp = new EntViewTableViewComparator(entityView, tableView, entityView.getDesign().getViewPropertyList());
            tabViewSel.setPropertiesComparator(comp);
            entViewSel.setPropertiesComparator(comp);
            tabViewSel.setSelected(comp.isModified());
            this.comparatorsMap.put(comp.getID(), comp);
            entViewSel.setCorrespondentNode(tabViewSel);
            tabViewSel.setCorrespondentNode(entViewSel);
            allTabViewSel.addChild(tabViewSel);
            allEntViewSel.addChild(entViewSel);
        } else if (tableView == null && (entityView.shouldBeEngineered() || !entityView.getDesign().getExcludeFromTree())) {
            String name = this.getDesign().transformNameFromLogicalToRelational(entityView);
            tabViewSel = new EngineeringObjectSelection(name);
            tabViewSel.setElementDescriptor(TableView.class);
            XtdMapping del_mapping = entityView.getDeletedMapping(this.phdes.getObjectID());
            if (del_mapping != null) {
                // empty if block
            }
            EntViewTableViewComparator comp = new EntViewTableViewComparator(entityView, tableView, entityView.getDesign().getViewPropertyList());
            tabViewSel.setPropertiesComparator(comp);
            entViewSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            entViewSel.setStatus(2);
            tabViewSel.setStatus(2);
            entViewSel.setCorrespondentNode(tabViewSel);
            tabViewSel.setCorrespondentNode(entViewSel);
            allTabViewSel.addChild(tabViewSel);
            allEntViewSel.addChild(entViewSel);
        }
    }

    private void setEditableStatus(Entity entity, EngineeringObjectSelection entsel, Table table, EngineeringObjectSelection tabsel, XtdMapping mapping, boolean showDetails) {
        if (entity.isHierarchicalEntityType()) {
            entsel.setEditable(true);
            if (showDetails) {
                this.addEntityDetails(entity, entsel, table, tabsel, false, mapping, false);
            } else {
                this.addEntityDetails(entity, entsel, table, tabsel, false, mapping, true);
            }
        } else if (showDetails) {
            this.addEntityDetails(entity, entsel, table, tabsel, false, mapping, true);
        }
    }

    private void addDeletedAttributes(Entity entity, EngineeringObjectSelection allAttrsel, Table table, EngineeringObjectSelection allColsel) {
        for (Column column : table.getElementsCollection()) {
            XtdMapping mapping = column.getDeletedMapping(entity);
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = column.getName();
            }
            EngineeringObjectSelection attrsel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(attrsel);
            attrsel.setSelected(false);
            EngineeringObjectSelection colsel = new EngineeringObjectSelection(column);
            attrsel.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(attrsel);
            this.setEmptyComparator(colsel);
            attrsel.setStatus(3);
            colsel.setStatus(3);
            colsel.setCorrespondentNode(attrsel);
            attrsel.setCorrespondentNode(colsel);
            allColsel.addChild(colsel);
            allAttrsel.addChild(attrsel);
        }
    }

    private void addDeletedKeys(Entity entity, EngineeringObjectSelection allCandKeysel, Table table, EngineeringObjectSelection allIndsel) {
        Iterator it = table.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            XtdMapping mapping = index.getDeletedMapping(entity);
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = index.getName();
            }
            EngineeringObjectSelection attrsel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(attrsel);
            attrsel.setSelected(false);
            EngineeringObjectSelection colsel = new EngineeringObjectSelection(index);
            attrsel.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(attrsel);
            this.setEmptyComparator(colsel);
            attrsel.setStatus(3);
            colsel.setStatus(3);
            colsel.setCorrespondentNode(attrsel);
            attrsel.setCorrespondentNode(colsel);
            allIndsel.addChild(colsel);
            allCandKeysel.addChild(attrsel);
        }
    }

    private void addDeletedEntities(EngineeringObjectSelection allEntsel, EngineeringObjectSelection allTabsel) {
        Iterator it = this.phdes.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            XtdMapping mapping = table.getDeletedMapping();
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = table.getName();
            }
            EngineeringObjectSelection entsel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(entsel);
            entsel.setSelected(false);
            EngineeringObjectSelection tabsel = new EngineeringObjectSelection(table);
            entsel.setElementDescriptor(Entity.class);
            this.setEmptyComparator(entsel);
            this.setEmptyComparator(tabsel);
            entsel.setStatus(3);
            tabsel.setStatus(3);
            tabsel.setCorrespondentNode(entsel);
            entsel.setCorrespondentNode(tabsel);
            allTabsel.addChild(tabsel);
            allEntsel.addChild(entsel);
        }
    }

    private void addDeletedRelations(EngFilteredSelection allRelsel, EngFilteredSelection allTabsel) {
        ArrayList list = new ArrayList();
        this.phdes.getFKIndexAssociationSet().addAllElementsTo(list);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk;
            FKContainer table;
            XtdMapping mapping = null;
            DesignObject obj = (DesignObject)it.next();
            if (obj instanceof FKIndexAssociation) {
                mapping = ((FKIndexAssociation)obj).getDeletedMapping();
                if (mapping != null && ((FKIndexAssociation)obj).getEngRelation() != null) {
                    mapping = null;
                }
            } else if (obj instanceof Table && (mapping = ((Table)obj).getDeletedMapping()) != null && ((Table)obj).getEngRelation() != null) {
                mapping = null;
            }
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = obj.getName();
            }
            String rname = null;
            if (obj instanceof FKIndexAssociation && (table = (fk = (FKIndexAssociation)obj).getTable()) != null && table instanceof Table) {
                Index ind = ((Table)table).getUniqueIndex((Column[])fk.getColumns());
                if (ind == null) {
                    ind = ((Table)table).getUniqueIndex_PK_UK((Column[])fk.getColumns());
                }
                if (ind != null) {
                    rname = "(--" + ind.getName() + ")";
                }
            }
            EngineeringObjectSelection entsel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(entsel);
            entsel.setSelected(false);
            EngineeringObjectSelection tabsel = new EngineeringObjectSelection(obj);
            if (rname != null) {
                tabsel.setName(obj.getName() + rname);
                tabsel.setDelMapping(mapping);
            }
            entsel.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(entsel);
            this.setEmptyComparator(tabsel);
            entsel.setStatus(3);
            tabsel.setStatus(3);
            tabsel.setCorrespondentNode(entsel);
            entsel.setCorrespondentNode(tabsel);
            allTabsel.addChild(tabsel);
            allRelsel.addChild(entsel);
        }
    }

    private void addDeletedEntityViews(EngineeringObjectSelection allEntViewSel, EngineeringObjectSelection allTabViewSel) {
        Iterator it = this.phdes.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView tableView = (TableView)it.next();
            XtdMapping mapping = tableView.getDeletedMapping();
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = tableView.getName();
            }
            EngineeringObjectSelection entViewSel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(entViewSel);
            entViewSel.setSelected(false);
            EngineeringObjectSelection tabViewSel = new EngineeringObjectSelection(tableView);
            entViewSel.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(entViewSel);
            this.setEmptyComparator(tabViewSel);
            entViewSel.setStatus(3);
            tabViewSel.setStatus(3);
            tabViewSel.setCorrespondentNode(entViewSel);
            entViewSel.setCorrespondentNode(tabViewSel);
            allTabViewSel.addChild(tabViewSel);
            allEntViewSel.addChild(entViewSel);
        }
    }

    private List getNoneHierarchiesEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity entity : this.entitylist) {
            if (this.multiMapped.get(entity.getObjectID()) != null || entity.isHierarchicalEntityType()) continue;
            list.add(entity);
        }
        return list;
    }

    private List getRoots() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity entity : this.entitylist) {
            Entity visible;
            if (this.multiMapped.get(entity.getObjectID()) != null) continue;
            if (entity.isHierarchicalRoot()) {
                list.add(entity);
                continue;
            }
            if (!entity.isHierarchicalEntityType() || (visible = this.getHighestVisibleParent(entity, this.dpv)) == null || list.contains(entity)) continue;
            list.add(entity);
        }
        Entity[] entities = list.toArray(new Entity[0]);
        for (int i = 0; i < entities.length; ++i) {
            for (int j = 0; j < entities.length; ++j) {
                if (i == j || !entities[i].isHierarchicalAncestorOf(entities[j])) continue;
                list.remove(entities[j]);
            }
        }
        return list;
    }

    private Entity getHighestVisibleParent(Entity ent, DesignPartView dpv) {
        Entity visible;
        Entity parent = ent.getHierarchicalParent();
        if (parent != null && (visible = this.getHighestVisibleParent(parent, dpv)) != null) {
            return visible;
        }
        if (ent.getFirstViewForDPV(dpv) != null) {
            return ent;
        }
        return null;
    }

    private void addFromLogicalModel() {
        List list = this.getEntitiesWitnMultiMappings();
        if (list.size() > 0) {
            EngFilteredSelection allTabsel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Tables"));
            allTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
            EngFilteredSelection allEntsel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.EntitiesWithMultipleMappings"));
            allEntsel.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
            this.setEmptyComparator(allEntsel);
            this.setEmptyComparator(allTabsel);
            allTabsel.setCorrespondentNode(allEntsel);
            allEntsel.setCorrespondentNode(allTabsel);
            for (Entity entity : list) {
                this.addEntityMulti(entity, allEntsel, allTabsel);
            }
            this.relationalRoot.addChild(allTabsel);
            this.addChild(allEntsel);
        }
        Iterator it = this.getNoneHierarchiesEntities().iterator();
        EngFilteredSelection allTabsel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Tables"));
        allTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        EngFilteredSelection allTabViewSel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Views"));
        allTabViewSel.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        EngFilteredSelection allTabSubViewSel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Subviews"));
        allTabSubViewSel.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        EngFilteredSelection allEntsel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Entities"));
        allEntsel.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
        EngFilteredSelection allEntViewSel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Views"));
        allEntViewSel.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        EngFilteredSelection allEntSubViewSel = null;
        if (this.entireLogical) {
            allEntSubViewSel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Subviews"));
            allEntSubViewSel.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
            allTabSubViewSel.setCorrespondentNode(allEntSubViewSel);
            allEntSubViewSel.setCorrespondentNode(allTabSubViewSel);
            this.setEmptyComparator(allEntSubViewSel);
        }
        allTabsel.setCorrespondentNode(allEntsel);
        allEntsel.setCorrespondentNode(allTabsel);
        allTabViewSel.setCorrespondentNode(allEntViewSel);
        allEntViewSel.setCorrespondentNode(allTabViewSel);
        this.setEmptyComparator(allEntsel);
        this.setEmptyComparator(allEntViewSel);
        allTabsel.setSelected(false);
        allTabViewSel.setSelected(false);
        allTabSubViewSel.setSelected(false);
        this.setEmptyComparator(allTabsel);
        this.setEmptyComparator(allTabViewSel);
        this.setEmptyComparator(allTabSubViewSel);
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            this.addEntity(entity, allEntsel, allTabsel);
        }
        for (EntityView entityView : this.entViewList) {
            this.addEntityView(entityView, allEntViewSel, allTabViewSel);
        }
        if (this.entireLogical) {
            it = this.ldes.getLogicalDesignSubviews().iterator();
            while (it.hasNext()) {
                DesignPartViewPlaceHolder entityHolder = (DesignPartViewPlaceHolder)it.next();
                DPVLogicalSubView logDPV = (DPVLogicalSubView)entityHolder.getDesignPartView();
                this.addEntitySubView(logDPV, allEntSubViewSel, allTabSubViewSel);
            }
        }
        this.addDeletedEntities(allEntsel, allTabsel);
        this.relationalRoot.addChild(allTabsel);
        this.addChild(allEntsel);
        this.roots = this.getRoots();
        it = this.roots.iterator();
        EngFilteredSelection allInhTabsel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.TablesMappedToHierarchies"));
        allInhTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        EngFilteredSelection allInhEntsel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.EntityHierarchies"));
        allInhEntsel.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
        allInhTabsel.setCorrespondentNode(allInhEntsel);
        allInhEntsel.setCorrespondentNode(allInhTabsel);
        this.setEmptyComparator(allInhEntsel);
        allInhTabsel.setSelected(false);
        this.setEmptyComparator(allInhTabsel);
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            this.addEntity(entity, allInhEntsel, allInhTabsel);
        }
        this.relationalRoot.addChild(allInhTabsel);
        this.addChild(allInhEntsel);
        this.addRelationsToTables();
        this.relationalRoot.addChild(allTabViewSel);
        this.addDeletedEntityViews(allEntViewSel, allTabViewSel);
        this.addChild(allEntViewSel);
        if (this.entireLogical) {
            this.relationalRoot.addChild(allTabSubViewSel);
            this.addDeletedEntitySubViews(allEntSubViewSel, allTabSubViewSel);
            this.addChild(allEntSubViewSel);
        }
    }

    private boolean hasChildsInDPV(Entity ent) {
        for (Entity temp : this.entitylist) {
            if (!ent.isHierarchicalAncestorOf(temp)) continue;
            return true;
        }
        return false;
    }

    private void addRelationsToTables() {
        EngFilteredSelection allTabsel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.ObjectsMappedToRelations"));
        allTabsel.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        EngFilteredSelection allRelsel = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Relations"));
        allRelsel.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        allTabsel.setCorrespondentNode(allRelsel);
        allRelsel.setCorrespondentNode(allTabsel);
        this.setEmptyComparator(allRelsel);
        allTabsel.setSelected(false);
        this.setEmptyComparator(allTabsel);
        for (Relation relation : this.relations) {
            this.addRelation(relation, allRelsel, allTabsel);
        }
        this.addDeletedRelations(allRelsel, allTabsel);
        this.relationalRoot.addChild(allTabsel);
        this.addChild(allRelsel);
    }

    public static boolean isRefKeyChanged(Attribute attr, Table table) {
        if (attr.isFKAttribute() && table != null) {
            Entity ent = (Entity)attr.getContainerWithKeyObject();
            DesignObject obj = attr.getGenerator();
            if (obj != null && obj instanceof Relation) {
                Relation rel = (Relation)obj;
                FKIndexAssociation fk = rel.getEngFK((RelationalDesign)table.getDesignPart(), table);
                Entity other = rel.getOtherEntity(ent);
                if (other != null) {
                    Index ind;
                    CandidateKey key;
                    Table parent = other.getEngTable((RelationalDesign)table.getDesignPart(), 3);
                    if (fk != null && parent != null && (key = rel.getPKProviderKeyForChild(ent)) != null && (ind = key.getEngIndex((RelationalDesign)table.getDesignPart(), parent)) != null && ind != fk.getRemoteIndex()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void addAttribute(Attribute attribute, Table table, EngineeringObjectSelection allAttrsel, EngineeringObjectSelection allColsel, XtdMapping containerMapping) {
        Entity ent = (Entity)attribute.getContainerWithKeyObject();
        if (FE_LogicalToRelational.isRefKeyChanged(attribute, table)) {
            attribute.setEngineerTo(table.getDesignPartId(), false);
            if (!containerMapping.getAttributes().contains(attribute.getObjectID())) {
                containerMapping.getAttributes().add(attribute.getObjectID());
            }
            return;
        }
        List mlist = attribute.getMappingsFor(this.phdes, table);
        int ind = 0;
        do {
            XtdMapping amapping = null;
            DesignObject obj = null;
            if (ind < mlist.size() && !((obj = (amapping = (XtdMapping)mlist.get(ind)).getObjectMappedTo(attribute)) instanceof Column)) {
                ++ind;
                continue;
            }
            EngineeringObjectSelection attrsel = new EngineeringObjectSelection(attribute, amapping, containerMapping);
            EngineeringObjectSelection colsel = null;
            Column column = null;
            if (table != null && amapping != null && (column = (Column)obj) != null) {
                EngPropertyHolder ph;
                Relation rel;
                FKIndexAssociation fk;
                DesignObject dob;
                boolean disableNameChane = false;
                if (attribute.isFKAttribute() && (dob = attribute.getDesign().getDesignObject(attribute.getGeneratorID())) != null && dob instanceof Relation && (fk = (rel = (Relation)dob).getEngFK(this.phdes, table)) != null && column.getReferencedColumn(fk) == column) {
                    attribute.setEngineerTo(this.phdes.getObjectID(), false);
                    disableNameChane = true;
                }
                colsel = new EngineeringObjectSelection(column);
                AttributeColumnComparator comp = new AttributeColumnComparator(attribute, column, attribute.getDesign().getAttrColPropertyList());
                if (disableNameChane && (ph = comp.getPropertyHolderByName(PropertyNames.NAME)) != null) {
                    ph.setSelected(false);
                }
                colsel.setPropertiesComparator(comp);
                attrsel.setPropertiesComparator(comp);
                colsel.setSelected(attribute.getShouldEngineer());
                this.comparatorsMap.put(comp.getID(), comp);
            }
            if (column == null) {
                XtdMapping del_mapping;
                String newName;
                String name = newName = this.getDesign().transformNameFromLogicalToRelational(attribute);
                colsel = new EngineeringObjectSelection(name);
                colsel.setElementDescriptor(Column.class);
                if (table == null || this.getDesign().isApplyNameStandardization() || (del_mapping = attribute.getDeletedMapping(table)) != null) {
                    // empty if block
                }
                AttributeColumnComparator comp = new AttributeColumnComparator(attribute, column, attribute.getDesign().getAttrColPropertyList());
                colsel.setPropertiesComparator(comp);
                attrsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                attrsel.setStatus(2);
                colsel.setStatus(2);
            }
            colsel.setCorrespondentNode(attrsel);
            attrsel.setCorrespondentNode(colsel);
            attrsel.setEditable(!ent.isHierarchicalEntityType());
            allColsel.addChild(colsel);
            allAttrsel.addChild(attrsel);
            ++ind;
        } while (ind < mlist.size());
    }

    private void addRelation(Relation relation, EngineeringObjectSelection allRelsel, EngineeringObjectSelection allTabsel) {
        ArrayList instances = new ArrayList();
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        this.processRelation(relation, instances);
        EngineeringObjectSelection relsel = new EngineeringObjectSelection(relation);
        relsel.setSelected(relation.getShouldEngineer());
        EngineeringObjectSelection physsel = new EngineeringObjectSelection(MessageFormat.format(Messages.getString("FE_LogicalToRelational.MappedTo"), relation.getName()));
        if (relation.isManyToMany()) {
            physsel.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        } else {
            physsel.setIcon(GUIConfiguration.getInstance().getIcon("ONE_TO_N_RELATION_ICON"));
            relsel.setIcon(GUIConfiguration.getInstance().getIcon("ONE_TO_N_RELATION_ICON"));
        }
        physsel.setCorrespondentNode(relsel);
        relsel.setCorrespondentNode(physsel);
        this.setEmptyComparator(physsel);
        this.setEmptyComparator(relsel);
        boolean rel_added = false;
        for (RelationMapping rm : instances) {
            EngineeringObjectSelection ph_sel;
            EngineeringObjectSelection logsel;
            Object dobj;
            int i;
            for (i = 0; i < rm.existing.size(); ++i) {
                EngPropertiesComparator comp;
                String newName;
                if (!relation.getShouldEngineer() && relation.getDesign().getExcludeFromTree()) continue;
                dobj = (DesignObject)rm.existing.get(i);
                logsel = new EngineeringObjectSelection(relation);
                ph_sel = new EngineeringObjectSelection((ModelIDObject)dobj);
                ph_sel.setCorrespondentNode(logsel);
                logsel.setCorrespondentNode(ph_sel);
                if (dobj instanceof FKIndexAssociation) {
                    newName = this.getDesign().transformNameFromLogicalToRelational(relation, (FKIndexAssociation)dobj, ((FKIndexAssociation)dobj).getTable());
                    ph_sel.setName(newName);
                    comp = new RelationFKComparator(relation, (FKIndexAssociation)dobj, relation.getDesign().getRelFKPropertyList());
                    if (relation.getAttributesCollection().size() > 0) {
                        this.addFK_RelationAttributes(relation, (FKIndexAssociation)dobj, logsel, ph_sel);
                    }
                } else {
                    newName = this.getDesign().transformNameFromLogicalToRelational(relation);
                    ph_sel.setName(newName);
                    comp = dobj instanceof Table ? new RelationTableComparator(relation, (Table)dobj, relation.getDesign().getRelTablePropertyList()) : new DesignObjectComparator(relation, (DesignObject)dobj, relation.getDesign().getRelFKPropertyList());
                    if (relation.getAttributesCollection().size() > 0 && dobj instanceof Table) {
                        this.addARelationAttributes(relation, (Table)dobj, new ArrayList(relation.getAttributesCollection()), logsel, ph_sel);
                    }
                }
                ph_sel.setPropertiesComparator(comp);
                logsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                if (rm.sourceEntity != null && rm.targetEntity != null) {
                    logsel.setName(rm.sourceEntity.getName() + " : " + rm.targetEntity.getName());
                }
                relsel.addChild(logsel);
                physsel.addChild(ph_sel);
                if (rel_added) continue;
                allRelsel.addChild(relsel);
                allTabsel.addChild(physsel);
                rel_added = true;
            }
            for (i = 0; i < rm.deleted.size(); ++i) {
                dobj = (DesignObject)rm.deleted.get(i);
                Object obj = map.get(((ModelIDObject)dobj).getObjectID());
                if (obj != null) continue;
                EngineeringObjectSelection logsel2 = new EngineeringObjectSelection(relation);
                EngineeringObjectSelection ph_sel2 = new EngineeringObjectSelection((ModelIDObject)dobj);
                ph_sel2.setCorrespondentNode(logsel2);
                logsel2.setCorrespondentNode(ph_sel2);
                DesignObjectComparator comp = new DesignObjectComparator(relation, (DesignObject)dobj, relation.getDesign().getRelFKPropertyList());
                ph_sel2.setPropertiesComparator(comp);
                logsel2.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                if (rm.sourceEntity != null && rm.targetEntity != null) {
                    logsel2.setName(rm.sourceEntity.getName() + " : " + rm.targetEntity.getName());
                }
                logsel2.setStatus(3);
                ph_sel2.setStatus(3);
                relsel.addChild(logsel2);
                physsel.addChild(ph_sel2);
                this.deletedMappings.add(logsel2);
                logsel2.setSelected(true);
                map.put(((ModelIDObject)dobj).getObjectID(), dobj);
                if (rel_added) continue;
                allRelsel.addChild(relsel);
                allTabsel.addChild(physsel);
                rel_added = true;
            }
            for (i = 0; i < rm.newStrings.size(); ++i) {
                dobj = (String)rm.newStrings.get(i);
                if (!relation.getShouldEngineer() && relation.getDesign().getExcludeFromTree()) continue;
                logsel = new EngineeringObjectSelection(relation);
                ph_sel = new EngineeringObjectSelection((String)dobj);
                String newName = this.getDesign().transformNameFromLogicalToRelational(relation);
                ph_sel.setName(newName);
                ph_sel.setCorrespondentNode(logsel);
                logsel.setCorrespondentNode(ph_sel);
                this.setEmptyComparator(ph_sel);
                this.setEmptyComparator(logsel);
                if (rm.sourceEntity != null && rm.targetEntity != null) {
                    logsel.setName(rm.sourceEntity.getName() + " : " + rm.targetEntity.getName());
                }
                logsel.setStatus(2);
                ph_sel.setStatus(2);
                relsel.addChild(logsel);
                physsel.addChild(ph_sel);
                if (relation.isManyToMany()) {
                    if (relation.getAttributesCollection().size() > 0) {
                        this.addARelationAttributes(relation, null, new ArrayList(relation.getAttributesCollection()), logsel, ph_sel);
                    }
                    ph_sel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_ICON"));
                } else {
                    if (relation.getAttributesCollection().size() > 0) {
                        this.addFK_RelationAttributes(relation, null, logsel, ph_sel);
                    }
                    ph_sel.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
                    logsel.setIcon(GUIConfiguration.getInstance().getIcon("ONE_TO_N_RELATION_ICON"));
                }
                if (rel_added) continue;
                allRelsel.addChild(relsel);
                allTabsel.addChild(physsel);
                rel_added = true;
            }
        }
    }

    private void addEntityDetails(Entity entity, EngineeringObjectSelection entParent, Table table, EngineeringObjectSelection tabParent, boolean subtypesOnly, XtdMapping mapping, boolean excludeSubtypes) {
        if (!subtypesOnly) {
            EngineeringObjectSelection allColsel = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.Columns"));
            allColsel.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
            EngineeringObjectSelection allAttrsel = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.Attributes"));
            allAttrsel.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
            allColsel.setCorrespondentNode(allAttrsel);
            allAttrsel.setCorrespondentNode(allColsel);
            this.setEmptyComparator(allColsel);
            this.setEmptyComparator(allAttrsel);
            allColsel.setSelected(false);
            allAttrsel.setEditable(false);
            for (Attribute attribute : entity.getElementsCollection()) {
                this.addAttribute(attribute, table, allAttrsel, allColsel, mapping);
            }
            if (table != null) {
                this.addDeletedAttributes(entity, allAttrsel, table, allColsel);
            }
            tabParent.addChild(allColsel);
            entParent.addChild(allAttrsel);
            EngineeringObjectSelection allIndsel = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.PKAndUKConstraints"));
            allIndsel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
            EngineeringObjectSelection allKeysel = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.CandidateKeys"));
            allKeysel.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
            allIndsel.setCorrespondentNode(allKeysel);
            allKeysel.setCorrespondentNode(allIndsel);
            this.setEmptyComparator(allIndsel);
            this.setEmptyComparator(allKeysel);
            Iterator it = entity.getKeySet().iterator();
            while (it.hasNext()) {
                CandidateKey key = (CandidateKey)it.next();
                this.addKey(key, table, allKeysel, allIndsel, mapping);
            }
            if (table != null) {
                this.addDeletedKeys(entity, allKeysel, table, allIndsel);
            }
            allKeysel.setEditable(false);
            tabParent.addChild(allIndsel);
            entParent.addChild(allKeysel);
        }
        if (entity.isHierarchicalEntityType() && !excludeSubtypes) {
            EngineeringObjectSelection allInhTabsel = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.TablesMappedToSubtypes"));
            allInhTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
            EngineeringObjectSelection allInhEntsel = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.Subtypes"));
            allInhEntsel.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
            allInhTabsel.setCorrespondentNode(allInhEntsel);
            allInhEntsel.setCorrespondentNode(allInhTabsel);
            this.setEmptyComparator(allInhEntsel);
            this.setEmptyComparator(allInhTabsel);
            int count = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < count; ++i) {
                Entity ch_entity = entity.getHierarchicalChild(i);
                if (!this.entitylist.contains(ch_entity) && !this.hasChildsInDPV(ch_entity)) continue;
                this.addEntity(ch_entity, allInhEntsel, allInhTabsel);
            }
            tabParent.addChild(allInhTabsel);
            entParent.addChild(allInhEntsel);
        }
    }

    private void addKey(CandidateKey key, Table table, EngineeringObjectSelection allKeySel, EngineeringObjectSelection allIndSel, XtdMapping containerMapping) {
        String name;
        XtdMapping kmapping = key.getMappingFor(table);
        EngineeringObjectSelection keysel = new EngineeringObjectSelection(key, kmapping, containerMapping);
        EngineeringObjectSelection indsel = null;
        Index index = null;
        if (table != null && kmapping != null && (index = (Index)kmapping.getObjectMappedTo(key)) != null) {
            name = index.getName();
            boolean hier = false;
            indsel = new EngineeringObjectSelection(name);
            if (index.isPK()) {
                indsel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
            } else {
                indsel.setIcon(GUIConfiguration.getInstance().getIcon("CANDIDATE_KEY_ICON"));
            }
            KeyIndexComparator comp = new KeyIndexComparator(key, index, key.getDesign().getKeyIdxPropertyList());
            indsel.setPropertiesComparator(comp);
            keysel.setPropertiesComparator(comp);
            if (hier) {
                keysel.setStatus(0);
                indsel.setStatus(0);
                keysel.setSelected(false);
                keysel.setEditable(false);
                comp.setReadOnly(true);
            } else {
                indsel.setSelected(comp.isModified());
                keysel.setSelected(comp.isModified());
            }
            this.comparatorsMap.put(comp.getID(), comp);
        }
        if (index == null) {
            XtdMapping del_mapping;
            name = this.getDesign().transformNameFromLogicalToRelational(key);
            indsel = new EngineeringObjectSelection(name);
            indsel.setElementDescriptor(CandidateKey.class);
            if (table == null || (del_mapping = key.getDeletedMapping(table)) != null) {
                // empty if block
            }
            if (key.isPK()) {
                if (key.getEntity().isCreateSurrogateKey()) {
                    indsel.setIcon(GUIConfiguration.getInstance().getIcon("CANDIDATE_KEY_ICON"));
                } else {
                    indsel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
                }
            } else {
                indsel.setIcon(GUIConfiguration.getInstance().getIcon("CANDIDATE_KEY_ICON"));
            }
            KeyIndexComparator comp = new KeyIndexComparator(key, index, key.getDesign().getKeyIdxPropertyList());
            indsel.setPropertiesComparator(comp);
            keysel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            indsel.setStatus(2);
            keysel.setStatus(2);
        }
        indsel.setCorrespondentNode(keysel);
        keysel.setCorrespondentNode(indsel);
        allKeySel.addChild(keysel);
        allIndSel.addChild(indsel);
    }

    public EngineeringObjectSelection getRelationalRoot() {
        return this.relationalRoot;
    }

    public EngineeringObjectSelection getLogicalRoot() {
        return this;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public List getDeletedMappings() {
        return this.deletedMappings;
    }

    void processRelation(Relation relation, List instances) {
        Entity parent;
        ArrayList list;
        ArrayList<Entity> seList = new ArrayList<Entity>();
        ArrayList<Entity> teList = new ArrayList<Entity>();
        Entity sEntity = relation.getSourceEntity();
        Entity tEntity = relation.getTargetEntity();
        if (sEntity.isHierarchicalEntityType()) {
            if (sEntity.shouldBeEngineered()) {
                seList.add(sEntity);
            } else {
                list = new ArrayList();
                FEEntityHierarchy.getEntities_Down_FirstEngineer(sEntity, list);
                if (list.size() > 0) {
                    seList.addAll(list);
                } else {
                    parent = FEEntityHierarchy.getParentFirstEngineer(sEntity);
                    if (parent != null) {
                        seList.add(parent);
                    }
                }
            }
        } else {
            seList.add(sEntity);
        }
        if (tEntity.isHierarchicalEntityType()) {
            if (tEntity.shouldBeEngineered()) {
                teList.add(tEntity);
            } else {
                list = new ArrayList();
                FEEntityHierarchy.getEntities_Down_FirstEngineer(tEntity, list);
                if (list.size() > 0) {
                    teList.addAll(list);
                } else {
                    parent = FEEntityHierarchy.getParentFirstEngineer(tEntity);
                    if (parent != null) {
                        teList.add(parent);
                    }
                }
            }
        } else {
            teList.add(tEntity);
        }
        List inlist = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
        for (int i = 0; i < seList.size(); ++i) {
            Entity realSourceEntity = (Entity)seList.get(i);
            for (int j = 0; j < teList.size(); ++j) {
                Entity realTargetEntity = (Entity)teList.get(j);
                RelationMapping rm = new RelationMapping(realSourceEntity, realTargetEntity);
                this.processRelation(relation, realSourceEntity, realTargetEntity, rm);
                this.addPreviousThatWillBeDeleted(relation, inlist, seList, teList, rm);
                instances.add(rm);
            }
        }
    }

    private void addPreviousThatWillBeDeleted(Relation relation, List mappings, List sList, List tList, RelationMapping rm) {
        for (XtdMapping mapping : mappings) {
            DesignObject dobj = mapping.getObjectMappedTo(relation);
            if (dobj == null || 0 == mapping.getInheritanceType() || this.containsDesObject(sList, mapping.getRealSourceEntityID()) && this.containsDesObject(tList, mapping.getRealTargetEntityID()) || !this.shouldDelete(dobj)) continue;
            rm.deleted.add(dobj);
        }
    }

    private boolean containsDesObject(List list, String id) {
        for (DesignObject dobj : list) {
            if (!dobj.getObjectID().equals(id)) continue;
            return true;
        }
        return false;
    }

    private void processRelation(Relation relation, Entity realSourceEntity, Entity realTargetEntity, RelationMapping relMapping) {
        block41: {
            block39: {
                Table pktab;
                Entity ent;
                DesignObject dobj;
                XtdMapping mapping;
                DesignObject dobj2;
                int[] pkEndPoints;
                Table targetTable;
                Table sourceTable;
                List list;
                Entity targetEntity;
                Entity sourceEntity;
                block40: {
                    List inlist = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
                    sourceEntity = relation.getSourceEntity();
                    targetEntity = relation.getTargetEntity();
                    list = this.getRelationMappingsFor(inlist, realSourceEntity, realTargetEntity);
                    sourceTable = realSourceEntity.getEngTable(this.phdes);
                    targetTable = realTargetEntity.getEngTable(this.phdes);
                    relMapping.pkNumber = relation.getPKProviderEndPoint().length;
                    if (sourceTable == null || targetTable == null) break block39;
                    pkEndPoints = relation.getPKProviderEndPoint();
                    if (!relation.isManyToMany()) break block40;
                    relMapping.many = true;
                    if (list.size() > 1) {
                        for (XtdMapping mapping2 : list) {
                            DesignObject dobj3 = mapping2.getObjectMappedTo(relation);
                            if (dobj3 == null) continue;
                            relMapping.status = 3;
                            relMapping.deleted.add(dobj3);
                        }
                        list.clear();
                    } else if (list.size() == 1) {
                        XtdMapping mapping3 = (XtdMapping)list.get(0);
                        DesignObject dobj4 = mapping3.getObjectMappedTo(relation);
                        if (dobj4 != null && !(dobj4 instanceof Table)) {
                            if (this.shouldDelete(dobj4)) {
                                relMapping.status = 3;
                                relMapping.deleted.add(dobj4);
                            }
                            list.clear();
                        } else if (dobj4 != null && dobj4 instanceof Table) {
                            relMapping.existing.add(dobj4);
                        }
                    }
                    if (list.size() != 0) break block41;
                    relMapping.status = 2;
                    relMapping.newStrings.add(NEW_TABLE);
                    break block41;
                }
                if (list.size() == 1 && (dobj2 = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(relation)) != null && dobj2 instanceof Table) {
                    relMapping.status = 3;
                    relMapping.many = true;
                    relMapping.deleted.add(dobj2);
                }
                if (list.size() > 0 && pkEndPoints.length == 0) {
                    ArrayList copy = new ArrayList(list);
                    for (XtdMapping mapping4 : copy) {
                        dobj = mapping4.getObjectMappedTo(relation);
                        if (dobj == null || !this.shouldDelete(dobj)) continue;
                        relMapping.status = 3;
                        relMapping.deleted.add(dobj);
                        list.remove(dobj);
                    }
                } else if (list.size() == 2 && pkEndPoints.length == 1) {
                    ent = relation.getEntity(pkEndPoints[0]);
                    pktab = null;
                    if (ent == sourceEntity) {
                        pktab = sourceTable;
                    } else if (ent == targetEntity) {
                        pktab = targetTable;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        XtdMapping mapping5 = (XtdMapping)list.get(i);
                        DesignObject dobj5 = mapping5.getObjectMappedTo(relation);
                        if (dobj5 == null || !(dobj5 instanceof FKIndexAssociation)) continue;
                        FKIndexAssociation fk = (FKIndexAssociation)dobj5;
                        FKContainer pkTable = fk.getRemoteTable();
                        if (pkTable != pktab) {
                            if (!this.shouldDelete(fk)) continue;
                            relMapping.status = 3;
                            relMapping.deleted.add(dobj5);
                            continue;
                        }
                        relMapping.existing.add(dobj5);
                    }
                } else if (list.size() == 1 && pkEndPoints.length == 2) {
                    mapping = (XtdMapping)list.get(0);
                    dobj2 = mapping.getObjectMappedTo(relation);
                    if (dobj2 != null && dobj2 instanceof FKIndexAssociation) {
                        FKIndexAssociation fk = (FKIndexAssociation)dobj2;
                        FKContainer pkTable = fk.getRemoteTable();
                        for (int i = 0; i < pkEndPoints.length; ++i) {
                            Entity ent2 = relation.getEntity(pkEndPoints[i]);
                            Table pktab2 = null;
                            if (ent2 == sourceEntity) {
                                pktab2 = sourceTable;
                            } else if (ent2 == targetEntity) {
                                pktab2 = targetTable;
                            }
                            if (pkTable != pktab2) {
                                relMapping.newStrings.add(NEW_FK);
                                continue;
                            }
                            relMapping.existing.add(dobj2);
                        }
                    }
                } else if (list.size() == 1 && pkEndPoints.length == 1) {
                    ent = relation.getEntity(pkEndPoints[0]);
                    pktab = null;
                    if (ent == sourceEntity) {
                        pktab = sourceTable;
                    } else if (ent == targetEntity) {
                        pktab = targetTable;
                    }
                    XtdMapping mapping6 = (XtdMapping)list.get(0);
                    dobj = mapping6.getObjectMappedTo(relation);
                    if (dobj != null && dobj instanceof FKIndexAssociation) {
                        FKIndexAssociation fk = (FKIndexAssociation)dobj;
                        FKContainer pkTable = fk.getRemoteTable();
                        if (pkTable != pktab) {
                            if (this.shouldDelete(fk)) {
                                relMapping.deleted.add(dobj);
                            }
                        } else {
                            relMapping.existing.add(dobj);
                        }
                    }
                }
                list = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
                if ((list = this.getRelationMappingsFor(list, realSourceEntity, realTargetEntity)).size() != 0) break block41;
                for (int i = 0; i < pkEndPoints.length; ++i) {
                    relMapping.newStrings.add(NEW_FK);
                }
                break block41;
            }
            if (relation.isManyToMany()) {
                relMapping.newStrings.add(NEW_TABLE);
            } else {
                int[] pks = relation.getPKProviderEndPoint();
                for (int k = 0; k < pks.length; ++k) {
                    relMapping.newStrings.add(NEW_FK);
                }
            }
        }
    }

    boolean shouldDelete(DesignObject desObject) {
        return true;
    }

    private List getRelationMappingsFor(List mappings, Entity realSourceEntity, Entity realTargetEntity) {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : mappings) {
            if (!realSourceEntity.getObjectID().equals(mapping.getRealSourceEntityID()) || !realTargetEntity.getObjectID().equals(mapping.getRealTargetEntityID())) continue;
            list.add(mapping);
        }
        if (list.size() == 0) {
            for (XtdMapping mapping : mappings) {
                if (mapping.getRealSourceEntityID() != null || mapping.getRealTargetEntityID() != null) continue;
                list.add(mapping);
            }
        } else {
            return list;
        }
        if (list.size() != mappings.size()) {
            list.clear();
        }
        return list;
    }

    private void addEntitySubView(DPVLogicalSubView entitySubView, EngineeringObjectSelection allEntsel, EngineeringObjectSelection allTabsel) {
        EngineeringObjectSelection entsel = new EngineeringObjectSelection(entitySubView.getPlaceHolder());
        entsel.setSelected(entitySubView.getPlaceHolder().getShouldEngineer());
        DPVRelationalSubView tableSubView = ((DesignPartViewPlaceHolder)entitySubView.getPlaceHolder()).getEngTabSubView(this.phdes);
        EngineeringObjectSelection tabsel = null;
        if (tableSubView != null) {
            if (entitySubView.getPlaceHolder().shouldBeEngineered() || !entitySubView.getDesign().getExcludeFromTree()) {
                tabsel = new EngineeringObjectSelection(tableSubView.getPlaceHolder());
                EntitySubViewTableSubViewComparator comp = new EntitySubViewTableSubViewComparator((DesignPartViewPlaceHolder)entitySubView.getPlaceHolder(), (DesignPartViewPlaceHolder)tableSubView.getPlaceHolder());
                tabsel.setPropertiesComparator(comp);
                entsel.setPropertiesComparator(comp);
                tabsel.setSelected(comp.isModified());
                this.comparatorsMap.put(comp.getID(), comp);
                entsel.setCorrespondentNode(tabsel);
                tabsel.setCorrespondentNode(entsel);
                allTabsel.addChild(tabsel);
                allEntsel.addChild(entsel);
            }
        } else if (entitySubView.getPlaceHolder().shouldBeEngineered() || !entitySubView.getDesign().getExcludeFromTree()) {
            String name = "From_LM_" + entitySubView.getPlaceHolder();
            tabsel = new EngineeringObjectSelection(name);
            tabsel.setElementDescriptor(DesignPartViewPlaceHolder.class);
            XtdMapping del_mapping = ((DesignPartViewPlaceHolder)entitySubView.getPlaceHolder()).getDeletedMapping(this.phdes.getObjectID());
            if (del_mapping == null || !this.getDesign().isApplyNameStandardization()) {
                // empty if block
            }
            EntitySubViewTableSubViewComparator comp = new EntitySubViewTableSubViewComparator((DesignPartViewPlaceHolder)entitySubView.getPlaceHolder(), null);
            tabsel.setPropertiesComparator(comp);
            entsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            entsel.setStatus(2);
            tabsel.setStatus(2);
            entsel.setCorrespondentNode(tabsel);
            tabsel.setCorrespondentNode(entsel);
            allTabsel.addChild(tabsel);
            allEntsel.addChild(entsel);
        }
    }

    private void addDeletedEntitySubViews(EngineeringObjectSelection allEntsel, EngineeringObjectSelection allTabsel) {
        Iterator it = this.phdes.getPhysicalDesignSubviews().iterator();
        String objectID = this.ldes.getObjectID();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder tableHolder = (DesignPartViewPlaceHolder)it.next();
            XtdMapping mapping = tableHolder.getDeletedMapping(objectID);
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = tableHolder.getName();
            }
            EngineeringObjectSelection entsel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(entsel);
            entsel.setSelected(false);
            EngineeringObjectSelection tabsel = new EngineeringObjectSelection(tableHolder);
            entsel.setElementDescriptor(DPVLogicalSubView.class);
            this.setEmptyComparator(entsel);
            this.setEmptyComparator(tabsel);
            entsel.setStatus(3);
            tabsel.setStatus(3);
            tabsel.setCorrespondentNode(entsel);
            entsel.setCorrespondentNode(tabsel);
            allTabsel.addChild(tabsel);
            allEntsel.addChild(entsel);
        }
    }

    private List getEntitiesWitnMultiMappings() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity entity : this.entitylist) {
            if (entity.isHierarchicalEntityType()) continue;
            list.add(entity);
        }
        ExtendedMap xmap = this.ldes.getDesign().getExtendedMap();
        String phID = this.phdes.getObjectID();
        ArrayList<Entity> multi = new ArrayList<Entity>();
        for (Entity ent : list) {
            List mappings = xmap.getMappingsForDesignPart(ent, phID);
            if (mappings.size() <= 1) continue;
            multi.add(ent);
            this.multiMapped.put(ent.getObjectID(), ent);
        }
        return multi;
    }

    private void addFK_RelationAttributes(Relation rel, FKIndexAssociation fk, EngineeringObjectSelection relSel, EngineeringObjectSelection fkSel) {
        ArrayList rlist = new ArrayList(rel.getAttributesCollection());
        if (fk != null) {
            this.addARelationAttributes(rel, fk.getTable(), rlist, relSel, fkSel);
        } else {
            this.addARelationAttributes(rel, null, rlist, relSel, fkSel);
        }
    }

    private void addARelationAttributes(Relation rel, FKContainer table, List rlist, EngineeringObjectSelection logSel, EngineeringObjectSelection relObjSel) {
        RMExtendedMap xmap = this.phdes.getRMExtendedMap();
        if (rlist.size() > 0) {
            String tname = rel.getName();
            if (table != null) {
                tname = table.getName();
            }
            EngineeringObjectSelection tcols = new EngineeringObjectSelection(tname + " columns");
            String relname = NEW_RELATION;
            if (rel != null) {
                relname = rel.getName();
            }
            EngineeringObjectSelection rattrs = new EngineeringObjectSelection(relname + " attributes");
            rattrs.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
            tcols.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
            rattrs.setCorrespondentNode(tcols);
            tcols.setCorrespondentNode(rattrs);
            logSel.addChild(rattrs);
            relObjSel.addChild(tcols);
            this.setEmptyComparator(rattrs);
            this.setEmptyComparator(tcols);
            for (Attribute attr : rlist) {
                Column col = (Column)attr.getEngColumn(this.phdes);
                XtdMapping mapping = null;
                if (col != null) {
                    mapping = xmap.getMapping(attr, col);
                }
                EngineeringObjectSelection colsel = null;
                EngineeringObjectSelection attrsel = new EngineeringObjectSelection((ModelIDObject)attr, mapping);
                if (col == null) {
                    String name = this.getDesign().transformNameFromLogicalToRelational(attr);
                    colsel = new EngineeringObjectSelection(name);
                    attrsel.setStatus(2);
                    colsel.setStatus(2);
                    AttributeColumnComparator comp = new AttributeColumnComparator(attr, col, attr.getDesign().getAttrColPropertyList());
                    colsel.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_ICON"));
                    colsel.setPropertiesComparator(comp);
                    attrsel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                } else {
                    colsel = new EngineeringObjectSelection(col);
                    AttributeColumnComparator comp = new AttributeColumnComparator(attr, col, attr.getDesign().getAttrColPropertyList());
                    colsel.setPropertiesComparator(comp);
                    attrsel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                }
                colsel.setCorrespondentNode(attrsel);
                attrsel.setCorrespondentNode(colsel);
                rattrs.addChild(attrsel);
                tcols.addChild(colsel);
            }
        }
    }

    class RelationMapping {
        Entity sourceEntity;
        Entity targetEntity;
        int pkNumber = 1;
        int status = 0;
        List deleted = new ArrayList();
        List newStrings = new ArrayList();
        List existing = new ArrayList();
        boolean many = false;

        RelationMapping(Entity sent, Entity tent) {
            this.sourceEntity = sent;
            this.targetEntity = tent;
        }
    }
}

