/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.ColumnAttributeComparator;
import oracle.dbtools.crest.model.design.engineering.DesignObjectComparator;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.engineering.FK_RelationComparator;
import oracle.dbtools.crest.model.design.engineering.IndexKeyComparator;
import oracle.dbtools.crest.model.design.engineering.TableEntityComparator;
import oracle.dbtools.crest.model.design.engineering.TableSubviewEntitySubviewComparator;
import oracle.dbtools.crest.model.design.engineering.TableViewEntityViewComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;

public class RE_RelationalToLogical
extends EngineeringObjectSelection {
    private static String NO_ENGINEERING = "no engineering";
    private RelationalDesign phdes;
    LogicalDesign ldes;
    private EngineeringObjectSelection logicalRoot;
    private Map comparatorsMap = new TreeMap();
    private List deletedMappings = new ArrayList();
    private Map multiMapped = new TreeMap();
    private List tablelist = new ArrayList();
    private List fkeys = new ArrayList();
    private List tableViewList = new ArrayList();
    DesignPartView dpv;
    private boolean entireRelational = true;

    public RE_RelationalToLogical(RelationalDesign phdes, DesignPartView dpv) {
        super(phdes.getName());
        this.setDesign(phdes.getDesign());
        this.phdes = phdes;
        this.dpv = dpv;
        this.setName(phdes.getName());
        this.ldes = phdes.getDesign().getLogicalDesign();
        this.logicalRoot = new EngineeringObjectSelection(this.ldes.getName());
        this.logicalRoot.setName(this.ldes.getName());
        this.setCorrespondentNode(this.logicalRoot);
        this.logicalRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.logicalRoot);
        if (dpv == null || dpv == phdes.getMainView()) {
            phdes.getTableSet().addAllElementsTo(this.tablelist);
            phdes.getFKIndexAssociationSet().addAllElementsTo(this.fkeys);
            phdes.getTableViewSet().addAllElementsTo(this.tableViewList);
            this.entireRelational = true;
        } else {
            FKContainer ent;
            this.entireRelational = false;
            Iterator it = phdes.getTableSet().iterator();
            while (it.hasNext()) {
                ent = (Table)it.next();
                if (ent.getFirstViewForDPV(dpv) == null) continue;
                this.tablelist.add(ent);
            }
            it = phdes.getFKIndexAssociationSet().iterator();
            while (it.hasNext()) {
                FKIndexAssociation rel = (FKIndexAssociation)it.next();
                if (rel.getFirstViewForDPV(dpv) == null) continue;
                this.fkeys.add(rel);
            }
            it = phdes.getTableViewSet().iterator();
            while (it.hasNext()) {
                ent = (TableView)it.next();
                if (ent.getFirstViewForDPV(dpv) == null) continue;
                this.tableViewList.add(ent);
            }
        }
        this.addFromRelationalModel();
    }

    private void setEmptyComparator(EngineeringObjectSelection node) {
        node.setPropertiesComparator(new EngEmptyPropertiesComparator(null, null));
    }

    private void addTableMulti(Table table, EngineeringObjectSelection allTabsel, EngineeringObjectSelection allEntsel, boolean details) {
        String logID = this.ldes.getObjectID();
        List mappings = this.ldes.getDesign().getExtendedMap().getMappingsForDesignPart(table, logID);
        for (XtdMapping mapping : mappings) {
            EngPropertiesComparator comp;
            DesignObject obj = mapping.getObjectMappedTo(table);
            if (!(obj instanceof Entity)) continue;
            EngineeringObjectSelection tabsel = new EngineeringObjectSelection((ModelIDObject)table, mapping);
            Entity entity = (Entity)obj;
            EngineeringObjectSelection entsel = null;
            Relation rel = table.getEngRelation();
            if (entity != null) {
                entsel = new EngineeringObjectSelection(entity);
                comp = new TableEntityComparator(table, entity, table.getDesign().getEntTablePropertyList());
                tabsel.setPropertiesComparator(comp);
                entsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
            } else if (rel != null || table.shouldEngineerToRelation()) {
                if (rel == null) {
                    entsel = new EngineeringObjectSelection(NEW_RELATION);
                    tabsel.setStatus(2);
                    entsel.setStatus(2);
                    comp = new DesignObjectComparator(table, rel, table.getDesign().getRelTablePropertyList());
                    tabsel.setPropertiesComparator(comp);
                    entsel.setPropertiesComparator(comp);
                } else {
                    entsel = new EngineeringObjectSelection(rel);
                    tabsel.setStatus(0);
                    entsel.setStatus(0);
                    comp = new DesignObjectComparator(table, rel, table.getDesign().getRelTablePropertyList());
                    tabsel.setPropertiesComparator(comp);
                    entsel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                }
                entsel.setElementDescriptor(Relation.class);
            } else if (rel == null && !table.shouldEngineerToRelation()) {
                String newName = this.getDesign().transformNameFromRelationalToLogical(table);
                entsel = new EngineeringObjectSelection(newName);
                tabsel.setStatus(2);
                entsel.setStatus(2);
                entsel.setElementDescriptor(Entity.class);
                TableEntityComparator comp2 = new TableEntityComparator(table, entity, table.getDesign().getEntTablePropertyList());
                tabsel.setPropertiesComparator(comp2);
                entsel.setPropertiesComparator(comp2);
                this.comparatorsMap.put(comp2.getID(), comp2);
            }
            entsel.setCorrespondentNode(tabsel);
            tabsel.setCorrespondentNode(entsel);
            if (details && table != null && rel == null) {
                this.addTableDetails(table, tabsel, entity, entsel, mapping);
            }
            allTabsel.addChild(tabsel);
            allEntsel.addChild(entsel);
        }
    }

    private void addTable(Table table, EngineeringObjectSelection allTabsel, EngineeringObjectSelection allEntsel, boolean details) {
        List list = table.getMappingsToEntities();
        int ind = 0;
        do {
            EngPropertiesComparator comp;
            XtdMapping mapping = null;
            DesignObject obj = null;
            if (ind < list.size() && !((obj = (mapping = (XtdMapping)list.get(ind)).getObjectMappedTo(table)) instanceof Entity)) {
                ++ind;
                continue;
            }
            ++ind;
            EngineeringObjectSelection tabsel = new EngineeringObjectSelection((ModelIDObject)table, mapping);
            tabsel.setSelected(table.getShouldEngineer());
            Entity entity = (Entity)obj;
            EngineeringObjectSelection entsel = null;
            Relation rel = table.getEngRelation();
            if (list.size() > 0 && entity != null) {
                if (table == null || !table.shouldBeEngineered() && table.getDesign().getExcludeFromTree()) continue;
                entsel = new EngineeringObjectSelection(entity);
                comp = null;
                comp = entity.isHierarchicalEntityType() && mapping != null && mapping.getInheritanceType() != 3 ? new EngEmptyPropertiesComparator(table, entity) : new TableEntityComparator(table, entity, table.getDesign().getEntTablePropertyList());
                tabsel.setPropertiesComparator(comp);
                entsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                entsel.setCorrespondentNode(tabsel);
                tabsel.setCorrespondentNode(entsel);
                if (details) {
                    this.addTableDetails(table, tabsel, entity, entsel, mapping);
                } else {
                    this.addTable_RelationAttributes(rel, table, entsel, tabsel);
                }
                allTabsel.addChild(tabsel);
                allEntsel.addChild(entsel);
                if (mapping.getInheritanceType() <= 0) continue;
                if (mapping.getInheritanceType() == 1) {
                    if (!entity.getFwdEngineeringStrategyName().equals("Single Table")) continue;
                    if (entity.isHierarchicalRoot()) {
                        tabsel.setSelectedNoPropagateSelection(true);
                        continue;
                    }
                    tabsel.setSelectedNoPropagateSelection(false);
                    continue;
                }
                if (mapping.getInheritanceType() != 2 || !entity.getFwdEngineeringStrategyName().equals("Table per child")) continue;
                if (entity.getHierarchicalChildrenCount() == 0) {
                    tabsel.setSelectedNoPropagateSelection(true);
                    continue;
                }
                tabsel.setSelectedNoPropagateSelection(false);
                continue;
            }
            if (rel != null || table.shouldEngineerToRelation()) {
                if (rel == null) {
                    entsel = new EngineeringObjectSelection(NEW_RELATION);
                    tabsel.setStatus(2);
                    entsel.setStatus(2);
                    comp = new DesignObjectComparator(table, rel, table.getDesign().getRelTablePropertyList());
                    tabsel.setPropertiesComparator(comp);
                    entsel.setPropertiesComparator(comp);
                } else if (rel.shouldBeEngineered() || !rel.getDesign().getExcludeFromTree()) {
                    entsel = new EngineeringObjectSelection(rel);
                    tabsel.setStatus(0);
                    entsel.setStatus(0);
                    comp = new DesignObjectComparator(table, rel, table.getDesign().getRelTablePropertyList());
                    tabsel.setPropertiesComparator(comp);
                    entsel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                }
                if (entsel != null) {
                    entsel.setElementDescriptor(Relation.class);
                    entsel.setCorrespondentNode(tabsel);
                    tabsel.setCorrespondentNode(entsel);
                }
                if (details) {
                    if (table != null) {
                        // empty if block
                    }
                } else {
                    this.addTable_RelationAttributes(rel, table, entsel, tabsel);
                }
                allTabsel.addChild(tabsel);
                allEntsel.addChild(entsel);
                continue;
            }
            if (rel != null || table.shouldEngineerToRelation() || !table.shouldBeEngineered() && table.getDesign().getExcludeFromTree()) continue;
            String newName = this.getDesign().transformNameFromRelationalToLogical(table);
            entsel = new EngineeringObjectSelection(newName);
            tabsel.setStatus(2);
            entsel.setStatus(2);
            entsel.setElementDescriptor(Entity.class);
            TableEntityComparator comp2 = new TableEntityComparator(table, entity, table.getDesign().getEntTablePropertyList());
            tabsel.setPropertiesComparator(comp2);
            entsel.setPropertiesComparator(comp2);
            this.comparatorsMap.put(comp2.getID(), comp2);
            entsel.setCorrespondentNode(tabsel);
            tabsel.setCorrespondentNode(entsel);
            if (details && table != null) {
                this.addTableDetails(table, tabsel, entity, entsel, mapping);
            }
            allTabsel.addChild(tabsel);
            allEntsel.addChild(entsel);
        } while (ind < list.size());
    }

    private void addTableView(TableView tableView, EngineeringObjectSelection allTabViewSel, EngineeringObjectSelection allEntViewSel) {
        EngineeringObjectSelection tabViewSel = new EngineeringObjectSelection(tableView);
        tabViewSel.setSelected(tableView.getShouldEngineer());
        EntityView entityView = tableView.getEngEntityView();
        EngineeringObjectSelection entViewSel = null;
        if (entityView != null) {
            if (tableView.getShouldEngineer() || !tableView.getDesign().getExcludeFromTree()) {
                entViewSel = new EngineeringObjectSelection(entityView);
                TableViewEntityViewComparator comp = new TableViewEntityViewComparator(tableView, entityView, tableView.getDesign().getViewPropertyList());
                tabViewSel.setPropertiesComparator(comp);
                entViewSel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                entViewSel.setCorrespondentNode(tabViewSel);
                tabViewSel.setCorrespondentNode(entViewSel);
                allTabViewSel.addChild(tabViewSel);
                allEntViewSel.addChild(entViewSel);
            }
        } else if (tableView.getShouldEngineer() || !tableView.getDesign().getExcludeFromTree()) {
            String name = this.getDesign().transformNameFromRelationalToLogical(tableView);
            entViewSel = new EngineeringObjectSelection(name);
            entViewSel.setElementDescriptor(EntityView.class);
            TableViewEntityViewComparator comp = new TableViewEntityViewComparator(tableView, entityView, tableView.getDesign().getViewPropertyList());
            tabViewSel.setPropertiesComparator(comp);
            entViewSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            tabViewSel.setStatus(2);
            entViewSel.setStatus(2);
            entViewSel.setCorrespondentNode(tabViewSel);
            tabViewSel.setCorrespondentNode(entViewSel);
            allTabViewSel.addChild(tabViewSel);
            allEntViewSel.addChild(entViewSel);
        }
    }

    private void addFK(FKIndexAssociation fk, EngineeringObjectSelection allFKsel, EngineeringObjectSelection allRelsel) {
        if (fk.getEngInheritanceRelation() != null) {
            return;
        }
        FKContainer remoteTable = fk.getRemoteTable();
        if (remoteTable instanceof Table) {
            EngineeringObjectSelection fksel = new EngineeringObjectSelection(fk);
            String fkname = fk.getName() + " (" + fk.getContainerWithKeyObject().getName() + " : " + remoteTable.getName() + " )";
            fksel.setName(fkname);
            fksel.setSelected(fk.getShouldEngineer());
            Relation relation = fk.getEngRelation();
            EngineeringObjectSelection relsel = null;
            if (fk.shouldBeEngineered() || !fk.getDesign().getExcludeFromTree()) {
                if (relation != null) {
                    relsel = new EngineeringObjectSelection(relation);
                    FK_RelationComparator comp = new FK_RelationComparator(fk, relation, fk.getDesign().getRelFKPropertyList());
                    fksel.setPropertiesComparator(comp);
                    relsel.setPropertiesComparator(comp);
                    Entity ent1 = ((Table)fk.getContainerWithKeyObject()).getEngEntity();
                    Entity ent2 = ((Table)remoteTable).getEngEntity();
                    if (ent1 != null && ent2 != null) {
                        String rname = relation.getName() + " (" + ent1.getName() + " : " + ent2.getName() + ")";
                        relsel.setName(rname);
                    }
                    this.comparatorsMap.put(comp.getID(), comp);
                    relsel.setCorrespondentNode(fksel);
                    fksel.setCorrespondentNode(relsel);
                    allFKsel.addChild(fksel);
                    allRelsel.addChild(relsel);
                    this.addFK_RelationAttributes(relation, fk, relsel, fksel);
                } else {
                    relsel = new EngineeringObjectSelection(NEW_RELATION);
                    fksel.setStatus(2);
                    relsel.setStatus(2);
                    relsel.setElementDescriptor(Relation.class);
                    DesignObjectComparator comp = new DesignObjectComparator(fk, relation, fk.getDesign().getRelFKPropertyList());
                    fksel.setPropertiesComparator(comp);
                    relsel.setPropertiesComparator(comp);
                    relsel.setCorrespondentNode(fksel);
                    fksel.setCorrespondentNode(relsel);
                    allFKsel.addChild(fksel);
                    allRelsel.addChild(relsel);
                    this.addFK_RelationAttributes(relation, fk, relsel, fksel);
                }
            }
        }
    }

    private void addFromRelationalModel() {
        Table table;
        List list = this.getTablesWitnMultiMappings();
        if (list.size() > 0) {
            EngFilteredSelection allTabsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.TablesWithMultipleMappings"));
            allTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
            EngFilteredSelection allEntsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Entities"));
            allEntsel.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
            allTabsel.setCorrespondentNode(allEntsel);
            allEntsel.setCorrespondentNode(allTabsel);
            this.setEmptyComparator(allTabsel);
            this.setEmptyComparator(allEntsel);
            for (Table table2 : list) {
                this.addTableMulti(table2, allTabsel, allEntsel, true);
            }
            this.addChild(allTabsel);
            this.logicalRoot.addChild(allEntsel);
        }
        Iterator it = this.getTablesToNoneHierarchicalEntity().iterator();
        EngFilteredSelection allTabsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Tables"));
        allTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        EngFilteredSelection allEntsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Entities"));
        allEntsel.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
        EngFilteredSelection allTabViewSel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Views"));
        allTabViewSel.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        EngFilteredSelection allEntViewSel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Views"));
        allEntViewSel.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        EngFilteredSelection allTabSubviewSel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Subviews"));
        allTabSubviewSel.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        EngFilteredSelection allEntSubviewSel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Subviews"));
        allEntSubviewSel.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        allTabsel.setCorrespondentNode(allEntsel);
        allEntsel.setCorrespondentNode(allTabsel);
        allTabViewSel.setCorrespondentNode(allEntViewSel);
        allEntViewSel.setCorrespondentNode(allTabViewSel);
        allTabSubviewSel.setCorrespondentNode(allEntSubviewSel);
        allEntSubviewSel.setCorrespondentNode(allTabSubviewSel);
        this.setEmptyComparator(allEntsel);
        this.setEmptyComparator(allEntViewSel);
        this.setEmptyComparator(allEntSubviewSel);
        allEntsel.setSelected(false);
        allEntViewSel.setSelected(false);
        allEntSubviewSel.setSelected(false);
        this.setEmptyComparator(allTabsel);
        this.setEmptyComparator(allTabViewSel);
        this.setEmptyComparator(allTabSubviewSel);
        while (it.hasNext()) {
            table = (Table)it.next();
            this.addTable(table, allTabsel, allEntsel, true);
        }
        for (TableView tableView : this.tableViewList) {
            this.addTableView(tableView, allTabViewSel, allEntViewSel);
        }
        if (this.entireRelational) {
            it = this.phdes.getPhysicalDesignSubviews().iterator();
            while (it.hasNext()) {
                DesignPartViewPlaceHolder dpvHolder = (DesignPartViewPlaceHolder)it.next();
                DPVRelationalSubView physSubView = (DPVRelationalSubView)dpvHolder.getDesignPartView();
                this.addTableSubView(physSubView, allTabSubviewSel, allEntSubviewSel);
            }
            this.addDeletedTables(allTabsel, allEntsel);
        }
        this.addChild(allTabsel);
        this.logicalRoot.addChild(allEntsel);
        it = this.getTablesMappetToRelations().iterator();
        allTabsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.TablesMappedToRelations"));
        allTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        allEntsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Relations"));
        allEntsel.setIcon(GUIConfiguration.getInstance().getIcon("ONE_TO_N_RELATION_ICON"));
        allTabsel.setCorrespondentNode(allEntsel);
        allEntsel.setCorrespondentNode(allTabsel);
        this.setEmptyComparator(allEntsel);
        allEntsel.setSelected(false);
        this.setEmptyComparator(allTabsel);
        while (it.hasNext()) {
            table = (Table)it.next();
            this.addTable(table, allTabsel, allEntsel, false);
        }
        this.addChild(allTabsel);
        this.logicalRoot.addChild(allEntsel);
        it = this.getTablesToEntHierarchies().iterator();
        allTabsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.TablesMappedToHierarchies"));
        allTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        allEntsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.EntitiesHierarchies"));
        allEntsel.setIcon(GUIConfiguration.getInstance().getIcon("HIERARCHY_ICON"));
        allTabsel.setCorrespondentNode(allEntsel);
        allEntsel.setCorrespondentNode(allTabsel);
        this.setEmptyComparator(allEntsel);
        allEntsel.setSelected(false);
        this.setEmptyComparator(allTabsel);
        while (it.hasNext()) {
            table = (Table)it.next();
            this.addTable(table, allTabsel, allEntsel, true);
        }
        this.addChild(allTabsel);
        this.logicalRoot.addChild(allEntsel);
        it = this.fkeys.iterator();
        allTabsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.References"));
        allTabsel.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        allEntsel = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Relations"));
        allEntsel.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        allTabsel.setCorrespondentNode(allEntsel);
        allEntsel.setCorrespondentNode(allTabsel);
        this.setEmptyComparator(allEntsel);
        allEntsel.setSelected(false);
        this.setEmptyComparator(allTabsel);
        while (it.hasNext()) {
            Table cont;
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            FKContainer con = fk.getTable();
            if (!(con instanceof Table) || (cont = (Table)con).shouldEngineerToRelation() || cont.getEngRelation() != null) continue;
            this.addFK(fk, allTabsel, allEntsel);
        }
        this.addChild(allTabsel);
        this.logicalRoot.addChild(allEntsel);
        this.addChild(allTabViewSel);
        this.logicalRoot.addChild(allEntViewSel);
        if (this.entireRelational) {
            this.addDeletedForeignKeys(allTabsel, allEntsel);
            this.addDeletedTableViews(allTabViewSel, allEntViewSel);
        }
        if (this.entireRelational) {
            this.addDeletedTableSubViews(allTabSubviewSel, allEntSubviewSel);
            this.addChild(allTabSubviewSel);
            this.logicalRoot.addChild(allEntSubviewSel);
        }
    }

    private void addColumn(Column column, Entity entity, EngineeringObjectSelection columns_sel, EngineeringObjectSelection attributes_sel, XtdMapping entityMapping) {
        List mlist = column.getMappingsFor(entity);
        int ind = 0;
        do {
            XtdMapping cmapping = null;
            DesignObject obj = null;
            if (ind < mlist.size() && !((obj = (cmapping = (XtdMapping)mlist.get(ind)).getObjectMappedTo(column)) instanceof Attribute)) {
                ++ind;
                continue;
            }
            EngineeringObjectSelection colsel = new EngineeringObjectSelection(column, cmapping, entityMapping);
            EngineeringObjectSelection attrsel = null;
            Attribute attribute = null;
            if (entity != null && cmapping != null && (attribute = (Attribute)obj) != null) {
                attrsel = new EngineeringObjectSelection(attribute);
                ColumnAttributeComparator comp = new ColumnAttributeComparator(column, attribute, column.getDesign().getAttrColPropertyList());
                colsel.setPropertiesComparator(comp);
                attrsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                if (comp.isModified()) {
                    colsel.setSelected(true);
                }
            }
            if (attribute == null) {
                ColumnAttributeComparator comp;
                String name;
                List list;
                attribute = column.getEngAttribute();
                boolean hier = false;
                if (attribute != null && entity != null && entity.isHierarchicalEntityType()) {
                    hier = entity.hasHierarchicalRelationWith((Entity)attribute.getContainerWithKeyObject());
                }
                Attribute orig = null;
                if (!hier && (list = column.getDesign().getExtendedMap().getMappingsForDesignPart(column, column.getDesign().getLogicalDesign().getObjectID())).size() == 1) {
                    XtdMapping mapping = (XtdMapping)list.get(0);
                    hier = mapping.getInheritanceType() == 5;
                    DesignObject cobj = mapping.getObjectMappedTo(column);
                    if (obj instanceof Attribute) {
                        orig = (Attribute)cobj;
                    }
                }
                if (hier) {
                    name = NO_ENGINEERING;
                    attrsel = new EngineeringObjectSelection(name);
                    attrsel.setStatus(0);
                    colsel.setStatus(0);
                    colsel.setSelected(false);
                    comp = null;
                    comp = orig != null ? new ColumnAttributeComparator(column, orig, column.getDesign().getAttrColPropertyList()) : new ColumnAttributeComparator(column, attribute, column.getDesign().getAttrColPropertyList());
                    comp.setReadOnly(true);
                    colsel.setEditable(false);
                    colsel.setPropertiesComparator(comp);
                    attrsel.setPropertiesComparator(comp);
                } else {
                    name = this.getDesign().transformNameFromRelationalToLogical(column);
                    attrsel = new EngineeringObjectSelection(name);
                    attrsel.setStatus(2);
                    colsel.setStatus(2);
                    comp = new ColumnAttributeComparator(column, attribute, column.getDesign().getAttrColPropertyList());
                    colsel.setPropertiesComparator(comp);
                    attrsel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                }
                attrsel.setElementDescriptor(Attribute.class);
                if (entity == null || !this.getDesign().isApplyNameStandardization()) {
                    // empty if block
                }
            }
            colsel.setCorrespondentNode(attrsel);
            attrsel.setCorrespondentNode(colsel);
            columns_sel.addChild(colsel);
            attributes_sel.addChild(attrsel);
            ++ind;
        } while (ind < mlist.size());
    }

    private void addTableDetails(Table table, EngineeringObjectSelection tabParent, Entity entity, EngineeringObjectSelection entParent, XtdMapping entityMapping) {
        EngineeringObjectSelection columns_sel = new EngineeringObjectSelection(Messages.getString("RE_RelationalToLogical.Columns"));
        columns_sel.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        EngineeringObjectSelection attributes_sel = new EngineeringObjectSelection(Messages.getString("RE_RelationalToLogical.Attributes"));
        attributes_sel.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        columns_sel.setCorrespondentNode(attributes_sel);
        attributes_sel.setCorrespondentNode(columns_sel);
        this.setEmptyComparator(columns_sel);
        this.setEmptyComparator(attributes_sel);
        attributes_sel.setSelected(false);
        for (Column column : table.getElementsCollection()) {
            FKElement cref = column.getReferencedColumn();
            if (column.isDiscriminatorColumn() || column.isSurrogateColumn() || column.getDependOnForeignKey() != null || cref != null && cref.isSurrogateColumn()) continue;
            this.addColumn(column, entity, columns_sel, attributes_sel, entityMapping);
        }
        if (entity != null) {
            this.addDeletedColumns(table, columns_sel, entity, attributes_sel);
        }
        tabParent.addChild(columns_sel);
        entParent.addChild(attributes_sel);
        EngineeringObjectSelection allIndsel = new EngineeringObjectSelection(Messages.getString("RE_RelationalToLogical.PKAndUKConstraints"));
        allIndsel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        EngineeringObjectSelection allKeySel = new EngineeringObjectSelection(Messages.getString("RE_RelationalToLogical.Keys"));
        allKeySel.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        allIndsel.setCorrespondentNode(allKeySel);
        allKeySel.setCorrespondentNode(allIndsel);
        this.setEmptyComparator(allIndsel);
        this.setEmptyComparator(allKeySel);
        allKeySel.setSelected(false);
        for (Index index : table.getPKandUKConstraints()) {
            if (index.isSurrogateKey()) continue;
            this.addIndex(index, entity, allIndsel, allKeySel, entityMapping);
        }
        if (entity != null) {
            this.addDeletedIndexes(table, allIndsel, entity, allKeySel);
        }
        tabParent.addChild(allIndsel);
        entParent.addChild(allKeySel);
    }

    private void addIndex(Index index, Entity entity, EngineeringObjectSelection allIndSel, EngineeringObjectSelection allKeySel, XtdMapping entityMapping) {
        XtdMapping imapping = index.getMappingFor(entity);
        EngineeringObjectSelection indsel = new EngineeringObjectSelection(index, imapping, entityMapping);
        EngineeringObjectSelection keysel = null;
        CandidateKey key = null;
        if (entity != null && (key = index.getEngCandidateKey(entity)) != null) {
            keysel = new EngineeringObjectSelection(key);
            IndexKeyComparator comp = new IndexKeyComparator(index, key, index.getDesign().getKeyIdxPropertyList());
            indsel.setPropertiesComparator(comp);
            keysel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        if (key == null || key != null && key.isPK() && entity.isHierarchicalEntityType()) {
            if (key == null) {
                key = index.getEngCandidateKey();
            }
            boolean hier = false;
            if (key != null && entity != null && entity.isHierarchicalEntityType()) {
                hier = entity.hasHierarchicalRelationWith((Entity)key.getContainerWithKeyObject());
            }
            if (hier) {
                keysel = new EngineeringObjectSelection(NO_ENGINEERING);
                keysel.setStatus(0);
                indsel.setStatus(0);
            } else {
                String newName = this.getDesign().transformNameFromRelationalToLogical(index);
                keysel = new EngineeringObjectSelection(newName);
                keysel.setStatus(2);
                indsel.setStatus(2);
            }
            keysel.setElementDescriptor(CandidateKey.class);
            if (entity != null) {
                // empty if block
            }
            IndexKeyComparator comp = new IndexKeyComparator(index, key, index.getDesign().getKeyIdxPropertyList());
            indsel.setPropertiesComparator(comp);
            keysel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            if (hier) {
                comp.setReadOnly(true);
                indsel.setSelected(false);
                indsel.setEditable(false);
            }
        }
        indsel.setCorrespondentNode(keysel);
        keysel.setCorrespondentNode(indsel);
        allKeySel.addChild(keysel);
        allIndSel.addChild(indsel);
    }

    public EngineeringObjectSelection getRelationalRoot() {
        return this;
    }

    public EngineeringObjectSelection getLogicalRoot() {
        return this.logicalRoot;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    private void addDeletedColumns(Table table, EngineeringObjectSelection allColsel, Entity entity, EngineeringObjectSelection allAttrsel) {
        for (Attribute attribute : entity.getElementsCollection()) {
            XtdMapping mapping = attribute.getDeletedMapping(table);
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = attribute.getName();
            }
            EngineeringObjectSelection ncolsel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(ncolsel);
            ncolsel.setSelected(false);
            EngineeringObjectSelection attrsel = new EngineeringObjectSelection(attribute);
            ncolsel.setElementDescriptor(Column.class);
            this.setEmptyComparator(ncolsel);
            this.setEmptyComparator(attrsel);
            ncolsel.setStatus(3);
            attrsel.setStatus(3);
            attrsel.setCorrespondentNode(ncolsel);
            ncolsel.setCorrespondentNode(attrsel);
            allColsel.addChild(ncolsel);
            allAttrsel.addChild(attrsel);
        }
    }

    private void addDeletedIndexes(Table table, EngineeringObjectSelection allIndsel, Entity entity, EngineeringObjectSelection allCandKeysel) {
        Iterator it = entity.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            XtdMapping mapping = key.getDeletedMapping(table);
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = key.getName();
            }
            EngineeringObjectSelection indsel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(indsel);
            indsel.setSelected(false);
            EngineeringObjectSelection keysel = new EngineeringObjectSelection(key);
            indsel.setElementDescriptor(Index.class);
            this.setEmptyComparator(indsel);
            this.setEmptyComparator(keysel);
            indsel.setStatus(3);
            keysel.setStatus(3);
            keysel.setCorrespondentNode(indsel);
            indsel.setCorrespondentNode(keysel);
            allIndsel.addChild(indsel);
            allCandKeysel.addChild(keysel);
        }
    }

    private void addDeletedTables(EngineeringObjectSelection allTabsel, EngineeringObjectSelection alEntsel) {
        Iterator it = this.ldes.getEntitySet().iterator();
        String desPartID = this.phdes.getObjectID();
        while (it.hasNext()) {
            Table obj;
            Entity entity = (Entity)it.next();
            XtdMapping mapping = entity.getDeletedMapping(desPartID);
            if (mapping == null || (obj = entity.getEngTable(this.phdes)) != null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = entity.getName();
            }
            EngineeringObjectSelection tabsel = new EngineeringObjectSelection(name);
            tabsel.setElementDescriptor(Table.class);
            this.deletedMappings.add(tabsel);
            tabsel.setSelected(false);
            EngineeringObjectSelection entsel = new EngineeringObjectSelection(entity);
            this.setEmptyComparator(tabsel);
            this.setEmptyComparator(entsel);
            tabsel.setStatus(3);
            entsel.setStatus(3);
            entsel.setCorrespondentNode(tabsel);
            tabsel.setCorrespondentNode(entsel);
            allTabsel.addChild(tabsel);
            alEntsel.addChild(entsel);
        }
    }

    private void addDeletedForeignKeys(EngineeringObjectSelection allTabsel, EngineeringObjectSelection alEntsel) {
        Iterator it = this.ldes.getRelationSet().iterator();
        String desPartID = this.phdes.getObjectID();
        while (it.hasNext()) {
            Relation entity = (Relation)it.next();
            XtdMapping mapping = entity.getDeletedMapping(desPartID);
            if (mapping == null) continue;
            List list = entity.getEngObjects(this.phdes);
            if (mapping.getDeletedID() == null || list.size() != 0) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = entity.getName();
            }
            EngineeringObjectSelection tabsel = new EngineeringObjectSelection(name);
            tabsel.setElementDescriptor(FKIndexAssociation.class);
            this.deletedMappings.add(tabsel);
            tabsel.setSelected(false);
            EngineeringObjectSelection entsel = new EngineeringObjectSelection(entity);
            this.setEmptyComparator(tabsel);
            this.setEmptyComparator(entsel);
            tabsel.setStatus(3);
            entsel.setStatus(3);
            entsel.setCorrespondentNode(tabsel);
            tabsel.setCorrespondentNode(entsel);
            allTabsel.addChild(tabsel);
            alEntsel.addChild(entsel);
        }
    }

    private void addDeletedTableViews(EngineeringObjectSelection allTabViewSel, EngineeringObjectSelection alEntViewSel) {
        Iterator it = this.ldes.getEntityViewSet().iterator();
        String desPartID = this.phdes.getObjectID();
        while (it.hasNext()) {
            EntityView entityView = (EntityView)it.next();
            XtdMapping mapping = entityView.getDeletedMapping(desPartID);
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = entityView.getName();
            }
            EngineeringObjectSelection tabViewSel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(tabViewSel);
            tabViewSel.setSelected(false);
            EngineeringObjectSelection entViewSel = new EngineeringObjectSelection(entityView);
            tabViewSel.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(tabViewSel);
            this.setEmptyComparator(entViewSel);
            tabViewSel.setStatus(3);
            entViewSel.setStatus(3);
            entViewSel.setCorrespondentNode(tabViewSel);
            tabViewSel.setCorrespondentNode(entViewSel);
            allTabViewSel.addChild(tabViewSel);
            alEntViewSel.addChild(entViewSel);
        }
    }

    public List getDeletedMappings() {
        return this.deletedMappings;
    }

    private List getTablesToEntHierarchies() {
        ArrayList<Table> list = new ArrayList<Table>();
        for (Table table : this.tablelist) {
            Entity entity;
            Entity obj;
            if (this.multiMapped.get(table.getObjectID()) != null || (obj = table.getEngEntity()) == null || !(obj instanceof Entity) || !(entity = obj).isHierarchicalEntityType()) continue;
            list.add(table);
        }
        return list;
    }

    private List getTablesToNoneHierarchicalEntity() {
        ArrayList<Table> list = new ArrayList<Table>();
        for (Table table : this.tablelist) {
            DesignObject entity;
            DesignObject obj = table.getEngEntity();
            if (this.multiMapped.get(table.getObjectID()) != null) continue;
            if (obj == null) {
                obj = table.getEngRelation();
            }
            if (obj == null && !table.shouldEngineerToRelation()) {
                list.add(table);
                continue;
            }
            if (obj == null || !(obj instanceof Entity) || ((Entity)(entity = obj)).isHierarchicalEntityType()) continue;
            list.add(table);
        }
        return list;
    }

    private List getTablesWitnMultiMappings() {
        ArrayList<Table> list = new ArrayList<Table>();
        for (Table table : this.tablelist) {
            Entity entity;
            Entity obj = table.getEngEntity();
            if (obj == null && !table.shouldEngineerToRelation()) {
                list.add(table);
                continue;
            }
            if (obj == null || !(obj instanceof Entity) || (entity = obj).isHierarchicalEntityType()) continue;
            list.add(table);
        }
        ExtendedMap xmap = this.phdes.getDesign().getExtendedMap();
        String logID = this.phdes.getDesign().getLogicalDesign().getObjectID();
        ArrayList<Table> multi = new ArrayList<Table>();
        for (Table table : list) {
            List mappings = xmap.getMappingsForDesignPart(table, logID);
            if (mappings.size() <= 1) continue;
            multi.add(table);
            this.multiMapped.put(table.getObjectID(), table);
        }
        return multi;
    }

    private List getTablesMappetToRelations() {
        ArrayList<Table> list = new ArrayList<Table>();
        for (Table table : this.tablelist) {
            if (this.multiMapped.get(table.getObjectID()) != null) continue;
            DesignObject obj = table.getEngEntity();
            if (obj != null) {
                if (!(obj instanceof Relation)) continue;
                list.add(table);
                continue;
            }
            obj = table.getEngRelation();
            if (obj != null && obj instanceof Relation) {
                list.add(table);
                continue;
            }
            if (obj != null || !table.shouldEngineerToRelation()) continue;
            list.add(table);
        }
        return list;
    }

    private void addTableSubView(DPVRelationalSubView tableSubview, EngineeringObjectSelection allTabSubviewSel, EngineeringObjectSelection allEntSubviewSel) {
        EngineeringObjectSelection tabSubviewSel = new EngineeringObjectSelection(tableSubview.getPlaceHolder());
        tabSubviewSel.setSelected(tableSubview.getPlaceHolder().getShouldEngineer());
        DPVLogicalSubView entitySubview = ((DesignPartViewPlaceHolder)tableSubview.getPlaceHolder()).getEngEntSubView(this.ldes);
        EngineeringObjectSelection entSubviewSel = null;
        if (entitySubview != null) {
            if (tableSubview.getPlaceHolder().shouldBeEngineered() || !tableSubview.getDesign().getExcludeFromTree()) {
                entSubviewSel = new EngineeringObjectSelection(entitySubview.getPlaceHolder());
                TableSubviewEntitySubviewComparator comp = new TableSubviewEntitySubviewComparator((DesignPartViewPlaceHolder)tableSubview.getPlaceHolder(), (DesignPartViewPlaceHolder)entitySubview.getPlaceHolder());
                tabSubviewSel.setPropertiesComparator(comp);
                entSubviewSel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                entSubviewSel.setCorrespondentNode(tabSubviewSel);
                tabSubviewSel.setCorrespondentNode(entSubviewSel);
                allTabSubviewSel.addChild(tabSubviewSel);
                allEntSubviewSel.addChild(entSubviewSel);
            }
        } else if (tableSubview.getPlaceHolder().shouldBeEngineered() || !tableSubview.getDesign().getExcludeFromTree()) {
            String newName = "From_RM_" + tableSubview.getPlaceHolder();
            entSubviewSel = new EngineeringObjectSelection(newName);
            entSubviewSel.setElementDescriptor(DesignPartViewPlaceHolder.class);
            TableSubviewEntitySubviewComparator comp = new TableSubviewEntitySubviewComparator((DesignPartViewPlaceHolder)tableSubview.getPlaceHolder(), null);
            tabSubviewSel.setPropertiesComparator(comp);
            entSubviewSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            tabSubviewSel.setStatus(2);
            entSubviewSel.setStatus(2);
            entSubviewSel.setCorrespondentNode(tabSubviewSel);
            tabSubviewSel.setCorrespondentNode(entSubviewSel);
            allTabSubviewSel.addChild(tabSubviewSel);
            allEntSubviewSel.addChild(entSubviewSel);
        }
    }

    private void addDeletedTableSubViews(EngineeringObjectSelection allTabSubviewSel, EngineeringObjectSelection allEntSubviewSel) {
        Iterator it = this.ldes.getLogicalDesignSubviews().iterator();
        String objectID = this.phdes.getObjectID();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder entityHolder = (DesignPartViewPlaceHolder)it.next();
            XtdMapping mapping = entityHolder.getDeletedMapping(objectID);
            if (mapping == null || mapping.getDeletedID() == null) continue;
            String name = mapping.getNameFor(mapping.getDeletedID());
            if (name == null || "".equals(name)) {
                name = entityHolder.getName();
            }
            EngineeringObjectSelection tabSubviewSel = new EngineeringObjectSelection(name);
            this.deletedMappings.add(tabSubviewSel);
            tabSubviewSel.setSelected(false);
            EngineeringObjectSelection entSubviewSel = new EngineeringObjectSelection(entityHolder);
            tabSubviewSel.setElementDescriptor(DesignPartViewPlaceHolder.class);
            this.setEmptyComparator(tabSubviewSel);
            this.setEmptyComparator(entSubviewSel);
            tabSubviewSel.setStatus(3);
            entSubviewSel.setStatus(3);
            entSubviewSel.setCorrespondentNode(tabSubviewSel);
            tabSubviewSel.setCorrespondentNode(entSubviewSel);
            allTabSubviewSel.addChild(tabSubviewSel);
            allEntSubviewSel.addChild(entSubviewSel);
        }
    }

    private void addTable_RelationAttributes(Relation rel, Table table, EngineeringObjectSelection relSel, EngineeringObjectSelection tabSel) {
        if (table.isMtoNjoinCandidate() || rel != null) {
            ArrayList<Column> rlist = new ArrayList<Column>();
            for (Column col : table.getElementsCollection()) {
                if (col.isPKElement() || col.isFKColumn()) continue;
                rlist.add(col);
            }
            this.addARelationAttributes(rel, table, rlist, relSel, tabSel);
        }
    }

    private void addFK_RelationAttributes(Relation rel, FKIndexAssociation fk, EngineeringObjectSelection relSel, EngineeringObjectSelection fkSel) {
        List rlist = fk.getTable().getColumnsDependinOn(fk);
        this.addARelationAttributes(rel, (Table)fk.getTable(), rlist, relSel, fkSel);
    }

    private void addARelationAttributes(Relation rel, Table table, List rlist, EngineeringObjectSelection relSel, EngineeringObjectSelection relObjSel) {
        RMExtendedMap xmap = table.getRelationalModel().getRMExtendedMap();
        if (rlist.size() > 0) {
            EngineeringObjectSelection tcols = new EngineeringObjectSelection(table.getName() + " columns");
            String relname = NEW_RELATION;
            if (rel != null) {
                relname = rel.getName();
            }
            EngineeringObjectSelection rattrs = new EngineeringObjectSelection(relname + " attributes");
            rattrs.setCorrespondentNode(tcols);
            tcols.setCorrespondentNode(rattrs);
            relSel.addChild(rattrs);
            relObjSel.addChild(tcols);
            this.setEmptyComparator(rattrs);
            this.setEmptyComparator(tcols);
            for (Column col : rlist) {
                Attribute attr = col.getEngAttribute();
                XtdMapping mapping = null;
                if (attr != null) {
                    mapping = xmap.getMapping(attr, col);
                }
                EngineeringObjectSelection colsel = new EngineeringObjectSelection((ModelIDObject)col, mapping);
                EngineeringObjectSelection attrsel = null;
                if (attr == null) {
                    String name = this.getDesign().transformNameFromRelationalToLogical(col);
                    attrsel = new EngineeringObjectSelection(name);
                    attrsel.setStatus(2);
                    colsel.setStatus(2);
                    ColumnAttributeComparator comp = new ColumnAttributeComparator(col, attr, col.getDesign().getAttrColPropertyList());
                    colsel.setPropertiesComparator(comp);
                    attrsel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                } else {
                    attrsel = new EngineeringObjectSelection(attr);
                    ColumnAttributeComparator comp = new ColumnAttributeComparator(col, attr, col.getDesign().getAttrColPropertyList());
                    colsel.setPropertiesComparator(comp);
                    attrsel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                }
                colsel.setCorrespondentNode(attrsel);
                attrsel.setCorrespondentNode(colsel);
                rattrs.addChild(attrsel);
                tcols.addChild(colsel);
            }
        }
    }
}

