/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.impact.ImpA_EntityView;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_TableView
extends ModelIdObjectSelection {
    private TableView view;

    public ImpA_TableView(TableView view, ModelIdObjectSelection parent) {
        super(view);
        this.loaded = false;
        this.view = view;
        this.setParent(parent);
        this.addViewNodes(this);
        this.addDependentViews();
    }

    private void addViewNodes(ImpA_TableView parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_TableView.Mappings"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        parent.addChild(selection);
        if (this.view.getObjectID() != null) {
            List list = this.view.getDesign().getExtendedMap().getMappingsForDesignPart(this.view, this.view.getDesign().getLogicalDesign().getObjectID());
            for (XtdMapping mapping : list) {
                EntityView entView = (EntityView)mapping.getObjectMappedTo(this.view);
                if (entView == null) continue;
                if (!selection.hasAsParent(entView)) {
                    selection.addChild(new ImpA_EntityView(entView, selection));
                    continue;
                }
                selection.addChild(new ModelIdObjectSelection(entView));
            }
        }
    }

    private void addDependentViews() {
        ModelIdObjectSelection viewSelection = new ModelIdObjectSelection(Messages.getString("ImpA_TableView.DependentViews"));
        viewSelection.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        this.addChild(viewSelection);
        Iterator it = this.view.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            TableView depView = (TableView)it.next();
            if (depView.getContainerHolderFor(this.view) == null) continue;
            if (!viewSelection.hasAsParent(depView)) {
                viewSelection.addChild(new ImpA_TableView(depView, viewSelection));
                continue;
            }
            viewSelection.addChild(new ModelIdObjectSelection(depView));
        }
    }
}

