/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.swingui.editor.process.RecordStructurePropertiesDialogEx;

public class RecordStructure
extends AbstractProcessObject {
    private List datas = new ArrayList();
    private List loadedDatas = new ArrayList();
    public static final String TYPE_NAME = "RecordStructure";

    public RecordStructure(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "RS";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RecordStructurePropertiesDialogEx dialog = new RecordStructurePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public void addExtData(ExternalData data) {
        if (!this.datas.contains(data)) {
            this.datas.add(data);
        }
    }

    public void removeExtData(ExternalData data) {
        this.datas.remove(data);
        data.remove();
    }

    public List getExtDatas() {
        return this.datas;
    }

    public ExternalData createExternalData() {
        ExternalData ed = ((ProcessModel)this.getDesignPart()).createExternalData();
        this.addExtData(ed);
        return ed;
    }

    public void addExtData(String dataID) {
        this.loadedDatas.add(dataID);
    }

    public void updatedExtDatas() {
        for (String dataID : this.loadedDatas) {
            ExternalData extData = (ExternalData)((ProcessModel)this.getDesignPart()).getExternalDataSet().getObjectByID(dataID);
            if (extData == null) continue;
            this.addExtData(extData);
            extData.setOwner(this);
        }
        this.loadedDatas.clear();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "recordstructure" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ExternalData getExternalDataByID(String id) {
        for (ExternalData ed : this.datas) {
            if (!ed.getObjectID().equals(id)) continue;
            return ed;
        }
        return null;
    }
}

