/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeSet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.FK_And_Delegate_Holder;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.editor.relational.ColumnPropertiesDialogEx;
import oracle.dbtools.crest.util.GUID;

public class Column
extends FKElement
implements ObjectListener,
ConstrainedObject,
StatementsConstants {
    public static final String TYPE_NAME = "Column";
    public static final String DISPLAY_AS_TEXT = "Text";
    public static final String DISPLAY_AS_COMBOBOX = "Combo Box";
    public static final String DISPLAY_AS_TEXTAREA = "Text Area";
    public static final String DISPLAY_AS_SELECTLIST = "Select List";
    public static final String DISPLAY_AS_RADIOGROUP = "Radio Group";
    public static final String DISPLAY_AS_CHECKBOX = "Checkbox";
    public static final String DISPLAY_AS_OTHER = "Other";
    public static final String[] DISPLAY_AS_INTERNAL = new String[]{"Text", "Text Area", "Select List", "Combo Box", "Radio Group", "Checkbox", "Other"};
    public static final String[] DISPLAY_AS_DISPLAY = new String[]{Messages.getString("Column.Text"), Messages.getString("Column.TextArea"), Messages.getString("Column.SelectList"), Messages.getString("Column.ComboBox"), Messages.getString("Column.RadioGroup"), Messages.getString("Column.Checkbox"), Messages.getString("Column.Other")};
    public static final String IDENTITY_GENERATION_ALWAYS = "ALWAYS";
    public static final String IDENTITY_GENERATION_BY_DEFAULT = "BY DEFAULT";
    public static final String IDENTITY_GENERATION_BY_DEFAULT_ON_NULL = "BY DEFAULT ON NULL";
    private static String REFERRED_COLUMN = "referredColumn";
    private static String FK_ASSOCIATION = "fkAssociation";
    private boolean previousColumn = true;
    private Collection allrefs = new ArrayList();
    private String fkAssociationId;
    private FKIndexAssociationReference fkAssociationReference;
    private String referencedColumnId;
    private FKElement delegate = null;
    private boolean realFKPlaceHolder = false;
    private boolean computed = false;
    private String abbreviation = "";
    String engAttributeID = "none";
    private String defaultLabel;
    private String defaultFormatMask;
    private Integer defaultFormDisplayWidth;
    private Integer defaultFormMaximumWidth;
    private Integer defaultFormHeight;
    private String defaultHelpText;
    private boolean defaultReadOnly;
    private boolean defaultDisplayedOnReports = true;
    private boolean defaultDisplayedOnForms = true;
    private String defaultDisplayAs = "Text";
    private Boolean containsPII;
    private Boolean containsSensitiveInformation;
    public static final String MT_NOT_DEFINED = "";
    public static final String MT_NO = "NO";
    public static final String MT_NONE = "NONE";
    public static final String MT_FULL = "FULL";
    public static final String MT_PARTIAL = "PARTIAL";
    public static final String MT_RANDOM = "RANDOM";
    public static final String MT_REGEXP = "REGEXP";
    public static final String MT_TEST = "TEST";
    public static final String[] MASKING_TYPES = new String[]{"", "FULL", "NO", "PARTIAL", "RANDOM", "REGEXP", "TEST"};
    private Boolean maskData;
    private String maskingType = "";
    private MaskTemplate maskTemplate = null;
    private boolean autoIncrementColumn;
    private boolean identityColumn;
    private boolean autoIncrementGenerateAlways = false;
    private String autoIncrementStartWith = "1";
    private Integer autoIncrementIncrementBy = 1;
    private String autoIncrementMinValue;
    private String autoIncrementMaxValue;
    private boolean autoIncrementCycle = false;
    private boolean autoIncrementDisableCache = true;
    private Integer autoIncrementCache;
    private boolean autoIncrementOrder = true;
    private boolean defaultOntNull = false;
    private String autoIncrementSequenceName;
    private String autoIncrementTriggerName;
    private boolean autoIncrementGenerateTrigger = true;
    private boolean discriminatorColumn = false;
    private boolean isSurrogateColumn = false;
    private boolean isRelationshipColumn = false;
    private FKIndexAssociation dependOnForeignKey;
    private String dependOnForeignKeyID = "";
    private boolean dependOnFK_Mandatory = false;
    private List<DependentColumnDescriptor> dependentColumns;
    private boolean notNullConstraintNameFixed = false;
    private boolean checkConstraintNameFixed = false;
    private String notNullConstraintName;
    private String generateConstraintInDDL = "YES";
    public static final String NAME_IS_FROZEN = "Name is frozen";
    List checkedCols;

    public Column(DesignPart designPart) {
        super(designPart);
    }

    public Column(DesignPart designPart, FKElement refColumn, FKIndexAssociationReference fkReference) {
        super(designPart);
        this.fkAssociationReference = fkReference;
        this.referencedColumnId = refColumn.getObjectID();
        FKElement.FKColRefNode ref = new FKElement.FKColRefNode(this);
        ref.fkAssociationRef = fkReference;
        ref.refColumnId = refColumn.getObjectID();
        this.allrefs.add(ref);
        this.setPreviousColumn(false);
    }

    public Column(DesignPart designPart, FKElement refColumn, FKIndexAssociation fkAssoc) {
        super(designPart);
        this.fkAssociationId = fkAssoc.getObjectID();
        this.referencedColumnId = refColumn.getObjectID();
        FKElement.FKColRefNode ref = new FKElement.FKColRefNode(this);
        ref.fkAssocId = fkAssoc.getObjectID();
        ref.refColumnId = refColumn.getObjectID();
        this.allrefs.add(ref);
        this.setPreviousColumn(false);
    }

    @Override
    public void addFKAssociation(FKElement refColumn, FKIndexAssociation fkAssociation) {
        String fkId = fkAssociation.getObjectID();
        String rfColId = refColumn.getObjectID();
        this.addFKAssociation(rfColId, fkId);
    }

    @Override
    public void addFKAssociation(String rfColId, String fkId) {
        if (this.allrefs.size() == 0) {
            this.fkAssociationId = fkId;
            this.referencedColumnId = rfColId;
        }
        boolean added = false;
        for (FKElement.FKColRefNode ref : this.allrefs) {
            if (ref.fkAssocId.equalsIgnoreCase(fkId)) {
                ref.refColumnId = rfColId;
                added = true;
                continue;
            }
            if (ref.fkAssociationRef == null || !fkId.equalsIgnoreCase(ref.fkAssociationRef.getObject().getObjectID())) continue;
            ref.refColumnId = rfColId;
            added = true;
        }
        if (!added) {
            FKElement.FKColRefNode ref;
            ref = new FKElement.FKColRefNode(this);
            ref.fkAssocId = fkId;
            ref.refColumnId = rfColId;
            this.allrefs.add(ref);
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("column id prefix");
    }

    @Override
    public boolean isFKColumn() {
        return this.getAssociationsCount() > 0;
    }

    @Override
    public boolean isFKElement() {
        return this.isFKColumn();
    }

    public FKIndexAssociation getFKIndexAssociation() {
        FKIndexAssociation fk = null;
        if (this.fkAssociationId != null) {
            fk = this.getFKIndexAssociation(this.fkAssociationId);
        }
        if (fk != null) {
            return fk;
        }
        if (this.allrefs.size() > 0) {
            for (FKElement.FKColRefNode rnode : this.allrefs) {
                if (rnode.fkAssocId != null && (fk = this.getFKIndexAssociation(rnode.fkAssocId)) != null) {
                    return fk;
                }
                if (rnode.fkAssociationRef == null) continue;
                if (rnode.fkAssociationRef.getObject() != null) {
                    fk = this.getFKIndexAssociation(rnode.fkAssociationRef.getObject().getObjectID());
                }
                if (fk == null) continue;
                return fk;
            }
        }
        return null;
    }

    public boolean isFKPlaceHolderColumn() {
        return this.isRealFKPlaceHolder() && !this.isAdapterLoaded();
    }

    public boolean isAdapter() {
        return false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isPreviousColumn() {
        return this.previousColumn;
    }

    public void setPreviousColumn(boolean previousColumn) {
        this.previousColumn = previousColumn;
    }

    @Override
    public int getAssociationsCount() {
        return this.allrefs.size();
    }

    @Override
    public boolean isReferingTo(FKElement delegate) {
        Iterator it = this.allrefs.iterator();
        String delegateId = delegate.getObjectID();
        while (it.hasNext()) {
            FKElement.FKColRefNode node = (FKElement.FKColRefNode)it.next();
            if (node.refColumnId == null || delegate == null || !node.refColumnId.equalsIgnoreCase(delegateId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReferingTo(FKIndexAssociation fk, FKElement delegate) {
        String fkid = fk.getObjectID();
        Iterator it = this.allrefs.iterator();
        String delegateId = delegate.getObjectID();
        while (it.hasNext()) {
            FKElement.FKColRefNode node = (FKElement.FKColRefNode)it.next();
            if (node.refColumnId == null || delegate == null || !node.refColumnId.equalsIgnoreCase(delegateId) || !fkid.equals(node.fkAssocId)) continue;
            return true;
        }
        return false;
    }

    public void removeReferencesTo(Column delegate) {
        FKElement.FKColRefNode[] arr = this.allrefs.toArray(new FKElement.FKColRefNode[0]);
        String delegateId = delegate.getObjectID();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].refColumnId == null || !arr[i].refColumnId.equalsIgnoreCase(delegateId)) continue;
            if (arr[i].fkAssocId != null) {
                this.removeFKAssociation(arr[i].fkAssocId);
                continue;
            }
            if (arr[i].fkAssociationRef == null) continue;
            this.removeFKAssociation(arr[i].fkAssociationRef);
        }
    }

    public FKElement getReferencedColumn() {
        FKIndexAssociation fkass;
        if (this.referencedColumnId != null && this.fkAssociationId != null && (fkass = this.getFKIndexAssociation(this.fkAssociationId)) != null && fkass.getRemoteTable() != null) {
            return (FKElement)fkass.getRemoteTable().getElementByID(this.referencedColumnId);
        }
        return null;
    }

    @Override
    public FKElement getReferencedColumn(FKIndexAssociation fkAssoc) {
        Iterator it = this.allrefs.iterator();
        String id = fkAssoc.getObjectID();
        while (it.hasNext()) {
            FKContainer remoteTable;
            FKIndexAssociation fkass;
            FKElement.FKColRefNode rnode = (FKElement.FKColRefNode)it.next();
            if (!rnode.fkAssocId.equalsIgnoreCase(id) || rnode.refColumnId == null || (fkass = this.getFKIndexAssociation(rnode.fkAssocId)) == null || (remoteTable = fkass.getRemoteTable()) == null) continue;
            return (FKElement)remoteTable.getElementByID(rnode.refColumnId);
        }
        return null;
    }

    public FKIndexAssociation getAssocToColumn(FKElement refColumn) {
        FKElement.FKColRefNode[] arr = this.allrefs.toArray(new FKElement.FKColRefNode[0]);
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].refColumnId.equalsIgnoreCase(refColumn.getObjectID())) continue;
            if (arr[i].fkAssocId != null) {
                return this.getFKIndexAssociation(arr[i].fkAssocId);
            }
            if (arr[i].fkAssociationRef == null) continue;
            return (FKIndexAssociation)arr[i].fkAssociationRef.getObject();
        }
        return null;
    }

    @Override
    public Collection getRefColAndAssocIDs() {
        for (FKElement.FKColRefNode snode : this.allrefs) {
            KeyObject remoteKey;
            FKContainer remoteTable;
            FKIndexAssociation fkass;
            snode.remoteTableId = "null";
            snode.remoteKeyId = "null";
            if (snode.fkAssocId != null) {
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
                if (fkass == null) continue;
                remoteTable = fkass.getRemoteTable();
                if (remoteTable != null) {
                    snode.remoteTableId = remoteTable.getObjectID();
                }
                if ((remoteKey = fkass.getKeyObject()) == null) continue;
                snode.remoteKeyId = remoteKey.getObjectID();
                continue;
            }
            if (snode.fkAssociationRef != null) {
                snode.fkAssocId = snode.fkAssociationRef.getObject().getObjectID();
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
                if (fkass == null) continue;
                remoteTable = fkass.getRemoteTable();
                if (remoteTable != null) {
                    snode.remoteTableId = remoteTable.getObjectID();
                }
                if ((remoteKey = fkass.getKeyObject()) == null) continue;
                snode.remoteKeyId = remoteKey.getObjectID();
                continue;
            }
            snode.fkAssocId = "null";
        }
        return this.allrefs;
    }

    @Override
    public List getAllDelegatesAndFK() {
        ArrayList<FK_And_Delegate_Holder> list = new ArrayList<FK_And_Delegate_Holder>();
        for (FKElement.FKColRefNode snode : this.allrefs) {
            FKElement dcol;
            FKIndexAssociation fkass = null;
            if (snode.fkAssocId != null) {
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            } else if (snode.fkAssociationRef != null) {
                snode.fkAssocId = snode.fkAssociationRef.getObject().getObjectID();
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            }
            if (fkass == null || snode.refColumnId == null || (dcol = (FKElement)fkass.getRemoteTable().getElementByID(snode.refColumnId)) == null) continue;
            FK_And_Delegate_Holder fkh = new FK_And_Delegate_Holder();
            fkh.delegateColumn = dcol;
            fkh.fk = fkass;
            list.add(fkh);
        }
        return list;
    }

    @Override
    public List getAllFKs() {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        for (FKElement.FKColRefNode snode : this.allrefs) {
            FKIndexAssociation fkass = null;
            if (snode.fkAssocId != null) {
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            } else if (snode.fkAssociationRef != null) {
                snode.fkAssocId = snode.fkAssociationRef.getObject().getObjectID();
                fkass = this.getFKIndexAssociation(snode.fkAssocId);
            }
            if (fkass == null) continue;
            list.add(fkass);
        }
        return list;
    }

    public boolean isInFKinArc() {
        for (FKIndexAssociation fk : this.getAllFKs()) {
            if (!fk.isInArc()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInOptionalFK() {
        return this.getOptionalFK() != null;
    }

    @Override
    public boolean isInMandatoryFK() {
        for (FKIndexAssociation fk : this.getAllFKs()) {
            if (!fk.isMandatory()) continue;
            return true;
        }
        return false;
    }

    public FKIndexAssociation getOptionalFK() {
        for (FKIndexAssociation fk : this.getAllFKs()) {
            if (fk.isMandatory()) continue;
            return fk;
        }
        return null;
    }

    @Override
    public boolean isPartOfFKIndexAssociation(FKIndexAssociation fkAssoc) {
        FKElement.FKColRefNode[] arr = this.allrefs.toArray(new FKElement.FKColRefNode[0]);
        String id = fkAssoc.getObjectID();
        if (id == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (id.equalsIgnoreCase(arr[i].fkAssocId)) {
                return true;
            }
            if (arr[i].fkAssociationRef == null) continue;
            return id.equalsIgnoreCase(arr[i].fkAssociationRef.getObject().getObjectID());
        }
        return false;
    }

    @Override
    public Collection getFKAssociationsForDelegate(String delegateId) {
        ArrayList<DesignObject> col = new ArrayList<DesignObject>();
        for (FKElement.FKColRefNode snode : this.allrefs) {
            if (snode.fkAssocId != null) {
                if (!snode.refColumnId.equalsIgnoreCase(delegateId)) continue;
                col.add(this.getFKIndexAssociation(snode.fkAssocId));
                continue;
            }
            if (snode.fkAssociationRef == null || snode.fkAssociationRef.getObject() == null || !snode.refColumnId.equalsIgnoreCase(delegateId)) continue;
            col.add(snode.fkAssociationRef.getObject());
        }
        return col;
    }

    public void removeFKAssociation(FKIndexAssociationReference reference) {
        if (this.fkAssociationReference == reference) {
            FKElement refcol = this.getReferencedColumn();
            this.fkAssociationReference = null;
            this.fkAssociationId = null;
            this.referencedColumnId = null;
            if (refcol != null && !this.isNested() && !this.getContainer().isBST()) {
                MergingModels.copyDataTypeFromCOWD_To_COWD(refcol, this, false);
            }
        }
        if (this.allrefs.size() > 0) {
            Iterator it;
            FKElement.FKColRefNode[] arr = this.allrefs.toArray(new FKElement.FKColRefNode[0]);
            for (int i = 0; i < arr.length; ++i) {
                if (reference != arr[i].fkAssociationRef && (reference.getObject() == null || reference.getObject() != arr[i].fkAssociationRef.getObject())) continue;
                this.allrefs.remove(arr[i]);
                break;
            }
            if ((it = this.allrefs.iterator()).hasNext()) {
                FKElement.FKColRefNode rnode = (FKElement.FKColRefNode)it.next();
                this.fkAssociationReference = rnode.fkAssociationRef;
                this.fkAssociationId = rnode.fkAssocId;
                this.referencedColumnId = rnode.refColumnId;
            }
        }
    }

    @Override
    public void removeFKAssociation(String fkAssocId) {
        if (this.fkAssociationId != null && this.fkAssociationId.equalsIgnoreCase(fkAssocId)) {
            FKElement refcol = this.getReferencedColumn();
            this.fkAssociationReference = null;
            this.fkAssociationId = null;
            this.referencedColumnId = null;
            if (!(refcol == null || this.isNested() || this.getContainer().isBST() || this.getAppView().getSettings().isAllowSimilarTypesFK() || refcol instanceof ColumnView && "UNKNOWN".equalsIgnoreCase(refcol.getDataType().getName()))) {
                MergingModels.copyDataTypeFromCOWD_To_COWD(refcol, this, false);
            }
        }
        if (this.allrefs.size() > 0) {
            Iterator it;
            FKElement.FKColRefNode[] arr = this.allrefs.toArray(new FKElement.FKColRefNode[0]);
            for (int i = 0; i < arr.length; ++i) {
                if (!fkAssocId.equalsIgnoreCase(arr[i].fkAssocId) && (arr[i].fkAssociationRef == null || arr[i].fkAssociationRef.getObject() == null || !fkAssocId.equalsIgnoreCase(arr[i].fkAssociationRef.getObject().getObjectID()))) continue;
                this.allrefs.remove(arr[i]);
                break;
            }
            if ((it = this.allrefs.iterator()).hasNext()) {
                FKElement.FKColRefNode rnode = (FKElement.FKColRefNode)it.next();
                this.fkAssociationReference = rnode.fkAssociationRef;
                this.fkAssociationId = rnode.fkAssocId;
                this.referencedColumnId = rnode.refColumnId;
            } else {
                this.fkAssociationReference = null;
                this.fkAssociationId = null;
                this.referencedColumnId = null;
            }
        }
    }

    private FKIndexAssociation getFKIndexAssociation(String fkId) {
        if (this.getContainerWithKeyObject() == null) {
            return null;
        }
        KeyObject[] indexes = this.getContainerWithKeyObject().getKeys();
        for (int i = 0; i < indexes.length; ++i) {
            if (!indexes[i].isFK() || !indexes[i].getFKAssociation().getObjectID().equalsIgnoreCase(fkId)) continue;
            return indexes[i].getFKAssociation();
        }
        return null;
    }

    public boolean hasCircularRef() {
        this.checkedCols = new ArrayList();
        if (this.isFKColumn()) {
            for (FKElement.FKColRefNode snode : this.getRefColAndAssocIDs()) {
                FKElement refColumn = (FKElement)this.getDesign().getDesignObject(snode.refColumnId);
                if (refColumn == null) continue;
                if (this == refColumn) {
                    return true;
                }
                if (this.checkedCols.contains(refColumn)) continue;
                this.checkedCols.add(refColumn);
                boolean found = this.testColumn(refColumn);
                if (!found) continue;
                return found;
            }
        }
        return false;
    }

    private boolean testColumn(FKElement col) {
        if (col.isFKColumn()) {
            for (FKElement.FKColRefNode snode : col.getRefColAndAssocIDs()) {
                FKElement refColumn = (FKElement)this.getDesign().getDesignObject(snode.refColumnId);
                if (refColumn == null) continue;
                if (this == refColumn) {
                    return true;
                }
                if (this.checkedCols.contains(refColumn)) continue;
                this.checkedCols.add(refColumn);
                boolean found = this.testColumn(refColumn);
                if (!found) continue;
                return found;
            }
        }
        return false;
    }

    @Override
    public Domain getDomain() {
        if (!(this.fkAssociationId == null || this.referencedColumnId == null || this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) || this.isNested() || this.getContainer().isBST())) {
            Column rcol;
            FKElement referencedColumn = this.getReferencedColumn();
            if (referencedColumn instanceof Column && !this.hasCircularRef()) {
                return referencedColumn.getDomain();
            }
            if (referencedColumn instanceof ColumnView && (rcol = ((ColumnView)referencedColumn).getFirstReferencedColumn()) != null) {
                return rcol.getDomain();
            }
        }
        return super.getDomain();
    }

    @Override
    public short getUse() {
        FKElement referencedColumn;
        if (!(this.fkAssociationId == null || this.referencedColumnId == null || this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) || this.isNested() || this.getContainer().isBST() || !((referencedColumn = this.getReferencedColumn()) instanceof Column) || this.hasCircularRef())) {
            return referencedColumn.getUse();
        }
        return super.getUse();
    }

    @Override
    public Datatype getDataType() {
        if (this.getAppView().getSettings().isAllowSimilarTypesFK() && !this.getParameters().isEmpty()) {
            return super.getDataType();
        }
        if (!(this.fkAssociationId == null || this.referencedColumnId == null || this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) || this.isNested() || this.getContainer().isBST() || this.isReference() && this.getUse() == 3)) {
            Datatype dt;
            FKElement referencedColumn = this.getReferencedColumn();
            if (referencedColumn instanceof Column) {
                if (referencedColumn != null && !referencedColumn.isOid() && !this.hasCircularRef()) {
                    return referencedColumn.getDataType();
                }
            } else if (referencedColumn instanceof ColumnView && (dt = referencedColumn.getDataType()) != null && !"UNKNOWN".equalsIgnoreCase(dt.getName())) {
                return dt;
            }
        }
        return super.getDataType();
    }

    @Override
    public String getDataType(int nestedLevel) {
        return this.getDatatypeString();
    }

    @Override
    public Datatype getDataType(String rdbmsName) {
        if (this.getAppView().getSettings().isAllowSimilarTypesFK() && !this.getParameters().isEmpty()) {
            return super.getDataType(rdbmsName);
        }
        if (!(this.fkAssociationId == null || this.referencedColumnId == null || this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) || this.isNested() || this.getContainer().isBST())) {
            Datatype dt;
            FKElement referencedColumn = this.getReferencedColumn();
            if (referencedColumn instanceof Column) {
                if (referencedColumn != null && !this.hasCircularRef()) {
                    return referencedColumn.getDataType(rdbmsName);
                }
            } else if (referencedColumn instanceof ColumnView && (dt = referencedColumn.getDataType(rdbmsName)) != null && !"UNKNOWN".equalsIgnoreCase(dt.getName())) {
                return dt;
            }
        }
        return super.getDataType(rdbmsName);
    }

    @Override
    public String getDataTypeParameter(String key) {
        FKElement referencedColumn;
        String res = MT_NOT_DEFINED;
        boolean superProcessed = false;
        if (this.getAppView().getSettings().isAllowSimilarTypesFK()) {
            res = super.getDataTypeParameter(key);
            superProcessed = true;
        }
        if (!(!res.isEmpty() || this.fkAssociationId == null || this.referencedColumnId == null || this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) || this.isNested() || this.getContainer().isBST() || (referencedColumn = this.getReferencedColumn()) == null || this.hasCircularRef())) {
            return referencedColumn.getDataTypeParameter(key);
        }
        if (superProcessed) {
            return res;
        }
        return super.getDataTypeParameter(key);
    }

    @Override
    public String getDatatypeString(String rdbmsName) {
        Datatype dt;
        FKElement referencedColumn;
        if (this.getAppView().getSettings().isAllowSimilarTypesFK() && !this.getParameters().isEmpty()) {
            return super.getDatatypeString(rdbmsName);
        }
        if (this.fkAssociationId != null && this.referencedColumnId != null && !this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) && !this.isNested() && !this.getContainer().isBST() && ((referencedColumn = this.getReferencedColumn()) instanceof Column ? referencedColumn != null && !this.hasCircularRef() : referencedColumn instanceof ColumnView && (dt = referencedColumn.getDataType()) != null && !"UNKNOWN".equalsIgnoreCase(dt.getName()))) {
            return referencedColumn.getDatatypeString(rdbmsName);
        }
        return super.getDatatypeString(rdbmsName);
    }

    public String getDatatypeString() {
        try {
            String dbtype = this.getRelationalModel().getSelectedRDBMSType().getName();
            return this.getDatatypeString(dbtype);
        }
        catch (Exception exception) {
            return MT_NOT_DEFINED;
        }
    }

    public String getDatatypeText() {
        DistinctType distinctType;
        Datatype datatype = this.getDataType();
        if (datatype instanceof StructuredType && this.isReference()) {
            return "REF " + datatype.toString();
        }
        if (datatype instanceof DistinctType) {
            String rdbmsName = this.getSelectedRDBMSType().toString();
            if (rdbmsName.startsWith("DB2")) {
                return datatype.getName();
            }
            datatype = this.getDataType(rdbmsName);
        }
        String type = MT_NOT_DEFINED;
        if (datatype != null) {
            type = datatype.toString();
        }
        if (this.getUse() == 0) {
            type = type + " {" + this.getDomain().getName() + "}";
        } else if (this.getUse() == 1) {
            type = type + " [" + this.getLogicalDatatype().getName() + "]";
        } else if (this.getUse() == 2 && (distinctType = this.getDistinctType()) != null) {
            type = type + " [" + distinctType.getName() + "]";
        }
        return type;
    }

    @Override
    public LogicalDatatype getLogicalDatatype() {
        if (!(this.fkAssociationId == null || this.referencedColumnId == null || this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) || this.isNested() || this.getContainer().isBST())) {
            LogicalDatatype lt;
            Column rcol;
            FKElement referencedColumn = this.getReferencedColumn();
            if (referencedColumn instanceof Column && !this.hasCircularRef()) {
                return referencedColumn.getLogicalDatatype();
            }
            if (referencedColumn instanceof ColumnView && (rcol = ((ColumnView)referencedColumn).getFirstReferencedColumn()) != null && rcol != this && (lt = rcol.getLogicalDatatype()) != null && !"UNKNOWN".equalsIgnoreCase(lt.getName())) {
                return lt;
            }
        }
        return super.getLogicalDatatype();
    }

    @Override
    public DistinctType getDistinctType() {
        FKElement referencedColumn;
        if (!(this.fkAssociationId == null || this.referencedColumnId == null || this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) || this.isNested() || this.getContainer().isBST() || !((referencedColumn = this.getReferencedColumn()) instanceof Column) || this.hasCircularRef())) {
            return referencedColumn.getDistinctType();
        }
        return super.getDistinctType();
    }

    @Override
    public void addAVT(AVT avt) {
        if (!this.getUseDomainConstraints()) {
            super.addAVT(avt);
        }
    }

    @Override
    public Set getAVTs() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getAVTs();
        }
        return super.getAVTs();
    }

    @Override
    public void removeAVT(AVT avt) {
        if (!this.getUseDomainConstraints()) {
            super.removeAVT(avt);
        }
    }

    @Override
    public void clearAVTs() {
        if (!this.getUseDomainConstraints()) {
            super.clearAVTs();
        }
    }

    public String getAVTString() {
        return "View";
    }

    @Override
    public void setValueList(ConstraintEnumeration valueList) {
        if (!this.getUseDomainConstraints()) {
            super.setValueList(valueList);
        }
    }

    @Override
    public CheckConstraint getCheck() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getCheck();
        }
        return super.getCheck();
    }

    @Override
    public void setCheck(CheckConstraint check) {
        if (!this.getUseDomainConstraints()) {
            super.setCheck(check);
        }
    }

    public void parseAndSetCheckConstraint(CheckConstraint constraint) {
        String constraintName = constraint.getName();
        Iterator it = constraint.getPropertyNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = constraint.getProperty(key);
            boolean separated = this.setSeparatedConstraints(value);
            if (separated) {
                String rangeList;
                String checkPart = this.getSeparatedCheckConstraint();
                if (!MT_NOT_DEFINED.equals(checkPart)) {
                    constraint.setProperty(key, checkPart);
                    this.setCheck(constraint);
                }
                if (!MT_NOT_DEFINED.equals(rangeList = this.getSeparatedRangeConstraint())) {
                    String[] rangeParts = rangeList.split(",");
                    int i = 0;
                    while (i < rangeParts.length) {
                        String rangeFrom = rangeParts[i++];
                        String rangeTo = rangeParts[i++];
                        AVT avt = new AVT(rangeFrom.trim(), rangeTo.trim(), MT_NOT_DEFINED);
                        this.setUseDomainConstraints(false);
                        this.addAVT(avt);
                    }
                }
                String valueList = this.getSeparatedValueConstraint();
                String likeList = this.getSeparatedLikeConstraint();
                if (MT_NOT_DEFINED.equals(valueList) && MT_NOT_DEFINED.equals(likeList)) continue;
                ConstraintEnumeration lov = new ConstraintEnumeration();
                this.getDesign().getRelationalDesign().stampModelObjectDDL(lov);
                if (valueList.length() > 0) {
                    String[] valueParts = valueList.split(",");
                    for (int i = 0; i < valueParts.length; ++i) {
                        String valuePart = valueParts[i].trim();
                        if (valuePart.startsWith("'") && valuePart.endsWith("'") && valuePart.length() > 1) {
                            valuePart = valuePart.substring(1, valuePart.length() - 1);
                        }
                        lov.add(valuePart);
                    }
                }
                if (likeList.length() > 0) {
                    String[] likeParts = likeList.split(",");
                    for (int i = 0; i < likeParts.length; ++i) {
                        String likePart = likeParts[i].trim();
                        if (likePart.startsWith("'") && likePart.endsWith("'") && likePart.length() > 1) {
                            likePart = likePart.substring(1, likePart.length() - 1);
                        }
                        lov.add(likePart, "LIKE");
                    }
                }
                lov.setName(constraintName);
                this.setUseDomainConstraints(false);
                this.setValueList(lov);
                continue;
            }
            this.setCheck(constraint);
        }
    }

    public void loadDelegate() {
        Column column = (Column)this.getDesign().getDesignObject(this.referencedColumnId);
        this.setDelegate(column);
    }

    public boolean isAdapterLoaded() {
        return this.delegate != null;
    }

    public void setDelegate(FKElement column) {
        this.delegate = column;
    }

    @Override
    public FKElement getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.getReferencedColumn();
    }

    @Override
    public void setDomain(Domain domain) {
        if (this.getReferencedColumn() != null && !this.hasCircularRef()) {
            this.getReferencedColumn().setDomain(domain);
        } else {
            super.setDomain(domain);
        }
    }

    private boolean isRealFKPlaceHolder() {
        return this.realFKPlaceHolder;
    }

    public void setRealFKPlaceHolder(boolean realFKPlaceHolder) {
        this.realFKPlaceHolder = realFKPlaceHolder;
    }

    @Override
    public boolean hasAliveGenerator() {
        DesignObject obj;
        AttributeSet set = this.getDesign().getLogicalDesign().getAttributeSet();
        return "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog(Dialog owner) {
        if (!this.isDialogVisible()) {
            ColumnPropertiesDialogEx dialog = owner == null ? new ColumnPropertiesDialogEx(this.getDesign().getAppView(), this, false) : new ColumnPropertiesDialogEx(owner, this.getDesign().getAppView(), this, false);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void showPropertyDialog() {
        this.showPropertyDialog(null);
    }

    @Override
    public Attribute getEngAttribute() {
        DesignObject obj;
        XtdMapping mapping;
        Attribute attr;
        MappingCollector mw = this.getRMExtendedMap().getOrCreateCollector(this);
        List list = mw.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() == 1 && (attr = (Attribute)(mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            return attr;
        }
        for (XtdMapping mapping2 : list) {
            if (mapping2.getInheritanceType() != 0 || (obj = mapping2.getObjectMappedTo(this)) == null || !(obj instanceof Attribute)) continue;
            return (Attribute)obj;
        }
        for (XtdMapping mapping2 : list) {
            if (mapping2.getInheritanceType() != 3 || (obj = mapping2.getObjectMappedTo(this)) == null || !(obj instanceof Attribute)) continue;
            return (Attribute)obj;
        }
        attr = null;
        attr = (Attribute)this.getGenerator();
        if (attr == null) {
            if (!"User generated".equalsIgnoreCase(this.getGeneratorID())) {
                attr = (Attribute)this.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(this.getGeneratorID());
            }
            if (attr == null) {
                attr = (Attribute)this.getDesign().getLogicalDesign().getAttributeSet().getObjectGeneratedBy(this.getObjectID());
            }
        }
        return attr;
    }

    public Attribute getEngAttribute(Entity entity) {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                Attribute attr = (Attribute)mapping.getObjectMappedTo(this);
                if (attr == null || attr.getContainerWithKeyObject() != entity) continue;
                return attr;
            }
        }
        return null;
    }

    @Override
    public XtdMapping getMappingFor(Entity entity) {
        List list;
        if (entity != null && (list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                Attribute attr = (Attribute)mapping.getObjectMappedTo(this);
                if (attr == null || attr.getContainerWithKeyObject() != entity) continue;
                return mapping;
            }
        }
        return null;
    }

    public List getMappingsFor(Entity entity) {
        List list;
        ArrayList<XtdMapping> temp = new ArrayList<XtdMapping>();
        if (entity != null && (list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                Attribute attr = (Attribute)mapping.getObjectMappedTo(this);
                if (attr == null || attr.getContainerWithKeyObject() != entity) continue;
                temp.add(mapping);
            }
        }
        return temp;
    }

    @Override
    public List getMappingsToAttributes() {
        ArrayList<XtdMapping> temp = new ArrayList<XtdMapping>();
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                DesignObject attr = mapping.getObjectMappedTo(this);
                if (attr == null || !(attr instanceof Attribute)) continue;
                temp.add(mapping);
            }
        }
        return temp;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public void copy(DesignObject desObject) {
        this.copy((Column)desObject, false, null, true);
    }

    public void copy(Column column, boolean remoteObject, Map copyMap, boolean copyNestedColumns) {
        super.copy(column);
        if (column.isBackup() && !this.isBackup()) {
            column.setObjectID(this.getObjectID());
        }
        column.setOid(this.isOid());
        column.setStructAttributeID(this.getStructAttributeID());
        column.setNullsAllowed(this.getNullsAllowed());
        column.setReference(this.isReference());
        column.setUse(this.getUse());
        if (this.getUse() == 0) {
            Domain remoteDomain = this.getDomain();
            if (remoteDomain != null) {
                if (column.isBackup()) {
                    column.setDomain(remoteDomain);
                } else if (this.getDesign() == column.getDesign()) {
                    column.setDomain(remoteDomain);
                } else if (!remoteDomain.isDefault() && remoteObject) {
                    Domain newDomain;
                    String domainID = remoteDomain.getObjectID();
                    if (remoteDomain.isRemoteObject()) {
                        domainID = remoteDomain.getRemoteObjectID();
                    }
                    if ((newDomain = (Domain)column.getDesign().getDomainSet().getByRemoteObjectId(domainID)) == null) {
                        newDomain = column.getDesign().getDomainSet().createDomain();
                        newDomain.setObjectID(new GUID().toString());
                        remoteDomain.copyTo(newDomain);
                        newDomain.setOwnerDesignName(column.getDesign().getName());
                        newDomain.setFileName(column.getDesign().getName());
                        if (remoteDomain.isRemoteObject()) {
                            newDomain.setRemoteObjectID(remoteDomain.getRemoteObjectID());
                            newDomain.setRemoteDesignID(remoteDomain.getRemoteDesignID());
                            newDomain.setRemoteObjectRelativeStorageName(remoteDomain.getRemoteObjectRelativeStorageName());
                        } else {
                            newDomain.setRemoteObjectID(remoteDomain.getObjectID());
                            newDomain.setRemoteDesignID(this.getDesign().getObjectID());
                            newDomain.setRemoteObjectRelativeStorageName(remoteDomain.getRelativeStorageName());
                        }
                    }
                    column.setDomain(newDomain);
                } else {
                    Domain dom = (Domain)column.getDesign().getDomainSet().getObjectByID(remoteDomain.getObjectID());
                    if (dom != null) {
                        remoteDomain = dom;
                    }
                    column.setDomain(remoteDomain);
                }
            }
        } else if (this.getUse() == 1) {
            if (column.isBackup() || this.getDesign() == column.getDesign()) {
                column.setLogicalDatatype(this.getLogicalDatatype());
            } else {
                LogicalDatatype lt = this.getLogicalDatatype();
                if (lt != null) {
                    LogicalDatatype nlt = (LogicalDatatype)column.getDesign().getLogicalDatatypeSet().getObjectByID(lt.getObjectID());
                    if (nlt == null) {
                        nlt = (LogicalDatatype)column.getDesign().getLogicalDatatypeSet().getByName(lt.getName(), false);
                    }
                    if (nlt != null) {
                        column.setLogicalDatatype(nlt);
                    }
                }
            }
            column.setDataTypeParameter("size", this.getSize());
            column.setDataTypeParameter("precision", this.getPrecision());
            column.setDataTypeParameter("scale", this.getScale());
        } else if (this.getUse() == 3) {
            column.setStructuredType(this.getStructuredType());
            List list = column.getPermittedSubTypes();
            list.clear();
            list.addAll(this.getPermittedSubTypes());
        } else if (this.getUse() == 4) {
            column.setCollectionType(this.getCollectionType());
        } else if (this.getUse() == 2) {
            column.setDistinctType(this.getDistinctType());
        }
        column.setPreviousColumn(this.isPreviousColumn());
        column.setUsesDefaultValue(this.getUsesDefaultValue());
        column.setUseDomainConstraints(this.getUseDomainConstraints());
        column.setGenerateConstraintInDDL(this.getGenerateConstraintInDDL());
        column.setConstraintName(this.getConstraintName());
        column.setNotNullConstraintName(this.getNotNullConstraintName());
        column.setDefaultValue(this.getDefaultValue());
        column.setDefaultOnNull(this.isDefaultOnNull());
        column.setSourceType(this.getSourceType());
        column.setComputed(this.isComputed());
        column.setFormulaDesc(this.getFormulaDesc());
        column.setScopeId(this.getScopeId());
        column.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        column.setRestrictedTypeSubstitution(this.isRestrictedTypeSubstitution());
        column.setAbbreviation(this.getAbbreviation());
        column.setConstraintNotes(this.getConstraintNotes());
        column.setConstraintComment(this.getConstraintComment());
        column.setConstraintCommentInRDBMS(this.getConstraintCommentInRDBMS());
        if (this.getDesignPart() == column.getDesignPart()) {
            column.setDependOnForeignKeyID(this.getDependOnForeignKeyID());
            column.setDependOnForeignKey(this.getDependOnForeignKey());
            column.setDependOnFK_AsMandatory(this.isDependOnFK_AsMandatory());
        }
        column.setSensitiveType(this.getSensitiveType());
        column.setSensitiveTypeDescription(this.getSensitiveTypeDescription());
        column.setDefaultLabel(this.getDefaultLabel());
        column.setDefaultFormatMask(this.getDefaultFormatMask());
        column.setDefaultFormDisplayWidth(this.getDefaultFormDisplayWidth());
        column.setDefaultFormMaximumWidth(this.getDefaultFormMaximumWidth());
        column.setDefaultFormHeight(this.getDefaultFormHeight());
        column.setDefaultHelpText(this.getDefaultHelpText());
        column.setDefaultReadOnly(this.isDefaultReadOnly());
        column.setDefaultDisplayedOnReports(this.isDefaultDisplayedOnReports());
        column.setDefaultDisplayedOnForms(this.isDefaultDisplayedOnForms());
        column.setDefaultDisplayAs(this.getDefaultDisplayAs());
        column.setContainsPII(this.isContainsPII());
        column.setContainsSensitiveInformation(this.isContainsSensitiveInformation());
        column.setMaskingType(this.getMaskingType());
        column.setMaskTemplate(this.getMaskTemplate());
        column.setDiscriminatorColumn(this.isDiscriminatorColumn());
        column.setAutoIncrementColumn(this.isAutoIncrementColumn());
        column.setIdentityColumn(this.isIdentityColumn());
        column.setAutoIncrementGenerateAlways(this.isAutoIncrementGenerateAlways());
        column.setAutoIncrementStartWith(this.getAutoIncrementStartWith());
        column.setAutoIncrementIncrementBy(this.getAutoIncrementIncrementBy());
        column.setAutoIncrementMinValue(this.getAutoIncrementMinValue());
        column.setAutoIncrementMaxValue(this.getAutoIncrementMaxValue());
        column.setAutoIncrementCycle(this.isAutoIncrementCycle());
        column.setAutoIncrementDisableCache(this.isAutoIncrementDisableCache());
        column.setAutoIncrementCache(this.getAutoIncrementCache());
        column.setAutoIncrementOrder(this.isAutoIncrementOrder());
        column.setAutoIncrementSequenceName(this.getAutoIncrementSequenceName());
        column.setAutoIncrementTriggerName(this.getAutoIncrementTriggerName());
        column.setAutoIncrementGenerateTrigger(this.isAutoIncrementGenerateTrigger());
        if (!this.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(this, column);
            EngCOPropertiesComparator.copyRangeConstraint(this, column);
            EngCOPropertiesComparator.copyLOVConstraint(this, column);
        }
        if (copyMap != null) {
            copyMap.put(this.getObjectID(), column);
        }
        if (copyNestedColumns) {
            block0: for (Column sourceNestedCol : this.getNestedObjects()) {
                ModelIDObject mappedStructTypeEl;
                String sourceStructAttID = sourceNestedCol.getStructAttributeID();
                if (sourceStructAttID.equals(MT_NOT_DEFINED)) continue;
                if (copyMap != null && (mappedStructTypeEl = (ModelIDObject)copyMap.get(sourceStructAttID)) != null) {
                    sourceStructAttID = mappedStructTypeEl.getObjectID();
                }
                for (Column targetNestedCol : column.getNestedObjects()) {
                    if (!sourceStructAttID.equals(targetNestedCol.getStructAttributeID())) continue;
                    sourceNestedCol.copy(targetNestedCol, remoteObject, copyMap, copyNestedColumns);
                    continue block0;
                }
            }
        }
        this.copyDepenDendentColumnDescriptors(column, true, copyMap);
        column.setNotNullConstraintNameFixed(this.isNotNullConstraintNameFixed());
        column.setCheckConstraintNameFixed(this.isCheckConstraintNameFixed());
    }

    @Override
    public boolean isAtomic() {
        return this.getStructuredType() == null || this.isReference();
    }

    public FKElement getOriginatingColumn() {
        if (!this.isFKColumn()) {
            return null;
        }
        ArrayList<FKElement> processed = new ArrayList<FKElement>();
        processed.add(this);
        FKElement delg = this.getDelegate();
        if (delg != null) {
            boolean found = false;
            while (!found) {
                processed.add(delg);
                if (delg.isFKColumn()) {
                    if (!processed.contains(delg = delg.getDelegate())) continue;
                    delg = null;
                    found = true;
                    continue;
                }
                found = true;
            }
        }
        return delg;
    }

    public FKElement getOriginatingColumn(FKIndexAssociation fk) {
        if (!this.isFKColumn()) {
            return null;
        }
        ArrayList<FKElement> processed = new ArrayList<FKElement>();
        processed.add(this);
        FKElement delg = this.getReferencedColumn(fk);
        boolean found = false;
        while (!found) {
            processed.add(delg);
            if (delg.isFKColumn()) {
                if (!processed.contains(delg = delg.getDelegate())) continue;
                delg = null;
                found = true;
                continue;
            }
            found = true;
        }
        return delg;
    }

    public boolean shouldBeEngineered(XtdMapping entityMapping) {
        Entity ent;
        DesignObject obj;
        if (this.isFKColumn() && (obj = entityMapping.getObjectMappedTo(this.getContainerWithKeyObject())) != null && obj instanceof Entity && this.getMappingFor(ent = (Entity)obj) == null) {
            Iterator it = this.getAllFKs().iterator();
            if (it.hasNext()) {
                FKIndexAssociation fk = (FKIndexAssociation)it.next();
                if (fk.shouldBeEngineered() || fk.getEngRelation(ent) != null) {
                    Index index;
                    KeyObject key = fk.getRemoteIndex();
                    if (key instanceof Index && ((index = (Index)key).shouldBeEngineered() || index.getMappingFor(ent) != null)) {
                        if (index.getMappingFor(ent) != null) {
                            return !entityMapping.getColumns().contains(this.getObjectID());
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        return !entityMapping.getColumns().contains(this.getObjectID());
    }

    @Override
    public void setUse(short use) {
        short oldUse = super.getUse();
        if (use != oldUse) {
            Table table;
            super.setUse(use);
            if (!(this.getDesign().isLoading() || use != 3 && oldUse != 3 || (table = (Table)this.getContainer()) == null)) {
                table.createNestedColumnsOnly(this.getStructuredType(), this);
            }
        }
    }

    @Override
    public void setReference(boolean reference) {
        if (this.isReference() != reference) {
            Table table;
            super.setReference(reference);
            if (!this.getDesign().isLoading() && (table = (Table)this.getContainer()) != null) {
                table.createNestedColumnsOnly(this.getStructuredType(), this);
            }
        }
    }

    @Override
    public void setStructuredType(StructuredType structuredType) {
        StructuredType old = this.getStructuredType();
        if (old != structuredType) {
            if (old != null) {
                old.removeObjectListener(this);
            }
            super.setStructuredType(structuredType);
            Table table = (Table)this.getContainer();
            if (table != null) {
                if (!this.getDesign().isLoading()) {
                    table.createNestedColumnsOnly(structuredType, this);
                }
                if (!table.isBackup()) {
                    structuredType.addObjectListener(this);
                }
            }
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        Table table;
        super.changed(object, event);
        if (object instanceof StructuredType && (table = (Table)this.getContainerWithKeyObject()) != null && !table.isBackup()) {
            table.createNestedColumnsOnly(this.getStructuredType(), this);
        }
    }

    public boolean hasAssignedUIDefaults() {
        return this.defaultLabel != null || this.defaultFormatMask != null || this.defaultFormDisplayWidth != null || this.defaultFormMaximumWidth != null || this.defaultFormHeight != null || this.defaultHelpText != null || this.defaultReadOnly || !this.defaultDisplayedOnReports || !this.defaultDisplayedOnForms || !DISPLAY_AS_TEXT.equals(this.defaultDisplayAs);
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setComputed(Boolean computed) {
        this.computed = computed;
    }

    public Boolean isComputed() {
        return this.computed;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public String getDefaultFormatMask() {
        return this.defaultFormatMask;
    }

    public void setDefaultFormatMask(String defaultFormatMask) {
        this.defaultFormatMask = defaultFormatMask;
    }

    public Integer getDefaultFormDisplayWidth() {
        return this.defaultFormDisplayWidth;
    }

    public void setDefaultFormDisplayWidth(Integer defaultFormDisplayWidth) {
        this.defaultFormDisplayWidth = defaultFormDisplayWidth;
    }

    public Integer getDefaultFormMaximumWidth() {
        return this.defaultFormMaximumWidth;
    }

    public void setDefaultFormMaximumWidth(Integer defaultFormMaximumWidth) {
        this.defaultFormMaximumWidth = defaultFormMaximumWidth;
    }

    public Integer getDefaultFormHeight() {
        return this.defaultFormHeight;
    }

    public void setDefaultFormHeight(Integer defaultFormHeight) {
        this.defaultFormHeight = defaultFormHeight;
    }

    public String getDefaultHelpText() {
        return this.defaultHelpText;
    }

    public void setDefaultHelpText(String defaultHelpText) {
        this.defaultHelpText = defaultHelpText;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public boolean isDefaultDisplayedOnReports() {
        return this.defaultDisplayedOnReports;
    }

    public void setDefaultDisplayedOnReports(boolean defaultDisplayedOnReports) {
        this.defaultDisplayedOnReports = defaultDisplayedOnReports;
    }

    public boolean isDefaultDisplayedOnForms() {
        return this.defaultDisplayedOnForms;
    }

    public void setDefaultDisplayedOnForms(boolean defaultDisplayedOnForms) {
        this.defaultDisplayedOnForms = defaultDisplayedOnForms;
    }

    public String getDefaultDisplayAs() {
        return this.defaultDisplayAs;
    }

    public void setDefaultDisplayAs(String defaultDisplayAs) {
        this.defaultDisplayAs = defaultDisplayAs;
    }

    public Boolean isContainsPII() {
        return this.containsPII;
    }

    public void setContainsPII(Boolean containsPII) {
        this.containsPII = containsPII;
    }

    public Boolean isContainsSensitiveInformation() {
        return this.containsSensitiveInformation;
    }

    public void setContainsSensitiveInformation(Boolean containsSensitiveInformation) {
        this.containsSensitiveInformation = containsSensitiveInformation;
    }

    public Boolean isMaskData() {
        return this.maskData;
    }

    public void setMaskData(Boolean maskData) {
        this.maskingType = maskData != false ? MT_FULL : MT_NO;
    }

    public String getMaskingType() {
        return this.maskingType;
    }

    public void setMaskingType(String maskingType) {
        this.maskingType = maskingType;
    }

    public List getFKAssociationMaps() {
        ArrayList list = new ArrayList();
        try {
            for (FKElement.FKColRefNode refNode : this.getRefColAndAssocIDs()) {
                FKIndexAssociation fk;
                if (refNode.fkAssocId == null || (fk = this.getFKIndexAssociation(refNode.fkAssocId)) == null) continue;
                TreeMap<String, String> map = new TreeMap<String, String>();
                map.put(REFERRED_COLUMN, refNode.refColumnId);
                map.put(FK_ASSOCIATION, refNode.fkAssocId);
                list.add(map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public void addFKAssociationMaps(List list) {
        for (Object obj : list) {
            if (!(obj instanceof Map)) continue;
            Map map = (Map)obj;
            String refCol = (String)map.get(REFERRED_COLUMN);
            String fkid = (String)map.get(FK_ASSOCIATION);
            if (refCol == null || fkid == null) continue;
            this.addFKAssociation(refCol, fkid);
        }
    }

    public boolean isAutoIncrementColumn() {
        return this.autoIncrementColumn;
    }

    public void setAutoIncrementColumn(boolean autoIncrementColumn) {
        this.autoIncrementColumn = autoIncrementColumn;
    }

    public boolean isIdentityColumn() {
        return this.identityColumn;
    }

    public void setIdentityColumn(boolean identityColumn) {
        Table table;
        if (identityColumn && (table = (Table)this.getParent()) != null) {
            for (Object column : table.getElementsCollection()) {
                if (column == this) continue;
                ((Column)column).setIdentityColumn(false);
            }
        }
        this.identityColumn = identityColumn;
    }

    public boolean isAutoIncrementGenerateAlways() {
        return this.autoIncrementGenerateAlways;
    }

    public void setAutoIncrementGenerateAlways(boolean autoIncrementGenerateAlways) {
        this.autoIncrementGenerateAlways = autoIncrementGenerateAlways;
    }

    public String getAutoIncrementStartWith() {
        return this.autoIncrementStartWith;
    }

    public void setAutoIncrementStartWith(String autoIncrementStartWith) {
        this.autoIncrementStartWith = autoIncrementStartWith;
    }

    public Integer getAutoIncrementIncrementBy() {
        return this.autoIncrementIncrementBy;
    }

    public void setAutoIncrementIncrementBy(Integer autoIncrementIncrementBy) {
        this.autoIncrementIncrementBy = autoIncrementIncrementBy;
    }

    public String getAutoIncrementMinValue() {
        return this.autoIncrementMinValue;
    }

    public void setAutoIncrementMinValue(String autoIncrementMinValue) {
        this.autoIncrementMinValue = autoIncrementMinValue;
    }

    public String getAutoIncrementMaxValue() {
        return this.autoIncrementMaxValue;
    }

    public void setAutoIncrementMaxValue(String autoIncrementMaxValue) {
        this.autoIncrementMaxValue = autoIncrementMaxValue;
    }

    public boolean isAutoIncrementCycle() {
        return this.autoIncrementCycle;
    }

    public void setAutoIncrementCycle(boolean autoIncrementCycle) {
        this.autoIncrementCycle = autoIncrementCycle;
    }

    public boolean isAutoIncrementDisableCache() {
        return this.autoIncrementDisableCache;
    }

    public void setAutoIncrementDisableCache(boolean autoIncrementDisableCache) {
        this.autoIncrementDisableCache = autoIncrementDisableCache;
    }

    public Integer getAutoIncrementCache() {
        return this.autoIncrementCache;
    }

    public void setAutoIncrementCache(Integer autoIncrementCache) {
        this.autoIncrementCache = autoIncrementCache;
    }

    public boolean isAutoIncrementOrder() {
        return this.autoIncrementOrder;
    }

    public void setAutoIncrementOrder(boolean autoIncrementOrder) {
        this.autoIncrementOrder = autoIncrementOrder;
    }

    public String getAutoIncrementSequenceName() {
        return this.autoIncrementSequenceName;
    }

    public void setAutoIncrementSequenceName(String autoIncrementSequenceName) {
        this.autoIncrementSequenceName = autoIncrementSequenceName;
    }

    public String getAutoIncrementTriggerName() {
        return this.autoIncrementTriggerName;
    }

    public void setAutoIncrementTriggerName(String autoIncrementTriggerName) {
        this.autoIncrementTriggerName = autoIncrementTriggerName;
    }

    public boolean isAutoIncrementGenerateTrigger() {
        return this.autoIncrementGenerateTrigger;
    }

    public void setAutoIncrementGenerateTrigger(boolean autoIncrementGenerateTrigger) {
        this.autoIncrementGenerateTrigger = autoIncrementGenerateTrigger;
    }

    @Override
    public String getNotNullConstraintName() {
        return this.notNullConstraintName;
    }

    @Override
    public void setNotNullConstraintName(String notNullConstraintName) {
        if (!this.notNullConstraintNameFixed) {
            this.notNullConstraintName = notNullConstraintName;
        }
    }

    public String getGenerateConstraintInDDL() {
        return this.generateConstraintInDDL;
    }

    public void setGenerateConstraintInDDL(String generateConstraintInDDL) {
        if (generateConstraintInDDL.equalsIgnoreCase("YES") || generateConstraintInDDL.equalsIgnoreCase(MT_NO)) {
            this.generateConstraintInDDL = generateConstraintInDDL;
        }
    }

    public boolean isGenerateConstraintInDDL() {
        return this.generateConstraintInDDL.equalsIgnoreCase("YES");
    }

    public void setGenerateConstraintInDDL(boolean generateConstraintInDDL) {
        this.generateConstraintInDDL = generateConstraintInDDL ? "YES" : MT_NO;
    }

    public boolean hasOtherFK_forRelation(FKIndexAssociation otherfk, Relation rel) {
        for (FKIndexAssociation fk : this.getAllFKs()) {
            if (fk == otherfk || !fk.getGeneratorID().equals(rel.getObjectID()) && !rel.getGeneratorID().equals(fk.getObjectID()) || fk.getRemoteTable() != otherfk.getRemoteTable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    public boolean isDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(boolean discriminatorColumn) {
        this.discriminatorColumn = discriminatorColumn;
    }

    @Override
    public boolean isSurrogateColumn() {
        return this.isSurrogateColumn;
    }

    public void setSurrogateColumn(boolean isSurrogateColumn) {
        this.isSurrogateColumn = isSurrogateColumn;
    }

    public RelationalDesign getRelationalModel() {
        return (RelationalDesign)this.getDesignPart();
    }

    public Table getTable() {
        return (Table)this.getContainerWithKeyObject();
    }

    public String getTableSchemaName() {
        if (this.getTable() != null) {
            return this.getTable().getSchema();
        }
        return MT_NOT_DEFINED;
    }

    public String getDataTypeName() {
        Datatype dt = this.getDataType();
        if (dt != null) {
            return dt.getName();
        }
        return MT_NOT_DEFINED;
    }

    public boolean isRelationshipColumn() {
        return this.isRelationshipColumn;
    }

    public void setRelationshipColumn(boolean isRelationshipColumn) {
        this.isRelationshipColumn = isRelationshipColumn;
    }

    @Override
    public FKIndexAssociation getDependOnForeignKey() {
        DesignObject obj;
        if (this.dependOnForeignKey == null && !MT_NOT_DEFINED.equals(this.dependOnForeignKeyID) && (obj = this.getDesign().getDesignObject(this.dependOnForeignKeyID)) instanceof FKIndexAssociation) {
            this.dependOnForeignKey = (FKIndexAssociation)obj;
        }
        return this.dependOnForeignKey;
    }

    @Override
    public void setDependOnForeignKey(FKIndexAssociation dependOnForeignKey) {
        if (dependOnForeignKey != null) {
            this.dependOnForeignKeyID = dependOnForeignKey.getObjectID();
        }
        this.dependOnForeignKey = dependOnForeignKey;
    }

    @Override
    public boolean isDependOnFK_AsMandatory() {
        return this.dependOnFK_Mandatory;
    }

    @Override
    public void setDependOnFK_AsMandatory(boolean dependOnFK_Mandatory) {
        this.dependOnFK_Mandatory = dependOnFK_Mandatory;
    }

    public String getDependOnForeignKeyID() {
        if (this.dependOnForeignKey != null && !this.dependOnForeignKey.isRemoved()) {
            this.dependOnForeignKeyID = this.dependOnForeignKey.getObjectID();
        }
        return this.dependOnForeignKeyID;
    }

    @Override
    public void setDependOnForeignKeyID(String dependOnForeignKeyID) {
        this.dependOnForeignKeyID = dependOnForeignKeyID;
    }

    public MaskTemplate getMaskTemplate() {
        return this.maskTemplate;
    }

    public void setMaskTemplate(MaskTemplate maskTemplate) {
        this.maskTemplate = maskTemplate;
    }

    public boolean isRedactionPolicyCompatible() {
        String datatype = this.getDataTypeName();
        return datatype.indexOf("CHAR") > -1 || "NUMBER".equalsIgnoreCase(datatype) || "INTEGER".equalsIgnoreCase(datatype) || "SMALLINT".equalsIgnoreCase(datatype) || "FLOAT".equalsIgnoreCase(datatype) || "BINARY_FLOAT".equalsIgnoreCase(datatype) || "BINARY_DOUBLE".equalsIgnoreCase(datatype) || "REAL".equalsIgnoreCase(datatype) || "DATE".equalsIgnoreCase(datatype) || datatype.startsWith("TIMESTAMP") || datatype.indexOf("LOB") > -1;
    }

    public void copyDepenDendentColumnDescriptors(Column column, boolean copyID, Map copyMap) {
        List<DependentColumnDescriptor> list = column.getDependentColumnDescriptors();
        list.clear();
        for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
            ModelIDObject obj;
            DependentColumnDescriptor temp = column.createDependentColumnDescriptor();
            desc.copy(temp);
            if (copyMap != null && (obj = (ModelIDObject)copyMap.get(desc.getColumnID())) != null) {
                temp.setColumnID(obj.getObjectID());
            }
            if (copyID) {
                temp.setID(desc.getID());
            }
            list.add(temp);
        }
    }

    public DependentColumnDescriptor createDependentColumnDescriptor() {
        return new DependentColumnDescriptor(this);
    }

    public DependentColumnDescriptor getDependentColumnDescriptorByID(String id) {
        if (id != null) {
            for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
                if (!id.equals(desc.getID())) continue;
                return desc;
            }
        }
        return null;
    }

    public void applyDependentColumnDescriptors(List list) {
        this.getDependentColumnDescriptors().clear();
        for (Object obj : list) {
            if (!(obj instanceof DependentColumnDescriptor)) continue;
            this.addDependentColumnDescriptor((DependentColumnDescriptor)obj);
        }
    }

    public List<DependentColumnDescriptor> getDependentColumnDescriptors() {
        if (this.dependentColumns == null) {
            this.dependentColumns = new ArrayList<DependentColumnDescriptor>();
        }
        return this.dependentColumns;
    }

    public List<DependentColumnDescriptor> getDependentColumnDescriptors(String discriminatorValue) {
        ArrayList<DependentColumnDescriptor> list = new ArrayList<DependentColumnDescriptor>();
        if (discriminatorValue != null) {
            for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
                if (!discriminatorValue.equals(desc.getDiscriminatorValue())) continue;
                list.add(desc);
            }
        }
        return list;
    }

    public Map getDependentColumnDescriptorsMap(String discriminatorValue) {
        HashMap<String, DependentColumnDescriptor> map = new HashMap<String, DependentColumnDescriptor>();
        if (discriminatorValue != null) {
            for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
                if (!discriminatorValue.equals(desc.getDiscriminatorValue())) continue;
                map.put(desc.getColumnID(), desc);
            }
        }
        return map;
    }

    public static DependentColumnDescriptor getDependentColumnDescriptor(List<DependentColumnDescriptor> list, String dependentColumnID) {
        for (DependentColumnDescriptor desc : list) {
            if (!desc.getColumnID().equals(dependentColumnID)) continue;
            return desc;
        }
        return null;
    }

    public DependentColumnDescriptor getDependentColumnDescriptor(String discriminatorValue, String dependentColumnID) {
        if (dependentColumnID != null && discriminatorValue != null) {
            for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
                if (!dependentColumnID.equals(desc.getColumnID()) || !discriminatorValue.equals(desc.getDiscriminatorValue())) continue;
                return desc;
            }
        }
        return null;
    }

    public void addDependentColumnDescriptor(DependentColumnDescriptor desc) {
        if (desc.getOwner() == this) {
            DependentColumnDescriptor temp = this.getDependentColumnDescriptor(desc.getDiscriminatorValue(), desc.getColumnID());
            if (temp == null) {
                this.getDependentColumnDescriptors().add(desc);
            } else {
                temp.setDependOnValue(desc.isDependOnValue());
                temp.setDependAsMandatory(desc.isDependAsMandatory());
            }
        }
    }

    public void validateDependentColumnsDescriptors() {
        List<DependentColumnDescriptor> list = this.getDependentColumnDescriptors();
        if (list.size() > 0) {
            Table table = this.getTable();
            Set values = this.getValues();
            ArrayList<DependentColumnDescriptor> copy = new ArrayList<DependentColumnDescriptor>(list);
            list.clear();
            for (DependentColumnDescriptor desc : copy) {
                if (!values.contains(desc.getDiscriminatorValue()) || !desc.isDependAsMandatory() && !desc.isDependOnValue()) continue;
                if (table != null) {
                    if (table.getElementByID(desc.getColumnID()) == null) continue;
                    list.add(desc);
                    continue;
                }
                list.add(desc);
            }
        }
    }

    public List<Column> getDependentColumnList() {
        this.validateDependentColumnsDescriptors();
        ArrayList<Column> list = new ArrayList<Column>();
        for (DependentColumnDescriptor desc : this.getDependentColumnDescriptors()) {
            Column col = desc.getColumn();
            if (col == null || list.contains(col)) continue;
            list.add(col);
        }
        return list;
    }

    @Override
    public ContainedObject getDelegateElement() {
        return this.getReferencedColumn();
    }

    public boolean isNotNullConstraintNameFixed() {
        return this.notNullConstraintNameFixed;
    }

    public void setNotNullConstraintNameFixed(boolean notNullConstraintNameFixed) {
        if (this.notNullConstraintNameFixed != notNullConstraintNameFixed) {
            this.notNullConstraintNameFixed = notNullConstraintNameFixed;
            this.setDirty(true);
        }
    }

    public boolean isCheckConstraintNameFixed() {
        return this.checkConstraintNameFixed;
    }

    public void setCheckConstraintNameFixed(boolean checkConstraintNameFixed) {
        if (this.checkConstraintNameFixed != checkConstraintNameFixed) {
            this.checkConstraintNameFixed = checkConstraintNameFixed;
            this.setDirty(true);
        }
    }

    public boolean isDefaultOnNull() {
        return this.defaultOntNull;
    }

    public void setDefaultOnNull(boolean defaultOntNull) {
        this.defaultOntNull = defaultOntNull;
    }

    public String getIdentityGeneration() {
        if (this.isAutoIncrementGenerateAlways()) {
            return IDENTITY_GENERATION_ALWAYS;
        }
        return IDENTITY_GENERATION_BY_DEFAULT;
    }

    public void setIdentityGeneration(String identityGeneration) {
        if (this.isIdentityColumn()) {
            if (IDENTITY_GENERATION_ALWAYS.equalsIgnoreCase(identityGeneration)) {
                this.setAutoIncrementGenerateAlways(true);
            } else {
                this.setAutoIncrementGenerateAlways(false);
            }
        }
    }

    public static class DependentColumnDescriptor {
        Column owner;
        Column column;
        String columnID;
        String id;
        String discriminatorValue;
        boolean dependAsMandatory = false;
        boolean dependOnValue = false;

        private DependentColumnDescriptor(Column owner) {
            this.owner = owner;
        }

        public Column getColumn() {
            if ((this.column == null || this.column.isRemoved()) && this.columnID != null) {
                Table table = this.owner.getTable();
                this.column = table != null ? (Column)table.getElementByID(this.getColumnID()) : (Column)this.owner.getDesign().getDesignObject(this.columnID);
            }
            return this.column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }

        public String getColumnID() {
            return this.columnID;
        }

        public void setColumnID(String columnID) {
            this.columnID = columnID;
        }

        public String getDiscriminatorValue() {
            return this.discriminatorValue;
        }

        public void setDiscriminatorValue(String discriminatorValue) {
            this.discriminatorValue = discriminatorValue;
        }

        public boolean isDependAsMandatory() {
            return this.dependAsMandatory;
        }

        public void setDependAsMandatory(boolean dependAsMandatory) {
            this.dependAsMandatory = dependAsMandatory;
        }

        public Column getOwner() {
            return this.owner;
        }

        public boolean isDependOnValue() {
            return this.dependOnValue;
        }

        public void setDependOnValue(boolean dependOnValue) {
            this.dependOnValue = dependOnValue;
        }

        public String getID() {
            if (this.id == null) {
                this.id = new GUID().toString();
            }
            return this.id;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void copy(DependentColumnDescriptor desc) {
            desc.setColumnID(this.getColumnID());
            desc.setDiscriminatorValue(this.getDiscriminatorValue());
            desc.setDependOnValue(this.isDependOnValue());
            desc.setDependAsMandatory(this.isDependAsMandatory());
        }

        public void backupTo(DependentColumnDescriptor desc) {
            this.copy(desc);
            desc.setID(this.getID());
        }
    }

    public class DelegateHolder {
        public String fkid;
        public String delegateID;
    }
}

