/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class ColumnUsage
implements Comparable<ColumnUsage> {
    String EMPTY;
    private String schema;
    private String tableName;
    private String columnName;
    private String ownerTableID;
    private String columnID;
    int position;
    int groupID;
    protected Table ownerTable;
    private Column column;

    public ColumnUsage(Table ownerTable) {
        this.schema = this.EMPTY = "";
        this.tableName = this.EMPTY;
        this.columnName = this.EMPTY;
        this.ownerTableID = this.EMPTY;
        this.columnID = this.EMPTY;
        this.groupID = 1;
        this.ownerTable = ownerTable;
    }

    public String getSchema() {
        if (this.column != null) {
            return this.column.getTable().getSchema();
        }
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTableName() {
        if (this.column != null) {
            return this.column.getTable().getName();
        }
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getOwnerTableID() {
        return this.ownerTableID;
    }

    public void setOwnerTableID(String ownerTableID) {
        this.ownerTableID = ownerTableID;
    }

    public String getColumnID() {
        return this.columnID;
    }

    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public void setGroupID(int groupID) {
        this.groupID = groupID;
    }

    public Table getOwnerTable() {
        return this.ownerTable;
    }

    public SchemaObject getOwnerTableSchema() {
        if (this.getOwnerTable() == null) {
            return null;
        }
        return this.getOwnerTable().getSchemaObject();
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    @Override
    public int compareTo(ColumnUsage ac) {
        return this.getTableLongName().compareTo(ac.getTableLongName());
    }

    public String getLongName() {
        if (this.column != null) {
            return this.column.getVeryLongName();
        }
        String ln = "";
        if (this.schema != null && !this.schema.isEmpty()) {
            ln = this.schema + ".";
        }
        if (this.tableName != null && !this.tableName.isEmpty()) {
            ln = ln + this.tableName + ".";
        }
        if (this.columnName != null && !this.columnName.isEmpty()) {
            ln = ln + this.columnName;
        }
        return ln;
    }

    public String getTableLongName() {
        if (this.column != null) {
            return this.column.getTable().getLongName();
        }
        String ln = "";
        if (this.schema != null && !this.schema.isEmpty()) {
            ln = this.schema + ".";
        }
        if (this.tableName != null && !this.tableName.isEmpty()) {
            ln = ln + this.tableName;
        }
        return ln;
    }
}

