/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.List;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.AbstractDenormalizer;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;

public class DenormalizerSplitTable
extends AbstractDenormalizer {
    public void setOriginalTable(Table table) {
        this.setBaseTable(table);
    }

    public void setSplitTable(Table table) {
        this.setDerivedTable(table);
    }

    public List getPossibleSplits() {
        return this.getBaseTable().getPossibleSplits();
    }

    public Table getOriginalTable() {
        return this.getBaseTable();
    }

    public Table getSplitTable() {
        return this.getDerivedTable();
    }

    public void makeSplitTable(String newTableName) {
        if (this.canSplit()) {
            Table split = this.getTableSet().createTable(null);
            split.setName(newTableName);
            split.setGeneratorID(this.getOriginalTable().getGeneratorID());
            split.setSplittedTableID(this.getOriginalTable().getObjectID());
            split.setSchemaObject(this.getOriginalTable().getSchemaObject());
            this.setSplitTable(split);
            this.copyPK();
        }
    }

    public boolean canSplit() {
        return this.getOriginalTable() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPK() {
        Index pk = (Index)this.getOriginalTable().getPK();
        if (pk != null && !this.getSplitTable().hasFKAssociationFor(pk)) {
            DesignPart designPart = this.getSplitTable().getDesignPart();
            boolean prop = this.getSplitTable().getDesign().isPropagatePKChahges();
            FKIndexAssociation fkAssociation = null;
            try {
                this.getSplitTable().getDesign().setPropagatePKChahges(true);
                fkAssociation = this.getSplitTable().addFK(pk);
            }
            finally {
                this.getSplitTable().getDesign().setPropagatePKChahges(prop);
            }
            KeyObject fkIndex = fkAssociation.getLocalFKIndex();
            Index newPK = this.getSplitTable().createIndex();
            for (Column col : fkIndex.getElementsCollection()) {
                if (col.getDelegate() != null) {
                    col.setName(col.getDelegate().getName());
                }
                newPK.getElementsCollection().add(col);
            }
            fkAssociation.setShouldEngineer(false);
            newPK.makePK();
            newPK.setOidKey(pk.isOidKey());
            newPK.setName(ApplyNamingStandards.createPK_Name(this.getSplitTable().getName(), designPart.getDesign().getDesignLevelSettings().getNamingStandardRule(), designPart.getName(), null));
            fkAssociation.resetEdgeParams();
        }
    }

    @Override
    public TableSet getTableSet() {
        return ((RelationalDesign)this.getOriginalTable().getDesignPart()).getTableSet();
    }
}

